#ifndef HTTPCONNECTION_CPP
#define HTTPCONNECTION_CPP

#include "connection.h"

/*Original idea to program it from:
http://cvs.sourceforge.net/viewcvs.py/kmess/kmess/kmess/network/extra/httpsoapconnection.cpp?rev=1.1&view=auto
 */

HTTPConnection::HTTPConnection(Main *m) {
	http = new QHttp(HOST, 80);
	/*connect(http,SIGNAL(requestFinished(int,bool)),
			this, SLOT(slotRequestFinished(int,bool)));
	*/
	connect(http,SIGNAL(requestFinished(int,bool)),
			m,SLOT(canviarActiu(int,bool)));
}

int HTTPConnection::sendNewWord(const QString &paraula, const QString &user,
				const QString &email, int idioma_actiu) {
	QString idioma;
	QString *content;

	if (idioma_actiu==1) {
		idioma="catal";
	}
	else {
		idioma="english";
	}

	content=new QString("name="+user+"&version="+VERSION+"&word="+paraula+"&email="+email+"&language="+idioma+"&type=new");
	
	send_post(*content);

	return 0;
}

int HTTPConnection::sendSuggestion(const QString &paraula,const QString &translation, const QString &examples, const QString &notes, const QString &user, const QString &email, int idioma_actiu) {
	QString idioma;
	QString *content;
	
        if (idioma_actiu==1) {
                idioma="catal";
        }
        else {
                idioma="english";
        }

	content=new QString("name="+user+"&version="+VERSION+"&word="+paraula+"&email="+email+"&language="+idioma+"&translation="+translation+"&examples="+examples+"&notes="+notes+"&type=suggestion");
	
	send_post(*content);
	
	return 0;
}


int HTTPConnection::send_post(const QString &q) {
	QCString content; 
	content = q.utf8();

	QHttpRequestHeader header("POST", URL);

	//header.setContentType("text/xml; charset=\"utf-8\"");
	header.setContentType("application/x-www-form-urlencoded");
	header.setContentLength(content.length());
	header.setValue("Host",HOST);

	http->request(header,content);

	return 0;
}

void HTTPConnection::slotHeaderReceived(const QHttpResponseHeader &header) {
	//printf("Rebut a slotHeaderReceived: %s\n",(const char*)header.reasonPhrase());
}

void HTTPConnection::slotRequestFinished(int id, bool error) {
	/*
	if (http->error() == QHttp::NoError) {
		printf("Entrada enviada correctament\n");
	}
	else {
		printf("Problema enviant l'entrada: %s\n",(const char*)http->errorString());
	}*/
}


QString* HTTPConnection::getStateError() {
	QString *ret;
	
	if (http->error() == QHttp::NoError) {
		ret=new QString("");
	}
	else {
		ret=new QString(http->errorString());
	}
	return ret;
}
#endif
