#include <qapplication.h>
#include <qtranslator.h>
#include <qsettings.h>
#include <qtextcodec.h> 
#include <qlocale.h>
#include <qstring.h>
#include "ppal.h"
#include "auxiliar.h"
#include "qm_files.h"

/*	Carles Pina i Estany <carles@pinux.info> 2005, 2006
	GPL Licensed
*/

QString PATH;
QString VERSION="0.4";
QString TRADUCCIONS="/usr/share/dacco-common/dictionaries";

int main( int argc, char ** argv )
{
	QApplication a( argc, argv );
	int pdebug=0;

	//Language l;

	QSettings qs;
	int idioma_actiu;

	if (a.argc()>1 && strcmp(a.argv()[1],"-d")==0) {
		printf("Debug activat\n");
		pdebug=1;
	}

	if (a.argc()>1 && strcmp(a.argv()[1],"-d")!=0) {
		printf("qDacco use:\n");
		printf("qdacco -d: to enable debug mode\n");
		printf("Just qdacco to just use QDacco\n");
		exit(1);
	}

	printf("qDacco %s\n",(const char*)VERSION);
	printf("Carles Pina i Estany, 2005, 2006\n");
	printf("Program: GPL licensed. Data: LGPL licensed\n");

	QTranslator translator;

	qs.setPath( "Dacco", "QDacco" );
	idioma_actiu = qs.readNumEntry("/dacco/idioma_per_defecte",10);

	if (pdebug) printf("IDIOMA ACTIU: %d\n",idioma_actiu);

	if (idioma_actiu==10) {
		//No hi ha idioma actiu, consultem les locale
		//l=QLocale::language();
		QString s=QTextCodec::locale();
		
		s=s.left(s.find('_'));

		if (s=="ca") {
			idioma_actiu=0;
			if (pdebug) printf("Catal\n");
		}
		else {
			idioma_actiu=1;
			if (pdebug) printf("Angls\n");
		}

		QSettings settings;
		settings.setPath( "Dacco", "QDacco" );
		settings.writeEntry("/Dacco/idioma_per_defecte",idioma_actiu);

	}

	if (idioma_actiu==0) {
		translator.load(qdacco_ca_qm_data,qdacco_ca_qm_len);
		
		//http://doc.trolltech.com/qq/qq08-swedish-chef-sequel.html	
		
		/*if (!translator.load( "qdacco_ca", a.applicationDirPath())) {
			translator.load( TRADUCCIONS+"qdacco_ca", a.applicationDirPath());
		}*/

		a.installTranslator( &translator );
		if (pdebug) printf("ARA en catal\n");
	}


	#ifdef Q_OS_WIN32
	if (pdebug) printf("Windows version\n");
		QFont f("Microsoft Sans Serif",10);
		f.setStyleHint(QFont::SansSerif);

		a.setFont(f);
	#endif

	#ifdef Q_OS_LINUX
	if (pdebug) printf("Linux version\n");
	//QFont f("Helvetica");
	//a.setFont(f);
	#endif

	PATH=a.applicationDirPath();

	Main w;
	w.setPdebug(pdebug);
	w.show();

	a.connect( &a, SIGNAL( lastWindowClosed() ), &a, SLOT( quit() ) );
	return a.exec();
}
