/*
 * qdacco: offline Dacco Catalan <-> English dictionary
 * Copyright (C) 2005-2006 Carles Pina i estany <carles@pina.cat>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 or any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
*/


#include "main.h"

Main::Main(QWidget *parent)
{
        ui.setupUi(this);

	showList=0;
	numberFound=0;

	cat_eng = new QToolButton;
	cat_eng->setText(tr("cat->eng"));
	cat_eng->setCheckable(1);
	ui.toolBar->addWidget(cat_eng);

	eng_cat = new QToolButton;
	eng_cat->setText(tr("eng->cat"));
	eng_cat->setCheckable(1);
	ui.toolBar->addWidget(eng_cat);

	ui.toolBar->addSeparator();

	ui.definicio->setProcess(&process);
	ui.definicio->setSignalSlot(this);

	QAction *copy = ui.toolBar->addAction(QIcon(":icons/editcopy.png"),tr("Copy"));
	QAction *paste = ui.toolBar->addAction(QIcon(":icons/editpaste.png"),tr("Paste"));
	QAction *list = ui.toolBar->addAction(QIcon(":icons/find.png"),tr("Display closest matches"));
	connect(copy,SIGNAL(triggered()),this,SLOT(copy_definition()));
	connect(paste,SIGNAL(triggered()),this,SLOT(paste_word()));
	
	connect(list,SIGNAL(triggered()),this,SLOT(doList()));

        connect(ui.Buscar,SIGNAL(clicked()),this,SLOT(buscar()));
        connect(ui.editConfigureAction,SIGNAL(activated()),this,SLOT(obrir_configuracio()));
	connect(cat_eng,SIGNAL(clicked()),this,SLOT(cat_engf()));
	connect(eng_cat,SIGNAL(clicked()),this,SLOT(eng_catf()));
	
	connect(ui.fileChangeDictionaryAction,SIGNAL(activated()),this,SLOT(switchDictionary()));
	connect(ui.paraula,SIGNAL(returnPressed()),this,SLOT(buscar()));
	connect(ui.helpAboutAction,SIGNAL(activated()),this,SLOT(obrir_about()));

	connect(ui.report,SIGNAL(clicked()),this,SLOT(obrir_suggeriment()));
	connect(ui.llistat,SIGNAL(itemDoubleClicked(QListWidgetItem *)),this,SLOT(searchListWord(QListWidgetItem*)));
	
	carrega_config(1);

	ui.clipboard->hide();
}

void Main::buscar() {
	treballaBuscar();
}

void Main::treballaBuscar() {
        StructureParser handler;
       
       	QString buscar = ui.paraula->text();
	//QString buscar = paraula->text();
        QString buscar_orig = ui.paraula->text();
        char lletra;

        QString idioma;

	//posa_idioma();
        posarApunt(0);

        //per preparar el path
        if (idioma_actiu==1) {
                idioma="cateng";
        }
        else {
                idioma="engcat";
        }

        if (!isValidWord(buscar)) {
                ui.actiu->setText(tr("<CENTER><FONT COLOR='red'>You have to write a word. The word has to start with a letter.</FONT></CENTER>"));
                ui.actiu->show();
                ui.definicio->setPlainText(""); //not valid input
        }
        else {  //TODO: clean this crazy if-else!

        ui.paraula->setText(buscar);
        lletra=lletra_buscar(buscar);
        QFile xmlFile(directori_usuari+"/"+idioma+"/"+lletra+".dic");
	

        if (!xmlFile.exists()) {
                ui.actiu->setText(tr("<CENTER><FONT COLOR='red'>Cannot open dictionary file. Check configuration directory and permissions</FONT></CENTER>"));
                ui.actiu->show();
        }
        else{
		Auxiliar::debug("Fitxer: "+directori_usuari+"/"+idioma+"/"+lletra+".dic");

                QXmlInputSource source( &xmlFile );
                QXmlSimpleReader reader;
                reader.setFeature("http://trolltech.com/xml/features/report-whitespace-only-CharData",FALSE);   //if we don't use it, we get more entries because spaces...
                reader.setContentHandler( &handler );

                //printf("ACTUAR SOBRE: %s\n",(const char*)buscar_orig);
                //printf("Buscar arrels:");
                //arrels_cat(buscar);

                handler.setParaula(buscar_orig);

                reader.parse(source);

                WordData d=handler.getWordData();

                ui.definicio->setPlainText("");

                if (showList==0) {
                        ui.definicio->show();
                        ui.llistat->hide();
                        //buscar == 0: we show what we have found
                        for (int i=0;i<d.getNum();i++) {
                                ui.definicio->setHtml(ui.definicio->toHtml()+d.getEntry(i)+"<P>");
				/*if (i+1<d.getNum()) {
                                	ui.definicio->setHtml(ui.definicio->toHtml()+"TTTT<BR>");
				}*/
                        }
                }
                if (d.getNum()==0 || showList==1) {
                        //No word found or buscar == 1: we show the list
                        //definicio->setText(tr("<FONT COLOR='red'>Word not found</FONT>"));
                        ui.definicio->setPlainText("");
                        ui.definicio->hide();
                        ui.llistat->show();
                        loadList(&handler);
                        searched=buscar_orig;
                        selectItem();
                        if (d.getNum()==0) {
                                ui.actiu->setText(tr("<CENTER><FONT COLOR=\"red\">Exact match not found</FONT></CENTER>"));
                                ui.actiu->show();
                                //report->setText(tr("Report \""+buscar+"\" as new word"));
                                ui.report->setText(tr("Report as new entry"));
                                ui.report->show();
                        }
                }
                if (d.getNum()>0 && showList==0) {
                        ui.report->setText(tr("Send comment(s)"));
                        ui.report->show();
                }
                ui.paraula->selectAll();
                numberFound=d.getNum();
        }
        }
}

void Main::posarApunt (int all) {
        ui.llistat->clear();
        ui.llistat->hide();
        ui.definicio->show();

        if (all) {
                ui.paraula->setText("");
        }
        ui.definicio->setPlainText("");

        ui.actiu->hide();
        ui.actiu->setText("");
        ui.report->hide();
        ui.paraula->selectAll();
        ui.paraula->setFocus();
}

int Main::isValidWord(QString &q) {
        QChar first;
        //We transform the word to not-capital
        //We check that first letter is a letter
        //We delete space before word

        q=q.toLower();
        q=q.trimmed();


        Auxiliar::debug("isValidWord: _"+q+"_");
        first=q.at(0);
        return (first.isLetter() && q.length()>0);
}

char Main::lletra_buscar(QString q) {
        QChar a;

        if (q.at(0)=='' || q.at(0)=='' || q.at(0)=='' || q.at(0)=='') return 'a';
        if (q.at(0)=='' || q.at(0)=='' || q.at(0)=='' || q.at(0)=='') return 'e';
        if (q.at(0)==''  || q.at(0)=='' || q.at(0)=='' || q.at(0)=='') return 'i';
        if (q.at(0)=='' || q.at(0)=='' || q.at(0)=='' || q.at(0)=='') return 'o';
        if (q.at(0)=='' || q.at(0)=='' || q.at(0)=='' || q.at(0)=='') return 'u';

        if (q.at(0)=='') return 'c';

        a=q.at(0);

        return (a.toAscii());
}

void Main::loadList(StructureParser *handler) {
        while (!handler->esBuida()) {
                ui.llistat->insertItem(0,handler->seguent());
		//potser millor fer servir llistat->addItem(handler.seguent());
                //printf("Paraula22: %s\n",(const char*)handler.seguent());
        }
}

void Main::selectItem()
{
        int i;
        int surt=0;
	QListWidgetItem *item;

        for (i=0;i<(int)ui.llistat->count() && !surt;i++) {
		item = ui.llistat->item(i);

		if (item->text().compare(searched)==0) {
			ui.llistat->setItemSelected(item,TRUE);

		}
        }
}

void Main::obrir_configuracio()
{
        Configure *c = new Configure;
	c->carregar_config();
	c->exec();

	delete c;
	
        carrega_config(0);
}


void Main::obrir_about()
{
        About *a = new About;
	a->exec();

	delete a;
}

void Main::carrega_config(int all)
{
        QSettings qs("dacco","qdacco");
	QString browser;
        int xsize,ysize,xpos,ypos;
        QString version;

        //qs.setPath(QSettings::NativeFormat,QSettings::UserScope,"qdacco" );
        //directori_usuari = qs.readEntry( "/dacco/directori", "" );
	directori_usuari = qs.value("/dacco/directori","").toString();

        //configurat = qs.readNumEntry("/dacco/configurat",0);
	version = qs.value("/dacco/version","0").toString();

        if (version!="0.5") {
                //We will open the same settings file with read and then write mode
                //be careful!
                QMessageBox::information( this, "qdacco",tr("There is no configuration or old configuration. A configuration dialog will now open"));
                obrir_configuracio();
                carrega_config(1); //correct but little recursive rare call
        }
        else {
                idioma_actiu = qs.value("/dacco/diccionari_per_defecte",1).toInt();
		browser = qs.value("/dacco/browser","").toString();
		ui.definicio->setBrowser(browser);

                Auxiliar::debug("Load config");
                Auxiliar::debug("Directory: "+directori_usuari);
                //Auxiliar::debug("Idioma actiu: "+idioma);
                
		posa_idioma();

                if (all==1) {
                        xpos = qs.value("/dacco/xpos",0).toInt();
                        ypos = qs.value("/dacco/ypos",0).toInt();
                        xsize = qs.value("/dacco/xsize",234).toInt();
                        ysize = qs.value("/dacco/ysize",355).toInt();

                        //this->move(xpos,ypos);
			//TODO: qt4

                        //resize( QSize(xsize, ysize).expandedTo(minimumSizeHint()) );
                        resize(QSize(xsize,ysize));
                }
        }
}

void Main::cat_engf()
{
        idioma_actiu=1;
        posa_idioma();
}


void Main::eng_catf()
{
        idioma_actiu=2;
        posa_idioma();
}


void Main::posa_idioma() {
        posarApunt(0);

        if (idioma_actiu==1) {
                //idioma="cateng";
                //actiu->setText(tr("Catalan -> English"));
                cat_eng->setChecked(TRUE);
                eng_cat->setChecked(FALSE);
        }
        else {
                //idioma="engcat";
                //actiu->setText(tr("English -> Catalan"));
		eng_cat->setChecked(TRUE);
                cat_eng->setChecked(FALSE);
        }
}

void Main::switchDictionary() {
        if (idioma_actiu==1) {
                idioma_actiu=2;
        }
        else {
                idioma_actiu=1;
        }
        posa_idioma();
        posarApunt(0);
}

void Main::doList() {
	QString word = ui.paraula->text();

        if (!isValidWord(word)) {
                ui.actiu->setText(tr("<CENTER><FONT COLOR='red'>You have to write a word. The word has to start with a letter.</FONT></CENTER>"));
                ui.actiu->show();
                ui.definicio->setPlainText(""); //not valid input
        }
	else {
		showList=1;
		treballaBuscar();
		showList=0;
	}
}

void Main::copy_definition() {
	QClipboard *clip = QApplication::clipboard();
	
	clip ->setText("PROVA DE PORTAPAPERS\n");

	ui.clipboard->setHtml(ui.paraula->text()+"<P>"+ui.definicio->toHtml());
	ui.clipboard->selectAll();
	ui.clipboard->copy();
}


void Main::paste_word() {
	QClipboard *clip = QApplication::clipboard();

	QString text = clip->text();

	ui.paraula->setText(text);
	treballaBuscar();
}


void Main::obrir_suggeriment()
{
	QSettings qs("dacco","qdacco");

	QString name,email;
	QString userWord,userTranslations,userExamples,userNotes;
	int okay;

	name = qs.value("/dacco/name","").toString();
	email = qs.value("/dacco/email","").toString();

	http = new HTTPConnection(this);

	if (numberFound==0) {
		http->sendNewWord(searched,name,email,idioma_actiu);
		ui.actiu->setText(tr("<CENTER>Sending...</CENTER>"));
		ui.actiu->show();
		ui.report->hide();
	}
	else {
        	Suggeriment *s = new Suggeriment;
		s->setWord(ui.paraula->text());
		s->exec();

		s->getOkay(okay);

		if (okay==1) {
                        s->getUserWord(userWord);
                        s->getUserTranslations(userTranslations);
                        s->getUserExamples(userExamples);
                        s->getUserNotes(userNotes);

                        if (userTranslations.length()==0 &&
                                userExamples.length()==0 &&
                                userNotes.length()==0) {
                                ui.actiu->setText(tr("<CENTER><FONT COLOR=\"red\">You must type something</FONT></CENTER>"));
                                ui.actiu->show();
                        }
                        else {
                                http->sendSuggestion(userWord,userTranslations,userExamples,userNotes,name,email,idioma_actiu);

                                ui.actiu->setText(tr("<CENTER>Sending...</CENTER>"));
                                ui.actiu->show();
                                ui.report->hide();
				ui.paraula->setFocus(Qt::OtherFocusReason);
                        }
                }
                else {
                        ui.actiu->setText(tr("<CENTER>Action cancelled</CENTER>"));
                        ui.actiu->show();
			ui.paraula->setFocus(Qt::OtherFocusReason);
                }
	}
}
/*	qs.readEntry

        Suggeriment *s = new Suggeriment;
	s->setWord(ui.paraula->text());
	s->exec();

	delete s;*/

void Main::changeActive(int a,bool b)
{
        if ((*http->getStateError()).compare("")==0) {
                ui.actiu->setText(tr("<CENTER>Correctly sent!</CENTER>"));
        }
        else {
                ui.actiu->setText(tr("<CENTER><FONT COLOR=\"red\">Problem sending:</FONT> ")+*http->getStateError()+"</FONT></CENTER>");
        }
        ui.actiu->show();

        delete http;
}

void Main::searchListWord(QListWidgetItem *a)
{
	ui.paraula->setText(a->text());
	treballaBuscar();
}

void Main::openBrowser(const QUrl &url) {
	printf("URL document: %s\n",qPrintable(url.toString()));

}
/*
void Main::setSource(const QUrl &name) {
	printf("Setsource called\n");
}
*/

void Main::browser (QProcess::ProcessError error) {
	ui.actiu->setText(tr("<CENTER><FONT COLOR=\"red\">Error executing browser. Check your configuration</FONT></CENTER>"));
	ui.actiu->show();
}
