/*
 * qdacco: offline Dacco Catalan <-> English dictionary
 * Copyright (C) 2005-2006 Carles Pina i estany <carles@pina.cat>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 or any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
*/

#ifndef TEXTBROWSER_H
#define TEXTBROWSER_H
#include <QTextBrowser>
#include <QProcess>

class TextBrowser : public QTextBrowser
{
	private:
		QProcess *p;
		QString browser;

		QMainWindow *m;

	public:
		TextBrowser(QWidget *&a) {};

		void setSignalSlot(QMainWindow *m_) {
			m=m_;

			connect(p,SIGNAL(error(QProcess::ProcessError)),
				m,SLOT(browser(QProcess::ProcessError)));
		}

		void setProcess(QProcess *p_) {
			p=p_;
		}
		void setBrowser(QString browser_) {
			browser=browser_;
		}
	
		virtual void setSource(const QUrl& url) {
			QString cmd = browser + " " + url.toString();
			p->start(cmd);
			printf("Executing: %s\n",qPrintable(cmd));
		}

	signals:
		void browserFailed();
		void browserOpened();
};
/*
TextBrowser::TextBrowser(QWidget *&a) {
	//super.TextBrowser(a);
}

void TextBrowser::setSource(const QUrl &url) {
	printf("overriding method!");
}
*/

#endif
