/***************************************************************************
                          qgsvectorlayer.h  -  description
                             -------------------
    begin                : Oct 29, 2003
    copyright            : (C) 2003 by Gary E.Sherman
    email                : sherman at mrcc.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* $Id: qgsvectorlayer.h,v 1.19 2004/03/31 22:39:06 mcoletti Exp $ */

#ifndef QGSVECTORLAYER_H
#define QGSVECTORLAYER_H
class QPainter;
class QgsRect;
class QLibrary;
class QgsCoordinateTransform;
class OGRLayer;
class OGRDataSource;
class QgsDataProvider;
class QgsRenderer;
class QgsLegendItem;
class QgsDlgVectorLayerProperties;
class QgisApp;
class QgsIdentifyResults;

#include <map>

#include "qgsmaplayer.h"
#include "qvaluevector.h"
#include "qgsattributetabledisplay.h"


/*! \class QgsVectorLayer
 * \brief Vector layer backed by a data source provider
 */

class QgsVectorLayer:public QgsMapLayer
{
    Q_OBJECT;

 public:

  //! Constructor
    QgsVectorLayer(QString baseName = 0, QString path = 0, QString providerLib = 0);
  //! Destructor
   ~QgsVectorLayer();
  //! Identify feature found within the search rectangle
  void identify(QgsRect *);
  //! Select features found within the search rectangle
  void select(QgsRect * rect, bool lock);
  //! Display the attribute table
  void table();
  //! Set the primary display field to be used in the identify results dialog 
  void setDisplayField();
  //! Initialize the context menu
  void initContextMenu(QgisApp * app);
  enum SHAPETYPE
  {
    Point,
    Line,
    Polygon
  };
  void setDataProvider(QgsDataProvider * dp);
  QgsDataProvider *getDataProvider();
  public slots:
   /**Sets the 'tabledisplay' to 0 again*/
  void invalidateTableDisplay();
  void select(int number);
  void removeSelection();
  void triggerRepaint();
  /**Shows the properties dialog*/
  virtual void showLayerProperties();
  /**Returns a pointer to the renderer*/
  QgsRenderer *renderer();
  /**Returns a pointer to the renderer dialog*/
  QDialog *rendererDialog();
  /**Sets the renderer. If a renderer is already present, it is deleted*/
  void setRenderer(QgsRenderer * r);
  /**Sets the renderer dialog. If a renderer dialog is already present, it is deleted*/
  void setRendererDialog(QDialog * dialog);
  /**Sets m_propertiesDialog*/
  void setLayerProperties(QgsDlgVectorLayerProperties * properties);
  /**Returns point, line or polygon*/
    QGis::VectorType vectorType();
  /**Returns a pointer to the properties dialog*/
  QgsDlgVectorLayerProperties *propertiesDialog();
  /** Return the context menu for the layer */
  QPopupMenu *contextMenu();
    /**Returns the bounding box of the selected features. If there is no selection, the lower bounds are DBL_MAX and the upper bounds -DBL_MAX*/
  virtual QgsRect bBoxOfSelected();
  //! Return the provider type for this layer
  QString providerType();
  //! Return the validity of the layer
  inline bool isValid()
  {
    return valid;
  }


  /** 
  * Get the first feature resulting from a select operation
  * @return QgsFeature
  */
  virtual QgsFeature * getFirstFeature(bool fetchAttributes=false) const;

  /** 
  * Get the next feature resulting from a select operation
  * @return QgsFeature
  */
  virtual QgsFeature * getNextFeature(bool fetchAttributes=false) const;

  /**
   * Get the next feature using new method
   * TODO - make this pure virtual once it works and change existing providers
   *        to use this method of fetching features
   */
  virtual bool getNextFeature(QgsFeature &feature, bool fetchAttributes=false) const;

  /**
   * Number of features in the layer
   * @return long containing number of features
   */
  virtual long featureCount() const;
  
  /**
   * Number of attribute fields for a feature in the layer
   */
  virtual int fieldCount() const;


  /**
    Return a list of field names for this layer
   @return vector of field names
  */
  virtual std::vector<QgsField> const & fields() const;


protected:
  /**Pointer to the table display object if there is one, else a pointer to 0*/
    QgsAttributeTableDisplay * tabledisplay;
  /**Vector holding the information which features are activated*/
  std::map < int, bool > selected;
  /**Color to draw and fill the selected features*/
  QColor selectionColor;
  /**Renderer object which holds the information about how to display the features*/
  QgsRenderer *m_renderer;
  /**Dialog to set the properties*/
  QgsDlgVectorLayerProperties *m_propertiesDialog;
  /**Widget to set the symbology properties*/
  QDialog *m_rendererDialog;


private:                       // Private attributes
//! Draws the layer using coordinate transformation
  void draw(QPainter * p, QgsRect * viewExtent, QgsCoordinateTransform * cXf, QPaintDevice * src, QPaintDevice * dst);
  //! Pointer to data provider derived from the abastract base class QgsDataProvider
  QgsDataProvider *dataProvider;
  //! index of the primary label field
  QString fieldIndex;
  //! Data provider key
  QString providerKey;
  //! Flag to indicate if this is a valid layer
  bool valid;
  bool registered;

  enum ENDIAN
  {
    NDR = 1,
    XDR = 0
  };
  enum WKBTYPE
  {
    WKBPoint = 1,
    WKBLineString,
    WKBPolygon,
    WKBMultiPoint,
    WKBMultiLineString,
    WKBMultiPolygon
  };
private:                       // Private methods
  int endian();
  // pointer for loading the provider library
  QLibrary *myLib;
  //! Pointer to the identify results dialog
  QgsIdentifyResults *ir;

};

#endif
