/***************************************************************************
      qgsproviderextentcalcevent.h  -  Notification that the exact extent
                                       of a layer has been calculated.
                             -------------------
    begin                : Feb 1, 2005
    copyright            : (C) 2005 by Brendan Morley
    email                : morb at ozemail dot com dot au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* $Id: qgsproviderextentcalcevent.h 4502 2006-01-08 01:18:20Z timlinux $ */

#ifndef QGSPROVIDEREXTENTCALCEVENT_H
#define QGSPROVIDEREXTENTCALCEVENT_H

#include <qevent.h>

#include "qgis.h"
#include "qgsrect.h"
//Added by qt3to4:
#include <QCustomEvent>

/*!
 * \brief   A custom event that is designed to be fired when a layer extent has been fully calculated.
   \author  Brendan Morley
   \date    March 2005

   
   This QCustomEvent is designed to be fired when the full extent of a layer has been calculated.
   It was initially included in QGIS to help the QgsPostgresProvider provide the asynchronous
   calculation of PostgreSQL layer extents.
   
   Events are used instead of Qt signals/slots as events can be received asynchronously,
   which makes for better mutlithreading behaviour and less opportunity for programmer mishap.
  
 */ 

// TODO: Add the pg table this is a extent OF.

class QgsProviderExtentCalcEvent : public QCustomEvent
{

public:

  QgsProviderExtentCalcEvent( QgsRect* layerExtent );

  QgsRect* layerExtent() const;

  
private:

  QgsRect* le;
    
};

#endif
