/***************************************************************************
                         qgsmarkerdialog.cpp  -  description
                             -------------------
    begin                : March 2004
    copyright            : (C) 2004 by Marco Hugentobler
    email                : mhugent@geo.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* $Id: qgsmarkerdialog.cpp 5539 2006-06-23 11:46:19Z timlinux $ */

#include "qgsmarkerdialog.h"
#include "qgsapplication.h"

#include <QDir>
#include <QFileDialog>
#include <Q3IconView>
#include <QPixmap>
#include <QPainter>

#include "qgsconfig.h"
#include <qgsmarkercatalogue.h>

QgsMarkerDialog::QgsMarkerDialog(QString startdir): 
  //paramters removed by Tim during qt4 ui port - FIXME!!!
  //QgsMarkerDialogBase(0,0,true,Qt::WStyle_StaysOnTop), mCurrentDir(startdir)
  QgsMarkerDialogBase(), mCurrentDir(startdir)
{
  setupUi(this);
    QObject::connect(mOkButton,SIGNAL(clicked()),this,SLOT(accept()));
    QObject::connect(mCancelButton,SIGNAL(clicked()),this,SLOT(reject()));
    QObject::connect(mBrowseDirectoriesButton,SIGNAL(clicked()),this,SLOT(changeDirectory()));
    QObject::connect(mIconView,SIGNAL(currentChanged(Q3IconViewItem*)),this,SLOT(updateSelectedMarker()));
    mDirectoryEdit->setText(startdir);
    visualizeMarkers(startdir);
}

QgsMarkerDialog::~QgsMarkerDialog()
{

}

void QgsMarkerDialog::updateSelectedMarker()
{
    Q3IconViewItem* current=mIconView->currentItem();
    if(current)
    {
	mSelectedMarker=current->text();
    }
    else
    {
	mSelectedMarker="";
    }
}

QString QgsMarkerDialog::selectedMarker()
{
    return mCurrentDir+"/"+mSelectedMarker;
}

void QgsMarkerDialog::changeDirectory()
{
    QString newdir = QFileDialog::getExistingDirectory(
        this, "Choose a directory", mCurrentDir);
    if (!newdir.isEmpty())
    {
	mCurrentDir=newdir;
	visualizeMarkers(mCurrentDir);
	mDirectoryEdit->setText(mCurrentDir);
    }
}

void QgsMarkerDialog::visualizeMarkers(QString directory)
{
    mIconView->clear();

    QDir dir(directory);
    QStringList files=dir.entryList("*.svg;*.SVG");
    
    for(QStringList::Iterator it = files.begin(); it != files.end(); ++it )
    {
	qWarning((*it).toLocal8Bit().data());
	
	//render the SVG file to a pixmap and put it into mIconView
	QPixmap pix (10,10);
  QPainter myPainter(&pix);
  QgsMarkerCatalogue::svgMarker(&myPainter,mCurrentDir + "/" + (*it), 1);
	Q3IconViewItem* ivi=new Q3IconViewItem(mIconView,*it,pix);
	
    }
}

QString QgsMarkerDialog::defaultDir()
{
#ifdef WIN32
	//TODO fix this to use appropriate path on windows 
	//qgis install
	QString dir = "Foo";
#else
    QString dir = QgsApplication::svgPath(); 
#endif
    return dir;
}

