/***************************************************************************
                         qgsattributedialog.cpp  -  description
                             -------------------
    begin                : October 2004
    copyright            : (C) 2004 by Marco Hugentobler
    email                : marco.hugentobler@autoform.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qgsattributedialog.h"

#include "qgsattributeform.h"
#include "qgshighlight.h"
#include "qgsapplication.h"
#include "qgsactionmenu.h"

#include <QSettings>


QgsAttributeDialog::QgsAttributeDialog( QgsVectorLayer* vl, QgsFeature* thepFeature, bool featureOwner, const QgsDistanceArea &myDa, QWidget* parent, bool showDialogButtons )
    : QDialog( parent )
    , mHighlight( nullptr )
    , mOwnedFeature( featureOwner ? thepFeature : nullptr )
{
  QgsAttributeEditorContext context;
  context.setDistanceArea( myDa );

  init( vl, thepFeature, context );

  if ( !showDialogButtons )
    mAttributeForm->hideButtonBox();
}

QgsAttributeDialog::QgsAttributeDialog( QgsVectorLayer* vl, QgsFeature* thepFeature, bool featureOwner, QWidget* parent, bool showDialogButtons, const QgsAttributeEditorContext &context )
    : QDialog( parent )
    , mHighlight( nullptr )
    , mOwnedFeature( featureOwner ? thepFeature : nullptr )
{
  init( vl, thepFeature, context );

  if ( !showDialogButtons )
    mAttributeForm->hideButtonBox();
}

QgsAttributeDialog::~QgsAttributeDialog()
{
  if ( mHighlight )
  {
    mHighlight->hide();
    delete mHighlight;
  }

  if ( mOwnedFeature )
    delete mOwnedFeature;

  saveGeometry();
}

void QgsAttributeDialog::saveGeometry()
{
  QSettings().setValue( mSettingsPath + "geometry", QDialog::saveGeometry() );
}

void QgsAttributeDialog::restoreGeometry()
{
  QDialog::restoreGeometry( QSettings().value( mSettingsPath + "geometry" ).toByteArray() );
}

void QgsAttributeDialog::setHighlight( QgsHighlight* h )
{
  delete mHighlight;

  mHighlight = h;
}

void QgsAttributeDialog::accept()
{
  mAttributeForm->save();
  QDialog::accept();
}

void QgsAttributeDialog::show()
{
  QDialog::show();
  raise();
  activateWindow();
}

void QgsAttributeDialog::init( QgsVectorLayer* layer, QgsFeature* feature, const QgsAttributeEditorContext &context )
{
  setWindowTitle( tr( "%1 - Feature Attributes" ).arg( layer->name() ) );
  setLayout( new QGridLayout() );
  layout()->setMargin( 0 );
  mAttributeForm = new QgsAttributeForm( layer, *feature, context, this );
  mAttributeForm->disconnectButtonBox();
  layout()->addWidget( mAttributeForm );
  QDialogButtonBox* buttonBox = mAttributeForm->findChild<QDialogButtonBox*>();
  connect( buttonBox, SIGNAL( rejected() ), this, SLOT( reject() ) );
  connect( buttonBox, SIGNAL( accepted() ), this, SLOT( accept() ) );
  connect( layer, SIGNAL( layerDeleted() ), this, SLOT( close() ) );

  QgsActionMenu* menu = new QgsActionMenu( layer, &mAttributeForm->feature(), this );
  if ( !menu->actions().isEmpty() )
  {
    QMenuBar* menuBar = new QMenuBar( this );
    menuBar->addMenu( menu );
    layout()->setMenuBar( menuBar );
  }
  else
  {
    delete menu;
  }

  restoreGeometry();
  focusNextChild();
}

bool QgsAttributeDialog::event( QEvent* e )
{
  if ( e->type() == QEvent::WindowActivate && mHighlight )
    mHighlight->show();
  else if ( e->type() == QEvent::WindowDeactivate && mHighlight )
    mHighlight->hide();

  return QDialog::event( e );
}
