/***************************************************************************
                          qgsrasterfilewritertask.cpp
                          ---------------------------
    begin                : Apr 2017
    copyright            : (C) 2017 by Nyall Dawson
    email                : nyall dot dawson at gmail dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qgsrasterfilewritertask.h"
#include "qgsrasterinterface.h"

QgsRasterFileWriterTask::QgsRasterFileWriterTask( const QgsRasterFileWriter &writer, QgsRasterPipe *pipe,
    int columns, int rows,
    const QgsRectangle &outputExtent,
    const QgsCoordinateReferenceSystem &crs )
  : QgsTask( tr( "Saving %1" ).arg( writer.outputUrl() ), QgsTask::CanCancel )
  , mWriter( writer )
  , mRows( rows )
  , mColumns( columns )
  , mExtent( outputExtent )
  , mCrs( crs )
  , mPipe( pipe )
  , mFeedback( new QgsRasterBlockFeedback() )
{}

void QgsRasterFileWriterTask::cancel()
{
  mFeedback->cancel();
  QgsTask::cancel();
}

bool QgsRasterFileWriterTask::run()
{
  if ( !mPipe )
    return false;

  connect( mFeedback.get(), &QgsRasterBlockFeedback::progressChanged, this, &QgsRasterFileWriterTask::setProgress );

  mError = mWriter.writeRaster( mPipe.get(), mColumns, mRows, mExtent, mCrs, mFeedback.get() );

  return mError == QgsRasterFileWriter::NoError;
}

void QgsRasterFileWriterTask::finished( bool result )
{
  if ( result )
    emit writeComplete( mWriter.outputUrl() );
  else
    emit errorOccurred( mError );
}


