/*
 * CLightSourceEditorRenderer.h
 * $Id: CLightSourceEditorRenderer.h,v 1.2 2001/11/15 16:54:51 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich, Michael Meissner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : 
//                


#ifndef CRENDERER__H
#define CRENDERER__H
    
    
// Own
////////
#include "QGLExaminerViewer.h"
#include "QLightSourceEditorImpl.h"

// Qt
///////
#include <qmainwindow.h>
#include <qslider.h>
#include <qgl.h>


// System
///////////
#include <math.h>




/** documentation stuff

  @author Michael Meissner
  
  @version 0.0 //see cvs docu
    
*/
    
class CLightSourceEditorRenderer : public QObject {
  Q_OBJECT

  //****** All methods ******

public:
  CLightSourceEditorRenderer(QGLViewer*, QLightSourceEditorImpl *);

  ~CLightSourceEditorRenderer();

  QGLViewer* getViewer(void) { return m_pViewer; };

  void MakeGlList();


  
private:
  /** Method processes the hits using GL selection mode. */
  GLuint processHits(GLint hits, GLuint buffer[]);


  // **** All the slots *****
private slots:

  /** Overloads the slot for GL initialization. */
  void sltInitializeGL();

  /** Overloads the slot for GL resize. */
  void sltResizeGL(int w, int h);

  /** Overloads the slot for GL paint. */
  void sltPaintGL();

  /** Manages the select events in selection mode. */
  void sltManageSelection(QMouseEvent *pqEvent);

  /** Manages the release events in selection mode. */
  void sltManageRelease(QMouseEvent *pqEvent);

  /** Manages the move events in selection mode. */
  void sltManageMove(QMouseEvent *pqEvent);

  /** Slot to reset selection for example after
      the render mode has changed. */
  void sltResetSelection();


private:

  /** Renders this nice sphere scene. */
  void renderScene(void);

  /** Renders a solid sphere at the given location with given radius. */
  void renderSolidSphere(const CP3D &cCenter, float radius,
                         int n1, int n2, float lw=2.5);

  /** Renders a wire sphere at the given location with given radius. */
  void renderWireSphere(const CP3D &cCenter, float radius,
                        int n1, int n2, float lw=2.5);

  //****** All data ******

  QGLViewer *m_pViewer;
  QLightSourceEditorImpl *m_pLightSourceEditor;
  
  GLuint m_glDispList;

  bool m_afSelected[12];               // select state of the spheres

  bool m_fLeftButtonPressed;           // saves left button state
  bool m_fMiddleButtonPressed;         // saves middle button state
  bool m_fRightButtonPressed;          // saves right button state

  CP3D m_cSphereCenter[12];            // saves centers of the spheres

  int m_nMousePosX, m_nMousePosY;      // last mouse position
};

#endif // CRENDERER__H 
