//////////////////////////////////////////////////////////////////////////
//
//  Filename    : QMyListBox.h
//  Class       : QMyListBox
//
//  Author(s)   : Markus Janich
//
//  Description : Class QMyListBox
//  Purpose     : Adds edit mode to the standard QListBox of Qt
//
//  Date        : March 2001
//
//  Updates     :    who    | date   | what
//                ----------+--------+-------------------------------------
//                          |        |
//
////////////////////////////////////////////////////////////////////////////



#ifndef QMYLISTBOX_H
#define QMYLISTBOX_H


// Qt
///////
#include <qlistbox.h>


// Forward declarations
////////////////////////
class QLineEdit;



/** This class expands the original QListBox class 
  * with the possibility the change the strings
  * in the list box by double clicking on the items.
  * 
  * @author Markus Janich
  */
class QMyListBox : public QListBox {
  Q_OBJECT 

public:
  QMyListBox(QWidget *parent=0, const char *name=0, WFlags f=0);

  /** Makes the items editable if 'fOnOff' is true. */
  void enableEditMode(bool fOnOff = true);


signals:
  /** This signal is return when you press the
    * return or enter key after editing. */
  void sigReturnPressed(int);

protected slots:

  /** This slot manages the mouse clicks on the
    * passed item 'pqItem'. */
  void sltCatchPressed(QListBoxItem *pqItem);
  /** This slot pops up an edit field over the
    * passed item 'pqItem'. */
  void sltEditItem(QListBoxItem *pqItem);
  /** This slot changes the last edited item. */
  void sltChangeItem();

protected:
  /** Reimplementation of inherited method for
    * internal things. */
  void resizeEvent(QResizeEvent *pqEvent);

private:

  bool m_firstMousePress;
  bool m_fEditable;
  QListBoxItem *m_pqItem;
  QLineEdit *m_pqEditField;
  int m_nItemIndex;
};

#endif  // QMYLISTBOX_H
