/***************************************************************************
 *   Copyright (C) 2007 by Κωνσταντίνος Σμάνης   *
 *   kon.smanis@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation                                              *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301 USA                                             *
 ***************************************************************************/

#include "backuprestore.h"

BackupRestore::BackupRestore( int indicator, QWidget* parent ) : QDialog( parent )
{
	file = new FileTransactions();

	setupUi( this );
	QObject::connect( pushButton_browse_source, SIGNAL( pressed() ), this, SLOT( browse_source() ) );
	QObject::connect( pushButton_browse_target, SIGNAL( pressed() ), this, SLOT( browse_target() ) );
	QObject::connect( pushButton_OK, SIGNAL( pressed() ), this, SLOT( OK() ) );
	QObject::connect( pushButton_cancel, SIGNAL( pressed() ), this, SLOT( close() ) );

	mode = indicator;

	lineEdit_source->setText( ( indicator == 0 ? Config::settings.menulst : Config::settings.menulst + "_backup" ) );
	lineEdit_target->setText( ( indicator == 0 ? Config::settings.menulst + "_backup" : Config::settings.menulst ) );
}
BackupRestore::~BackupRestore()
{
	delete file;
}
void BackupRestore::browse_source()
{
	QString file = QFileDialog::getOpenFileName( this, tr( "Select the source GRUB menu file" ), lineEdit_source->text(), tr( "GRUB menu file (*.*)" ) );
	if ( !file.isEmpty() )
	{
		lineEdit_source->setText( file );
	}
}
void BackupRestore::browse_target()
{
	QString file = QFileDialog::getOpenFileName( this, tr( "Select the target GRUB menu file" ), lineEdit_target->text(), tr( "GRUB menu file (*.*)" ) );
	if ( !file.isEmpty() )
	{
		lineEdit_target->setText( file );
	}
}
void BackupRestore::OK()
{
	if ( !lineEdit_source->text().isEmpty() && !lineEdit_target->text().isEmpty() )
	{
		( mode == 0 ? file->backup( lineEdit_source->text(), lineEdit_target->text() ) : file->restore( lineEdit_source->text(), lineEdit_target->text() ) );
		close();
	}
	else
	{
		QMessageBox::warning( this, tr( "Warning!" ), tr( "You have to fill in all fields!" ), QMessageBox::Ok );
	}
}
