/***************************************************************************
 *   Copyright (C) 2007 by Κωνσταντίνος Σμάνης   *
 *   kon.smanis@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation                                              *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301 USA                                             *
 ***************************************************************************/

#ifndef FILETRANSACTIONS_H
#define FILETRANSACTIONS_H

#include <QVector>
#include <QString>
#include <QStringList>
#include <QFile>
#include <QTextStream>
#include <QRegExp>
#include <QFileInfo>
#include <QMessageBox>
#include <QProcess>
#include <QByteArray>

#include "data.h"

class FileTransactions
{
public:
//FUNCTIONS
	static bool definePermissions( const QString menulst, const QString devicemap, const QString mtab );

	void menuInput( const QString path, GRUBSettings *settings, QVector<GRUBItem> *items );
	void menuOutput( const QString path, const GRUBSettings *settings, const QVector<GRUBItem> *items );

	void mtabInput( const QString path, QVector<Device> *devices );
	void deviceInput( const QString path, QVector<Device> *devices );

	static QString view( const QString path );

	void backup( const QString source, const QString target );
	void backup_original( const QString source );
	void restore( const QString source, const QString target );
	void deleteBackup( const QString backup );

	void addEntry( const QString path, const GRUBItem grubitem, const GRUBSettings *settings, QVector<GRUBItem> *items );
	void editEntry( const QString path, const int index, const GRUBItem grubitem, const GRUBSettings *settings, QVector<GRUBItem> *items );
	void copyEntry( const QString path, const int index, const GRUBSettings *settings, QVector<GRUBItem> *items );
	void removeEntry( const QString path, const int index, const GRUBSettings *settings, QVector<GRUBItem> *items );

	void move( const QString path, const int source, const int target, const GRUBSettings *settings, QVector<GRUBItem> *items );
};

#endif
