/*
 * Decompiled with CFR 0.152.
 */
package driftwood.isosurface;

import driftwood.isosurface.CrystalVertexSource;
import driftwood.isosurface.VertexEvaluator;
import driftwood.isosurface.VertexLocator;

public class LowResolutionVertexSource
implements VertexEvaluator,
VertexLocator {
    final CrystalVertexSource map;
    final int divisor;
    final double[] cell = new double[3];

    public LowResolutionVertexSource(CrystalVertexSource crystalVertexSource, int n) {
        this.map = crystalVertexSource;
        this.divisor = n;
    }

    public double evaluateVertex(int n, int n2, int n3) {
        return this.map.evaluateVertex(n * this.divisor, n2 * this.divisor, n3 * this.divisor);
    }

    public void locateVertex(int n, int n2, int n3, double[] dArray) {
        this.map.locateVertex(n * this.divisor, n2 * this.divisor, n3 * this.divisor, dArray);
    }

    public void findVertexForPoint(double d, double d2, double d3, int[] nArray) {
        this.map.findVertexForPoint(d, d2, d3, this.cell);
        nArray[0] = (int)Math.round(this.cell[0] / (double)this.divisor);
        nArray[1] = (int)Math.round(this.cell[1] / (double)this.divisor);
        nArray[2] = (int)Math.round(this.cell[2] / (double)this.divisor);
    }
}

