/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2.selection;

import driftwood.moldb2.AtomState;
import driftwood.moldb2.Selection;
import driftwood.r3.SpatialBin;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;

public class WithinSelectionTerm
extends Selection {
    private static final DecimalFormat df = new DecimalFormat("0.####");
    double distance;
    Selection childTerm;
    SpatialBin spatialBin;
    Collection foundPts;

    public WithinSelectionTerm(double d, Selection selection) {
        this.distance = d;
        this.childTerm = selection;
        this.foundPts = new ArrayList();
    }

    public void init(Collection collection) {
        super.init(collection);
        this.childTerm.init(collection);
        this.spatialBin = new SpatialBin(3.0);
        this.spatialBin.addAll(this.childTerm.selectAtomStates(collection));
    }

    protected boolean selectImpl(AtomState atomState) {
        this.foundPts.clear();
        this.spatialBin.findSphere(atomState, this.distance, this.foundPts);
        return !this.foundPts.isEmpty();
    }

    public String toString() {
        return "within " + df.format(this.distance) + " of (" + this.childTerm + ")";
    }
}

