/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.FatJList;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane2;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import king.KingMain;
import king.core.KIterator;
import king.core.KList;
import king.core.KView;
import king.core.Kinemage;

public class AxisChooser {
    KingMain kMain;
    Kinemage kin;
    int kinDimension;
    Collection dimNames;
    JList xAxisList;
    JList yAxisList;
    JList zAxisList;

    public AxisChooser(KingMain kingMain, Kinemage kinemage) {
        this.kMain = kingMain;
        this.kin = kinemage;
        this.kinDimension = AxisChooser.getKinDimension(kinemage);
        this.dimNames = new ArrayList<String>(kinemage.dimensionNames);
        for (int i = this.dimNames.size(); i < this.kinDimension; ++i) {
            this.dimNames.add("Axis " + (i + 1));
        }
        this.buildGUI();
    }

    private void buildGUI() {
        int[] nArray = new int[]{0, 1, 2};
        KView kView = this.kMain.getCanvas().getCurrentView(this.kin);
        if (kView.getViewingAxes() != null) {
            nArray = kView.getViewingAxes();
        }
        this.xAxisList = new FatJList(0, 10);
        this.xAxisList.setVisibleRowCount(10);
        this.xAxisList.setListData(this.dimNames.toArray());
        this.xAxisList.setSelectedIndex(Math.min(nArray[0], this.dimNames.size() - 1));
        this.yAxisList = new FatJList(0, 10);
        this.yAxisList.setVisibleRowCount(10);
        this.yAxisList.setListData(this.dimNames.toArray());
        this.yAxisList.setSelectedIndex(Math.min(nArray[1], this.dimNames.size() - 1));
        this.zAxisList = new FatJList(0, 10);
        this.zAxisList.setVisibleRowCount(10);
        this.zAxisList.setListData(this.dimNames.toArray());
        this.zAxisList.setSelectedIndex(Math.min(nArray[2], this.dimNames.size() - 1));
        JButton jButton = new JButton(new ReflectiveAction("Set axes", null, this, "onSetAxes"));
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.insets(10).memorize();
        tablePane2.add(new JLabel("X axis"));
        tablePane2.add(new JLabel("Y axis"));
        tablePane2.add(new JLabel("Z axis"));
        tablePane2.newRow();
        tablePane2.add(new JScrollPane(this.xAxisList));
        tablePane2.add(new JScrollPane(this.yAxisList));
        tablePane2.add(new JScrollPane(this.zAxisList));
        tablePane2.newRow();
        tablePane2.startSubtable(3, 1).center().addCell(jButton).endSubtable();
        JDialog jDialog = new JDialog(this.kMain.getTopWindow(), "Choose axes", false);
        jDialog.setDefaultCloseOperation(2);
        jDialog.setContentPane(tablePane2);
        jDialog.pack();
        jDialog.show();
    }

    public void onSetAxes(ActionEvent actionEvent) {
        int n = Math.max(0, this.xAxisList.getSelectedIndex());
        int n2 = Math.max(1, this.yAxisList.getSelectedIndex());
        int n3 = Math.max(2, this.zAxisList.getSelectedIndex());
        KView kView = this.kMain.getView();
        if (kView == null) {
            return;
        }
        kView.setViewingAxes(new int[]{n, n2, n3});
        kView.activateViewingAxes();
    }

    public static int getKinDimension(Kinemage kinemage) {
        int n = 0;
        for (KList kList : KIterator.allLists(kinemage)) {
            n = Math.max(n, kList.getDimension());
        }
        return n;
    }
}

