/*
 * Decompiled with CFR 0.152.
 */
package king;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import king.core.AGE;
import king.core.KList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinTreeModel
implements TreeModel {
    protected AGE root;
    protected Collection<TreeModelListener> tmls = new ArrayList<TreeModelListener>();

    public KinTreeModel(AGE aGE) {
        this.root = aGE;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.tmls.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.tmls.remove(treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        for (TreeModelListener treeModelListener : this.tmls) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    public void kinChanged(boolean bl) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.getRoot()});
        for (TreeModelListener treeModelListener : this.tmls) {
            if (bl) {
                treeModelListener.treeStructureChanged(treeModelEvent);
                continue;
            }
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return object instanceof KList || ((AGE)object).getChildren().size() == 0;
    }

    @Override
    public int getChildCount(Object object) {
        if (object instanceof KList) {
            return 0;
        }
        return ((AGE)object).getChildren().size();
    }

    @Override
    public Object getChild(Object object, int n) {
        if (this.isLeaf(object)) {
            return null;
        }
        ArrayList arrayList = ((AGE)object).getChildren();
        if (0 <= n && n < arrayList.size()) {
            return arrayList.get(n);
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null || this.isLeaf(object)) {
            return -1;
        }
        return ((AGE)object).getChildren().indexOf(object2);
    }

    public static Collection<TreePath> memorizeVisibility(JTree jTree) {
        return KinTreeModel.memorizeVisibility(jTree, new TreePath(jTree.getModel().getRoot()), null);
    }

    public static Collection<TreePath> memorizeVisibility(JTree jTree, TreePath treePath, Collection<TreePath> collection) {
        Object object;
        TreeModel treeModel;
        if (collection == null) {
            collection = new HashSet<TreePath>();
        }
        if (jTree.isVisible(treePath)) {
            collection.add(treePath);
        }
        if (!(treeModel = jTree.getModel()).isLeaf(object = treePath.getLastPathComponent())) {
            int n = treeModel.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                KinTreeModel.memorizeVisibility(jTree, treePath.pathByAddingChild(treeModel.getChild(object, i)), collection);
            }
        }
        return collection;
    }

    public static void restoreVisibility(JTree jTree, Collection<TreePath> collection) {
        for (TreePath treePath : collection) {
            jTree.makeVisible(treePath);
        }
    }
}

