/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.util.Props;
import driftwood.util.ReflectiveRunnable;
import driftwood.util.SoftLog;
import driftwood.util.Strings;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class KingPrefs
extends Props {
    static final String PROPS_HEADER = "#\n# This file contains your customized settings for running KiNG.\n# Place this in your home directory, or in an applet's\n# <PARAM name='king_prefs' value='url/path/to/king.prefs'> tag.\n# KiNG must be restarted for changes to take effect.\n#\n# For more information on all the possible properties that can be set,\n# including some which cannot be accessed from the GUI,\n# see the sample .king_prefs in the doc/ folder of your KiNG distribution.\n#";
    volatile boolean newerVersionAvail = false;
    volatile URL remoteVersionURL = null;
    public File jarFileDirectory;
    public Image windowIcon;
    public Icon stepBackIcon;
    public Icon stepForwardIcon;
    public Icon moveUpIcon;
    public Icon moveDownIcon;
    public Icon addIcon;
    public Icon cutIcon;
    public Icon copyIcon;
    public Icon pasteIcon;
    public Icon deleteIcon;
    public Icon helpIcon;
    public Icon htmlBackIcon;
    public Icon htmlHomeIcon;
    public Icon treeOnIcon;
    public Icon treeOffIcon;
    public Icon rotXpIcon;
    public Icon rotXmIcon;
    public Icon rotYpIcon;
    public Icon rotYmIcon;
    public Icon rotZpIcon;
    public Icon rotZmIcon;

    public KingPrefs(boolean bl) {
        if (!bl) {
            this.jarFileDirectory = this.locateJarFile();
        }
        Props props = new Props();
        this.loadFromJar(props);
        this.setDefaults(props);
        this.loadFromFile();
        this.windowIcon = new ImageIcon(this.getClass().getResource("images/kingicon20.png")).getImage();
        this.stepBackIcon = new ImageIcon(this.getClass().getResource("images/StepBack16.gif"));
        this.stepForwardIcon = new ImageIcon(this.getClass().getResource("images/StepForward16.gif"));
        this.moveUpIcon = new ImageIcon(this.getClass().getResource("images/Up16.gif"));
        this.moveDownIcon = new ImageIcon(this.getClass().getResource("images/Down16.gif"));
        this.addIcon = new ImageIcon(this.getClass().getResource("images/Add16.gif"));
        this.cutIcon = new ImageIcon(this.getClass().getResource("images/Cut16.gif"));
        this.copyIcon = new ImageIcon(this.getClass().getResource("images/Copy16.gif"));
        this.pasteIcon = new ImageIcon(this.getClass().getResource("images/Paste16.gif"));
        this.deleteIcon = new ImageIcon(this.getClass().getResource("images/Delete16.gif"));
        this.helpIcon = new ImageIcon(this.getClass().getResource("images/Help16.gif"));
        this.htmlBackIcon = new ImageIcon(this.getClass().getResource("images/Back24.gif"));
        this.htmlHomeIcon = new ImageIcon(this.getClass().getResource("images/Home24.gif"));
        this.treeOnIcon = new ImageIcon(this.getClass().getResource("images/tree-on.png"));
        this.treeOffIcon = new ImageIcon(this.getClass().getResource("images/tree-off.png"));
        this.rotXpIcon = new ImageIcon(this.getClass().getResource("images/rotxp.png"));
        this.rotXmIcon = new ImageIcon(this.getClass().getResource("images/rotxm.png"));
        this.rotYpIcon = new ImageIcon(this.getClass().getResource("images/rotyp.png"));
        this.rotYmIcon = new ImageIcon(this.getClass().getResource("images/rotym.png"));
        this.rotZpIcon = new ImageIcon(this.getClass().getResource("images/rotzp.png"));
        this.rotZmIcon = new ImageIcon(this.getClass().getResource("images/rotzm.png"));
    }

    File locateJarFile() {
        URL uRL = this.getClass().getResource("version.props");
        File file = null;
        try {
            file = Strings.jarUrlToFile(uRL);
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(SoftLog.err);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace(SoftLog.err);
        }
        return file;
    }

    boolean loadFromJar(Properties properties) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("king_prefs");
            properties.load(inputStream);
            inputStream.close();
            inputStream = this.getClass().getResourceAsStream("version.props");
            properties.load(inputStream);
            inputStream.close();
            inputStream = this.getClass().getResourceAsStream("buildnum.props");
            properties.load(inputStream);
            inputStream.close();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace(SoftLog.err);
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
            return false;
        }
        return true;
    }

    public boolean loadFromFile() {
        try {
            File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".king_prefs");
            if (file.exists()) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                this.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                SoftLog.err.println("Loaded preferences from " + file.toString());
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace(SoftLog.err);
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    public boolean loadFromURL(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            this.load(inputStream);
            inputStream.close();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace(SoftLog.err);
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
            return false;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace(SoftLog.err);
            return false;
        }
        return true;
    }

    public boolean storeToFile() {
        this.minimizeDifferences();
        try {
            File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".king_prefs");
            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
            printStream.println(PROPS_HEADER);
            this.store(printStream, "");
            printStream.close();
            SoftLog.err.println("Stored preferences to   " + file.toString());
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace(SoftLog.err);
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    public void checkVersion(URL uRL, long l) {
        this.remoteVersionURL = uRL;
        Thread thread = new Thread(new ReflectiveRunnable(this, "checkVersionBackground"));
        thread.start();
        try {
            thread.join(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void checkVersionBackground() {
        Object object;
        if (this.remoteVersionURL == null) {
            return;
        }
        Props props = new Props();
        try {
            object = this.remoteVersionURL.openStream();
            props.load((InputStream)object);
            ((InputStream)object).close();
        }
        catch (Exception exception) {
            SoftLog.err.println("Unable to check for new version: " + exception.getMessage());
            SoftLog.err.println("You can disable version checking under Edit | Configure.");
            return;
        }
        object = this.getString("version");
        String string = props.getString("version", null);
        if (string != null && Strings.compareVersions((String)object, string) < 0) {
            this.newerVersionAvail = true;
        }
    }

    public boolean newerVersionAvailable() {
        return this.newerVersionAvail;
    }
}

