/*
 * Decompiled with CFR 0.152.
 */
package king.core;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import king.core.AGE;
import king.core.AHE;
import king.core.AHEImpl;
import king.core.KGroup;
import king.core.KList;
import king.core.KPoint;
import king.core.Kinemage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KIterator<T extends AHE>
implements Iterable<T>,
Iterator<T> {
    Set<Opts> opts;
    T next;
    T last;
    Iterator<T> iter;
    Iterator<T> iterLast;
    LinkedList<Iterator<T>> iterStack;

    public KIterator(AGE aGE, Opts opts) {
        this(aGE, EnumSet.of(opts));
    }

    public KIterator(AGE aGE, Opts opts, Opts ... optsArray) {
        this(aGE, EnumSet.of(opts, optsArray));
    }

    public KIterator(AGE aGE, Set<Opts> set) {
        this.opts = set;
        this.next = null;
        this.last = null;
        this.iter = Collections.singleton(aGE).iterator();
        this.iterLast = null;
        this.iterStack = new LinkedList();
    }

    private void nextImpl() {
        this.last = null;
        while (true) {
            if (this.iter.hasNext()) {
                AHE aHE = (AHE)this.iter.next();
                this.iterLast = this.iter;
                if (aHE instanceof KPoint) {
                    if (!this.shouldVisit((KPoint)aHE)) continue;
                    this.next = aHE;
                    return;
                }
                if (!(aHE instanceof AGE)) continue;
                AGE aGE = (AGE)aHE;
                if (this.shouldVisitChildren(aGE)) {
                    this.iterStack.addLast(this.iter);
                    this.iter = aGE.getChildren().iterator();
                }
                if (!this.shouldVisit(aGE)) continue;
                this.next = aHE;
                return;
            }
            if (this.iterStack.isEmpty()) break;
            this.iter = this.iterStack.removeLast();
        }
        this.next = null;
    }

    protected boolean shouldVisit(KPoint kPoint) {
        return !(!kPoint.isOn() && this.opts.contains((Object)Opts.VISIBLE_ONLY) || kPoint.isUnpickable() && this.opts.contains((Object)Opts.PICKABLE_ONLY));
    }

    protected boolean shouldVisit(AGE aGE) {
        boolean bl;
        boolean bl2 = bl = aGE.isOn() || !this.opts.contains((Object)Opts.VISIBLE_ONLY);
        if (aGE instanceof KList) {
            bl &= this.opts.contains((Object)Opts.LIST);
        } else if (aGE instanceof KGroup) {
            bl &= this.opts.contains((Object)Opts.GROUP);
        } else if (aGE instanceof Kinemage) {
            bl &= this.opts.contains((Object)Opts.KINEMAGE);
        }
        return bl;
    }

    protected boolean shouldVisitChildren(AGE aGE) {
        boolean bl;
        boolean bl2 = bl = aGE.isOn() || !this.opts.contains((Object)Opts.VISIBLE_ONLY);
        if (aGE instanceof KList) {
            bl &= this.opts.contains((Object)Opts.POINT);
        } else if (aGE instanceof KGroup) {
            bl &= this.opts.contains((Object)Opts.GROUP) || this.opts.contains((Object)Opts.LIST) || this.opts.contains((Object)Opts.POINT);
        }
        return bl;
    }

    @Override
    public T next() {
        if (this.next == null) {
            this.nextImpl();
        }
        this.last = this.next;
        this.next = null;
        return this.last;
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.nextImpl();
        }
        return this.next != null;
    }

    @Override
    public void remove() {
        Object p;
        if (this.last != null) {
            p = this.last.getParent();
            this.iterLast.remove();
            if (this.iter != this.iterLast) {
                this.iter = this.iterStack.removeLast();
                assert (this.iter == this.iterLast);
            }
        } else {
            throw new IllegalStateException();
        }
        int n = this.last instanceof AGE ? 1 : 256;
        this.last = null;
        ((AHEImpl)p).fireKinChanged(n);
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public static KIterator<KList> allLists(AGE aGE) {
        return new KIterator<KList>(aGE, Opts.LIST);
    }

    public static KIterator<KPoint> allPoints(AGE aGE) {
        return new KIterator<KPoint>(aGE, Opts.POINT);
    }

    public static KIterator<AGE> allNonPoints(AGE aGE) {
        return new KIterator<AGE>(aGE, Opts.LIST, Opts.GROUP, Opts.KINEMAGE);
    }

    public static KIterator<KList> visibleLists(AGE aGE) {
        return new KIterator<KList>(aGE, Opts.LIST, Opts.VISIBLE_ONLY);
    }

    public static KIterator<KPoint> visiblePoints(AGE aGE) {
        return new KIterator<KPoint>(aGE, Opts.POINT, Opts.VISIBLE_ONLY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Opts {
        KINEMAGE,
        GROUP,
        LIST,
        POINT,
        VISIBLE_ONLY,
        PICKABLE_ONLY;

    }
}

