/*
 * Decompiled with CFR 0.152.
 */
package king.core;

import java.io.Serializable;
import king.core.KIterator;
import king.core.KList;
import king.core.KPoint;
import king.core.Kinemage;

public class KView
implements Serializable,
Cloneable {
    static final int N_UPDATES_ALLOWED = 100;
    protected transient Kinemage parent = null;
    protected String ID = "Unnamed view";
    public float[][] xform = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
    protected float[] center = null;
    protected float zoom = 0.0f;
    protected float span = 0.0f;
    protected float clip = 1.0f;
    public float R11 = 1.0f;
    public float R12 = 0.0f;
    public float R13 = 0.0f;
    public float R21 = 0.0f;
    public float R22 = 1.0f;
    public float R23 = 0.0f;
    public float R31 = 0.0f;
    public float R32 = 0.0f;
    public float R33 = 1.0f;
    public float cx = 0.0f;
    public float cy = 0.0f;
    public float cz = 0.0f;
    protected int[] viewingAxes = null;
    protected int nUpdates = 0;

    private KView() {
    }

    public KView(Kinemage kinemage) {
        this.parent = kinemage;
    }

    public synchronized KView clone() {
        try {
            KView kView = (KView)super.clone();
            kView.xform = (float[][])kView.xform.clone();
            if (kView.center != null) {
                kView.center = (float[])kView.center.clone();
            }
            kView.compile();
            return kView;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public String getName() {
        return this.ID;
    }

    public synchronized void setName(String string) {
        this.ID = string;
        if (this.parent != null) {
            this.parent.fireKinChanged(131072);
        }
    }

    public String toString() {
        return this.getName();
    }

    protected static float[][] mmult(float[][] fArray, float[][] fArray2) {
        float[][] fArray3 = new float[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                float f = 0.0f;
                for (int k = 0; k < 3; ++k) {
                    f += fArray[i][k] * fArray2[k][j];
                }
                fArray3[i][j] = f;
            }
        }
        return fArray3;
    }

    protected static float[] mmult(float[][] fArray, float[] fArray2) {
        float[] fArray3 = new float[3];
        for (int i = 0; i < 3; ++i) {
            float f = 0.0f;
            for (int j = 0; j < 3; ++j) {
                f += fArray[i][j] * fArray2[j];
            }
            fArray3[i] = f;
        }
        return fArray3;
    }

    protected static void normalize(float[][] fArray) {
        float f = (float)Math.sqrt(fArray[2][0] * fArray[2][0] + fArray[2][1] * fArray[2][1] + fArray[2][2] * fArray[2][2]);
        fArray[2][0] = fArray[2][0] / f;
        fArray[2][1] = fArray[2][1] / f;
        fArray[2][2] = fArray[2][2] / f;
        f = (float)Math.sqrt(fArray[1][0] * fArray[1][0] + fArray[1][1] * fArray[1][1] + fArray[1][2] * fArray[1][2]);
        fArray[1][0] = fArray[1][0] / f;
        fArray[1][1] = fArray[1][1] / f;
        fArray[1][2] = fArray[1][2] / f;
        fArray[0][0] = fArray[1][1] * fArray[2][2] - fArray[1][2] * fArray[2][1];
        fArray[0][1] = fArray[1][2] * fArray[2][0] - fArray[1][0] * fArray[2][2];
        fArray[0][2] = fArray[1][0] * fArray[2][1] - fArray[1][1] * fArray[2][0];
        fArray[1][0] = fArray[2][1] * fArray[0][2] - fArray[2][2] * fArray[0][1];
        fArray[1][1] = fArray[2][2] * fArray[0][0] - fArray[2][0] * fArray[0][2];
        fArray[1][2] = fArray[2][0] * fArray[0][1] - fArray[2][1] * fArray[0][0];
    }

    protected static float[][] transpose(float[][] fArray) {
        float[][] fArray2 = new float[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                fArray2[i][j] = fArray[j][i];
            }
        }
        return fArray2;
    }

    public synchronized void compile() {
        this.R11 = this.xform[0][0];
        this.R12 = this.xform[0][1];
        this.R13 = this.xform[0][2];
        this.R21 = this.xform[1][0];
        this.R22 = this.xform[1][1];
        this.R23 = this.xform[1][2];
        this.R31 = this.xform[2][0];
        this.R32 = this.xform[2][1];
        this.R33 = this.xform[2][2];
        if (this.center == null) {
            this.getCenter();
        }
        this.cx = this.center[0];
        this.cy = this.center[1];
        this.cz = this.center[2];
    }

    public synchronized void rotateX(float f) {
        float f2 = (float)Math.sin(f);
        float f3 = (float)Math.cos(f);
        float[][] fArrayArray = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, f3, -f2}, {0.0f, f2, f3}};
        this.xform = KView.mmult((float[][])fArrayArray, this.xform);
        if (++this.nUpdates % 100 == 0) {
            this.nUpdates = 0;
            KView.normalize(this.xform);
        }
        if (this.parent != null) {
            this.parent.fireKinChanged(65536);
        }
    }

    public synchronized void rotateY(float f) {
        float f2 = (float)Math.sin(f);
        float f3 = (float)Math.cos(f);
        float[][] fArrayArray = new float[][]{{f3, 0.0f, f2}, {0.0f, 1.0f, 0.0f}, {-f2, 0.0f, f3}};
        this.xform = KView.mmult((float[][])fArrayArray, this.xform);
        if (++this.nUpdates % 100 == 0) {
            this.nUpdates = 0;
            KView.normalize(this.xform);
        }
        if (this.parent != null) {
            this.parent.fireKinChanged(65536);
        }
    }

    public synchronized void rotateZ(float f) {
        float f2 = (float)Math.sin(f);
        float f3 = (float)Math.cos(f);
        float[][] fArrayArray = new float[][]{{f3, -f2, 0.0f}, {f2, f3, 0.0f}, {0.0f, 0.0f, 1.0f}};
        this.xform = KView.mmult((float[][])fArrayArray, this.xform);
        if (++this.nUpdates % 100 == 0) {
            this.nUpdates = 0;
            KView.normalize(this.xform);
        }
        if (this.parent != null) {
            this.parent.fireKinChanged(65536);
        }
    }

    public synchronized void setMatrix(float[][] fArray) {
        this.xform = (float[][])fArray.clone();
        if (this.parent != null) {
            this.parent.fireKinChanged(65536);
        }
    }

    public synchronized void setZoom(float f) {
        this.zoom = f;
        this.span = 0.0f;
        if (this.parent != null) {
            this.parent.fireKinChanged(65536);
        }
    }

    public synchronized float getSpan() {
        if (this.span <= 0.0f) {
            if (this.zoom <= 0.0f) {
                this.zoom = 1.0f;
            }
            this.span = this.parent.getSpan() / this.zoom;
        }
        return this.span;
    }

    public synchronized void setSpan(float f) {
        this.span = f;
        if (this.parent != null) {
            this.parent.fireKinChanged(65536);
        }
    }

    public float getClip() {
        return this.clip;
    }

    public synchronized void setClip(float f) {
        this.clip = f;
        if (this.parent != null) {
            this.parent.fireKinChanged(65536);
        }
    }

    public synchronized float[] getCenter() {
        if (this.center == null) {
            if (this.parent != null) {
                this.center = this.parent.getCenter();
            } else {
                float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
                this.center = fArray;
            }
        }
        return (float[])this.center.clone();
    }

    public synchronized void setCenter(float f, float f2, float f3) {
        if (this.center == null) {
            this.center = new float[3];
        }
        this.center[0] = f;
        this.center[1] = f2;
        this.center[2] = f3;
        if (this.parent != null) {
            this.parent.fireKinChanged(65536);
        }
    }

    public synchronized float[] translateRotated(int n, int n2, int n3, int n4) {
        float f = (float)n4 / this.getSpan();
        float f2 = (float)n / f;
        float f3 = (float)n2 / f;
        float f4 = (float)n3 / f;
        float[] fArray = new float[]{f2, f3, f4};
        float[] fArray2 = KView.mmult(KView.transpose(this.xform), fArray);
        return fArray2;
    }

    public synchronized void viewTranslateRotated(int n, int n2, int n3, int n4) {
        float[] fArray = this.translateRotated(n, n2, n3, n4);
        float[] fArray2 = this.getCenter();
        this.setCenter(fArray2[0] - fArray[0], fArray2[1] - fArray[1], fArray2[2] - fArray[2]);
    }

    public void setViewingAxes(int[] nArray) {
        this.viewingAxes = (int[])(nArray == null ? null : (int[])nArray.clone());
    }

    public int[] getViewingAxes() {
        return this.viewingAxes;
    }

    public void activateViewingAxes() {
        if (this.viewingAxes == null) {
            return;
        }
        int n = this.viewingAxes[0];
        int n2 = this.viewingAxes[1];
        int n3 = this.viewingAxes[2];
        for (KList kList : KIterator.allLists(this.parent)) {
            if (kList.getDimension() <= 3) continue;
            for (KPoint kPoint : kList) {
                kPoint.useCoordsXYZ(n, n2, n3);
            }
        }
        this.parent.fireKinChanged(4096);
    }
}

