/*
 * Decompiled with CFR 0.152.
 */
package king.painters;

import com.sun.opengl.util.GLUT;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;
import king.core.KPaint;
import king.core.KPalette;
import king.core.Painter;

public class JoglPainter
implements Painter {
    GL gl;
    GLU glu;
    GLUT glut;
    Rectangle clipRgn = new Rectangle();
    int currFont = 7;
    double[] xPoints = new double[6];
    double[] yPoints = new double[6];
    double[] circle4;
    double[] circle8;
    double[] circle16;
    double[] circle32;

    public JoglPainter(GLAutoDrawable gLAutoDrawable) {
        this.gl = gLAutoDrawable.getGL();
        this.glu = new GLU();
        this.glut = new GLUT();
        this.gl.glEnable(3042);
        this.gl.glBlendFunc(770, 771);
        this.circle4 = this.makeCircle(4);
        this.circle8 = this.makeCircle(8);
        this.circle16 = this.makeCircle(16);
        this.circle32 = this.makeCircle(32);
    }

    double[] makeCircle(int n) {
        double[] dArray = new double[2 * n];
        for (int i = 0; i < n; ++i) {
            double d = Math.PI * 2 * (double)i / (double)n;
            dArray[2 * i] = Math.cos(d) / 2.0;
            dArray[2 * i + 1] = Math.sin(d) / 2.0;
        }
        return dArray;
    }

    void fillOval(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d5 = d3 > d4 ? d3 : d4;
        double[] dArray = d5 <= 3.0 ? this.circle4 : (d5 <= 8.0 ? this.circle8 : (d5 <= 16.0 ? this.circle16 : this.circle32));
        double d7 = d + d3 / 2.0;
        double d8 = d2 + d4 / 2.0;
        this.gl.glBegin(9);
        for (int i = 0; i < dArray.length; i += 2) {
            this.gl.glVertex2d(d7 + d3 * dArray[i], -(d8 + d4 * dArray[i + 1]));
        }
        this.gl.glEnd();
    }

    void drawOval(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d5 = d3 > d4 ? d3 : d4;
        double[] dArray = d5 <= 3.0 ? this.circle4 : (d5 <= 8.0 ? this.circle8 : (d5 <= 16.0 ? this.circle16 : this.circle32));
        double d7 = d + d3 / 2.0;
        double d8 = d2 + d4 / 2.0;
        this.gl.glBegin(2);
        for (int i = 0; i < dArray.length; i += 2) {
            this.gl.glVertex2d(d7 + d3 * dArray[i], -(d8 + d4 * dArray[i + 1]));
        }
        this.gl.glEnd();
    }

    void drawLine(double d, double d2, double d3, double d4) {
        this.gl.glBegin(1);
        this.gl.glVertex2d(d, -d2);
        this.gl.glVertex2d(d3, -d4);
        this.gl.glEnd();
    }

    void fillRect(double d, double d2, double d3, double d4) {
        this.gl.glRectd(d, -d2, d + d3, -(d2 + d4));
    }

    void drawRect(double d, double d2, double d3, double d4) {
        this.gl.glBegin(2);
        this.gl.glVertex2d(d, -d2);
        this.gl.glVertex2d(d, -(d2 + d4));
        this.gl.glVertex2d(d + d3, -(d2 + d4));
        this.gl.glVertex2d(d + d3, -d2);
        this.gl.glEnd();
    }

    public void paintBall(Paint paint, double d, double d2, double d3, double d4, boolean bl) {
        double d5 = 2.0 * d4;
        if (d5 < 2.0) {
            d5 = 2.0;
        }
        this.setPaint(paint);
        this.fillOval(d - d4, d2 - d4, d5, d5);
        try {
            Color color = (Color)paint;
            if (d5 >= 10.0 && color.getAlpha() == 255) {
                this.setPaint(KPaint.black);
                this.drawOval(d - d4, d2 - d4, d5, d5);
            }
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            System.err.println("JoglPainter: tried painting with non-Color type of Paint");
        }
        if (bl) {
            double d6 = 0.5 * d4;
            d5 = (int)(0.3 * d4) + 1;
            this.setPaint(Color.white);
            this.fillOval(d - d6, d2 - d6, d5, d5);
        }
    }

    public void paintDot(Paint paint, double d, double d2, double d3, int n) {
        double d4 = n / 2;
        this.setPaint(paint);
        if (n == 1) {
            this.fillRect(d - d4, d2 - d4, n, n);
        } else {
            this.fillOval(d - d4, d2 - d4, ++n, n);
        }
    }

    public void paintLabel(Paint paint, String string, double d, double d2, double d3) {
        this.setPaint(paint);
        this.gl.glRasterPos2d(d, -d2);
        this.glut.glutBitmapString(this.currFont, string);
    }

    public void paintMarker(Paint paint, double d, double d2, double d3, int n, int n2) {
        double d4 = d;
        double d5 = d2;
        double d6 = n;
        double d7 = 2 * n;
        double d8 = 3 * n;
        double d9 = 4 * n;
        double d10 = 5 * n;
        double d11 = 6 * n;
        double d12 = 7 * n;
        double d13 = 10 * n;
        double d14 = 11 * n;
        this.setPaint(paint);
        if ((n2 & 0x4000) != 0) {
            this.fillRect(d4 - d10, d5 - d10, d14, d14);
        } else if ((n2 & 0x400000) != 0) {
            this.fillOval(d4 - d10, d5 - d10, d14, d14);
        }
        if ((n2 & 0x2000) != 0) {
            this.fillRect(d4 - d8, d5 - d8, d12, d12);
        } else if ((n2 & 0x200000) != 0) {
            this.fillOval(d4 - d8, d5 - d8, d12, d12);
        }
        if ((n2 & 0x1000) != 0) {
            this.fillRect(d4 - d6, d5 - d6, d8, d8);
        } else if ((n2 & 0x100000) != 0) {
            this.fillOval(d4 - d6, d5 - d6, d8, d8);
        }
        if ((n2 & 1) != 0) {
            this.drawLine(d4, d5 - d6, d4, d5 + d6);
            this.drawLine(d4 - d6, d5, d4 + d6, d5);
        }
        if ((n2 & 2) != 0) {
            this.drawLine(d4, d5 - d8, d4, d5 + d8);
            this.drawLine(d4 - d8, d5, d4 + d8, d5);
        }
        if ((n2 & 4) != 0) {
            this.drawLine(d4, d5 - d10, d4, d5 + d10);
            this.drawLine(d4 - d10, d5, d4 + d10, d5);
        }
        if ((n2 & 8) != 0) {
            this.drawLine(d4 - d6, d5 - d10, d4 - d6, d5 + d10);
            this.drawLine(d4 + d6, d5 - d10, d4 + d6, d5 + d10);
            this.drawLine(d4 - d10, d5 - d6, d4 + d10, d5 - d6);
            this.drawLine(d4 - d10, d5 + d6, d4 + d10, d5 + d6);
        }
        if ((n2 & 0x10) != 0) {
            this.drawLine(d4 - d6, d5 - d6, d4 + d6, d5 + d6);
            this.drawLine(d4 - d6, d5 + d6, d4 + d6, d5 - d6);
        }
        if ((n2 & 0x20) != 0) {
            this.drawLine(d4 - d8, d5 - d8, d4 + d8, d5 + d8);
            this.drawLine(d4 - d8, d5 + d8, d4 + d8, d5 - d8);
        }
        if ((n2 & 0x40) != 0) {
            this.drawLine(d4 - d10, d5 - d10, d4 + d10, d5 + d10);
            this.drawLine(d4 - d10, d5 + d10, d4 + d10, d5 - d10);
        }
        if ((n2 & 0x80) != 0) {
            this.drawLine(d4 - d9, d5 - d10, d4 + d10, d5 + d9);
            this.drawLine(d4 - d10, d5 - d9, d4 + d9, d5 + d10);
            this.drawLine(d4 - d9, d5 + d10, d4 + d10, d5 - d9);
            this.drawLine(d4 - d10, d5 + d9, d4 + d9, d5 - d10);
        }
        if ((n2 & 0x100) != 0) {
            this.drawRect(d4 - d6, d5 - d6, d7, d7);
        }
        if ((n2 & 0x200) != 0) {
            this.drawRect(d4 - d8, d5 - d8, d11, d11);
        }
        if ((n2 & 0x400) != 0) {
            this.drawRect(d4 - d10, d5 - d10, d13, d13);
        }
        if ((n2 & 0x10000) != 0) {
            this.drawOval(d4 - d6, d5 - d6, d7, d7);
        }
        if ((n2 & 0x20000) != 0) {
            this.drawOval(d4 - d8, d5 - d8, d11, d11);
        }
        if ((n2 & 0x40000) != 0) {
            this.drawOval(d4 - d10, d5 - d10, d13, d13);
        }
    }

    public void paintSphereDisk(Paint paint, double d, double d2, double d3, double d4) {
        double d5 = 2.0 * d4;
        if (d5 < 2.0) {
            d5 = 2.0;
        }
        this.setPaint(paint);
        this.fillOval(d - d4, d2 - d4, d5, d5);
    }

    public void paintTriangle(Paint paint, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.setPaint(paint);
        this.gl.glBegin(4);
        this.gl.glVertex2d(d, -d2);
        this.gl.glVertex2d(d4, -d5);
        this.gl.glVertex2d(d7, -d8);
        this.gl.glEnd();
    }

    public void paintVector(Paint paint, int n, int n2, double d, double d2, double d3, double d4, double d5, double d6) {
        this.setPaint(paint);
        this.prettyLine(d, d2, d4, d5, KPalette.lineWidths[n - 1][n2]);
    }

    void prettyLine(double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7 = -d5 / 2.0;
        double d8 = d7 + d5;
        double d9 = Math.abs(d3 - d);
        if (d9 > (d6 = Math.abs(d4 - d2))) {
            if (d < d3) {
                this.xPoints[0] = d;
                this.xPoints[1] = d + d7;
                this.xPoints[2] = d;
                this.xPoints[3] = d3;
                this.xPoints[4] = d3 - d7;
                this.xPoints[5] = d3;
                this.yPoints[0] = d2 + d7;
                this.yPoints[1] = d2;
                this.yPoints[2] = d2 + d8;
                this.yPoints[3] = d4 + d8;
                this.yPoints[4] = d4;
                this.yPoints[5] = d4 + d7;
            } else {
                this.xPoints[0] = d;
                this.xPoints[1] = d - d7;
                this.xPoints[2] = d;
                this.xPoints[3] = d3;
                this.xPoints[4] = d3 + d7;
                this.xPoints[5] = d3;
                this.yPoints[0] = d2 + d7;
                this.yPoints[1] = d2;
                this.yPoints[2] = d2 + d8;
                this.yPoints[3] = d4 + d8;
                this.yPoints[4] = d4;
                this.yPoints[5] = d4 + d7;
            }
        } else if (d2 < d4) {
            this.xPoints[0] = d + d7;
            this.xPoints[1] = d;
            this.xPoints[2] = d + d8;
            this.xPoints[3] = d3 + d8;
            this.xPoints[4] = d3;
            this.xPoints[5] = d3 + d7;
            this.yPoints[0] = d2;
            this.yPoints[1] = d2 + d7;
            this.yPoints[2] = d2;
            this.yPoints[3] = d4;
            this.yPoints[4] = d4 - d7;
            this.yPoints[5] = d4;
        } else {
            this.xPoints[0] = d + d7;
            this.xPoints[1] = d;
            this.xPoints[2] = d + d8;
            this.xPoints[3] = d3 + d8;
            this.xPoints[4] = d3;
            this.xPoints[5] = d3 + d7;
            this.yPoints[0] = d2;
            this.yPoints[1] = d2 - d7;
            this.yPoints[2] = d2;
            this.yPoints[3] = d4;
            this.yPoints[4] = d4 + d7;
            this.yPoints[5] = d4;
        }
        this.gl.glBegin(9);
        this.gl.glVertex2d(this.xPoints[0], -this.yPoints[0]);
        this.gl.glVertex2d(this.xPoints[1], -this.yPoints[1]);
        this.gl.glVertex2d(this.xPoints[2], -this.yPoints[2]);
        this.gl.glVertex2d(this.xPoints[3], -this.yPoints[3]);
        this.gl.glVertex2d(this.xPoints[4], -this.yPoints[4]);
        this.gl.glVertex2d(this.xPoints[5], -this.yPoints[5]);
        this.gl.glEnd();
    }

    public void drawOval(Paint paint, double d, double d2, double d3, double d4, double d5) {
        this.setPaint(paint);
        this.drawOval(d - d4 / 2.0, d2 - d5 / 2.0, d4, d5);
    }

    public void drawOval(Paint paint, int n, int n2, double d, double d2, double d3, double d4, double d5) {
        this.setPaint(paint);
        double d6 = d - d4 / 2.0 - (double)n / 2.0;
        double d7 = d2 - d5 / 2.0 - (double)n / 2.0;
        double d8 = d4 + (double)n;
        double d9 = d5 + (double)n;
        for (int i = 0; i < n; ++i) {
            this.drawOval(d6, d7, d8, d9);
            d6 += 1.0;
            d7 += 1.0;
            d8 -= 2.0;
            d9 -= 2.0;
        }
    }

    public void setFont(Font font) {
        int n = font.getSize();
        this.currFont = n <= 10 ? 6 : (n <= 14 ? 7 : 8);
    }

    public int getLabelWidth(String string) {
        return this.glut.glutBitmapLength(this.currFont, string);
    }

    public int getLabelAscent(String string) {
        if (this.currFont == 6) {
            return 10;
        }
        if (this.currFont == 7) {
            return 12;
        }
        if (this.currFont == 8) {
            return 18;
        }
        return 1;
    }

    public int getLabelDescent(String string) {
        return this.getLabelAscent(string) / 4;
    }

    void setPaint(Paint paint) {
        try {
            Color color = (Color)paint;
            this.gl.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            System.err.println("JoglPainter: tried painting with non-Color type of Paint");
        }
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        this.clipRgn.setBounds(n, n2, n3, n4);
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.glu.gluOrtho2D((double)n, (double)(n + n3), (double)(n2 - n4), (double)n2);
        this.gl.glViewport(n, n2, n3, n4);
    }

    public void clearCanvas(Color color) {
        this.gl.glClearColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
        this.gl.glClear(16384);
    }
}

