/*
 * Decompiled with CFR 0.152.
 */
package king.points;

import java.awt.Color;
import king.core.Engine2D;
import king.core.KPaint;
import king.core.KPoint;
import king.points.AbstractPoint;

public class LabelPoint
extends AbstractPoint {
    public static final int LEFT = 0;
    public static final int CENTER = 0x800000;
    public static final int RIGHT = 0x400000;
    public static final int HALIGN_MASK = -12582913;
    int minx = 0;
    int miny = 0;
    int maxx = 0;
    int maxy = 0;

    public LabelPoint(String string) {
        super(string);
    }

    public void paint2D(Engine2D engine2D) {
        KPaint kPaint = this.getDrawingColor(engine2D);
        if (kPaint.isInvisible()) {
            return;
        }
        Color color = kPaint.getPaint(engine2D.backgroundMode, engine2D.colorCue);
        String string = this.toString();
        if (string == null) {
            return;
        }
        int n = engine2D.painter.getLabelWidth(string);
        int n2 = engine2D.painter.getLabelAscent(string);
        int n3 = engine2D.painter.getLabelDescent(string);
        this.maxy = (int)this.y + n3;
        this.miny = (int)this.y - n2;
        this.minx = (this.multi & 0x800000) != 0 ? (int)this.x - n / 2 : ((this.multi & 0x400000) != 0 ? (int)this.x - n : (int)this.x);
        this.maxx = this.minx + n;
        engine2D.painter.paintLabel(color, this.toString(), this.minx, this.y, this.z);
    }

    public void setHorizontalAlignment(int n) {
        this.multi = this.multi & 0xFF3FFFFF | n;
        this.fireKinChanged(512);
    }

    public KPoint isPickedBy(float f, float f2, float f3, boolean bl) {
        if ((float)this.minx <= f && f <= (float)this.maxx && (float)this.miny <= f2 && f2 <= (float)this.maxy) {
            return this;
        }
        return super.isPickedBy(f, f2, f3, bl);
    }
}

