/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/

#include "CDlgConfig.h"
#include "CCentralResources.h"
#include "IProjection.h"

#include <QtGui>

CDlgConfig::CDlgConfig()
: projKey(1)
{
    setupUi(this);
    connect(butFont,SIGNAL(clicked(bool)),this,SLOT(slotSelectFont()));
    connect(comboBrowser,SIGNAL(currentIndexChanged(int)),this,SLOT(slotBrowserChanged(int)));

    QSettings cfg;
    cfg.beginGroup("map");
    projKey = cfg.value("projection",projKey).toUInt();

}


CDlgConfig::~CDlgConfig()
{

}


void CDlgConfig::exec()
{
    labelFontSample->setFont(gpResources->m_mapfont);
    radioMetric->setChecked(gpResources->m_doMetric);
    radioImperial->setChecked(!gpResources->m_doMetric);

    checkProxy->setChecked(gpResources->m_useHttpProxy);
    lineProxyURL->setText(gpResources->m_httpProxy);
    lineProxyPort->setText(QString("%1").arg(gpResources->m_httpProxyPort));

    spinUTCOffset->setValue(gpResources->m_offsetUTC > 24 ? 0: gpResources->m_offsetUTC);
    spinUTCOffsetFract->setValue(gpResources->m_offsetUTCfract);

    comboBrowser->setCurrentIndex(gpResources->m_eBrowser);
    lineBrowserCmd->setText(gpResources->cmdOther);

    checkUpMap->setChecked(gpResources->uploadMap);
    checkUpWpt->setChecked(gpResources->uploadWpt);
    checkUpRte->setChecked(gpResources->uploadRte);
    checkDnMap->setChecked(gpResources->downloadMap);
    checkDnWpt->setChecked(gpResources->downloadWpt);
    checkDnTrk->setChecked(gpResources->downloadTrk);

    lineSerialPort->setText(gpResources->serialPort);

    const proj_t * proj = projections;
    while(proj->proj) {
        comboProjection->addItem(proj->name,proj->key);
        ++proj;
    }
    comboProjection->setCurrentIndex(projKey);

    checkMouseWheel->setChecked(gpResources->flipMouseWheel);

    QDialog::exec();
}


void CDlgConfig::accept()
{
    gpResources->m_mapfont        = labelFontSample->font();
    gpResources->m_doMetric       = radioMetric->isChecked();
    gpResources->m_offsetUTC      = spinUTCOffset->value();
    gpResources->m_offsetUTCfract = spinUTCOffsetFract->value();
    gpResources->setUTCOffset(gpResources->m_offsetUTC, gpResources->m_offsetUTCfract);

    gpResources->m_useHttpProxy   = checkProxy->isChecked();
    gpResources->m_httpProxy      = lineProxyURL->text();
    gpResources->m_httpProxyPort  = lineProxyPort->text().toUInt();

    emit gpResources->sigProxyChanged();

    gpResources->m_eBrowser = (CCentralResources::bowser_e)comboBrowser->currentIndex();
    gpResources->cmdOther = lineBrowserCmd->text();

    gpResources->uploadMap      = checkUpMap->isChecked();
    gpResources->uploadWpt      = checkUpWpt->isChecked();
    gpResources->uploadRte      = checkUpRte->isChecked();
    gpResources->downloadMap    = checkDnMap->isChecked();
    gpResources->downloadWpt    = checkDnWpt->isChecked();
    gpResources->downloadTrk    = checkDnTrk->isChecked();

    gpResources->serialPort     = lineSerialPort->text();

    if(projKey != (quint32)comboProjection->currentIndex()) {
        projKey = comboProjection->currentIndex();
        QSettings cfg;
        cfg.beginGroup("map");
        cfg.setValue("projection",projKey);
        QMessageBox::information(0,tr("Projection ..."),tr("You must restart QLandkarte to enable the new projection mode."));
    }

    gpResources->flipMouseWheel = checkMouseWheel->isChecked();

    QDialog::accept();
}


void CDlgConfig::slotSelectFont()
{
    bool ok = false;
    QFont font = QFontDialog::getFont(&ok, labelFontSample->font(), this);
    if(ok) {
        labelFontSample->setFont(font);
    }
}


void CDlgConfig::slotBrowserChanged(int idx)
{
    if(idx == CCentralResources::eOther) {
        lineBrowserCmd->setEnabled(true);
    }
    else {
        lineBrowserCmd->setEnabled(false);
    }
}
