#include <qstring.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qtextstream.h>
#include <qmessagebox.h>
#include <alsa/asoundlib.h>
#include "seqdriver.h"
#include "mapdata.h"

MapData::MapData(QWidget *parent, const char *name) : QWidget(parent, name) {

  seqDriver = new SeqDriver(&midiMapList, this);
  midiMapList.setAutoDelete(true);
}

MapData::~MapData(){
}

void MapData::addMidiMap(MidiMap *midiMap) {

  midiMapList.append(midiMap);
}

void MapData::addMapWidget(MapWidget *mapWidget) {

  mapWidgetList.append(mapWidget);
}

void MapData::removeMidiMap(MidiMap *midiMap) {

  midiMapList.removeRef(midiMap);
}

void MapData::removeMapWidget(MapWidget *mapWidget) {

  mapWidgetList.removeRef(mapWidget);
}

int MapData::midiMapCount() {

  return(midiMapList.count());
}

int MapData::mapWidgetCount() {

  return(mapWidgetList.count());
}

MidiMap *MapData::midiMap(int index) {

  return(midiMapList.at(index));
}

MapWidget *MapData::mapWidget(int index) {

  return(mapWidgetList.at(index));
}

void MapData::registerPorts(int num) {

  portCount = num;
  seqDriver->registerPorts(num);
}

int MapData::getPortCount() {

  return(portCount);
}
