// dialogs.C
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

#include "dialogs.h"
#include "qps.h"

#include <qmessagebox.h> 
#include <qaccel.h>
#include <qapplication.h>
#include <qlayout.h>

extern Qps 	*qps;

// center window a with respect to main application window
static void center_window(QWidget *a)
{
    QWidget *b = qApp->mainWidget();
    a->move(b->x() + (b->width() - a->width()) / 2,
	    b->y() + (b->height() - a->height()) / 2);
}

static void fix_size(QWidget *w)
{
    w->setFixedSize(w->sizeHint());
}

IntervalDialog::IntervalDialog(const char *ed_txt, bool enabled)
    : QDialog(0, 0, TRUE)
{
    setCaption("Change Update Period");
    QVBoxLayout *tl = new QVBoxLayout(this, 10);

    QHBoxLayout *h1 = new QHBoxLayout;
    tl->addLayout(h1);

    QLabel *label1 = new QLabel("New Update Period", this);
    fix_size(label1);
    h1->addWidget(label1);
    h1->addStretch(1);

    lined = new QLineEdit(this);
    QFont f = font();
    lined->setMaxLength(7);
    lined->setText(ed_txt);
    if(enabled) {
	lined->selectAll();
	lined->setFocus();
    }
    //lined->setEnabled(enabled);
    lined->setEnabled(true);
    fix_size(lined);
    lined->setFixedWidth(64);
    h1->addWidget(lined);

    label = new QLabel( this );
    label->setFrameStyle( QFrame::Panel | QFrame::Sunken );
    label->setText( "");
    label->setAlignment(AlignRight );
    tl->addWidget(label);

    //toggle = new CrossBox("Automatic Update", this);
    toggle = new CrossBox("Dynamic Update", this);
    fix_size(toggle);
    toggle->setChecked(enabled);
    //toggle->setChecked(false);
    toggle->setChecked(true);
    toggle->setEnabled(false);
    tl->addWidget(toggle);
	
    QHBoxLayout *h2 = new QHBoxLayout;
    	//h2->addStretch(1);
    	cancel = new QPushButton("Cancel", this);
    	h2->addWidget(cancel);

    	ok = new QPushButton("OK", this);
    	h2->addWidget(ok);
    tl->addLayout(h2);


    connect(ok, SIGNAL(clicked()), SLOT(done_dialog()));
    connect(cancel, SIGNAL(clicked()), SLOT(reject()));
    connect(lined, SIGNAL(returnPressed()), SLOT(done_dialog()));
    connect(lined, SIGNAL( textChanged ( const QString & )), SLOT(event_label_changed()));
    connect(toggle, SIGNAL(toggled(bool)), lined, SLOT(setEnabled(bool)));

    ok->setDefault(TRUE);

    QAccel *acc = new QAccel(this);
    acc->connectItem(acc->insertItem(Key_Escape), this, SLOT(reject()));
    tl->freeze();
    center_window(this);
}

void IntervalDialog::event_label_changed()
{
	QString txt;
	int i = 0;
	ed_result = lined->text();
	ed_result = ed_result.stripWhiteSpace();
	
	//if(toggle->isChecked()) 

	QString s = ed_result;
	if (s.length()==0) 
	{
		label->setText("No UPDATE");
		return;
	}

	while(s[i] >= '0' && s[i] <= '9' || s[i] == '.') i++;

	float period = (i > 0) ? s.left(i).toFloat() : -1;
	
	s = s.mid(i, 3).stripWhiteSpace();
	if(s.length() == 0 || s == "s")
		period *= 1000;
	else if(s == "min")
		period *= 60000;
	else if(s != "ms")
		period = -1;
	if(period <= 0) {
		label->setText( "Invalid input");
		return;
		
	}

	txt.sprintf("%d ms",(int)period);
	label->setText(txt);
}

void IntervalDialog::done_dialog()
{
	int i = 0;

	ed_result = lined->text();
	ed_result = ed_result.stripWhiteSpace();
	
	//if(toggle->isChecked()) 
	QString s = ed_result;
	while(s[i] >= '0' && s[i] <= '9' || s[i] == '.') i++;

	float period = (i > 0) ? s.left(i).toFloat() : -1;
	
	s = s.mid(i, 3).stripWhiteSpace();
	if(s.length() == 0 || s == "s")
		period *= 1000;
	else if(s == "min")
		period *= 60000;
	else if(s != "ms")
		period = -1;
	if(period < 0) 
		return;
	
	qps->set_update_period((int)period);
	qps->forced_update();
	
	accept();
}

SliderDialog::SliderDialog(int defaultval, int minval, int maxval)
            : QDialog(0, 0, TRUE)
{
    setCaption("Renice Process");
    QVBoxLayout *tl = new QVBoxLayout(this, 10);

    QHBoxLayout *h1 = new QHBoxLayout;
    tl->addLayout(h1);

    label = new QLabel("New nice value:", this);
    fix_size(label);
    h1->addWidget(label);

    h1->addStretch(1);

    lined = new QLineEdit(this);
    QFont f = font();
    f.setBold(FALSE);
    lined->setFont(f);
    lined->setMaxLength(7);
    QString s;
    s.setNum(defaultval);
    lined->setText(s);
    lined->selectAll();
    lined->setFocus();
    fix_size(lined);
    lined->setFixedWidth(64);
    h1->addWidget(lined);

    slider = new QSlider(minval, maxval, 1, defaultval, QSlider::Horizontal,
			 this);
    slider->setTickInterval(10);
    slider->setTickmarks(QSlider::Below);
    slider->setFixedHeight(slider->sizeHint().height());
    tl->addWidget(slider);

    QHBoxLayout *h2 = new QHBoxLayout;
    tl->addLayout(h2);

    // decorate slider
    QLabel *left = new QLabel(this);
    QLabel *mid = new QLabel(this);
    QLabel *right = new QLabel(this);
    left->setNum(minval);
    mid->setNum((minval + maxval) / 2);
    right->setNum(maxval);
    fix_size(left);
    fix_size(mid);
    fix_size(right);
    h2->addWidget(left);
    h2->addStretch(1);
    h2->addWidget(mid);
    h2->addStretch(1);
    h2->addWidget(right);

    QHBoxLayout *h3 = new QHBoxLayout;
    tl->addLayout(h3);

    h3->addStretch(1);
    cancel = new QPushButton("Cancel", this);
    fix_size(cancel);
    h3->addWidget(cancel);

    ok = new QPushButton("OK", this);
    ok->setFixedSize(cancel->sizeHint());
    h3->addWidget(ok);

    connect(ok, SIGNAL(clicked()), SLOT(done_dialog()));
    ok->setDefault(TRUE);
    connect(cancel, SIGNAL(clicked()), SLOT(reject()));
    connect(lined, SIGNAL(returnPressed()), SLOT(done_dialog()));
    connect(slider, SIGNAL(valueChanged(int)), this, SLOT(slider_change(int)));
    QAccel *acc = new QAccel(this);
    acc->connectItem(acc->insertItem(Key_Escape), this, SLOT(reject()));
    tl->freeze();
    center_window(this);
}

void SliderDialog::done_dialog()
{
    ed_result = lined->text();
    ed_result = ed_result.stripWhiteSpace();
    accept();
}

void SliderDialog::slider_change(int val)
{
    QString s;
    s.setNum(val);
    lined->setText(s);
    lined->selectAll();
}
