// for Non-ASCII locale 
#include <qtextcodec.h>  
#include <global.h>
extern QTextCodec * codec ;
#define UniString(str)   codec->toUnicode(str)

// 	*** new style ***
int 		flag_24_ok; // we presume a kernel 2.4.x


//DELETE because of ~
static inline bool isprintable(unsigned char c)
{
	// assume, somewhat navely, that all latin-1 characters are printable
	return (c >= 0x20 && c < 0x7f) || c >= 0xa0;
}

// replace unprintables by spaces
static void make_printable(char *s)
{
	while(*s) {
		if(!isprintable(*s)) *s = ' ';
		++s;
	}
}

Category::~Category()
{}

int Category::compare(Procinfo *a, Procinfo *b)
{
	return string(a).compare(string(b));
}


Cat_int::Cat_int(const char *heading, const char *explain,
		int w, int Procinfo::*member)
: Category(heading, explain), int_member(member), field_width(w)
{}

QString Cat_int::string(Procinfo *p)
{
	QString s;
	s.setNum(p->*int_member);	
	return s;
}

int Cat_int::compare(Procinfo *a, Procinfo *b)
{
	// qsort() only cares about the sign of the number returned by the
	// comparison function; only a subtraction is necessary
	return a->*int_member - b->*int_member;
}


Cat_uintl::Cat_uintl(const char *heading, const char *explain, int w,
		unsigned long Procinfo::*member)
: Category(heading, explain), uintl_member(member), field_width(w)
{}

QString Cat_uintl::string(Procinfo *p)
{
	QString s;
	s.setNum(p->*uintl_member);	
	return s;
}

int Cat_uintl::compare(Procinfo *a, Procinfo *b)
{
	int bu = b->*uintl_member, au = a->*uintl_member;
	return bu >= au ? (bu == au ? 0 : 1) : -1;
}



Cat_hex::Cat_hex(const char *heading, const char *explain, int w,
		unsigned long Procinfo::*member)
		: Cat_uintl(heading, explain, w, member)
{}

QString Cat_hex::string(Procinfo *p)
{
	QString s;
	s.sprintf("%8x", (unsigned)(p->*uintl_member));
	return s;
}

Cat_swap::Cat_swap(const char *heading, const char *explain)
: Category(heading, explain)
{}

QString Cat_swap::string(Procinfo *p)
{
	QString s;
	// It can actually happen that size < resident (XSun under Solaris 2.6)
	// Possible with Linux ?
	s.setNum(p->size > p->resident ? p->size - p->resident : 0);
	return s;
}

int Cat_swap::compare(Procinfo *a, Procinfo *b)
{
	return (b->size - b->resident) - (a->size - a->resident);
}



Cat_string::Cat_string(const char *heading, const char *explain,
		QString Procinfo::*member)
: Category(heading, explain), str_member(member)
{}

QString Cat_string::string(Procinfo *p)
{
	return p->*str_member;
}


Cat_user::Cat_user(const char *heading, const char *explain)
: Cat_string(heading, explain)
{}

QString Cat_user::string(Procinfo *p)
{
	if(p->uid == p->euid)
		return Uidstr::userName(p->uid);
	else {
		QString s = Uidstr::userName(p->uid);
		s.append(p->euid == 0 ? "*" : "+");
		return s;
	}
}



Cat_group::Cat_group(const char *heading, const char *explain)
: Cat_string(heading, explain)
{}

QString Cat_group::string(Procinfo *p)
{
	if(p->gid == p->egid)
		return Uidstr::groupName(p->gid);
	else {
		QString s = Uidstr::groupName(p->gid);
		s.append("*");
		return s;
	}
}


Cat_wchan::Cat_wchan(const char *heading, const char *explain)
	: Cat_string(heading, explain)
{}

QString Cat_wchan::string(Procinfo *p)
{
	return Wchan::name(p->wchan);
}



Cat_cmdline::Cat_cmdline(const char *heading, const char *explain)
: Cat_string(heading, explain)
{}

QString Cat_cmdline::string(Procinfo *p)
{
	if(p->cmdline.isEmpty()) {
		QString s("(");
		s.append(p->command);
		s.append(")");
		return s;
	} else {
		if(Qps::show_file_path)
			return p->cmdline;
		else {
			QString s(p->cmdline);
			
			int i = s.find(' ');
			if(i < 0)
				i = s.length();
			if(i > 0) {
				i = s.findRev('/', i - 1);
				if(i >= 0)
					s.remove(0, i + 1);
			}
			return s;
		}
	}
}



// read new process info
void Procview::refresh()
{
	/****************************************************************/
	/*"Procview.procs" has the procinfo !!!!!!!!!!!!!!!!!		*/
	/****************************************************************/
	
	for(int i = 0; i < old_procs.size(); i++)
		old_procs[i]->deref();
	old_procs = procs;
	procs.clear();
	proc->refresh(); // update the process list ,read "/proc/*"
	rebuild();
}



// COMMON: 
// Description :
// 		View(MENU) mode : ALL , OWNER, NO-ROOOt
// 		Filtering processes
bool Procview::accept_proc(Procinfo *p)
{
	QString pid;
	static int my_uid = getuid();
	bool    ok;

	ok =    viewproc == ALL 
		|| ( viewproc == OWNED && p->uid == my_uid )
		|| ( viewproc == NROOT && p->uid != 0 )
		|| ( viewproc == RUNNING && strchr("ORDW", p->state) != 0 ) ; 
	if(ok==false) return false;
	
	
	
	if(search_box==NULL)	return ok;	//????	

	if(search_box->text()=="" || search_box->text()=="*" )
		return true;

	if(p->command.contains(search_box->text(),false)>0)
		return true;
	if(p->cmdline.contains(search_box->text(),false)>0) 
		return true;	

	pid= pid.setNum(p->pid);  //=QString::number(p->pid);
	if(pid.contains(search_box->text(),false)>0) 	
		return true;
		
		
	return false;
}


//  ????
void Procview::linearize_tree(Svec<Procinfo *> *ps, int level, int prow)
{
	static_sortcat = sortcat;
	ps->sort(reversed ? compare_backwards : compare);
	for(int i = 0; i < ps->size(); i++) 
	{
		Procinfo *p = (*ps)[i];
		p->level = level;
		p->lastchild = FALSE;
		procs.add(p->ref());
		parent_rows.add(prow);
		if(p->children && !p->hidekids)
			linearize_tree(p->children, level + 1, procs.size() - 1);
	}

	if(ps->size() > 0)
		(*ps)[ps->size() - 1]->lastchild = TRUE;
}


void Procview::set_fields_list(int fields[])
{
	cats.clear();
	for(int i = 0; fields[i] != F_END; i++)
	{
		cats.add(proc->allcats[fields[i]]);
		//printf("DEBUG: %d %s \n", i,proc->allcats[fields[i]]->name);
	}
}



// return the column number of a field, or -1 if not displayed
int Procview::findCol(int field)
{
	for(int i = 0; i < cats.size(); i++)
		if(cats[i] == proc->allcats[field])
			return i;
	return -1;
}


// add a category (last)
void Procview::add_cat(Category *c)
	//void Procview::add_category(Category *c)
{
	cats.add(c);
}

void Procview::remove_cat(int index)
{
	cats.remove(index);
}


Category *Procview::static_sortcat = 0;

int Procview::compare(Procinfo *const *a, Procinfo *const *b)
{
	int r = static_sortcat->compare(*a, *b);
	return (r == 0) ? ((*a)->pid > (*b)->pid ? 1 : -1) : r;
}

int Procview::compare_backwards(Procinfo *const *a, Procinfo *const *b)
{
	int r = static_sortcat->compare(*b, *a);
	return (r == 0) ? ((*b)->pid > (*a)->pid ? 1 : -1) : r;
}

