/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 *
 * Some Plextor commands got from PxScan and CDVDlib (C) Alexander Noe`
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <sys/time.h>
#include <unistd.h>

#include <transport.h>
#include <qpx_mmc.h>
#include "plextor_features.h"

int plextor_get_TLA(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0] = 0xF1;
	drive->cmd[9] = 0x80;
	// The Plextor PX-716 does not understand this command....
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,0x100)))
	{
		//printf("Possible PX-716...\n");
		drive->cmd_clear();
		drive->cmd[0] = 0xF1;
		drive->cmd[1] = 0x01;
		drive->cmd[9] = 0x80;
		if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,0x100) ))
			{strcpy(drive->TLA,"N/A\0"); return 1;}
	}
	memcpy(drive->TLA,drive->rd_buf+0x29,4);
	drive->TLA[4] = 0;
	return 0;
}

int plextor_get_speeds(drive_info* drive) {
	int sel, max, last;
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_PREC_SPD;
	drive->cmd[9]=0x0A;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("GET_SPEEDS",drive->err);return drive->err;}
	sel = ((drive->rd_buf[5] & 0xFF)<<8) | (drive->rd_buf[4] & 0xFF);
	max = ((drive->rd_buf[7] & 0xFF)<<8) | (drive->rd_buf[6] & 0xFF);
	last = ((drive->rd_buf[9] & 0xFF)<<8) | (drive->rd_buf[8] & 0xFF);
	printf("Selected write speed: %d kB/s\n  Max for this media: %d kB/s\n   Last actual speed: %d kB/s\n",
		sel,max,last);
	return 0;
}

int plextor_get_powerec(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE2;
	drive->cmd[1]=PLEX_GET_MODE;
	drive->cmd[2]=0x00;
	drive->cmd[9]=0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("GET_POWEREC",drive->err);return drive->err;}
	drive->plextor.powerec_state = (drive->rd_buf[2] & 0xFF);
	drive->plextor.powerec_spd = ((drive->rd_buf[4] & 0xFF)<<8) | (drive->rd_buf[5] & 0xFF);
	printf("\tPoweRec %s, Recomended speed: %d kB/s\n",
		drive->plextor.powerec_state ? "ON" : "OFF",drive->plextor.powerec_spd);
//	printf("\t"); for (int i=0; i<8; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
	return 0;
}

int plextor_set_powerec(drive_info* drive) {
	printf("\tTurning PoweRec %s\n",drive->plextor.powerec_state ? "ON" : "OFF");
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE2;
	drive->cmd[1]=PLEX_SET_MODE | (drive->plextor.powerec_state?1:0);
	drive->cmd[2]=0x00;
	drive->cmd[9]=0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("SET_POWEREC",drive->err);return drive->err;}
	drive->plextor.powerec_state = (drive->rd_buf[2] & 0xFF);	
	drive->plextor.powerec_spd = ((drive->rd_buf[4] & 0xFF)<<8) | (drive->rd_buf[5] & 0xFF);
//	printf("\t"); for (int i=0; i<8; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
//	plextor_get_speeds(drive);
	return 0;
}

void plextor_print_silentmode_state(drive_info* drive){
	int val, idx;
	val=drive->plextor_silent.read_speed; idx=0;
	printf("\t MAX read speed: ");
	if ( drive->media.disc_type & DISC_DVD ) {
		while ((silent_dvd_rd_tbl[idx].val!=0xFF) & (silent_dvd_rd_tbl[idx].val!=(val & 0xFF))) idx++;
		printf("%s\n",silent_dvd_rd_tbl[idx].name);
	}else{
		while ((silent_cd_rd_tbl[idx].val!=0xFF) & (silent_cd_rd_tbl[idx].val!=(val & 0xFF))) idx++;
		printf("%s\n",silent_cd_rd_tbl[idx].name);
	}
	val=drive->plextor_silent.write_speed; idx=0;
	printf("\tMAX write speed: ");
	if ( drive->media.disc_type & DISC_DVD ) {
		while ((silent_dvd_wr_tbl[idx].val!=0xFF) & (silent_dvd_wr_tbl[idx].val!=(val & 0xFF))) idx++;
		printf("%s\n",silent_dvd_wr_tbl[idx].name);
	}else{
		while ((silent_cd_wr_tbl[idx].val!=0xFF) & (silent_cd_wr_tbl[idx].val!=(val & 0xFF))) idx++;
		printf("%s\n",silent_cd_wr_tbl[idx].name);
	}
	printf("\t         Access: %s\n",drive->plextor_silent.access_speed?"SLOW":"FAST");
	printf("\t    Eject speed: %d\n",drive->plextor_silent.eject_speed);
	printf("\t     Load speed: %d\n",drive->plextor_silent.load_speed);
}

int plextor_get_silentmode(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_GET_MODE;
	drive->cmd[2]=PLEX_MODE_SILENT;
	drive->cmd[3]=0x04;
	drive->cmd[10]=0x08;
	if (( drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("GET_SILENT_MODE",drive->err);return drive->err;}
	if (( drive->err=drive->cmd.transport(READ,(void*)&(drive->plextor_silent),8) ))
		{ sperror ("GET_SILENT_MODE",drive->err);return drive->err;}
//	printf("\t"); for (int i=0; i<8; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
	return 0;
}

int plextor_set_silentmode_tray(drive_info* drive, int disc_type, int permanent) {
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_GET_MODE;
	drive->cmd[2]=PLEX_MODE_SILENT_TRAY;
	drive->cmd[3]=disc_type | 2*!!permanent;
	drive->cmd[4]=drive->plextor_silent.eject_speed;
	drive->cmd[6]=drive->plextor_silent.load_speed;
	if ((drive->err=drive->cmd.transport(WRITE,(void*)&(drive->plextor_silent),0) ))
		{ sperror ("SET_SILENT_MODE_DISC",drive->err);return drive->err;}
//	printf("\t"); for (int i=0; i<8; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
	return 0;
}

int plextor_set_silentmode_disc(drive_info* drive, int disc_type, int permanent) {
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_GET_MODE;
	drive->cmd[2]=PLEX_MODE_SILENT_DISC;
	drive->cmd[3]=disc_type | 2*!!permanent;
	drive->cmd[4]=drive->plextor_silent.read_speed;
	drive->cmd[5]=drive->plextor_silent.write_speed;
	drive->cmd[6]=drive->plextor_silent.access_speed;
	if ((drive->err=drive->cmd.transport(WRITE,(void*)&(drive->plextor_silent),0) ))
		{ sperror ("SET_SILENT_MODE_DISC",drive->err);return drive->err;}
//	printf("\t"); for (int i=0; i<8; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
	return 0;
}

int plextor_set_silentmode_disable(drive_info* drive, int permanent) {

	drive->plextor_silent.read_speed=0x07;
	drive->plextor_silent.write_speed=0x07;
	drive->plextor_silent.access_speed=0;
	plextor_set_silentmode_disc(drive, 0, permanent);
	drive->plextor_silent.eject_speed=0x50;
	drive->plextor_silent.load_speed=0x50;
	plextor_set_silentmode_tray(drive, 0, permanent);
	return 0;
}

void print_gigarec_value(drive_info* drive) {
//	plextor_get_gigarec(drive);
	int g,i;
	printf("\tGigaRec value: ");
	i=drive->plextor.gigarec; g=0;
	while ((gigarec_tbl[g].val!=0xFF) & (gigarec_tbl[g].val!=(i & 0xFF))) g++;
	printf("%s, disc GigaRec rate: ",gigarec_tbl[g].name);
	
	i=drive->plextor.gigarec_disc; g=0;
	while ((gigarec_tbl[g].val!=0xFF) & (gigarec_tbl[g].val!=(i & 0xFF))) g++;
	printf("%s\n",gigarec_tbl[g].name);
}

int plextor_set_gigarec(drive_info* drive) {
// 	printf("  applying gigarec setting... ");
// 	print_gigarec_value(i);
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_SET_MODE;
	drive->cmd[2]=PLEX_MODE_GIGAREC;
	drive->cmd[3]=(drive->plextor.gigarec?1:0);
	drive->cmd[4]=drive->plextor.gigarec;
	drive->cmd[10]=0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("SET_GIGAREC",drive->err); return drive->err;}
	drive->plextor.gigarec = (drive->rd_buf[3] & 0xFF);
	drive->plextor.gigarec_disc = (drive->rd_buf[4] & 0xFF);
	print_gigarec_value(drive);
//	printf("\t"); for (int i=0; i<8; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
	return 0;
}

int plextor_get_gigarec(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_GET_MODE;
	drive->cmd[2]=PLEX_MODE_GIGAREC;
	drive->cmd[10]=0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("GET_GIGAREC",drive->err);return drive->err;}
	drive->plextor.gigarec = (drive->rd_buf[3] & 0xFF);
	drive->plextor.gigarec_disc = (drive->rd_buf[4] & 0xFF);
//	printf("\t"); for (int i=0; i<8; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
	return 0;
}

void print_varirec(drive_info* drive, int disc_type) {
	int v,i,s;
	if (disc_type == VARIREC_DVD) {
		i=drive->plextor.varirec_pwr_dvd;
		s=drive->plextor.varirec_str_dvd;
	}else{
		i=drive->plextor.varirec_pwr_cd;
		s=drive->plextor.varirec_str_cd;
	}
	v=0;
	while ((varirec_pwr_tbl[v].val!=0xFF) & (varirec_pwr_tbl[v].val!=(i & 0xFF))) v++;
	printf("\tVariRec %s power : %s, Strategy: ", (disc_type == VARIREC_DVD)? "DVD":"CD",varirec_pwr_tbl[v].name);
	if (disc_type == VARIREC_DVD) {
		printf("%s\n",varirec_str_dvd_tbl[s]);
	} else {
		printf("%s\n",varirec_str_cd_tbl[s]);
	}
}

int plextor_set_varirec(drive_info* drive, int disc_type) {
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_SET_MODE;
	drive->cmd[2]=PLEX_MODE_VARIREC;
	if (disc_type == VARIREC_DVD) {
		drive->cmd[3]=disc_type + 2*!!drive->plextor.varirec_state_dvd;
		drive->cmd[4]=drive->plextor.varirec_pwr_dvd;
		drive->cmd[5]=drive->plextor.varirec_str_dvd;
	}else{
		drive->cmd[3]=disc_type + 2*!!drive->plextor.varirec_state_cd;
		drive->cmd[4]=drive->plextor.varirec_pwr_cd;
		drive->cmd[5]=drive->plextor.varirec_str_cd;
	}
	drive->cmd[10]=0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("SET_VARIREC",drive->err);return drive->err;}
	if (disc_type == VARIREC_DVD) {
		drive->plextor.varirec_state_dvd =  (drive->rd_buf[2] &0xFF);
		drive->plextor.varirec_pwr_dvd = (drive->rd_buf[3] &0xFF);
		drive->plextor.varirec_str_dvd = (drive->rd_buf[5] &0xFF);
	}else{
		drive->plextor.varirec_state_cd =  (drive->rd_buf[2] &0xFF);
		drive->plextor.varirec_pwr_cd = (drive->rd_buf[3] &0xFF);
		drive->plextor.varirec_str_cd = (drive->rd_buf[5] &0xFF);
	}
//	printf("\t"); for (int i=0; i<8; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
	return 0;
}

int plextor_get_varirec(drive_info* drive, int disc_type) {
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_GET_MODE;
	drive->cmd[2]=PLEX_MODE_VARIREC;
	drive->cmd[3]=0x02 | disc_type;
	drive->cmd[10]=0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("GET_VARIREC",drive->err);return drive->err;}
	if (disc_type == VARIREC_DVD) {
		drive->plextor.varirec_state_dvd =  (drive->rd_buf[2] &0xFF);
		drive->plextor.varirec_pwr_dvd = (drive->rd_buf[3] &0xFF);
		drive->plextor.varirec_str_dvd = (drive->rd_buf[5] &0xFF);
	}else{
		drive->plextor.varirec_state_cd =  (drive->rd_buf[2] &0xFF);
		drive->plextor.varirec_pwr_cd = (drive->rd_buf[3] &0xFF);
		drive->plextor.varirec_str_cd = (drive->rd_buf[5] &0xFF);
	}
//	printf("\t"); for (int i=0; i<8; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
	return 0;
}

void print_speedread_state(drive_info* drive){
	printf("\tSpeedRead: %s\n",drive->plextor.spdread ? "on" : "off" );
}

int plextor_set_speedread(drive_info* drive, int state) {
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_SET_MODE;
	drive->cmd[2]=PLEX_MODE_SPDREAD;
	drive->cmd[3]=!!state;
	drive->cmd[10]=0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("SET_SPDREAD",drive->err); return drive->err; }
//	printf("** SPDREAD: "); for (int i=0; i<8; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
	drive->plextor.spdread=drive->rd_buf[2];
	return 0;
}

int plextor_get_speedread(drive_info* drive) {
//	return 1;
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_GET_MODE;
	drive->cmd[2]=PLEX_MODE_SPDREAD;
	drive->cmd[3]=0;
	drive->cmd[10]=0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("GET_SPDREAD",drive->err);return drive->err; }
	drive->plextor.spdread=drive->rd_buf[2];
	return 0;
}

void print_hcdr_state(drive_info* drive) {
	printf("\tHide CD-R: %s\n",drive->plextor.hcdr ? "on" : "off");
}

void print_sss_state(drive_info* drive) {
	printf("\tSingleSession: %s\n",drive->plextor.sss ? "on" : "off");
}

int plextor_get_hidecdr_singlesession(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_GET_MODE;
	drive->cmd[2]=PLEX_MODE_SS_HIDE;
	drive->cmd[9]=0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8)))
		{ sperror ("GET_HCDR_SSS",drive->err); return drive->err; }
	drive->plextor.hcdr = !!(drive->rd_buf[2] & 0x02);
	drive->plextor.sss = (drive->rd_buf[2]) & 0x01;
	return 0;
}

int plextor_set_hidecdr_singlesession(drive_info* drive, int hidecdr_state, int singlesession_state) {
	if (plextor_get_hidecdr_singlesession(drive)) return 1;
//	printf("Trying to change SS/HIDE state to %d...\n",2*!!hidecdr_state + !!singlesession_state);
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_SET_MODE;
	drive->cmd[2]=PLEX_MODE_SS_HIDE;
	drive->cmd[3]=2*!!hidecdr_state + !!singlesession_state;
	drive->cmd[9]=0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("SET_HCDR_SSS",drive->err); return drive->err;}
//	printf("** HCDR_SSS: "); for (int i=0; i<8; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
	drive->plextor.hcdr = !!(drive->rd_buf[2] & 0x02);
	drive->plextor.sss = (drive->rd_buf[2]) & 0x01;
	return 0;
}

int plextor_set_hidecdr(drive_info* drive, int state) {
	if (plextor_get_hidecdr_singlesession(drive)) return 1;
	drive->plextor.hcdr = !!state;
	return plextor_set_hidecdr_singlesession(drive, drive->plextor.hcdr, drive->plextor.sss);
}

int plextor_set_singlesession(drive_info* drive, int state) {
	if (plextor_get_hidecdr_singlesession(drive)) return 1;	
	drive->plextor.sss = !!state;
	return plextor_set_hidecdr_singlesession(drive, drive->plextor.hcdr, drive->plextor.sss);
}

int plextor_get_bitset(drive_info* drive, int disc_type)
{
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_GET_MODE;
	drive->cmd[2]=PLEX_MODE_BITSET;
	drive->cmd[3]=disc_type;
	drive->cmd[9]=0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("PLEXTOR_GET_BITSET",drive->err); return drive->err;}
	switch (disc_type)
	{
		case PLEX_BITSET_R: drive->book_plus_r = ((drive->rd_buf[2] & 0x02) == 0x02); break;
		case PLEX_BITSET_RDL: drive->book_plus_rdl = ((drive->rd_buf[2] & 0x01) == 0x01); break;
	}
	return 0;
}

int plextor_set_bitset(drive_info* drive, int disc_type)
{
	char book;
	switch (disc_type)
	{
		case PLEX_BITSET_R:	book = (drive->book_plus_r); break;
		case PLEX_BITSET_RDL:	book = (drive->book_plus_rdl); break;
		default:		printf("PLEXTOR_SET_BITSET: Invalid disc_type"); return 1;
	}
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_SET_MODE;
	drive->cmd[2]=PLEX_MODE_BITSET;
	drive->cmd[3]=disc_type;
	drive->cmd[5]=book;
	drive->cmd[9]=0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("PLEXTOR_SET_BITSET",drive->err); return drive->err;}
	return 0;
}

int plextor_get_testwrite_dvdplus(drive_info* drive)
{
/*    char data[] = { 0,0,0,0,0,0,0,0 };
    int j = ExecSCSICmd(SRB_DIR_IN,drive,&srbExec,data,8,12,
	0xE9,0x00,0x21,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x08);
    if (status)
        *status = !!data[2];
*/
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_MODE;
	drive->cmd[1]=PLEX_GET_MODE;
	drive->cmd[2]=PLEX_MODE_TESTWRITE_DVDPLUS;
	drive->cmd[10]= 0x08;
	if ((drive->err=drive->cmd.transport(READ, drive->rd_buf, 8) ))
		{ sperror ("PLEXTOR_GET_TESTWRITE_DVDPLUS",drive->err); return drive->err;}
	drive->plextor.testwrite_dvdplus = !!drive->rd_buf[2];
	return 0;
}

int plextor_set_testwrite_dvdplus(drive_info* drive)
{
/*
// plextor enable test write: E9 10 21 01
    int j = ExecSCSICmd(SRB_DIR_IN,drive,&srbExec,NULL,0,12,0xE9,0x10,0x21,!!i);
*/
	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_MODE;
	drive->cmd[1] = PLEX_SET_MODE;
	drive->cmd[2] = PLEX_MODE_TESTWRITE_DVDPLUS;
	drive->cmd[3] = drive->plextor.testwrite_dvdplus;
	if ((drive->err=drive->cmd.transport(READ, NULL, 0) ))
		{ sperror ("PLEXTOR_SET_TESTWRITE_DVDPLUS",drive->err); return drive->err;}
	return 0;
}

int plextor_plexeraser(drive_info* drive)
{
	long i;
	printf("Destucting disc [mode=%02X]... \n",drive->plextor.plexeraser);
//	return 0;
	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_ERASER;
	drive->cmd[1] = 0x06;
	drive->cmd[2] = drive->plextor.plexeraser;
	if ((drive->err=drive->cmd.transport(READ, NULL, 0) ))
		{ sperror ("PLEXTOR_DO_PLEXERASER",drive->err); return drive->err;}
	while (test_unit_ready(drive)) {
		usleep(1000000);
		i++;
	}
	return 0;
}

		//-----------------//
		//  AUTOSTRATEGY   //
		//-----------------//

int plextor_print_autostrategy_state(drive_info* drive)
{
	printf("\t   Autostrategy: ");
	switch (drive->astrategy.state)
	{
		case AS_OFF: printf("OFF"); break;
		case AS_AUTO: printf("AUTO"); break;
		case AS_FORCED: printf("FORCED"); break;
		case AS_ON: printf("ON"); break;
		default: printf("???");
	}
	printf(" [%d]\n",drive->astrategy.state);
	return 0;
}

int plextor_get_autostrategy(drive_info* drive)
{
	drive->cmd_clear();
	drive->cmd[0]=CMD_PLEX_AS_RD;
	drive->cmd[10]= 0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("PLEXTOR_GET_AUTOSTRATEGY",drive->err); return drive->err;}
//	printf("** GET AS: "); for (int i=0; i<8; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
	drive->astrategy.state = (drive->rd_buf[2] & 0x0F);
	return 0;
}

int plextor_set_autostrategy(drive_info* drive)
{
	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_AS_RD;
	drive->cmd[2] = PLEX_SET_MODE + (drive->astrategy.state & 0x0F);
	drive->cmd[10]= 0x08;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8) ))
		{ sperror ("PLEXTOR_SET_AUTOSTRATEGY",drive->err); return drive->err;}
//	printf("** SET AS: "); for (int i=0; i<8; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
	drive->astrategy.state = (drive->rd_buf[2] & 0x0F);
	plextor_print_autostrategy_state(drive);
	return 0;
}

int plextor_get_autostrategy_db_entry_count(drive_info* drive)
{
	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_AS_RD;
	drive->cmd[1] = 0x02;
	drive->cmd[10]= 0x08;
	if ((drive->err=drive->cmd.transport(READ,(void*)&(drive->astrategy),8) ))
		{ sperror ("PLEXTOR_GET_ASDB_ENTRY_COUNT",drive->err); return drive->err;}
//	drive->astrategy.dbcnt = drive->rd_buf[6];
//	printf ("\t  AS DB entries: %d\n", drive->astrategy.dbcnt);
	return 0;
}

int plextor_get_autostrategy_db(drive_info* drive)//, void* database)
{
	int size = 8 + (int)drive->astrategy.dbcnt * 32;
	int i,j;
	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_AS_RD; // 0xE4
	drive->cmd[1] = 0x02;
	drive->cmd[9]= (size >> 8) & 0xFF ;
	drive->cmd[10]= size & 0xFF ;
	if ((drive->err=drive->cmd.transport(READ,(void*)&(drive->astrategy),size) ))
		{ sperror ("PLEXTOR_GET_ASDB",drive->err); return drive->err;}
	printf("** AS DB entries: %d\n",drive->astrategy.dbcnt);
//*
	for (j=0; j<drive->astrategy.dbcnt; j++) {
		printf("S#%02d: ", drive->astrategy.entry[j].number);
		printf("[%c]",drive->astrategy.entry[j].enabled ? '*':' ');
		printf("DVD%cR [%02X] |", (drive->astrategy.entry[j].type == 0xA1)? '+':'-',drive->astrategy.entry[j].type);
		printf("%3dX |",drive->astrategy.entry[j].speed);
		for (i=0; i<12;i++)
			if (drive->astrategy.entry[j].MID[i] < 0x20) drive->astrategy.entry[j].MID[i] = 0x20;
		printf("%13s |",drive->astrategy.entry[j].MID);
		printf("%d\n",(drive->astrategy.entry[j].counter[0] <<8) | drive->astrategy.entry[j].counter[1]);
	}
//*/
/*
	char ch;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,size) ))
		{ sperror ("PLEXTOR_GET_ASDB",drive->err); return drive->err;}
	printf("ASDB dump:\n");
	for (i=0; i<8; i++) printf("%02X ", drive->rd_buf[i] & 0xFF);
	printf("\n");
	for (j=0; j<drive->astrategy.dbcnt; j++) {
		for (i=0; i<32; i++) printf("%02X ", drive->rd_buf[j*32+i+8] & 0xFF);
		printf("\n");
		for (i=0; i<32; i++) {
			if (drive->rd_buf[j*32+i+8] > 0x1F) 
				ch = drive->rd_buf[j*32+i+8];
			else
				ch = 0x20;
			printf("%c", ch);
		}
		printf("\n");
	}
*/
	return 0;
}

int plextor_modify_autostrategy_db(drive_info* drive, int index, int action)
{
	drive->rd_buf[0]=0x00;
	drive->rd_buf[1]=0x08;
	drive->rd_buf[2]=0x02;
	drive->rd_buf[3]=0x00;
	drive->rd_buf[4]=0x00;
	drive->rd_buf[5]=0x00;
	drive->rd_buf[6]=0x01;
	drive->rd_buf[7]=0x02;
	drive->rd_buf[8]=index;
	drive->rd_buf[9]=action;

	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_AS_WR; // 0xE5
	drive->cmd[1] = 0x02;
	drive->cmd[10]= 0x0A;
	if ((drive->err=drive->cmd.transport(WRITE,drive->rd_buf,0x0A) ))
		{ sperror ("PLEXTOR_MODIFY_ASDB",drive->err); return drive->err;}
	return 0;
}

int plextor_create_strategy(drive_info* drive, int mode)
{
	int i;
	printf("AS create: %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X\n",
		(CMD_PLEX_AS_RD) & 0xFF, 4, mode & 0xFF, 0, 0, 0, 0, 0, 0, 0, 0, 0);
//	return 0;

	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_AS_RD;
	drive->cmd[1] = 0x04;
	drive->cmd[2] = mode;
	if ((drive->err=drive->cmd.transport(READ,NULL,0) ))
		{ sperror ("PLEXTOR_CREATE_STRATEGY_START",drive->err); return drive->err;}

	printf("AS CRE START...\n");

	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_AS_RD;
	drive->cmd[1] = 0x01;
	drive->cmd[10]= 0x12;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,0x12) ))
		{ sperror ("PLEXTOR_CREATE_STRATEGY",drive->err); return drive->err;}

	printf("      AS CRE: "); for (i=0; i<0x12; i++) printf("%02X ", drive->rd_buf[i] & 0x0FF); printf("\n");

// Waiting until Strategy is created
	while (test_unit_ready(drive)) {
		usleep(1000000);
		i++;
	}

	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_AS_RD;
	drive->cmd[1] = 0x01;
	drive->cmd[10]= 0x12;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,0x12) ))
		{ sperror ("PLEXTOR_CREATE_STRATEGY_DONE",drive->err); return drive->err;}

	printf(" AS CRE DONE: "); for (i=0; i<0x12; i++) printf("%02X ", drive->rd_buf[i]) & 0x0FF; printf("\n");

	return 0;
}

int plextor_media_check(drive_info* drive, int mode)
//int plextor_create_strategy(drive_info* drive, int mode)
{
	int i;
	printf("MQCK: %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X\n",
		(CMD_PLEX_AS_RD) & 0xFF, 1, mode & 0xFF, 0, 0, 0, 0, 0, 0, 0, 0, 0);
//	return 0;

	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_AS_RD;
	drive->cmd[1] = 0x01;
	drive->cmd[2] = mode;
	if ((drive->err=drive->cmd.transport(READ,NULL,0) ))
		{ sperror ("PLEXTOR_MEDIA_QUALITY_CHECK_START",drive->err); return drive->err;}

	printf("MQCK START...\n");
/*
	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_AS_RD;
	drive->cmd[1] = 0x01;
	drive->cmd[10]= 0x12;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,0x12) ))
		{ sperror ("PLEXTOR_CREATE_STRATEGY",drive->err); return drive->err;}

	printf("      AS CRE: "); for (i=0; i<0x12; i++) printf("%02X ", drive->rd_buf[i] & 0xFF); printf("\n");
*/
// Waiting until Media is checked
	while (test_unit_ready(drive)) {
//		sleep(10);
		i++;
	}

	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_AS_RD;
	drive->cmd[1] = 0x01;
	drive->cmd[10]= 0x12;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,0x12) ))
		{ sperror ("PLEXTOR_MEDIA_QUALITY_CHECK_DONE",drive->err); return drive->err;}

	printf(" MQCK DONE: "); for (i=0; i<0x12; i++) printf("%02X ", drive->rd_buf[i]) & 0xFF; printf("\n");

	return 0;
}

		//----------------//
		//  PX-755 AUTH   //
		//----------------//

int px755_get_auth_code(drive_info* drive,char* auth_code)
{
	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_GET_AUTH;
	drive->cmd[10]= 0x10;
	if ((drive->err=drive->cmd.transport(READ,auth_code,16) ))
		{ sperror ("PLEXTOR_PX755_GET_AUTH_CODE",drive->err); return drive->err;}
	printf("** Get PX755 auth: "); for (int i=0; i<16; i++) printf("0x%02X ",drive->rd_buf[i]&0xFF); printf("\n");
	return 0;
}

int px755_send_auth_code(drive_info* drive,char* auth_code)
{
	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_SEND_AUTH;
	drive->cmd[1] = 0x01;
	drive->cmd[2] = 0x01;
	drive->cmd[10]= 0x10;
	if ((drive->err=drive->cmd.transport(WRITE,auth_code,16) ))
		{ sperror ("PLEXTOR_PX755_SEND_AUTH_CODE",drive->err); return drive->err;}
	return 0;
}

int px755_clear_auth_status(drive_info* drive)
{
	drive->cmd_clear();
	drive->cmd[0] = CMD_PLEX_SEND_AUTH;
	drive->cmd[1] = 0x01;
	drive->cmd[10]= 0x10;
	if ((drive->err=drive->cmd.transport(WRITE,NULL,0) ))
		{ sperror ("PLEXTOR_PX755_CLEAR_AUTH_STATUS",drive->err); return drive->err;}
	return 0;
}

int px755_calc_auth_code(char* auth_code)
{
	return 0;
}
