/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 *
 * NEC Cx scan commands got from readcd path by Alexander Noe`
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <stdio.h>
#include <stdlib.h>

#include <qpx_transport.h>
#include <qpx_mmc.h>
#include <common_functions.h>

#include "media_check_nec.h"

// ************* Scan init commands *********
int nec_init_cx_scan(drive_info* drive) {
	/* initialize scan mode */
	drive->cmd_clear();
	drive->cmd[0] = 0xF3;
	drive->cmd[1] = 0x01;
	if ((drive->err=drive->cmd.transport(NONE, NULL, 0))){
		sperror ("nec_init_cx_scan",drive->err); return 1;
	}
	/* set scan interval = 75 sectors */
	drive->cmd_clear();
	drive->cmd[0] = 0xF3;
	drive->cmd[1] = 0x02;
	drive->cmd[8] = 75;  // interval
	if ((drive->err=drive->cmd.transport(NONE, NULL, 0))){
		sperror ("nec_set_cx_scan_interval",drive->err); return 1;
	}
	return 0;
}

int nec_init_pie_scan(drive_info* drive) {
	/* initialize scan mode */
	drive->cmd_clear();
	drive->cmd[0] = 0xF3;
	drive->cmd[1] = 0x01;
	if ((drive->err=drive->cmd.transport(NONE, NULL, 0))){
		sperror ("nec_init_cx_scan",drive->err); return 1;
	}
	/* set scan interval = 8 ECC */
	drive->cmd_clear();
	drive->cmd[0] = 0xF3;
	drive->cmd[1] = 0x02;
	drive->cmd[8] = 0x08;  // interval
	if ((drive->err=drive->cmd.transport(NONE, NULL, 0))){
		sperror ("nec_set_cx_scan_interval",drive->err); return 1;
	}
	return 0;
}

int nec_init_pif_scan(drive_info* drive) {
	/* initialize scan mode */
	drive->cmd_clear();
	drive->cmd[0] = 0xF3;
	drive->cmd[1] = 0x01;
	if ((drive->err=drive->cmd.transport(NONE, NULL, 0))){
		sperror ("nec_init_cx_scan",drive->err); return 1;
	}
	/* set scan interval = 1 ECC */
	drive->cmd_clear();
	drive->cmd[0] = 0xF3;
	drive->cmd[1] = 0x02;
	drive->cmd[8] = 0x01;  // interval
	if ((drive->err=drive->cmd.transport(NONE, NULL, 0))){
		sperror ("nec_set_cx_scan_interval",drive->err); return 1;
	}
	return 0;
}

// **********************
int nec_cx_do_one_interval(drive_info* drive, int* lba, int* BLER,
	int* E11, int* E21, int* E31, int* E12, int* E22, int* E32)
{
	drive->cmd_clear();
	drive->cmd[0] = 0xF3;
	drive->cmd[1] = 0x03;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8))){
		sperror ("nec_cx_do_one_interval",drive->err);
		if (drive->err == 0x30200) return SCAN_BLOCK_LAST;
		else return SCAN_BLOCK_FAIL;
	}
	*BLER = swap2(drive->rd_buf+4);
	*E11 = 0;
	*E21 = 0;
	*E31 = 0;
	*E12 = 0;
	*E22 = swap2(drive->rd_buf+6);
	*E32 = 0;
//	*lba+=75;
	*lba=((int)drive->rd_buf[1] * 4500 + (int)drive->rd_buf[2] * 75 + (int)drive->rd_buf[3]);
	return SCAN_BLOCK_DONE;
}

int nec_pie_do_eight_ecc_blocks(drive_info* drive, int* lba, int* pie, int* pof)
{
	drive->cmd_clear();
	drive->cmd[0] = 0xF3;
	drive->cmd[1] = 0x03;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8))){
		sperror ("nec_pie_do_one_interval",drive->err);
		if (drive->err == 0x30200) return SCAN_BLOCK_LAST;
		else return SCAN_BLOCK_FAIL;
	}
	*pie = swap2(drive->rd_buf+4);
	*pof = 0;
	*lba=swap4(drive->rd_buf);
//	*lba+=0x80;
	return SCAN_BLOCK_DONE;
}

int nec_pif_do_one_ecc_block(drive_info* drive, int* lba, int* pif)
{
	drive->cmd_clear();
	drive->cmd[0] = 0xF3;
	drive->cmd[1] = 0x03;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8))){
		sperror ("nec_pif_do_one_interval",drive->err);
		if (drive->err == 0x30200) return SCAN_BLOCK_LAST;
		else return SCAN_BLOCK_FAIL;
	}
	*pif = swap2(drive->rd_buf+6);
	*lba=swap4(drive->rd_buf);
//	*lba+=0x10;
	return SCAN_BLOCK_DONE;
}

// ************* END SCAN COMMAND *********
int nec_end_scan(drive_info* drive) {
	drive->cmd_clear();
	drive->cmd[0] = 0xF3;
	drive->cmd[1] = 0x0F;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,8))){
		sperror ("nec_end_scan",drive->err); return 1;
	}
	return 0;
}

scan_commands commands_list_nec = {
	nec_init_cx_scan,	nec_cx_do_one_interval,		nec_end_scan,
	NULL,			NULL,				NULL,

	nec_init_pie_scan,	nec_pie_do_eight_ecc_blocks,	nec_end_scan,
	nec_init_pif_scan,	nec_pif_do_one_ecc_block,	nec_end_scan,
	NULL,			NULL,				NULL,
	NULL,			NULL,				NULL,
	NULL,			NULL,				NULL,
};

scan_commands commands_nec()  { return commands_list_nec; }
