/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <stdio.h>
#include <stdlib.h>
//#include "qpx_const.h"
#include <qevent.h>
#include <qthread.h>
#include <qmutex.h>
#include <qevent.h>
#include "scan_pointers.h"
//#include <unistd.h>

class QCustomEvent;
class QMutex;
class QThread;

class ScanThread: public QThread//, public QObject
{
public:
	ScanThread(QWidget* p){
		parent = (QObject*)p;
		drive = NULL;
		printf("** Init scan thread...");
// 		scan_tbl = (scan_commands**)malloc((VENDORS+1)*sizeof(scan_commands*));
// 		for (int i=0; i<(VENDORS+1); i++)
// 			scan_tbl[i] = (scan_commands*)malloc(sizeof(scan_commands));
		init_check_table();
		printf(" OK\n");
	}
	~ScanThread(){
		if (drive) delete drive;
// 		for (int i=0; i<=VENDORS; i++)
// 			delete scan_tbl[i];// = (scan_commands*)malloc(sizeof(scan_commands));
	}
	void	run();
//	int current_test();
	void	skip_test();
	void	abort_test();
	void	set_drive(drive_info* drv);
private:
	void	post_signal(int event_id, void* data){
		QCustomEvent*	event = new QCustomEvent(event_id);
		if (data) event->setData(data);
		postEvent(parent, event);
	}

	void	event_block_done(int event_id,block_data b){
		block_data* block = new block_data;
		memcpy(block,&b,sizeof(block_data));
		QCustomEvent*	event = new QCustomEvent(event_id);
		event->setData(block);
		postEvent(parent, event);
	}

	int	skip();
	void	reset_skip_flag();
	int	skip_flag;

	int	init_check_table();

	int 	rd_rate();
	int	scan_cx();
	int	scan_jb_cd();
	int	scan_pie();
	int	scan_pif();
	int	scan_jb_dvd();
	int	scan_fete();
	int	plextor_scan_TA();

	QMutex		mutex;
	QObject*	parent;
	drive_info*	drive;

// 	scan_commands	commands_generic;
	scan_commands	scan_tbl[VENDORS+1];
	int arr_BLER[128];
	int arr_E11[128], arr_E21[128], arr_E31[128];
	int arr_E12[128], arr_E22[128], arr_E32[128];
signals:
};

#ifndef __USE_QTHREAD
extern	void	*scan(void* arg);
#endif


class ScanTimer: public QThread
{
public:
	ScanTimer(QWidget* p) {
		parent = (QObject*)p;
	}
	~ScanTimer() {}

	void	run();
private:
	QObject*	parent;
	void	post_signal(int event_id){
		QCustomEvent*	event = new QCustomEvent(event_id);
		postEvent(parent, event);
	}
};
