/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <stdio.h>

#include <string.h>
#include "common_functions.h"

int swap4(char* c) {
	char d[4];
	d[0]=c[3];
	d[1]=c[2];
	d[2]=c[1];
	d[3]=c[0];
	return *(int*)d;
}

int swap4(unsigned char* c) {
	char d[4];
	d[0]=c[3];
	d[1]=c[2];
	d[2]=c[1];
	d[3]=c[0];
	return *(int*)d;
}

int swap4(int c_) {
	char* c = (char*)&c_;
	char d[4];
	d[0]=c[3];
	d[1]=c[2];
	d[2]=c[1];
	d[3]=c[0];
	return *(int*)d;
}

short int swap2(char* c) {
	char d[2];
	d[0]=c[1];
	d[1]=c[0];
	return *(short int*)d;
}

short int swap2(unsigned char* c) {
	char d[2];
	d[0]=c[1];
	d[1]=c[0];
	return *(short int*)d;
}

unsigned short int swap2u(char* c) {
	char d[2];
	d[0]=c[1];
	d[1]=c[0];
	return *(unsigned short int*)d;
}

unsigned short int swap2u(unsigned char* c) {
	char d[2];
	d[0]=c[1];
	d[1]=c[0];
	return *(unsigned short int*)d;
}

void lba2msf(int* lba, msf* time){
	time->m = *lba/4500;
	time->s = (*lba/75)%60;
	time->f = *lba % 75;
}

int min(int a, int b){
  if (a<=b)
	return a;
  return b;}

int max(int a, int b){
  if (a>b)
	return a;
  return b;}

void remove_double_spaces(char* str)
{
	int len = strlen(str);
	while(len--) {
		if (*str == 0x20 && str[1] == 0x20) 
			strcpy(str, str+1);
		else
			str++;
	}
}

void remove_end_spaces(char* str)
{
	int len = strlen(str);
	while (str[--len] == 0x20)
		str[len] = 0;

}

void file_path_name(char* str, char* fpath, char* fname)
{
//	printf("Path to split: %s\n", str);
	int len = strlen(str);
	int i;
	if ((str[0]!='/') && (strncmp(str, "./", 2))) {
		for (i=(len-1); i>(-1);i--) str[i+2]=str[i];
		str[0]='.';
		str[1]='/';
		str[len+2]=0;
		len+=2;
	}
//	printf("Full path    : %s\n", str);
	while (len)
		if (str[--len] == '/') {
			strcpy(fname, str+len+1);
			str[len+1]=0;
			strcpy(fpath, str);
			len = 0;
		}
//	printf("Path         : %s\n", fpath);
//	printf("File         : %s\n", fname);
}

void file_suf_rm(char* str){
	int len = strlen(str);
	while (len)
		if ((str[--len] == '.') && (len)) {
			str[len]=0;
			len = 0;
		}
}

int dispers(int m, int* arr, int l) {
	if ((!m) || (!arr) || (l<2)) return 0;
	long disp = 0;
	int i;
	int q;
	for (i=0; i<l; i++) {
	    q = (m - arr[i]);
	    disp += (q*q);
	}
	return (disp/(l-1));
}
