/***************************************************************************
                          paint.cpp  -  description
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "paint.h"
#include <qtoolbar.h>
#include <qpainter.h>
#include <qstatusbar.h>
#include <qcolordialog.h>
#include <qlabel.h>
#include "cpixmap.h"
#include "qsstvglobal.h"
#include "dirdialog.h"
#include "imageframe.h"

//#define DEBUGPAINT

static bool baspect=TRUE;

subWindow::subWindow(QWidget *parent,const char* name):imageFrame(parent,name)
{
  state=DIDLE;
  textBox=new ptext;
  styleBox=new pstyle;
}

subWindow::~subWindow()
{
  delete textBox;
  delete styleBox;
}

void subWindow::contentsMousePressEvent(QMouseEvent *event)
{
  berase=FALSE;
  startPoint=event->pos();  
  if (state==DTEXT)
    {
      contentsMouseMoveEvent(event); // so you only have to click
    }
}


void subWindow::contentsMouseMoveEvent(QMouseEvent *event)
{
  QPainter p(&pixmap);
  
  p.setRasterOp(XorROP);
  
  QPoint ep=event->pos();
  int ex=event->pos().x();
  int ey=event->pos().y();
 

  p.setPen(QPen(XORCOLOR,styleBox->getThickness(),styleBox->getStyle()));
  switch (state)
    {
    case DARROW:
      {
      }
    break;
    case DTEXT:
      {
				textBox->draw(&p,ep,fgColor,berase);
      }
    break;
    case DLINE:
      {
				if (berase)
	  			{
	    			p.drawLine(startPoint,endPoint);
	  			}
				p.drawLine(startPoint,ep);
      }
      break;
    case DRECT: 
    case DFRECT:
      {
				if (berase)
	  			{
	    			p.drawRect(QRect(startPoint,endPoint));
#ifdef DEBUGPAINT
	    			debug("erase rect %d,%d ; %d,%d",startPoint.x(),startPoint.y(),endPoint.x(),endPoint.y());
#endif
	  			}
#ifdef DEBUGPAINT
	    			debug("draw rect %d,%d ; %d,%d",startPoint.x(),startPoint.y(),ep.x(),ep.y());
#endif	
				p.drawRect(QRect(startPoint,ep));
      }
		break;
    case DIMAGE:
      {
				if (berase)
	  			{
	    			p.drawRect(QRect(startPoint,endPoint));
	  			}
				if(baspect)
	  			{
	    			ey=startPoint.y()+(int)(((double)pixmap.height()/(double)pixmap.width())*(double)(ex-startPoint.x()));
	  			}
				ep=QPoint(ex,ey);
				p.drawRect(QRect(startPoint,ep));
      }
		break;
    case DCIRCLE: 
    case DFCIRCLE:
      {
				if (berase)
	  			{
	    			p.drawEllipse(QRect(startPoint,endPoint));
	  			}
				p.drawEllipse(QRect(startPoint,ep));
      }
		break;

    default:
      {
      }
    }
  berase=TRUE;
  QRect t=QRect(startPoint,endPoint).normalize();
	QRect v=QRect(startPoint,ep).normalize();
  t=t.unite(v);
#ifdef DEBUGPAINT
	  debug("repaint %d,%d; %d,%d ",t.x(),t.y(),t.right(),t.bottom());
#endif
 // repaintContents(t,FALSE);
 	 viewport()->repaint(FALSE);
  endPoint=ep;
}




void subWindow::contentsMouseReleaseEvent(QMouseEvent *event)
{
  QPainter p(&pixmap);
  
  p.setRasterOp(XorROP);
  p.setPen(QPen(XORCOLOR,styleBox->getThickness(),styleBox->getStyle()));
  QPoint ep = event->pos();
  int ex=event->pos().x();
  int ey=event->pos().y();

  switch (state)
    {
    case DARROW:
      {
      }
      break;
    case DTEXT:
      {
	p.setRasterOp(CopyROP);
	if ( event->button() == LeftButton )            // left button released
	  {
	   textBox->fixText(&p,fgColor,bgColor);
	  }
      }
      break;
    case DLINE:
      {
	p.drawLine(startPoint,endPoint);
	p.setRasterOp(CopyROP);
	p.setPen(QPen(fgColor,styleBox->getThickness(),styleBox->getStyle()));
	p.drawLine(startPoint,ep);
      }
      break;
    case DRECT:
      {
	p.drawRect(QRect(startPoint,endPoint));
	p.setRasterOp(CopyROP);
	p.setPen(QPen(fgColor,styleBox->getThickness(),styleBox->getStyle()));
	p.drawRect(QRect(startPoint,ep));
      }
      break;
    case DFRECT:
      {
	p.drawRect(QRect(startPoint,endPoint));
	p.setRasterOp(CopyROP);
	p.setPen(QPen(bgColor,styleBox->getThickness(),styleBox->getStyle()));
	p.fillRect(QRect(startPoint,ep),bgColor);
	p.setPen(QPen(fgColor,styleBox->getThickness(),styleBox->getStyle()));
	p.drawRect(QRect(startPoint,ep));
      }
      break;
      
    case DCIRCLE:
      {
	p.drawEllipse(QRect(startPoint,endPoint));
	p.setRasterOp(CopyROP);
	p.setPen(QPen(fgColor,styleBox->getThickness(),styleBox->getStyle()));
	p.drawEllipse(QRect(startPoint,ep));
      }
      break;
    case DFCIRCLE:
      {
	p.drawEllipse(QRect(startPoint,endPoint));
	p.setRasterOp(CopyROP);
	p.setBrush(bgColor);
	p.drawPie(QRect(startPoint,ep),0,16*360);
	p.setPen(QPen(fgColor,styleBox->getThickness(),styleBox->getStyle()));
	p.drawEllipse(QRect(startPoint,ep));
      }
      break;
    case DIMAGE:
      {
	p.drawRect(QRect(startPoint,endPoint));
	if(baspect)
	  {
	    ey=startPoint.y()+(int)(((double)pixmap.height()/(double)pixmap.width())*(double)(ex-startPoint.x()));
	  }
	ep=QPoint(ex,ey);
	p.setRasterOp(CopyROP);
	QImage temp;
	QPixmap m;
	int width,height;
	width=ep.x()-startPoint.x();
	height=ep.y()-startPoint.y();
	temp=tpm; // tpm is the loaded image
	temp=temp.smoothScale(width,height);
	m=temp;
	p.drawPixmap(startPoint,m);
	}
      break;
   
    default:
      {
      }
    }
//  repaintContents(QRect(startPoint,endPoint).normalize(),FALSE);
	viewport()->repaint(FALSE);
}



void subWindow::deselect()
{
  for (int i=0;i<NUMTOOLS;i++)
    {
      if (i!=(int)state)
	{
	  buttonArray[i]->setOn(FALSE);
	}
    }
}


void subWindow::line()
{
  state=DLINE;
  deselect();
}

void subWindow::arrow()
{
  state=DARROW;
  deselect();
}


void subWindow::text()
{
  state=DTEXT;
  deselect();
  textBox->show();
}

void subWindow::setStyle()
{
  styleBox->show();
}

void subWindow::Rect()
{
  state=DRECT;
  deselect();
}

void subWindow::fRect()
{
  state=DFRECT;
  deselect();
}


void subWindow::circle()
{
  state=DCIRCLE;
  deselect();
}

void subWindow::fcircle()
{
  state=DFCIRCLE;
  deselect();
}

void subWindow::insertImage()
{
  QString fn;
  dirDialog dd(0,0,TRUE);
  fn=dd.openFileName(configFile.readOption("ImageTxDir"));
  if(!fn.isNull())
    {
//      erase();
      tpm.load(fn);
//      repaint(FALSE);
      state=DIMAGE;
      deselect();
    }
  else
    {
      arrow();
    }
}


paint::paint(QWidget *parent,int x,int y):QMainWindow(parent,"Image Editor")
{

  mainTools = new QToolBar( this, "file operations" );
  drawTools = new QToolBar("",this,QMainWindow::Top,TRUE);
  commandTools = new QToolBar("",this,QMainWindow::Bottom,TRUE);
  canvas=new subWindow(this,"canvas");
  canvas->setFixedSize(x,y);
  setCentralWidget(canvas);

  canvas->buttonArray[DARROW] = new QToolButton( *arrowIcon, "Select", 0,
					    canvas, SLOT(arrow()),
					    mainTools, "arrow" );
  canvas->buttonArray[DTEXT]  = new QToolButton( *textIcon, "Insert text", 0,
					    canvas, SLOT(text()),
					    mainTools, "Text" );
  canvas->buttonArray[DLINE]  = new QToolButton( *lineIcon, "Draw line", 0,
					    canvas, SLOT(line()),
					    mainTools, "Line" );
  new QToolButton( *styleIcon, "Change style", 0,
					    canvas, SLOT(setStyle()),
					    mainTools, "Style" );
  canvas->buttonArray[DRECT] = new QToolButton( *rectIcon, "Draw rectangle", 0,
					    canvas, SLOT(Rect()),
					    mainTools, "Rect" );
  canvas->buttonArray[DFRECT] = new QToolButton( *frectIcon, "Draw filled rectangle", 0,
					    canvas, SLOT(fRect()),
					    mainTools, "Filled" );
  canvas->buttonArray[DCIRCLE]  = new QToolButton( *circleIcon, "Draw circle", 0,
					    canvas, SLOT(circle()),
					    mainTools, "circle" );
  canvas->buttonArray[DFCIRCLE] = new QToolButton( *fcircleIcon, "Draw filled circle", 0,
					    canvas, SLOT(fcircle()),
					    mainTools, "Fcircle" );
  canvas->buttonArray[DIMAGE] = new QToolButton( *insertPictureIcon, "Insert Picture", 0,
					    canvas, SLOT(insertImage()),
					    mainTools, "insertImage" );
  QCheckBox *aspectButton=new QCheckBox("Keep aspect ratio",mainTools);
  connect(aspectButton,SIGNAL(toggled(bool)),this,SLOT(aspect(bool)));
  aspectButton->setChecked(baspect);
  QLabel *fs=new QLabel("",mainTools);
  mainTools->setStretchableWidget (fs );
  for (int i=0;i<NUMTOOLS;i++)
    {
      canvas->buttonArray[i]->setToggleButton(TRUE);
    }
  QPushButton  *okButton = new QPushButton( commandTools, "okbutton" );
  okButton->setText("OK");
  connect(okButton, SIGNAL(clicked()), SLOT(finish()));
  QPushButton  *cancelButton = new QPushButton( commandTools, "cancelbutton" );
  cancelButton->setText("Cancel");
  connect(cancelButton, SIGNAL(clicked()), SLOT(abandon()) );
  foregroundSelect = new QPushButton( drawTools, "foregroundsel" );
  foregroundSelect->setText("Foregr.");
  connect(foregroundSelect, SIGNAL(clicked()), SLOT(foregroundClicked()) );
  backgroundSelect = new QPushButton( drawTools, "backgroundsel" );
  backgroundSelect->setText("Backgr.");
  QLabel *fst=new QLabel("",drawTools);
  drawTools->setStretchableWidget (fst );
  connect(backgroundSelect, SIGNAL(clicked()), SLOT(backgroundClicked()) );
  canvas->fgColor=Qt::black;
  canvas->bgColor=Qt::white;
  foregroundSelect->setPalette(QPalette(canvas->fgColor));
  backgroundSelect->setPalette(QPalette(canvas->bgColor));
  statusBar()->message("Ready");
  setRightJustification(TRUE);
}

paint::~paint()
{

}



void paint::editImage(imageFrame *im)
{
  canvas->copyPixmap(*im->getPixmapPtr());
  imageFramePtr=im;
  repaint(FALSE);
}


void paint::finish()
{
  imageFramePtr->copyPixmap(*canvas->getPixmapPtr());
  //imageFramePtr->repaint(FALSE);
  imageFramePtr->viewport()->repaint(FALSE);
  close();
}

void paint::abandon()
{
  close(); 
}

void paint::closeEvent( QCloseEvent * )
{ 
  delete this;
}



void paint::foregroundClicked()
{ 
	QColor c;
	c=QColorDialog::getColor(canvas->fgColor);
	if (c.isValid())
		{
			canvas->fgColor=c;
			foregroundSelect->setPalette(QPalette(c));	
		}
}

void paint::backgroundClicked()
{
	QColor c;
	c=QColorDialog::getColor(canvas->fgColor);
	if (c.isValid())
		{
			canvas->bgColor=c;
      backgroundSelect->setPalette(QPalette(c));
    }
}


void paint::aspect (bool b)
{
  baspect=b;
}














