/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.launcher;

import com.trolltech.qt.core.*;

public abstract class Worker extends QObject {
    
    protected abstract void execute();

    public Worker(QObject parent) {
        super(parent);
    }

    public void start() {
	if (m_is_running)
	    stop();
	m_is_running = true;
	m_timer_id = startTimer(m_delay);
    }

    public void stop() {
	killTimer(m_timer_id);
	m_is_running = false;
    }

    public void setDelay(int delay) {
	m_delay = delay;
    }

    public int delay() {
	return m_delay;
    }

    protected void timerEvent(QTimerEvent e) {
	if (e.timerId() == m_timer_id) {
	    execute();
	    stop();
	}
    }

    private int m_delay = 250;
    private int m_timer_id;
    private boolean m_is_running;
} 
