/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef ABSTRACTGAMEOBJECT_H
#define ABSTRACTGAMEOBJECT_H

#include "gamenamespace.h"
#include "point3d.h"

#include <QtGui/QGraphicsItem>

class AbstractGameObject: public QGraphicsItem
{
public:
    virtual void perform(Game::ActionType action, AbstractGameObject **args, int num_args) = 0;
    virtual Game::WalkingDirection direction() const = 0;
    virtual QString name() const = 0;
    virtual QStringList otherNames() const = 0;
    virtual Point3D position() const = 0;
    virtual void walk(Game::WalkingDirection direction) = 0;
    virtual Game::ObjectFlags objectFlags() const = 0;
};


#endif
