/****************************************************************************
**
** Copyright (C) 1992-2008 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** * Commercial Usage
* Licensees holding valid Qt Commercial licenses may use this file in
* accordance with the Qt Commercial License Agreement provided with the
* Software or, alternatively, in accordance with the terms contained in
* a written agreement between you and Nokia.
*
*
* GNU General Public License Usage
* Alternatively, this file may be used under the terms of the GNU
* General Public License versions 2.0 or 3.0 as published by the Free
* Software Foundation and appearing in the file LICENSE.GPL included in
* the packaging of this file.  Please review the following information
* to ensure GNU General Public Licensing requirements will be met:
* http://www.fsf.org/licensing/licenses/info/GPLv2.html and
* http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
* exception, Nokia gives you certain additional rights. These rights
* are described in the Nokia Qt GPL Exception version 1.2, included in
* the file GPL_EXCEPTION.txt in this package.
* 
* Qt for Windows(R) Licensees
* As a special exception, Nokia, as the sole copyright holder for Qt
* Designer, grants users of the Qt/Eclipse Integration plug-in the
* right for the Qt/Eclipse Integration to link to functionality
* provided by Qt Designer and its related libraries.
*
*
* If you are unsure which license is appropriate for your use, please
* contact the sales department at qt-sales@nokia.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.tools.designer;

import com.trolltech.qt.gui.*;
import com.trolltech.qt.core.*;

public class HourGlass extends QWidget {

    public HourGlass() {
        this(null);
    }

    public HourGlass(QWidget parent) {
        super(parent);

        double mainRadius = 8;
        double maxRadius = 2.5;
        double minRadius = 1;
        path = new QPainterPath();
        QPointF pt = new QPointF(0, mainRadius - maxRadius);
        QMatrix m = new QMatrix();
        for (int i=0; i<8; ++i) {
            m.rotate(-360 / 8);
            double size = Math.max(maxRadius * 2 - i, minRadius * 2);
            QRectF r = new QRectF(-size / 2, -size / 2, size, size);
            r.moveCenter(m.map(pt));
            path.addEllipse(r);
        }
        hide();
    }

    public void start() {
        if (running)
            return;
        running = true;
        run(true);
        show();
    }

    public void stop() {
        running = false;
        run(false);
        hide();
    }

    @Override
    protected void showEvent(QShowEvent e) {
        run(true);
    }

    @Override
    protected void hideEvent(QHideEvent e) {
        run(false);
    }

    @Override
    protected void timerEvent(QTimerEvent e) {
        rotation += 360 / 8;
        update();
    }

    @Override
    protected void paintEvent(QPaintEvent arg) {
        QPainter p = new QPainter(this);
        p.setRenderHint(QPainter.RenderHint.Antialiasing);

        p.translate(rect().center());

        p.rotate(rotation);
        p.setBrush(new QBrush(QColor.gray));
        p.setPen(QPen.NoPen);

        p.fillPath(path, new QBrush(QColor.gray));
    }

    @Override
    public QSize sizeHint() {
        return new QSize(16, 16);
    }

    private void run(boolean visible) {
        if (visible && running && timerId == 0) {
            timerId = startTimer(100);
        } else if (timerId != 0 && (!visible || !running)) {
            killTimer(timerId);
            timerId = 0;
        }
    }

    private boolean running;
    private int timerId;
    private int rotation;
    private QPainterPath path;
}
