/****************************************************************************
**
** Copyright (C) 1992-2008 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** * Commercial Usage
* Licensees holding valid Qt Commercial licenses may use this file in
* accordance with the Qt Commercial License Agreement provided with the
* Software or, alternatively, in accordance with the terms contained in
* a written agreement between you and Nokia.
*
*
* GNU General Public License Usage
* Alternatively, this file may be used under the terms of the GNU
* General Public License versions 2.0 or 3.0 as published by the Free
* Software Foundation and appearing in the file LICENSE.GPL included in
* the packaging of this file.  Please review the following information
* to ensure GNU General Public Licensing requirements will be met:
* http://www.fsf.org/licensing/licenses/info/GPLv2.html and
* http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
* exception, Nokia gives you certain additional rights. These rights
* are described in the Nokia Qt GPL Exception version 1.2, included in
* the file GPL_EXCEPTION.txt in this package.
* 
* Qt for Windows(R) Licensees
* As a special exception, Nokia, as the sole copyright holder for Qt
* Designer, grants users of the Qt/Eclipse Integration plug-in the
* right for the Qt/Eclipse Integration to link to functionality
* provided by Qt Designer and its related libraries.
*
*
* If you are unsure which license is appropriate for your use, please
* contact the sales department at qt-sales@nokia.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef CPP_HEADER_GENERATOR
#define CPP_HEADER_GENERATOR

#include "cppgenerator.h"
#include "metajava.h"

class CppHeaderGenerator : public CppGenerator
{
    Q_OBJECT

public:
    CppHeaderGenerator(PriGenerator *pri)
    {
        priGenerator = pri;
    }

    virtual QString fileNameForClass(const AbstractMetaClass *cls) const;

    void write(QTextStream &s, const AbstractMetaClass *java_class);
    void writeFunction(QTextStream &s, const AbstractMetaFunction *java_function);
    void writePublicFunctionOverride(QTextStream &s, const AbstractMetaFunction *java_function);
    void writeVirtualFunctionOverride(QTextStream &s, const AbstractMetaFunction *java_function);
    void writeForwardDeclareSection(QTextStream &s, const AbstractMetaClass *java_class);
    void writeVariablesSection(QTextStream &s, const AbstractMetaClass *java_class);
    void writeFieldAccessors(QTextStream &s, const AbstractMetaField *java_field);
    void writeSignalWrapper(QTextStream &s, const AbstractMetaFunction *java_function);
    void writeSignalWrappers(QTextStream &s, const AbstractMetaClass *java_class);
    void writeWrapperClass(QTextStream &s, const AbstractMetaClass *java_class);
    void writeInjectedCode(QTextStream &s, const AbstractMetaClass *java_class);

    bool shouldGenerate(const AbstractMetaClass *java_class) const {
        return (java_class->generateShellClass()
                && CppGenerator::shouldGenerate(java_class))
            || (java_class->queryFunctions(AbstractMetaClass::Signals).size() > 0
                && (java_class->typeEntry()->codeGeneration() & TypeEntry::GenerateCpp));
    }
};

#endif // CPP_HEADER_GENERATOR
