/****************************************************************************
**
** Copyright (C) 1992-2008 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** * Commercial Usage
* Licensees holding valid Qt Commercial licenses may use this file in
* accordance with the Qt Commercial License Agreement provided with the
* Software or, alternatively, in accordance with the terms contained in
* a written agreement between you and Nokia.
*
*
* GNU General Public License Usage
* Alternatively, this file may be used under the terms of the GNU
* General Public License versions 2.0 or 3.0 as published by the Free
* Software Foundation and appearing in the file LICENSE.GPL included in
* the packaging of this file.  Please review the following information
* to ensure GNU General Public Licensing requirements will be met:
* http://www.fsf.org/licensing/licenses/info/GPLv2.html and
* http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
* exception, Nokia gives you certain additional rights. These rights
* are described in the Nokia Qt GPL Exception version 1.2, included in
* the file GPL_EXCEPTION.txt in this package.
* 
* Qt for Windows(R) Licensees
* As a special exception, Nokia, as the sole copyright holder for Qt
* Designer, grants users of the Qt/Eclipse Integration plug-in the
* right for the Qt/Eclipse Integration to link to functionality
* provided by Qt Designer and its related libraries.
*
*
* If you are unsure which license is appropriate for your use, please
* contact the sales department at qt-sales@nokia.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package generator;

import com.trolltech.qt.*;
import com.trolltech.qt.xml.*;

class QDomDocument___ extends QDomDocument {

    public class Result {
        private Result(boolean success, QNativePointer errorMessage, QNativePointer errorLine, QNativePointer errorColumn) {
            this.success = success;
            this.errorMessage = errorMessage.stringValue();
            this.errorLine = errorLine.intValue();
            this.errorColumn = errorColumn.intValue();
        }

        public boolean success;
        public String errorMessage;
        public int errorLine;
        public int errorColumn;

    }

}// class

class QXmlNamespaceSupport___ extends QXmlNamespaceSupport {

    public static class ProcessedName {
        public ProcessedName(String nsuri, String localName) {
            this.nsuri = nsuri;
            this.localName = localName;
        }

        public String nsuri;
        public String localName;
    }

    public final ProcessedName processName(String qname, boolean isAttribute) {
        QNativePointer nsUri = new QNativePointer(QNativePointer.Type.String);
        QNativePointer localName = new QNativePointer(QNativePointer.Type.String);
        processName(qname, isAttribute, nsUri, localName);

        return new ProcessedName(nsUri.stringValue(), localName.stringValue());
    }

    public static class SplitName {
        public SplitName(String prefix, String localname) {
            this.prefix = prefix;
            this.localname = localname;
        }

        public String prefix;
        public String localname;
    }

    public final SplitName splitName(String qname) {
        QNativePointer prefix = new QNativePointer(QNativePointer.Type.String);
        QNativePointer localName = new QNativePointer(QNativePointer.Type.String);
        splitName(qname, prefix, localName);

        return new SplitName(prefix.stringValue(), localName.stringValue());
    }

}// class

class QXmlStreamWriter___ extends QXmlStreamWriter {

    public QXmlStreamWriter(com.trolltech.qt.core.QByteArray array) {
        this(array.nativePointer());
        __rcDevice = array;
    }

    public final void setCodec(String codecName) {
        setCodec(QNativePointer.createCharPointer(codecName));
        __rcCodec = null;
    }

}// class

interface QXmlEntityResolver___ extends QXmlEntityResolver {

    public static class ResolvedEntity {

        public boolean error;
        public QXmlInputSource inputSource;

        public ResolvedEntity(boolean error, QXmlInputSource inputSource) {

            this.error = error;
            this.inputSource = inputSource;

        }

    }

}// class
