/****************************************************************************
**
** Copyright (C) 1992-2008 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** * Commercial Usage
* Licensees holding valid Qt Commercial licenses may use this file in
* accordance with the Qt Commercial License Agreement provided with the
* Software or, alternatively, in accordance with the terms contained in
* a written agreement between you and Nokia.
*
*
* GNU General Public License Usage
* Alternatively, this file may be used under the terms of the GNU
* General Public License versions 2.0 or 3.0 as published by the Free
* Software Foundation and appearing in the file LICENSE.GPL included in
* the packaging of this file.  Please review the following information
* to ensure GNU General Public Licensing requirements will be met:
* http://www.fsf.org/licensing/licenses/info/GPLv2.html and
* http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
* exception, Nokia gives you certain additional rights. These rights
* are described in the Nokia Qt GPL Exception version 1.2, included in
* the file GPL_EXCEPTION.txt in this package.
* 
* Qt for Windows(R) Licensees
* As a special exception, Nokia, as the sole copyright holder for Qt
* Designer, grants users of the Qt/Eclipse Integration plug-in the
* right for the Qt/Eclipse Integration to link to functionality
* provided by Qt Designer and its related libraries.
*
*
* If you are unsure which license is appropriate for your use, please
* contact the sales department at qt-sales@nokia.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "javautils.h"
#include <QtCore/QHash>

QString javaFixString(const QString &str)
{
    const ushort *chars = str.utf16();
    QString result;

    for (int i = 0; i < str.length(); ++i) {
        ushort c = chars[i];
        if (c >= 0x0080) {
            QString num = QString::number(c, 16);
            int padding = 4 - num.length();
            if (padding <= 0) {
                qWarning("juic: bad unicode character %x became %s\n", c, qPrintable(num));
                return "";
            }

            result += QLatin1String("\\u") + QString(padding, '0') + QString::number(c, 16);
        } else {
            switch(c) {
            case '\\':
                result += QLatin1String("\\\\"); break;
            case '\"':
                result += QLatin1String("\\\""); break;
            case '\r':
                break;
            case '\n':
                result += QLatin1String("\\n\"+\n\""); break;
            default:
                result += QChar(c);
            }
        }
    }

    return QLatin1String("\"") + result + QLatin1String("\"");
}


QString escapeVariableName(const QString &name)
{
    static QHash<QString, bool> escaped_names;
    if (escaped_names.isEmpty()) {
        escaped_names[QLatin1String("native")] = false;
        escaped_names[QLatin1String("boolean")] = false;
        escaped_names[QLatin1String("abstract")] = false;
        escaped_names[QLatin1String("final")] = false;
    }

    if (escaped_names.contains(name)) {
        bool &reported = escaped_names[name];

        if (!reported) {
            fprintf(stderr, "juic: Variable '%s' renamed to '%s__'\n", qPrintable(name), qPrintable(name));
            reported = true;
        }

        return name + QLatin1String("__");
    }
    return name;
}
