/**
 * This file is a part of Qtpfsgui package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2006,2007 Giuseppe Rota
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author Giuseppe Rota <grota@users.sourceforge.net>
 */

#ifndef TONEMAPPERTHREAD_H
#define TONEMAPPERTHREAD_H

#include <QThread>
#include <QReadWriteLock>
#include <QImage>
#include "../options.h"
#include "../Libpfs/pfs.h"
class QProgressBar;

class TonemapperThread : public QThread {
Q_OBJECT

public:
	TonemapperThread(int origsize, QString cachepath, QProgressBar *itsbar);
	~TonemapperThread();
	//pass by value, bit-copy should be enough (default should be available)
	void ComputeImage(const tonemapping_options opts );

signals:
	void ImageComputed(const QImage&,tonemapping_options *);
	void setMaximumSteps(int);
	void setCurrentProgress(int);
	void removeProgressBar( QProgressBar *pb );

protected:
	void run();

private:
	QProgressBar *bar;
	int originalxsize;
	bool colorspaceconversion;
	tonemapping_options opt;
	pfs::Frame *workingframe;
	void fetch(QString);
	void swap(pfs::Frame *, QString );
// 	void dumpOpts();
	enum {from_resize,from_pregamma,from_tm} status;
	QString cachepath;
	QImage fromLDRPFStoQImage( pfs::Frame* inpfsframe );
};
#endif
