// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_COMMON_ORIGIN_POLICY_ORIGIN_POLICY_H_
#define THIRD_PARTY_BLINK_PUBLIC_COMMON_ORIGIN_POLICY_ORIGIN_POLICY_H_

#include <memory>
#include <string>

#include "base/strings/string_piece.h"
#include "third_party/blink/common/common_export.h"

namespace blink {

class OriginPolicyParser;

class BLINK_COMMON_EXPORT OriginPolicy {
 public:
  ~OriginPolicy();

  // Create & parse the manifest.
  static std::unique_ptr<OriginPolicy> From(base::StringPiece);

  struct CSP {
    std::string policy;
    bool report_only;
  };
  const std::vector<CSP>& GetContentSecurityPolicies() const { return csp_; }

 private:
  friend class OriginPolicyParser;

  OriginPolicy();

  std::vector<CSP> csp_;
};

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_COMMON_ORIGIN_POLICY_ORIGIN_POLICY_H_
