/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.27
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <stdexcept>


#include <ql/quantlib.hpp>

#if QL_HEX_VERSION < 0x000311f0
    #error using an old version of QuantLib, please update
#endif

// add here SWIG version check

#if defined(_MSC_VER)         // Microsoft Visual C++ 6.0
// disable Swig-dependent warnings

// 'identifier1' has C-linkage specified,
// but returns UDT 'identifier2' which is incompatible with C
#pragma warning(disable: 4190)

// 'int' : forcing value to bool 'true' or 'false' (performance warning)
#pragma warning(disable: 4800)

// debug info too long etc etc
#pragma warning(disable: 4786)
#endif


#include <string>


#include <vector>
#include <algorithm>
#include <stdexcept>


#include <map>
#include <algorithm>
#include <stdexcept>


#include <utility>


// generally useful classes
using QuantLib::Error;
using QuantLib::Handle;


using QuantLib::Observer;
using QuantLib::Observable;

static bool boost_shared_ptr_Sl_Observable_Sg__isNull(boost::shared_ptr<Observable > *self){
                return !(*self);
            }

using QuantLib::Integer;
using QuantLib::BigInteger;
using QuantLib::Natural;
using QuantLib::BigNatural;
using QuantLib::Real;
using QuantLib::Decimal;
using QuantLib::Time;
using QuantLib::Rate;
using QuantLib::Spread;
using QuantLib::DiscountFactor;
using QuantLib::Volatility;
using QuantLib::Size;


using QuantLib::Array;
using QuantLib::Matrix;

static std::string Array___str__(Array *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

typedef QuantLib::LexicographicalView<Array::iterator>
    LexicographicalView;
typedef QuantLib::LexicographicalView<Array::iterator>::y_iterator
    LexicographicalViewColumn;

static LexicographicalView *new_LexicographicalView(Array &a,Size xSize){
            return new LexicographicalView(a.begin(),a.end(),xSize);
        }
static std::string LexicographicalView___str__(LexicographicalView *self){
            std::ostringstream s;
            for (Size j=0; j<self->ySize(); j++) {
                s << "\n";
                for (Size i=0; i<self->xSize(); i++) {
                    if (i != 0)
                        s << ",";
                    s << (*self)[i][j];
                }
            }
            s << "\n";
            return s.str();
        }

typedef QuantLib::Matrix::row_iterator MatrixRow;
using QuantLib::outerProduct;
using QuantLib::transpose;
using QuantLib::SVD;

static std::string Matrix___str__(Matrix *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

using QuantLib::pseudoSqrt;
using QuantLib::SalvagingAlgorithm;


using QuantLib::CostFunction;


using QuantLib::Quote;

static bool boost_shared_ptr_Sl_Quote_Sg__isNull(boost::shared_ptr<Quote > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_Quote_Sg__asObservable(boost::shared_ptr<Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static boost::shared_ptr<Observable > Handle_Sl_Quote_Sg__asObservable(Handle<Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SimpleQuote;
typedef boost::shared_ptr<Quote> SimpleQuotePtr;

static SimpleQuotePtr *new_SimpleQuotePtr(Real value){
            return new SimpleQuotePtr(new SimpleQuote(value));
        }
static void SimpleQuotePtr_setValue(SimpleQuotePtr *self,Real value){
            boost::dynamic_pointer_cast<SimpleQuote>(*self)->setValue(value);
        }
static boost::shared_ptr<Quote > &std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__get(std::vector<boost::shared_ptr<Quote > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__set(std::vector<boost::shared_ptr<Quote > > *self,int i,boost::shared_ptr<Quote > const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static Handle<Quote > &std_vector_Sl_Handle_Sl_Quote_Sg__Sg__get(std::vector<Handle<Quote > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__set(std::vector<Handle<Quote > > *self,int i,Handle<Quote > const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::Day;
using QuantLib::Year;


using QuantLib::Weekday;
using QuantLib::Sunday;
using QuantLib::Monday;
using QuantLib::Tuesday;
using QuantLib::Wednesday;
using QuantLib::Thursday;
using QuantLib::Friday;
using QuantLib::Saturday;


using QuantLib::Month;
using QuantLib::January;
using QuantLib::February;
using QuantLib::March;
using QuantLib::April;
using QuantLib::May;
using QuantLib::June;
using QuantLib::July;
using QuantLib::August;
using QuantLib::September;
using QuantLib::October;
using QuantLib::November;
using QuantLib::December;


using QuantLib::TimeUnit;
using QuantLib::Days;
using QuantLib::Weeks;
using QuantLib::Months;
using QuantLib::Years;


using QuantLib::Frequency;
using QuantLib::NoFrequency;
using QuantLib::Once;
using QuantLib::Annual;
using QuantLib::Semiannual;
using QuantLib::EveryFourthMonth;
using QuantLib::Quarterly;
using QuantLib::Bimonthly;
using QuantLib::Monthly;


using QuantLib::Period;
using QuantLib::PeriodParser;

static Period *new_Period__SWIG_1(std::string const &str){
            return new Period(PeriodParser::parse(str));
        }
static std::string Period___str__(Period *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
static std::string Period___repr__(Period *self){
            std::ostringstream out;
            out << "Period(\"" << QuantLib::io::short_period(*self) << "\")";
            return out.str();
        }
static int Period___cmp__(Period *self,Period const &other){
            if (*self < other)
                return -1;
            if (*self == other)
                return 0;
            return 1;
        }
static Period &std_vector_Sl_Period_Sg__get(std::vector<Period > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_Period_Sg__set(std::vector<Period > *self,int i,Period const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::Date;
using QuantLib::DateParser;

static Date *new_Date__SWIG_3(std::string const &str,std::string const &fmt){
            return new Date(DateParser::parse(str,fmt));
        }
static Integer Date_weekdayNumber(Date *self){
            return int(self->weekday());
        }
static std::string Date___str__(Date *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
static std::string Date___repr__(Date *self){
            std::ostringstream out;
            out << "Date(" << self->dayOfMonth() << ","
                << int(self->month()) << "," << self->year() << ")";
            return out.str();
        }
static std::string Date_ISO(Date *self){
            std::ostringstream out;
            out << QuantLib::io::iso_date(*self);
            return out.str();
        }
static Date &std_vector_Sl_Date_Sg__get(std::vector<Date > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_Date_Sg__set(std::vector<Date > *self,int i,Date const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::Null;
typedef int intOrNull;
typedef double doubleOrNull;


int nullInt() { return Null<int>(); }
double nullDouble() { return Null<double>(); }


using QuantLib::DayCounter;

static std::string DayCounter___str__(DayCounter *self){
            return self->name()+" day counter";
        }
static bool DayCounter___eq__(DayCounter *self,DayCounter const &other){
            return (*self) == other;
        }
static bool DayCounter___ne__(DayCounter *self,DayCounter const &other){
            return (*self) != other;
        }

using QuantLib::Compounding;
using QuantLib::Simple;
using QuantLib::Compounded;
using QuantLib::Continuous;
using QuantLib::SimpleThenCompounded;


using QuantLib::InterestRate;

static std::string InterestRate___str__(InterestRate *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

using QuantLib::Calendar;


using QuantLib::BusinessDayConvention;
using QuantLib::Unadjusted;
using QuantLib::Preceding;
using QuantLib::ModifiedPreceding;
using QuantLib::Following;
using QuantLib::ModifiedFollowing;
using QuantLib::MonthEndReference;


using QuantLib::JointCalendarRule;
using QuantLib::JoinHolidays;
using QuantLib::JoinBusinessDays;

static std::string Calendar___str__(Calendar *self){
            return self->name()+" calendar";
        }
static bool Calendar___eq__(Calendar *self,Calendar const &other){
            return (*self) == other;
        }
static bool Calendar___ne__(Calendar *self,Calendar const &other){
            return (*self) != other;
        }

using QuantLib::Rounding;
using QuantLib::UpRounding;
using QuantLib::DownRounding;
using QuantLib::ClosestRounding;
using QuantLib::CeilingTruncation;
using QuantLib::FloorTruncation;


using QuantLib::Currency;

static std::string Currency___str__(Currency *self){
            return self->name();
        }
static bool Currency___eq__(Currency *self,Currency const &other){
            return (*self) == other;
        }
static bool Currency___ne__(Currency *self,Currency const &other){
            return (*self) != other;
        }

using QuantLib::Extrapolator;


// safe versions which copy their arguments
template <class I>
class SafeInterpolation {
  public:
    SafeInterpolation(const Array& x, const Array& y)
    : x_(x), y_(y), f_(x_.begin(),x_.end(),y_.begin()) {}
    Real operator()(Real x, bool allowExtrapolation=false) {
        return f_(x, allowExtrapolation);
    }
    Array x_, y_;
    I f_;
};


typedef SafeInterpolation<QuantLib::LinearInterpolation> SafeLinearInterpolation;


typedef SafeInterpolation<QuantLib::LogLinearInterpolation> SafeLogLinearInterpolation;


typedef SafeInterpolation<QuantLib::BackwardFlatInterpolation> SafeBackwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::ForwardFlatInterpolation> SafeForwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::NaturalCubicSpline> SafeNaturalCubicSpline;

static Real SafeNaturalCubicSpline_derivative__SWIG_0(SafeNaturalCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
static Real SafeNaturalCubicSpline_secondDerivative__SWIG_0(SafeNaturalCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::NaturalMonotonicCubicSpline> SafeNaturalMonotonicCubicSpline;

static Real SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
static Real SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }

// safe versions which copy their arguments
template <class I>
class SafeInterpolation2D {
  public:
    SafeInterpolation2D(const Array& x, const Array& y, const Matrix& m)
    : x_(x), y_(y), m_(m), f_(x_.begin(),x_.end(),y_.begin(),y_.end(),m_) {}
    Real operator()(Real x, Real y, bool allowExtrapolation=false) {
        return f_(x,y, allowExtrapolation);
    }
  protected:
    Array x_, y_;
    Matrix m_;
    I f_;
};


typedef SafeInterpolation2D<QuantLib::BilinearInterpolation> SafeBilinearInterpolation;


typedef SafeInterpolation2D<QuantLib::BicubicSpline> SafeBicubicSpline;


using QuantLib::YieldTermStructure;

static bool boost_shared_ptr_Sl_YieldTermStructure_Sg__isNull(boost::shared_ptr<YieldTermStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_YieldTermStructure_Sg__asObservable(boost::shared_ptr<YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static boost::shared_ptr<Observable > Handle_Sl_YieldTermStructure_Sg__asObservable(Handle<YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::ImpliedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ImpliedTermStructurePtr;

static ImpliedTermStructurePtr *new_ImpliedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Date const &referenceDate){
            return new ImpliedTermStructurePtr(
                new ImpliedTermStructure(curveHandle, referenceDate));
        }

using QuantLib::ZeroSpreadedTermStructure;
using QuantLib::ForwardSpreadedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ZeroSpreadedTermStructurePtr;
typedef boost::shared_ptr<YieldTermStructure> ForwardSpreadedTermStructurePtr;

static ZeroSpreadedTermStructurePtr *new_ZeroSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
	        return new ZeroSpreadedTermStructurePtr(
	            new ZeroSpreadedTermStructure(curveHandle,spreadHandle));
        }
static ForwardSpreadedTermStructurePtr *new_ForwardSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
	        return new ForwardSpreadedTermStructurePtr(
	            new ForwardSpreadedTermStructure(curveHandle,spreadHandle));
        }

using QuantLib::FlatForward;
typedef boost::shared_ptr<YieldTermStructure> FlatForwardPtr;

static FlatForwardPtr *new_FlatForwardPtr__SWIG_0(Date const &referenceDate,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
static FlatForwardPtr *new_FlatForwardPtr__SWIG_3(Date const &referenceDate,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
static FlatForwardPtr *new_FlatForwardPtr__SWIG_6(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }
static FlatForwardPtr *new_FlatForwardPtr__SWIG_9(Integer settlementDays,Calendar const &calendar,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }

using QuantLib::BlackModel;

static bool boost_shared_ptr_Sl_BlackModel_Sg__isNull(boost::shared_ptr<BlackModel > *self){
                return !(*self);
            }
static boost::shared_ptr<BlackModel > *new_boost_shared_ptr_Sl_BlackModel_Sg_(Handle<Quote > const &volatility,Handle<YieldTermStructure > const &termStructure){
        return new boost::shared_ptr<BlackModel>(
            new BlackModel(volatility,termStructure));
    }

using QuantLib::PricingEngine;

static bool boost_shared_ptr_Sl_PricingEngine_Sg__isNull(boost::shared_ptr<PricingEngine > *self){
                return !(*self);
            }

using QuantLib::Instrument;

static bool boost_shared_ptr_Sl_Instrument_Sg__isNull(boost::shared_ptr<Instrument > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_Instrument_Sg__asObservable(boost::shared_ptr<Instrument > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::Stock;
typedef boost::shared_ptr<Instrument> StockPtr;

static StockPtr *new_StockPtr(Handle<Quote > const &quote){
            return new StockPtr(new Stock(quote));
        }
static int std_vector_Sl_int_Sg__get(std::vector<int > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_int_Sg__set(std::vector<int > *self,int i,int x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static double std_vector_Sl_double_Sg__get(std::vector<double > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_double_Sg__set(std::vector<double > *self,int i,double x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static std::string std_vector_Sl_std_string_Sg__get(std::vector<std::string > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_std_string_Sg__set(std::vector<std::string > *self,int i,std::string x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::History;
typedef History::Entry HistoryEntry;

static Size History___len__(History *self){
            return self->size();
        }

using QuantLib::IndexManager;


using QuantLib::Index;

static bool boost_shared_ptr_Sl_Index_Sg__isNull(boost::shared_ptr<Index > *self){
                return !(*self);
            }
static std::string boost_shared_ptr_Sl_Index_Sg____str__(boost::shared_ptr<Index > *self){
        if (*self)
            return (*self)->name()+" index";
        else
            return "Null index";
    }

using QuantLib::Xibor;
typedef boost::shared_ptr<Index> XiborPtr;

static XiborPtr *new_XiborPtr(std::string const &familyName,Integer n,TimeUnit units,Integer settlementDays,Currency const &currency,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Handle<YieldTermStructure > const &h){
            return new XiborPtr(new Xibor(familyName, n, units, settlementDays,
                                          currency, calendar, convention,
                                          dayCounter, h));
        }
static Period XiborPtr_tenor(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->tenor();
        }
static Frequency XiborPtr_frequency(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->frequency();
        }
static Currency XiborPtr_currency(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->currency();
        }
static Calendar XiborPtr_calendar(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->calendar();
        }
static bool XiborPtr_isAdjusted(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->isAdjusted();
        }
static BusinessDayConvention XiborPtr_businessDayConvention(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)
                 ->businessDayConvention();
        }
static DayCounter XiborPtr_dayCounter(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->dayCounter();
        }

using QuantLib::AUDLibor;
typedef boost::shared_ptr<Index> AUDLiborPtr;

static AUDLiborPtr *new_AUDLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new AUDLiborPtr(new AUDLibor(n,units,h,dayCount));
      }

using QuantLib::CADLibor;
typedef boost::shared_ptr<Index> CADLiborPtr;

static CADLiborPtr *new_CADLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new CADLiborPtr(new CADLibor(n,units,h,dayCount));
      }

using QuantLib::Cdor;
typedef boost::shared_ptr<Index> CdorPtr;

static CdorPtr *new_CdorPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new CdorPtr(new Cdor(n,units,h,dayCount));
      }

using QuantLib::CHFLibor;
typedef boost::shared_ptr<Index> CHFLiborPtr;

static CHFLiborPtr *new_CHFLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new CHFLiborPtr(new CHFLibor(n,units,h,dayCount));
      }

using QuantLib::Euribor;
typedef boost::shared_ptr<Index> EuriborPtr;

static EuriborPtr *new_EuriborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new EuriborPtr(new Euribor(n,units,h,dayCount));
      }

using QuantLib::GBPLibor;
typedef boost::shared_ptr<Index> GBPLiborPtr;

static GBPLiborPtr *new_GBPLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual365Fixed()){
          return new GBPLiborPtr(new GBPLibor(n,units,h,dayCount));
      }

using QuantLib::Jibar;
typedef boost::shared_ptr<Index> JibarPtr;

static JibarPtr *new_JibarPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual365Fixed()){
          return new JibarPtr(new Jibar(n,units,h,dayCount));
      }

using QuantLib::JPYLibor;
typedef boost::shared_ptr<Index> JPYLiborPtr;

static JPYLiborPtr *new_JPYLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new JPYLiborPtr(new JPYLibor(n,units,h,dayCount));
      }

using QuantLib::Tibor;
typedef boost::shared_ptr<Index> TiborPtr;

static TiborPtr *new_TiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual365Fixed()){
          return new TiborPtr(new Tibor(n,units,h,dayCount));
      }

using QuantLib::TRLibor;
typedef boost::shared_ptr<Index> TRLiborPtr;

static TRLiborPtr *new_TRLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new TRLiborPtr(new TRLibor(n,units,h,dayCount));
      }

using QuantLib::USDLibor;
typedef boost::shared_ptr<Index> USDLiborPtr;

static USDLiborPtr *new_USDLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new USDLiborPtr(new USDLibor(n,units,h,dayCount));
      }

using QuantLib::Zibor;
typedef boost::shared_ptr<Index> ZiborPtr;

static ZiborPtr *new_ZiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new ZiborPtr(new Zibor(n,units,h,dayCount));
      }

using QuantLib::Schedule;


using QuantLib::CashFlow;

static bool boost_shared_ptr_Sl_CashFlow_Sg__isNull(boost::shared_ptr<CashFlow > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_CashFlow_Sg__asObservable(boost::shared_ptr<CashFlow > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SimpleCashFlow;
using QuantLib::FixedRateCoupon;
using QuantLib::ParCoupon;
typedef boost::shared_ptr<CashFlow> SimpleCashFlowPtr;
typedef boost::shared_ptr<CashFlow> FixedRateCouponPtr;
typedef boost::shared_ptr<CashFlow> ParCouponPtr;

static SimpleCashFlowPtr *new_SimpleCashFlowPtr(Real amount,Date const &date){
            return new SimpleCashFlowPtr(new SimpleCashFlow(amount,date));
        }
static FixedRateCouponPtr *new_FixedRateCouponPtr__SWIG_0(Real nominal,Date const &paymentDate,Rate rate,DayCounter const &dayCounter,Date const &startDate,Date const &endDate,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date()){
            return new FixedRateCouponPtr(
                new FixedRateCoupon(nominal, paymentDate, rate,
                                    dayCounter, startDate, endDate,
                                    refPeriodStart, refPeriodEnd));
        }
static ParCouponPtr *new_ParCouponPtr__SWIG_0(Real nominal,Date const &paymentDate,XiborPtr const &index,Date const &startDate,Date const &endDate,Integer fixingDays,Spread spread=0.0,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date()){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new ParCouponPtr(
                new ParCoupon(nominal, paymentDate, libor,
                              startDate, endDate, fixingDays, spread,
                              refPeriodStart, refPeriodEnd));
        }
static Date ParCouponPtr_accrualStartDate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                 ->accrualStartDate();
        }
static Date ParCouponPtr_accrualEndDate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                 ->accrualEndDate();
        }
static Rate ParCouponPtr_rate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)->rate();
        }
static Rate ParCouponPtr_indexFixing(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                ->indexFixing();
        }
static Real ParCouponPtr_nominal(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)->nominal();
        }
static boost::shared_ptr<CashFlow > &std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__get(std::vector<boost::shared_ptr<CashFlow > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__set(std::vector<boost::shared_ptr<CashFlow > > *self,int i,boost::shared_ptr<CashFlow > const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::FixedRateCouponVector;


std::vector<boost::shared_ptr<CashFlow> >
FloatingRateCouponVector(const Schedule& schedule,
                         BusinessDayConvention paymentAdjustment,
                         const std::vector<Real>& nominals,
                         const XiborPtr& index, Integer fixingDays,
                         const std::vector<Spread>& spreads =
                             std::vector<Spread>()) {
    boost::shared_ptr<Xibor> libor =
        boost::dynamic_pointer_cast<Xibor>(index);
    return QuantLib::FloatingRateCouponVector(schedule,paymentAdjustment,
                                              nominals,libor,
                                              fixingDays,spreads);
}


using QuantLib::Cashflows;
using QuantLib::Duration;


using QuantLib::Bond;
using QuantLib::ZeroCouponBond;
using QuantLib::FixedCouponBond;
using QuantLib::FloatingRateBond;
typedef boost::shared_ptr<Instrument> BondPtr;
typedef boost::shared_ptr<Instrument> ZeroCouponBondPtr;
typedef boost::shared_ptr<Instrument> FixedCouponBondPtr;
typedef boost::shared_ptr<Instrument> FloatingRateBondPtr;

static Date BondPtr_settlementDate(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->settlementDate();
        }
static std::vector<boost::shared_ptr<CashFlow > > BondPtr_cashflows(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cashflows();
        }
static boost::shared_ptr<CashFlow > BondPtr_redemption(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->redemption();
        }
static Calendar BondPtr_calendar(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->calendar();
        }
static BusinessDayConvention BondPtr_businessDayConvention(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->businessDayConvention();
        }
static DayCounter BondPtr_dayCounter(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->dayCounter();
        }
static Frequency BondPtr_frequency(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->frequency();
        }
static Real BondPtr_cleanPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cleanPrice();
        }
static Real BondPtr_cleanPrice__SWIG_1(BondPtr *self,Rate yield,Compounding compounding,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->cleanPrice(yield,compounding,settlement);
        }
static Real BondPtr_dirtyPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->dirtyPrice();
        }
static Real BondPtr_dirtyPrice__SWIG_1(BondPtr *self,Rate yield,Compounding compounding,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->dirtyPrice(yield,compounding,settlement);
        }
static Real BondPtr_yield__SWIG_0(BondPtr *self,Compounding compounding,Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(compounding,accuracy,maxEvaluations);
        }
static Real BondPtr_yield__SWIG_3(BondPtr *self,Real cleanPrice,Compounding compounding,Date const &settlement=Date(),Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(cleanPrice,compounding,settlement,
                        accuracy,maxEvaluations);
        }
static Real BondPtr_accruedAmount__SWIG_0(BondPtr *self,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->accruedAmount(settlement);
        }
static ZeroCouponBondPtr *new_ZeroCouponBondPtr__SWIG_0(Date const &issueDate,Date const &maturityDate,Integer settlementDays,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention convention=QuantLib::Following,Real redemption=100.0,Handle<YieldTermStructure > const &discountCurve=Handle<YieldTermStructure >()){
            return new ZeroCouponBondPtr(
                new ZeroCouponBond(issueDate, maturityDate, settlementDays,
                                   dayCounter, calendar, convention,
                                   redemption, discountCurve));
        }
static FixedCouponBondPtr *new_FixedCouponBondPtr__SWIG_0(Date const &issueDate,Date const &datedDate,Date const &maturityDate,Integer settlementDays,std::vector<Rate > const &coupons,Frequency couponFrequency,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention convention=QuantLib::Following,Real redemption=100.0,Handle<YieldTermStructure > const &discountCurve=Handle<YieldTermStructure >(),Date const &stub=Date(),bool fromEnd=true){
            return new FixedCouponBondPtr(
                new FixedCouponBond(issueDate, datedDate, maturityDate,
                                    settlementDays, coupons, couponFrequency,
                                    dayCounter, calendar, convention,
                                    redemption, discountCurve, stub, fromEnd));
        }
static FloatingRateBondPtr *new_FloatingRateBondPtr__SWIG_0(Date const &issueDate,Date const &datedDate,Date const &maturityDate,Integer settlementDays,XiborPtr const &index,Integer fixingDays,std::vector<Spread > const &spreads,Frequency couponFrequency,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention convention=QuantLib::Following,Real redemption=100.0,Handle<YieldTermStructure > const &discountCurve=Handle<YieldTermStructure >(),Date const &stub=Date(),bool fromEnd=true){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new FloatingRateBondPtr(
                new FloatingRateBond(issueDate, datedDate, maturityDate,
                                     settlementDays, libor, fixingDays,
                                     spreads, couponFrequency,
                                     dayCounter, calendar, convention,
                                     redemption, discountCurve,
                                     stub, fromEnd));
        }

using QuantLib::Exercise;
typedef Exercise::Type ExerciseType;

Exercise::Type exerciseTypeFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "e" || s == "european")
        return Exercise::European;
    else if (s == "a" || s == "american")
        return Exercise::American;
    else if (s == "b" || s == "bermudan")
        return Exercise::Bermudan;
    else
        QL_FAIL("unknown exercise type: "+s);
}

std::string exerciseTypeToString(Exercise::Type t) {
    switch (t) {
      case Exercise::European:
        return "European";
      case Exercise::American:
        return "American";
      case Exercise::Bermudan:
        return "Bermudan";
      default:
        QL_FAIL("unknown exercise type");
    }
}

static bool boost_shared_ptr_Sl_Exercise_Sg__isNull(boost::shared_ptr<Exercise > *self){
                return !(*self);
            }

using QuantLib::EuropeanExercise;
using QuantLib::AmericanExercise;
using QuantLib::BermudanExercise;
typedef boost::shared_ptr<Exercise> EuropeanExercisePtr;
typedef boost::shared_ptr<Exercise> AmericanExercisePtr;
typedef boost::shared_ptr<Exercise> BermudanExercisePtr;

static EuropeanExercisePtr *new_EuropeanExercisePtr(Date const &date){
            return new EuropeanExercisePtr(new EuropeanExercise(date));
        }
static AmericanExercisePtr *new_AmericanExercisePtr__SWIG_0(Date const &earliestDate,Date const &latestDate,bool payoffAtExpiry=false){
            return new AmericanExercisePtr(
                                        new AmericanExercise(earliestDate,
                                                             latestDate,
                                                             payoffAtExpiry));
        }
static BermudanExercisePtr *new_BermudanExercisePtr__SWIG_0(std::vector<Date > const &dates,bool payoffAtExpiry=false){
            return new BermudanExercisePtr(
                                        new BermudanExercise(dates,
                                                             payoffAtExpiry));
        }

using QuantLib::BlackVolTermStructure;
using QuantLib::LocalVolTermStructure;

static bool boost_shared_ptr_Sl_BlackVolTermStructure_Sg__isNull(boost::shared_ptr<BlackVolTermStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_BlackVolTermStructure_Sg__asObservable(boost::shared_ptr<BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static boost::shared_ptr<Observable > Handle_Sl_BlackVolTermStructure_Sg__asObservable(Handle<BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static bool boost_shared_ptr_Sl_LocalVolTermStructure_Sg__isNull(boost::shared_ptr<LocalVolTermStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_LocalVolTermStructure_Sg__asObservable(boost::shared_ptr<LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static boost::shared_ptr<Observable > Handle_Sl_LocalVolTermStructure_Sg__asObservable(Handle<LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::BlackConstantVol;
typedef boost::shared_ptr<BlackVolTermStructure> BlackConstantVolPtr;

static BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, volatility, dayCounter));
        }
static BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, volatility, dayCounter));
        }
static BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
static BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

using QuantLib::BlackVarianceSurface;
typedef BlackVarianceSurface::Extrapolation VolExtrapolationType;
typedef boost::shared_ptr<BlackVolTermStructure> BlackVarianceSurfacePtr;

VolExtrapolationType volExTypeFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "const" || s == "constant")
        return BlackVarianceSurface::ConstantExtrapolation;
    else if (s == "" || s == "default")
        return BlackVarianceSurface::InterpolatorDefaultExtrapolation;
    else
        QL_FAIL("unknown extrapolation type: "+s);
}

std::string volExTypeToString(VolExtrapolationType t) {
    switch (t) {
      case BlackVarianceSurface::ConstantExtrapolation:
        return "constant";
      case BlackVarianceSurface::InterpolatorDefaultExtrapolation:
        return "default";
      default:
        QL_FAIL("unknown extrapolation type");
    }
}

static BlackVarianceSurfacePtr *new_BlackVarianceSurfacePtr__SWIG_0(Date const &referenceDate,std::vector<Date > const &dates,std::vector<Real > const &strikes,Matrix const &blackVols,DayCounter const &dayCounter,VolExtrapolationType lower=BlackVarianceSurface::InterpolatorDefaultExtrapolation,VolExtrapolationType upper=BlackVarianceSurface::InterpolatorDefaultExtrapolation){
            return new BlackVarianceSurfacePtr(
                new BlackVarianceSurface(referenceDate,dates,strikes,
                                         blackVols,dayCounter,lower,upper));
        }

using QuantLib::LocalConstantVol;
typedef boost::shared_ptr<LocalVolTermStructure> LocalConstantVolPtr;

static LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
static LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
static LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
static LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

using QuantLib::GenericStochasticProcess;

static bool boost_shared_ptr_Sl_GenericStochasticProcess_Sg__isNull(boost::shared_ptr<GenericStochasticProcess > *self){
                return !(*self);
            }

using QuantLib::StochasticProcess1D;
typedef boost::shared_ptr<GenericStochasticProcess> StochasticProcess1DPtr;


using QuantLib::BlackScholesProcess;
typedef boost::shared_ptr<GenericStochasticProcess> BlackScholesProcessPtr;

static BlackScholesProcessPtr *new_BlackScholesProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new BlackScholesProcessPtr(
                              new BlackScholesProcess(s0, dividendTS,
                                                      riskFreeTS, volTS));
      }

using QuantLib::Merton76Process;
typedef boost::shared_ptr<GenericStochasticProcess> Merton76ProcessPtr;

static Merton76ProcessPtr *new_Merton76ProcessPtr(Handle<Quote > const &stateVariable,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS,Handle<Quote > const &jumpIntensity,Handle<Quote > const &meanLogJump,Handle<Quote > const &jumpVolatility){
            return new Merton76ProcessPtr(
                              new Merton76Process(stateVariable, dividendTS,
                                                  riskFreeTS, volTS,
                                                  jumpIntensity, meanLogJump,
                                                  jumpVolatility));
      }
static StochasticProcess1DPtr &std_vector_Sl_StochasticProcess1DPtr_Sg__get(std::vector<StochasticProcess1DPtr > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_StochasticProcess1DPtr_Sg__set(std::vector<StochasticProcess1DPtr > *self,int i,StochasticProcess1DPtr const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::Option;
using QuantLib::Barrier;


using QuantLib::Payoff;
using QuantLib::StrikedTypePayoff;

static bool boost_shared_ptr_Sl_Payoff_Sg__isNull(boost::shared_ptr<Payoff > *self){
                return !(*self);
            }

using QuantLib::VanillaOption;
typedef boost::shared_ptr<Instrument> VanillaOptionPtr;

static VanillaOptionPtr *new_VanillaOptionPtr__SWIG_0(boost::shared_ptr<GenericStochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new VanillaOptionPtr(
                         new VanillaOption(process,stPayoff,exercise,engine));
        }
static Real VanillaOptionPtr_delta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->delta();
        }
static Real VanillaOptionPtr_gamma(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->gamma();
        }
static Real VanillaOptionPtr_theta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->theta();
        }
static Real VanillaOptionPtr_vega(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->vega();
        }
static Real VanillaOptionPtr_rho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->rho();
        }
static Real VanillaOptionPtr_dividendRho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->dividendRho();
        }
static Real VanillaOptionPtr_strikeSensitivity(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->strikeSensitivity();
        }
static Volatility VanillaOptionPtr_impliedVolatility__SWIG_0(VanillaOptionPtr *self,Real targetValue,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }

using QuantLib::EuropeanOption;
typedef boost::shared_ptr<Instrument> EuropeanOptionPtr;

static EuropeanOptionPtr *new_EuropeanOptionPtr__SWIG_0(boost::shared_ptr<GenericStochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new EuropeanOptionPtr(
                        new EuropeanOption(process,stPayoff,exercise,engine));
        }

using QuantLib::AnalyticEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticEuropeanEnginePtr;

static AnalyticEuropeanEnginePtr *new_AnalyticEuropeanEnginePtr(){
            return new AnalyticEuropeanEnginePtr(new AnalyticEuropeanEngine);
        }

using QuantLib::IntegralEngine;
typedef boost::shared_ptr<PricingEngine> IntegralEnginePtr;

static IntegralEnginePtr *new_IntegralEnginePtr(){
            return new IntegralEnginePtr(new IntegralEngine);
        }

using QuantLib::FDEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> FDEuropeanEnginePtr;

static FDEuropeanEnginePtr *new_FDEuropeanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDEuropeanEnginePtr(
                    new FDEuropeanEngine(timeSteps,gridPoints,timeDependent));
        }

using QuantLib::BinomialVanillaEngine;
using QuantLib::CoxRossRubinstein;
using QuantLib::JarrowRudd;
using QuantLib::AdditiveEQPBinomialTree;
using QuantLib::Trigeorgis;
using QuantLib::Tian;
using QuantLib::LeisenReimer;
typedef boost::shared_ptr<PricingEngine> BinomialVanillaEnginePtr;

static BinomialVanillaEnginePtr *new_BinomialVanillaEnginePtr(std::string const &type,Size steps){
            std::string s = QuantLib::lowercase(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<CoxRossRubinstein>(steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<JarrowRudd>(steps));
            else if (s == "eqp")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<AdditiveEQPBinomialTree>(steps));
            else if (s == "trigeorgis")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Trigeorgis>(steps));
            else if (s == "tian")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Tian>(steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<LeisenReimer>(steps));
            else
                QL_FAIL("unknown binomial engine type: "+s);
        }

using QuantLib::MCEuropeanEngine;
using QuantLib::PseudoRandom;
using QuantLib::LowDiscrepancy;
typedef boost::shared_ptr<PricingEngine> MCEuropeanEnginePtr;

static MCEuropeanEnginePtr *new_MCEuropeanEnginePtr(std::string const &traits,intOrNull timeSteps=Null<Size >(),intOrNull timeStepsPerYear=Null<Size >(),bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null<Size >(),doubleOrNull requiredTolerance=Null<Real >(),intOrNull maxSamples=Null<Size >(),BigInteger seed=0){
            std::string s = QuantLib::lowercase(traits);
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            if (s == "pseudorandom" || s == "pr")
                return new MCEuropeanEnginePtr(
                         new MCEuropeanEngine<PseudoRandom>(timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCEuropeanEnginePtr(
                       new MCEuropeanEngine<LowDiscrepancy>(timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::FDAmericanEngine;
using QuantLib::FDShoutEngine;
typedef boost::shared_ptr<PricingEngine> FDAmericanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDShoutEnginePtr;

static FDAmericanEnginePtr *new_FDAmericanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDAmericanEnginePtr(
                    new FDAmericanEngine(timeSteps,gridPoints,timeDependent));
        }
static FDShoutEnginePtr *new_FDShoutEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDShoutEnginePtr(
                       new FDShoutEngine(timeSteps,gridPoints,timeDependent));
        }

using QuantLib::BaroneAdesiWhaleyApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BaroneAdesiWhaleyApproximationEnginePtr;

static BaroneAdesiWhaleyApproximationEnginePtr *new_BaroneAdesiWhaleyApproximationEnginePtr(){
            return new BaroneAdesiWhaleyApproximationEnginePtr(
                new BaroneAdesiWhaleyApproximationEngine);
        }

using QuantLib::BjerksundStenslandApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BjerksundStenslandApproximationEnginePtr;

static BjerksundStenslandApproximationEnginePtr *new_BjerksundStenslandApproximationEnginePtr(){
            return new BjerksundStenslandApproximationEnginePtr(
                new BjerksundStenslandApproximationEngine);
        }

using QuantLib::AnalyticDigitalAmericanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDigitalAmericanEnginePtr;

static AnalyticDigitalAmericanEnginePtr *new_AnalyticDigitalAmericanEnginePtr(){
            return new AnalyticDigitalAmericanEnginePtr(
                new AnalyticDigitalAmericanEngine);
        }

using QuantLib::DividendVanillaOption;
typedef boost::shared_ptr<Instrument> DividendVanillaOptionPtr;

static DividendVanillaOptionPtr *new_DividendVanillaOptionPtr__SWIG_0(boost::shared_ptr<GenericStochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,std::vector<Date > const &dividendDates,std::vector<Real > const &dividends,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new DividendVanillaOptionPtr(
                   new DividendVanillaOption(process,stPayoff,exercise,
                                             dividendDates,dividends,engine));
        }
static Real DividendVanillaOptionPtr_delta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->delta();
        }
static Real DividendVanillaOptionPtr_gamma(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->gamma();
        }
static Real DividendVanillaOptionPtr_theta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->theta();
        }
static Real DividendVanillaOptionPtr_vega(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->vega();
        }
static Real DividendVanillaOptionPtr_rho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->rho();
        }
static Real DividendVanillaOptionPtr_dividendRho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->dividendRho();
        }
static Real DividendVanillaOptionPtr_strikeSensitivity(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->strikeSensitivity();
        }
static Volatility DividendVanillaOptionPtr_impliedVolatility__SWIG_0(DividendVanillaOptionPtr *self,Real targetValue,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }

using QuantLib::AnalyticDividendEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDividendEuropeanEnginePtr;

static AnalyticDividendEuropeanEnginePtr *new_AnalyticDividendEuropeanEnginePtr(){
            return new AnalyticDividendEuropeanEnginePtr(
                new AnalyticDividendEuropeanEngine);
        }

using QuantLib::FDDividendEuropeanEngine;
using QuantLib::FDDividendAmericanEngine;
typedef boost::shared_ptr<PricingEngine> FDDividendEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDDividendAmericanEnginePtr;

static FDDividendEuropeanEnginePtr *new_FDDividendEuropeanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDDividendEuropeanEnginePtr(
                new FDDividendEuropeanEngine(timeSteps,gridPoints,
                                             timeDependent));
        }
static FDDividendAmericanEnginePtr *new_FDDividendAmericanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDDividendAmericanEnginePtr(
                new FDDividendAmericanEngine(timeSteps,gridPoints,
                                             timeDependent));
        }

using QuantLib::BarrierOption;
typedef boost::shared_ptr<Instrument> BarrierOptionPtr;

static BarrierOptionPtr *new_BarrierOptionPtr__SWIG_0(Barrier::Type barrierType,Real barrier,Real rebate,boost::shared_ptr<GenericStochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new BarrierOptionPtr(
                         new BarrierOption(barrierType, barrier, rebate,
                                           process,stPayoff,exercise,engine));
        }
static Real BarrierOptionPtr_errorEstimate(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->errorEstimate();
        }
static Real BarrierOptionPtr_delta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->delta();
        }
static Real BarrierOptionPtr_gamma(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->gamma();
        }
static Real BarrierOptionPtr_theta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->theta();
        }
static Real BarrierOptionPtr_vega(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->vega();
        }
static Real BarrierOptionPtr_rho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->rho();
        }
static Real BarrierOptionPtr_dividendRho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->dividendRho();
        }
static Real BarrierOptionPtr_strikeSensitivity(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->strikeSensitivity();
        }
static Volatility BarrierOptionPtr_impliedVolatility__SWIG_0(BarrierOptionPtr *self,Real targetValue,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }

using QuantLib::AnalyticBarrierEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticBarrierEnginePtr;

static AnalyticBarrierEnginePtr *new_AnalyticBarrierEnginePtr(){
            return new AnalyticBarrierEnginePtr(new AnalyticBarrierEngine);
        }

using QuantLib::Cap;
using QuantLib::Floor;
using QuantLib::Collar;
typedef boost::shared_ptr<Instrument> CapPtr;
typedef boost::shared_ptr<Instrument> FloorPtr;
typedef boost::shared_ptr<Instrument> CollarPtr;

static CapPtr *new_CapPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new CapPtr(new Cap(leg,capRates,h,engine));
        }
static FloorPtr *new_FloorPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &floorRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new FloorPtr(new Floor(leg,floorRates,h,engine));
        }
static CollarPtr *new_CollarPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates,std::vector<Rate > const &floorRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new CollarPtr(new Collar(leg,capRates,floorRates,h,engine));
        }

using QuantLib::BlackCapFloorEngine;
typedef boost::shared_ptr<PricingEngine> BlackCapFloorEnginePtr;

static BlackCapFloorEnginePtr *new_BlackCapFloorEnginePtr(boost::shared_ptr<BlackModel > const &model){
            return new BlackCapFloorEnginePtr(new BlackCapFloorEngine(model));
        }

using QuantLib::CompoundForward;
typedef boost::shared_ptr<YieldTermStructure> CompoundForwardPtr;

static CompoundForwardPtr *new_CompoundForwardPtr(Date const &settlementDate,std::vector<Date > const &dates,std::vector<Rate > const &rates,Calendar calendar,BusinessDayConvention roll,Integer compounding,DayCounter const &dayCounter){
	        return new CompoundForwardPtr(
                new CompoundForward(settlementDate,
                                    dates, rates, calendar, roll,
                                    compounding, dayCounter));
        }
static std::vector<Date > const &CompoundForwardPtr_dates(CompoundForwardPtr *self){
            return boost::dynamic_pointer_cast<CompoundForward>(*self)
                 ->dates();
        }

using QuantLib::DiscountCurve;
using QuantLib::ExtendedDiscountCurve;
typedef boost::shared_ptr<YieldTermStructure> DiscountCurvePtr;
typedef boost::shared_ptr<YieldTermStructure> ExtendedDiscountCurvePtr;

static DiscountCurvePtr *new_DiscountCurvePtr(std::vector<Date > const &dates,std::vector<DiscountFactor > const &discounts,DayCounter const &dayCounter){
            return new DiscountCurvePtr(
                             new DiscountCurve(dates, discounts, dayCounter));
        }
static std::vector<Date > const &DiscountCurvePtr_dates(DiscountCurvePtr *self){
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->dates();
        }
static ExtendedDiscountCurvePtr *new_ExtendedDiscountCurvePtr(std::vector<Date > const &dates,std::vector<DiscountFactor > const &discounts,Calendar const &calendar,BusinessDayConvention roll,DayCounter const &dayCounter){
            return new ExtendedDiscountCurvePtr(
                new ExtendedDiscountCurve(dates, discounts,
                                          calendar, roll, dayCounter));
        }

using QuantLib::NormalDistribution;
using QuantLib::CumulativeNormalDistribution;
using QuantLib::MoroInverseCumulativeNormal;
using QuantLib::InverseCumulativeNormal;


using QuantLib::Money;

static Money Money_operator_Sa___SWIG_1(Money *self,Money const &m){ return *self+m; }
static Money Money_operator_Ss___SWIG_1(Money *self,Money const &m){ return *self-m; }
static Money Money_operator_Sm_(Money *self,Decimal x){ return *self*x; }
static Money Money_operator_Sd___SWIG_0(Money *self,Decimal x){ return *self/x; }
static Decimal Money_operator_Sd___SWIG_1(Money *self,Money const &m){ return *self/m; }
static int Money___cmp__(Money *self,Money const &other){
            if (*self < other)
                return -1;
            else if (*self == other)
                return 0;
            else
                return 1;
        }
static std::string Money___str__(Money *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
static void Money_setConversionType(Money::ConversionType type){
            Money::conversionType = type;
        }
static void Money_setBaseCurrency(Currency const &c){
            Money::baseCurrency = c;
        }

using QuantLib::ExchangeRate;
using QuantLib::ExchangeRateManager;


using QuantLib::TimeGrid;

static TimeGrid *new_TimeGrid__SWIG_2(std::vector<Time > const &times){
            return new TimeGrid(times.begin(), times.end());
        }
static TimeGrid *new_TimeGrid__SWIG_3(std::vector<Time > const &times,Size steps){
            return new TimeGrid(times.begin(), times.end(), steps);
        }
static Time TimeGrid_ref(TimeGrid *self,Size i){
            if (i<self->size())
                return (*self)[i];
            else
                throw std::out_of_range("time-grid index out of range");
            QL_DUMMY_RETURN(0.0)
        }
static Time TimeGrid_dt(TimeGrid *self,Size i){
            if (i<self->size())
                return self->dt(i);
            else
                throw std::out_of_range("time-grid index out of range");
            QL_DUMMY_RETURN(0.0)
        }

using QuantLib::SegmentIntegral;
using QuantLib::TrapezoidIntegral;
using QuantLib::SimpsonIntegral;
using QuantLib::KronrodIntegral;


using QuantLib::Sample;

using QuantLib::LecuyerUniformRng;
using QuantLib::KnuthUniformRng;
using QuantLib::MersenneTwisterUniformRng;

typedef QuantLib::PseudoRandom::urng_type UniformRandomGenerator;

using QuantLib::CLGaussianRng;
using QuantLib::BoxMullerGaussianRng;
using QuantLib::InverseCumulativeRng;

typedef QuantLib::PseudoRandom::rng_type GaussianRandomGenerator;

using QuantLib::RandomSequenceGenerator;

typedef QuantLib::PseudoRandom::ursg_type UniformRandomSequenceGenerator;

using QuantLib::HaltonRsg;
using QuantLib::SobolRsg;

typedef QuantLib::LowDiscrepancy::ursg_type
    UniformLowDiscrepancySequenceGenerator;

using QuantLib::InverseCumulativeRsg;

typedef QuantLib::PseudoRandom::rsg_type GaussianRandomSequenceGenerator;
typedef QuantLib::LowDiscrepancy::rsg_type
    GaussianLowDiscrepancySequenceGenerator;

static Real Sample_Sl_Real_Sg__value(Sample<Real > *self){ return self->value; }
static Real Sample_Sl_Real_Sg__weight(Sample<Real > *self){ return self->weight; }
static Array Sample_Sl_Array_Sg__value(Sample<Array > *self){ return self->value; }
static Real Sample_Sl_Array_Sg__weight(Sample<Array > *self){ return self->weight; }

Matrix getCovariance(const Array& volatilities, const Matrix& correlations) {
    return QuantLib::getCovariance(volatilities.begin(),
                                   volatilities.end(),
                                   correlations);
}


using QuantLib::Path;


typedef QuantLib::SingleAsset<PseudoRandom>::path_generator_type
    GaussianPathGenerator;

static Path Sample_Sl_Path_Sg__value(Sample<Path > *self){ return self->value; }
static Real Sample_Sl_Path_Sg__weight(Sample<Path > *self){ return self->weight; }
static GaussianPathGenerator *new_GaussianPathGenerator(StochasticProcess1DPtr const &process,Time length,Size steps,GaussianRandomSequenceGenerator const &rsg,bool brownianBridge){
            boost::shared_ptr<StochasticProcess1D> process1d =
                boost::dynamic_pointer_cast<StochasticProcess1D>(process);
            return new GaussianPathGenerator(process1d,length,steps,
                                             rsg,brownianBridge);
        }

using QuantLib::MultiPath;


typedef QuantLib::MultiAsset<PseudoRandom>::path_generator_type
    GaussianMultiPathGenerator;

static MultiPath Sample_Sl_MultiPath_Sg__value(Sample<MultiPath > *self){ return self->value; }
static Real Sample_Sl_MultiPath_Sg__weight(Sample<MultiPath > *self){ return self->weight; }
static GaussianMultiPathGenerator *new_GaussianMultiPathGenerator__SWIG_0(boost::shared_ptr<GenericStochasticProcess > const &process,std::vector<Time > const &times,GaussianRandomSequenceGenerator const &generator,bool brownianBridge=false){
          return new GaussianMultiPathGenerator(process,
                                                QuantLib::TimeGrid(
                                                    times.begin(),
                                                    times.end()),
                                                generator,
                                                brownianBridge);
      }

typedef QuantLib::BoundaryCondition<QuantLib::TridiagonalOperator>
		BoundaryCondition;
typedef BoundaryCondition::Side BoundaryConditionSide;

BoundaryCondition::Side BCSideFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "" || s == "none")
        return BoundaryCondition::None;
    else if (s == "upper")
        return BoundaryCondition::Upper;
    else if (s == "lower")
        return BoundaryCondition::Lower;
    else
        QL_FAIL("unknown boundary condition side: "+s);
}

std::string BCSideToString(BoundaryCondition::Side type) {
    switch (type) {
      case BoundaryCondition::None:
        return "None";
      case BoundaryCondition::Upper:
        return "upper";
      case BoundaryCondition::Lower:
        return "lower";
      default:
        QL_FAIL("unknown boundary condition side");
    }
}

static bool boost_shared_ptr_Sl_BoundaryCondition_Sg__isNull(boost::shared_ptr<BoundaryCondition > *self){
                return !(*self);
            }

using QuantLib::NeumannBC;
using QuantLib::DirichletBC;
typedef boost::shared_ptr<BoundaryCondition> NeumannBCPtr;
typedef boost::shared_ptr<BoundaryCondition> DirichletBCPtr;

static NeumannBCPtr *new_NeumannBCPtr(Real value,BoundaryConditionSide side){
            return new NeumannBCPtr(new NeumannBC(value, side));
        }
static DirichletBCPtr *new_DirichletBCPtr(Real value,BoundaryConditionSide side){
            return new DirichletBCPtr(new DirichletBC(value, side));
        }

using QuantLib::TridiagonalOperator;


using QuantLib::DPlus;
using QuantLib::DMinus;
using QuantLib::DZero;
using QuantLib::DPlusDMinus;


using QuantLib::valueAtCenter;
using QuantLib::firstDerivativeAtCenter;
using QuantLib::secondDerivativeAtCenter;


using QuantLib::SymmetricEigenvalues;
using QuantLib::SymmetricEigenvectors;


using QuantLib::Bisection;
using QuantLib::Brent;
using QuantLib::FalsePosition;
using QuantLib::Newton;
using QuantLib::NewtonSafe;
using QuantLib::Ridder;
using QuantLib::Secant;


using QuantLib::Constraint;
using QuantLib::BoundaryConstraint;
using QuantLib::NoConstraint;
using QuantLib::PositiveConstraint;


using QuantLib::EndCriteria;


using QuantLib::OptimizationMethod;
using QuantLib::ConjugateGradient;
using QuantLib::Simplex;
using QuantLib::SteepestDescent;


using QuantLib::Problem;


    class Optimizer {};


using QuantLib::PlainVanillaPayoff;
using QuantLib::PercentageStrikePayoff;
using QuantLib::CashOrNothingPayoff;
using QuantLib::AssetOrNothingPayoff;
using QuantLib::SuperSharePayoff;
typedef boost::shared_ptr<Payoff> PlainVanillaPayoffPtr;
typedef boost::shared_ptr<Payoff> PercentageStrikePayoffPtr;
typedef boost::shared_ptr<Payoff> CashOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> AssetOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> SuperSharePayoffPtr;

static PlainVanillaPayoffPtr *new_PlainVanillaPayoffPtr(Option::Type type,Real strike){
            return new PlainVanillaPayoffPtr(
                                        new PlainVanillaPayoff(type, strike));
        }
static PercentageStrikePayoffPtr *new_PercentageStrikePayoffPtr(Option::Type type,Real moneyness){
            return new PercentageStrikePayoffPtr(
                                 new PercentageStrikePayoff(type, moneyness));
        }
static CashOrNothingPayoffPtr *new_CashOrNothingPayoffPtr(Option::Type type,Real strike,Real payoff){
            return new CashOrNothingPayoffPtr(
                               new CashOrNothingPayoff(type, strike, payoff));
        }
static AssetOrNothingPayoffPtr *new_AssetOrNothingPayoffPtr(Option::Type type,Real strike){
            return new AssetOrNothingPayoffPtr(
                                      new AssetOrNothingPayoff(type, strike));
        }
static SuperSharePayoffPtr *new_SuperSharePayoffPtr(Option::Type type,Real strike,Real increment){
            return new SuperSharePayoffPtr(
                               new SuperSharePayoff(type, strike, increment));
        }

using QuantLib::RateHelper;
using QuantLib::DepositRateHelper;
using QuantLib::FraRateHelper;
using QuantLib::FuturesRateHelper;
using QuantLib::SwapRateHelper;
typedef boost::shared_ptr<RateHelper> DepositRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FraRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FuturesRateHelperPtr;
typedef boost::shared_ptr<RateHelper> SwapRateHelperPtr;

static bool boost_shared_ptr_Sl_RateHelper_Sg__isNull(boost::shared_ptr<RateHelper > *self){
                return !(*self);
            }
static DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,n,units,settlementDays,
                                      calendar, convention,dayCounter));
        }
static DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_1(Rate rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,n,units,settlementDays,
                                      calendar, convention,dayCounter));
        }
static FraRateHelperPtr *new_FraRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer monthsToStart,Integer monthsToEnd,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  dayCounter));
        }
static FraRateHelperPtr *new_FraRateHelperPtr__SWIG_1(Rate rate,Integer monthsToStart,Integer monthsToEnd,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  dayCounter));
        }
static FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_0(Handle<Quote > const &price,Date const &immDate,Integer nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter));
        }
static FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_1(Real price,Date const &immDate,Integer nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter));
        }
static FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_2(Handle<Quote > const &price,Date const &immDate,Date const &matDate,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,matDate,
                                      calendar,convention,dayCounter));
        }
static SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,Frequency floatingFrequency,BusinessDayConvention floatingConvention){
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, n, units, settlementDays,
                                   calendar, fixedFrequency, fixedConvention,
                                   fixedDayCount, floatingFrequency,
                                   floatingConvention));
        }
static SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_1(Rate rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,Frequency floatingFrequency,BusinessDayConvention floatingConvention){
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, n, units, settlementDays,
                                   calendar, fixedFrequency, fixedConvention,
                                   fixedDayCount, floatingFrequency,
                                   floatingConvention));
        }
static boost::shared_ptr<RateHelper > &std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__get(std::vector<boost::shared_ptr<RateHelper > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__set(std::vector<boost::shared_ptr<RateHelper > > *self,int i,boost::shared_ptr<RateHelper > const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::PiecewiseFlatForward;
typedef boost::shared_ptr<YieldTermStructure> PiecewiseFlatForwardPtr;

static PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_0(Date const &referenceDate,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12){
	        return new PiecewiseFlatForwardPtr(
	            new PiecewiseFlatForward(referenceDate,instruments,
                                         dayCounter,accuracy));
        }
static PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12){
	        return new PiecewiseFlatForwardPtr(
	            new PiecewiseFlatForward(settlementDays, calendar,
                                         instruments, dayCounter, accuracy));
        }
static std::vector<Date > const &PiecewiseFlatForwardPtr_dates(PiecewiseFlatForwardPtr *self){
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)
                 ->dates();
        }
static std::vector<Time > const &PiecewiseFlatForwardPtr_times(PiecewiseFlatForwardPtr *self){
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)
                 ->times();
        }

using QuantLib::Settings;

static Date Settings_getEvaluationDate(Settings *self){
            return self->evaluationDate();
        }
static void Settings_setEvaluationDate(Settings *self,Date const &d){
            self->evaluationDate() = d;
        }

using QuantLib::CalibrationHelper;
using QuantLib::SwaptionHelper;
using QuantLib::CapHelper;
typedef boost::shared_ptr<CalibrationHelper> SwaptionHelperPtr;
typedef boost::shared_ptr<CalibrationHelper> CapHelperPtr;

static bool boost_shared_ptr_Sl_CalibrationHelper_Sg__isNull(boost::shared_ptr<CalibrationHelper > *self){
                return !(*self);
            }
static SwaptionHelperPtr *new_SwaptionHelperPtr(Period const &maturity,Period const &length,Handle<Quote > const &volatility,XiborPtr const &index,Frequency fixedLegFrequency,DayCounter const &fixedLegDayCounter,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new SwaptionHelperPtr(
                new SwaptionHelper(maturity,length,volatility,
                                   libor,fixedLegFrequency,
                                   fixedLegDayCounter,termStructure));
        }
static std::vector<Time > SwaptionHelperPtr_times(SwaptionHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
static CapHelperPtr *new_CapHelperPtr(Period const &length,Handle<Quote > const &volatility,XiborPtr const &index,Frequency fixedLegFrequency,DayCounter const &fixedLegDayCounter,bool includeFirstSwaplet,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new CapHelperPtr(
                new CapHelper(length,volatility,libor,fixedLegFrequency,
                              fixedLegDayCounter,includeFirstSwaplet,
                              termStructure));
        }
static std::vector<Time > CapHelperPtr_times(CapHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
static boost::shared_ptr<CalibrationHelper > &std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__get(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__set(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int i,boost::shared_ptr<CalibrationHelper > const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::ShortRateModel;

static bool boost_shared_ptr_Sl_ShortRateModel_Sg__isNull(boost::shared_ptr<ShortRateModel > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_ShortRateModel_Sg__asObservable(boost::shared_ptr<ShortRateModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::HullWhite;
using QuantLib::BlackKarasinski;
using QuantLib::G2;
typedef boost::shared_ptr<ShortRateModel> HullWhitePtr;
typedef boost::shared_ptr<ShortRateModel> BlackKarasinskiPtr;
typedef boost::shared_ptr<ShortRateModel> G2Ptr;

static HullWhitePtr *new_HullWhitePtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01){
	        return new HullWhitePtr(
	            new HullWhite(termStructure, a, sigma));
        }
static BlackKarasinskiPtr *new_BlackKarasinskiPtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.1){
	        return new BlackKarasinskiPtr(
	            new BlackKarasinski(termStructure, a, sigma));
        }
static G2Ptr *new_G2Ptr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01,Real b=0.1,Real eta=0.01,Real rho=-0.75){
	        return new G2Ptr(new G2(termStructure, a, sigma, b, eta, rho));
        }

using QuantLib::JamshidianSwaptionEngine;
using QuantLib::TreeSwaptionEngine;
using QuantLib::AnalyticCapFloorEngine;
using QuantLib::TreeCapFloorEngine;
using QuantLib::G2SwaptionEngine;
typedef boost::shared_ptr<PricingEngine> JamshidianSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> AnalyticCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> G2SwaptionEnginePtr;

static JamshidianSwaptionEnginePtr *new_JamshidianSwaptionEnginePtr(boost::shared_ptr<ShortRateModel > const &model){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new JamshidianSwaptionEnginePtr(
                                             new JamshidianSwaptionEngine(m));
        }
static TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps){
            return new TreeSwaptionEnginePtr(
                                     new TreeSwaptionEngine(model,timeSteps));
        }
static TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_1(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid){
            return new TreeSwaptionEnginePtr(
                                     new TreeSwaptionEngine(model,grid));
        }
static AnalyticCapFloorEnginePtr *new_AnalyticCapFloorEnginePtr(boost::shared_ptr<ShortRateModel > const &model){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new AnalyticCapFloorEnginePtr(
                                           new AnalyticCapFloorEngine(m));
        }
static TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps){
            return new TreeCapFloorEnginePtr(
                                     new TreeCapFloorEngine(model,timeSteps));
        }
static TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_1(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid){
            return new TreeCapFloorEnginePtr(
                                     new TreeCapFloorEngine(model,grid));
        }
static G2SwaptionEnginePtr *new_G2SwaptionEnginePtr(boost::shared_ptr<ShortRateModel > const &model,Real range,Size intervals){
            boost::shared_ptr<G2> g2 =
                boost::dynamic_pointer_cast<G2>(model);
            return new G2SwaptionEnginePtr(
                                    new G2SwaptionEngine(g2,range,intervals));
        }

using QuantLib::Statistics;
using QuantLib::RiskStatistics;
using QuantLib::SequenceStatistics;

static void Statistics_add__SWIG_2(Statistics *self,std::vector<Real > const &values){
            self->addSequence(values.begin(), values.end());
        }
static void Statistics_add__SWIG_3(Statistics *self,std::vector<Real > const &values,std::vector<Real > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }

using QuantLib::TimeBasket;


using QuantLib::Swap;
using QuantLib::SimpleSwap;
typedef boost::shared_ptr<Instrument> SwapPtr;
typedef boost::shared_ptr<Instrument> SimpleSwapPtr;

static SwapPtr *new_SwapPtr(std::vector<boost::shared_ptr<CashFlow > > const &firstLeg,std::vector<boost::shared_ptr<CashFlow > > const &secondLeg,Handle<YieldTermStructure > const &termStructure){
            return new SwapPtr(new Swap(firstLeg, secondLeg,
                                        termStructure));
        }
static Date SwapPtr_startDate(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->startDate();
        }
static Date SwapPtr_maturity(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->maturity();
        }
static Real SwapPtr_firstLegBPS(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->firstLegBPS();
        }
static Real SwapPtr_secondLegBPS(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->secondLegBPS();
        }
static TimeBasket SwapPtr_sensitivity(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->sensitivity();
        }
static SimpleSwapPtr *new_SimpleSwapPtr(bool payFixedRate,Real nominal,Schedule const &fixedSchedule,Rate fixedRate,DayCounter const &fixedDayCount,Schedule const &floatSchedule,XiborPtr const &index,Integer indexFixingDays,Spread spread,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new SimpleSwapPtr(
                new SimpleSwap(payFixedRate,nominal,fixedSchedule,fixedRate,
                               fixedDayCount,floatSchedule,libor,
                               indexFixingDays,spread,termStructure));
        }
static Rate SimpleSwapPtr_fairRate(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)->fairRate();
        }
static Spread SimpleSwapPtr_fairSpread(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->fairSpread();
        }
static Real SimpleSwapPtr_fixedLegBPS(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->fixedLegBPS();
        }
static Real SimpleSwapPtr_floatingLegBPS(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->floatingLegBPS();
        }

using QuantLib::Swaption;
typedef boost::shared_ptr<Instrument> SwaptionPtr;

static SwaptionPtr *new_SwaptionPtr(boost::shared_ptr<Instrument > const &simpleSwap,boost::shared_ptr<Exercise > const &exercise,Handle<YieldTermStructure > const &termStructure,boost::shared_ptr<PricingEngine > const &engine){
            boost::shared_ptr<SimpleSwap> swap =
                 boost::dynamic_pointer_cast<SimpleSwap>(simpleSwap);
            QL_REQUIRE(swap, "simple swap required");
            return new SwaptionPtr(new Swaption(swap,exercise,
                                                termStructure,engine));
        }

using QuantLib::BlackSwaptionEngine;
typedef boost::shared_ptr<PricingEngine> BlackSwaptionEnginePtr;

static BlackSwaptionEnginePtr *new_BlackSwaptionEnginePtr(boost::shared_ptr<BlackModel > const &model){
            return new BlackSwaptionEnginePtr(new BlackSwaptionEngine(model));
        }

using QuantLib::DiscreteGeometricASO;


// single asset
using QuantLib::McDiscreteArithmeticASO;

// multi asset
using QuantLib::McMaxBasket;
using QuantLib::McEverest;
using QuantLib::McHimalaya;
using QuantLib::McPagoda;


using QuantLib::SwaptionVolatilityStructure;

static bool boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__isNull(boost::shared_ptr<SwaptionVolatilityStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__asObservable(boost::shared_ptr<SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static boost::shared_ptr<Observable > Handle_Sl_SwaptionVolatilityStructure_Sg__asObservable(Handle<SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SwaptionVolatilityMatrix;
typedef boost::shared_ptr<SwaptionVolatilityStructure>
    SwaptionVolatilityMatrixPtr;

static SwaptionVolatilityMatrixPtr *new_SwaptionVolatilityMatrixPtr(Date const &referenceDate,std::vector<Date > const &dates,std::vector<Period > const &lengths,Matrix const &vols,DayCounter const &dayCounter){
            return new SwaptionVolatilityMatrixPtr(
                new SwaptionVolatilityMatrix(referenceDate,dates,lengths,
                                             vols,dayCounter));
        }

using QuantLib::CapVolatilityStructure;

static bool boost_shared_ptr_Sl_CapVolatilityStructure_Sg__isNull(boost::shared_ptr<CapVolatilityStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > boost_shared_ptr_Sl_CapVolatilityStructure_Sg__asObservable(boost::shared_ptr<CapVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
static boost::shared_ptr<Observable > Handle_Sl_CapVolatilityStructure_Sg__asObservable(Handle<CapVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::CapVolatilityVector;
typedef boost::shared_ptr<CapVolatilityStructure> CapVolatilityVectorPtr;

static CapVolatilityVectorPtr *new_CapVolatilityVectorPtr__SWIG_0(Date const &referenceDate,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,DayCounter const &dayCounter){
            return new CapVolatilityVectorPtr(
                new CapVolatilityVector(referenceDate,lengths,
                                        vols,dayCounter));
        }
static CapVolatilityVectorPtr *new_CapVolatilityVectorPtr__SWIG_1(Integer settlementDays,Calendar const &calendar,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,DayCounter const &dayCounter){
            return new CapVolatilityVectorPtr(
                new CapVolatilityVector(settlementDays,calendar,
                                        lengths,vols,dayCounter));
        }

#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Observable_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
    Observable *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Observable > **)(void *)&jarg1; 
    {
        try {
            result = (Observable *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Observable **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Observable_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Observable > **)(void *)&jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_Observable_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Observable(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    boost::shared_ptr<Observable > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (boost::shared_ptr<Observable > *)new boost::shared_ptr<Observable >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<Observable > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Observable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Observable > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    Array *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (Array *)new Array();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Array **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jlong jresult = 0 ;
    Size arg1 ;
    Real arg2 ;
    Array *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Size)jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Array *)new Array(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Array **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Size arg1 ;
    Array *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Size)jarg1; 
    {
        try {
            result = (Array *)new Array(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Array **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Array *arg1 = 0 ;
    Array *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    {
        try {
            result = (Array *)new Array((Array const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Array **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Array_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Array *arg1 = (Array *) 0 ;
    Size result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1; 
    {
        try {
            result = ((Array const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Array_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Array *arg1 = (Array *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1; 
    {
        try {
            result = Array___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Array(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Array *arg1 = (Array *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LexicographicalView_1xSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LexicographicalView **)(void *)&jarg1; 
    {
        try {
            result = ((LexicographicalView const *)arg1)->xSize();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LexicographicalView_1ySize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LexicographicalView **)(void *)&jarg1; 
    {
        try {
            result = ((LexicographicalView const *)arg1)->ySize();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LexicographicalView(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Array *arg1 = 0 ;
    Size arg2 ;
    LexicographicalView *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array & reference is null");
        return 0;
    } 
    arg2 = (Size)jarg2; 
    {
        try {
            result = (LexicographicalView *)new_LexicographicalView(*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(LexicographicalView **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_LexicographicalView_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LexicographicalView **)(void *)&jarg1; 
    {
        try {
            result = LexicographicalView___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LexicographicalView(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LexicographicalView **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    Matrix *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (Matrix *)new Matrix();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Matrix **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jdouble jarg3) {
    jlong jresult = 0 ;
    Size arg1 ;
    Size arg2 ;
    Real arg3 ;
    Matrix *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Size)jarg1; 
    arg2 = (Size)jarg2; 
    arg3 = (Real)jarg3; 
    {
        try {
            result = (Matrix *)new Matrix(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Matrix **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Size arg1 ;
    Size arg2 ;
    Matrix *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Size)jarg1; 
    arg2 = (Size)jarg2; 
    {
        try {
            result = (Matrix *)new Matrix(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Matrix **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Matrix *arg1 = 0 ;
    Matrix *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Matrix **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
        return 0;
    } 
    {
        try {
            result = (Matrix *)new Matrix((Matrix const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Matrix **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1rows(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Matrix *arg1 = (Matrix *) 0 ;
    Size result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Matrix **)(void *)&jarg1; 
    {
        try {
            result = ((Matrix const *)arg1)->rows();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1columns(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Matrix *arg1 = (Matrix *) 0 ;
    Size result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Matrix **)(void *)&jarg1; 
    {
        try {
            result = ((Matrix const *)arg1)->columns();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Matrix *arg1 = (Matrix *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Matrix **)(void *)&jarg1; 
    {
        try {
            result = Matrix___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Matrix(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Matrix *arg1 = (Matrix *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Matrix **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SalvagingAlgorithm(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    SalvagingAlgorithm *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (SalvagingAlgorithm *)new SalvagingAlgorithm();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(SalvagingAlgorithm **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SalvagingAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SalvagingAlgorithm *arg1 = (SalvagingAlgorithm *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SalvagingAlgorithm **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_transpose(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Matrix *arg1 = 0 ;
    Matrix result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Matrix **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
        return 0;
    } 
    {
        try {
            result = transpose((Matrix const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Matrix **)(void *)&jresult = new Matrix((Matrix &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_outerProduct(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    arg2 = *(Array **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    {
        try {
            result = outerProduct((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Matrix **)(void *)&jresult = new Matrix((Matrix &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_pseudoSqrt(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    Matrix *arg1 = 0 ;
    SalvagingAlgorithm::Type arg2 ;
    Matrix result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Matrix **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
        return 0;
    } 
    arg2 = (SalvagingAlgorithm::Type)jarg2; 
    {
        try {
            result = pseudoSqrt((Matrix const &)*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Matrix **)(void *)&jresult = new Matrix((Matrix &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SVD(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Matrix *arg1 = 0 ;
    SVD *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Matrix **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
        return 0;
    } 
    {
        try {
            result = (SVD *)new SVD((Matrix const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(SVD **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1U(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SVD *arg1 = (SVD *) 0 ;
    Matrix *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SVD **)(void *)&jarg1; 
    {
        try {
            {
                Matrix const &_result_ref = ((SVD const *)arg1)->U();
                result = (Matrix *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Matrix **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1V(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SVD *arg1 = (SVD *) 0 ;
    Matrix *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SVD **)(void *)&jarg1; 
    {
        try {
            {
                Matrix const &_result_ref = ((SVD const *)arg1)->V();
                result = (Matrix *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Matrix **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1S(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SVD *arg1 = (SVD *) 0 ;
    Matrix result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SVD **)(void *)&jarg1; 
    {
        try {
            result = ((SVD const *)arg1)->S();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Matrix **)(void *)&jresult = new Matrix((Matrix &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1singularValues(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SVD *arg1 = (SVD *) 0 ;
    Array *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SVD **)(void *)&jarg1; 
    {
        try {
            {
                Array const &_result_ref = ((SVD const *)arg1)->singularValues();
                result = (Array *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Array **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SVD(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SVD *arg1 = (SVD *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SVD **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Quote_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    Quote *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Quote > **)(void *)&jarg1; 
    {
        try {
            result = (Quote *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Quote **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Quote_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Quote > **)(void *)&jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_Quote_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Quote_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    boost::shared_ptr<Observable > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Quote > **)(void *)&jarg1; 
    {
        try {
            result = boost_shared_ptr_Sl_Quote_Sg__asObservable(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<Observable > **)(void *)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Quote_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Quote > **)(void *)&jarg1; 
    {
        try {
            result = (Real)(*arg1)->value();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Quote(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    boost::shared_ptr<Quote > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (boost::shared_ptr<Quote > *)new boost::shared_ptr<Quote >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<Quote > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Quote(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Quote > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<Quote > *arg1 = 0 ;
    Handle<Quote > *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Quote > **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<Quote > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (Handle<Quote > *)new Handle<Quote >((boost::shared_ptr<Quote > const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Handle<Quote > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    Handle<Quote > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (Handle<Quote > *)new Handle<Quote >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Handle<Quote > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    boost::shared_ptr<Quote > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<Quote > **)(void *)&jarg1; 
    {
        try {
            result = (arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<Quote > **)(void *)&jresult = new boost::shared_ptr<Quote >((boost::shared_ptr<Quote > &)result); 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1linkTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<Quote > **)(void *)&jarg1; 
    arg2 = *(boost::shared_ptr<Quote > **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<Quote > const & reference is null");
        return ;
    } 
    {
        try {
            (arg1)->linkTo((boost::shared_ptr<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<Quote > **)(void *)&jarg1; 
    {
        try {
            result = (bool)(arg1)->empty();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    boost::shared_ptr<Observable > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<Quote > **)(void *)&jarg1; 
    {
        try {
            result = Handle_Sl_Quote_Sg__asObservable(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<Observable > **)(void *)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<Quote > **)(void *)&jarg1; 
    {
        try {
            result = (Real)(*arg1)->value();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<Quote > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SimpleQuote(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
    jlong jresult = 0 ;
    Real arg1 ;
    SimpleQuotePtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Real)jarg1; 
    {
        try {
            result = (SimpleQuotePtr *)new_SimpleQuotePtr(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(SimpleQuotePtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_SimpleQuote_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
    Real arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SimpleQuotePtr **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            SimpleQuotePtr_setValue(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SimpleQuote(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SimpleQuotePtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    std::vector<boost::shared_ptr<Quote > > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<boost::shared_ptr<Quote > > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    unsigned int arg1 ;
    std::vector<boost::shared_ptr<Quote > > *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (unsigned int)jarg1; 
    {
        try {
            result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<boost::shared_ptr<Quote > > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<boost::shared_ptr<Quote > > **)(void *)&jarg1; 
    {
        try {
            result = (unsigned int)((std::vector<boost::shared_ptr<Quote > > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<boost::shared_ptr<Quote > > **)(void *)&jarg1; 
    {
        try {
            result = (bool)((std::vector<boost::shared_ptr<Quote > > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<boost::shared_ptr<Quote > > **)(void *)&jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<boost::shared_ptr<Quote > > **)(void *)&jarg1; 
    arg2 = *(boost::shared_ptr<Quote > **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<Quote > const & reference is null");
        return ;
    } 
    {
        try {
            (arg1)->push_back((boost::shared_ptr<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    boost::shared_ptr<Quote > *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<boost::shared_ptr<Quote > > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                {
                    boost::shared_ptr<Quote > &_result_ref = std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__get(arg1,arg2);
                    result = (boost::shared_ptr<Quote > *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<Quote > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    boost::shared_ptr<Quote > *arg3 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<boost::shared_ptr<Quote > > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = *(boost::shared_ptr<Quote > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<Quote > const & reference is null");
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__set(arg1,arg2,(boost::shared_ptr<Quote > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<boost::shared_ptr<Quote > > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    std::vector<Handle<Quote > > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<Handle<Quote > > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    unsigned int arg1 ;
    std::vector<Handle<Quote > > *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (unsigned int)jarg1; 
    {
        try {
            result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<Handle<Quote > > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Handle<Quote > > **)(void *)&jarg1; 
    {
        try {
            result = (unsigned int)((std::vector<Handle<Quote > > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Handle<Quote > > **)(void *)&jarg1; 
    {
        try {
            result = (bool)((std::vector<Handle<Quote > > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Handle<Quote > > **)(void *)&jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    Handle<Quote > *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Handle<Quote > > **)(void *)&jarg1; 
    arg2 = *(Handle<Quote > **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
        return ;
    } 
    {
        try {
            (arg1)->push_back((Handle<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    Handle<Quote > *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Handle<Quote > > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                {
                    Handle<Quote > &_result_ref = std_vector_Sl_Handle_Sl_Quote_Sg__Sg__get(arg1,arg2);
                    result = (Handle<Quote > *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Handle<Quote > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    Handle<Quote > *arg3 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Handle<Quote > > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = *(Handle<Quote > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Handle_Sl_Quote_Sg__Sg__set(arg1,arg2,(Handle<Quote > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteHandleVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Handle<Quote > > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Period *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    {
        try {
            result = (Period *)new Period(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Period **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Period_1length(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Period *arg1 = (Period *) 0 ;
    Integer result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Period **)(void *)&jarg1; 
    {
        try {
            result = (Integer)((Period const *)arg1)->length();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Period_1units(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Period *arg1 = (Period *) 0 ;
    TimeUnit result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Period **)(void *)&jarg1; 
    {
        try {
            result = (TimeUnit)((Period const *)arg1)->units();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    std::string *arg1 = 0 ;
    Period *result;
    
    (void)jenv;
    (void)jcls;
    if(!jarg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
    if (!arg1_pstr) return 0;
    std::string arg1_str(arg1_pstr);
    arg1 = &arg1_str;
    jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
    {
        try {
            result = (Period *)new_Period__SWIG_1((std::string const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Period **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Period_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Period *arg1 = (Period *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Period **)(void *)&jarg1; 
    {
        try {
            result = Period___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Period_1repr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Period *arg1 = (Period *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Period **)(void *)&jarg1; 
    {
        try {
            result = Period___repr__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Period_1compare(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    Period *arg1 = (Period *) 0 ;
    Period *arg2 = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Period **)(void *)&jarg1; 
    arg2 = *(Period **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
        return 0;
    } 
    {
        try {
            result = (int)Period___cmp__(arg1,(Period const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Period(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Period *arg1 = (Period *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Period **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PeriodVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    std::vector<Period > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (std::vector<Period > *)new std::vector<Period >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<Period > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PeriodVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    unsigned int arg1 ;
    std::vector<Period > *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (unsigned int)jarg1; 
    {
        try {
            result = (std::vector<Period > *)new std::vector<Period >(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<Period > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Period > **)(void *)&jarg1; 
    {
        try {
            result = (unsigned int)((std::vector<Period > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Period > **)(void *)&jarg1; 
    {
        try {
            result = (bool)((std::vector<Period > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Period > **)(void *)&jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    Period *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Period > **)(void *)&jarg1; 
    arg2 = *(Period **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
        return ;
    } 
    {
        try {
            (arg1)->push_back((Period const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    Period *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Period > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                {
                    Period &_result_ref = std_vector_Sl_Period_Sg__get(arg1,arg2);
                    result = (Period *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Period **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    Period *arg3 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Period > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = *(Period **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Period_Sg__set(arg1,arg2,(Period const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PeriodVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Period > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    Date *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (Date *)new Date();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3) {
    jlong jresult = 0 ;
    Day arg1 ;
    Month arg2 ;
    Year arg3 ;
    Date *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Day)jarg1; 
    arg2 = (Month)jarg2; 
    arg3 = (Year)jarg3; 
    {
        try {
            result = (Date *)new Date(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    BigInteger arg1 ;
    Date *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (BigInteger)jarg1; 
    {
        try {
            result = (Date *)new Date(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1weekday(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    Weekday result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    {
        try {
            result = (Weekday)((Date const *)arg1)->weekday();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1dayOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    Day result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    {
        try {
            result = (Day)((Date const *)arg1)->dayOfMonth();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1dayOfYear(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    Day result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    {
        try {
            result = (Day)((Date const *)arg1)->dayOfYear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1month(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    Month result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    {
        try {
            result = (Month)((Date const *)arg1)->month();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1year(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    Year result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    {
        try {
            result = (Year)((Date const *)arg1)->year();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1serialNumber(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    BigInteger result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    {
        try {
            result = (BigInteger)((Date const *)arg1)->serialNumber();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Date_1isLeap(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jboolean jresult = 0 ;
    Year arg1 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Year)jarg1; 
    {
        try {
            result = (bool)Date::isLeap(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1minDate(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = Date::minDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1maxDate(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = Date::maxDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1todaysDate(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = Date::todaysDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1endOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Date *arg1 = 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = Date::endOfMonth((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Date_1isEOM(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    Date *arg1 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (bool)Date::isEOM((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1nextWeekday(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    Date *arg1 = 0 ;
    Weekday arg2 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg2 = (Weekday)jarg2; 
    {
        try {
            result = Date::nextWeekday((Date const &)*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1nthWeekday(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4) {
    jlong jresult = 0 ;
    Size arg1 ;
    Weekday arg2 ;
    Month arg3 ;
    Year arg4 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Size)jarg1; 
    arg2 = (Weekday)jarg2; 
    arg3 = (Month)jarg3; 
    arg4 = (Year)jarg4; 
    {
        try {
            result = Date::nthWeekday(arg1,arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Date_1isIMMdate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    Date *arg1 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (bool)Date::isIMMdate((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1nextIMMdate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Date *arg1 = 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = Date::nextIMMdate((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1add_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    BigInteger arg2 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    arg2 = (BigInteger)jarg2; 
    {
        try {
            result = ((Date const *)arg1)->operator +(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1subtract_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    BigInteger arg2 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    arg2 = (BigInteger)jarg2; 
    {
        try {
            result = ((Date const *)arg1)->operator -(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1add_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    Period *arg2 = 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    arg2 = *(Period **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
        return 0;
    } 
    {
        try {
            result = ((Date const *)arg1)->operator +((Period const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1subtract_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    Period *arg2 = 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    arg2 = *(Period **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
        return 0;
    } 
    {
        try {
            result = ((Date const *)arg1)->operator -((Period const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    std::string *arg1 = 0 ;
    std::string *arg2 = 0 ;
    Date *result;
    
    (void)jenv;
    (void)jcls;
    if(!jarg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
    if (!arg1_pstr) return 0;
    std::string arg1_str(arg1_pstr);
    arg1 = &arg1_str;
    jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
    if(!jarg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
    if (!arg2_pstr) return 0;
    std::string arg2_str(arg2_pstr);
    arg2 = &arg2_str;
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
    {
        try {
            result = (Date *)new_Date__SWIG_3((std::string const &)*arg1,(std::string const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1weekdayNumber(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    Integer result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    {
        try {
            result = (Integer)Date_weekdayNumber(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Date_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    {
        try {
            result = Date___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Date_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    {
        try {
            result = Date___repr__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Date_1ISO(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Date *arg1 = (Date *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    {
        try {
            result = Date_ISO(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Date(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Date *arg1 = (Date *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DateVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    std::vector<Date > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (std::vector<Date > *)new std::vector<Date >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<Date > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DateVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    unsigned int arg1 ;
    std::vector<Date > *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (unsigned int)jarg1; 
    {
        try {
            result = (std::vector<Date > *)new std::vector<Date >(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<Date > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Date > **)(void *)&jarg1; 
    {
        try {
            result = (unsigned int)((std::vector<Date > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Date > **)(void *)&jarg1; 
    {
        try {
            result = (bool)((std::vector<Date > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Date > **)(void *)&jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    Date *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Date > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return ;
    } 
    {
        try {
            (arg1)->push_back((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    Date *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Date > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                {
                    Date &_result_ref = std_vector_Sl_Date_Sg__get(arg1,arg2);
                    result = (Date *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    Date *arg3 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Date > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return ;
    } 
    {
        try {
            try {
                std_vector_Sl_Date_Sg__set(arg1,arg2,(Date const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DateVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Date > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_nullInt(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (int)nullInt();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_nullDouble(JNIEnv *jenv, jclass jcls) {
    jdouble jresult = 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (double)nullDouble();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1dayCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    BigInteger result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DayCounter **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (BigInteger)(arg1)->dayCount((Date const &)*arg2,(Date const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1yearFraction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
    jdouble jresult = 0 ;
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Date *arg4 = 0 ;
    Date *arg5 = 0 ;
    Time result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DayCounter **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = *(Date **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg5 = *(Date **)(void *)&jarg5;
    if(!arg5) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4,(Date const &)*arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1yearFraction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    jdouble jresult = 0 ;
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Date *arg4 = 0 ;
    Time result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DayCounter **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = *(Date **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1yearFraction_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jdouble jresult = 0 ;
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Time result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DayCounter **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    DayCounter *arg1 = (DayCounter *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DayCounter **)(void *)&jarg1; 
    {
        try {
            result = DayCounter___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    DayCounter *arg1 = (DayCounter *) 0 ;
    DayCounter *arg2 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DayCounter **)(void *)&jarg1; 
    arg2 = *(DayCounter **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (bool)DayCounter___eq__(arg1,(DayCounter const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1unEquals(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    DayCounter *arg1 = (DayCounter *) 0 ;
    DayCounter *arg2 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DayCounter **)(void *)&jarg1; 
    arg2 = *(DayCounter **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (bool)DayCounter___ne__(arg1,(DayCounter const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    DayCounter *arg1 = (DayCounter *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DayCounter **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Actual360(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Actual360 *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Actual360 *)new QuantLib::Actual360();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Actual360 **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Actual360(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Actual360 *arg1 = (QuantLib::Actual360 *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Actual360 **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Actual365Fixed(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Actual365Fixed *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Actual365Fixed *)new QuantLib::Actual365Fixed();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Actual365Fixed **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Actual365Fixed(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Actual365Fixed *arg1 = (QuantLib::Actual365Fixed *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Actual365Fixed **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Thirty360_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    QuantLib::Thirty360::Convention arg1 ;
    QuantLib::Thirty360 *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (QuantLib::Thirty360::Convention)jarg1; 
    {
        try {
            result = (QuantLib::Thirty360 *)new QuantLib::Thirty360(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Thirty360 **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Thirty360_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Thirty360 *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Thirty360 *)new QuantLib::Thirty360();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Thirty360 **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Thirty360(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Thirty360 *arg1 = (QuantLib::Thirty360 *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Thirty360 **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ActualActual_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    QuantLib::ActualActual::Convention arg1 ;
    QuantLib::ActualActual *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (QuantLib::ActualActual::Convention)jarg1; 
    {
        try {
            result = (QuantLib::ActualActual *)new QuantLib::ActualActual(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::ActualActual **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ActualActual_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::ActualActual *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::ActualActual *)new QuantLib::ActualActual();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::ActualActual **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ActualActual(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::ActualActual *arg1 = (QuantLib::ActualActual *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::ActualActual **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1OneDayCounter(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::OneDayCounter *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::OneDayCounter *)new QuantLib::OneDayCounter();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::OneDayCounter **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1OneDayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::OneDayCounter *arg1 = (QuantLib::OneDayCounter *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::OneDayCounter **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SimpleDayCounter(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::SimpleDayCounter *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::SimpleDayCounter *)new QuantLib::SimpleDayCounter();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::SimpleDayCounter **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SimpleDayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::SimpleDayCounter *arg1 = (QuantLib::SimpleDayCounter *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::SimpleDayCounter **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1InterestRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    InterestRate *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (InterestRate *)new InterestRate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1InterestRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jint jarg3, jint jarg4) {
    jlong jresult = 0 ;
    Rate arg1 ;
    DayCounter *arg2 = 0 ;
    Compounding arg3 ;
    Frequency arg4 ;
    InterestRate *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Rate)jarg1; 
    arg2 = *(DayCounter **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg3 = (Compounding)jarg3; 
    arg4 = (Frequency)jarg4; 
    {
        try {
            result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1InterestRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jint jarg3) {
    jlong jresult = 0 ;
    Rate arg1 ;
    DayCounter *arg2 = 0 ;
    Compounding arg3 ;
    InterestRate *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Rate)jarg1; 
    arg2 = *(DayCounter **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg3 = (Compounding)jarg3; 
    {
        try {
            result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1rate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Rate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    {
        try {
            result = (Rate)((InterestRate const *)arg1)->rate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    SwigValueWrapper<DayCounter > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    {
        try {
            result = ((InterestRate const *)arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(DayCounter **)(void *)&jresult = new DayCounter((DayCounter &)result); 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1compounding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Compounding result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    {
        try {
            result = (Compounding)((InterestRate const *)arg1)->compounding();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1frequency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Frequency result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    {
        try {
            result = (Frequency)((InterestRate const *)arg1)->frequency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1discountFactor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    DiscountFactor result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    {
        try {
            result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1discountFactor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jdouble jresult = 0 ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date arg2 ;
    Date arg3 ;
    DiscountFactor result;
    Date *argp2 ;
    Date *argp3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    argp2 = *(Date **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Date");
        return 0;
    }
    arg2 = *argp2; 
    argp3 = *(Date **)(void *)&jarg3; 
    if (!argp3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Date");
        return 0;
    }
    arg3 = *argp3; 
    {
        try {
            result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1compoundFactor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    {
        try {
            result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1compoundFactor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jdouble jresult = 0 ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date arg2 ;
    Date arg3 ;
    Real result;
    Date *argp2 ;
    Date *argp3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    argp2 = *(Date **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Date");
        return 0;
    }
    arg2 = *argp2; 
    argp3 = *(Date **)(void *)&jarg3; 
    if (!argp3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Date");
        return 0;
    }
    arg3 = *argp3; 
    {
        try {
            result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1impliedRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jlong jarg3, jint jarg4, jint jarg5) {
    jlong jresult = 0 ;
    Real arg1 ;
    Time arg2 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Real)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = InterestRate::impliedRate(arg1,arg2,(DayCounter const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1impliedRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jlong jarg3, jint jarg4) {
    jlong jresult = 0 ;
    Real arg1 ;
    Time arg2 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Real)jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = InterestRate::impliedRate(arg1,arg2,(DayCounter const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1impliedRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5, jint jarg6) {
    jlong jresult = 0 ;
    Real arg1 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Real)jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    {
        try {
            result = InterestRate::impliedRate(arg1,(Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1impliedRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
    jlong jresult = 0 ;
    Real arg1 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Real)jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    {
        try {
            result = InterestRate::impliedRate(arg1,(Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1equivalentRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jint jarg3, jint jarg4) {
    jlong jresult = 0 ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    arg4 = (Frequency)jarg4; 
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1equivalentRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jint jarg3) {
    jlong jresult = 0 ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1equivalentRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5, jint jarg6) {
    jlong jresult = 0 ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1equivalentRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
    jlong jresult = 0 ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    InterestRate *arg1 = (InterestRate *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    {
        try {
            result = InterestRate___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1InterestRate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    InterestRate *arg1 = (InterestRate *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(InterestRate **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isBusinessDay(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (bool)(arg1)->isBusinessDay((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isHoliday(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (bool)(arg1)->isHoliday((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isEndOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (bool)(arg1)->isEndOfMonth((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1addHoliday(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return ;
    } 
    {
        try {
            (arg1)->addHoliday((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1removeHoliday(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return ;
    } 
    {
        try {
            (arg1)->removeHoliday((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1adjust_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    BusinessDayConvention arg3 ;
    Date *arg4 = 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = (BusinessDayConvention)jarg3; 
    arg4 = *(Date **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (arg1)->adjust((Date const &)*arg2,arg3,(Date const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1adjust_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    jlong jresult = 0 ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    BusinessDayConvention arg3 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = (BusinessDayConvention)jarg3; 
    {
        try {
            result = (arg1)->adjust((Date const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1adjust_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (arg1)->adjust((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4, jint jarg5) {
    jlong jresult = 0 ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Integer arg3 ;
    TimeUnit arg4 ;
    BusinessDayConvention arg5 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = (Integer)jarg3; 
    arg4 = (TimeUnit)jarg4; 
    arg5 = (BusinessDayConvention)jarg5; 
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4) {
    jlong jresult = 0 ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Integer arg3 ;
    TimeUnit arg4 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = (Integer)jarg3; 
    arg4 = (TimeUnit)jarg4; 
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
    jlong jresult = 0 ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Period *arg3 = 0 ;
    BusinessDayConvention arg4 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Period **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
        return 0;
    } 
    arg4 = (BusinessDayConvention)jarg4; 
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Period *arg3 = 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Period **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
        return 0;
    } 
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Calendar *arg1 = (Calendar *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    {
        try {
            result = Calendar___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    Calendar *arg1 = (Calendar *) 0 ;
    Calendar *arg2 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    {
        try {
            result = (bool)Calendar___eq__(arg1,(Calendar const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1unEquals(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    Calendar *arg1 = (Calendar *) 0 ;
    Calendar *arg2 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    {
        try {
            result = (bool)Calendar___ne__(arg1,(Calendar const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Calendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Calendar *arg1 = (Calendar *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Beijing(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Beijing *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Beijing *)new QuantLib::Beijing();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Beijing **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Beijing(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Beijing *arg1 = (QuantLib::Beijing *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Beijing **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Bombay(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Bombay *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Bombay *)new QuantLib::Bombay();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Bombay **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Bombay(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Bombay *arg1 = (QuantLib::Bombay *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Bombay **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Bratislava(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Bratislava *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Bratislava *)new QuantLib::Bratislava();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Bratislava **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Bratislava(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Bratislava *arg1 = (QuantLib::Bratislava *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Bratislava **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Budapest(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Budapest *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Budapest *)new QuantLib::Budapest();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Budapest **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Budapest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Budapest *arg1 = (QuantLib::Budapest *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Budapest **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Copenhagen(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Copenhagen *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Copenhagen *)new QuantLib::Copenhagen();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Copenhagen **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Copenhagen(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Copenhagen *arg1 = (QuantLib::Copenhagen *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Copenhagen **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Germany_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    QuantLib::Germany::Market arg1 ;
    QuantLib::Germany *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (QuantLib::Germany::Market)jarg1; 
    {
        try {
            result = (QuantLib::Germany *)new QuantLib::Germany(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Germany **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Germany_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Germany *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Germany *)new QuantLib::Germany();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Germany **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Germany(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Germany *arg1 = (QuantLib::Germany *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Germany **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Helsinki(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Helsinki *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Helsinki *)new QuantLib::Helsinki();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Helsinki **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Helsinki(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Helsinki *arg1 = (QuantLib::Helsinki *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Helsinki **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1HongKong(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::HongKong *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::HongKong *)new QuantLib::HongKong();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::HongKong **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1HongKong(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::HongKong *arg1 = (QuantLib::HongKong *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::HongKong **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Italy_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    QuantLib::Italy::Market arg1 ;
    QuantLib::Italy *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (QuantLib::Italy::Market)jarg1; 
    {
        try {
            result = (QuantLib::Italy *)new QuantLib::Italy(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Italy **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Italy_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Italy *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Italy *)new QuantLib::Italy();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Italy **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Italy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Italy *arg1 = (QuantLib::Italy *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Italy **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Istanbul(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Istanbul *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Istanbul *)new QuantLib::Istanbul();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Istanbul **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Istanbul(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Istanbul *arg1 = (QuantLib::Istanbul *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Istanbul **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Johannesburg(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Johannesburg *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Johannesburg *)new QuantLib::Johannesburg();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Johannesburg **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Johannesburg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Johannesburg *arg1 = (QuantLib::Johannesburg *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Johannesburg **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NullCalendar(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::NullCalendar *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::NullCalendar *)new QuantLib::NullCalendar();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::NullCalendar **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NullCalendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::NullCalendar *arg1 = (QuantLib::NullCalendar *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::NullCalendar **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Oslo(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Oslo *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Oslo *)new QuantLib::Oslo();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Oslo **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Oslo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Oslo *arg1 = (QuantLib::Oslo *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Oslo **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Prague(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Prague *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Prague *)new QuantLib::Prague();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Prague **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Prague(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Prague *arg1 = (QuantLib::Prague *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Prague **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Riyadh(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Riyadh *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Riyadh *)new QuantLib::Riyadh();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Riyadh **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Riyadh(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Riyadh *arg1 = (QuantLib::Riyadh *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Riyadh **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Seoul(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Seoul *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Seoul *)new QuantLib::Seoul();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Seoul **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Seoul(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Seoul *arg1 = (QuantLib::Seoul *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Seoul **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Singapore(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Singapore *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Singapore *)new QuantLib::Singapore();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Singapore **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Singapore(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Singapore *arg1 = (QuantLib::Singapore *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Singapore **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Stockholm(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Stockholm *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Stockholm *)new QuantLib::Stockholm();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Stockholm **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Stockholm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Stockholm *arg1 = (QuantLib::Stockholm *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Stockholm **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Sydney(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Sydney *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Sydney *)new QuantLib::Sydney();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Sydney **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Sydney(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Sydney *arg1 = (QuantLib::Sydney *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Sydney **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1TARGET(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::TARGET *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::TARGET *)new QuantLib::TARGET();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::TARGET **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1TARGET(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::TARGET *arg1 = (QuantLib::TARGET *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::TARGET **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Taipei(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Taipei *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Taipei *)new QuantLib::Taipei();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Taipei **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Taipei(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Taipei *arg1 = (QuantLib::Taipei *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Taipei **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Taiwan(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Taiwan *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Taiwan *)new QuantLib::Taiwan();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Taiwan **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Taiwan(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Taiwan *arg1 = (QuantLib::Taiwan *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Taiwan **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Tokyo(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Tokyo *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Tokyo *)new QuantLib::Tokyo();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Tokyo **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Tokyo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Tokyo *arg1 = (QuantLib::Tokyo *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Tokyo **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Toronto(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Toronto *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Toronto *)new QuantLib::Toronto();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Toronto **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Toronto(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Toronto *arg1 = (QuantLib::Toronto *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Toronto **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnitedKingdom_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    QuantLib::UnitedKingdom::Market arg1 ;
    QuantLib::UnitedKingdom *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (QuantLib::UnitedKingdom::Market)jarg1; 
    {
        try {
            result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::UnitedKingdom **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnitedKingdom_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::UnitedKingdom *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::UnitedKingdom **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UnitedKingdom(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::UnitedKingdom *arg1 = (QuantLib::UnitedKingdom *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::UnitedKingdom **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnitedStates_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    QuantLib::UnitedStates::Market arg1 ;
    QuantLib::UnitedStates *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (QuantLib::UnitedStates::Market)jarg1; 
    {
        try {
            result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::UnitedStates **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnitedStates_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::UnitedStates *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::UnitedStates **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UnitedStates(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::UnitedStates *arg1 = (QuantLib::UnitedStates *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::UnitedStates **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Warsaw(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Warsaw *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Warsaw *)new QuantLib::Warsaw();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Warsaw **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Warsaw(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Warsaw *arg1 = (QuantLib::Warsaw *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Warsaw **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Wellington(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Wellington *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Wellington *)new QuantLib::Wellington();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Wellington **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Wellington(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Wellington *arg1 = (QuantLib::Wellington *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Wellington **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Zurich(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::Zurich *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::Zurich *)new QuantLib::Zurich();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::Zurich **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Zurich(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::Zurich *arg1 = (QuantLib::Zurich *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::Zurich **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    jlong jresult = 0 ;
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    JointCalendarRule arg3 ;
    QuantLib::JointCalendar *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg3 = (JointCalendarRule)jarg3; 
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::JointCalendar **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    QuantLib::JointCalendar *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::JointCalendar **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
    jlong jresult = 0 ;
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    JointCalendarRule arg4 ;
    QuantLib::JointCalendar *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg3 = *(Calendar **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg4 = (JointCalendarRule)jarg4; 
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::JointCalendar **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    QuantLib::JointCalendar *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg3 = *(Calendar **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::JointCalendar **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
    jlong jresult = 0 ;
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    Calendar *arg4 = 0 ;
    JointCalendarRule arg5 ;
    QuantLib::JointCalendar *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg3 = *(Calendar **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg4 = *(Calendar **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg5 = (JointCalendarRule)jarg5; 
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::JointCalendar **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    Calendar *arg4 = 0 ;
    QuantLib::JointCalendar *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg3 = *(Calendar **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg4 = *(Calendar **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::JointCalendar **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1JointCalendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::JointCalendar *arg1 = (QuantLib::JointCalendar *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::JointCalendar **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Rounding(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    Rounding *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (Rounding *)new Rounding();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Rounding **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Rounding_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    Rounding *arg1 = (Rounding *) 0 ;
    Decimal arg2 ;
    Decimal result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Rounding **)(void *)&jarg1; 
    arg2 = (Decimal)jarg2; 
    {
        try {
            result = (Decimal)((Rounding const *)arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Rounding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Rounding *arg1 = (Rounding *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Rounding **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UpRounding_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    jlong jresult = 0 ;
    Integer arg1 ;
    Integer arg2 ;
    UpRounding *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (Integer)jarg2; 
    {
        try {
            result = (UpRounding *)new UpRounding(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(UpRounding **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UpRounding_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    Integer arg1 ;
    UpRounding *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    {
        try {
            result = (UpRounding *)new UpRounding(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(UpRounding **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UpRounding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    UpRounding *arg1 = (UpRounding *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(UpRounding **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DownRounding_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    jlong jresult = 0 ;
    Integer arg1 ;
    Integer arg2 ;
    DownRounding *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (Integer)jarg2; 
    {
        try {
            result = (DownRounding *)new DownRounding(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(DownRounding **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DownRounding_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    Integer arg1 ;
    DownRounding *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    {
        try {
            result = (DownRounding *)new DownRounding(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(DownRounding **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DownRounding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    DownRounding *arg1 = (DownRounding *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DownRounding **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ClosestRounding_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    jlong jresult = 0 ;
    Integer arg1 ;
    Integer arg2 ;
    ClosestRounding *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (Integer)jarg2; 
    {
        try {
            result = (ClosestRounding *)new ClosestRounding(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(ClosestRounding **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ClosestRounding_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    Integer arg1 ;
    ClosestRounding *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    {
        try {
            result = (ClosestRounding *)new ClosestRounding(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(ClosestRounding **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ClosestRounding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    ClosestRounding *arg1 = (ClosestRounding *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ClosestRounding **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CeilingTruncation_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    jlong jresult = 0 ;
    Integer arg1 ;
    Integer arg2 ;
    CeilingTruncation *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (Integer)jarg2; 
    {
        try {
            result = (CeilingTruncation *)new CeilingTruncation(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(CeilingTruncation **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CeilingTruncation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    Integer arg1 ;
    CeilingTruncation *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    {
        try {
            result = (CeilingTruncation *)new CeilingTruncation(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(CeilingTruncation **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CeilingTruncation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    CeilingTruncation *arg1 = (CeilingTruncation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(CeilingTruncation **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FloorTruncation_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    jlong jresult = 0 ;
    Integer arg1 ;
    Integer arg2 ;
    FloorTruncation *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (Integer)jarg2; 
    {
        try {
            result = (FloorTruncation *)new FloorTruncation(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FloorTruncation **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FloorTruncation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    Integer arg1 ;
    FloorTruncation *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    {
        try {
            result = (FloorTruncation *)new FloorTruncation(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FloorTruncation **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1FloorTruncation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    FloorTruncation *arg1 = (FloorTruncation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(FloorTruncation **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Currency_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Currency **)(void *)&jarg1; 
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->name();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF(result->c_str()); 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Currency_1code(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Currency **)(void *)&jarg1; 
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->code();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF(result->c_str()); 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Currency_1numericCode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Currency *arg1 = (Currency *) 0 ;
    Integer result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Currency **)(void *)&jarg1; 
    {
        try {
            result = (Integer)((Currency const *)arg1)->numericCode();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Currency_1symbol(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Currency **)(void *)&jarg1; 
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->symbol();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF(result->c_str()); 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Currency_1fractionSymbol(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Currency **)(void *)&jarg1; 
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->fractionSymbol();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF(result->c_str()); 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Currency_1fractionsPerUnit(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Currency *arg1 = (Currency *) 0 ;
    Integer result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Currency **)(void *)&jarg1; 
    {
        try {
            result = (Integer)((Currency const *)arg1)->fractionsPerUnit();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Currency_1rounding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Currency *arg1 = (Currency *) 0 ;
    Rounding *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Currency **)(void *)&jarg1; 
    {
        try {
            {
                Rounding const &_result_ref = ((Currency const *)arg1)->rounding();
                result = (Rounding *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Rounding **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Currency_1isValid(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    Currency *arg1 = (Currency *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Currency **)(void *)&jarg1; 
    {
        try {
            result = (bool)((Currency const *)arg1)->isValid();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Currency_1triangulationCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Currency *arg1 = (Currency *) 0 ;
    Currency *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Currency **)(void *)&jarg1; 
    {
        try {
            {
                Currency const &_result_ref = ((Currency const *)arg1)->triangulationCurrency();
                result = (Currency *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Currency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Currency_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Currency *arg1 = (Currency *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Currency **)(void *)&jarg1; 
    {
        try {
            result = Currency___str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Currency_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    Currency *arg1 = (Currency *) 0 ;
    Currency *arg2 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Currency **)(void *)&jarg1; 
    arg2 = *(Currency **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Currency const & reference is null");
        return 0;
    } 
    {
        try {
            result = (bool)Currency___eq__(arg1,(Currency const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Currency_1unEquals(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    Currency *arg1 = (Currency *) 0 ;
    Currency *arg2 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Currency **)(void *)&jarg1; 
    arg2 = *(Currency **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Currency const & reference is null");
        return 0;
    } 
    {
        try {
            result = (bool)Currency___ne__(arg1,(Currency const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Currency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    Currency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (Currency *)new Currency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Currency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Currency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Currency *arg1 = (Currency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Currency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ARSCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::ARSCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::ARSCurrency *)new QuantLib::ARSCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::ARSCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ARSCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::ARSCurrency *arg1 = (QuantLib::ARSCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::ARSCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ATSCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::ATSCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::ATSCurrency *)new QuantLib::ATSCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::ATSCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ATSCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::ATSCurrency *arg1 = (QuantLib::ATSCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::ATSCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1AUDCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::AUDCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::AUDCurrency *)new QuantLib::AUDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::AUDCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1AUDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::AUDCurrency *arg1 = (QuantLib::AUDCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::AUDCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BDTCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::BDTCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::BDTCurrency *)new QuantLib::BDTCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::BDTCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BDTCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::BDTCurrency *arg1 = (QuantLib::BDTCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::BDTCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BEFCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::BEFCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::BEFCurrency *)new QuantLib::BEFCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::BEFCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BEFCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::BEFCurrency *arg1 = (QuantLib::BEFCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::BEFCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BGLCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::BGLCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::BGLCurrency *)new QuantLib::BGLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::BGLCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BGLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::BGLCurrency *arg1 = (QuantLib::BGLCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::BGLCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BRLCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::BRLCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::BRLCurrency *)new QuantLib::BRLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::BRLCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BRLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::BRLCurrency *arg1 = (QuantLib::BRLCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::BRLCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BYRCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::BYRCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::BYRCurrency *)new QuantLib::BYRCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::BYRCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BYRCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::BYRCurrency *arg1 = (QuantLib::BYRCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::BYRCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CADCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::CADCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::CADCurrency *)new QuantLib::CADCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::CADCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CADCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::CADCurrency *arg1 = (QuantLib::CADCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::CADCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CHFCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::CHFCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::CHFCurrency *)new QuantLib::CHFCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::CHFCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CHFCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::CHFCurrency *arg1 = (QuantLib::CHFCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::CHFCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CLPCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::CLPCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::CLPCurrency *)new QuantLib::CLPCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::CLPCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CLPCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::CLPCurrency *arg1 = (QuantLib::CLPCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::CLPCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CNYCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::CNYCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::CNYCurrency *)new QuantLib::CNYCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::CNYCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CNYCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::CNYCurrency *arg1 = (QuantLib::CNYCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::CNYCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1COPCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::COPCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::COPCurrency *)new QuantLib::COPCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::COPCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1COPCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::COPCurrency *arg1 = (QuantLib::COPCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::COPCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CYPCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::CYPCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::CYPCurrency *)new QuantLib::CYPCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::CYPCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CYPCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::CYPCurrency *arg1 = (QuantLib::CYPCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::CYPCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CZKCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::CZKCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::CZKCurrency *)new QuantLib::CZKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::CZKCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CZKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::CZKCurrency *arg1 = (QuantLib::CZKCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::CZKCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DEMCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::DEMCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::DEMCurrency *)new QuantLib::DEMCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::DEMCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DEMCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::DEMCurrency *arg1 = (QuantLib::DEMCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::DEMCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DKKCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::DKKCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::DKKCurrency *)new QuantLib::DKKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::DKKCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DKKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::DKKCurrency *arg1 = (QuantLib::DKKCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::DKKCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1EEKCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::EEKCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::EEKCurrency *)new QuantLib::EEKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::EEKCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1EEKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::EEKCurrency *arg1 = (QuantLib::EEKCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::EEKCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ESPCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::ESPCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::ESPCurrency *)new QuantLib::ESPCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::ESPCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ESPCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::ESPCurrency *arg1 = (QuantLib::ESPCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::ESPCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1EURCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::EURCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::EURCurrency *)new QuantLib::EURCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::EURCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1EURCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::EURCurrency *arg1 = (QuantLib::EURCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::EURCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FIMCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::FIMCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::FIMCurrency *)new QuantLib::FIMCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::FIMCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1FIMCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::FIMCurrency *arg1 = (QuantLib::FIMCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::FIMCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FRFCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::FRFCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::FRFCurrency *)new QuantLib::FRFCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::FRFCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1FRFCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::FRFCurrency *arg1 = (QuantLib::FRFCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::FRFCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1GBPCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::GBPCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::GBPCurrency *)new QuantLib::GBPCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::GBPCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1GBPCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::GBPCurrency *arg1 = (QuantLib::GBPCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::GBPCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1GRDCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::GRDCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::GRDCurrency *)new QuantLib::GRDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::GRDCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1GRDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::GRDCurrency *arg1 = (QuantLib::GRDCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::GRDCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1HKDCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::HKDCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::HKDCurrency *)new QuantLib::HKDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::HKDCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1HKDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::HKDCurrency *arg1 = (QuantLib::HKDCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::HKDCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1HUFCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::HUFCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::HUFCurrency *)new QuantLib::HUFCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::HUFCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1HUFCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::HUFCurrency *arg1 = (QuantLib::HUFCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::HUFCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IEPCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::IEPCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::IEPCurrency *)new QuantLib::IEPCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::IEPCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IEPCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::IEPCurrency *arg1 = (QuantLib::IEPCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::IEPCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ILSCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::ILSCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::ILSCurrency *)new QuantLib::ILSCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::ILSCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ILSCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::ILSCurrency *arg1 = (QuantLib::ILSCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::ILSCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1INRCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::INRCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::INRCurrency *)new QuantLib::INRCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::INRCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1INRCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::INRCurrency *arg1 = (QuantLib::INRCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::INRCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IQDCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::IQDCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::IQDCurrency *)new QuantLib::IQDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::IQDCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IQDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::IQDCurrency *arg1 = (QuantLib::IQDCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::IQDCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IRRCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::IRRCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::IRRCurrency *)new QuantLib::IRRCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::IRRCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IRRCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::IRRCurrency *arg1 = (QuantLib::IRRCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::IRRCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ISKCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::ISKCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::ISKCurrency *)new QuantLib::ISKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::ISKCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ISKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::ISKCurrency *arg1 = (QuantLib::ISKCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::ISKCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ITLCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::ITLCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::ITLCurrency *)new QuantLib::ITLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::ITLCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ITLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::ITLCurrency *arg1 = (QuantLib::ITLCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::ITLCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JPYCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::JPYCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::JPYCurrency *)new QuantLib::JPYCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::JPYCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1JPYCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::JPYCurrency *arg1 = (QuantLib::JPYCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::JPYCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1KRWCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::KRWCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::KRWCurrency *)new QuantLib::KRWCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::KRWCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1KRWCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::KRWCurrency *arg1 = (QuantLib::KRWCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::KRWCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1KWDCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::KWDCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::KWDCurrency *)new QuantLib::KWDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::KWDCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1KWDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::KWDCurrency *arg1 = (QuantLib::KWDCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::KWDCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LTLCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::LTLCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::LTLCurrency *)new QuantLib::LTLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::LTLCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LTLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::LTLCurrency *arg1 = (QuantLib::LTLCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::LTLCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LUFCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::LUFCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::LUFCurrency *)new QuantLib::LUFCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::LUFCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LUFCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::LUFCurrency *arg1 = (QuantLib::LUFCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::LUFCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LVLCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::LVLCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::LVLCurrency *)new QuantLib::LVLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::LVLCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LVLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::LVLCurrency *arg1 = (QuantLib::LVLCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::LVLCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1MTLCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::MTLCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::MTLCurrency *)new QuantLib::MTLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::MTLCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1MTLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::MTLCurrency *arg1 = (QuantLib::MTLCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::MTLCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1MXNCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::MXNCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::MXNCurrency *)new QuantLib::MXNCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::MXNCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1MXNCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::MXNCurrency *arg1 = (QuantLib::MXNCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::MXNCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NLGCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::NLGCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::NLGCurrency *)new QuantLib::NLGCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::NLGCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NLGCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::NLGCurrency *arg1 = (QuantLib::NLGCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::NLGCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NOKCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::NOKCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::NOKCurrency *)new QuantLib::NOKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::NOKCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NOKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::NOKCurrency *arg1 = (QuantLib::NOKCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::NOKCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NPRCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::NPRCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::NPRCurrency *)new QuantLib::NPRCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::NPRCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NPRCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::NPRCurrency *arg1 = (QuantLib::NPRCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::NPRCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NZDCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::NZDCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::NZDCurrency *)new QuantLib::NZDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::NZDCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NZDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::NZDCurrency *arg1 = (QuantLib::NZDCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::NZDCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PKRCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::PKRCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::PKRCurrency *)new QuantLib::PKRCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::PKRCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PKRCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::PKRCurrency *arg1 = (QuantLib::PKRCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::PKRCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PLNCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::PLNCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::PLNCurrency *)new QuantLib::PLNCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::PLNCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PLNCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::PLNCurrency *arg1 = (QuantLib::PLNCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::PLNCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PTECurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::PTECurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::PTECurrency *)new QuantLib::PTECurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::PTECurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PTECurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::PTECurrency *arg1 = (QuantLib::PTECurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::PTECurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ROLCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::ROLCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::ROLCurrency *)new QuantLib::ROLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::ROLCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ROLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::ROLCurrency *arg1 = (QuantLib::ROLCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::ROLCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SARCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::SARCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::SARCurrency *)new QuantLib::SARCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::SARCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SARCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::SARCurrency *arg1 = (QuantLib::SARCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::SARCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SEKCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::SEKCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::SEKCurrency *)new QuantLib::SEKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::SEKCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SEKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::SEKCurrency *arg1 = (QuantLib::SEKCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::SEKCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SGDCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::SGDCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::SGDCurrency *)new QuantLib::SGDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::SGDCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SGDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::SGDCurrency *arg1 = (QuantLib::SGDCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::SGDCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SITCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::SITCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::SITCurrency *)new QuantLib::SITCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::SITCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SITCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::SITCurrency *arg1 = (QuantLib::SITCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::SITCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SKKCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::SKKCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::SKKCurrency *)new QuantLib::SKKCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::SKKCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SKKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::SKKCurrency *arg1 = (QuantLib::SKKCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::SKKCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1THBCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::THBCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::THBCurrency *)new QuantLib::THBCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::THBCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1THBCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::THBCurrency *arg1 = (QuantLib::THBCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::THBCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1TRLCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::TRLCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::TRLCurrency *)new QuantLib::TRLCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::TRLCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1TRLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::TRLCurrency *arg1 = (QuantLib::TRLCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::TRLCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1TRYCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::TRYCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::TRYCurrency *)new QuantLib::TRYCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::TRYCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1TRYCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::TRYCurrency *arg1 = (QuantLib::TRYCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::TRYCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1TTDCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::TTDCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::TTDCurrency *)new QuantLib::TTDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::TTDCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1TTDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::TTDCurrency *arg1 = (QuantLib::TTDCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::TTDCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1TWDCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::TWDCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::TWDCurrency *)new QuantLib::TWDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::TWDCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1TWDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::TWDCurrency *arg1 = (QuantLib::TWDCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::TWDCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1USDCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::USDCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::USDCurrency *)new QuantLib::USDCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::USDCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1USDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::USDCurrency *arg1 = (QuantLib::USDCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::USDCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1VEBCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::VEBCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::VEBCurrency *)new QuantLib::VEBCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::VEBCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1VEBCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::VEBCurrency *arg1 = (QuantLib::VEBCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::VEBCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ZARCurrency(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    QuantLib::ZARCurrency *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (QuantLib::ZARCurrency *)new QuantLib::ZARCurrency();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(QuantLib::ZARCurrency **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ZARCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    QuantLib::ZARCurrency *arg1 = (QuantLib::ZARCurrency *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(QuantLib::ZARCurrency **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LinearInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeLinearInterpolation *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    arg2 = *(Array **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    {
        try {
            result = (SafeLinearInterpolation *)new SafeLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(SafeLinearInterpolation **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LinearInterpolation_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeLinearInterpolation **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LinearInterpolation_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
    Real arg2 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeLinearInterpolation **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LinearInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeLinearInterpolation **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LogLinearInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeLogLinearInterpolation *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    arg2 = *(Array **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    {
        try {
            result = (SafeLogLinearInterpolation *)new SafeLogLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(SafeLogLinearInterpolation **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LogLinearInterpolation_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeLogLinearInterpolation **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LogLinearInterpolation_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
    Real arg2 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeLogLinearInterpolation **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LogLinearInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeLogLinearInterpolation **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BackwardFlatInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeBackwardFlatInterpolation *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    arg2 = *(Array **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    {
        try {
            result = (SafeBackwardFlatInterpolation *)new SafeBackwardFlatInterpolation((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(SafeBackwardFlatInterpolation **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BackwardFlatInterpolation_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeBackwardFlatInterpolation **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BackwardFlatInterpolation_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
    Real arg2 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeBackwardFlatInterpolation **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BackwardFlatInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeBackwardFlatInterpolation **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ForwardFlatInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeForwardFlatInterpolation *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    arg2 = *(Array **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    {
        try {
            result = (SafeForwardFlatInterpolation *)new SafeForwardFlatInterpolation((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(SafeForwardFlatInterpolation **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_ForwardFlatInterpolation_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeForwardFlatInterpolation **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_ForwardFlatInterpolation_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
    Real arg2 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeForwardFlatInterpolation **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ForwardFlatInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeForwardFlatInterpolation **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CubicSpline(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeNaturalCubicSpline *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    arg2 = *(Array **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    {
        try {
            result = (SafeNaturalCubicSpline *)new SafeNaturalCubicSpline((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(SafeNaturalCubicSpline **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CubicSpline_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalCubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CubicSpline_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalCubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CubicSpline_1derivative_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalCubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)SafeNaturalCubicSpline_derivative__SWIG_0(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CubicSpline_1derivative_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalCubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)SafeNaturalCubicSpline_derivative__SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CubicSpline_1secondDerivative_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalCubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)SafeNaturalCubicSpline_secondDerivative__SWIG_0(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CubicSpline_1secondDerivative_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalCubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)SafeNaturalCubicSpline_secondDerivative__SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CubicSpline(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalCubicSpline **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1MonotonicCubicSpline(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeNaturalMonotonicCubicSpline *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    arg2 = *(Array **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    {
        try {
            result = (SafeNaturalMonotonicCubicSpline *)new SafeNaturalMonotonicCubicSpline((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(SafeNaturalMonotonicCubicSpline **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_MonotonicCubicSpline_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalMonotonicCubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_MonotonicCubicSpline_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalMonotonicCubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_MonotonicCubicSpline_1derivative_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalMonotonicCubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_MonotonicCubicSpline_1derivative_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalMonotonicCubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_MonotonicCubicSpline_1secondDerivative_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalMonotonicCubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_MonotonicCubicSpline_1secondDerivative_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalMonotonicCubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1MonotonicCubicSpline(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeNaturalMonotonicCubicSpline **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BilinearInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix *arg3 = 0 ;
    SafeBilinearInterpolation *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    arg2 = *(Array **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    arg3 = *(Matrix **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
        return 0;
    } 
    {
        try {
            result = (SafeBilinearInterpolation *)new SafeBilinearInterpolation((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(SafeBilinearInterpolation **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BilinearInterpolation_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jboolean jarg4) {
    jdouble jresult = 0 ;
    SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
    Real arg2 ;
    Real arg3 ;
    bool arg4 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeBilinearInterpolation **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = (Real)jarg3; 
    arg4 = jarg4 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BilinearInterpolation_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3) {
    jdouble jresult = 0 ;
    SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
    Real arg2 ;
    Real arg3 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeBilinearInterpolation **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = (Real)jarg3; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BilinearInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeBilinearInterpolation **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BicubicSpline(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix *arg3 = 0 ;
    SafeBicubicSpline *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Array **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    arg2 = *(Array **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
        return 0;
    } 
    arg3 = *(Matrix **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
        return 0;
    } 
    {
        try {
            result = (SafeBicubicSpline *)new SafeBicubicSpline((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(SafeBicubicSpline **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BicubicSpline_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jboolean jarg4) {
    jdouble jresult = 0 ;
    SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
    Real arg2 ;
    Real arg3 ;
    bool arg4 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeBicubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = (Real)jarg3; 
    arg4 = jarg4 ? true : false; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BicubicSpline_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3) {
    jdouble jresult = 0 ;
    SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
    Real arg2 ;
    Real arg3 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeBicubicSpline **)(void *)&jarg1; 
    arg2 = (Real)jarg2; 
    arg3 = (Real)jarg3; 
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BicubicSpline(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SafeBicubicSpline **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    YieldTermStructure *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (YieldTermStructure *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(YieldTermStructure **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_YieldTermStructure_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    boost::shared_ptr<Observable > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = boost_shared_ptr_Sl_YieldTermStructure_Sg__asObservable(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<Observable > **)(void *)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    SwigValueWrapper<DayCounter > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(DayCounter **)(void *)&jresult = new DayCounter((DayCounter &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1calendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    SwigValueWrapper<Calendar > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (*arg1)->calendar();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Calendar **)(void *)&jresult = new Calendar((Calendar &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1referenceDate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1maxDate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1maxTime(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1discount_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    bool arg3 ;
    DiscountFactor result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1discount_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jdouble jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DiscountFactor result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1discount_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    bool arg3 ;
    DiscountFactor result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1discount_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    DiscountFactor result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1zeroRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jint jarg5, jboolean jarg6) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    bool arg6 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    arg6 = jarg6 ? true : false; 
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1zeroRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jint jarg5) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1zeroRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1zeroRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jint jarg3, jint jarg4, jboolean jarg5) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 ;
    bool arg5 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    arg4 = (Frequency)jarg4; 
    arg5 = jarg5 ? true : false; 
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1zeroRate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jint jarg3, jint jarg4) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    arg4 = (Frequency)jarg4; 
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1zeroRate_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jint jarg3) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1forwardRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5, jint jarg6, jboolean jarg7) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    bool arg7 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    arg7 = jarg7 ? true : false; 
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6,arg7);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1forwardRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5, jint jarg6) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1forwardRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1forwardRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jint jarg4, jint jarg5, jboolean jarg6) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    Frequency arg5 ;
    bool arg6 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Time)jarg3; 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    arg6 = jarg6 ? true : false; 
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1forwardRate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jint jarg4, jint jarg5) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    Frequency arg5 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Time)jarg3; 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1forwardRate_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jint jarg4) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Time)jarg3; 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1enableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            (*arg1)->enableExtrapolation();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1disableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            (*arg1)->disableExtrapolation();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1allowsExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (bool)(*arg1)->allowsExtrapolation();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1YieldTermStructure(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (boost::shared_ptr<YieldTermStructure > *)new boost::shared_ptr<YieldTermStructure >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<YieldTermStructure > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1YieldTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1YieldTermStructureHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<YieldTermStructure > *arg1 = 0 ;
    Handle<YieldTermStructure > *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (Handle<YieldTermStructure > *)new Handle<YieldTermStructure >((boost::shared_ptr<YieldTermStructure > const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Handle<YieldTermStructure > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1YieldTermStructureHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (Handle<YieldTermStructure > *)new Handle<YieldTermStructure >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Handle<YieldTermStructure > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    boost::shared_ptr<YieldTermStructure > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<YieldTermStructure > **)(void *)&jresult = new boost::shared_ptr<YieldTermStructure >((boost::shared_ptr<YieldTermStructure > &)result); 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1linkTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    boost::shared_ptr<YieldTermStructure > *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(boost::shared_ptr<YieldTermStructure > **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<YieldTermStructure > const & reference is null");
        return ;
    } 
    {
        try {
            (arg1)->linkTo((boost::shared_ptr<YieldTermStructure > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (bool)(arg1)->empty();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    boost::shared_ptr<Observable > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = Handle_Sl_YieldTermStructure_Sg__asObservable(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<Observable > **)(void *)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    SwigValueWrapper<DayCounter > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(DayCounter **)(void *)&jresult = new DayCounter((DayCounter &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1calendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    SwigValueWrapper<Calendar > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (*arg1)->calendar();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Calendar **)(void *)&jresult = new Calendar((Calendar &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1referenceDate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1maxDate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1maxTime(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1discount_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    bool arg3 ;
    DiscountFactor result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1discount_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jdouble jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DiscountFactor result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1discount_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jboolean jarg3) {
    jdouble jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    bool arg3 ;
    DiscountFactor result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = jarg3 ? true : false; 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1discount_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    jdouble jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    DiscountFactor result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1zeroRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jint jarg5, jboolean jarg6) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    bool arg6 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    arg6 = jarg6 ? true : false; 
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1zeroRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jint jarg5) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1zeroRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1zeroRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jint jarg3, jint jarg4, jboolean jarg5) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 ;
    bool arg5 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    arg4 = (Frequency)jarg4; 
    arg5 = jarg5 ? true : false; 
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1zeroRate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jint jarg3, jint jarg4) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    arg4 = (Frequency)jarg4; 
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1zeroRate_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jint jarg3) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Compounding)jarg3; 
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1forwardRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5, jint jarg6, jboolean jarg7) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    bool arg7 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    arg7 = jarg7 ? true : false; 
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6,arg7);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1forwardRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5, jint jarg6) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1forwardRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    {
        try {
            result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1forwardRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jint jarg4, jint jarg5, jboolean jarg6) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    Frequency arg5 ;
    bool arg6 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Time)jarg3; 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    arg6 = jarg6 ? true : false; 
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1forwardRate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jint jarg4, jint jarg5) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    Frequency arg5 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Time)jarg3; 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1forwardRate_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jint jarg4) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Time arg3 ;
    Compounding arg4 ;
    InterestRate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    arg2 = (Time)jarg2; 
    arg3 = (Time)jarg3; 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = (*arg1)->forwardRate(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(InterestRate **)(void *)&jresult = new InterestRate((InterestRate &)result); 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1enableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            (*arg1)->enableExtrapolation();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1disableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            (*arg1)->disableExtrapolation();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1allowsExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            result = (bool)(*arg1)->allowsExtrapolation();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1YieldTermStructureHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ImpliedTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = 0 ;
    Date *arg2 = 0 ;
    ImpliedTermStructurePtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (ImpliedTermStructurePtr *)new_ImpliedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(ImpliedTermStructurePtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ImpliedTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    ImpliedTermStructurePtr *arg1 = (ImpliedTermStructurePtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ImpliedTermStructurePtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ZeroSpreadedTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    ZeroSpreadedTermStructurePtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg2 = *(Handle<Quote > **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (ZeroSpreadedTermStructurePtr *)new_ZeroSpreadedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Handle<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(ZeroSpreadedTermStructurePtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ZeroSpreadedTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    ZeroSpreadedTermStructurePtr *arg1 = (ZeroSpreadedTermStructurePtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ZeroSpreadedTermStructurePtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ForwardSpreadedTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Handle<YieldTermStructure > *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    ForwardSpreadedTermStructurePtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<YieldTermStructure > **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg2 = *(Handle<Quote > **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (ForwardSpreadedTermStructurePtr *)new_ForwardSpreadedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Handle<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(ForwardSpreadedTermStructurePtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ForwardSpreadedTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    ForwardSpreadedTermStructurePtr *arg1 = (ForwardSpreadedTermStructurePtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ForwardSpreadedTermStructurePtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jint jarg5) {
    jlong jresult = 0 ;
    Date *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    FlatForwardPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg2 = *(Handle<Quote > **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
        return 0;
    } 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_0((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FlatForwardPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
    jlong jresult = 0 ;
    Date *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    FlatForwardPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg2 = *(Handle<Quote > **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
        return 0;
    } 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_0((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FlatForwardPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Date *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    FlatForwardPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg2 = *(Handle<Quote > **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
        return 0;
    } 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_0((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FlatForwardPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jlong jarg3, jint jarg4, jint jarg5) {
    jlong jresult = 0 ;
    Date *arg1 = 0 ;
    Rate arg2 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    FlatForwardPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg2 = (Rate)jarg2; 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    arg5 = (Frequency)jarg5; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_3((Date const &)*arg1,arg2,(DayCounter const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FlatForwardPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jlong jarg3, jint jarg4) {
    jlong jresult = 0 ;
    Date *arg1 = 0 ;
    Rate arg2 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    FlatForwardPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg2 = (Rate)jarg2; 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg4 = (Compounding)jarg4; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_3((Date const &)*arg1,arg2,(DayCounter const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FlatForwardPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Date *arg1 = 0 ;
    Rate arg2 ;
    DayCounter *arg3 = 0 ;
    FlatForwardPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Date **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg2 = (Rate)jarg2; 
    arg3 = *(DayCounter **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_3((Date const &)*arg1,arg2,(DayCounter const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FlatForwardPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5, jint jarg6) {
    jlong jresult = 0 ;
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Handle<Quote > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    FlatForwardPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg3 = *(Handle<Quote > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_6(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FlatForwardPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
    jlong jresult = 0 ;
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Handle<Quote > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    FlatForwardPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg3 = *(Handle<Quote > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_6(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FlatForwardPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Handle<Quote > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    FlatForwardPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg3 = *(Handle<Quote > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_6(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FlatForwardPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_19(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jdouble jarg3, jlong jarg4, jint jarg5, jint jarg6) {
    jlong jresult = 0 ;
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Rate arg3 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    FlatForwardPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg3 = (Rate)jarg3; 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    arg6 = (Frequency)jarg6; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_9(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FlatForwardPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_110(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jdouble jarg3, jlong jarg4, jint jarg5) {
    jlong jresult = 0 ;
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Rate arg3 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    FlatForwardPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg3 = (Rate)jarg3; 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg5 = (Compounding)jarg5; 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_9(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FlatForwardPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_111(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jdouble jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    Calendar *arg2 = 0 ;
    Rate arg3 ;
    DayCounter *arg4 = 0 ;
    FlatForwardPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg3 = (Rate)jarg3; 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_9(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(FlatForwardPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1FlatForward(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    FlatForwardPtr *arg1 = (FlatForwardPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(FlatForwardPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BlackModel_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<BlackModel > *arg1 = (boost::shared_ptr<BlackModel > *) 0 ;
    BlackModel *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<BlackModel > **)(void *)&jarg1; 
    {
        try {
            result = (BlackModel *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(BlackModel **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_BlackModel_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    boost::shared_ptr<BlackModel > *arg1 = (boost::shared_ptr<BlackModel > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<BlackModel > **)(void *)&jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_BlackModel_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BlackModel(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Handle<Quote > *arg1 = 0 ;
    Handle<YieldTermStructure > *arg2 = 0 ;
    boost::shared_ptr<BlackModel > *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<Quote > **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
        return 0;
    } 
    arg2 = *(Handle<YieldTermStructure > **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (boost::shared_ptr<BlackModel > *)new_boost_shared_ptr_Sl_BlackModel_Sg_((Handle<Quote > const &)*arg1,(Handle<YieldTermStructure > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<BlackModel > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BlackModel(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    boost::shared_ptr<BlackModel > *arg1 = (boost::shared_ptr<BlackModel > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<BlackModel > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PricingEngine_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<PricingEngine > *arg1 = (boost::shared_ptr<PricingEngine > *) 0 ;
    PricingEngine *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<PricingEngine > **)(void *)&jarg1; 
    {
        try {
            result = (PricingEngine *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(PricingEngine **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_PricingEngine_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    boost::shared_ptr<PricingEngine > *arg1 = (boost::shared_ptr<PricingEngine > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<PricingEngine > **)(void *)&jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_PricingEngine_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PricingEngine(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    boost::shared_ptr<PricingEngine > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (boost::shared_ptr<PricingEngine > *)new boost::shared_ptr<PricingEngine >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<PricingEngine > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PricingEngine(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    boost::shared_ptr<PricingEngine > *arg1 = (boost::shared_ptr<PricingEngine > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<PricingEngine > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Instrument_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    Instrument *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Instrument > **)(void *)&jarg1; 
    {
        try {
            result = (Instrument *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Instrument **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Instrument_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Instrument > **)(void *)&jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_Instrument_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Instrument_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    boost::shared_ptr<Observable > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Instrument > **)(void *)&jarg1; 
    {
        try {
            result = boost_shared_ptr_Sl_Instrument_Sg__asObservable(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<Observable > **)(void *)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Instrument_1NPV(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Instrument > **)(void *)&jarg1; 
    {
        try {
            result = (Real)(*arg1)->NPV();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Instrument_1errorEstimate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    Real result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Instrument > **)(void *)&jarg1; 
    {
        try {
            result = (Real)(*arg1)->errorEstimate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Instrument_1isExpired(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Instrument > **)(void *)&jarg1; 
    {
        try {
            result = (bool)(*arg1)->isExpired();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Instrument_1setPricingEngine(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    boost::shared_ptr<PricingEngine > *arg2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Instrument > **)(void *)&jarg1; 
    arg2 = *(boost::shared_ptr<PricingEngine > **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<PricingEngine > const & reference is null");
        return ;
    } 
    {
        try {
            (*arg1)->setPricingEngine((boost::shared_ptr<PricingEngine > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Instrument_1recalculate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Instrument > **)(void *)&jarg1; 
    {
        try {
            (*arg1)->recalculate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Instrument_1freeze(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Instrument > **)(void *)&jarg1; 
    {
        try {
            (*arg1)->freeze();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Instrument_1unfreeze(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Instrument > **)(void *)&jarg1; 
    {
        try {
            (*arg1)->unfreeze();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Instrument(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    boost::shared_ptr<Instrument > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (boost::shared_ptr<Instrument > *)new boost::shared_ptr<Instrument >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<Instrument > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Instrument(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Instrument > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Stock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Handle<Quote > *arg1 = 0 ;
    StockPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Handle<Quote > **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (StockPtr *)new_StockPtr((Handle<Quote > const &)*arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(StockPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Stock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    StockPtr *arg1 = (StockPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(StockPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IntVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    std::vector<int > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (std::vector<int > *)new std::vector<int >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<int > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IntVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    unsigned int arg1 ;
    std::vector<int > *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (unsigned int)jarg1; 
    {
        try {
            result = (std::vector<int > *)new std::vector<int >(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<int > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<int > **)(void *)&jarg1; 
    {
        try {
            result = (unsigned int)((std::vector<int > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<int > **)(void *)&jarg1; 
    {
        try {
            result = (bool)((std::vector<int > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<int > **)(void *)&jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<int > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            (arg1)->push_back(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<int > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = (int)std_vector_Sl_int_Sg__get(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    int arg2 ;
    int arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<int > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    {
        try {
            try {
                std_vector_Sl_int_Sg__set(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IntVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<int > *arg1 = (std::vector<int > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<int > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoubleVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    std::vector<double > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (std::vector<double > *)new std::vector<double >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<double > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoubleVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    unsigned int arg1 ;
    std::vector<double > *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (unsigned int)jarg1; 
    {
        try {
            result = (std::vector<double > *)new std::vector<double >(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<double > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<double > **)(void *)&jarg1; 
    {
        try {
            result = (unsigned int)((std::vector<double > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<double > **)(void *)&jarg1; 
    {
        try {
            result = (bool)((std::vector<double > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<double > **)(void *)&jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<double > **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    {
        try {
            (arg1)->push_back(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jdouble jresult = 0 ;
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<double > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = (double)std_vector_Sl_double_Sg__get(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jdouble jarg3) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    int arg2 ;
    double arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<double > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (double)jarg3; 
    {
        try {
            try {
                std_vector_Sl_double_Sg__set(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DoubleVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<double > *arg1 = (std::vector<double > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<double > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1StrVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    std::vector<std::string > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (std::vector<std::string > *)new std::vector<std::string >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<std::string > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1StrVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    unsigned int arg1 ;
    std::vector<std::string > *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (unsigned int)jarg1; 
    {
        try {
            result = (std::vector<std::string > *)new std::vector<std::string >(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<std::string > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<std::string > **)(void *)&jarg1; 
    {
        try {
            result = (unsigned int)((std::vector<std::string > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<std::string > **)(void *)&jarg1; 
    {
        try {
            result = (bool)((std::vector<std::string > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<std::string > **)(void *)&jarg1; 
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    std::string arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<std::string > **)(void *)&jarg1; 
    if(!jarg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    } 
    const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
    if (!arg2_pstr) return ;
    arg2 =  std::string(arg2_pstr);
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
    {
        try {
            (arg1)->push_back(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    int arg2 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<std::string > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        try {
            try {
                result = std_vector_Sl_std_string_Sg__get(arg1,arg2);
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return 0; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    int arg2 ;
    std::string arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<std::string > **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    if(!jarg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    } 
    const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
    if (!arg3_pstr) return ;
    arg3 =  std::string(arg3_pstr);
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
    {
        try {
            try {
                std_vector_Sl_std_string_Sg__set(arg1,arg2,arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
                return ; 
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1StrVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<std::string > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1HistoryEntry(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    HistoryEntry *arg1 = (HistoryEntry *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(HistoryEntry **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1History(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    std::vector<Date > *arg1 = 0 ;
    std::vector<Real > *arg2 = 0 ;
    History *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Date > **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<Date > const & reference is null");
        return 0;
    } 
    arg2 = *(std::vector<Real > **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<Real > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (History *)new History((std::vector<Date > const &)*arg1,(std::vector<double > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(History **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_History_1firstDate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    History *arg1 = (History *) 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(History **)(void *)&jarg1; 
    {
        try {
            result = ((History const *)arg1)->firstDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_History_1lastDate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    History *arg1 = (History *) 0 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(History **)(void *)&jarg1; 
    {
        try {
            result = ((History const *)arg1)->lastDate();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_History_1_1_1len_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    History *arg1 = (History *) 0 ;
    Size result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(History **)(void *)&jarg1; 
    {
        try {
            result = History___len__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1History(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    History *arg1 = (History *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(History **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IndexManager_1instance(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    IndexManager *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            {
                IndexManager &_result_ref = IndexManager::instance();
                result = (IndexManager *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(IndexManager **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IndexManager_1setHistory(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
    IndexManager *arg1 = (IndexManager *) 0 ;
    std::string *arg2 = 0 ;
    History *arg3 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(IndexManager **)(void *)&jarg1; 
    if(!jarg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return ;
    }
    const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
    if (!arg2_pstr) return ;
    std::string arg2_str(arg2_pstr);
    arg2 = &arg2_str;
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
    arg3 = *(History **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "History const & reference is null");
        return ;
    } 
    {
        try {
            (arg1)->setHistory((std::string const &)*arg2,(History const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IndexManager_1getHistory(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    IndexManager *arg1 = (IndexManager *) 0 ;
    std::string *arg2 = 0 ;
    History *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(IndexManager **)(void *)&jarg1; 
    if(!jarg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
    if (!arg2_pstr) return 0;
    std::string arg2_str(arg2_pstr);
    arg2 = &arg2_str;
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
    {
        try {
            {
                History const &_result_ref = ((IndexManager const *)arg1)->getHistory((std::string const &)*arg2);
                result = (History *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(History **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IndexManager_1hasHistory(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jboolean jresult = 0 ;
    IndexManager *arg1 = (IndexManager *) 0 ;
    std::string *arg2 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(IndexManager **)(void *)&jarg1; 
    if(!jarg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
    if (!arg2_pstr) return 0;
    std::string arg2_str(arg2_pstr);
    arg2 = &arg2_str;
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
    {
        try {
            result = (bool)((IndexManager const *)arg1)->hasHistory((std::string const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IndexManager_1histories(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    IndexManager *arg1 = (IndexManager *) 0 ;
    std::vector<std::string > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(IndexManager **)(void *)&jarg1; 
    {
        try {
            result = ((IndexManager const *)arg1)->histories();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(std::vector<std::string > **)(void *)&jresult = new std::vector<std::string >((std::vector<std::string > &)result); 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IndexManager(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    IndexManager *arg1 = (IndexManager *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(IndexManager **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Index_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
    Index *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Index > **)(void *)&jarg1; 
    {
        try {
            result = (Index *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Index **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Index_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Index > **)(void *)&jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_Index_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Index_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Index > **)(void *)&jarg1; 
    {
        try {
            result = boost_shared_ptr_Sl_Index_Sg____str__(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Index_1fixing(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jdouble jresult = 0 ;
    boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
    Date *arg2 = 0 ;
    Rate result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Index > **)(void *)&jarg1; 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (Rate)(*arg1)->fixing((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Index_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
    std::string result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Index > **)(void *)&jarg1; 
    {
        try {
            result = (*arg1)->name();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = jenv->NewStringUTF((&result)->c_str()); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Index(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    boost::shared_ptr<Index > *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (boost::shared_ptr<Index > *)new boost::shared_ptr<Index >();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(boost::shared_ptr<Index > **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Index(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<Index > **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Xibor(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jint jarg3, jint jarg4, jlong jarg5, jlong jarg6, jint jarg7, jlong jarg8, jlong jarg9) {
    jlong jresult = 0 ;
    std::string *arg1 = 0 ;
    Integer arg2 ;
    TimeUnit arg3 ;
    Integer arg4 ;
    Currency *arg5 = 0 ;
    Calendar *arg6 = 0 ;
    BusinessDayConvention arg7 ;
    DayCounter *arg8 = 0 ;
    Handle<YieldTermStructure > *arg9 = 0 ;
    XiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    if(!jarg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
        return 0;
    }
    const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
    if (!arg1_pstr) return 0;
    std::string arg1_str(arg1_pstr);
    arg1 = &arg1_str;
    jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
    arg2 = (Integer)jarg2; 
    arg3 = (TimeUnit)jarg3; 
    arg4 = (Integer)jarg4; 
    arg5 = *(Currency **)(void *)&jarg5;
    if(!arg5) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Currency const & reference is null");
        return 0;
    } 
    arg6 = *(Calendar **)(void *)&jarg6;
    if(!arg6) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg7 = (BusinessDayConvention)jarg7; 
    arg8 = *(DayCounter **)(void *)&jarg8;
    if(!arg8) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    arg9 = *(Handle<YieldTermStructure > **)(void *)&jarg9;
    if(!arg9) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (XiborPtr *)new_XiborPtr((std::string const &)*arg1,arg2,arg3,arg4,(Currency const &)*arg5,(Calendar const &)*arg6,arg7,(DayCounter const &)*arg8,(Handle<YieldTermStructure > const &)*arg9);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(XiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Xibor_1tenor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    SwigValueWrapper<Period > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XiborPtr **)(void *)&jarg1; 
    {
        try {
            result = XiborPtr_tenor(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Period **)(void *)&jresult = new Period((Period &)result); 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Xibor_1frequency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    Frequency result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XiborPtr **)(void *)&jarg1; 
    {
        try {
            result = (Frequency)XiborPtr_frequency(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Xibor_1currency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    Currency result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XiborPtr **)(void *)&jarg1; 
    {
        try {
            result = XiborPtr_currency(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Currency **)(void *)&jresult = new Currency((Currency &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Xibor_1calendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    SwigValueWrapper<Calendar > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XiborPtr **)(void *)&jarg1; 
    {
        try {
            result = XiborPtr_calendar(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Calendar **)(void *)&jresult = new Calendar((Calendar &)result); 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Xibor_1isAdjusted(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XiborPtr **)(void *)&jarg1; 
    {
        try {
            result = (bool)XiborPtr_isAdjusted(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Xibor_1businessDayConvention(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    BusinessDayConvention result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XiborPtr **)(void *)&jarg1; 
    {
        try {
            result = (BusinessDayConvention)XiborPtr_businessDayConvention(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Xibor_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    SwigValueWrapper<DayCounter > result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XiborPtr **)(void *)&jarg1; 
    {
        try {
            result = XiborPtr_dayCounter(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(DayCounter **)(void *)&jresult = new DayCounter((DayCounter &)result); 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Xibor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    XiborPtr *arg1 = (XiborPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(XiborPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1AUDLibor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    AUDLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (AUDLiborPtr *)new_AUDLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(AUDLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1AUDLibor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    AUDLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (AUDLiborPtr *)new_AUDLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(AUDLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1AUDLibor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    AUDLiborPtr *arg1 = (AUDLiborPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(AUDLiborPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CADLibor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    CADLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (CADLiborPtr *)new_CADLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(CADLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CADLibor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    CADLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (CADLiborPtr *)new_CADLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(CADLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CADLibor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    CADLiborPtr *arg1 = (CADLiborPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(CADLiborPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Cdor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    CdorPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (CdorPtr *)new_CdorPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(CdorPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Cdor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    CdorPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (CdorPtr *)new_CdorPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(CdorPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Cdor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    CdorPtr *arg1 = (CdorPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(CdorPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CHFLibor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    CHFLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (CHFLiborPtr *)new_CHFLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(CHFLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CHFLibor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    CHFLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (CHFLiborPtr *)new_CHFLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(CHFLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CHFLibor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    CHFLiborPtr *arg1 = (CHFLiborPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(CHFLiborPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Euribor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    EuriborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (EuriborPtr *)new_EuriborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(EuriborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Euribor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    EuriborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (EuriborPtr *)new_EuriborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(EuriborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Euribor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    EuriborPtr *arg1 = (EuriborPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(EuriborPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1GBPLibor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    GBPLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (GBPLiborPtr *)new_GBPLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(GBPLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1GBPLibor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    GBPLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (GBPLiborPtr *)new_GBPLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(GBPLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1GBPLibor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    GBPLiborPtr *arg1 = (GBPLiborPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(GBPLiborPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Jibar_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    JibarPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (JibarPtr *)new_JibarPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(JibarPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Jibar_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    JibarPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (JibarPtr *)new_JibarPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(JibarPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Jibar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    JibarPtr *arg1 = (JibarPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(JibarPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JPYLibor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    JPYLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (JPYLiborPtr *)new_JPYLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(JPYLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JPYLibor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    JPYLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (JPYLiborPtr *)new_JPYLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(JPYLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1JPYLibor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    JPYLiborPtr *arg1 = (JPYLiborPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(JPYLiborPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Tibor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    TiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (TiborPtr *)new_TiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(TiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Tibor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    TiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (TiborPtr *)new_TiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(TiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Tibor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    TiborPtr *arg1 = (TiborPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(TiborPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1TRLibor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    TRLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (TRLiborPtr *)new_TRLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(TRLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1TRLibor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    TRLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (TRLiborPtr *)new_TRLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(TRLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1TRLibor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    TRLiborPtr *arg1 = (TRLiborPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(TRLiborPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1USDLibor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    USDLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (USDLiborPtr *)new_USDLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(USDLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1USDLibor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    USDLiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (USDLiborPtr *)new_USDLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(USDLiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1USDLibor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    USDLiborPtr *arg1 = (USDLiborPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(USDLiborPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Zibor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    ZiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    arg4 = *(DayCounter **)(void *)&jarg4;
    if(!arg4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
        return 0;
    } 
    {
        try {
            result = (ZiborPtr *)new_ZiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(ZiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Zibor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    Integer arg1 ;
    TimeUnit arg2 ;
    Handle<YieldTermStructure > *arg3 = 0 ;
    ZiborPtr *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (Integer)jarg1; 
    arg2 = (TimeUnit)jarg2; 
    arg3 = *(Handle<YieldTermStructure > **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
        return 0;
    } 
    {
        try {
            result = (ZiborPtr *)new_ZiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(ZiborPtr **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Zibor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    ZiborPtr *arg1 = (ZiborPtr *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ZiborPtr **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Schedule_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jint jarg5, jlong jarg6, jboolean jarg7, jboolean jarg8) {
    jlong jresult = 0 ;
    Calendar *arg1 = 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Frequency arg4 ;
    BusinessDayConvention arg5 ;
    Date *arg6 = 0 ;
    bool arg7 ;
    bool arg8 ;
    Schedule *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = (Frequency)jarg4; 
    arg5 = (BusinessDayConvention)jarg5; 
    arg6 = *(Date **)(void *)&jarg6;
    if(!arg6) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg7 = jarg7 ? true : false; 
    arg8 = jarg8 ? true : false; 
    {
        try {
            result = (Schedule *)new Schedule((Calendar const &)*arg1,(Date const &)*arg2,(Date const &)*arg3,arg4,arg5,(Date const &)*arg6,arg7,arg8);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Schedule **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Schedule_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jint jarg5, jlong jarg6, jboolean jarg7) {
    jlong jresult = 0 ;
    Calendar *arg1 = 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Frequency arg4 ;
    BusinessDayConvention arg5 ;
    Date *arg6 = 0 ;
    bool arg7 ;
    Schedule *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = (Frequency)jarg4; 
    arg5 = (BusinessDayConvention)jarg5; 
    arg6 = *(Date **)(void *)&jarg6;
    if(!arg6) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg7 = jarg7 ? true : false; 
    {
        try {
            result = (Schedule *)new Schedule((Calendar const &)*arg1,(Date const &)*arg2,(Date const &)*arg3,arg4,arg5,(Date const &)*arg6,arg7);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Schedule **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Schedule_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jint jarg5, jlong jarg6) {
    jlong jresult = 0 ;
    Calendar *arg1 = 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Frequency arg4 ;
    BusinessDayConvention arg5 ;
    Date *arg6 = 0 ;
    Schedule *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = (Frequency)jarg4; 
    arg5 = (BusinessDayConvention)jarg5; 
    arg6 = *(Date **)(void *)&jarg6;
    if(!arg6) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    {
        try {
            result = (Schedule *)new Schedule((Calendar const &)*arg1,(Date const &)*arg2,(Date const &)*arg3,arg4,arg5,(Date const &)*arg6);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Schedule **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Schedule_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jint jarg5) {
    jlong jresult = 0 ;
    Calendar *arg1 = 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Frequency arg4 ;
    BusinessDayConvention arg5 ;
    Schedule *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Calendar **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg2 = *(Date **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg3 = *(Date **)(void *)&jarg3;
    if(!arg3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
        return 0;
    } 
    arg4 = (Frequency)jarg4; 
    arg5 = (BusinessDayConvention)jarg5; 
    {
        try {
            result = (Schedule *)new Schedule((Calendar const &)*arg1,(Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Schedule **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Schedule_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    jlong jresult = 0 ;
    std::vector<Date > *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    BusinessDayConvention arg3 ;
    Schedule *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(std::vector<Date > **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<Date > const & reference is null");
        return 0;
    } 
    arg2 = *(Calendar **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
        return 0;
    } 
    arg3 = (BusinessDayConvention)jarg3; 
    {
        try {
            result = (Schedule *)new Schedule((std::vector<Date > const &)*arg1,(Calendar const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Schedule **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Schedule_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Schedule *arg1 = (Schedule *) 0 ;
    Size result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Schedule **)(void *)&jarg1; 
    {
        try {
            result = ((Schedule const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Schedule_1date(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    Schedule *arg1 = (Schedule *) 0 ;
    Size arg2 ;
    Date result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Schedule **)(void *)&jarg1; 
    arg2 = (Size)jarg2; 
    {
        try {
            result = ((Schedule const *)arg1)->date(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(Date **)(void *)&jresult = new Date((Date &)result); 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Schedule_1isRegular(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    Schedule *arg1 = (Schedule *) 0 ;
    Size arg2 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Schedule **)(void *)&jarg1; 
    arg2 = (Size)jarg2; 
    {
        try {
            result = (bool)((Schedule const *)arg1)->isRegular(arg2);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Schedule(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Schedule *arg1 = (Schedule *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Schedule **)(void *)&jarg1; 
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return ;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return ;
            }
            /*@@*/;
        }
    }
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_CashFlow_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<CashFlow > *arg1 = (boost::shared_ptr<CashFlow > *) 0 ;
    CashFlow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<CashFlow > **)(void *)&jarg1; 
    {
        try {
            result = (CashFlow *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    *(CashFlow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_CashFlow_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    boost::shared_ptr<CashFlow > *arg1 = (boost::shared_ptr<CashFlow > *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(boost::shared_ptr<CashFlow > **)(void *)&jarg1; 
    {
        try {
            result = (bool)boost_shared_ptr_Sl_CashFlow_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (std::exception& e) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what()));
                return 0;
            }
            /*@@*/;
        } catch (...) {
            /*@/usr/local/share/swig/1.3.27/exception.i,193,SWIG_exception@*/
            {
                SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error");
                return 0;
            }
            /*@@*/;
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_CashFlow_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    boost::shared_ptr<CashFlow > *