/* -*- buffer-read-only: t -*- vi: set ro: */
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.27
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif


/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "2"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;


/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (int)(*f1 - *f2);
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}

/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}


/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/* -*- c -*-
 * -----------------------------------------------------------------------
 * swig_lib/mzscheme/mzrun.swg
 * 
 * Author: John Lenz <lenz@cs.wisc.edu>
 * ----------------------------------------------------------------------- */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <escheme.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Common SWIG API */
  
#define SWIG_ConvertPtr(s, result, type, flags) \
  SWIG_MzScheme_ConvertPtr(s, result, type, flags)
#define SWIG_NewPointerObj(ptr, type, owner) \
  SWIG_MzScheme_NewPointerObj((void *)ptr, type, owner)
#define SWIG_MustGetPtr(s, type, argnum, flags) \
  SWIG_MzScheme_MustGetPtr(s, type, argnum, flags, FUNC_NAME, argc, argv)

#define SWIG_contract_assert(expr,msg) \
 if (!(expr)) { \
    char *m=(char *) scheme_malloc(strlen(msg)+1000); \
    sprintf(m,"SWIG contract, assertion failed: function=%s, message=%s", \
            (char *) FUNC_NAME,(char *) msg); \
    scheme_signal_error(m); \
 }

/* Runtime API */
#define SWIG_GetModule(clientdata) SWIG_MzScheme_GetModule((Scheme_Env *)(clientdata))
#define SWIG_SetModule(clientdata, pointer) SWIG_MzScheme_SetModule((Scheme_Env *) (clientdata), pointer)
#define SWIG_MODULE_CLIENTDATA_TYPE Scheme_Env *

/* MzScheme-specific SWIG API */
  
#define SWIG_malloc(size) SWIG_MzScheme_Malloc(size, FUNC_NAME)
#define SWIG_free(mem) free(mem)
#define SWIG_NewStructFromPtr(ptr,type) \
        _swig_convert_struct_##type##(ptr)

#define MAXVALUES 6
#define swig_make_boolean(b) (b ? scheme_true : scheme_false)

/* ----------------------------------------------------------------------- 
 * mzscheme 30X support code
 * Contributed by Hans Oesterholt
 * ----------------------------------------------------------------------- */

#ifndef SCHEME_STR_VAL
#define MZSCHEME30X 1
#endif

#ifdef MZSCHEME30X 
/* 
 * This is MZSCHEME 299.100 or higher (30x).  From version 299.100 of
 * mzscheme upwards, strings are in unicode. These functions convert
 * to and from utf8 encodings of these strings.  NB! strlen(s) will be
 * the size in bytes of the string, not the actual length.
 */
#define SCHEME_STR_VAL(obj)  	       SCHEME_BYTE_STR_VAL(scheme_char_string_to_byte_string(obj))
#define SCHEME_STRLEN_VAL(obj)         SCHEME_BYTE_STRLEN_VAL(scheme_char_string_to_byte_string(obj))
#define SCHEME_STRINGP(obj)            SCHEME_CHAR_STRINGP(obj)
#define scheme_make_string(s)          scheme_make_utf8_string(s)
#define scheme_make_sized_string(s,l)  scheme_make_sized_utf8_string(s,l)
#define scheme_make_sized_offset_string(s,d,l) \
                   scheme_make_sized_offset_utf8_string(s,d,l)
#define SCHEME_MAKE_STRING(s) scheme_make_utf8_string(s)
#else
#define SCHEME_MAKE_STRING(s) scheme_make_string_without_copying(s)
#endif
/* ----------------------------------------------------------------------- 
 * End of mzscheme 30X support code 
 * ----------------------------------------------------------------------- */
  
struct swig_mz_proxy {
  Scheme_Type mztype;
  swig_type_info *type;
  void *object;
};

static Scheme_Type swig_type;

static void 
mz_free_swig(void *p, void *data) {
  struct swig_mz_proxy *proxy = (struct swig_mz_proxy *) p;
  if (SCHEME_NULLP((Scheme_Object*)p) || SCHEME_TYPE((Scheme_Object*)p) != swig_type)
    return;
  if (proxy->type) {
    if (proxy->type->clientdata) {
      ((Scheme_Prim *)proxy->type->clientdata)(1, (Scheme_Object **)&proxy);
    }
  }
}

static Scheme_Object *
SWIG_MzScheme_NewPointerObj(void *ptr, swig_type_info *type, int owner) {
  struct swig_mz_proxy *new_proxy;
  new_proxy = (struct swig_mz_proxy *) scheme_malloc(sizeof(struct swig_mz_proxy));
  new_proxy->mztype = swig_type;
  new_proxy->type = type;
  new_proxy->object = ptr;
  if (owner) {
    scheme_add_finalizer(new_proxy, mz_free_swig, NULL);
  }
  return (Scheme_Object *) new_proxy;
}

static int
SWIG_MzScheme_ConvertPtr(Scheme_Object *s, void **result, swig_type_info *type, int flags) {
  swig_cast_info *cast;

  if (SCHEME_NULLP(s)) {
    *result = NULL;
    return 0;
  } else if (SCHEME_TYPE(s) == swig_type) {
    struct swig_mz_proxy *proxy = (struct swig_mz_proxy *) s;
    if (type) {
      cast = SWIG_TypeCheckStruct(proxy->type, type);
      if (cast) {
        *result = SWIG_TypeCast(cast, proxy->object);
        return 0;
      } else {
        return 1;
      }
    } else {
      *result = proxy->object;
      return 0;
    }
  }
  return 1;
}

static SWIGINLINE void *
SWIG_MzScheme_MustGetPtr(Scheme_Object *s, swig_type_info *type, 
                         int argnum, int flags, const char *func_name,
                         int argc, Scheme_Object **argv) {
  void *result;
  if (SWIG_MzScheme_ConvertPtr(s, &result, type, flags)) {
    scheme_wrong_type(func_name, type->str ? type->str : "void *", argnum - 1, argc, argv);
  }
  return result;
}

static SWIGINLINE void *
SWIG_MzScheme_Malloc(size_t size, const char *func_name) {
  void *p = malloc(size);
  if (p == NULL) {
    scheme_signal_error("swig-memory-error");
  } else return p;
}

static Scheme_Object *
SWIG_MzScheme_PackageValues(int num, Scheme_Object **values) {
    /* ignore first value if void */
    if (num > 0 && SCHEME_VOIDP(values[0]))
	num--, values++;
    if (num == 0) return scheme_void;
    else if (num == 1) return values[0];
    else return scheme_values(num, values);
}

#ifndef scheme_make_inspector
#define scheme_make_inspector(x,y) \
        _scheme_apply(scheme_builtin_value("make-inspector"), x, y)
#endif

/* Function to create a new struct. */
static Scheme_Object *
SWIG_MzScheme_new_scheme_struct (Scheme_Env* env, const char* basename, 
				 int num_fields, char** field_names)
{
    Scheme_Object *new_type;
    int count_out, i;
    Scheme_Object **struct_names;
    Scheme_Object **vals;
    Scheme_Object **a = (Scheme_Object**) \
        scheme_malloc(num_fields*sizeof(Scheme_Object*));
    
    for (i=0; i<num_fields; ++i) {
        a[i] = (Scheme_Object*) scheme_intern_symbol(field_names[i]);
    }

    new_type = scheme_make_struct_type(scheme_intern_symbol(basename),
                                       NULL /*super_type*/,
                                       scheme_make_inspector(0, NULL),
                                       num_fields,
                                       0 /* auto_fields */,
                                       NULL /* auto_val */,
                                       NULL /* properties */
#ifdef MZSCHEME30X
				       ,NULL /* Guard */
#endif
				       );
    struct_names = scheme_make_struct_names(scheme_intern_symbol(basename),
                                            scheme_build_list(num_fields,a),
                                            0 /*flags*/, &count_out);
    vals = scheme_make_struct_values(new_type, struct_names, count_out, 0);

    for (i = 0; i < count_out; i++)
        scheme_add_global_symbol(struct_names[i], vals[i],env);

    return new_type;
}

/* The interpreter will store a pointer to this structure in a global
   variable called swig-runtime-data-type-pointer.  The instance of this
   struct is only used if no other module has yet been loaded */
struct swig_mzscheme_runtime_data {
  swig_module_info *module_head;
  Scheme_Type type;
};
static struct swig_mzscheme_runtime_data swig_mzscheme_runtime_data;


static swig_module_info *
SWIG_MzScheme_GetModule(Scheme_Env *env) {
  Scheme_Object *pointer, *symbol;
  struct swig_mzscheme_runtime_data *data;

  /* first check if pointer already created */
  symbol = scheme_intern_symbol("swig-runtime-data-type-pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME);
  pointer = scheme_lookup_global(symbol, env);
  if (pointer && SCHEME_CPTRP(pointer)) {
      data = (struct swig_mzscheme_runtime_data *) SCHEME_CPTR_VAL(pointer);
      swig_type = data->type;
      return data->module_head;
  } else {
      return NULL;
  }
}

static void
SWIG_MzScheme_SetModule(Scheme_Env *env, swig_module_info *module) {
  Scheme_Object *pointer, *symbol;
  struct swig_mzscheme_runtime_data *data;

  /* first check if pointer already created */
  symbol = scheme_intern_symbol("swig-runtime-data-type-pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME);
  pointer = scheme_lookup_global(symbol, env);
  if (pointer && SCHEME_CPTRP(pointer)) {
    data = (struct swig_mzscheme_runtime_data *) SCHEME_CPTR_VAL(pointer);
    swig_type = data->type;
    data->module_head = module;
  } else {
    /* create a new type for wrapped pointer values */
    swig_type = scheme_make_type((char *)"swig");
    swig_mzscheme_runtime_data.module_head = module;
    swig_mzscheme_runtime_data.type = swig_type;
    
    /* create a new pointer */
#ifndef MZSCHEME30X
    pointer = scheme_make_cptr((void *) &swig_mzscheme_runtime_data, "swig_mzscheme_runtime_data");
#else
    pointer = scheme_make_cptr((void *) &swig_mzscheme_runtime_data,
			       scheme_make_byte_string("swig_mzscheme_runtime_data"));
#endif
    scheme_add_global_symbol(symbol, pointer, env);
  }
}

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_AUDLiborPtr swig_types[0]
#define SWIGTYPE_p_AmericanExercisePtr swig_types[1]
#define SWIGTYPE_p_AnalyticBarrierEnginePtr swig_types[2]
#define SWIGTYPE_p_AnalyticCapFloorEnginePtr swig_types[3]
#define SWIGTYPE_p_AnalyticDigitalAmericanEnginePtr swig_types[4]
#define SWIGTYPE_p_AnalyticDividendEuropeanEnginePtr swig_types[5]
#define SWIGTYPE_p_AnalyticEuropeanEnginePtr swig_types[6]
#define SWIGTYPE_p_Array swig_types[7]
#define SWIGTYPE_p_AssetOrNothingPayoffPtr swig_types[8]
#define SWIGTYPE_p_BaroneAdesiWhaleyApproximationEnginePtr swig_types[9]
#define SWIGTYPE_p_Barrier swig_types[10]
#define SWIGTYPE_p_BarrierOptionPtr swig_types[11]
#define SWIGTYPE_p_BermudanExercisePtr swig_types[12]
#define SWIGTYPE_p_BinomialVanillaEnginePtr swig_types[13]
#define SWIGTYPE_p_Bisection swig_types[14]
#define SWIGTYPE_p_BjerksundStenslandApproximationEnginePtr swig_types[15]
#define SWIGTYPE_p_BlackCapFloorEnginePtr swig_types[16]
#define SWIGTYPE_p_BlackConstantVolPtr swig_types[17]
#define SWIGTYPE_p_BlackKarasinskiPtr swig_types[18]
#define SWIGTYPE_p_BlackModel swig_types[19]
#define SWIGTYPE_p_BlackScholesProcessPtr swig_types[20]
#define SWIGTYPE_p_BlackSwaptionEnginePtr swig_types[21]
#define SWIGTYPE_p_BlackVarianceSurfacePtr swig_types[22]
#define SWIGTYPE_p_BlackVolTermStructure swig_types[23]
#define SWIGTYPE_p_BondPtr swig_types[24]
#define SWIGTYPE_p_BoundaryCondition swig_types[25]
#define SWIGTYPE_p_BoundaryConstraint swig_types[26]
#define SWIGTYPE_p_BoxMullerGaussianRngTKnuthUniformRng_t swig_types[27]
#define SWIGTYPE_p_BoxMullerGaussianRngTLecuyerUniformRng_t swig_types[28]
#define SWIGTYPE_p_BoxMullerGaussianRngTMersenneTwisterUniformRng_t swig_types[29]
#define SWIGTYPE_p_Brent swig_types[30]
#define SWIGTYPE_p_CADLiborPtr swig_types[31]
#define SWIGTYPE_p_CHFLiborPtr swig_types[32]
#define SWIGTYPE_p_CLGaussianRngTKnuthUniformRng_t swig_types[33]
#define SWIGTYPE_p_CLGaussianRngTLecuyerUniformRng_t swig_types[34]
#define SWIGTYPE_p_CLGaussianRngTMersenneTwisterUniformRng_t swig_types[35]
#define SWIGTYPE_p_Calendar swig_types[36]
#define SWIGTYPE_p_CalibrationHelper swig_types[37]
#define SWIGTYPE_p_CapHelperPtr swig_types[38]
#define SWIGTYPE_p_CapPtr swig_types[39]
#define SWIGTYPE_p_CapVolatilityStructure swig_types[40]
#define SWIGTYPE_p_CapVolatilityVectorPtr swig_types[41]
#define SWIGTYPE_p_CashFlow swig_types[42]
#define SWIGTYPE_p_CashOrNothingPayoffPtr swig_types[43]
#define SWIGTYPE_p_Cashflows swig_types[44]
#define SWIGTYPE_p_CdorPtr swig_types[45]
#define SWIGTYPE_p_CeilingTruncation swig_types[46]
#define SWIGTYPE_p_ClosestRounding swig_types[47]
#define SWIGTYPE_p_CollarPtr swig_types[48]
#define SWIGTYPE_p_CompositeQuotePtr swig_types[49]
#define SWIGTYPE_p_CompoundForwardPtr swig_types[50]
#define SWIGTYPE_p_ConjugateGradient swig_types[51]
#define SWIGTYPE_p_Constraint swig_types[52]
#define SWIGTYPE_p_CumulativeNormalDistribution swig_types[53]
#define SWIGTYPE_p_Currency swig_types[54]
#define SWIGTYPE_p_Date swig_types[55]
#define SWIGTYPE_p_DayCounter swig_types[56]
#define SWIGTYPE_p_DepositRateHelperPtr swig_types[57]
#define SWIGTYPE_p_DerivedQuotePtr swig_types[58]
#define SWIGTYPE_p_DirichletBCPtr swig_types[59]
#define SWIGTYPE_p_DiscountCurvePtr swig_types[60]
#define SWIGTYPE_p_DiscreteGeometricASO swig_types[61]
#define SWIGTYPE_p_DividendVanillaOptionPtr swig_types[62]
#define SWIGTYPE_p_DownRounding swig_types[63]
#define SWIGTYPE_p_Duration swig_types[64]
#define SWIGTYPE_p_EndCriteria swig_types[65]
#define SWIGTYPE_p_EuriborPtr swig_types[66]
#define SWIGTYPE_p_EuropeanExercisePtr swig_types[67]
#define SWIGTYPE_p_EuropeanOptionPtr swig_types[68]
#define SWIGTYPE_p_ExchangeRate swig_types[69]
#define SWIGTYPE_p_ExchangeRateManager swig_types[70]
#define SWIGTYPE_p_Exercise swig_types[71]
#define SWIGTYPE_p_ExtendedDiscountCurvePtr swig_types[72]
#define SWIGTYPE_p_Extrapolator swig_types[73]
#define SWIGTYPE_p_FDAmericanEnginePtr swig_types[74]
#define SWIGTYPE_p_FDDividendAmericanEnginePtr swig_types[75]
#define SWIGTYPE_p_FDDividendEuropeanEnginePtr swig_types[76]
#define SWIGTYPE_p_FDEuropeanEnginePtr swig_types[77]
#define SWIGTYPE_p_FDShoutEnginePtr swig_types[78]
#define SWIGTYPE_p_FalsePosition swig_types[79]
#define SWIGTYPE_p_FixedCouponBondPtr swig_types[80]
#define SWIGTYPE_p_FixedRateCouponPtr swig_types[81]
#define SWIGTYPE_p_FlatForwardPtr swig_types[82]
#define SWIGTYPE_p_FloatingRateBondPtr swig_types[83]
#define SWIGTYPE_p_FloorPtr swig_types[84]
#define SWIGTYPE_p_FloorTruncation swig_types[85]
#define SWIGTYPE_p_ForwardSpreadedTermStructurePtr swig_types[86]
#define SWIGTYPE_p_FraRateHelperPtr swig_types[87]
#define SWIGTYPE_p_FuturesRateHelperPtr swig_types[88]
#define SWIGTYPE_p_G2Ptr swig_types[89]
#define SWIGTYPE_p_G2SwaptionEnginePtr swig_types[90]
#define SWIGTYPE_p_GBPLiborPtr swig_types[91]
#define SWIGTYPE_p_GaussianLowDiscrepancySequenceGenerator swig_types[92]
#define SWIGTYPE_p_GaussianMultiPathGenerator swig_types[93]
#define SWIGTYPE_p_GaussianPathGenerator swig_types[94]
#define SWIGTYPE_p_GaussianRandomGenerator swig_types[95]
#define SWIGTYPE_p_GaussianRandomSequenceGenerator swig_types[96]
#define SWIGTYPE_p_GenericStochasticProcess swig_types[97]
#define SWIGTYPE_p_HaltonRsg swig_types[98]
#define SWIGTYPE_p_HandleTBlackVolTermStructure_t swig_types[99]
#define SWIGTYPE_p_HandleTCapVolatilityStructure_t swig_types[100]
#define SWIGTYPE_p_HandleTLocalVolTermStructure_t swig_types[101]
#define SWIGTYPE_p_HandleTQuote_t swig_types[102]
#define SWIGTYPE_p_HandleTSwaptionVolatilityStructure_t swig_types[103]
#define SWIGTYPE_p_HandleTYieldTermStructure_t swig_types[104]
#define SWIGTYPE_p_History swig_types[105]
#define SWIGTYPE_p_HistoryEntry swig_types[106]
#define SWIGTYPE_p_HullWhitePtr swig_types[107]
#define SWIGTYPE_p_ImpliedTermStructurePtr swig_types[108]
#define SWIGTYPE_p_Index swig_types[109]
#define SWIGTYPE_p_IndexManager swig_types[110]
#define SWIGTYPE_p_Instrument swig_types[111]
#define SWIGTYPE_p_IntegralEnginePtr swig_types[112]
#define SWIGTYPE_p_InterestRate swig_types[113]
#define SWIGTYPE_p_InverseCumulativeNormal swig_types[114]
#define SWIGTYPE_p_InverseCumulativeRngTKnuthUniformRng_InverseCumulativeNormal_t swig_types[115]
#define SWIGTYPE_p_InverseCumulativeRngTKnuthUniformRng_MoroInverseCumulativeNormal_t swig_types[116]
#define SWIGTYPE_p_InverseCumulativeRngTLecuyerUniformRng_InverseCumulativeNormal_t swig_types[117]
#define SWIGTYPE_p_InverseCumulativeRngTLecuyerUniformRng_MoroInverseCumulativeNormal_t swig_types[118]
#define SWIGTYPE_p_InverseCumulativeRngTMersenneTwisterUniformRng_InverseCumulativeNormal_t swig_types[119]
#define SWIGTYPE_p_InverseCumulativeRngTMersenneTwisterUniformRng_MoroInverseCumulativeNormal_t swig_types[120]
#define SWIGTYPE_p_InverseCumulativeRsgTHaltonRsg_InverseCumulativeNormal_t swig_types[121]
#define SWIGTYPE_p_InverseCumulativeRsgTHaltonRsg_MoroInverseCumulativeNormal_t swig_types[122]
#define SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_InverseCumulativeNormal_t swig_types[123]
#define SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_MoroInverseCumulativeNormal_t swig_types[124]
#define SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_InverseCumulativeNormal_t swig_types[125]
#define SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_MoroInverseCumulativeNormal_t swig_types[126]
#define SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_InverseCumulativeNormal_t swig_types[127]
#define SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_MoroInverseCumulativeNormal_t swig_types[128]
#define SWIGTYPE_p_JPYLiborPtr swig_types[129]
#define SWIGTYPE_p_JamshidianSwaptionEnginePtr swig_types[130]
#define SWIGTYPE_p_JibarPtr swig_types[131]
#define SWIGTYPE_p_KnuthUniformRng swig_types[132]
#define SWIGTYPE_p_KronrodIntegral swig_types[133]
#define SWIGTYPE_p_LecuyerUniformRng swig_types[134]
#define SWIGTYPE_p_LexicographicalView swig_types[135]
#define SWIGTYPE_p_LocalConstantVolPtr swig_types[136]
#define SWIGTYPE_p_LocalVolTermStructure swig_types[137]
#define SWIGTYPE_p_MCEuropeanEnginePtr swig_types[138]
#define SWIGTYPE_p_Matrix swig_types[139]
#define SWIGTYPE_p_McDiscreteArithmeticASO swig_types[140]
#define SWIGTYPE_p_McEverest swig_types[141]
#define SWIGTYPE_p_McHimalaya swig_types[142]
#define SWIGTYPE_p_McMaxBasket swig_types[143]
#define SWIGTYPE_p_McPagoda swig_types[144]
#define SWIGTYPE_p_MersenneTwisterUniformRng swig_types[145]
#define SWIGTYPE_p_Merton76ProcessPtr swig_types[146]
#define SWIGTYPE_p_Money swig_types[147]
#define SWIGTYPE_p_MoroInverseCumulativeNormal swig_types[148]
#define SWIGTYPE_p_MultiPath swig_types[149]
#define SWIGTYPE_p_MzObserver swig_types[150]
#define SWIGTYPE_p_NeumannBCPtr swig_types[151]
#define SWIGTYPE_p_NoConstraint swig_types[152]
#define SWIGTYPE_p_NormalDistribution swig_types[153]
#define SWIGTYPE_p_Observable swig_types[154]
#define SWIGTYPE_p_OptimizationMethod swig_types[155]
#define SWIGTYPE_p_Optimizer swig_types[156]
#define SWIGTYPE_p_Option swig_types[157]
#define SWIGTYPE_p_ParCouponPtr swig_types[158]
#define SWIGTYPE_p_Path swig_types[159]
#define SWIGTYPE_p_Payoff swig_types[160]
#define SWIGTYPE_p_PercentageStrikePayoffPtr swig_types[161]
#define SWIGTYPE_p_Period swig_types[162]
#define SWIGTYPE_p_PiecewiseFlatForwardPtr swig_types[163]
#define SWIGTYPE_p_PlainVanillaPayoffPtr swig_types[164]
#define SWIGTYPE_p_PositiveConstraint swig_types[165]
#define SWIGTYPE_p_PricingEngine swig_types[166]
#define SWIGTYPE_p_QuantLib__ARSCurrency swig_types[167]
#define SWIGTYPE_p_QuantLib__ATSCurrency swig_types[168]
#define SWIGTYPE_p_QuantLib__AUDCurrency swig_types[169]
#define SWIGTYPE_p_QuantLib__Actual360 swig_types[170]
#define SWIGTYPE_p_QuantLib__Actual365Fixed swig_types[171]
#define SWIGTYPE_p_QuantLib__ActualActual swig_types[172]
#define SWIGTYPE_p_QuantLib__BDTCurrency swig_types[173]
#define SWIGTYPE_p_QuantLib__BEFCurrency swig_types[174]
#define SWIGTYPE_p_QuantLib__BGLCurrency swig_types[175]
#define SWIGTYPE_p_QuantLib__BRLCurrency swig_types[176]
#define SWIGTYPE_p_QuantLib__BYRCurrency swig_types[177]
#define SWIGTYPE_p_QuantLib__Beijing swig_types[178]
#define SWIGTYPE_p_QuantLib__Bombay swig_types[179]
#define SWIGTYPE_p_QuantLib__Bratislava swig_types[180]
#define SWIGTYPE_p_QuantLib__Budapest swig_types[181]
#define SWIGTYPE_p_QuantLib__CADCurrency swig_types[182]
#define SWIGTYPE_p_QuantLib__CHFCurrency swig_types[183]
#define SWIGTYPE_p_QuantLib__CLPCurrency swig_types[184]
#define SWIGTYPE_p_QuantLib__CNYCurrency swig_types[185]
#define SWIGTYPE_p_QuantLib__COPCurrency swig_types[186]
#define SWIGTYPE_p_QuantLib__CYPCurrency swig_types[187]
#define SWIGTYPE_p_QuantLib__CZKCurrency swig_types[188]
#define SWIGTYPE_p_QuantLib__Copenhagen swig_types[189]
#define SWIGTYPE_p_QuantLib__DEMCurrency swig_types[190]
#define SWIGTYPE_p_QuantLib__DKKCurrency swig_types[191]
#define SWIGTYPE_p_QuantLib__EEKCurrency swig_types[192]
#define SWIGTYPE_p_QuantLib__ESPCurrency swig_types[193]
#define SWIGTYPE_p_QuantLib__EURCurrency swig_types[194]
#define SWIGTYPE_p_QuantLib__FIMCurrency swig_types[195]
#define SWIGTYPE_p_QuantLib__FRFCurrency swig_types[196]
#define SWIGTYPE_p_QuantLib__GBPCurrency swig_types[197]
#define SWIGTYPE_p_QuantLib__GRDCurrency swig_types[198]
#define SWIGTYPE_p_QuantLib__Germany swig_types[199]
#define SWIGTYPE_p_QuantLib__HKDCurrency swig_types[200]
#define SWIGTYPE_p_QuantLib__HUFCurrency swig_types[201]
#define SWIGTYPE_p_QuantLib__Helsinki swig_types[202]
#define SWIGTYPE_p_QuantLib__HongKong swig_types[203]
#define SWIGTYPE_p_QuantLib__IEPCurrency swig_types[204]
#define SWIGTYPE_p_QuantLib__ILSCurrency swig_types[205]
#define SWIGTYPE_p_QuantLib__INRCurrency swig_types[206]
#define SWIGTYPE_p_QuantLib__IQDCurrency swig_types[207]
#define SWIGTYPE_p_QuantLib__IRRCurrency swig_types[208]
#define SWIGTYPE_p_QuantLib__ISKCurrency swig_types[209]
#define SWIGTYPE_p_QuantLib__ITLCurrency swig_types[210]
#define SWIGTYPE_p_QuantLib__Istanbul swig_types[211]
#define SWIGTYPE_p_QuantLib__Italy swig_types[212]
#define SWIGTYPE_p_QuantLib__JPYCurrency swig_types[213]
#define SWIGTYPE_p_QuantLib__Johannesburg swig_types[214]
#define SWIGTYPE_p_QuantLib__JointCalendar swig_types[215]
#define SWIGTYPE_p_QuantLib__KRWCurrency swig_types[216]
#define SWIGTYPE_p_QuantLib__KWDCurrency swig_types[217]
#define SWIGTYPE_p_QuantLib__LTLCurrency swig_types[218]
#define SWIGTYPE_p_QuantLib__LUFCurrency swig_types[219]
#define SWIGTYPE_p_QuantLib__LVLCurrency swig_types[220]
#define SWIGTYPE_p_QuantLib__MTLCurrency swig_types[221]
#define SWIGTYPE_p_QuantLib__MXNCurrency swig_types[222]
#define SWIGTYPE_p_QuantLib__NLGCurrency swig_types[223]
#define SWIGTYPE_p_QuantLib__NOKCurrency swig_types[224]
#define SWIGTYPE_p_QuantLib__NPRCurrency swig_types[225]
#define SWIGTYPE_p_QuantLib__NZDCurrency swig_types[226]
#define SWIGTYPE_p_QuantLib__NullCalendar swig_types[227]
#define SWIGTYPE_p_QuantLib__OneDayCounter swig_types[228]
#define SWIGTYPE_p_QuantLib__Oslo swig_types[229]
#define SWIGTYPE_p_QuantLib__PKRCurrency swig_types[230]
#define SWIGTYPE_p_QuantLib__PLNCurrency swig_types[231]
#define SWIGTYPE_p_QuantLib__PTECurrency swig_types[232]
#define SWIGTYPE_p_QuantLib__Prague swig_types[233]
#define SWIGTYPE_p_QuantLib__ROLCurrency swig_types[234]
#define SWIGTYPE_p_QuantLib__Riyadh swig_types[235]
#define SWIGTYPE_p_QuantLib__SARCurrency swig_types[236]
#define SWIGTYPE_p_QuantLib__SEKCurrency swig_types[237]
#define SWIGTYPE_p_QuantLib__SGDCurrency swig_types[238]
#define SWIGTYPE_p_QuantLib__SITCurrency swig_types[239]
#define SWIGTYPE_p_QuantLib__SKKCurrency swig_types[240]
#define SWIGTYPE_p_QuantLib__Seoul swig_types[241]
#define SWIGTYPE_p_QuantLib__SimpleDayCounter swig_types[242]
#define SWIGTYPE_p_QuantLib__Singapore swig_types[243]
#define SWIGTYPE_p_QuantLib__Stockholm swig_types[244]
#define SWIGTYPE_p_QuantLib__Sydney swig_types[245]
#define SWIGTYPE_p_QuantLib__TARGET swig_types[246]
#define SWIGTYPE_p_QuantLib__THBCurrency swig_types[247]
#define SWIGTYPE_p_QuantLib__TRLCurrency swig_types[248]
#define SWIGTYPE_p_QuantLib__TRYCurrency swig_types[249]
#define SWIGTYPE_p_QuantLib__TTDCurrency swig_types[250]
#define SWIGTYPE_p_QuantLib__TWDCurrency swig_types[251]
#define SWIGTYPE_p_QuantLib__Taipei swig_types[252]
#define SWIGTYPE_p_QuantLib__Taiwan swig_types[253]
#define SWIGTYPE_p_QuantLib__Thirty360 swig_types[254]
#define SWIGTYPE_p_QuantLib__Tokyo swig_types[255]
#define SWIGTYPE_p_QuantLib__Toronto swig_types[256]
#define SWIGTYPE_p_QuantLib__USDCurrency swig_types[257]
#define SWIGTYPE_p_QuantLib__UnitedKingdom swig_types[258]
#define SWIGTYPE_p_QuantLib__UnitedStates swig_types[259]
#define SWIGTYPE_p_QuantLib__VEBCurrency swig_types[260]
#define SWIGTYPE_p_QuantLib__Warsaw swig_types[261]
#define SWIGTYPE_p_QuantLib__Wellington swig_types[262]
#define SWIGTYPE_p_QuantLib__ZARCurrency swig_types[263]
#define SWIGTYPE_p_QuantLib__Zurich swig_types[264]
#define SWIGTYPE_p_Quote swig_types[265]
#define SWIGTYPE_p_RandomSequenceGeneratorTKnuthUniformRng_t swig_types[266]
#define SWIGTYPE_p_RandomSequenceGeneratorTLecuyerUniformRng_t swig_types[267]
#define SWIGTYPE_p_RandomSequenceGeneratorTMersenneTwisterUniformRng_t swig_types[268]
#define SWIGTYPE_p_RateHelper swig_types[269]
#define SWIGTYPE_p_Ridder swig_types[270]
#define SWIGTYPE_p_RiskStatistics swig_types[271]
#define SWIGTYPE_p_Rounding swig_types[272]
#define SWIGTYPE_p_SVD swig_types[273]
#define SWIGTYPE_p_SafeBackwardFlatInterpolation swig_types[274]
#define SWIGTYPE_p_SafeBicubicSpline swig_types[275]
#define SWIGTYPE_p_SafeBilinearInterpolation swig_types[276]
#define SWIGTYPE_p_SafeForwardFlatInterpolation swig_types[277]
#define SWIGTYPE_p_SafeLinearInterpolation swig_types[278]
#define SWIGTYPE_p_SafeLogLinearInterpolation swig_types[279]
#define SWIGTYPE_p_SafeNaturalCubicSpline swig_types[280]
#define SWIGTYPE_p_SafeNaturalMonotonicCubicSpline swig_types[281]
#define SWIGTYPE_p_SalvagingAlgorithm swig_types[282]
#define SWIGTYPE_p_SampleTArray_t swig_types[283]
#define SWIGTYPE_p_SampleTMultiPath_t swig_types[284]
#define SWIGTYPE_p_SampleTPath_t swig_types[285]
#define SWIGTYPE_p_SampleTdouble_t swig_types[286]
#define SWIGTYPE_p_Schedule swig_types[287]
#define SWIGTYPE_p_Secant swig_types[288]
#define SWIGTYPE_p_SegmentIntegral swig_types[289]
#define SWIGTYPE_p_SequenceStatisticsTStatistics_t swig_types[290]
#define SWIGTYPE_p_Settings swig_types[291]
#define SWIGTYPE_p_ShortRateModel swig_types[292]
#define SWIGTYPE_p_SimpleCashFlowPtr swig_types[293]
#define SWIGTYPE_p_SimpleQuotePtr swig_types[294]
#define SWIGTYPE_p_SimpleSwapPtr swig_types[295]
#define SWIGTYPE_p_Simplex swig_types[296]
#define SWIGTYPE_p_SimpsonIntegral swig_types[297]
#define SWIGTYPE_p_SobolRsg swig_types[298]
#define SWIGTYPE_p_Statistics swig_types[299]
#define SWIGTYPE_p_SteepestDescent swig_types[300]
#define SWIGTYPE_p_StochasticProcess1DPtr swig_types[301]
#define SWIGTYPE_p_StockPtr swig_types[302]
#define SWIGTYPE_p_SuperSharePayoffPtr swig_types[303]
#define SWIGTYPE_p_SwapPtr swig_types[304]
#define SWIGTYPE_p_SwapRateHelperPtr swig_types[305]
#define SWIGTYPE_p_SwaptionHelperPtr swig_types[306]
#define SWIGTYPE_p_SwaptionPtr swig_types[307]
#define SWIGTYPE_p_SwaptionVolatilityMatrixPtr swig_types[308]
#define SWIGTYPE_p_SwaptionVolatilityStructure swig_types[309]
#define SWIGTYPE_p_TRLiborPtr swig_types[310]
#define SWIGTYPE_p_TiborPtr swig_types[311]
#define SWIGTYPE_p_TimeBasket swig_types[312]
#define SWIGTYPE_p_TimeGrid swig_types[313]
#define SWIGTYPE_p_TrapezoidIntegral swig_types[314]
#define SWIGTYPE_p_TreeCapFloorEnginePtr swig_types[315]
#define SWIGTYPE_p_TreeSwaptionEnginePtr swig_types[316]
#define SWIGTYPE_p_TridiagonalOperator swig_types[317]
#define SWIGTYPE_p_USDLiborPtr swig_types[318]
#define SWIGTYPE_p_UniformLowDiscrepancySequenceGenerator swig_types[319]
#define SWIGTYPE_p_UniformRandomGenerator swig_types[320]
#define SWIGTYPE_p_UniformRandomSequenceGenerator swig_types[321]
#define SWIGTYPE_p_UpRounding swig_types[322]
#define SWIGTYPE_p_VanillaOptionPtr swig_types[323]
#define SWIGTYPE_p_XiborPtr swig_types[324]
#define SWIGTYPE_p_YieldTermStructure swig_types[325]
#define SWIGTYPE_p_ZeroCouponBondPtr swig_types[326]
#define SWIGTYPE_p_ZeroSpreadedTermStructurePtr swig_types[327]
#define SWIGTYPE_p_ZiborPtr swig_types[328]
#define SWIGTYPE_p_boost__shared_ptrTBlackModel_t swig_types[329]
#define SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t swig_types[330]
#define SWIGTYPE_p_boost__shared_ptrTBoundaryCondition_t swig_types[331]
#define SWIGTYPE_p_boost__shared_ptrTCalibrationHelper_t swig_types[332]
#define SWIGTYPE_p_boost__shared_ptrTCapVolatilityStructure_t swig_types[333]
#define SWIGTYPE_p_boost__shared_ptrTCashFlow_t swig_types[334]
#define SWIGTYPE_p_boost__shared_ptrTExercise_t swig_types[335]
#define SWIGTYPE_p_boost__shared_ptrTGenericStochasticProcess_t swig_types[336]
#define SWIGTYPE_p_boost__shared_ptrTIndex_t swig_types[337]
#define SWIGTYPE_p_boost__shared_ptrTInstrument_t swig_types[338]
#define SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t swig_types[339]
#define SWIGTYPE_p_boost__shared_ptrTObservable_t swig_types[340]
#define SWIGTYPE_p_boost__shared_ptrTPayoff_t swig_types[341]
#define SWIGTYPE_p_boost__shared_ptrTPricingEngine_t swig_types[342]
#define SWIGTYPE_p_boost__shared_ptrTQuote_t swig_types[343]
#define SWIGTYPE_p_boost__shared_ptrTRateHelper_t swig_types[344]
#define SWIGTYPE_p_boost__shared_ptrTShortRateModel_t swig_types[345]
#define SWIGTYPE_p_boost__shared_ptrTSwaptionVolatilityStructure_t swig_types[346]
#define SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t swig_types[347]
#define SWIGTYPE_p_double swig_types[348]
#define SWIGTYPE_p_int swig_types[349]
#define SWIGTYPE_p_long swig_types[350]
#define SWIGTYPE_p_std__size_t swig_types[351]
#define SWIGTYPE_p_std__vectorTDate_t swig_types[352]
#define SWIGTYPE_p_std__vectorTHandleTBlackVolTermStructure_t_t swig_types[353]
#define SWIGTYPE_p_std__vectorTHandleTQuote_t_t swig_types[354]
#define SWIGTYPE_p_std__vectorTHandleTYieldTermStructure_t_t swig_types[355]
#define SWIGTYPE_p_std__vectorTPeriod_t swig_types[356]
#define SWIGTYPE_p_std__vectorTStochasticProcess1DPtr_t swig_types[357]
#define SWIGTYPE_p_std__vectorTboost__shared_ptrTCalibrationHelper_t_t swig_types[358]
#define SWIGTYPE_p_std__vectorTboost__shared_ptrTCashFlow_t_t swig_types[359]
#define SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t swig_types[360]
#define SWIGTYPE_p_std__vectorTboost__shared_ptrTRateHelper_t_t swig_types[361]
#define SWIGTYPE_p_std__vectorTdouble_t swig_types[362]
#define SWIGTYPE_p_std__vectorTint_t swig_types[363]
#define SWIGTYPE_p_std__vectorTstd__string_t swig_types[364]
#define SWIGTYPE_p_unsigned_int swig_types[365]
#define SWIGTYPE_p_unsigned_long swig_types[366]
static swig_type_info *swig_types[368];
static swig_module_info swig_module = {swig_types, 367, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */


#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


SWIGINTERN void SWIG_exception_ (int code, const char *msg) {
#define ERROR(errname)				\
	scheme_signal_error(errname " (%s)", msg);
#define MAP(swigerr, errname)			\
	case swigerr:				\
	  ERROR(errname);			\
	  break
    switch (code) {
      MAP(SWIG_MemoryError,	"swig-memory-error");
      MAP(SWIG_IOError,		"swig-io-error");
      MAP(SWIG_RuntimeError,	"swig-runtime-error");
      MAP(SWIG_IndexError,	"swig-index-error");
      MAP(SWIG_TypeError,	"swig-type-error");
      MAP(SWIG_DivisionByZero,	"swig-division-by-zero");
      MAP(SWIG_OverflowError,	"swig-overflow-error");
      MAP(SWIG_SyntaxError,	"swig-syntax-error");
      MAP(SWIG_ValueError,	"swig-value-error");
      MAP(SWIG_SystemError,	"swig-system-error");
    default:
      ERROR("swig-error");
    }
#undef ERROR
#undef MAP
  }

#define SWIG_exception(a,b) SWIG_exception_(a, b)


#include <stdexcept>


#include <ql/quantlib.hpp>

#if QL_HEX_VERSION < 0x000311f0
    #error using an old version of QuantLib, please update
#endif

// add here SWIG version check

#if defined(_MSC_VER)         // Microsoft Visual C++ 6.0
// disable Swig-dependent warnings

// 'identifier1' has C-linkage specified,
// but returns UDT 'identifier2' which is incompatible with C
#pragma warning(disable: 4190)

// 'int' : forcing value to bool 'true' or 'false' (performance warning)
#pragma warning(disable: 4800)

// debug info too long etc etc
#pragma warning(disable: 4786)
#endif


#include <string>

std::string swig_scm_to_string(Scheme_Object* x) {
    return std::string(SCHEME_STR_VAL(x));
}
Scheme_Object* swig_make_string(const std::string& s) {
    return scheme_make_string(s.c_str());
}


#include <string>


#include <vector>
#include <algorithm>
#include <stdexcept>


#include <map>
#include <algorithm>
#include <stdexcept>


#include <utility>


// generally useful classes
using QuantLib::Error;
using QuantLib::Handle;


using QuantLib::Observer;
using QuantLib::Observable;

static bool boost_shared_ptr_Sl_Observable_Sg__isNull(boost::shared_ptr<Observable > *self){
                return !(*self);
            }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTObservable_t;
static const char *_swig_struct__boost__shared_ptrTObservable_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTObservable_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTObservable_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTObservable_t(boost::shared_ptr<Observable > *ptr);

// C++ wrapper for MzScheme observer
class MzObserver : public Observer {
  public:
	MzObserver(Scheme_Object* callback)
	: callback_(callback) {
        QL_REQUIRE(SCHEME_PROCP(callback), "procedure expected");
	    /* make sure the MzScheme object stays alive
	       as long as we need it */
	    scheme_dont_gc_ptr(callback_);
    }
    MzObserver(const MzObserver& o)
    : callback_(o.callback_) {
	    /* make sure the MzScheme object stays alive
	       as long as we need it */
	    scheme_dont_gc_ptr(callback_);
    }
    MzObserver& operator=(const MzObserver& o) {
        if ((this != &o) && (callback_ != o.callback_)) {
            scheme_gc_ptr_ok(callback_);
            callback_ = o.callback_;
            scheme_dont_gc_ptr(callback_);
        }
        return *this;
    }
    ~MzObserver() {
        // now it can go as far as we are concerned
        scheme_gc_ptr_ok(callback_);
    }
    void update() {
        scheme_apply(callback_,0,0);
    }
  private:
	Scheme_Object* callback_;
};

static Scheme_Object *_swig_struct_type__MzObserver;
static const char *_swig_struct__MzObserver_field_names[] = { 
};
#define  _swig_struct__MzObserver_field_names_cnt (sizeof(_swig_struct__MzObserver_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__MzObserver(MzObserver *ptr);

using QuantLib::Integer;
using QuantLib::BigInteger;
using QuantLib::Natural;
using QuantLib::BigNatural;
using QuantLib::Real;
using QuantLib::Decimal;
using QuantLib::Time;
using QuantLib::Rate;
using QuantLib::Spread;
using QuantLib::DiscountFactor;
using QuantLib::Volatility;
using QuantLib::Size;


using QuantLib::Array;
using QuantLib::Matrix;

static std::string Array___str__(Array *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
static Real Array_ref(Array *self,Size i){
            if (i<self->size())
                return (*self)[i];
            else
                throw std::out_of_range("array index out of range");
            QL_DUMMY_RETURN(0.0)
        }
static void Array_set(Array *self,Size i,Real x){
            if (i<self->size())
                (*self)[i] = x;
            else
                throw std::out_of_range("array index out of range");
        }
static Scheme_Object *_swig_struct_type__Array;
static const char *_swig_struct__Array_field_names[] = { 
};
#define  _swig_struct__Array_field_names_cnt (sizeof(_swig_struct__Array_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Array(Array *ptr);

    Array Array_add(const Array& a, const Array& b) {
        return a+b;
    }
    Array Array_sub(const Array& a, const Array& b) {
        return a-b;
    }
    Array Array_div(const Array& a, Real x) {
        return a/x;
    }
    Array Array_mul(const Array& a, Real x) {
        return a*x;
    }
    Real Array_mul(const Array& a, const Array& b) {
        return QuantLib::DotProduct(a,b);;
    }
    Array Array_mul(const Array& a, const Matrix& m) {
        return a*m;
    }


typedef QuantLib::LexicographicalView<Array::iterator>
    LexicographicalView;
typedef QuantLib::LexicographicalView<Array::iterator>::y_iterator
    LexicographicalViewColumn;

static LexicographicalView *new_LexicographicalView(Array &a,Size xSize){
            return new LexicographicalView(a.begin(),a.end(),xSize);
        }
static std::string LexicographicalView___str__(LexicographicalView *self){
            std::ostringstream s;
            for (Size j=0; j<self->ySize(); j++) {
                s << "\n";
                for (Size i=0; i<self->xSize(); i++) {
                    if (i != 0)
                        s << ",";
                    s << (*self)[i][j];
                }
            }
            s << "\n";
            return s.str();
        }
static Real LexicographicalView_ref(LexicographicalView *self,Size i,Size j){
            return (*self)[i][j];
        }
static void LexicographicalView_set(LexicographicalView *self,Size i,Size j,Real x){
            (*self)[i][j] = x;
        }
static Scheme_Object *_swig_struct_type__LexicographicalView;
static const char *_swig_struct__LexicographicalView_field_names[] = { 
};
#define  _swig_struct__LexicographicalView_field_names_cnt (sizeof(_swig_struct__LexicographicalView_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__LexicographicalView(LexicographicalView *ptr);

typedef QuantLib::Matrix::row_iterator MatrixRow;
using QuantLib::outerProduct;
using QuantLib::transpose;
using QuantLib::SVD;

static std::string Matrix___str__(Matrix *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
static Real Matrix_ref(Matrix *self,Size i,Size j){
            return (*self)[i][j];
        }
static void Matrix_setitem(Matrix *self,Size i,Size j,Real x){
            (*self)[i][j] = x;
        }
static Scheme_Object *_swig_struct_type__Matrix;
static const char *_swig_struct__Matrix_field_names[] = { 
};
#define  _swig_struct__Matrix_field_names_cnt (sizeof(_swig_struct__Matrix_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Matrix(Matrix *ptr);

    Matrix Matrix_add(const Matrix& m, const Matrix& n) {
        return m+n;
    }
    Matrix Matrix_sub(const Matrix& m, const Matrix& n) {
        return m-n;
    }
    Matrix Matrix_div(const Matrix& m, Real x) {
        return m/x;
    }
    Matrix Matrix_mul(const Matrix& m, Real x) {
        return m*x;
    }
    Array Matrix_mul(const Matrix& m, const Array& a) {
        return m*a;
    }
    Matrix Matrix_mul(const Matrix& m, const Matrix& n) {
        return m*n;
    }


using QuantLib::pseudoSqrt;
using QuantLib::SalvagingAlgorithm;

static int _wrap_const_SalvagingAlgorithm_None = SalvagingAlgorithm::None;
static int _wrap_const_SalvagingAlgorithm_Spectral = SalvagingAlgorithm::Spectral;
static int _wrap_const_SalvagingAlgorithm_Hypersphere = SalvagingAlgorithm::Hypersphere;
static Scheme_Object *_swig_struct_type__SalvagingAlgorithm;
static const char *_swig_struct__SalvagingAlgorithm_field_names[] = { 
};
#define  _swig_struct__SalvagingAlgorithm_field_names_cnt (sizeof(_swig_struct__SalvagingAlgorithm_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SalvagingAlgorithm(SalvagingAlgorithm *ptr);
static Scheme_Object *_swig_struct_type__SVD;
static const char *_swig_struct__SVD_field_names[] = { 
};
#define  _swig_struct__SVD_field_names_cnt (sizeof(_swig_struct__SVD_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SVD(SVD *ptr);

using QuantLib::CostFunction;


class UnaryFunction {
  public:
	UnaryFunction(Scheme_Object* function) : function_(function) {
        QL_REQUIRE(SCHEME_PROCP(function), "procedure expected");
	    scheme_dont_gc_ptr(function_);
    }
    UnaryFunction(const UnaryFunction& f) : function_(f.function_) {
	    scheme_dont_gc_ptr(function_);
    }
    UnaryFunction& operator=(const UnaryFunction& f) {
        if ((this != &f) && (function_ != f.function_)) {
            scheme_gc_ptr_ok(function_);
            function_ = f.function_;
            scheme_dont_gc_ptr(function_);
        }
        return *this;
    }
    ~UnaryFunction() {
        scheme_gc_ptr_ok(function_);
    }
	Real operator()(Real x) const {
		Scheme_Object* arg = scheme_make_double(x);
        Scheme_Object* mzResult = scheme_apply(function_,1,&arg);
        QL_ENSURE(SCHEME_REALP(mzResult),
                  "the function did not return a double");
		Real result = scheme_real_to_double(mzResult);
		return result;
	}
  private:
	Scheme_Object* function_;
};

class BinaryFunction {
  public:
	BinaryFunction(Scheme_Object* function) : function_(function) {
        QL_REQUIRE(SCHEME_PROCP(function), "procedure expected");
	    scheme_dont_gc_ptr(function_);
    }
    BinaryFunction(const BinaryFunction& f) : function_(f.function_) {
	    scheme_dont_gc_ptr(function_);
    }
    BinaryFunction& operator=(const BinaryFunction& f) {
        if ((this != &f) && (function_ != f.function_)) {
            scheme_gc_ptr_ok(function_);
            function_ = f.function_;
            scheme_dont_gc_ptr(function_);
        }
        return *this;
    }
    ~BinaryFunction() {
        scheme_gc_ptr_ok(function_);
    }
	Real operator()(Real x, Real y) const {
		Scheme_Object* arg1 = scheme_make_double(x);
        Scheme_Object* arg2 = scheme_make_double(y);
        Scheme_Object* arg  = scheme_make_pair(arg1,
                                               scheme_make_pair(arg2,
                                                                scheme_null));
        Scheme_Object* mzResult = scheme_apply_to_list(function_,arg);
        QL_ENSURE(SCHEME_REALP(mzResult),
                  "the function did not return a double");
		Real result = scheme_real_to_double(mzResult);
		return result;
	}
  private:
	Scheme_Object* function_;
};

class MzCostFunction : public CostFunction {
  public:
	MzCostFunction(Scheme_Object* function) : function_(function) {
        QL_REQUIRE(SCHEME_PROCP(function), "procedure expected");
	    scheme_dont_gc_ptr(function_);
    }
    MzCostFunction(const MzCostFunction& f)
    : function_(f.function_) {
	    scheme_dont_gc_ptr(function_);
    }
    MzCostFunction& operator=(const MzCostFunction& f) {
        if ((this != &f) && (function_ != f.function_)) {
            scheme_gc_ptr_ok(function_);
            function_ = f.function_;
            scheme_dont_gc_ptr(function_);
        }
        return *this;
    }
    ~MzCostFunction() {
        scheme_gc_ptr_ok(function_);
    }
	Real value(const Array& x) const {
        Scheme_Object** args = new Scheme_Object*[x.size()];
        for (Size i=0; i<x.size(); i++)
            args[i] = scheme_make_double(x[i]);
        Scheme_Object* mzResult = scheme_apply(function_,x.size(),args);
        delete[] args;
        QL_ENSURE(SCHEME_REALP(mzResult),
                  "the function did not return a double");
		Real result = scheme_real_to_double(mzResult);
		return result;
	}
  private:
	Scheme_Object* function_;
};


using QuantLib::Quote;

static bool boost_shared_ptr_Sl_Quote_Sg__isNull(boost::shared_ptr<Quote > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > *boost_shared_ptr_Sl_Quote_Sg__asObservable(boost::shared_ptr<Quote > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTQuote_t;
static const char *_swig_struct__boost__shared_ptrTQuote_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTQuote_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTQuote_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTQuote_t(boost::shared_ptr<Quote > *ptr);
static boost::shared_ptr<Observable > *Handle_Sl_Quote_Sg__asObservable(Handle<Quote > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__HandleTQuote_t;
static const char *_swig_struct__HandleTQuote_t_field_names[] = { 
};
#define  _swig_struct__HandleTQuote_t_field_names_cnt (sizeof(_swig_struct__HandleTQuote_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__HandleTQuote_t(Handle<Quote > *ptr);

using QuantLib::SimpleQuote;
typedef boost::shared_ptr<Quote> SimpleQuotePtr;

static SimpleQuotePtr *new_SimpleQuotePtr(Real value){
            return new SimpleQuotePtr(new SimpleQuote(value));
        }
static void SimpleQuotePtr_setValue(SimpleQuotePtr *self,Real value){
            boost::dynamic_pointer_cast<SimpleQuote>(*self)->setValue(value);
        }
static Scheme_Object *_swig_struct_type__SimpleQuotePtr;
static const char *_swig_struct__SimpleQuotePtr_field_names[] = { 
};
#define  _swig_struct__SimpleQuotePtr_field_names_cnt (sizeof(_swig_struct__SimpleQuotePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SimpleQuotePtr(SimpleQuotePtr *ptr);

using QuantLib::DerivedQuote;
using QuantLib::CompositeQuote;
typedef boost::shared_ptr<Quote> DerivedQuotePtr;
typedef boost::shared_ptr<Quote> CompositeQuotePtr;

static DerivedQuotePtr *new_DerivedQuotePtr(Handle<Quote > const &h,Scheme_Object *function){
            return new DerivedQuotePtr(
                new DerivedQuote<UnaryFunction>(h,UnaryFunction(function)));
        }
static Scheme_Object *_swig_struct_type__DerivedQuotePtr;
static const char *_swig_struct__DerivedQuotePtr_field_names[] = { 
};
#define  _swig_struct__DerivedQuotePtr_field_names_cnt (sizeof(_swig_struct__DerivedQuotePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__DerivedQuotePtr(DerivedQuotePtr *ptr);
static CompositeQuotePtr *new_CompositeQuotePtr(Handle<Quote > const &h1,Handle<Quote > const &h2,Scheme_Object *function){
            return new CompositeQuotePtr(
                new CompositeQuote<BinaryFunction>(
                    h1,h2,BinaryFunction(function)));
        }
static Scheme_Object *_swig_struct_type__CompositeQuotePtr;
static const char *_swig_struct__CompositeQuotePtr_field_names[] = { 
};
#define  _swig_struct__CompositeQuotePtr_field_names_cnt (sizeof(_swig_struct__CompositeQuotePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CompositeQuotePtr(CompositeQuotePtr *ptr);
static boost::shared_ptr<Quote > std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__pop(std::vector<boost::shared_ptr<Quote > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                boost::shared_ptr<Quote > x = self->back();
                self->pop_back();
                return x;
            }
static boost::shared_ptr<Quote > &std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__ref(std::vector<boost::shared_ptr<Quote > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__set(std::vector<boost::shared_ptr<Quote > > *self,int i,boost::shared_ptr<Quote > const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static Scheme_Object *_swig_struct_type__std__vectorTboost__shared_ptrTQuote_t_t;
static const char *_swig_struct__std__vectorTboost__shared_ptrTQuote_t_t_field_names[] = { 
};
#define  _swig_struct__std__vectorTboost__shared_ptrTQuote_t_t_field_names_cnt (sizeof(_swig_struct__std__vectorTboost__shared_ptrTQuote_t_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__std__vectorTboost__shared_ptrTQuote_t_t(std::vector<boost::shared_ptr<Quote > > *ptr);
static Handle<Quote > std_vector_Sl_Handle_Sl_Quote_Sg__Sg__pop(std::vector<Handle<Quote > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                Handle<Quote > x = self->back();
                self->pop_back();
                return x;
            }
static Handle<Quote > &std_vector_Sl_Handle_Sl_Quote_Sg__Sg__ref(std::vector<Handle<Quote > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__set(std::vector<Handle<Quote > > *self,int i,Handle<Quote > const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static Scheme_Object *_swig_struct_type__std__vectorTHandleTQuote_t_t;
static const char *_swig_struct__std__vectorTHandleTQuote_t_t_field_names[] = { 
};
#define  _swig_struct__std__vectorTHandleTQuote_t_t_field_names_cnt (sizeof(_swig_struct__std__vectorTHandleTQuote_t_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__std__vectorTHandleTQuote_t_t(std::vector<Handle<Quote > > *ptr);

using QuantLib::Day;
using QuantLib::Year;


using QuantLib::Weekday;
using QuantLib::Sunday;
using QuantLib::Monday;
using QuantLib::Tuesday;
using QuantLib::Wednesday;
using QuantLib::Thursday;
using QuantLib::Friday;
using QuantLib::Saturday;

static int _wrap_const_Sunday = Sunday;
static int _wrap_const_Monday = Monday;
static int _wrap_const_Tuesday = Tuesday;
static int _wrap_const_Wednesday = Wednesday;
static int _wrap_const_Thursday = Thursday;
static int _wrap_const_Friday = Friday;
static int _wrap_const_Saturday = Saturday;

using QuantLib::Month;
using QuantLib::January;
using QuantLib::February;
using QuantLib::March;
using QuantLib::April;
using QuantLib::May;
using QuantLib::June;
using QuantLib::July;
using QuantLib::August;
using QuantLib::September;
using QuantLib::October;
using QuantLib::November;
using QuantLib::December;

static int _wrap_const_January = January;
static int _wrap_const_February = February;
static int _wrap_const_March = March;
static int _wrap_const_April = April;
static int _wrap_const_May = May;
static int _wrap_const_June = June;
static int _wrap_const_July = July;
static int _wrap_const_August = August;
static int _wrap_const_September = September;
static int _wrap_const_October = October;
static int _wrap_const_November = November;
static int _wrap_const_December = December;

using QuantLib::TimeUnit;
using QuantLib::Days;
using QuantLib::Weeks;
using QuantLib::Months;
using QuantLib::Years;

static int _wrap_const_Days = Days;
static int _wrap_const_Weeks = Weeks;
static int _wrap_const_Months = Months;
static int _wrap_const_Years = Years;

using QuantLib::Frequency;
using QuantLib::NoFrequency;
using QuantLib::Once;
using QuantLib::Annual;
using QuantLib::Semiannual;
using QuantLib::EveryFourthMonth;
using QuantLib::Quarterly;
using QuantLib::Bimonthly;
using QuantLib::Monthly;

static int _wrap_const_NoFrequency = NoFrequency;
static int _wrap_const_Once = Once;
static int _wrap_const_Annual = Annual;
static int _wrap_const_Semiannual = Semiannual;
static int _wrap_const_EveryFourthMonth = EveryFourthMonth;
static int _wrap_const_Quarterly = Quarterly;
static int _wrap_const_Bimonthly = Bimonthly;
static int _wrap_const_Monthly = Monthly;

using QuantLib::Period;
using QuantLib::PeriodParser;

static Period *new_Period__SWIG_1(std::string const &str){
            return new Period(PeriodParser::parse(str));
        }
static std::string Period___str__(Period *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
static std::string Period___repr__(Period *self){
            std::ostringstream out;
            out << "Period(\"" << QuantLib::io::short_period(*self) << "\")";
            return out.str();
        }
static int Period___cmp__(Period *self,Period const &other){
            if (*self < other)
                return -1;
            if (*self == other)
                return 0;
            return 1;
        }
static Scheme_Object *_swig_struct_type__Period;
static const char *_swig_struct__Period_field_names[] = { 
};
#define  _swig_struct__Period_field_names_cnt (sizeof(_swig_struct__Period_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Period(Period *ptr);
static Period std_vector_Sl_Period_Sg__pop(std::vector<Period > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                Period x = self->back();
                self->pop_back();
                return x;
            }
static Period &std_vector_Sl_Period_Sg__ref(std::vector<Period > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_Period_Sg__set(std::vector<Period > *self,int i,Period const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static Scheme_Object *_swig_struct_type__std__vectorTPeriod_t;
static const char *_swig_struct__std__vectorTPeriod_t_field_names[] = { 
};
#define  _swig_struct__std__vectorTPeriod_t_field_names_cnt (sizeof(_swig_struct__std__vectorTPeriod_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__std__vectorTPeriod_t(std::vector<Period > *ptr);

using QuantLib::Date;
using QuantLib::DateParser;

static Date *new_Date__SWIG_3(std::string const &str,std::string const &fmt){
            return new Date(DateParser::parse(str,fmt));
        }
static Integer Date_weekdayNumber(Date *self){
            return int(self->weekday());
        }
static std::string Date___str__(Date *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
static std::string Date___repr__(Date *self){
            std::ostringstream out;
            out << "Date(" << self->dayOfMonth() << ","
                << int(self->month()) << "," << self->year() << ")";
            return out.str();
        }
static std::string Date_ISO(Date *self){
            std::ostringstream out;
            out << QuantLib::io::iso_date(*self);
            return out.str();
        }
static Date Date_advance(Date *self,Integer n,TimeUnit units){
            return *self + n*units;
        }
static Scheme_Object *_swig_struct_type__Date;
static const char *_swig_struct__Date_field_names[] = { 
};
#define  _swig_struct__Date_field_names_cnt (sizeof(_swig_struct__Date_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Date(Date *ptr);
static Date std_vector_Sl_Date_Sg__pop(std::vector<Date > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                Date x = self->back();
                self->pop_back();
                return x;
            }
static Date &std_vector_Sl_Date_Sg__ref(std::vector<Date > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_Date_Sg__set(std::vector<Date > *self,int i,Date const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static Scheme_Object *_swig_struct_type__std__vectorTDate_t;
static const char *_swig_struct__std__vectorTDate_t_field_names[] = { 
};
#define  _swig_struct__std__vectorTDate_t_field_names_cnt (sizeof(_swig_struct__std__vectorTDate_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__std__vectorTDate_t(std::vector<Date > *ptr);

    // difference - comparison
    BigInteger Date_days_between(const Date& d1, const Date& d2) {
        return d2-d1;
    }
    bool Date_equal(const Date& d1, const Date& d2) {
        return d1 == d2;
    }
    bool Date_less(const Date& d1, const Date& d2) {
        return d1 < d2;
    }
    bool Date_less_equal(const Date& d1, const Date& d2) {
        return d1 <= d2;
    }
    bool Date_greater(const Date& d1, const Date& d2) {
        return d1 > d2;
    }
    bool Date_greater_equal(const Date& d1, const Date& d2) {
        return d1 >= d2;
    }


using QuantLib::Null;
typedef int intOrNull;
typedef double doubleOrNull;


int nullInt() { return Null<int>(); }
double nullDouble() { return Null<double>(); }


using QuantLib::DayCounter;

static std::string DayCounter___str__(DayCounter *self){
            return self->name()+" day counter";
        }
static Scheme_Object *_swig_struct_type__DayCounter;
static const char *_swig_struct__DayCounter_field_names[] = { 
};
#define  _swig_struct__DayCounter_field_names_cnt (sizeof(_swig_struct__DayCounter_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__DayCounter(DayCounter *ptr);

    bool DayCounter_equal(const DayCounter& d1, const DayCounter& d2) {
        return d1 == d2;
    }

static Scheme_Object *_swig_struct_type__QuantLib__Actual360;
static const char *_swig_struct__QuantLib__Actual360_field_names[] = { 
};
#define  _swig_struct__QuantLib__Actual360_field_names_cnt (sizeof(_swig_struct__QuantLib__Actual360_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Actual360(QuantLib::Actual360 *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Actual365Fixed;
static const char *_swig_struct__QuantLib__Actual365Fixed_field_names[] = { 
};
#define  _swig_struct__QuantLib__Actual365Fixed_field_names_cnt (sizeof(_swig_struct__QuantLib__Actual365Fixed_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Actual365Fixed(QuantLib::Actual365Fixed *ptr);
static int _wrap_const_Thirty360_USA = QuantLib::Thirty360::USA;
static int _wrap_const_Thirty360_BondBasis = QuantLib::Thirty360::BondBasis;
static int _wrap_const_Thirty360_European = QuantLib::Thirty360::European;
static int _wrap_const_Thirty360_EurobondBasis = QuantLib::Thirty360::EurobondBasis;
static int _wrap_const_Thirty360_Italian = QuantLib::Thirty360::Italian;
static Scheme_Object *_swig_struct_type__QuantLib__Thirty360;
static const char *_swig_struct__QuantLib__Thirty360_field_names[] = { 
};
#define  _swig_struct__QuantLib__Thirty360_field_names_cnt (sizeof(_swig_struct__QuantLib__Thirty360_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Thirty360(QuantLib::Thirty360 *ptr);
static int _wrap_const_ActualActual_ISMA = QuantLib::ActualActual::ISMA;
static int _wrap_const_ActualActual_Bond = QuantLib::ActualActual::Bond;
static int _wrap_const_ActualActual_ISDA = QuantLib::ActualActual::ISDA;
static int _wrap_const_ActualActual_Historical = QuantLib::ActualActual::Historical;
static int _wrap_const_ActualActual_AFB = QuantLib::ActualActual::AFB;
static int _wrap_const_ActualActual_Euro = QuantLib::ActualActual::Euro;
static Scheme_Object *_swig_struct_type__QuantLib__ActualActual;
static const char *_swig_struct__QuantLib__ActualActual_field_names[] = { 
};
#define  _swig_struct__QuantLib__ActualActual_field_names_cnt (sizeof(_swig_struct__QuantLib__ActualActual_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__ActualActual(QuantLib::ActualActual *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__OneDayCounter;
static const char *_swig_struct__QuantLib__OneDayCounter_field_names[] = { 
};
#define  _swig_struct__QuantLib__OneDayCounter_field_names_cnt (sizeof(_swig_struct__QuantLib__OneDayCounter_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__OneDayCounter(QuantLib::OneDayCounter *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__SimpleDayCounter;
static const char *_swig_struct__QuantLib__SimpleDayCounter_field_names[] = { 
};
#define  _swig_struct__QuantLib__SimpleDayCounter_field_names_cnt (sizeof(_swig_struct__QuantLib__SimpleDayCounter_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__SimpleDayCounter(QuantLib::SimpleDayCounter *ptr);

using QuantLib::Compounding;
using QuantLib::Simple;
using QuantLib::Compounded;
using QuantLib::Continuous;
using QuantLib::SimpleThenCompounded;

static int _wrap_const_Simple = Simple;
static int _wrap_const_Compounded = Compounded;
static int _wrap_const_Continuous = Continuous;
static int _wrap_const_SimpleThenCompounded = SimpleThenCompounded;

using QuantLib::InterestRate;

static std::string InterestRate___str__(InterestRate *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
static Scheme_Object *_swig_struct_type__InterestRate;
static const char *_swig_struct__InterestRate_field_names[] = { 
};
#define  _swig_struct__InterestRate_field_names_cnt (sizeof(_swig_struct__InterestRate_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InterestRate(InterestRate *ptr);

using QuantLib::Calendar;


using QuantLib::BusinessDayConvention;
using QuantLib::Unadjusted;
using QuantLib::Preceding;
using QuantLib::ModifiedPreceding;
using QuantLib::Following;
using QuantLib::ModifiedFollowing;
using QuantLib::MonthEndReference;

static int _wrap_const_Unadjusted = Unadjusted;
static int _wrap_const_Preceding = Preceding;
static int _wrap_const_ModifiedPreceding = ModifiedPreceding;
static int _wrap_const_Following = Following;
static int _wrap_const_ModifiedFollowing = ModifiedFollowing;
static int _wrap_const_MonthEndReference = MonthEndReference;

using QuantLib::JointCalendarRule;
using QuantLib::JoinHolidays;
using QuantLib::JoinBusinessDays;

static int _wrap_const_JoinHolidays = JoinHolidays;
static int _wrap_const_JoinBusinessDays = JoinBusinessDays;
static std::string Calendar___str__(Calendar *self){
            return self->name()+" calendar";
        }
static Scheme_Object *_swig_struct_type__Calendar;
static const char *_swig_struct__Calendar_field_names[] = { 
};
#define  _swig_struct__Calendar_field_names_cnt (sizeof(_swig_struct__Calendar_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Calendar(Calendar *ptr);

    bool Calendar_equal(const Calendar& c1, const Calendar& c2) {
        return c1 == c2;
    }

static Scheme_Object *_swig_struct_type__QuantLib__Beijing;
static const char *_swig_struct__QuantLib__Beijing_field_names[] = { 
};
#define  _swig_struct__QuantLib__Beijing_field_names_cnt (sizeof(_swig_struct__QuantLib__Beijing_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Beijing(QuantLib::Beijing *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Bombay;
static const char *_swig_struct__QuantLib__Bombay_field_names[] = { 
};
#define  _swig_struct__QuantLib__Bombay_field_names_cnt (sizeof(_swig_struct__QuantLib__Bombay_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Bombay(QuantLib::Bombay *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Bratislava;
static const char *_swig_struct__QuantLib__Bratislava_field_names[] = { 
};
#define  _swig_struct__QuantLib__Bratislava_field_names_cnt (sizeof(_swig_struct__QuantLib__Bratislava_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Bratislava(QuantLib::Bratislava *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Budapest;
static const char *_swig_struct__QuantLib__Budapest_field_names[] = { 
};
#define  _swig_struct__QuantLib__Budapest_field_names_cnt (sizeof(_swig_struct__QuantLib__Budapest_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Budapest(QuantLib::Budapest *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Copenhagen;
static const char *_swig_struct__QuantLib__Copenhagen_field_names[] = { 
};
#define  _swig_struct__QuantLib__Copenhagen_field_names_cnt (sizeof(_swig_struct__QuantLib__Copenhagen_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Copenhagen(QuantLib::Copenhagen *ptr);
static int _wrap_const_Germany_Settlement = QuantLib::Germany::Settlement;
static int _wrap_const_Germany_FrankfurtStockExchange = QuantLib::Germany::FrankfurtStockExchange;
static int _wrap_const_Germany_Xetra = QuantLib::Germany::Xetra;
static int _wrap_const_Germany_Eurex = QuantLib::Germany::Eurex;
static Scheme_Object *_swig_struct_type__QuantLib__Germany;
static const char *_swig_struct__QuantLib__Germany_field_names[] = { 
};
#define  _swig_struct__QuantLib__Germany_field_names_cnt (sizeof(_swig_struct__QuantLib__Germany_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Germany(QuantLib::Germany *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Helsinki;
static const char *_swig_struct__QuantLib__Helsinki_field_names[] = { 
};
#define  _swig_struct__QuantLib__Helsinki_field_names_cnt (sizeof(_swig_struct__QuantLib__Helsinki_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Helsinki(QuantLib::Helsinki *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__HongKong;
static const char *_swig_struct__QuantLib__HongKong_field_names[] = { 
};
#define  _swig_struct__QuantLib__HongKong_field_names_cnt (sizeof(_swig_struct__QuantLib__HongKong_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__HongKong(QuantLib::HongKong *ptr);
static int _wrap_const_Italy_Settlement = QuantLib::Italy::Settlement;
static int _wrap_const_Italy_Exchange = QuantLib::Italy::Exchange;
static Scheme_Object *_swig_struct_type__QuantLib__Italy;
static const char *_swig_struct__QuantLib__Italy_field_names[] = { 
};
#define  _swig_struct__QuantLib__Italy_field_names_cnt (sizeof(_swig_struct__QuantLib__Italy_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Italy(QuantLib::Italy *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Istanbul;
static const char *_swig_struct__QuantLib__Istanbul_field_names[] = { 
};
#define  _swig_struct__QuantLib__Istanbul_field_names_cnt (sizeof(_swig_struct__QuantLib__Istanbul_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Istanbul(QuantLib::Istanbul *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Johannesburg;
static const char *_swig_struct__QuantLib__Johannesburg_field_names[] = { 
};
#define  _swig_struct__QuantLib__Johannesburg_field_names_cnt (sizeof(_swig_struct__QuantLib__Johannesburg_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Johannesburg(QuantLib::Johannesburg *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__NullCalendar;
static const char *_swig_struct__QuantLib__NullCalendar_field_names[] = { 
};
#define  _swig_struct__QuantLib__NullCalendar_field_names_cnt (sizeof(_swig_struct__QuantLib__NullCalendar_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__NullCalendar(QuantLib::NullCalendar *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Oslo;
static const char *_swig_struct__QuantLib__Oslo_field_names[] = { 
};
#define  _swig_struct__QuantLib__Oslo_field_names_cnt (sizeof(_swig_struct__QuantLib__Oslo_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Oslo(QuantLib::Oslo *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Prague;
static const char *_swig_struct__QuantLib__Prague_field_names[] = { 
};
#define  _swig_struct__QuantLib__Prague_field_names_cnt (sizeof(_swig_struct__QuantLib__Prague_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Prague(QuantLib::Prague *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Riyadh;
static const char *_swig_struct__QuantLib__Riyadh_field_names[] = { 
};
#define  _swig_struct__QuantLib__Riyadh_field_names_cnt (sizeof(_swig_struct__QuantLib__Riyadh_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Riyadh(QuantLib::Riyadh *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Seoul;
static const char *_swig_struct__QuantLib__Seoul_field_names[] = { 
};
#define  _swig_struct__QuantLib__Seoul_field_names_cnt (sizeof(_swig_struct__QuantLib__Seoul_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Seoul(QuantLib::Seoul *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Singapore;
static const char *_swig_struct__QuantLib__Singapore_field_names[] = { 
};
#define  _swig_struct__QuantLib__Singapore_field_names_cnt (sizeof(_swig_struct__QuantLib__Singapore_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Singapore(QuantLib::Singapore *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Stockholm;
static const char *_swig_struct__QuantLib__Stockholm_field_names[] = { 
};
#define  _swig_struct__QuantLib__Stockholm_field_names_cnt (sizeof(_swig_struct__QuantLib__Stockholm_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Stockholm(QuantLib::Stockholm *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Sydney;
static const char *_swig_struct__QuantLib__Sydney_field_names[] = { 
};
#define  _swig_struct__QuantLib__Sydney_field_names_cnt (sizeof(_swig_struct__QuantLib__Sydney_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Sydney(QuantLib::Sydney *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__TARGET;
static const char *_swig_struct__QuantLib__TARGET_field_names[] = { 
};
#define  _swig_struct__QuantLib__TARGET_field_names_cnt (sizeof(_swig_struct__QuantLib__TARGET_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__TARGET(QuantLib::TARGET *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Taipei;
static const char *_swig_struct__QuantLib__Taipei_field_names[] = { 
};
#define  _swig_struct__QuantLib__Taipei_field_names_cnt (sizeof(_swig_struct__QuantLib__Taipei_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Taipei(QuantLib::Taipei *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Taiwan;
static const char *_swig_struct__QuantLib__Taiwan_field_names[] = { 
};
#define  _swig_struct__QuantLib__Taiwan_field_names_cnt (sizeof(_swig_struct__QuantLib__Taiwan_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Taiwan(QuantLib::Taiwan *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Tokyo;
static const char *_swig_struct__QuantLib__Tokyo_field_names[] = { 
};
#define  _swig_struct__QuantLib__Tokyo_field_names_cnt (sizeof(_swig_struct__QuantLib__Tokyo_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Tokyo(QuantLib::Tokyo *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Toronto;
static const char *_swig_struct__QuantLib__Toronto_field_names[] = { 
};
#define  _swig_struct__QuantLib__Toronto_field_names_cnt (sizeof(_swig_struct__QuantLib__Toronto_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Toronto(QuantLib::Toronto *ptr);
static int _wrap_const_UnitedKingdom_Settlement = QuantLib::UnitedKingdom::Settlement;
static int _wrap_const_UnitedKingdom_Exchange = QuantLib::UnitedKingdom::Exchange;
static int _wrap_const_UnitedKingdom_Metals = QuantLib::UnitedKingdom::Metals;
static Scheme_Object *_swig_struct_type__QuantLib__UnitedKingdom;
static const char *_swig_struct__QuantLib__UnitedKingdom_field_names[] = { 
};
#define  _swig_struct__QuantLib__UnitedKingdom_field_names_cnt (sizeof(_swig_struct__QuantLib__UnitedKingdom_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__UnitedKingdom(QuantLib::UnitedKingdom *ptr);
static int _wrap_const_UnitedStates_Settlement = QuantLib::UnitedStates::Settlement;
static int _wrap_const_UnitedStates_Exchange = QuantLib::UnitedStates::Exchange;
static int _wrap_const_UnitedStates_GovernmentBond = QuantLib::UnitedStates::GovernmentBond;
static Scheme_Object *_swig_struct_type__QuantLib__UnitedStates;
static const char *_swig_struct__QuantLib__UnitedStates_field_names[] = { 
};
#define  _swig_struct__QuantLib__UnitedStates_field_names_cnt (sizeof(_swig_struct__QuantLib__UnitedStates_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__UnitedStates(QuantLib::UnitedStates *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Warsaw;
static const char *_swig_struct__QuantLib__Warsaw_field_names[] = { 
};
#define  _swig_struct__QuantLib__Warsaw_field_names_cnt (sizeof(_swig_struct__QuantLib__Warsaw_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Warsaw(QuantLib::Warsaw *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Wellington;
static const char *_swig_struct__QuantLib__Wellington_field_names[] = { 
};
#define  _swig_struct__QuantLib__Wellington_field_names_cnt (sizeof(_swig_struct__QuantLib__Wellington_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Wellington(QuantLib::Wellington *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__Zurich;
static const char *_swig_struct__QuantLib__Zurich_field_names[] = { 
};
#define  _swig_struct__QuantLib__Zurich_field_names_cnt (sizeof(_swig_struct__QuantLib__Zurich_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__Zurich(QuantLib::Zurich *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__JointCalendar;
static const char *_swig_struct__QuantLib__JointCalendar_field_names[] = { 
};
#define  _swig_struct__QuantLib__JointCalendar_field_names_cnt (sizeof(_swig_struct__QuantLib__JointCalendar_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__JointCalendar(QuantLib::JointCalendar *ptr);

using QuantLib::Rounding;
using QuantLib::UpRounding;
using QuantLib::DownRounding;
using QuantLib::ClosestRounding;
using QuantLib::CeilingTruncation;
using QuantLib::FloorTruncation;

static Scheme_Object *_swig_struct_type__Rounding;
static const char *_swig_struct__Rounding_field_names[] = { 
};
#define  _swig_struct__Rounding_field_names_cnt (sizeof(_swig_struct__Rounding_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Rounding(Rounding *ptr);
static Scheme_Object *_swig_struct_type__UpRounding;
static const char *_swig_struct__UpRounding_field_names[] = { 
};
#define  _swig_struct__UpRounding_field_names_cnt (sizeof(_swig_struct__UpRounding_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__UpRounding(UpRounding *ptr);
static Scheme_Object *_swig_struct_type__DownRounding;
static const char *_swig_struct__DownRounding_field_names[] = { 
};
#define  _swig_struct__DownRounding_field_names_cnt (sizeof(_swig_struct__DownRounding_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__DownRounding(DownRounding *ptr);
static Scheme_Object *_swig_struct_type__ClosestRounding;
static const char *_swig_struct__ClosestRounding_field_names[] = { 
};
#define  _swig_struct__ClosestRounding_field_names_cnt (sizeof(_swig_struct__ClosestRounding_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__ClosestRounding(ClosestRounding *ptr);
static Scheme_Object *_swig_struct_type__CeilingTruncation;
static const char *_swig_struct__CeilingTruncation_field_names[] = { 
};
#define  _swig_struct__CeilingTruncation_field_names_cnt (sizeof(_swig_struct__CeilingTruncation_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CeilingTruncation(CeilingTruncation *ptr);
static Scheme_Object *_swig_struct_type__FloorTruncation;
static const char *_swig_struct__FloorTruncation_field_names[] = { 
};
#define  _swig_struct__FloorTruncation_field_names_cnt (sizeof(_swig_struct__FloorTruncation_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FloorTruncation(FloorTruncation *ptr);

using QuantLib::Currency;

static std::string Currency___str__(Currency *self){
            return self->name();
        }
static Scheme_Object *_swig_struct_type__Currency;
static const char *_swig_struct__Currency_field_names[] = { 
};
#define  _swig_struct__Currency_field_names_cnt (sizeof(_swig_struct__Currency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Currency(Currency *ptr);

    bool Currency_equal(const Currency& c1, const Currency& c2) {
        return c1 == c2;
    }

static Scheme_Object *_swig_struct_type__QuantLib__ARSCurrency;
static const char *_swig_struct__QuantLib__ARSCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__ARSCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__ARSCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__ARSCurrency(QuantLib::ARSCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__ATSCurrency;
static const char *_swig_struct__QuantLib__ATSCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__ATSCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__ATSCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__ATSCurrency(QuantLib::ATSCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__AUDCurrency;
static const char *_swig_struct__QuantLib__AUDCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__AUDCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__AUDCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__AUDCurrency(QuantLib::AUDCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__BDTCurrency;
static const char *_swig_struct__QuantLib__BDTCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__BDTCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__BDTCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__BDTCurrency(QuantLib::BDTCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__BEFCurrency;
static const char *_swig_struct__QuantLib__BEFCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__BEFCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__BEFCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__BEFCurrency(QuantLib::BEFCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__BGLCurrency;
static const char *_swig_struct__QuantLib__BGLCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__BGLCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__BGLCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__BGLCurrency(QuantLib::BGLCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__BRLCurrency;
static const char *_swig_struct__QuantLib__BRLCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__BRLCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__BRLCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__BRLCurrency(QuantLib::BRLCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__BYRCurrency;
static const char *_swig_struct__QuantLib__BYRCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__BYRCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__BYRCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__BYRCurrency(QuantLib::BYRCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__CADCurrency;
static const char *_swig_struct__QuantLib__CADCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__CADCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__CADCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__CADCurrency(QuantLib::CADCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__CHFCurrency;
static const char *_swig_struct__QuantLib__CHFCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__CHFCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__CHFCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__CHFCurrency(QuantLib::CHFCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__CLPCurrency;
static const char *_swig_struct__QuantLib__CLPCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__CLPCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__CLPCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__CLPCurrency(QuantLib::CLPCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__CNYCurrency;
static const char *_swig_struct__QuantLib__CNYCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__CNYCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__CNYCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__CNYCurrency(QuantLib::CNYCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__COPCurrency;
static const char *_swig_struct__QuantLib__COPCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__COPCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__COPCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__COPCurrency(QuantLib::COPCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__CYPCurrency;
static const char *_swig_struct__QuantLib__CYPCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__CYPCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__CYPCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__CYPCurrency(QuantLib::CYPCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__CZKCurrency;
static const char *_swig_struct__QuantLib__CZKCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__CZKCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__CZKCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__CZKCurrency(QuantLib::CZKCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__DEMCurrency;
static const char *_swig_struct__QuantLib__DEMCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__DEMCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__DEMCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__DEMCurrency(QuantLib::DEMCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__DKKCurrency;
static const char *_swig_struct__QuantLib__DKKCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__DKKCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__DKKCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__DKKCurrency(QuantLib::DKKCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__EEKCurrency;
static const char *_swig_struct__QuantLib__EEKCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__EEKCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__EEKCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__EEKCurrency(QuantLib::EEKCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__ESPCurrency;
static const char *_swig_struct__QuantLib__ESPCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__ESPCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__ESPCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__ESPCurrency(QuantLib::ESPCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__EURCurrency;
static const char *_swig_struct__QuantLib__EURCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__EURCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__EURCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__EURCurrency(QuantLib::EURCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__FIMCurrency;
static const char *_swig_struct__QuantLib__FIMCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__FIMCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__FIMCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__FIMCurrency(QuantLib::FIMCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__FRFCurrency;
static const char *_swig_struct__QuantLib__FRFCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__FRFCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__FRFCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__FRFCurrency(QuantLib::FRFCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__GBPCurrency;
static const char *_swig_struct__QuantLib__GBPCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__GBPCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__GBPCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__GBPCurrency(QuantLib::GBPCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__GRDCurrency;
static const char *_swig_struct__QuantLib__GRDCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__GRDCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__GRDCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__GRDCurrency(QuantLib::GRDCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__HKDCurrency;
static const char *_swig_struct__QuantLib__HKDCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__HKDCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__HKDCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__HKDCurrency(QuantLib::HKDCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__HUFCurrency;
static const char *_swig_struct__QuantLib__HUFCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__HUFCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__HUFCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__HUFCurrency(QuantLib::HUFCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__IEPCurrency;
static const char *_swig_struct__QuantLib__IEPCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__IEPCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__IEPCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__IEPCurrency(QuantLib::IEPCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__ILSCurrency;
static const char *_swig_struct__QuantLib__ILSCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__ILSCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__ILSCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__ILSCurrency(QuantLib::ILSCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__INRCurrency;
static const char *_swig_struct__QuantLib__INRCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__INRCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__INRCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__INRCurrency(QuantLib::INRCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__IQDCurrency;
static const char *_swig_struct__QuantLib__IQDCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__IQDCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__IQDCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__IQDCurrency(QuantLib::IQDCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__IRRCurrency;
static const char *_swig_struct__QuantLib__IRRCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__IRRCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__IRRCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__IRRCurrency(QuantLib::IRRCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__ISKCurrency;
static const char *_swig_struct__QuantLib__ISKCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__ISKCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__ISKCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__ISKCurrency(QuantLib::ISKCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__ITLCurrency;
static const char *_swig_struct__QuantLib__ITLCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__ITLCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__ITLCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__ITLCurrency(QuantLib::ITLCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__JPYCurrency;
static const char *_swig_struct__QuantLib__JPYCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__JPYCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__JPYCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__JPYCurrency(QuantLib::JPYCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__KRWCurrency;
static const char *_swig_struct__QuantLib__KRWCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__KRWCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__KRWCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__KRWCurrency(QuantLib::KRWCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__KWDCurrency;
static const char *_swig_struct__QuantLib__KWDCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__KWDCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__KWDCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__KWDCurrency(QuantLib::KWDCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__LTLCurrency;
static const char *_swig_struct__QuantLib__LTLCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__LTLCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__LTLCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__LTLCurrency(QuantLib::LTLCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__LUFCurrency;
static const char *_swig_struct__QuantLib__LUFCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__LUFCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__LUFCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__LUFCurrency(QuantLib::LUFCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__LVLCurrency;
static const char *_swig_struct__QuantLib__LVLCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__LVLCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__LVLCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__LVLCurrency(QuantLib::LVLCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__MTLCurrency;
static const char *_swig_struct__QuantLib__MTLCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__MTLCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__MTLCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__MTLCurrency(QuantLib::MTLCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__MXNCurrency;
static const char *_swig_struct__QuantLib__MXNCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__MXNCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__MXNCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__MXNCurrency(QuantLib::MXNCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__NLGCurrency;
static const char *_swig_struct__QuantLib__NLGCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__NLGCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__NLGCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__NLGCurrency(QuantLib::NLGCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__NOKCurrency;
static const char *_swig_struct__QuantLib__NOKCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__NOKCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__NOKCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__NOKCurrency(QuantLib::NOKCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__NPRCurrency;
static const char *_swig_struct__QuantLib__NPRCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__NPRCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__NPRCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__NPRCurrency(QuantLib::NPRCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__NZDCurrency;
static const char *_swig_struct__QuantLib__NZDCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__NZDCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__NZDCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__NZDCurrency(QuantLib::NZDCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__PKRCurrency;
static const char *_swig_struct__QuantLib__PKRCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__PKRCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__PKRCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__PKRCurrency(QuantLib::PKRCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__PLNCurrency;
static const char *_swig_struct__QuantLib__PLNCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__PLNCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__PLNCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__PLNCurrency(QuantLib::PLNCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__PTECurrency;
static const char *_swig_struct__QuantLib__PTECurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__PTECurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__PTECurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__PTECurrency(QuantLib::PTECurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__ROLCurrency;
static const char *_swig_struct__QuantLib__ROLCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__ROLCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__ROLCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__ROLCurrency(QuantLib::ROLCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__SARCurrency;
static const char *_swig_struct__QuantLib__SARCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__SARCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__SARCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__SARCurrency(QuantLib::SARCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__SEKCurrency;
static const char *_swig_struct__QuantLib__SEKCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__SEKCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__SEKCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__SEKCurrency(QuantLib::SEKCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__SGDCurrency;
static const char *_swig_struct__QuantLib__SGDCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__SGDCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__SGDCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__SGDCurrency(QuantLib::SGDCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__SITCurrency;
static const char *_swig_struct__QuantLib__SITCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__SITCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__SITCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__SITCurrency(QuantLib::SITCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__SKKCurrency;
static const char *_swig_struct__QuantLib__SKKCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__SKKCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__SKKCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__SKKCurrency(QuantLib::SKKCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__THBCurrency;
static const char *_swig_struct__QuantLib__THBCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__THBCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__THBCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__THBCurrency(QuantLib::THBCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__TRLCurrency;
static const char *_swig_struct__QuantLib__TRLCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__TRLCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__TRLCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__TRLCurrency(QuantLib::TRLCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__TRYCurrency;
static const char *_swig_struct__QuantLib__TRYCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__TRYCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__TRYCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__TRYCurrency(QuantLib::TRYCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__TTDCurrency;
static const char *_swig_struct__QuantLib__TTDCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__TTDCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__TTDCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__TTDCurrency(QuantLib::TTDCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__TWDCurrency;
static const char *_swig_struct__QuantLib__TWDCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__TWDCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__TWDCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__TWDCurrency(QuantLib::TWDCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__USDCurrency;
static const char *_swig_struct__QuantLib__USDCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__USDCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__USDCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__USDCurrency(QuantLib::USDCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__VEBCurrency;
static const char *_swig_struct__QuantLib__VEBCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__VEBCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__VEBCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__VEBCurrency(QuantLib::VEBCurrency *ptr);
static Scheme_Object *_swig_struct_type__QuantLib__ZARCurrency;
static const char *_swig_struct__QuantLib__ZARCurrency_field_names[] = { 
};
#define  _swig_struct__QuantLib__ZARCurrency_field_names_cnt (sizeof(_swig_struct__QuantLib__ZARCurrency_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__QuantLib__ZARCurrency(QuantLib::ZARCurrency *ptr);

using QuantLib::Extrapolator;


// safe versions which copy their arguments
template <class I>
class SafeInterpolation {
  public:
    SafeInterpolation(const Array& x, const Array& y)
    : x_(x), y_(y), f_(x_.begin(),x_.end(),y_.begin()) {}
    Real operator()(Real x, bool allowExtrapolation=false) {
        return f_(x, allowExtrapolation);
    }
    Array x_, y_;
    I f_;
};


typedef SafeInterpolation<QuantLib::LinearInterpolation> SafeLinearInterpolation;

static Scheme_Object *_swig_struct_type__SafeLinearInterpolation;
static const char *_swig_struct__SafeLinearInterpolation_field_names[] = { 
};
#define  _swig_struct__SafeLinearInterpolation_field_names_cnt (sizeof(_swig_struct__SafeLinearInterpolation_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SafeLinearInterpolation(SafeLinearInterpolation *ptr);

typedef SafeInterpolation<QuantLib::LogLinearInterpolation> SafeLogLinearInterpolation;

static Scheme_Object *_swig_struct_type__SafeLogLinearInterpolation;
static const char *_swig_struct__SafeLogLinearInterpolation_field_names[] = { 
};
#define  _swig_struct__SafeLogLinearInterpolation_field_names_cnt (sizeof(_swig_struct__SafeLogLinearInterpolation_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SafeLogLinearInterpolation(SafeLogLinearInterpolation *ptr);

typedef SafeInterpolation<QuantLib::BackwardFlatInterpolation> SafeBackwardFlatInterpolation;

static Scheme_Object *_swig_struct_type__SafeBackwardFlatInterpolation;
static const char *_swig_struct__SafeBackwardFlatInterpolation_field_names[] = { 
};
#define  _swig_struct__SafeBackwardFlatInterpolation_field_names_cnt (sizeof(_swig_struct__SafeBackwardFlatInterpolation_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SafeBackwardFlatInterpolation(SafeBackwardFlatInterpolation *ptr);

typedef SafeInterpolation<QuantLib::ForwardFlatInterpolation> SafeForwardFlatInterpolation;

static Scheme_Object *_swig_struct_type__SafeForwardFlatInterpolation;
static const char *_swig_struct__SafeForwardFlatInterpolation_field_names[] = { 
};
#define  _swig_struct__SafeForwardFlatInterpolation_field_names_cnt (sizeof(_swig_struct__SafeForwardFlatInterpolation_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SafeForwardFlatInterpolation(SafeForwardFlatInterpolation *ptr);

typedef SafeInterpolation<QuantLib::NaturalCubicSpline> SafeNaturalCubicSpline;

static Real SafeNaturalCubicSpline_derivative__SWIG_0(SafeNaturalCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
static Real SafeNaturalCubicSpline_secondDerivative__SWIG_0(SafeNaturalCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
static Scheme_Object *_swig_struct_type__SafeNaturalCubicSpline;
static const char *_swig_struct__SafeNaturalCubicSpline_field_names[] = { 
};
#define  _swig_struct__SafeNaturalCubicSpline_field_names_cnt (sizeof(_swig_struct__SafeNaturalCubicSpline_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SafeNaturalCubicSpline(SafeNaturalCubicSpline *ptr);

typedef SafeInterpolation<QuantLib::NaturalMonotonicCubicSpline> SafeNaturalMonotonicCubicSpline;

static Real SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
static Real SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }
static Scheme_Object *_swig_struct_type__SafeNaturalMonotonicCubicSpline;
static const char *_swig_struct__SafeNaturalMonotonicCubicSpline_field_names[] = { 
};
#define  _swig_struct__SafeNaturalMonotonicCubicSpline_field_names_cnt (sizeof(_swig_struct__SafeNaturalMonotonicCubicSpline_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SafeNaturalMonotonicCubicSpline(SafeNaturalMonotonicCubicSpline *ptr);

// safe versions which copy their arguments
template <class I>
class SafeInterpolation2D {
  public:
    SafeInterpolation2D(const Array& x, const Array& y, const Matrix& m)
    : x_(x), y_(y), m_(m), f_(x_.begin(),x_.end(),y_.begin(),y_.end(),m_) {}
    Real operator()(Real x, Real y, bool allowExtrapolation=false) {
        return f_(x,y, allowExtrapolation);
    }
  protected:
    Array x_, y_;
    Matrix m_;
    I f_;
};


typedef SafeInterpolation2D<QuantLib::BilinearInterpolation> SafeBilinearInterpolation;

static Scheme_Object *_swig_struct_type__SafeBilinearInterpolation;
static const char *_swig_struct__SafeBilinearInterpolation_field_names[] = { 
};
#define  _swig_struct__SafeBilinearInterpolation_field_names_cnt (sizeof(_swig_struct__SafeBilinearInterpolation_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SafeBilinearInterpolation(SafeBilinearInterpolation *ptr);

typedef SafeInterpolation2D<QuantLib::BicubicSpline> SafeBicubicSpline;

static Scheme_Object *_swig_struct_type__SafeBicubicSpline;
static const char *_swig_struct__SafeBicubicSpline_field_names[] = { 
};
#define  _swig_struct__SafeBicubicSpline_field_names_cnt (sizeof(_swig_struct__SafeBicubicSpline_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SafeBicubicSpline(SafeBicubicSpline *ptr);

using QuantLib::YieldTermStructure;

static bool boost_shared_ptr_Sl_YieldTermStructure_Sg__isNull(boost::shared_ptr<YieldTermStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > *boost_shared_ptr_Sl_YieldTermStructure_Sg__asObservable(boost::shared_ptr<YieldTermStructure > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTYieldTermStructure_t;
static const char *_swig_struct__boost__shared_ptrTYieldTermStructure_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTYieldTermStructure_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTYieldTermStructure_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTYieldTermStructure_t(boost::shared_ptr<YieldTermStructure > *ptr);
static boost::shared_ptr<Observable > *Handle_Sl_YieldTermStructure_Sg__asObservable(Handle<YieldTermStructure > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__HandleTYieldTermStructure_t;
static const char *_swig_struct__HandleTYieldTermStructure_t_field_names[] = { 
};
#define  _swig_struct__HandleTYieldTermStructure_t_field_names_cnt (sizeof(_swig_struct__HandleTYieldTermStructure_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__HandleTYieldTermStructure_t(Handle<YieldTermStructure > *ptr);

using QuantLib::ImpliedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ImpliedTermStructurePtr;

static ImpliedTermStructurePtr *new_ImpliedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Date const &referenceDate){
            return new ImpliedTermStructurePtr(
                new ImpliedTermStructure(curveHandle, referenceDate));
        }
static Scheme_Object *_swig_struct_type__ImpliedTermStructurePtr;
static const char *_swig_struct__ImpliedTermStructurePtr_field_names[] = { 
};
#define  _swig_struct__ImpliedTermStructurePtr_field_names_cnt (sizeof(_swig_struct__ImpliedTermStructurePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__ImpliedTermStructurePtr(ImpliedTermStructurePtr *ptr);

using QuantLib::ZeroSpreadedTermStructure;
using QuantLib::ForwardSpreadedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ZeroSpreadedTermStructurePtr;
typedef boost::shared_ptr<YieldTermStructure> ForwardSpreadedTermStructurePtr;

static ZeroSpreadedTermStructurePtr *new_ZeroSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
	        return new ZeroSpreadedTermStructurePtr(
	            new ZeroSpreadedTermStructure(curveHandle,spreadHandle));
        }
static Scheme_Object *_swig_struct_type__ZeroSpreadedTermStructurePtr;
static const char *_swig_struct__ZeroSpreadedTermStructurePtr_field_names[] = { 
};
#define  _swig_struct__ZeroSpreadedTermStructurePtr_field_names_cnt (sizeof(_swig_struct__ZeroSpreadedTermStructurePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__ZeroSpreadedTermStructurePtr(ZeroSpreadedTermStructurePtr *ptr);
static ForwardSpreadedTermStructurePtr *new_ForwardSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
	        return new ForwardSpreadedTermStructurePtr(
	            new ForwardSpreadedTermStructure(curveHandle,spreadHandle));
        }
static Scheme_Object *_swig_struct_type__ForwardSpreadedTermStructurePtr;
static const char *_swig_struct__ForwardSpreadedTermStructurePtr_field_names[] = { 
};
#define  _swig_struct__ForwardSpreadedTermStructurePtr_field_names_cnt (sizeof(_swig_struct__ForwardSpreadedTermStructurePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__ForwardSpreadedTermStructurePtr(ForwardSpreadedTermStructurePtr *ptr);

using QuantLib::FlatForward;
typedef boost::shared_ptr<YieldTermStructure> FlatForwardPtr;

static FlatForwardPtr *new_FlatForwardPtr__SWIG_0(Date const &referenceDate,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
static FlatForwardPtr *new_FlatForwardPtr__SWIG_3(Date const &referenceDate,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
static FlatForwardPtr *new_FlatForwardPtr__SWIG_6(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }
static FlatForwardPtr *new_FlatForwardPtr__SWIG_9(Integer settlementDays,Calendar const &calendar,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }
static Scheme_Object *_swig_struct_type__FlatForwardPtr;
static const char *_swig_struct__FlatForwardPtr_field_names[] = { 
};
#define  _swig_struct__FlatForwardPtr_field_names_cnt (sizeof(_swig_struct__FlatForwardPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FlatForwardPtr(FlatForwardPtr *ptr);

using QuantLib::BlackModel;

static bool boost_shared_ptr_Sl_BlackModel_Sg__isNull(boost::shared_ptr<BlackModel > *self){
                return !(*self);
            }
static boost::shared_ptr<BlackModel > *new_boost_shared_ptr_Sl_BlackModel_Sg_(Handle<Quote > const &volatility,Handle<YieldTermStructure > const &termStructure){
        return new boost::shared_ptr<BlackModel>(
            new BlackModel(volatility,termStructure));
    }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTBlackModel_t;
static const char *_swig_struct__boost__shared_ptrTBlackModel_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTBlackModel_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTBlackModel_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTBlackModel_t(boost::shared_ptr<BlackModel > *ptr);

using QuantLib::PricingEngine;

static bool boost_shared_ptr_Sl_PricingEngine_Sg__isNull(boost::shared_ptr<PricingEngine > *self){
                return !(*self);
            }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTPricingEngine_t;
static const char *_swig_struct__boost__shared_ptrTPricingEngine_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTPricingEngine_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTPricingEngine_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTPricingEngine_t(boost::shared_ptr<PricingEngine > *ptr);

using QuantLib::Instrument;

static bool boost_shared_ptr_Sl_Instrument_Sg__isNull(boost::shared_ptr<Instrument > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > *boost_shared_ptr_Sl_Instrument_Sg__asObservable(boost::shared_ptr<Instrument > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTInstrument_t;
static const char *_swig_struct__boost__shared_ptrTInstrument_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTInstrument_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTInstrument_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTInstrument_t(boost::shared_ptr<Instrument > *ptr);

using QuantLib::Stock;
typedef boost::shared_ptr<Instrument> StockPtr;

static StockPtr *new_StockPtr(Handle<Quote > const &quote){
            return new StockPtr(new Stock(quote));
        }
static Scheme_Object *_swig_struct_type__StockPtr;
static const char *_swig_struct__StockPtr_field_names[] = { 
};
#define  _swig_struct__StockPtr_field_names_cnt (sizeof(_swig_struct__StockPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__StockPtr(StockPtr *ptr);
static int std_vector_Sl_int_Sg__pop(std::vector<int > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                int x = self->back();
                self->pop_back();
                return x;
            }
static int std_vector_Sl_int_Sg__ref(std::vector<int > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_int_Sg__set(std::vector<int > *self,int i,int x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static Scheme_Object *_swig_struct_type__std__vectorTint_t;
static const char *_swig_struct__std__vectorTint_t_field_names[] = { 
};
#define  _swig_struct__std__vectorTint_t_field_names_cnt (sizeof(_swig_struct__std__vectorTint_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__std__vectorTint_t(std::vector<int > *ptr);
static double std_vector_Sl_double_Sg__pop(std::vector<double > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                double x = self->back();
                self->pop_back();
                return x;
            }
static double std_vector_Sl_double_Sg__ref(std::vector<double > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_double_Sg__set(std::vector<double > *self,int i,double x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static Scheme_Object *_swig_struct_type__std__vectorTdouble_t;
static const char *_swig_struct__std__vectorTdouble_t_field_names[] = { 
};
#define  _swig_struct__std__vectorTdouble_t_field_names_cnt (sizeof(_swig_struct__std__vectorTdouble_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__std__vectorTdouble_t(std::vector<double > *ptr);
static std::string std_vector_Sl_std_string_Sg__pop(std::vector<std::string > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                std::string x = self->back();
                self->pop_back();
                return x;
            }
static std::string std_vector_Sl_std_string_Sg__ref(std::vector<std::string > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_std_string_Sg__set(std::vector<std::string > *self,int i,std::string x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static Scheme_Object *_swig_struct_type__std__vectorTstd__string_t;
static const char *_swig_struct__std__vectorTstd__string_t_field_names[] = { 
};
#define  _swig_struct__std__vectorTstd__string_t_field_names_cnt (sizeof(_swig_struct__std__vectorTstd__string_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__std__vectorTstd__string_t(std::vector<std::string > *ptr);

using QuantLib::History;
typedef History::Entry HistoryEntry;

static Scheme_Object *_swig_struct_type__HistoryEntry;
static const char *_swig_struct__HistoryEntry_field_names[] = { 
};
#define  _swig_struct__HistoryEntry_field_names_cnt (sizeof(_swig_struct__HistoryEntry_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__HistoryEntry(HistoryEntry *ptr);
static Size History___len__(History *self){
            return self->size();
        }
static HistoryEntry History_assoc(History *self,Date const &d){
            if (d < self->firstDate() || d > self->lastDate())
                return History::Entry();
            else
                return *(self->begin()+(d-self->firstDate()));
        }
static void History_for_each(History *self,Scheme_Object *proc){
            History::const_iterator i=self->begin(), end=self->end();
            for ( ; i!=end; ++i) {
                Real v = i->value();
                Scheme_Object* entry;
                if (v == Null<Real>()) {
                    entry = scheme_false;
                } else {
                    Date* d = new Date(i->date());
                    Scheme_Object* car =
                        SWIG_NewPointerObj(d, SWIGTYPE_p_Date, 1);
                    Scheme_Object* cdr = scheme_make_double(v);
                    entry = scheme_make_pair(car,cdr);
                }
                scheme_apply(proc,1,&entry);
            }
        }
static void History_for_each_valid(History *self,Scheme_Object *proc){
            History::const_valid_iterator i=self->vbegin(), end=self->vend();
            for ( ; i!=end; ++i) {
                Real v = i->value();
                Date* d = new Date(i->date());
                Scheme_Object* car =
                    SWIG_NewPointerObj(d, SWIGTYPE_p_Date, 1);
                Scheme_Object* cdr = scheme_make_double(v);
                Scheme_Object* cons = scheme_make_pair(car,cdr);
                scheme_apply(proc,1,&cons);
            }
        }
static Scheme_Object *_swig_struct_type__History;
static const char *_swig_struct__History_field_names[] = { 
};
#define  _swig_struct__History_field_names_cnt (sizeof(_swig_struct__History_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__History(History *ptr);

using QuantLib::IndexManager;

static Scheme_Object *_swig_struct_type__IndexManager;
static const char *_swig_struct__IndexManager_field_names[] = { 
};
#define  _swig_struct__IndexManager_field_names_cnt (sizeof(_swig_struct__IndexManager_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__IndexManager(IndexManager *ptr);

using QuantLib::Index;

static bool boost_shared_ptr_Sl_Index_Sg__isNull(boost::shared_ptr<Index > *self){
                return !(*self);
            }
static std::string boost_shared_ptr_Sl_Index_Sg____str__(boost::shared_ptr<Index > *self){
        if (*self)
            return (*self)->name()+" index";
        else
            return "Null index";
    }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTIndex_t;
static const char *_swig_struct__boost__shared_ptrTIndex_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTIndex_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTIndex_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTIndex_t(boost::shared_ptr<Index > *ptr);

using QuantLib::Xibor;
typedef boost::shared_ptr<Index> XiborPtr;

static XiborPtr *new_XiborPtr(std::string const &familyName,Integer n,TimeUnit units,Integer settlementDays,Currency const &currency,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Handle<YieldTermStructure > const &h){
            return new XiborPtr(new Xibor(familyName, n, units, settlementDays,
                                          currency, calendar, convention,
                                          dayCounter, h));
        }
static Period XiborPtr_tenor(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->tenor();
        }
static Frequency XiborPtr_frequency(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->frequency();
        }
static Currency XiborPtr_currency(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->currency();
        }
static Calendar XiborPtr_calendar(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->calendar();
        }
static bool XiborPtr_isAdjusted(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->isAdjusted();
        }
static BusinessDayConvention XiborPtr_businessDayConvention(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)
                 ->businessDayConvention();
        }
static DayCounter XiborPtr_dayCounter(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->dayCounter();
        }
static Scheme_Object *_swig_struct_type__XiborPtr;
static const char *_swig_struct__XiborPtr_field_names[] = { 
};
#define  _swig_struct__XiborPtr_field_names_cnt (sizeof(_swig_struct__XiborPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__XiborPtr(XiborPtr *ptr);

using QuantLib::AUDLibor;
typedef boost::shared_ptr<Index> AUDLiborPtr;

static AUDLiborPtr *new_AUDLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new AUDLiborPtr(new AUDLibor(n,units,h,dayCount));
      }
static Scheme_Object *_swig_struct_type__AUDLiborPtr;
static const char *_swig_struct__AUDLiborPtr_field_names[] = { 
};
#define  _swig_struct__AUDLiborPtr_field_names_cnt (sizeof(_swig_struct__AUDLiborPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__AUDLiborPtr(AUDLiborPtr *ptr);

using QuantLib::CADLibor;
typedef boost::shared_ptr<Index> CADLiborPtr;

static CADLiborPtr *new_CADLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new CADLiborPtr(new CADLibor(n,units,h,dayCount));
      }
static Scheme_Object *_swig_struct_type__CADLiborPtr;
static const char *_swig_struct__CADLiborPtr_field_names[] = { 
};
#define  _swig_struct__CADLiborPtr_field_names_cnt (sizeof(_swig_struct__CADLiborPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CADLiborPtr(CADLiborPtr *ptr);

using QuantLib::Cdor;
typedef boost::shared_ptr<Index> CdorPtr;

static CdorPtr *new_CdorPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new CdorPtr(new Cdor(n,units,h,dayCount));
      }
static Scheme_Object *_swig_struct_type__CdorPtr;
static const char *_swig_struct__CdorPtr_field_names[] = { 
};
#define  _swig_struct__CdorPtr_field_names_cnt (sizeof(_swig_struct__CdorPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CdorPtr(CdorPtr *ptr);

using QuantLib::CHFLibor;
typedef boost::shared_ptr<Index> CHFLiborPtr;

static CHFLiborPtr *new_CHFLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new CHFLiborPtr(new CHFLibor(n,units,h,dayCount));
      }
static Scheme_Object *_swig_struct_type__CHFLiborPtr;
static const char *_swig_struct__CHFLiborPtr_field_names[] = { 
};
#define  _swig_struct__CHFLiborPtr_field_names_cnt (sizeof(_swig_struct__CHFLiborPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CHFLiborPtr(CHFLiborPtr *ptr);

using QuantLib::Euribor;
typedef boost::shared_ptr<Index> EuriborPtr;

static EuriborPtr *new_EuriborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new EuriborPtr(new Euribor(n,units,h,dayCount));
      }
static Scheme_Object *_swig_struct_type__EuriborPtr;
static const char *_swig_struct__EuriborPtr_field_names[] = { 
};
#define  _swig_struct__EuriborPtr_field_names_cnt (sizeof(_swig_struct__EuriborPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__EuriborPtr(EuriborPtr *ptr);

using QuantLib::GBPLibor;
typedef boost::shared_ptr<Index> GBPLiborPtr;

static GBPLiborPtr *new_GBPLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual365Fixed()){
          return new GBPLiborPtr(new GBPLibor(n,units,h,dayCount));
      }
static Scheme_Object *_swig_struct_type__GBPLiborPtr;
static const char *_swig_struct__GBPLiborPtr_field_names[] = { 
};
#define  _swig_struct__GBPLiborPtr_field_names_cnt (sizeof(_swig_struct__GBPLiborPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__GBPLiborPtr(GBPLiborPtr *ptr);

using QuantLib::Jibar;
typedef boost::shared_ptr<Index> JibarPtr;

static JibarPtr *new_JibarPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual365Fixed()){
          return new JibarPtr(new Jibar(n,units,h,dayCount));
      }
static Scheme_Object *_swig_struct_type__JibarPtr;
static const char *_swig_struct__JibarPtr_field_names[] = { 
};
#define  _swig_struct__JibarPtr_field_names_cnt (sizeof(_swig_struct__JibarPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__JibarPtr(JibarPtr *ptr);

using QuantLib::JPYLibor;
typedef boost::shared_ptr<Index> JPYLiborPtr;

static JPYLiborPtr *new_JPYLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new JPYLiborPtr(new JPYLibor(n,units,h,dayCount));
      }
static Scheme_Object *_swig_struct_type__JPYLiborPtr;
static const char *_swig_struct__JPYLiborPtr_field_names[] = { 
};
#define  _swig_struct__JPYLiborPtr_field_names_cnt (sizeof(_swig_struct__JPYLiborPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__JPYLiborPtr(JPYLiborPtr *ptr);

using QuantLib::Tibor;
typedef boost::shared_ptr<Index> TiborPtr;

static TiborPtr *new_TiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual365Fixed()){
          return new TiborPtr(new Tibor(n,units,h,dayCount));
      }
static Scheme_Object *_swig_struct_type__TiborPtr;
static const char *_swig_struct__TiborPtr_field_names[] = { 
};
#define  _swig_struct__TiborPtr_field_names_cnt (sizeof(_swig_struct__TiborPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__TiborPtr(TiborPtr *ptr);

using QuantLib::TRLibor;
typedef boost::shared_ptr<Index> TRLiborPtr;

static TRLiborPtr *new_TRLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new TRLiborPtr(new TRLibor(n,units,h,dayCount));
      }
static Scheme_Object *_swig_struct_type__TRLiborPtr;
static const char *_swig_struct__TRLiborPtr_field_names[] = { 
};
#define  _swig_struct__TRLiborPtr_field_names_cnt (sizeof(_swig_struct__TRLiborPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__TRLiborPtr(TRLiborPtr *ptr);

using QuantLib::USDLibor;
typedef boost::shared_ptr<Index> USDLiborPtr;

static USDLiborPtr *new_USDLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new USDLiborPtr(new USDLibor(n,units,h,dayCount));
      }
static Scheme_Object *_swig_struct_type__USDLiborPtr;
static const char *_swig_struct__USDLiborPtr_field_names[] = { 
};
#define  _swig_struct__USDLiborPtr_field_names_cnt (sizeof(_swig_struct__USDLiborPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__USDLiborPtr(USDLiborPtr *ptr);

using QuantLib::Zibor;
typedef boost::shared_ptr<Index> ZiborPtr;

static ZiborPtr *new_ZiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new ZiborPtr(new Zibor(n,units,h,dayCount));
      }
static Scheme_Object *_swig_struct_type__ZiborPtr;
static const char *_swig_struct__ZiborPtr_field_names[] = { 
};
#define  _swig_struct__ZiborPtr_field_names_cnt (sizeof(_swig_struct__ZiborPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__ZiborPtr(ZiborPtr *ptr);

using QuantLib::Schedule;

static void Schedule_for_each(Schedule *self,Scheme_Object *proc){
            for (Size i=0; i<self->size(); i++) {
                Date* d = new Date(self->date(i));
                Scheme_Object* x =
                    SWIG_NewPointerObj(d, SWIGTYPE_p_Date, 1);
                scheme_apply(proc,1,&x);
            }
        }
static Scheme_Object *_swig_struct_type__Schedule;
static const char *_swig_struct__Schedule_field_names[] = { 
};
#define  _swig_struct__Schedule_field_names_cnt (sizeof(_swig_struct__Schedule_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Schedule(Schedule *ptr);

using QuantLib::CashFlow;

static bool boost_shared_ptr_Sl_CashFlow_Sg__isNull(boost::shared_ptr<CashFlow > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > *boost_shared_ptr_Sl_CashFlow_Sg__asObservable(boost::shared_ptr<CashFlow > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTCashFlow_t;
static const char *_swig_struct__boost__shared_ptrTCashFlow_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTCashFlow_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTCashFlow_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTCashFlow_t(boost::shared_ptr<CashFlow > *ptr);

using QuantLib::SimpleCashFlow;
using QuantLib::FixedRateCoupon;
using QuantLib::ParCoupon;
typedef boost::shared_ptr<CashFlow> SimpleCashFlowPtr;
typedef boost::shared_ptr<CashFlow> FixedRateCouponPtr;
typedef boost::shared_ptr<CashFlow> ParCouponPtr;

static SimpleCashFlowPtr *new_SimpleCashFlowPtr(Real amount,Date const &date){
            return new SimpleCashFlowPtr(new SimpleCashFlow(amount,date));
        }
static Scheme_Object *_swig_struct_type__SimpleCashFlowPtr;
static const char *_swig_struct__SimpleCashFlowPtr_field_names[] = { 
};
#define  _swig_struct__SimpleCashFlowPtr_field_names_cnt (sizeof(_swig_struct__SimpleCashFlowPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SimpleCashFlowPtr(SimpleCashFlowPtr *ptr);
static FixedRateCouponPtr *new_FixedRateCouponPtr__SWIG_0(Real nominal,Date const &paymentDate,Rate rate,DayCounter const &dayCounter,Date const &startDate,Date const &endDate,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date()){
            return new FixedRateCouponPtr(
                new FixedRateCoupon(nominal, paymentDate, rate,
                                    dayCounter, startDate, endDate,
                                    refPeriodStart, refPeriodEnd));
        }
static Scheme_Object *_swig_struct_type__FixedRateCouponPtr;
static const char *_swig_struct__FixedRateCouponPtr_field_names[] = { 
};
#define  _swig_struct__FixedRateCouponPtr_field_names_cnt (sizeof(_swig_struct__FixedRateCouponPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FixedRateCouponPtr(FixedRateCouponPtr *ptr);
static ParCouponPtr *new_ParCouponPtr__SWIG_0(Real nominal,Date const &paymentDate,XiborPtr const &index,Date const &startDate,Date const &endDate,Integer fixingDays,Spread spread=0.0,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date()){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new ParCouponPtr(
                new ParCoupon(nominal, paymentDate, libor,
                              startDate, endDate, fixingDays, spread,
                              refPeriodStart, refPeriodEnd));
        }
static Date ParCouponPtr_accrualStartDate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                 ->accrualStartDate();
        }
static Date ParCouponPtr_accrualEndDate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                 ->accrualEndDate();
        }
static Rate ParCouponPtr_rate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)->rate();
        }
static Rate ParCouponPtr_indexFixing(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                ->indexFixing();
        }
static Real ParCouponPtr_nominal(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)->nominal();
        }
static Scheme_Object *_swig_struct_type__ParCouponPtr;
static const char *_swig_struct__ParCouponPtr_field_names[] = { 
};
#define  _swig_struct__ParCouponPtr_field_names_cnt (sizeof(_swig_struct__ParCouponPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__ParCouponPtr(ParCouponPtr *ptr);
static boost::shared_ptr<CashFlow > std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__pop(std::vector<boost::shared_ptr<CashFlow > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                boost::shared_ptr<CashFlow > x = self->back();
                self->pop_back();
                return x;
            }
static boost::shared_ptr<CashFlow > &std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__ref(std::vector<boost::shared_ptr<CashFlow > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__set(std::vector<boost::shared_ptr<CashFlow > > *self,int i,boost::shared_ptr<CashFlow > const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static Scheme_Object *_swig_struct_type__std__vectorTboost__shared_ptrTCashFlow_t_t;
static const char *_swig_struct__std__vectorTboost__shared_ptrTCashFlow_t_t_field_names[] = { 
};
#define  _swig_struct__std__vectorTboost__shared_ptrTCashFlow_t_t_field_names_cnt (sizeof(_swig_struct__std__vectorTboost__shared_ptrTCashFlow_t_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__std__vectorTboost__shared_ptrTCashFlow_t_t(std::vector<boost::shared_ptr<CashFlow > > *ptr);

using QuantLib::FixedRateCouponVector;


std::vector<boost::shared_ptr<CashFlow> >
FloatingRateCouponVector(const Schedule& schedule,
                         BusinessDayConvention paymentAdjustment,
                         const std::vector<Real>& nominals,
                         const XiborPtr& index, Integer fixingDays,
                         const std::vector<Spread>& spreads =
                             std::vector<Spread>()) {
    boost::shared_ptr<Xibor> libor =
        boost::dynamic_pointer_cast<Xibor>(index);
    return QuantLib::FloatingRateCouponVector(schedule,paymentAdjustment,
                                              nominals,libor,
                                              fixingDays,spreads);
}


using QuantLib::Cashflows;
using QuantLib::Duration;

static int _wrap_const_Duration_Simple = Duration::Simple;
static int _wrap_const_Duration_Macaulay = Duration::Macaulay;
static int _wrap_const_Duration_Modified = Duration::Modified;
static Scheme_Object *_swig_struct_type__Duration;
static const char *_swig_struct__Duration_field_names[] = { 
};
#define  _swig_struct__Duration_field_names_cnt (sizeof(_swig_struct__Duration_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Duration(Duration *ptr);
static Scheme_Object *_swig_struct_type__Cashflows;
static const char *_swig_struct__Cashflows_field_names[] = { 
};
#define  _swig_struct__Cashflows_field_names_cnt (sizeof(_swig_struct__Cashflows_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Cashflows(Cashflows *ptr);

using QuantLib::Bond;
using QuantLib::ZeroCouponBond;
using QuantLib::FixedCouponBond;
using QuantLib::FloatingRateBond;
typedef boost::shared_ptr<Instrument> BondPtr;
typedef boost::shared_ptr<Instrument> ZeroCouponBondPtr;
typedef boost::shared_ptr<Instrument> FixedCouponBondPtr;
typedef boost::shared_ptr<Instrument> FloatingRateBondPtr;

static Date BondPtr_settlementDate(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->settlementDate();
        }
static std::vector<boost::shared_ptr<CashFlow > > BondPtr_cashflows(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cashflows();
        }
static boost::shared_ptr<CashFlow > BondPtr_redemption(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->redemption();
        }
static Calendar BondPtr_calendar(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->calendar();
        }
static BusinessDayConvention BondPtr_businessDayConvention(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->businessDayConvention();
        }
static DayCounter BondPtr_dayCounter(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->dayCounter();
        }
static Frequency BondPtr_frequency(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->frequency();
        }
static Real BondPtr_cleanPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cleanPrice();
        }
static Real BondPtr_cleanPrice__SWIG_1(BondPtr *self,Rate yield,Compounding compounding,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->cleanPrice(yield,compounding,settlement);
        }
static Real BondPtr_dirtyPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->dirtyPrice();
        }
static Real BondPtr_dirtyPrice__SWIG_1(BondPtr *self,Rate yield,Compounding compounding,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->dirtyPrice(yield,compounding,settlement);
        }
static Real BondPtr_yield__SWIG_0(BondPtr *self,Compounding compounding,Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(compounding,accuracy,maxEvaluations);
        }
static Real BondPtr_yield__SWIG_3(BondPtr *self,Real cleanPrice,Compounding compounding,Date const &settlement=Date(),Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(cleanPrice,compounding,settlement,
                        accuracy,maxEvaluations);
        }
static Real BondPtr_accruedAmount__SWIG_0(BondPtr *self,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->accruedAmount(settlement);
        }
static Scheme_Object *_swig_struct_type__BondPtr;
static const char *_swig_struct__BondPtr_field_names[] = { 
};
#define  _swig_struct__BondPtr_field_names_cnt (sizeof(_swig_struct__BondPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BondPtr(BondPtr *ptr);
static ZeroCouponBondPtr *new_ZeroCouponBondPtr__SWIG_0(Date const &issueDate,Date const &maturityDate,Integer settlementDays,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention convention=QuantLib::Following,Real redemption=100.0,Handle<YieldTermStructure > const &discountCurve=Handle<YieldTermStructure >()){
            return new ZeroCouponBondPtr(
                new ZeroCouponBond(issueDate, maturityDate, settlementDays,
                                   dayCounter, calendar, convention,
                                   redemption, discountCurve));
        }
static Scheme_Object *_swig_struct_type__ZeroCouponBondPtr;
static const char *_swig_struct__ZeroCouponBondPtr_field_names[] = { 
};
#define  _swig_struct__ZeroCouponBondPtr_field_names_cnt (sizeof(_swig_struct__ZeroCouponBondPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__ZeroCouponBondPtr(ZeroCouponBondPtr *ptr);
static FixedCouponBondPtr *new_FixedCouponBondPtr__SWIG_0(Date const &issueDate,Date const &datedDate,Date const &maturityDate,Integer settlementDays,std::vector<Rate > const &coupons,Frequency couponFrequency,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention convention=QuantLib::Following,Real redemption=100.0,Handle<YieldTermStructure > const &discountCurve=Handle<YieldTermStructure >(),Date const &stub=Date(),bool fromEnd=true){
            return new FixedCouponBondPtr(
                new FixedCouponBond(issueDate, datedDate, maturityDate,
                                    settlementDays, coupons, couponFrequency,
                                    dayCounter, calendar, convention,
                                    redemption, discountCurve, stub, fromEnd));
        }
static Scheme_Object *_swig_struct_type__FixedCouponBondPtr;
static const char *_swig_struct__FixedCouponBondPtr_field_names[] = { 
};
#define  _swig_struct__FixedCouponBondPtr_field_names_cnt (sizeof(_swig_struct__FixedCouponBondPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FixedCouponBondPtr(FixedCouponBondPtr *ptr);
static FloatingRateBondPtr *new_FloatingRateBondPtr__SWIG_0(Date const &issueDate,Date const &datedDate,Date const &maturityDate,Integer settlementDays,XiborPtr const &index,Integer fixingDays,std::vector<Spread > const &spreads,Frequency couponFrequency,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention convention=QuantLib::Following,Real redemption=100.0,Handle<YieldTermStructure > const &discountCurve=Handle<YieldTermStructure >(),Date const &stub=Date(),bool fromEnd=true){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new FloatingRateBondPtr(
                new FloatingRateBond(issueDate, datedDate, maturityDate,
                                     settlementDays, libor, fixingDays,
                                     spreads, couponFrequency,
                                     dayCounter, calendar, convention,
                                     redemption, discountCurve,
                                     stub, fromEnd));
        }
static Scheme_Object *_swig_struct_type__FloatingRateBondPtr;
static const char *_swig_struct__FloatingRateBondPtr_field_names[] = { 
};
#define  _swig_struct__FloatingRateBondPtr_field_names_cnt (sizeof(_swig_struct__FloatingRateBondPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FloatingRateBondPtr(FloatingRateBondPtr *ptr);

using QuantLib::Exercise;
typedef Exercise::Type ExerciseType;

Exercise::Type exerciseTypeFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "e" || s == "european")
        return Exercise::European;
    else if (s == "a" || s == "american")
        return Exercise::American;
    else if (s == "b" || s == "bermudan")
        return Exercise::Bermudan;
    else
        QL_FAIL("unknown exercise type: "+s);
}

std::string exerciseTypeToString(Exercise::Type t) {
    switch (t) {
      case Exercise::European:
        return "European";
      case Exercise::American:
        return "American";
      case Exercise::Bermudan:
        return "Bermudan";
      default:
        QL_FAIL("unknown exercise type");
    }
}

static bool boost_shared_ptr_Sl_Exercise_Sg__isNull(boost::shared_ptr<Exercise > *self){
                return !(*self);
            }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTExercise_t;
static const char *_swig_struct__boost__shared_ptrTExercise_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTExercise_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTExercise_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTExercise_t(boost::shared_ptr<Exercise > *ptr);

using QuantLib::EuropeanExercise;
using QuantLib::AmericanExercise;
using QuantLib::BermudanExercise;
typedef boost::shared_ptr<Exercise> EuropeanExercisePtr;
typedef boost::shared_ptr<Exercise> AmericanExercisePtr;
typedef boost::shared_ptr<Exercise> BermudanExercisePtr;

static EuropeanExercisePtr *new_EuropeanExercisePtr(Date const &date){
            return new EuropeanExercisePtr(new EuropeanExercise(date));
        }
static Scheme_Object *_swig_struct_type__EuropeanExercisePtr;
static const char *_swig_struct__EuropeanExercisePtr_field_names[] = { 
};
#define  _swig_struct__EuropeanExercisePtr_field_names_cnt (sizeof(_swig_struct__EuropeanExercisePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__EuropeanExercisePtr(EuropeanExercisePtr *ptr);
static AmericanExercisePtr *new_AmericanExercisePtr__SWIG_0(Date const &earliestDate,Date const &latestDate,bool payoffAtExpiry=false){
            return new AmericanExercisePtr(
                                        new AmericanExercise(earliestDate,
                                                             latestDate,
                                                             payoffAtExpiry));
        }
static Scheme_Object *_swig_struct_type__AmericanExercisePtr;
static const char *_swig_struct__AmericanExercisePtr_field_names[] = { 
};
#define  _swig_struct__AmericanExercisePtr_field_names_cnt (sizeof(_swig_struct__AmericanExercisePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__AmericanExercisePtr(AmericanExercisePtr *ptr);
static BermudanExercisePtr *new_BermudanExercisePtr__SWIG_0(std::vector<Date > const &dates,bool payoffAtExpiry=false){
            return new BermudanExercisePtr(
                                        new BermudanExercise(dates,
                                                             payoffAtExpiry));
        }
static Scheme_Object *_swig_struct_type__BermudanExercisePtr;
static const char *_swig_struct__BermudanExercisePtr_field_names[] = { 
};
#define  _swig_struct__BermudanExercisePtr_field_names_cnt (sizeof(_swig_struct__BermudanExercisePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BermudanExercisePtr(BermudanExercisePtr *ptr);

using QuantLib::BlackVolTermStructure;
using QuantLib::LocalVolTermStructure;

static bool boost_shared_ptr_Sl_BlackVolTermStructure_Sg__isNull(boost::shared_ptr<BlackVolTermStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > *boost_shared_ptr_Sl_BlackVolTermStructure_Sg__asObservable(boost::shared_ptr<BlackVolTermStructure > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTBlackVolTermStructure_t;
static const char *_swig_struct__boost__shared_ptrTBlackVolTermStructure_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTBlackVolTermStructure_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTBlackVolTermStructure_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTBlackVolTermStructure_t(boost::shared_ptr<BlackVolTermStructure > *ptr);
static boost::shared_ptr<Observable > *Handle_Sl_BlackVolTermStructure_Sg__asObservable(Handle<BlackVolTermStructure > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__HandleTBlackVolTermStructure_t;
static const char *_swig_struct__HandleTBlackVolTermStructure_t_field_names[] = { 
};
#define  _swig_struct__HandleTBlackVolTermStructure_t_field_names_cnt (sizeof(_swig_struct__HandleTBlackVolTermStructure_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__HandleTBlackVolTermStructure_t(Handle<BlackVolTermStructure > *ptr);
static bool boost_shared_ptr_Sl_LocalVolTermStructure_Sg__isNull(boost::shared_ptr<LocalVolTermStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > *boost_shared_ptr_Sl_LocalVolTermStructure_Sg__asObservable(boost::shared_ptr<LocalVolTermStructure > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTLocalVolTermStructure_t;
static const char *_swig_struct__boost__shared_ptrTLocalVolTermStructure_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTLocalVolTermStructure_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTLocalVolTermStructure_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTLocalVolTermStructure_t(boost::shared_ptr<LocalVolTermStructure > *ptr);
static boost::shared_ptr<Observable > *Handle_Sl_LocalVolTermStructure_Sg__asObservable(Handle<LocalVolTermStructure > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__HandleTLocalVolTermStructure_t;
static const char *_swig_struct__HandleTLocalVolTermStructure_t_field_names[] = { 
};
#define  _swig_struct__HandleTLocalVolTermStructure_t_field_names_cnt (sizeof(_swig_struct__HandleTLocalVolTermStructure_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__HandleTLocalVolTermStructure_t(Handle<LocalVolTermStructure > *ptr);

using QuantLib::BlackConstantVol;
typedef boost::shared_ptr<BlackVolTermStructure> BlackConstantVolPtr;

static BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, volatility, dayCounter));
        }
static BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, volatility, dayCounter));
        }
static BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
static BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
static Scheme_Object *_swig_struct_type__BlackConstantVolPtr;
static const char *_swig_struct__BlackConstantVolPtr_field_names[] = { 
};
#define  _swig_struct__BlackConstantVolPtr_field_names_cnt (sizeof(_swig_struct__BlackConstantVolPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BlackConstantVolPtr(BlackConstantVolPtr *ptr);

using QuantLib::BlackVarianceSurface;
typedef BlackVarianceSurface::Extrapolation VolExtrapolationType;
typedef boost::shared_ptr<BlackVolTermStructure> BlackVarianceSurfacePtr;

VolExtrapolationType volExTypeFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "const" || s == "constant")
        return BlackVarianceSurface::ConstantExtrapolation;
    else if (s == "" || s == "default")
        return BlackVarianceSurface::InterpolatorDefaultExtrapolation;
    else
        QL_FAIL("unknown extrapolation type: "+s);
}

std::string volExTypeToString(VolExtrapolationType t) {
    switch (t) {
      case BlackVarianceSurface::ConstantExtrapolation:
        return "constant";
      case BlackVarianceSurface::InterpolatorDefaultExtrapolation:
        return "default";
      default:
        QL_FAIL("unknown extrapolation type");
    }
}

static BlackVarianceSurfacePtr *new_BlackVarianceSurfacePtr__SWIG_0(Date const &referenceDate,std::vector<Date > const &dates,std::vector<Real > const &strikes,Matrix const &blackVols,DayCounter const &dayCounter,VolExtrapolationType lower=BlackVarianceSurface::InterpolatorDefaultExtrapolation,VolExtrapolationType upper=BlackVarianceSurface::InterpolatorDefaultExtrapolation){
            return new BlackVarianceSurfacePtr(
                new BlackVarianceSurface(referenceDate,dates,strikes,
                                         blackVols,dayCounter,lower,upper));
        }
static Scheme_Object *_swig_struct_type__BlackVarianceSurfacePtr;
static const char *_swig_struct__BlackVarianceSurfacePtr_field_names[] = { 
};
#define  _swig_struct__BlackVarianceSurfacePtr_field_names_cnt (sizeof(_swig_struct__BlackVarianceSurfacePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BlackVarianceSurfacePtr(BlackVarianceSurfacePtr *ptr);

using QuantLib::LocalConstantVol;
typedef boost::shared_ptr<LocalVolTermStructure> LocalConstantVolPtr;

static LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
static LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
static LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
static LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
static Scheme_Object *_swig_struct_type__LocalConstantVolPtr;
static const char *_swig_struct__LocalConstantVolPtr_field_names[] = { 
};
#define  _swig_struct__LocalConstantVolPtr_field_names_cnt (sizeof(_swig_struct__LocalConstantVolPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__LocalConstantVolPtr(LocalConstantVolPtr *ptr);

using QuantLib::GenericStochasticProcess;

static bool boost_shared_ptr_Sl_GenericStochasticProcess_Sg__isNull(boost::shared_ptr<GenericStochasticProcess > *self){
                return !(*self);
            }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTGenericStochasticProcess_t;
static const char *_swig_struct__boost__shared_ptrTGenericStochasticProcess_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTGenericStochasticProcess_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTGenericStochasticProcess_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTGenericStochasticProcess_t(boost::shared_ptr<GenericStochasticProcess > *ptr);

using QuantLib::StochasticProcess1D;
typedef boost::shared_ptr<GenericStochasticProcess> StochasticProcess1DPtr;

static Scheme_Object *_swig_struct_type__StochasticProcess1DPtr;
static const char *_swig_struct__StochasticProcess1DPtr_field_names[] = { 
};
#define  _swig_struct__StochasticProcess1DPtr_field_names_cnt (sizeof(_swig_struct__StochasticProcess1DPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__StochasticProcess1DPtr(StochasticProcess1DPtr *ptr);

using QuantLib::BlackScholesProcess;
typedef boost::shared_ptr<GenericStochasticProcess> BlackScholesProcessPtr;

static BlackScholesProcessPtr *new_BlackScholesProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new BlackScholesProcessPtr(
                              new BlackScholesProcess(s0, dividendTS,
                                                      riskFreeTS, volTS));
      }
static Scheme_Object *_swig_struct_type__BlackScholesProcessPtr;
static const char *_swig_struct__BlackScholesProcessPtr_field_names[] = { 
};
#define  _swig_struct__BlackScholesProcessPtr_field_names_cnt (sizeof(_swig_struct__BlackScholesProcessPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BlackScholesProcessPtr(BlackScholesProcessPtr *ptr);

using QuantLib::Merton76Process;
typedef boost::shared_ptr<GenericStochasticProcess> Merton76ProcessPtr;

static Merton76ProcessPtr *new_Merton76ProcessPtr(Handle<Quote > const &stateVariable,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS,Handle<Quote > const &jumpIntensity,Handle<Quote > const &meanLogJump,Handle<Quote > const &jumpVolatility){
            return new Merton76ProcessPtr(
                              new Merton76Process(stateVariable, dividendTS,
                                                  riskFreeTS, volTS,
                                                  jumpIntensity, meanLogJump,
                                                  jumpVolatility));
      }
static Scheme_Object *_swig_struct_type__Merton76ProcessPtr;
static const char *_swig_struct__Merton76ProcessPtr_field_names[] = { 
};
#define  _swig_struct__Merton76ProcessPtr_field_names_cnt (sizeof(_swig_struct__Merton76ProcessPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Merton76ProcessPtr(Merton76ProcessPtr *ptr);
static StochasticProcess1DPtr std_vector_Sl_StochasticProcess1DPtr_Sg__pop(std::vector<StochasticProcess1DPtr > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                StochasticProcess1DPtr x = self->back();
                self->pop_back();
                return x;
            }
static StochasticProcess1DPtr &std_vector_Sl_StochasticProcess1DPtr_Sg__ref(std::vector<StochasticProcess1DPtr > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_StochasticProcess1DPtr_Sg__set(std::vector<StochasticProcess1DPtr > *self,int i,StochasticProcess1DPtr const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static Scheme_Object *_swig_struct_type__std__vectorTStochasticProcess1DPtr_t;
static const char *_swig_struct__std__vectorTStochasticProcess1DPtr_t_field_names[] = { 
};
#define  _swig_struct__std__vectorTStochasticProcess1DPtr_t_field_names_cnt (sizeof(_swig_struct__std__vectorTStochasticProcess1DPtr_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__std__vectorTStochasticProcess1DPtr_t(std::vector<StochasticProcess1DPtr > *ptr);

using QuantLib::Option;
using QuantLib::Barrier;

static int _wrap_const_Option_Call = Option::Call;
static int _wrap_const_Option_Put = Option::Put;
static Scheme_Object *_swig_struct_type__Option;
static const char *_swig_struct__Option_field_names[] = { 
};
#define  _swig_struct__Option_field_names_cnt (sizeof(_swig_struct__Option_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Option(Option *ptr);
static int _wrap_const_Barrier_DownIn = Barrier::DownIn;
static int _wrap_const_Barrier_UpIn = Barrier::UpIn;
static int _wrap_const_Barrier_DownOut = Barrier::DownOut;
static int _wrap_const_Barrier_UpOut = Barrier::UpOut;
static Scheme_Object *_swig_struct_type__Barrier;
static const char *_swig_struct__Barrier_field_names[] = { 
};
#define  _swig_struct__Barrier_field_names_cnt (sizeof(_swig_struct__Barrier_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Barrier(Barrier *ptr);

using QuantLib::Payoff;
using QuantLib::StrikedTypePayoff;

static bool boost_shared_ptr_Sl_Payoff_Sg__isNull(boost::shared_ptr<Payoff > *self){
                return !(*self);
            }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTPayoff_t;
static const char *_swig_struct__boost__shared_ptrTPayoff_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTPayoff_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTPayoff_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTPayoff_t(boost::shared_ptr<Payoff > *ptr);

using QuantLib::VanillaOption;
typedef boost::shared_ptr<Instrument> VanillaOptionPtr;

static VanillaOptionPtr *new_VanillaOptionPtr__SWIG_0(boost::shared_ptr<GenericStochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new VanillaOptionPtr(
                         new VanillaOption(process,stPayoff,exercise,engine));
        }
static Real VanillaOptionPtr_delta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->delta();
        }
static Real VanillaOptionPtr_gamma(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->gamma();
        }
static Real VanillaOptionPtr_theta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->theta();
        }
static Real VanillaOptionPtr_vega(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->vega();
        }
static Real VanillaOptionPtr_rho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->rho();
        }
static Real VanillaOptionPtr_dividendRho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->dividendRho();
        }
static Real VanillaOptionPtr_strikeSensitivity(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->strikeSensitivity();
        }
static Volatility VanillaOptionPtr_impliedVolatility__SWIG_0(VanillaOptionPtr *self,Real targetValue,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }
static Scheme_Object *_swig_struct_type__VanillaOptionPtr;
static const char *_swig_struct__VanillaOptionPtr_field_names[] = { 
};
#define  _swig_struct__VanillaOptionPtr_field_names_cnt (sizeof(_swig_struct__VanillaOptionPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__VanillaOptionPtr(VanillaOptionPtr *ptr);

using QuantLib::EuropeanOption;
typedef boost::shared_ptr<Instrument> EuropeanOptionPtr;

static EuropeanOptionPtr *new_EuropeanOptionPtr__SWIG_0(boost::shared_ptr<GenericStochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new EuropeanOptionPtr(
                        new EuropeanOption(process,stPayoff,exercise,engine));
        }
static Scheme_Object *_swig_struct_type__EuropeanOptionPtr;
static const char *_swig_struct__EuropeanOptionPtr_field_names[] = { 
};
#define  _swig_struct__EuropeanOptionPtr_field_names_cnt (sizeof(_swig_struct__EuropeanOptionPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__EuropeanOptionPtr(EuropeanOptionPtr *ptr);

using QuantLib::AnalyticEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticEuropeanEnginePtr;

static AnalyticEuropeanEnginePtr *new_AnalyticEuropeanEnginePtr(){
            return new AnalyticEuropeanEnginePtr(new AnalyticEuropeanEngine);
        }
static Scheme_Object *_swig_struct_type__AnalyticEuropeanEnginePtr;
static const char *_swig_struct__AnalyticEuropeanEnginePtr_field_names[] = { 
};
#define  _swig_struct__AnalyticEuropeanEnginePtr_field_names_cnt (sizeof(_swig_struct__AnalyticEuropeanEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__AnalyticEuropeanEnginePtr(AnalyticEuropeanEnginePtr *ptr);

using QuantLib::IntegralEngine;
typedef boost::shared_ptr<PricingEngine> IntegralEnginePtr;

static IntegralEnginePtr *new_IntegralEnginePtr(){
            return new IntegralEnginePtr(new IntegralEngine);
        }
static Scheme_Object *_swig_struct_type__IntegralEnginePtr;
static const char *_swig_struct__IntegralEnginePtr_field_names[] = { 
};
#define  _swig_struct__IntegralEnginePtr_field_names_cnt (sizeof(_swig_struct__IntegralEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__IntegralEnginePtr(IntegralEnginePtr *ptr);

using QuantLib::FDEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> FDEuropeanEnginePtr;

static FDEuropeanEnginePtr *new_FDEuropeanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDEuropeanEnginePtr(
                    new FDEuropeanEngine(timeSteps,gridPoints,timeDependent));
        }
static Scheme_Object *_swig_struct_type__FDEuropeanEnginePtr;
static const char *_swig_struct__FDEuropeanEnginePtr_field_names[] = { 
};
#define  _swig_struct__FDEuropeanEnginePtr_field_names_cnt (sizeof(_swig_struct__FDEuropeanEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FDEuropeanEnginePtr(FDEuropeanEnginePtr *ptr);

using QuantLib::BinomialVanillaEngine;
using QuantLib::CoxRossRubinstein;
using QuantLib::JarrowRudd;
using QuantLib::AdditiveEQPBinomialTree;
using QuantLib::Trigeorgis;
using QuantLib::Tian;
using QuantLib::LeisenReimer;
typedef boost::shared_ptr<PricingEngine> BinomialVanillaEnginePtr;

static BinomialVanillaEnginePtr *new_BinomialVanillaEnginePtr(std::string const &type,Size steps){
            std::string s = QuantLib::lowercase(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<CoxRossRubinstein>(steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<JarrowRudd>(steps));
            else if (s == "eqp")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<AdditiveEQPBinomialTree>(steps));
            else if (s == "trigeorgis")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Trigeorgis>(steps));
            else if (s == "tian")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Tian>(steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<LeisenReimer>(steps));
            else
                QL_FAIL("unknown binomial engine type: "+s);
        }
static Scheme_Object *_swig_struct_type__BinomialVanillaEnginePtr;
static const char *_swig_struct__BinomialVanillaEnginePtr_field_names[] = { 
};
#define  _swig_struct__BinomialVanillaEnginePtr_field_names_cnt (sizeof(_swig_struct__BinomialVanillaEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BinomialVanillaEnginePtr(BinomialVanillaEnginePtr *ptr);

using QuantLib::MCEuropeanEngine;
using QuantLib::PseudoRandom;
using QuantLib::LowDiscrepancy;
typedef boost::shared_ptr<PricingEngine> MCEuropeanEnginePtr;

static MCEuropeanEnginePtr *new_MCEuropeanEnginePtr(std::string const &traits,intOrNull timeSteps=Null<Size >(),intOrNull timeStepsPerYear=Null<Size >(),bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null<Size >(),doubleOrNull requiredTolerance=Null<Real >(),intOrNull maxSamples=Null<Size >(),BigInteger seed=0){
            std::string s = QuantLib::lowercase(traits);
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            if (s == "pseudorandom" || s == "pr")
                return new MCEuropeanEnginePtr(
                         new MCEuropeanEngine<PseudoRandom>(timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCEuropeanEnginePtr(
                       new MCEuropeanEngine<LowDiscrepancy>(timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }
static Scheme_Object *_swig_struct_type__MCEuropeanEnginePtr;
static const char *_swig_struct__MCEuropeanEnginePtr_field_names[] = { 
};
#define  _swig_struct__MCEuropeanEnginePtr_field_names_cnt (sizeof(_swig_struct__MCEuropeanEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__MCEuropeanEnginePtr(MCEuropeanEnginePtr *ptr);

using QuantLib::FDAmericanEngine;
using QuantLib::FDShoutEngine;
typedef boost::shared_ptr<PricingEngine> FDAmericanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDShoutEnginePtr;

static FDAmericanEnginePtr *new_FDAmericanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDAmericanEnginePtr(
                    new FDAmericanEngine(timeSteps,gridPoints,timeDependent));
        }
static Scheme_Object *_swig_struct_type__FDAmericanEnginePtr;
static const char *_swig_struct__FDAmericanEnginePtr_field_names[] = { 
};
#define  _swig_struct__FDAmericanEnginePtr_field_names_cnt (sizeof(_swig_struct__FDAmericanEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FDAmericanEnginePtr(FDAmericanEnginePtr *ptr);
static FDShoutEnginePtr *new_FDShoutEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDShoutEnginePtr(
                       new FDShoutEngine(timeSteps,gridPoints,timeDependent));
        }
static Scheme_Object *_swig_struct_type__FDShoutEnginePtr;
static const char *_swig_struct__FDShoutEnginePtr_field_names[] = { 
};
#define  _swig_struct__FDShoutEnginePtr_field_names_cnt (sizeof(_swig_struct__FDShoutEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FDShoutEnginePtr(FDShoutEnginePtr *ptr);

using QuantLib::BaroneAdesiWhaleyApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BaroneAdesiWhaleyApproximationEnginePtr;

static BaroneAdesiWhaleyApproximationEnginePtr *new_BaroneAdesiWhaleyApproximationEnginePtr(){
            return new BaroneAdesiWhaleyApproximationEnginePtr(
                new BaroneAdesiWhaleyApproximationEngine);
        }
static Scheme_Object *_swig_struct_type__BaroneAdesiWhaleyApproximationEnginePtr;
static const char *_swig_struct__BaroneAdesiWhaleyApproximationEnginePtr_field_names[] = { 
};
#define  _swig_struct__BaroneAdesiWhaleyApproximationEnginePtr_field_names_cnt (sizeof(_swig_struct__BaroneAdesiWhaleyApproximationEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BaroneAdesiWhaleyApproximationEnginePtr(BaroneAdesiWhaleyApproximationEnginePtr *ptr);

using QuantLib::BjerksundStenslandApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BjerksundStenslandApproximationEnginePtr;

static BjerksundStenslandApproximationEnginePtr *new_BjerksundStenslandApproximationEnginePtr(){
            return new BjerksundStenslandApproximationEnginePtr(
                new BjerksundStenslandApproximationEngine);
        }
static Scheme_Object *_swig_struct_type__BjerksundStenslandApproximationEnginePtr;
static const char *_swig_struct__BjerksundStenslandApproximationEnginePtr_field_names[] = { 
};
#define  _swig_struct__BjerksundStenslandApproximationEnginePtr_field_names_cnt (sizeof(_swig_struct__BjerksundStenslandApproximationEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BjerksundStenslandApproximationEnginePtr(BjerksundStenslandApproximationEnginePtr *ptr);

using QuantLib::AnalyticDigitalAmericanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDigitalAmericanEnginePtr;

static AnalyticDigitalAmericanEnginePtr *new_AnalyticDigitalAmericanEnginePtr(){
            return new AnalyticDigitalAmericanEnginePtr(
                new AnalyticDigitalAmericanEngine);
        }
static Scheme_Object *_swig_struct_type__AnalyticDigitalAmericanEnginePtr;
static const char *_swig_struct__AnalyticDigitalAmericanEnginePtr_field_names[] = { 
};
#define  _swig_struct__AnalyticDigitalAmericanEnginePtr_field_names_cnt (sizeof(_swig_struct__AnalyticDigitalAmericanEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__AnalyticDigitalAmericanEnginePtr(AnalyticDigitalAmericanEnginePtr *ptr);

using QuantLib::DividendVanillaOption;
typedef boost::shared_ptr<Instrument> DividendVanillaOptionPtr;

static DividendVanillaOptionPtr *new_DividendVanillaOptionPtr__SWIG_0(boost::shared_ptr<GenericStochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,std::vector<Date > const &dividendDates,std::vector<Real > const &dividends,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new DividendVanillaOptionPtr(
                   new DividendVanillaOption(process,stPayoff,exercise,
                                             dividendDates,dividends,engine));
        }
static Real DividendVanillaOptionPtr_delta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->delta();
        }
static Real DividendVanillaOptionPtr_gamma(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->gamma();
        }
static Real DividendVanillaOptionPtr_theta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->theta();
        }
static Real DividendVanillaOptionPtr_vega(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->vega();
        }
static Real DividendVanillaOptionPtr_rho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->rho();
        }
static Real DividendVanillaOptionPtr_dividendRho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->dividendRho();
        }
static Real DividendVanillaOptionPtr_strikeSensitivity(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->strikeSensitivity();
        }
static Volatility DividendVanillaOptionPtr_impliedVolatility__SWIG_0(DividendVanillaOptionPtr *self,Real targetValue,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }
static Scheme_Object *_swig_struct_type__DividendVanillaOptionPtr;
static const char *_swig_struct__DividendVanillaOptionPtr_field_names[] = { 
};
#define  _swig_struct__DividendVanillaOptionPtr_field_names_cnt (sizeof(_swig_struct__DividendVanillaOptionPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__DividendVanillaOptionPtr(DividendVanillaOptionPtr *ptr);

using QuantLib::AnalyticDividendEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDividendEuropeanEnginePtr;

static AnalyticDividendEuropeanEnginePtr *new_AnalyticDividendEuropeanEnginePtr(){
            return new AnalyticDividendEuropeanEnginePtr(
                new AnalyticDividendEuropeanEngine);
        }
static Scheme_Object *_swig_struct_type__AnalyticDividendEuropeanEnginePtr;
static const char *_swig_struct__AnalyticDividendEuropeanEnginePtr_field_names[] = { 
};
#define  _swig_struct__AnalyticDividendEuropeanEnginePtr_field_names_cnt (sizeof(_swig_struct__AnalyticDividendEuropeanEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__AnalyticDividendEuropeanEnginePtr(AnalyticDividendEuropeanEnginePtr *ptr);

using QuantLib::FDDividendEuropeanEngine;
using QuantLib::FDDividendAmericanEngine;
typedef boost::shared_ptr<PricingEngine> FDDividendEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDDividendAmericanEnginePtr;

static FDDividendEuropeanEnginePtr *new_FDDividendEuropeanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDDividendEuropeanEnginePtr(
                new FDDividendEuropeanEngine(timeSteps,gridPoints,
                                             timeDependent));
        }
static Scheme_Object *_swig_struct_type__FDDividendEuropeanEnginePtr;
static const char *_swig_struct__FDDividendEuropeanEnginePtr_field_names[] = { 
};
#define  _swig_struct__FDDividendEuropeanEnginePtr_field_names_cnt (sizeof(_swig_struct__FDDividendEuropeanEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FDDividendEuropeanEnginePtr(FDDividendEuropeanEnginePtr *ptr);
static FDDividendAmericanEnginePtr *new_FDDividendAmericanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDDividendAmericanEnginePtr(
                new FDDividendAmericanEngine(timeSteps,gridPoints,
                                             timeDependent));
        }
static Scheme_Object *_swig_struct_type__FDDividendAmericanEnginePtr;
static const char *_swig_struct__FDDividendAmericanEnginePtr_field_names[] = { 
};
#define  _swig_struct__FDDividendAmericanEnginePtr_field_names_cnt (sizeof(_swig_struct__FDDividendAmericanEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FDDividendAmericanEnginePtr(FDDividendAmericanEnginePtr *ptr);

using QuantLib::BarrierOption;
typedef boost::shared_ptr<Instrument> BarrierOptionPtr;

static BarrierOptionPtr *new_BarrierOptionPtr__SWIG_0(Barrier::Type barrierType,Real barrier,Real rebate,boost::shared_ptr<GenericStochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new BarrierOptionPtr(
                         new BarrierOption(barrierType, barrier, rebate,
                                           process,stPayoff,exercise,engine));
        }
static Real BarrierOptionPtr_errorEstimate(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->errorEstimate();
        }
static Real BarrierOptionPtr_delta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->delta();
        }
static Real BarrierOptionPtr_gamma(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->gamma();
        }
static Real BarrierOptionPtr_theta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->theta();
        }
static Real BarrierOptionPtr_vega(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->vega();
        }
static Real BarrierOptionPtr_rho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->rho();
        }
static Real BarrierOptionPtr_dividendRho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->dividendRho();
        }
static Real BarrierOptionPtr_strikeSensitivity(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->strikeSensitivity();
        }
static Volatility BarrierOptionPtr_impliedVolatility__SWIG_0(BarrierOptionPtr *self,Real targetValue,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }
static Scheme_Object *_swig_struct_type__BarrierOptionPtr;
static const char *_swig_struct__BarrierOptionPtr_field_names[] = { 
};
#define  _swig_struct__BarrierOptionPtr_field_names_cnt (sizeof(_swig_struct__BarrierOptionPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BarrierOptionPtr(BarrierOptionPtr *ptr);

using QuantLib::AnalyticBarrierEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticBarrierEnginePtr;

static AnalyticBarrierEnginePtr *new_AnalyticBarrierEnginePtr(){
            return new AnalyticBarrierEnginePtr(new AnalyticBarrierEngine);
        }
static Scheme_Object *_swig_struct_type__AnalyticBarrierEnginePtr;
static const char *_swig_struct__AnalyticBarrierEnginePtr_field_names[] = { 
};
#define  _swig_struct__AnalyticBarrierEnginePtr_field_names_cnt (sizeof(_swig_struct__AnalyticBarrierEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__AnalyticBarrierEnginePtr(AnalyticBarrierEnginePtr *ptr);

using QuantLib::Cap;
using QuantLib::Floor;
using QuantLib::Collar;
typedef boost::shared_ptr<Instrument> CapPtr;
typedef boost::shared_ptr<Instrument> FloorPtr;
typedef boost::shared_ptr<Instrument> CollarPtr;

static CapPtr *new_CapPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new CapPtr(new Cap(leg,capRates,h,engine));
        }
static Scheme_Object *_swig_struct_type__CapPtr;
static const char *_swig_struct__CapPtr_field_names[] = { 
};
#define  _swig_struct__CapPtr_field_names_cnt (sizeof(_swig_struct__CapPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CapPtr(CapPtr *ptr);
static FloorPtr *new_FloorPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &floorRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new FloorPtr(new Floor(leg,floorRates,h,engine));
        }
static Scheme_Object *_swig_struct_type__FloorPtr;
static const char *_swig_struct__FloorPtr_field_names[] = { 
};
#define  _swig_struct__FloorPtr_field_names_cnt (sizeof(_swig_struct__FloorPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FloorPtr(FloorPtr *ptr);
static CollarPtr *new_CollarPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates,std::vector<Rate > const &floorRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new CollarPtr(new Collar(leg,capRates,floorRates,h,engine));
        }
static Scheme_Object *_swig_struct_type__CollarPtr;
static const char *_swig_struct__CollarPtr_field_names[] = { 
};
#define  _swig_struct__CollarPtr_field_names_cnt (sizeof(_swig_struct__CollarPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CollarPtr(CollarPtr *ptr);

using QuantLib::BlackCapFloorEngine;
typedef boost::shared_ptr<PricingEngine> BlackCapFloorEnginePtr;

static BlackCapFloorEnginePtr *new_BlackCapFloorEnginePtr(boost::shared_ptr<BlackModel > const &model){
            return new BlackCapFloorEnginePtr(new BlackCapFloorEngine(model));
        }
static Scheme_Object *_swig_struct_type__BlackCapFloorEnginePtr;
static const char *_swig_struct__BlackCapFloorEnginePtr_field_names[] = { 
};
#define  _swig_struct__BlackCapFloorEnginePtr_field_names_cnt (sizeof(_swig_struct__BlackCapFloorEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BlackCapFloorEnginePtr(BlackCapFloorEnginePtr *ptr);

using QuantLib::CompoundForward;
typedef boost::shared_ptr<YieldTermStructure> CompoundForwardPtr;

static CompoundForwardPtr *new_CompoundForwardPtr(Date const &settlementDate,std::vector<Date > const &dates,std::vector<Rate > const &rates,Calendar calendar,BusinessDayConvention roll,Integer compounding,DayCounter const &dayCounter){
	        return new CompoundForwardPtr(
                new CompoundForward(settlementDate,
                                    dates, rates, calendar, roll,
                                    compounding, dayCounter));
        }
static std::vector<Date > const &CompoundForwardPtr_dates(CompoundForwardPtr *self){
            return boost::dynamic_pointer_cast<CompoundForward>(*self)
                 ->dates();
        }
static Scheme_Object *_swig_struct_type__CompoundForwardPtr;
static const char *_swig_struct__CompoundForwardPtr_field_names[] = { 
};
#define  _swig_struct__CompoundForwardPtr_field_names_cnt (sizeof(_swig_struct__CompoundForwardPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CompoundForwardPtr(CompoundForwardPtr *ptr);

using QuantLib::DiscountCurve;
using QuantLib::ExtendedDiscountCurve;
typedef boost::shared_ptr<YieldTermStructure> DiscountCurvePtr;
typedef boost::shared_ptr<YieldTermStructure> ExtendedDiscountCurvePtr;

static DiscountCurvePtr *new_DiscountCurvePtr(std::vector<Date > const &dates,std::vector<DiscountFactor > const &discounts,DayCounter const &dayCounter){
            return new DiscountCurvePtr(
                             new DiscountCurve(dates, discounts, dayCounter));
        }
static std::vector<Date > const &DiscountCurvePtr_dates(DiscountCurvePtr *self){
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->dates();
        }
static Scheme_Object *_swig_struct_type__DiscountCurvePtr;
static const char *_swig_struct__DiscountCurvePtr_field_names[] = { 
};
#define  _swig_struct__DiscountCurvePtr_field_names_cnt (sizeof(_swig_struct__DiscountCurvePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__DiscountCurvePtr(DiscountCurvePtr *ptr);
static ExtendedDiscountCurvePtr *new_ExtendedDiscountCurvePtr(std::vector<Date > const &dates,std::vector<DiscountFactor > const &discounts,Calendar const &calendar,BusinessDayConvention roll,DayCounter const &dayCounter){
            return new ExtendedDiscountCurvePtr(
                new ExtendedDiscountCurve(dates, discounts,
                                          calendar, roll, dayCounter));
        }
static Scheme_Object *_swig_struct_type__ExtendedDiscountCurvePtr;
static const char *_swig_struct__ExtendedDiscountCurvePtr_field_names[] = { 
};
#define  _swig_struct__ExtendedDiscountCurvePtr_field_names_cnt (sizeof(_swig_struct__ExtendedDiscountCurvePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__ExtendedDiscountCurvePtr(ExtendedDiscountCurvePtr *ptr);

using QuantLib::NormalDistribution;
using QuantLib::CumulativeNormalDistribution;
using QuantLib::MoroInverseCumulativeNormal;
using QuantLib::InverseCumulativeNormal;

static Scheme_Object *_swig_struct_type__NormalDistribution;
static const char *_swig_struct__NormalDistribution_field_names[] = { 
};
#define  _swig_struct__NormalDistribution_field_names_cnt (sizeof(_swig_struct__NormalDistribution_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__NormalDistribution(NormalDistribution *ptr);
static Scheme_Object *_swig_struct_type__CumulativeNormalDistribution;
static const char *_swig_struct__CumulativeNormalDistribution_field_names[] = { 
};
#define  _swig_struct__CumulativeNormalDistribution_field_names_cnt (sizeof(_swig_struct__CumulativeNormalDistribution_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CumulativeNormalDistribution(CumulativeNormalDistribution *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeNormal;
static const char *_swig_struct__InverseCumulativeNormal_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeNormal_field_names_cnt (sizeof(_swig_struct__InverseCumulativeNormal_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeNormal(InverseCumulativeNormal *ptr);
static Scheme_Object *_swig_struct_type__MoroInverseCumulativeNormal;
static const char *_swig_struct__MoroInverseCumulativeNormal_field_names[] = { 
};
#define  _swig_struct__MoroInverseCumulativeNormal_field_names_cnt (sizeof(_swig_struct__MoroInverseCumulativeNormal_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__MoroInverseCumulativeNormal(MoroInverseCumulativeNormal *ptr);

using QuantLib::Money;

static int _wrap_const_Money_NoConversion = Money::NoConversion;
static int _wrap_const_Money_BaseCurrencyConversion = Money::BaseCurrencyConversion;
static int _wrap_const_Money_AutomatedConversion = Money::AutomatedConversion;
static void Money_setConversionType(Money::ConversionType type){
            Money::conversionType = type;
        }
static void Money_setBaseCurrency(Currency const &c){
            Money::baseCurrency = c;
        }
static Scheme_Object *_swig_struct_type__Money;
static const char *_swig_struct__Money_field_names[] = { 
};
#define  _swig_struct__Money_field_names_cnt (sizeof(_swig_struct__Money_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Money(Money *ptr);

    Money Money_plus(const Money& m1, const Money& m2) {
        return m1+m2;
    }
    Money Money_minus(const Money& m1, const Money& m2) {
        return m1-m2;
    }
    Money Money_times(const Money& m1, Decimal x) {
        return m1*x;
    }
    Money Money_times(Decimal x, const Money& m2) {
        return m2*x;
    }
    Money Money_divided(const Money& m1, Decimal x) {
        return m1/x;
    }
    Decimal Money_divided(const Money& m1, const Money& m2) {
        return m1/m2;
    }
    bool Money_equal(const Money& d1, const Money& d2) {
        return d1 == d2;
    }
    bool Money_less(const Money& d1, const Money& d2) {
        return d1 < d2;
    }
    bool Money_less_equal(const Money& d1, const Money& d2) {
        return d1 <= d2;
    }
    bool Money_greater(const Money& d1, const Money& d2) {
        return d1 > d2;
    }
    bool Money_greater_equal(const Money& d1, const Money& d2) {
        return d1 >= d2;
    }


using QuantLib::ExchangeRate;
using QuantLib::ExchangeRateManager;

static int _wrap_const_ExchangeRate_Direct = ExchangeRate::Direct;
static int _wrap_const_ExchangeRate_Derived = ExchangeRate::Derived;
static Scheme_Object *_swig_struct_type__ExchangeRate;
static const char *_swig_struct__ExchangeRate_field_names[] = { 
};
#define  _swig_struct__ExchangeRate_field_names_cnt (sizeof(_swig_struct__ExchangeRate_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__ExchangeRate(ExchangeRate *ptr);
static Scheme_Object *_swig_struct_type__ExchangeRateManager;
static const char *_swig_struct__ExchangeRateManager_field_names[] = { 
};
#define  _swig_struct__ExchangeRateManager_field_names_cnt (sizeof(_swig_struct__ExchangeRateManager_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__ExchangeRateManager(ExchangeRateManager *ptr);

using QuantLib::TimeGrid;

static TimeGrid *new_TimeGrid__SWIG_2(std::vector<Time > const &times){
            return new TimeGrid(times.begin(), times.end());
        }
static TimeGrid *new_TimeGrid__SWIG_3(std::vector<Time > const &times,Size steps){
            return new TimeGrid(times.begin(), times.end(), steps);
        }
static Time TimeGrid_ref(TimeGrid *self,Size i){
            if (i<self->size())
                return (*self)[i];
            else
                throw std::out_of_range("time-grid index out of range");
            QL_DUMMY_RETURN(0.0)
        }
static Time TimeGrid_dt(TimeGrid *self,Size i){
            if (i<self->size())
                return self->dt(i);
            else
                throw std::out_of_range("time-grid index out of range");
            QL_DUMMY_RETURN(0.0)
        }
static Scheme_Object *_swig_struct_type__TimeGrid;
static const char *_swig_struct__TimeGrid_field_names[] = { 
};
#define  _swig_struct__TimeGrid_field_names_cnt (sizeof(_swig_struct__TimeGrid_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__TimeGrid(TimeGrid *ptr);

using QuantLib::SegmentIntegral;
using QuantLib::TrapezoidIntegral;
using QuantLib::SimpsonIntegral;
using QuantLib::KronrodIntegral;

static Real SegmentIntegral_calculate(SegmentIntegral *self,Scheme_Object *mzFunction,Real a,Real b){
            UnaryFunction f(mzFunction);
            return (*self)(f, a, b);
        }
static Scheme_Object *_swig_struct_type__SegmentIntegral;
static const char *_swig_struct__SegmentIntegral_field_names[] = { 
};
#define  _swig_struct__SegmentIntegral_field_names_cnt (sizeof(_swig_struct__SegmentIntegral_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SegmentIntegral(SegmentIntegral *ptr);
static Real TrapezoidIntegral_calculate(TrapezoidIntegral *self,Scheme_Object *mzFunction,Real a,Real b){
            UnaryFunction f(mzFunction);
            return (*self)(f, a, b);
        }
static Scheme_Object *_swig_struct_type__TrapezoidIntegral;
static const char *_swig_struct__TrapezoidIntegral_field_names[] = { 
};
#define  _swig_struct__TrapezoidIntegral_field_names_cnt (sizeof(_swig_struct__TrapezoidIntegral_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__TrapezoidIntegral(TrapezoidIntegral *ptr);
static Real SimpsonIntegral_calculate(SimpsonIntegral *self,Scheme_Object *mzFunction,Real a,Real b){
            UnaryFunction f(mzFunction);
            return (*self)(f, a, b);
        }
static Scheme_Object *_swig_struct_type__SimpsonIntegral;
static const char *_swig_struct__SimpsonIntegral_field_names[] = { 
};
#define  _swig_struct__SimpsonIntegral_field_names_cnt (sizeof(_swig_struct__SimpsonIntegral_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SimpsonIntegral(SimpsonIntegral *ptr);
static Real KronrodIntegral_calculate(KronrodIntegral *self,Scheme_Object *mzFunction,Real a,Real b){
            UnaryFunction f(mzFunction);
            return (*self)(f, a, b);
        }
static Scheme_Object *_swig_struct_type__KronrodIntegral;
static const char *_swig_struct__KronrodIntegral_field_names[] = { 
};
#define  _swig_struct__KronrodIntegral_field_names_cnt (sizeof(_swig_struct__KronrodIntegral_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__KronrodIntegral(KronrodIntegral *ptr);

using QuantLib::Sample;

using QuantLib::LecuyerUniformRng;
using QuantLib::KnuthUniformRng;
using QuantLib::MersenneTwisterUniformRng;

typedef QuantLib::PseudoRandom::urng_type UniformRandomGenerator;

using QuantLib::CLGaussianRng;
using QuantLib::BoxMullerGaussianRng;
using QuantLib::InverseCumulativeRng;

typedef QuantLib::PseudoRandom::rng_type GaussianRandomGenerator;

using QuantLib::RandomSequenceGenerator;

typedef QuantLib::PseudoRandom::ursg_type UniformRandomSequenceGenerator;

using QuantLib::HaltonRsg;
using QuantLib::SobolRsg;

typedef QuantLib::LowDiscrepancy::ursg_type
    UniformLowDiscrepancySequenceGenerator;

using QuantLib::InverseCumulativeRsg;

typedef QuantLib::PseudoRandom::rsg_type GaussianRandomSequenceGenerator;
typedef QuantLib::LowDiscrepancy::rsg_type
    GaussianLowDiscrepancySequenceGenerator;

static Real Sample_Sl_Real_Sg__value(Sample<Real > *self){ return self->value; }
static Real Sample_Sl_Real_Sg__weight(Sample<Real > *self){ return self->weight; }
static Scheme_Object *_swig_struct_type__SampleTdouble_t;
static const char *_swig_struct__SampleTdouble_t_field_names[] = { 
};
#define  _swig_struct__SampleTdouble_t_field_names_cnt (sizeof(_swig_struct__SampleTdouble_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SampleTdouble_t(Sample<Real > *ptr);
static Array Sample_Sl_Array_Sg__value(Sample<Array > *self){ return self->value; }
static Real Sample_Sl_Array_Sg__weight(Sample<Array > *self){ return self->weight; }
static Scheme_Object *_swig_struct_type__SampleTArray_t;
static const char *_swig_struct__SampleTArray_t_field_names[] = { 
};
#define  _swig_struct__SampleTArray_t_field_names_cnt (sizeof(_swig_struct__SampleTArray_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SampleTArray_t(Sample<Array > *ptr);
static Scheme_Object *_swig_struct_type__LecuyerUniformRng;
static const char *_swig_struct__LecuyerUniformRng_field_names[] = { 
};
#define  _swig_struct__LecuyerUniformRng_field_names_cnt (sizeof(_swig_struct__LecuyerUniformRng_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__LecuyerUniformRng(LecuyerUniformRng *ptr);
static Scheme_Object *_swig_struct_type__KnuthUniformRng;
static const char *_swig_struct__KnuthUniformRng_field_names[] = { 
};
#define  _swig_struct__KnuthUniformRng_field_names_cnt (sizeof(_swig_struct__KnuthUniformRng_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__KnuthUniformRng(KnuthUniformRng *ptr);
static Scheme_Object *_swig_struct_type__MersenneTwisterUniformRng;
static const char *_swig_struct__MersenneTwisterUniformRng_field_names[] = { 
};
#define  _swig_struct__MersenneTwisterUniformRng_field_names_cnt (sizeof(_swig_struct__MersenneTwisterUniformRng_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__MersenneTwisterUniformRng(MersenneTwisterUniformRng *ptr);
static Scheme_Object *_swig_struct_type__UniformRandomGenerator;
static const char *_swig_struct__UniformRandomGenerator_field_names[] = { 
};
#define  _swig_struct__UniformRandomGenerator_field_names_cnt (sizeof(_swig_struct__UniformRandomGenerator_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__UniformRandomGenerator(UniformRandomGenerator *ptr);
static Scheme_Object *_swig_struct_type__CLGaussianRngTLecuyerUniformRng_t;
static const char *_swig_struct__CLGaussianRngTLecuyerUniformRng_t_field_names[] = { 
};
#define  _swig_struct__CLGaussianRngTLecuyerUniformRng_t_field_names_cnt (sizeof(_swig_struct__CLGaussianRngTLecuyerUniformRng_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CLGaussianRngTLecuyerUniformRng_t(CLGaussianRng<LecuyerUniformRng > *ptr);
static Scheme_Object *_swig_struct_type__CLGaussianRngTKnuthUniformRng_t;
static const char *_swig_struct__CLGaussianRngTKnuthUniformRng_t_field_names[] = { 
};
#define  _swig_struct__CLGaussianRngTKnuthUniformRng_t_field_names_cnt (sizeof(_swig_struct__CLGaussianRngTKnuthUniformRng_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CLGaussianRngTKnuthUniformRng_t(CLGaussianRng<KnuthUniformRng > *ptr);
static Scheme_Object *_swig_struct_type__CLGaussianRngTMersenneTwisterUniformRng_t;
static const char *_swig_struct__CLGaussianRngTMersenneTwisterUniformRng_t_field_names[] = { 
};
#define  _swig_struct__CLGaussianRngTMersenneTwisterUniformRng_t_field_names_cnt (sizeof(_swig_struct__CLGaussianRngTMersenneTwisterUniformRng_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CLGaussianRngTMersenneTwisterUniformRng_t(CLGaussianRng<MersenneTwisterUniformRng > *ptr);
static Scheme_Object *_swig_struct_type__BoxMullerGaussianRngTLecuyerUniformRng_t;
static const char *_swig_struct__BoxMullerGaussianRngTLecuyerUniformRng_t_field_names[] = { 
};
#define  _swig_struct__BoxMullerGaussianRngTLecuyerUniformRng_t_field_names_cnt (sizeof(_swig_struct__BoxMullerGaussianRngTLecuyerUniformRng_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BoxMullerGaussianRngTLecuyerUniformRng_t(BoxMullerGaussianRng<LecuyerUniformRng > *ptr);
static Scheme_Object *_swig_struct_type__BoxMullerGaussianRngTKnuthUniformRng_t;
static const char *_swig_struct__BoxMullerGaussianRngTKnuthUniformRng_t_field_names[] = { 
};
#define  _swig_struct__BoxMullerGaussianRngTKnuthUniformRng_t_field_names_cnt (sizeof(_swig_struct__BoxMullerGaussianRngTKnuthUniformRng_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BoxMullerGaussianRngTKnuthUniformRng_t(BoxMullerGaussianRng<KnuthUniformRng > *ptr);
static Scheme_Object *_swig_struct_type__BoxMullerGaussianRngTMersenneTwisterUniformRng_t;
static const char *_swig_struct__BoxMullerGaussianRngTMersenneTwisterUniformRng_t_field_names[] = { 
};
#define  _swig_struct__BoxMullerGaussianRngTMersenneTwisterUniformRng_t_field_names_cnt (sizeof(_swig_struct__BoxMullerGaussianRngTMersenneTwisterUniformRng_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BoxMullerGaussianRngTMersenneTwisterUniformRng_t(BoxMullerGaussianRng<MersenneTwisterUniformRng > *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRngTLecuyerUniformRng_MoroInverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRngTLecuyerUniformRng_MoroInverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRngTLecuyerUniformRng_MoroInverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRngTLecuyerUniformRng_MoroInverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRngTLecuyerUniformRng_MoroInverseCumulativeNormal_t(InverseCumulativeRng<LecuyerUniformRng,MoroInverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRngTKnuthUniformRng_MoroInverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRngTKnuthUniformRng_MoroInverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRngTKnuthUniformRng_MoroInverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRngTKnuthUniformRng_MoroInverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRngTKnuthUniformRng_MoroInverseCumulativeNormal_t(InverseCumulativeRng<KnuthUniformRng,MoroInverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRngTMersenneTwisterUniformRng_MoroInverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRngTMersenneTwisterUniformRng_MoroInverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRngTMersenneTwisterUniformRng_MoroInverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRngTMersenneTwisterUniformRng_MoroInverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRngTMersenneTwisterUniformRng_MoroInverseCumulativeNormal_t(InverseCumulativeRng<MersenneTwisterUniformRng,MoroInverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRngTLecuyerUniformRng_InverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRngTLecuyerUniformRng_InverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRngTLecuyerUniformRng_InverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRngTLecuyerUniformRng_InverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRngTLecuyerUniformRng_InverseCumulativeNormal_t(InverseCumulativeRng<LecuyerUniformRng,InverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRngTKnuthUniformRng_InverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRngTKnuthUniformRng_InverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRngTKnuthUniformRng_InverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRngTKnuthUniformRng_InverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRngTKnuthUniformRng_InverseCumulativeNormal_t(InverseCumulativeRng<KnuthUniformRng,InverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRngTMersenneTwisterUniformRng_InverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRngTMersenneTwisterUniformRng_InverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRngTMersenneTwisterUniformRng_InverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRngTMersenneTwisterUniformRng_InverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRngTMersenneTwisterUniformRng_InverseCumulativeNormal_t(InverseCumulativeRng<MersenneTwisterUniformRng,InverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__GaussianRandomGenerator;
static const char *_swig_struct__GaussianRandomGenerator_field_names[] = { 
};
#define  _swig_struct__GaussianRandomGenerator_field_names_cnt (sizeof(_swig_struct__GaussianRandomGenerator_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__GaussianRandomGenerator(GaussianRandomGenerator *ptr);
static Scheme_Object *_swig_struct_type__HaltonRsg;
static const char *_swig_struct__HaltonRsg_field_names[] = { 
};
#define  _swig_struct__HaltonRsg_field_names_cnt (sizeof(_swig_struct__HaltonRsg_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__HaltonRsg(HaltonRsg *ptr);
static Scheme_Object *_swig_struct_type__SobolRsg;
static const char *_swig_struct__SobolRsg_field_names[] = { 
};
#define  _swig_struct__SobolRsg_field_names_cnt (sizeof(_swig_struct__SobolRsg_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SobolRsg(SobolRsg *ptr);
static Scheme_Object *_swig_struct_type__RandomSequenceGeneratorTLecuyerUniformRng_t;
static const char *_swig_struct__RandomSequenceGeneratorTLecuyerUniformRng_t_field_names[] = { 
};
#define  _swig_struct__RandomSequenceGeneratorTLecuyerUniformRng_t_field_names_cnt (sizeof(_swig_struct__RandomSequenceGeneratorTLecuyerUniformRng_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__RandomSequenceGeneratorTLecuyerUniformRng_t(RandomSequenceGenerator<LecuyerUniformRng > *ptr);
static Scheme_Object *_swig_struct_type__RandomSequenceGeneratorTKnuthUniformRng_t;
static const char *_swig_struct__RandomSequenceGeneratorTKnuthUniformRng_t_field_names[] = { 
};
#define  _swig_struct__RandomSequenceGeneratorTKnuthUniformRng_t_field_names_cnt (sizeof(_swig_struct__RandomSequenceGeneratorTKnuthUniformRng_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__RandomSequenceGeneratorTKnuthUniformRng_t(RandomSequenceGenerator<KnuthUniformRng > *ptr);
static Scheme_Object *_swig_struct_type__RandomSequenceGeneratorTMersenneTwisterUniformRng_t;
static const char *_swig_struct__RandomSequenceGeneratorTMersenneTwisterUniformRng_t_field_names[] = { 
};
#define  _swig_struct__RandomSequenceGeneratorTMersenneTwisterUniformRng_t_field_names_cnt (sizeof(_swig_struct__RandomSequenceGeneratorTMersenneTwisterUniformRng_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__RandomSequenceGeneratorTMersenneTwisterUniformRng_t(RandomSequenceGenerator<MersenneTwisterUniformRng > *ptr);
static Scheme_Object *_swig_struct_type__UniformRandomSequenceGenerator;
static const char *_swig_struct__UniformRandomSequenceGenerator_field_names[] = { 
};
#define  _swig_struct__UniformRandomSequenceGenerator_field_names_cnt (sizeof(_swig_struct__UniformRandomSequenceGenerator_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__UniformRandomSequenceGenerator(UniformRandomSequenceGenerator *ptr);
static Scheme_Object *_swig_struct_type__UniformLowDiscrepancySequenceGenerator;
static const char *_swig_struct__UniformLowDiscrepancySequenceGenerator_field_names[] = { 
};
#define  _swig_struct__UniformLowDiscrepancySequenceGenerator_field_names_cnt (sizeof(_swig_struct__UniformLowDiscrepancySequenceGenerator_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__UniformLowDiscrepancySequenceGenerator(UniformLowDiscrepancySequenceGenerator *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_MoroInverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_MoroInverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_MoroInverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_MoroInverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_MoroInverseCumulativeNormal_t(InverseCumulativeRsg<RandomSequenceGenerator<LecuyerUniformRng >,MoroInverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_MoroInverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_MoroInverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_MoroInverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_MoroInverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_MoroInverseCumulativeNormal_t(InverseCumulativeRsg<RandomSequenceGenerator<KnuthUniformRng >,MoroInverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_MoroInverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_MoroInverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_MoroInverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_MoroInverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_MoroInverseCumulativeNormal_t(InverseCumulativeRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,MoroInverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRsgTHaltonRsg_MoroInverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRsgTHaltonRsg_MoroInverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRsgTHaltonRsg_MoroInverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRsgTHaltonRsg_MoroInverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRsgTHaltonRsg_MoroInverseCumulativeNormal_t(InverseCumulativeRsg<HaltonRsg,MoroInverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_InverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_InverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_InverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_InverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_InverseCumulativeNormal_t(InverseCumulativeRsg<RandomSequenceGenerator<LecuyerUniformRng >,InverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_InverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_InverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_InverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_InverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_InverseCumulativeNormal_t(InverseCumulativeRsg<RandomSequenceGenerator<KnuthUniformRng >,InverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_InverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_InverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_InverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_InverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_InverseCumulativeNormal_t(InverseCumulativeRsg<RandomSequenceGenerator<MersenneTwisterUniformRng >,InverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__InverseCumulativeRsgTHaltonRsg_InverseCumulativeNormal_t;
static const char *_swig_struct__InverseCumulativeRsgTHaltonRsg_InverseCumulativeNormal_t_field_names[] = { 
};
#define  _swig_struct__InverseCumulativeRsgTHaltonRsg_InverseCumulativeNormal_t_field_names_cnt (sizeof(_swig_struct__InverseCumulativeRsgTHaltonRsg_InverseCumulativeNormal_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__InverseCumulativeRsgTHaltonRsg_InverseCumulativeNormal_t(InverseCumulativeRsg<HaltonRsg,InverseCumulativeNormal > *ptr);
static Scheme_Object *_swig_struct_type__GaussianRandomSequenceGenerator;
static const char *_swig_struct__GaussianRandomSequenceGenerator_field_names[] = { 
};
#define  _swig_struct__GaussianRandomSequenceGenerator_field_names_cnt (sizeof(_swig_struct__GaussianRandomSequenceGenerator_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__GaussianRandomSequenceGenerator(GaussianRandomSequenceGenerator *ptr);
static Scheme_Object *_swig_struct_type__GaussianLowDiscrepancySequenceGenerator;
static const char *_swig_struct__GaussianLowDiscrepancySequenceGenerator_field_names[] = { 
};
#define  _swig_struct__GaussianLowDiscrepancySequenceGenerator_field_names_cnt (sizeof(_swig_struct__GaussianLowDiscrepancySequenceGenerator_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__GaussianLowDiscrepancySequenceGenerator(GaussianLowDiscrepancySequenceGenerator *ptr);

Matrix getCovariance(const Array& volatilities, const Matrix& correlations) {
    return QuantLib::getCovariance(volatilities.begin(),
                                   volatilities.end(),
                                   correlations);
}


using QuantLib::Path;

static Real Path_ref(Path *self,Size i){
            if (i<self->length()) {
                return (*self)[i];
            } else {
                throw std::out_of_range("path index out of range");
            }
            QL_DUMMY_RETURN(0.0)
        }
static void Path_for_each(Path *self,Scheme_Object *proc){
            for (Size i=0; i<self->length(); ++i) {
                Scheme_Object* x = scheme_make_double((*self)[i]);
                scheme_apply(proc,1,&x);
            }
        }
static Scheme_Object *_swig_struct_type__Path;
static const char *_swig_struct__Path_field_names[] = { 
};
#define  _swig_struct__Path_field_names_cnt (sizeof(_swig_struct__Path_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Path(Path *ptr);

typedef QuantLib::SingleAsset<PseudoRandom>::path_generator_type
    GaussianPathGenerator;

static Path Sample_Sl_Path_Sg__value(Sample<Path > *self){ return self->value; }
static Real Sample_Sl_Path_Sg__weight(Sample<Path > *self){ return self->weight; }
static Scheme_Object *_swig_struct_type__SampleTPath_t;
static const char *_swig_struct__SampleTPath_t_field_names[] = { 
};
#define  _swig_struct__SampleTPath_t_field_names_cnt (sizeof(_swig_struct__SampleTPath_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SampleTPath_t(Sample<Path > *ptr);
static GaussianPathGenerator *new_GaussianPathGenerator(StochasticProcess1DPtr const &process,Time length,Size steps,GaussianRandomSequenceGenerator const &rsg,bool brownianBridge){
            boost::shared_ptr<StochasticProcess1D> process1d =
                boost::dynamic_pointer_cast<StochasticProcess1D>(process);
            return new GaussianPathGenerator(process1d,length,steps,
                                             rsg,brownianBridge);
        }
static Scheme_Object *_swig_struct_type__GaussianPathGenerator;
static const char *_swig_struct__GaussianPathGenerator_field_names[] = { 
};
#define  _swig_struct__GaussianPathGenerator_field_names_cnt (sizeof(_swig_struct__GaussianPathGenerator_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__GaussianPathGenerator(GaussianPathGenerator *ptr);

using QuantLib::MultiPath;

static Real MultiPath_ref(MultiPath *self,Size i,Size j){
            if (i<self->assetNumber() && j<self->pathSize()) {
                return (*self)[i][j];
            } else {
                throw std::out_of_range("multi-path index out of range");
            }
            QL_DUMMY_RETURN(0.0)
        }
static void MultiPath_for_each_path(MultiPath *self,Scheme_Object *proc){
            for (Size i=0; i<self->assetNumber(); i++) {
                Scheme_Object* x =
                    SWIG_NewPointerObj(&((*self)[i]), SWIGTYPE_p_Path, 0);
                scheme_apply(proc,1,&x);
            }
        }
static void MultiPath_for_each_step(MultiPath *self,Scheme_Object *proc){
            for (Size j=0; j<self->pathSize(); j++) {
                Scheme_Object* v = scheme_make_vector(self->assetNumber(),
                                                      scheme_undefined);
                Scheme_Object** els = SCHEME_VEC_ELS(v);
                for (Size i=0; i<self->assetNumber(); i++)
                    els[i] = scheme_make_double((*self)[i][j]);
                scheme_apply(proc,1,&v);
            }
        }
static Scheme_Object *_swig_struct_type__MultiPath;
static const char *_swig_struct__MultiPath_field_names[] = { 
};
#define  _swig_struct__MultiPath_field_names_cnt (sizeof(_swig_struct__MultiPath_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__MultiPath(MultiPath *ptr);

typedef QuantLib::MultiAsset<PseudoRandom>::path_generator_type
    GaussianMultiPathGenerator;

static MultiPath Sample_Sl_MultiPath_Sg__value(Sample<MultiPath > *self){ return self->value; }
static Real Sample_Sl_MultiPath_Sg__weight(Sample<MultiPath > *self){ return self->weight; }
static Scheme_Object *_swig_struct_type__SampleTMultiPath_t;
static const char *_swig_struct__SampleTMultiPath_t_field_names[] = { 
};
#define  _swig_struct__SampleTMultiPath_t_field_names_cnt (sizeof(_swig_struct__SampleTMultiPath_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SampleTMultiPath_t(Sample<MultiPath > *ptr);
static GaussianMultiPathGenerator *new_GaussianMultiPathGenerator__SWIG_0(boost::shared_ptr<GenericStochasticProcess > const &process,std::vector<Time > const &times,GaussianRandomSequenceGenerator const &generator,bool brownianBridge=false){
          return new GaussianMultiPathGenerator(process,
                                                QuantLib::TimeGrid(
                                                    times.begin(),
                                                    times.end()),
                                                generator,
                                                brownianBridge);
      }
static Scheme_Object *_swig_struct_type__GaussianMultiPathGenerator;
static const char *_swig_struct__GaussianMultiPathGenerator_field_names[] = { 
};
#define  _swig_struct__GaussianMultiPathGenerator_field_names_cnt (sizeof(_swig_struct__GaussianMultiPathGenerator_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__GaussianMultiPathGenerator(GaussianMultiPathGenerator *ptr);

typedef QuantLib::BoundaryCondition<QuantLib::TridiagonalOperator>
		BoundaryCondition;
typedef BoundaryCondition::Side BoundaryConditionSide;

BoundaryCondition::Side BCSideFromString(std::string s) {
    s = QuantLib::lowercase(s);
    if (s == "" || s == "none")
        return BoundaryCondition::None;
    else if (s == "upper")
        return BoundaryCondition::Upper;
    else if (s == "lower")
        return BoundaryCondition::Lower;
    else
        QL_FAIL("unknown boundary condition side: "+s);
}

std::string BCSideToString(BoundaryCondition::Side type) {
    switch (type) {
      case BoundaryCondition::None:
        return "None";
      case BoundaryCondition::Upper:
        return "upper";
      case BoundaryCondition::Lower:
        return "lower";
      default:
        QL_FAIL("unknown boundary condition side");
    }
}

static bool boost_shared_ptr_Sl_BoundaryCondition_Sg__isNull(boost::shared_ptr<BoundaryCondition > *self){
                return !(*self);
            }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTBoundaryCondition_t;
static const char *_swig_struct__boost__shared_ptrTBoundaryCondition_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTBoundaryCondition_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTBoundaryCondition_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTBoundaryCondition_t(boost::shared_ptr<BoundaryCondition > *ptr);

using QuantLib::NeumannBC;
using QuantLib::DirichletBC;
typedef boost::shared_ptr<BoundaryCondition> NeumannBCPtr;
typedef boost::shared_ptr<BoundaryCondition> DirichletBCPtr;

static NeumannBCPtr *new_NeumannBCPtr(Real value,BoundaryConditionSide side){
            return new NeumannBCPtr(new NeumannBC(value, side));
        }
static Scheme_Object *_swig_struct_type__NeumannBCPtr;
static const char *_swig_struct__NeumannBCPtr_field_names[] = { 
};
#define  _swig_struct__NeumannBCPtr_field_names_cnt (sizeof(_swig_struct__NeumannBCPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__NeumannBCPtr(NeumannBCPtr *ptr);
static DirichletBCPtr *new_DirichletBCPtr(Real value,BoundaryConditionSide side){
            return new DirichletBCPtr(new DirichletBC(value, side));
        }
static Scheme_Object *_swig_struct_type__DirichletBCPtr;
static const char *_swig_struct__DirichletBCPtr_field_names[] = { 
};
#define  _swig_struct__DirichletBCPtr_field_names_cnt (sizeof(_swig_struct__DirichletBCPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__DirichletBCPtr(DirichletBCPtr *ptr);

using QuantLib::TridiagonalOperator;

static Scheme_Object *_swig_struct_type__TridiagonalOperator;
static const char *_swig_struct__TridiagonalOperator_field_names[] = { 
};
#define  _swig_struct__TridiagonalOperator_field_names_cnt (sizeof(_swig_struct__TridiagonalOperator_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__TridiagonalOperator(TridiagonalOperator *ptr);

    TridiagonalOperator TridiagonalOperator_add(const TridiagonalOperator& p,
                                                const TridiagonalOperator& q) {
        return p+q;
    }
    TridiagonalOperator TridiagonalOperator_sub(const TridiagonalOperator& p,
                                                const TridiagonalOperator& q) {
        return p-q;
    }
    TridiagonalOperator TridiagonalOperator_mul(const TridiagonalOperator& p,
                                                Real x) {
        return p*x;
    }
    TridiagonalOperator TridiagonalOperator_div(const TridiagonalOperator& p,
                                                Real x) {
        return p/x;
    }


using QuantLib::DPlus;
using QuantLib::DMinus;
using QuantLib::DZero;
using QuantLib::DPlusDMinus;


    TridiagonalOperator makeDPlus(Size gridPoints, Real h) {
        return DPlus(gridPoints,h);
    }
    TridiagonalOperator makeDMinus(Size gridPoints, Real h) {
        return DMinus(gridPoints,h);
    }
    TridiagonalOperator makeDZero(Size gridPoints, Real h) {
        return DZero(gridPoints,h);
    }
    TridiagonalOperator makeDPlusDMinus(Size gridPoints, Real h) {
        return DPlusDMinus(gridPoints,h);
    }


using QuantLib::valueAtCenter;
using QuantLib::firstDerivativeAtCenter;
using QuantLib::secondDerivativeAtCenter;


using QuantLib::SymmetricEigenvalues;
using QuantLib::SymmetricEigenvectors;


using QuantLib::Bisection;
using QuantLib::Brent;
using QuantLib::FalsePosition;
using QuantLib::Newton;
using QuantLib::NewtonSafe;
using QuantLib::Ridder;
using QuantLib::Secant;

static Real Brent_solve__SWIG_0(Brent *self,Scheme_Object *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
static Real Brent_solve__SWIG_1(Brent *self,Scheme_Object *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
static Scheme_Object *_swig_struct_type__Brent;
static const char *_swig_struct__Brent_field_names[] = { 
};
#define  _swig_struct__Brent_field_names_cnt (sizeof(_swig_struct__Brent_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Brent(Brent *ptr);
static Real Bisection_solve__SWIG_0(Bisection *self,Scheme_Object *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
static Real Bisection_solve__SWIG_1(Bisection *self,Scheme_Object *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
static Scheme_Object *_swig_struct_type__Bisection;
static const char *_swig_struct__Bisection_field_names[] = { 
};
#define  _swig_struct__Bisection_field_names_cnt (sizeof(_swig_struct__Bisection_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Bisection(Bisection *ptr);
static Real FalsePosition_solve__SWIG_0(FalsePosition *self,Scheme_Object *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
static Real FalsePosition_solve__SWIG_1(FalsePosition *self,Scheme_Object *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
static Scheme_Object *_swig_struct_type__FalsePosition;
static const char *_swig_struct__FalsePosition_field_names[] = { 
};
#define  _swig_struct__FalsePosition_field_names_cnt (sizeof(_swig_struct__FalsePosition_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FalsePosition(FalsePosition *ptr);
static Real Ridder_solve__SWIG_0(Ridder *self,Scheme_Object *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
static Real Ridder_solve__SWIG_1(Ridder *self,Scheme_Object *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
static Scheme_Object *_swig_struct_type__Ridder;
static const char *_swig_struct__Ridder_field_names[] = { 
};
#define  _swig_struct__Ridder_field_names_cnt (sizeof(_swig_struct__Ridder_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Ridder(Ridder *ptr);
static Real Secant_solve__SWIG_0(Secant *self,Scheme_Object *function,Real xAccuracy,Real guess,Real step){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, step);
        }
static Real Secant_solve__SWIG_1(Secant *self,Scheme_Object *function,Real xAccuracy,Real guess,Real xMin,Real xMax){
            UnaryFunction f(function);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
        }
static Scheme_Object *_swig_struct_type__Secant;
static const char *_swig_struct__Secant_field_names[] = { 
};
#define  _swig_struct__Secant_field_names_cnt (sizeof(_swig_struct__Secant_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Secant(Secant *ptr);

using QuantLib::Constraint;
using QuantLib::BoundaryConstraint;
using QuantLib::NoConstraint;
using QuantLib::PositiveConstraint;

static Scheme_Object *_swig_struct_type__Constraint;
static const char *_swig_struct__Constraint_field_names[] = { 
};
#define  _swig_struct__Constraint_field_names_cnt (sizeof(_swig_struct__Constraint_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Constraint(Constraint *ptr);
static Scheme_Object *_swig_struct_type__BoundaryConstraint;
static const char *_swig_struct__BoundaryConstraint_field_names[] = { 
};
#define  _swig_struct__BoundaryConstraint_field_names_cnt (sizeof(_swig_struct__BoundaryConstraint_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BoundaryConstraint(BoundaryConstraint *ptr);
static Scheme_Object *_swig_struct_type__NoConstraint;
static const char *_swig_struct__NoConstraint_field_names[] = { 
};
#define  _swig_struct__NoConstraint_field_names_cnt (sizeof(_swig_struct__NoConstraint_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__NoConstraint(NoConstraint *ptr);
static Scheme_Object *_swig_struct_type__PositiveConstraint;
static const char *_swig_struct__PositiveConstraint_field_names[] = { 
};
#define  _swig_struct__PositiveConstraint_field_names_cnt (sizeof(_swig_struct__PositiveConstraint_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__PositiveConstraint(PositiveConstraint *ptr);

using QuantLib::EndCriteria;

static Scheme_Object *_swig_struct_type__EndCriteria;
static const char *_swig_struct__EndCriteria_field_names[] = { 
};
#define  _swig_struct__EndCriteria_field_names_cnt (sizeof(_swig_struct__EndCriteria_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__EndCriteria(EndCriteria *ptr);

using QuantLib::OptimizationMethod;
using QuantLib::ConjugateGradient;
using QuantLib::Simplex;
using QuantLib::SteepestDescent;

static Scheme_Object *_swig_struct_type__OptimizationMethod;
static const char *_swig_struct__OptimizationMethod_field_names[] = { 
};
#define  _swig_struct__OptimizationMethod_field_names_cnt (sizeof(_swig_struct__OptimizationMethod_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__OptimizationMethod(OptimizationMethod *ptr);
static Scheme_Object *_swig_struct_type__ConjugateGradient;
static const char *_swig_struct__ConjugateGradient_field_names[] = { 
};
#define  _swig_struct__ConjugateGradient_field_names_cnt (sizeof(_swig_struct__ConjugateGradient_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__ConjugateGradient(ConjugateGradient *ptr);
static Scheme_Object *_swig_struct_type__Simplex;
static const char *_swig_struct__Simplex_field_names[] = { 
};
#define  _swig_struct__Simplex_field_names_cnt (sizeof(_swig_struct__Simplex_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Simplex(Simplex *ptr);
static Scheme_Object *_swig_struct_type__SteepestDescent;
static const char *_swig_struct__SteepestDescent_field_names[] = { 
};
#define  _swig_struct__SteepestDescent_field_names_cnt (sizeof(_swig_struct__SteepestDescent_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SteepestDescent(SteepestDescent *ptr);

using QuantLib::Problem;


    class Optimizer {};

static Array Optimizer_solve(Optimizer *self,Scheme_Object *function,Constraint &c,OptimizationMethod &m){
        MzCostFunction f(function);
        Problem p(f,c,m);
        p.minimize();
        return p.minimumValue();
    }
static Scheme_Object *_swig_struct_type__Optimizer;
static const char *_swig_struct__Optimizer_field_names[] = { 
};
#define  _swig_struct__Optimizer_field_names_cnt (sizeof(_swig_struct__Optimizer_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Optimizer(Optimizer *ptr);

using QuantLib::PlainVanillaPayoff;
using QuantLib::PercentageStrikePayoff;
using QuantLib::CashOrNothingPayoff;
using QuantLib::AssetOrNothingPayoff;
using QuantLib::SuperSharePayoff;
typedef boost::shared_ptr<Payoff> PlainVanillaPayoffPtr;
typedef boost::shared_ptr<Payoff> PercentageStrikePayoffPtr;
typedef boost::shared_ptr<Payoff> CashOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> AssetOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> SuperSharePayoffPtr;

static PlainVanillaPayoffPtr *new_PlainVanillaPayoffPtr(Option::Type type,Real strike){
            return new PlainVanillaPayoffPtr(
                                        new PlainVanillaPayoff(type, strike));
        }
static Scheme_Object *_swig_struct_type__PlainVanillaPayoffPtr;
static const char *_swig_struct__PlainVanillaPayoffPtr_field_names[] = { 
};
#define  _swig_struct__PlainVanillaPayoffPtr_field_names_cnt (sizeof(_swig_struct__PlainVanillaPayoffPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__PlainVanillaPayoffPtr(PlainVanillaPayoffPtr *ptr);
static PercentageStrikePayoffPtr *new_PercentageStrikePayoffPtr(Option::Type type,Real moneyness){
            return new PercentageStrikePayoffPtr(
                                 new PercentageStrikePayoff(type, moneyness));
        }
static Scheme_Object *_swig_struct_type__PercentageStrikePayoffPtr;
static const char *_swig_struct__PercentageStrikePayoffPtr_field_names[] = { 
};
#define  _swig_struct__PercentageStrikePayoffPtr_field_names_cnt (sizeof(_swig_struct__PercentageStrikePayoffPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__PercentageStrikePayoffPtr(PercentageStrikePayoffPtr *ptr);
static CashOrNothingPayoffPtr *new_CashOrNothingPayoffPtr(Option::Type type,Real strike,Real payoff){
            return new CashOrNothingPayoffPtr(
                               new CashOrNothingPayoff(type, strike, payoff));
        }
static Scheme_Object *_swig_struct_type__CashOrNothingPayoffPtr;
static const char *_swig_struct__CashOrNothingPayoffPtr_field_names[] = { 
};
#define  _swig_struct__CashOrNothingPayoffPtr_field_names_cnt (sizeof(_swig_struct__CashOrNothingPayoffPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CashOrNothingPayoffPtr(CashOrNothingPayoffPtr *ptr);
static AssetOrNothingPayoffPtr *new_AssetOrNothingPayoffPtr(Option::Type type,Real strike){
            return new AssetOrNothingPayoffPtr(
                                      new AssetOrNothingPayoff(type, strike));
        }
static Scheme_Object *_swig_struct_type__AssetOrNothingPayoffPtr;
static const char *_swig_struct__AssetOrNothingPayoffPtr_field_names[] = { 
};
#define  _swig_struct__AssetOrNothingPayoffPtr_field_names_cnt (sizeof(_swig_struct__AssetOrNothingPayoffPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__AssetOrNothingPayoffPtr(AssetOrNothingPayoffPtr *ptr);
static SuperSharePayoffPtr *new_SuperSharePayoffPtr(Option::Type type,Real strike,Real increment){
            return new SuperSharePayoffPtr(
                               new SuperSharePayoff(type, strike, increment));
        }
static Scheme_Object *_swig_struct_type__SuperSharePayoffPtr;
static const char *_swig_struct__SuperSharePayoffPtr_field_names[] = { 
};
#define  _swig_struct__SuperSharePayoffPtr_field_names_cnt (sizeof(_swig_struct__SuperSharePayoffPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SuperSharePayoffPtr(SuperSharePayoffPtr *ptr);

using QuantLib::RateHelper;
using QuantLib::DepositRateHelper;
using QuantLib::FraRateHelper;
using QuantLib::FuturesRateHelper;
using QuantLib::SwapRateHelper;
typedef boost::shared_ptr<RateHelper> DepositRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FraRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FuturesRateHelperPtr;
typedef boost::shared_ptr<RateHelper> SwapRateHelperPtr;

static bool boost_shared_ptr_Sl_RateHelper_Sg__isNull(boost::shared_ptr<RateHelper > *self){
                return !(*self);
            }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTRateHelper_t;
static const char *_swig_struct__boost__shared_ptrTRateHelper_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTRateHelper_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTRateHelper_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTRateHelper_t(boost::shared_ptr<RateHelper > *ptr);
static DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,n,units,settlementDays,
                                      calendar, convention,dayCounter));
        }
static DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_1(Rate rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,n,units,settlementDays,
                                      calendar, convention,dayCounter));
        }
static Scheme_Object *_swig_struct_type__DepositRateHelperPtr;
static const char *_swig_struct__DepositRateHelperPtr_field_names[] = { 
};
#define  _swig_struct__DepositRateHelperPtr_field_names_cnt (sizeof(_swig_struct__DepositRateHelperPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__DepositRateHelperPtr(DepositRateHelperPtr *ptr);
static FraRateHelperPtr *new_FraRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer monthsToStart,Integer monthsToEnd,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  dayCounter));
        }
static FraRateHelperPtr *new_FraRateHelperPtr__SWIG_1(Rate rate,Integer monthsToStart,Integer monthsToEnd,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  dayCounter));
        }
static Scheme_Object *_swig_struct_type__FraRateHelperPtr;
static const char *_swig_struct__FraRateHelperPtr_field_names[] = { 
};
#define  _swig_struct__FraRateHelperPtr_field_names_cnt (sizeof(_swig_struct__FraRateHelperPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FraRateHelperPtr(FraRateHelperPtr *ptr);
static FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_0(Handle<Quote > const &price,Date const &immDate,Integer nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter));
        }
static FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_1(Real price,Date const &immDate,Integer nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter));
        }
static FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_2(Handle<Quote > const &price,Date const &immDate,Date const &matDate,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,matDate,
                                      calendar,convention,dayCounter));
        }
static Scheme_Object *_swig_struct_type__FuturesRateHelperPtr;
static const char *_swig_struct__FuturesRateHelperPtr_field_names[] = { 
};
#define  _swig_struct__FuturesRateHelperPtr_field_names_cnt (sizeof(_swig_struct__FuturesRateHelperPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__FuturesRateHelperPtr(FuturesRateHelperPtr *ptr);
static SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,Frequency floatingFrequency,BusinessDayConvention floatingConvention){
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, n, units, settlementDays,
                                   calendar, fixedFrequency, fixedConvention,
                                   fixedDayCount, floatingFrequency,
                                   floatingConvention));
        }
static SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_1(Rate rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,Frequency floatingFrequency,BusinessDayConvention floatingConvention){
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, n, units, settlementDays,
                                   calendar, fixedFrequency, fixedConvention,
                                   fixedDayCount, floatingFrequency,
                                   floatingConvention));
        }
static Scheme_Object *_swig_struct_type__SwapRateHelperPtr;
static const char *_swig_struct__SwapRateHelperPtr_field_names[] = { 
};
#define  _swig_struct__SwapRateHelperPtr_field_names_cnt (sizeof(_swig_struct__SwapRateHelperPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SwapRateHelperPtr(SwapRateHelperPtr *ptr);
static boost::shared_ptr<RateHelper > std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__pop(std::vector<boost::shared_ptr<RateHelper > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                boost::shared_ptr<RateHelper > x = self->back();
                self->pop_back();
                return x;
            }
static boost::shared_ptr<RateHelper > &std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__ref(std::vector<boost::shared_ptr<RateHelper > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__set(std::vector<boost::shared_ptr<RateHelper > > *self,int i,boost::shared_ptr<RateHelper > const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static Scheme_Object *_swig_struct_type__std__vectorTboost__shared_ptrTRateHelper_t_t;
static const char *_swig_struct__std__vectorTboost__shared_ptrTRateHelper_t_t_field_names[] = { 
};
#define  _swig_struct__std__vectorTboost__shared_ptrTRateHelper_t_t_field_names_cnt (sizeof(_swig_struct__std__vectorTboost__shared_ptrTRateHelper_t_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__std__vectorTboost__shared_ptrTRateHelper_t_t(std::vector<boost::shared_ptr<RateHelper > > *ptr);

using QuantLib::PiecewiseFlatForward;
typedef boost::shared_ptr<YieldTermStructure> PiecewiseFlatForwardPtr;

static PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_0(Date const &referenceDate,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12){
	        return new PiecewiseFlatForwardPtr(
	            new PiecewiseFlatForward(referenceDate,instruments,
                                         dayCounter,accuracy));
        }
static PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12){
	        return new PiecewiseFlatForwardPtr(
	            new PiecewiseFlatForward(settlementDays, calendar,
                                         instruments, dayCounter, accuracy));
        }
static std::vector<Date > const &PiecewiseFlatForwardPtr_dates(PiecewiseFlatForwardPtr *self){
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)
                 ->dates();
        }
static std::vector<Time > const &PiecewiseFlatForwardPtr_times(PiecewiseFlatForwardPtr *self){
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)
                 ->times();
        }
static Scheme_Object *_swig_struct_type__PiecewiseFlatForwardPtr;
static const char *_swig_struct__PiecewiseFlatForwardPtr_field_names[] = { 
};
#define  _swig_struct__PiecewiseFlatForwardPtr_field_names_cnt (sizeof(_swig_struct__PiecewiseFlatForwardPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__PiecewiseFlatForwardPtr(PiecewiseFlatForwardPtr *ptr);

using QuantLib::Settings;

static Date Settings_getEvaluationDate(Settings *self){
            return self->evaluationDate();
        }
static void Settings_setEvaluationDate(Settings *self,Date const &d){
            self->evaluationDate() = d;
        }
static Scheme_Object *_swig_struct_type__Settings;
static const char *_swig_struct__Settings_field_names[] = { 
};
#define  _swig_struct__Settings_field_names_cnt (sizeof(_swig_struct__Settings_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Settings(Settings *ptr);

using QuantLib::CalibrationHelper;
using QuantLib::SwaptionHelper;
using QuantLib::CapHelper;
typedef boost::shared_ptr<CalibrationHelper> SwaptionHelperPtr;
typedef boost::shared_ptr<CalibrationHelper> CapHelperPtr;

static bool boost_shared_ptr_Sl_CalibrationHelper_Sg__isNull(boost::shared_ptr<CalibrationHelper > *self){
                return !(*self);
            }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTCalibrationHelper_t;
static const char *_swig_struct__boost__shared_ptrTCalibrationHelper_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTCalibrationHelper_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTCalibrationHelper_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTCalibrationHelper_t(boost::shared_ptr<CalibrationHelper > *ptr);
static SwaptionHelperPtr *new_SwaptionHelperPtr(Period const &maturity,Period const &length,Handle<Quote > const &volatility,XiborPtr const &index,Frequency fixedLegFrequency,DayCounter const &fixedLegDayCounter,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new SwaptionHelperPtr(
                new SwaptionHelper(maturity,length,volatility,
                                   libor,fixedLegFrequency,
                                   fixedLegDayCounter,termStructure));
        }
static std::vector<Time > SwaptionHelperPtr_times(SwaptionHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
static Scheme_Object *_swig_struct_type__SwaptionHelperPtr;
static const char *_swig_struct__SwaptionHelperPtr_field_names[] = { 
};
#define  _swig_struct__SwaptionHelperPtr_field_names_cnt (sizeof(_swig_struct__SwaptionHelperPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SwaptionHelperPtr(SwaptionHelperPtr *ptr);
static CapHelperPtr *new_CapHelperPtr(Period const &length,Handle<Quote > const &volatility,XiborPtr const &index,Frequency fixedLegFrequency,DayCounter const &fixedLegDayCounter,bool includeFirstSwaplet,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new CapHelperPtr(
                new CapHelper(length,volatility,libor,fixedLegFrequency,
                              fixedLegDayCounter,includeFirstSwaplet,
                              termStructure));
        }
static std::vector<Time > CapHelperPtr_times(CapHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
static Scheme_Object *_swig_struct_type__CapHelperPtr;
static const char *_swig_struct__CapHelperPtr_field_names[] = { 
};
#define  _swig_struct__CapHelperPtr_field_names_cnt (sizeof(_swig_struct__CapHelperPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CapHelperPtr(CapHelperPtr *ptr);
static boost::shared_ptr<CalibrationHelper > std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__pop(std::vector<boost::shared_ptr<CalibrationHelper > > *self){
                if (self->size() == 0)
                    throw std::out_of_range("pop from empty vector");
                boost::shared_ptr<CalibrationHelper > x = self->back();
                self->pop_back();
                return x;
            }
static boost::shared_ptr<CalibrationHelper > &std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__ref(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
static void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__set(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int i,boost::shared_ptr<CalibrationHelper > const &x){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = x;
                else
                    throw std::out_of_range("vector index out of range");
            }
static Scheme_Object *_swig_struct_type__std__vectorTboost__shared_ptrTCalibrationHelper_t_t;
static const char *_swig_struct__std__vectorTboost__shared_ptrTCalibrationHelper_t_t_field_names[] = { 
};
#define  _swig_struct__std__vectorTboost__shared_ptrTCalibrationHelper_t_t_field_names_cnt (sizeof(_swig_struct__std__vectorTboost__shared_ptrTCalibrationHelper_t_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__std__vectorTboost__shared_ptrTCalibrationHelper_t_t(std::vector<boost::shared_ptr<CalibrationHelper > > *ptr);

using QuantLib::ShortRateModel;

static bool boost_shared_ptr_Sl_ShortRateModel_Sg__isNull(boost::shared_ptr<ShortRateModel > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > *boost_shared_ptr_Sl_ShortRateModel_Sg__asObservable(boost::shared_ptr<ShortRateModel > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTShortRateModel_t;
static const char *_swig_struct__boost__shared_ptrTShortRateModel_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTShortRateModel_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTShortRateModel_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTShortRateModel_t(boost::shared_ptr<ShortRateModel > *ptr);

using QuantLib::HullWhite;
using QuantLib::BlackKarasinski;
using QuantLib::G2;
typedef boost::shared_ptr<ShortRateModel> HullWhitePtr;
typedef boost::shared_ptr<ShortRateModel> BlackKarasinskiPtr;
typedef boost::shared_ptr<ShortRateModel> G2Ptr;

static HullWhitePtr *new_HullWhitePtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01){
	        return new HullWhitePtr(
	            new HullWhite(termStructure, a, sigma));
        }
static Scheme_Object *_swig_struct_type__HullWhitePtr;
static const char *_swig_struct__HullWhitePtr_field_names[] = { 
};
#define  _swig_struct__HullWhitePtr_field_names_cnt (sizeof(_swig_struct__HullWhitePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__HullWhitePtr(HullWhitePtr *ptr);
static BlackKarasinskiPtr *new_BlackKarasinskiPtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.1){
	        return new BlackKarasinskiPtr(
	            new BlackKarasinski(termStructure, a, sigma));
        }
static Scheme_Object *_swig_struct_type__BlackKarasinskiPtr;
static const char *_swig_struct__BlackKarasinskiPtr_field_names[] = { 
};
#define  _swig_struct__BlackKarasinskiPtr_field_names_cnt (sizeof(_swig_struct__BlackKarasinskiPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BlackKarasinskiPtr(BlackKarasinskiPtr *ptr);
static G2Ptr *new_G2Ptr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01,Real b=0.1,Real eta=0.01,Real rho=-0.75){
	        return new G2Ptr(new G2(termStructure, a, sigma, b, eta, rho));
        }
static Scheme_Object *_swig_struct_type__G2Ptr;
static const char *_swig_struct__G2Ptr_field_names[] = { 
};
#define  _swig_struct__G2Ptr_field_names_cnt (sizeof(_swig_struct__G2Ptr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__G2Ptr(G2Ptr *ptr);

using QuantLib::JamshidianSwaptionEngine;
using QuantLib::TreeSwaptionEngine;
using QuantLib::AnalyticCapFloorEngine;
using QuantLib::TreeCapFloorEngine;
using QuantLib::G2SwaptionEngine;
typedef boost::shared_ptr<PricingEngine> JamshidianSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> AnalyticCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> G2SwaptionEnginePtr;

static JamshidianSwaptionEnginePtr *new_JamshidianSwaptionEnginePtr(boost::shared_ptr<ShortRateModel > const &model){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new JamshidianSwaptionEnginePtr(
                                             new JamshidianSwaptionEngine(m));
        }
static Scheme_Object *_swig_struct_type__JamshidianSwaptionEnginePtr;
static const char *_swig_struct__JamshidianSwaptionEnginePtr_field_names[] = { 
};
#define  _swig_struct__JamshidianSwaptionEnginePtr_field_names_cnt (sizeof(_swig_struct__JamshidianSwaptionEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__JamshidianSwaptionEnginePtr(JamshidianSwaptionEnginePtr *ptr);
static TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps){
            return new TreeSwaptionEnginePtr(
                                     new TreeSwaptionEngine(model,timeSteps));
        }
static TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_1(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid){
            return new TreeSwaptionEnginePtr(
                                     new TreeSwaptionEngine(model,grid));
        }
static Scheme_Object *_swig_struct_type__TreeSwaptionEnginePtr;
static const char *_swig_struct__TreeSwaptionEnginePtr_field_names[] = { 
};
#define  _swig_struct__TreeSwaptionEnginePtr_field_names_cnt (sizeof(_swig_struct__TreeSwaptionEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__TreeSwaptionEnginePtr(TreeSwaptionEnginePtr *ptr);
static AnalyticCapFloorEnginePtr *new_AnalyticCapFloorEnginePtr(boost::shared_ptr<ShortRateModel > const &model){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new AnalyticCapFloorEnginePtr(
                                           new AnalyticCapFloorEngine(m));
        }
static Scheme_Object *_swig_struct_type__AnalyticCapFloorEnginePtr;
static const char *_swig_struct__AnalyticCapFloorEnginePtr_field_names[] = { 
};
#define  _swig_struct__AnalyticCapFloorEnginePtr_field_names_cnt (sizeof(_swig_struct__AnalyticCapFloorEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__AnalyticCapFloorEnginePtr(AnalyticCapFloorEnginePtr *ptr);
static TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps){
            return new TreeCapFloorEnginePtr(
                                     new TreeCapFloorEngine(model,timeSteps));
        }
static TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_1(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid){
            return new TreeCapFloorEnginePtr(
                                     new TreeCapFloorEngine(model,grid));
        }
static Scheme_Object *_swig_struct_type__TreeCapFloorEnginePtr;
static const char *_swig_struct__TreeCapFloorEnginePtr_field_names[] = { 
};
#define  _swig_struct__TreeCapFloorEnginePtr_field_names_cnt (sizeof(_swig_struct__TreeCapFloorEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__TreeCapFloorEnginePtr(TreeCapFloorEnginePtr *ptr);
static G2SwaptionEnginePtr *new_G2SwaptionEnginePtr(boost::shared_ptr<ShortRateModel > const &model,Real range,Size intervals){
            boost::shared_ptr<G2> g2 =
                boost::dynamic_pointer_cast<G2>(model);
            return new G2SwaptionEnginePtr(
                                    new G2SwaptionEngine(g2,range,intervals));
        }
static Scheme_Object *_swig_struct_type__G2SwaptionEnginePtr;
static const char *_swig_struct__G2SwaptionEnginePtr_field_names[] = { 
};
#define  _swig_struct__G2SwaptionEnginePtr_field_names_cnt (sizeof(_swig_struct__G2SwaptionEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__G2SwaptionEnginePtr(G2SwaptionEnginePtr *ptr);

using QuantLib::Statistics;
using QuantLib::RiskStatistics;
using QuantLib::SequenceStatistics;

static void Statistics_add__SWIG_2(Statistics *self,std::vector<Real > const &values){
            self->addSequence(values.begin(), values.end());
        }
static void Statistics_add__SWIG_3(Statistics *self,std::vector<Real > const &values,std::vector<Real > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }
static Scheme_Object *_swig_struct_type__Statistics;
static const char *_swig_struct__Statistics_field_names[] = { 
};
#define  _swig_struct__Statistics_field_names_cnt (sizeof(_swig_struct__Statistics_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__Statistics(Statistics *ptr);
static Scheme_Object *_swig_struct_type__RiskStatistics;
static const char *_swig_struct__RiskStatistics_field_names[] = { 
};
#define  _swig_struct__RiskStatistics_field_names_cnt (sizeof(_swig_struct__RiskStatistics_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__RiskStatistics(RiskStatistics *ptr);
static Scheme_Object *_swig_struct_type__SequenceStatisticsTStatistics_t;
static const char *_swig_struct__SequenceStatisticsTStatistics_t_field_names[] = { 
};
#define  _swig_struct__SequenceStatisticsTStatistics_t_field_names_cnt (sizeof(_swig_struct__SequenceStatisticsTStatistics_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SequenceStatisticsTStatistics_t(SequenceStatistics<Statistics > *ptr);

using QuantLib::TimeBasket;

static Scheme_Object *_swig_struct_type__TimeBasket;
static const char *_swig_struct__TimeBasket_field_names[] = { 
};
#define  _swig_struct__TimeBasket_field_names_cnt (sizeof(_swig_struct__TimeBasket_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__TimeBasket(TimeBasket *ptr);

using QuantLib::Swap;
using QuantLib::SimpleSwap;
typedef boost::shared_ptr<Instrument> SwapPtr;
typedef boost::shared_ptr<Instrument> SimpleSwapPtr;

static SwapPtr *new_SwapPtr(std::vector<boost::shared_ptr<CashFlow > > const &firstLeg,std::vector<boost::shared_ptr<CashFlow > > const &secondLeg,Handle<YieldTermStructure > const &termStructure){
            return new SwapPtr(new Swap(firstLeg, secondLeg,
                                        termStructure));
        }
static Date SwapPtr_startDate(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->startDate();
        }
static Date SwapPtr_maturity(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->maturity();
        }
static Real SwapPtr_firstLegBPS(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->firstLegBPS();
        }
static Real SwapPtr_secondLegBPS(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->secondLegBPS();
        }
static TimeBasket SwapPtr_sensitivity(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->sensitivity();
        }
static Scheme_Object *_swig_struct_type__SwapPtr;
static const char *_swig_struct__SwapPtr_field_names[] = { 
};
#define  _swig_struct__SwapPtr_field_names_cnt (sizeof(_swig_struct__SwapPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SwapPtr(SwapPtr *ptr);
static SimpleSwapPtr *new_SimpleSwapPtr(bool payFixedRate,Real nominal,Schedule const &fixedSchedule,Rate fixedRate,DayCounter const &fixedDayCount,Schedule const &floatSchedule,XiborPtr const &index,Integer indexFixingDays,Spread spread,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new SimpleSwapPtr(
                new SimpleSwap(payFixedRate,nominal,fixedSchedule,fixedRate,
                               fixedDayCount,floatSchedule,libor,
                               indexFixingDays,spread,termStructure));
        }
static Rate SimpleSwapPtr_fairRate(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)->fairRate();
        }
static Spread SimpleSwapPtr_fairSpread(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->fairSpread();
        }
static Real SimpleSwapPtr_fixedLegBPS(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->fixedLegBPS();
        }
static Real SimpleSwapPtr_floatingLegBPS(SimpleSwapPtr *self){
            return boost::dynamic_pointer_cast<SimpleSwap>(*self)
                 ->floatingLegBPS();
        }
static Scheme_Object *_swig_struct_type__SimpleSwapPtr;
static const char *_swig_struct__SimpleSwapPtr_field_names[] = { 
};
#define  _swig_struct__SimpleSwapPtr_field_names_cnt (sizeof(_swig_struct__SimpleSwapPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SimpleSwapPtr(SimpleSwapPtr *ptr);

using QuantLib::Swaption;
typedef boost::shared_ptr<Instrument> SwaptionPtr;

static SwaptionPtr *new_SwaptionPtr(boost::shared_ptr<Instrument > const &simpleSwap,boost::shared_ptr<Exercise > const &exercise,Handle<YieldTermStructure > const &termStructure,boost::shared_ptr<PricingEngine > const &engine){
            boost::shared_ptr<SimpleSwap> swap =
                 boost::dynamic_pointer_cast<SimpleSwap>(simpleSwap);
            QL_REQUIRE(swap, "simple swap required");
            return new SwaptionPtr(new Swaption(swap,exercise,
                                                termStructure,engine));
        }
static Scheme_Object *_swig_struct_type__SwaptionPtr;
static const char *_swig_struct__SwaptionPtr_field_names[] = { 
};
#define  _swig_struct__SwaptionPtr_field_names_cnt (sizeof(_swig_struct__SwaptionPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SwaptionPtr(SwaptionPtr *ptr);

using QuantLib::BlackSwaptionEngine;
typedef boost::shared_ptr<PricingEngine> BlackSwaptionEnginePtr;

static BlackSwaptionEnginePtr *new_BlackSwaptionEnginePtr(boost::shared_ptr<BlackModel > const &model){
            return new BlackSwaptionEnginePtr(new BlackSwaptionEngine(model));
        }
static Scheme_Object *_swig_struct_type__BlackSwaptionEnginePtr;
static const char *_swig_struct__BlackSwaptionEnginePtr_field_names[] = { 
};
#define  _swig_struct__BlackSwaptionEnginePtr_field_names_cnt (sizeof(_swig_struct__BlackSwaptionEnginePtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__BlackSwaptionEnginePtr(BlackSwaptionEnginePtr *ptr);

using QuantLib::DiscreteGeometricASO;

static Scheme_Object *_swig_struct_type__DiscreteGeometricASO;
static const char *_swig_struct__DiscreteGeometricASO_field_names[] = { 
};
#define  _swig_struct__DiscreteGeometricASO_field_names_cnt (sizeof(_swig_struct__DiscreteGeometricASO_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__DiscreteGeometricASO(DiscreteGeometricASO *ptr);

// single asset
using QuantLib::McDiscreteArithmeticASO;

// multi asset
using QuantLib::McMaxBasket;
using QuantLib::McEverest;
using QuantLib::McHimalaya;
using QuantLib::McPagoda;

static Scheme_Object *_swig_struct_type__McDiscreteArithmeticASO;
static const char *_swig_struct__McDiscreteArithmeticASO_field_names[] = { 
};
#define  _swig_struct__McDiscreteArithmeticASO_field_names_cnt (sizeof(_swig_struct__McDiscreteArithmeticASO_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__McDiscreteArithmeticASO(McDiscreteArithmeticASO *ptr);
static Scheme_Object *_swig_struct_type__McMaxBasket;
static const char *_swig_struct__McMaxBasket_field_names[] = { 
};
#define  _swig_struct__McMaxBasket_field_names_cnt (sizeof(_swig_struct__McMaxBasket_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__McMaxBasket(McMaxBasket *ptr);
static Scheme_Object *_swig_struct_type__McHimalaya;
static const char *_swig_struct__McHimalaya_field_names[] = { 
};
#define  _swig_struct__McHimalaya_field_names_cnt (sizeof(_swig_struct__McHimalaya_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__McHimalaya(McHimalaya *ptr);
static Scheme_Object *_swig_struct_type__McEverest;
static const char *_swig_struct__McEverest_field_names[] = { 
};
#define  _swig_struct__McEverest_field_names_cnt (sizeof(_swig_struct__McEverest_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__McEverest(McEverest *ptr);
static Scheme_Object *_swig_struct_type__McPagoda;
static const char *_swig_struct__McPagoda_field_names[] = { 
};
#define  _swig_struct__McPagoda_field_names_cnt (sizeof(_swig_struct__McPagoda_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__McPagoda(McPagoda *ptr);

using QuantLib::SwaptionVolatilityStructure;

static bool boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__isNull(boost::shared_ptr<SwaptionVolatilityStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > *boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__asObservable(boost::shared_ptr<SwaptionVolatilityStructure > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTSwaptionVolatilityStructure_t;
static const char *_swig_struct__boost__shared_ptrTSwaptionVolatilityStructure_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTSwaptionVolatilityStructure_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTSwaptionVolatilityStructure_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTSwaptionVolatilityStructure_t(boost::shared_ptr<SwaptionVolatilityStructure > *ptr);
static boost::shared_ptr<Observable > *Handle_Sl_SwaptionVolatilityStructure_Sg__asObservable(Handle<SwaptionVolatilityStructure > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__HandleTSwaptionVolatilityStructure_t;
static const char *_swig_struct__HandleTSwaptionVolatilityStructure_t_field_names[] = { 
};
#define  _swig_struct__HandleTSwaptionVolatilityStructure_t_field_names_cnt (sizeof(_swig_struct__HandleTSwaptionVolatilityStructure_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__HandleTSwaptionVolatilityStructure_t(Handle<SwaptionVolatilityStructure > *ptr);

using QuantLib::SwaptionVolatilityMatrix;
typedef boost::shared_ptr<SwaptionVolatilityStructure>
    SwaptionVolatilityMatrixPtr;

static SwaptionVolatilityMatrixPtr *new_SwaptionVolatilityMatrixPtr(Date const &referenceDate,std::vector<Date > const &dates,std::vector<Period > const &lengths,Matrix const &vols,DayCounter const &dayCounter){
            return new SwaptionVolatilityMatrixPtr(
                new SwaptionVolatilityMatrix(referenceDate,dates,lengths,
                                             vols,dayCounter));
        }
static Scheme_Object *_swig_struct_type__SwaptionVolatilityMatrixPtr;
static const char *_swig_struct__SwaptionVolatilityMatrixPtr_field_names[] = { 
};
#define  _swig_struct__SwaptionVolatilityMatrixPtr_field_names_cnt (sizeof(_swig_struct__SwaptionVolatilityMatrixPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__SwaptionVolatilityMatrixPtr(SwaptionVolatilityMatrixPtr *ptr);

using QuantLib::CapVolatilityStructure;

static bool boost_shared_ptr_Sl_CapVolatilityStructure_Sg__isNull(boost::shared_ptr<CapVolatilityStructure > *self){
                return !(*self);
            }
static boost::shared_ptr<Observable > *boost_shared_ptr_Sl_CapVolatilityStructure_Sg__asObservable(boost::shared_ptr<CapVolatilityStructure > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__boost__shared_ptrTCapVolatilityStructure_t;
static const char *_swig_struct__boost__shared_ptrTCapVolatilityStructure_t_field_names[] = { 
};
#define  _swig_struct__boost__shared_ptrTCapVolatilityStructure_t_field_names_cnt (sizeof(_swig_struct__boost__shared_ptrTCapVolatilityStructure_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__boost__shared_ptrTCapVolatilityStructure_t(boost::shared_ptr<CapVolatilityStructure > *ptr);
static boost::shared_ptr<Observable > *Handle_Sl_CapVolatilityStructure_Sg__asObservable(Handle<CapVolatilityStructure > *self){
        return new boost::shared_ptr<Observable>(*self);
    }
static Scheme_Object *_swig_struct_type__HandleTCapVolatilityStructure_t;
static const char *_swig_struct__HandleTCapVolatilityStructure_t_field_names[] = { 
};
#define  _swig_struct__HandleTCapVolatilityStructure_t_field_names_cnt (sizeof(_swig_struct__HandleTCapVolatilityStructure_t_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__HandleTCapVolatilityStructure_t(Handle<CapVolatilityStructure > *ptr);

using QuantLib::CapVolatilityVector;
typedef boost::shared_ptr<CapVolatilityStructure> CapVolatilityVectorPtr;

static CapVolatilityVectorPtr *new_CapVolatilityVectorPtr__SWIG_0(Date const &referenceDate,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,DayCounter const &dayCounter){
            return new CapVolatilityVectorPtr(
                new CapVolatilityVector(referenceDate,lengths,
                                        vols,dayCounter));
        }
static CapVolatilityVectorPtr *new_CapVolatilityVectorPtr__SWIG_1(Integer settlementDays,Calendar const &calendar,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,DayCounter const &dayCounter){
            return new CapVolatilityVectorPtr(
                new CapVolatilityVector(settlementDays,calendar,
                                        lengths,vols,dayCounter));
        }
static Scheme_Object *_swig_struct_type__CapVolatilityVectorPtr;
static const char *_swig_struct__CapVolatilityVectorPtr_field_names[] = { 
};
#define  _swig_struct__CapVolatilityVectorPtr_field_names_cnt (sizeof(_swig_struct__CapVolatilityVectorPtr_field_names)/sizeof(char*))
static Scheme_Object *_swig_convert_struct__CapVolatilityVectorPtr(CapVolatilityVectorPtr *ptr);
static Scheme_Object *_wrap_Observable___deref__ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Observable---deref--"
    boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
    Observable *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<Observable > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTObservable_t, 1, 0);
    }
    {
        try {
            result = (Observable *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Observable, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Observable_nullq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Observable-null?"
    boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<Observable > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTObservable_t, 1, 0);
    }
    {
        try {
            result = (bool)boost_shared_ptr_Sl_Observable_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Observable (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Observable"
    boost::shared_ptr<Observable > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (boost::shared_ptr<Observable > *)new boost::shared_ptr<Observable >();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_boost__shared_ptrTObservable_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Observable (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Observable"
    boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<Observable > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTObservable_t, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__boost__shared_ptrTObservable_t(boost::shared_ptr<Observable > *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__boost__shared_ptrTObservable_t_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__boost__shared_ptrTObservable_t, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Observer (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Observer"
    Scheme_Object *arg1 = (Scheme_Object *) 0 ;
    MzObserver *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    arg1=argv[0];
    {
        try {
            result = (MzObserver *)new MzObserver(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_MzObserver, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Observer_registerswith___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Observer-register-with"
    MzObserver *arg1 = (MzObserver *) 0 ;
    boost::shared_ptr<Observable > *arg2 = 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (MzObserver *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_MzObserver, 1, 0);
    }
    {
        arg2 = (boost::shared_ptr<Observable > *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_boost__shared_ptrTObservable_t, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            (arg1)->registerWith((boost::shared_ptr<Observable > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Observer_unregisterswith___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Observer-unregister-with"
    MzObserver *arg1 = (MzObserver *) 0 ;
    boost::shared_ptr<Observable > *arg2 = 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (MzObserver *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_MzObserver, 1, 0);
    }
    {
        arg2 = (boost::shared_ptr<Observable > *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_boost__shared_ptrTObservable_t, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            (arg1)->unregisterWith((boost::shared_ptr<Observable > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Observer (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Observer"
    MzObserver *arg1 = (MzObserver *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (MzObserver *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_MzObserver, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__MzObserver(MzObserver *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__MzObserver_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__MzObserver, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Array__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Array"
    Array *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (Array *)new Array();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Array, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Array__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Array"
    Size arg1 ;
    Real arg2 ;
    Array *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (Array *)new Array(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Array, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Array__SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Array"
    Size arg1 ;
    Array *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (Array *)new Array(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Array, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Array__SWIG_3 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Array"
    Array *arg1 = 0 ;
    Array *result;
    Array temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        try {
            result = (Array *)new Array((Array const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Array, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_Array(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_Array__SWIG_0(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_Array__SWIG_2(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (SCHEME_VECTORP(argv[0])) {
                _v = 1;
                /* wrapped Array? */
            } else {
                Array* v;
                _v = (SWIG_ConvertPtr(argv[0],(void **) &v,SWIGTYPE_p_Array,0) != -1) ?
                1 : 0;
            }
        }
        if (_v) {
            return _wrap_new_Array__SWIG_3(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_Array__SWIG_1(argc,argv);
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_Array'");
}


static Scheme_Object *_wrap_Array_length (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Array-length"
    Array *arg1 = (Array *) 0 ;
    Size result;
    Array temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        try {
            result = ((Array const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value_from_unsigned(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Array_gstring___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Array->string"
    Array *arg1 = (Array *) 0 ;
    std::string result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Array *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Array, 1, 0);
    }
    {
        try {
            result = Array___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string((&result)->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Array_ref (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Array-ref"
    Array *arg1 = (Array *) 0 ;
    Size arg2 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Array *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Array, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            result = (Real)Array_ref(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Array_setN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Array-set!"
    Array *arg1 = (Array *) 0 ;
    Size arg2 ;
    Real arg3 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Array *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Array, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        if (!SCHEME_REALP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"real", 3 - 1, argc, argv);
        arg3 = scheme_real_to_double(argv[2]);
    }
    {
        try {
            Array_set(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Array (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Array"
    Array *arg1 = (Array *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Array *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Array, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__Array(Array *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__Array_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__Array, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Arraya___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Array+"
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Array result;
    Array temp1 ;
    Array temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size size = SCHEME_VEC_SIZE(argv[1]);
            temp2 = Array(size);
            arg2 = &temp2;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp2[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                2, argc, argv);
            }
        } else {
            arg2 = (Array *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Array,2,0);
        }
    }
    {
        try {
            result = Array_add((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Array, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Arrays___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Array-"
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Array result;
    Array temp1 ;
    Array temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size size = SCHEME_VEC_SIZE(argv[1]);
            temp2 = Array(size);
            arg2 = &temp2;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp2[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                2, argc, argv);
            }
        } else {
            arg2 = (Array *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Array,2,0);
        }
    }
    {
        try {
            result = Array_sub((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Array, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Arrayd___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Array/"
    Array *arg1 = 0 ;
    Real arg2 ;
    Array result;
    Array temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = Array_div((Array const &)*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Array, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Arraym_____SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Array*"
    Array *arg1 = 0 ;
    Real arg2 ;
    Array result;
    Array temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = Array_mul((Array const &)*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Array, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Arraym_____SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Array*"
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Real result;
    Array temp1 ;
    Array temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size size = SCHEME_VEC_SIZE(argv[1]);
            temp2 = Array(size);
            arg2 = &temp2;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp2[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                2, argc, argv);
            }
        } else {
            arg2 = (Array *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Array,2,0);
        }
    }
    {
        try {
            result = (Real)Array_mul((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Arraym_____SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Array*"
    Array *arg1 = 0 ;
    Matrix *arg2 = 0 ;
    Array result;
    Array temp1 ;
    Matrix temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[1]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        2, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp2[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        2, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    2, argc, argv);
                }
            }
        } else {
            arg2 = (Matrix *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Matrix,2,0);
        }
    }
    {
        try {
            result = Array_mul((Array const &)*arg1,(Matrix const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Array, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_Arraym___(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            /* native sequence? */
            if (SCHEME_VECTORP(argv[0])) {
                _v = 1;
                /* wrapped Array? */
            } else {
                Array* v;
                _v = (SWIG_ConvertPtr(argv[0],(void **) &v,SWIGTYPE_p_Array,0) != -1) ?
                1 : 0;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Arraym_____SWIG_0(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            /* native sequence? */
            if (SCHEME_VECTORP(argv[0])) {
                _v = 1;
                /* wrapped Array? */
            } else {
                Array* v;
                _v = (SWIG_ConvertPtr(argv[0],(void **) &v,SWIGTYPE_p_Array,0) != -1) ?
                1 : 0;
            }
        }
        if (_v) {
            {
                /* native sequence? */
                if (SCHEME_VECTORP(argv[1])) {
                    _v = 1;
                    /* wrapped Array? */
                } else {
                    Array* v;
                    _v = (SWIG_ConvertPtr(argv[1],(void **) &v,SWIGTYPE_p_Array,0) != -1) ?
                    1 : 0;
                }
            }
            if (_v) {
                return _wrap_Arraym_____SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            /* native sequence? */
            if (SCHEME_VECTORP(argv[0])) {
                _v = 1;
                /* wrapped Array? */
            } else {
                Array* v;
                _v = (SWIG_ConvertPtr(argv[0],(void **) &v,SWIGTYPE_p_Array,0) != -1) ?
                1 : 0;
            }
        }
        if (_v) {
            {
                /* native sequence? */
                if (SCHEME_VECTORP(argv[1])) {
                    _v = 1;
                    /* wrapped Matrix? */
                } else {
                    Matrix* m;
                    _v = (SWIG_ConvertPtr(argv[1],(void **) &m,SWIGTYPE_p_Matrix,0) != -1) ?
                    1 : 0;
                }
            }
            if (_v) {
                return _wrap_Arraym_____SWIG_2(argc,argv);
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'Array*'");
}


static Scheme_Object *_wrap_LexicographicalView_xSize (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "LexicographicalView-xSize"
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (LexicographicalView *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_LexicographicalView, 1, 0);
    }
    {
        try {
            result = ((LexicographicalView const *)arg1)->xSize();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value_from_unsigned(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_LexicographicalView_ySize (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "LexicographicalView-ySize"
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (LexicographicalView *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_LexicographicalView, 1, 0);
    }
    {
        try {
            result = ((LexicographicalView const *)arg1)->ySize();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value_from_unsigned(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_LexicographicalView (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-LexicographicalView"
    Array *arg1 = 0 ;
    Size arg2 ;
    LexicographicalView *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Array *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Array, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            result = (LexicographicalView *)new_LexicographicalView(*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_LexicographicalView, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_LexicographicalView_gstring___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "LexicographicalView->string"
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    std::string result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (LexicographicalView *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_LexicographicalView, 1, 0);
    }
    {
        try {
            result = LexicographicalView___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string((&result)->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_LexicographicalView_ref (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "LexicographicalView-ref"
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size arg2 ;
    Size arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (LexicographicalView *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_LexicographicalView, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        if (!SCHEME_INTP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"integer", 3 - 1, argc, argv);
        arg3 = SCHEME_INT_VAL(argv[2]);
    }
    {
        try {
            result = (Real)LexicographicalView_ref(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_LexicographicalView_setN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "LexicographicalView-set!"
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    Size arg2 ;
    Size arg3 ;
    Real arg4 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (LexicographicalView *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_LexicographicalView, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        if (!SCHEME_INTP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"integer", 3 - 1, argc, argv);
        arg3 = SCHEME_INT_VAL(argv[2]);
    }
    {
        if (!SCHEME_REALP(argv[3]))
        scheme_wrong_type(FUNC_NAME,"real", 4 - 1, argc, argv);
        arg4 = scheme_real_to_double(argv[3]);
    }
    {
        try {
            LexicographicalView_set(arg1,arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_LexicographicalView (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-LexicographicalView"
    LexicographicalView *arg1 = (LexicographicalView *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (LexicographicalView *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_LexicographicalView, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__LexicographicalView(LexicographicalView *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__LexicographicalView_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__LexicographicalView, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Matrix__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Matrix"
    Matrix *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (Matrix *)new Matrix();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Matrix, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Matrix__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Matrix"
    Size arg1 ;
    Size arg2 ;
    Real arg3 ;
    Matrix *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        if (!SCHEME_REALP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"real", 3 - 1, argc, argv);
        arg3 = scheme_real_to_double(argv[2]);
    }
    {
        try {
            result = (Matrix *)new Matrix(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Matrix, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Matrix__SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Matrix"
    Size arg1 ;
    Size arg2 ;
    Matrix *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            result = (Matrix *)new Matrix(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Matrix, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Matrix__SWIG_3 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Matrix"
    Matrix *arg1 = 0 ;
    Matrix *result;
    Matrix temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[0]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp1[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    1, argc, argv);
                }
            }
        } else {
            arg1 = (Matrix *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Matrix,1,0);
        }
    }
    {
        try {
            result = (Matrix *)new Matrix((Matrix const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Matrix, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_Matrix(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_Matrix__SWIG_0(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (SCHEME_VECTORP(argv[0])) {
                _v = 1;
                /* wrapped Matrix? */
            } else {
                Matrix* m;
                _v = (SWIG_ConvertPtr(argv[0],(void **) &m,SWIGTYPE_p_Matrix,0) != -1) ?
                1 : 0;
            }
        }
        if (_v) {
            return _wrap_new_Matrix__SWIG_3(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (SCHEME_INTP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_Matrix__SWIG_2(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (SCHEME_INTP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_REALP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_Matrix__SWIG_1(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_Matrix'");
}


static Scheme_Object *_wrap_Matrix_rows (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Matrix-rows"
    Matrix *arg1 = (Matrix *) 0 ;
    Size result;
    Matrix temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[0]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp1[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    1, argc, argv);
                }
            }
        } else {
            arg1 = (Matrix *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Matrix,1,0);
        }
    }
    {
        try {
            result = ((Matrix const *)arg1)->rows();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value_from_unsigned(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Matrix_columns (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Matrix-columns"
    Matrix *arg1 = (Matrix *) 0 ;
    Size result;
    Matrix temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[0]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp1[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    1, argc, argv);
                }
            }
        } else {
            arg1 = (Matrix *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Matrix,1,0);
        }
    }
    {
        try {
            result = ((Matrix const *)arg1)->columns();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value_from_unsigned(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Matrix_gstring___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Matrix->string"
    Matrix *arg1 = (Matrix *) 0 ;
    std::string result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Matrix *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Matrix, 1, 0);
    }
    {
        try {
            result = Matrix___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string((&result)->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Matrix_ref (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Matrix-ref"
    Matrix *arg1 = (Matrix *) 0 ;
    Size arg2 ;
    Size arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Matrix *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Matrix, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        if (!SCHEME_INTP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"integer", 3 - 1, argc, argv);
        arg3 = SCHEME_INT_VAL(argv[2]);
    }
    {
        try {
            result = (Real)Matrix_ref(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Matrix_setN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Matrix-set!"
    Matrix *arg1 = (Matrix *) 0 ;
    Size arg2 ;
    Size arg3 ;
    Real arg4 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Matrix *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Matrix, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        if (!SCHEME_INTP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"integer", 3 - 1, argc, argv);
        arg3 = SCHEME_INT_VAL(argv[2]);
    }
    {
        if (!SCHEME_REALP(argv[3]))
        scheme_wrong_type(FUNC_NAME,"real", 4 - 1, argc, argv);
        arg4 = scheme_real_to_double(argv[3]);
    }
    {
        try {
            Matrix_setitem(arg1,arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Matrix (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Matrix"
    Matrix *arg1 = (Matrix *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Matrix *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Matrix, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__Matrix(Matrix *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__Matrix_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__Matrix, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Matrixa___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Matrix+"
    Matrix *arg1 = 0 ;
    Matrix *arg2 = 0 ;
    Matrix result;
    Matrix temp1 ;
    Matrix temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[0]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp1[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    1, argc, argv);
                }
            }
        } else {
            arg1 = (Matrix *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Matrix,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[1]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        2, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp2[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        2, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    2, argc, argv);
                }
            }
        } else {
            arg2 = (Matrix *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Matrix,2,0);
        }
    }
    {
        try {
            result = Matrix_add((Matrix const &)*arg1,(Matrix const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Matrixs___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Matrix-"
    Matrix *arg1 = 0 ;
    Matrix *arg2 = 0 ;
    Matrix result;
    Matrix temp1 ;
    Matrix temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[0]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp1[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    1, argc, argv);
                }
            }
        } else {
            arg1 = (Matrix *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Matrix,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[1]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        2, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp2[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        2, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    2, argc, argv);
                }
            }
        } else {
            arg2 = (Matrix *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Matrix,2,0);
        }
    }
    {
        try {
            result = Matrix_sub((Matrix const &)*arg1,(Matrix const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Matrixd___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Matrix/"
    Matrix *arg1 = 0 ;
    Real arg2 ;
    Matrix result;
    Matrix temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[0]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp1[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    1, argc, argv);
                }
            }
        } else {
            arg1 = (Matrix *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Matrix,1,0);
        }
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = Matrix_div((Matrix const &)*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Matrixm_____SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Matrix*"
    Matrix *arg1 = 0 ;
    Real arg2 ;
    Matrix result;
    Matrix temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[0]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp1[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    1, argc, argv);
                }
            }
        } else {
            arg1 = (Matrix *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Matrix,1,0);
        }
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = Matrix_mul((Matrix const &)*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Matrixm_____SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Matrix*"
    Matrix *arg1 = 0 ;
    Array *arg2 = 0 ;
    Array result;
    Matrix temp1 ;
    Array temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[0]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp1[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    1, argc, argv);
                }
            }
        } else {
            arg1 = (Matrix *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Matrix,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size size = SCHEME_VEC_SIZE(argv[1]);
            temp2 = Array(size);
            arg2 = &temp2;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp2[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                2, argc, argv);
            }
        } else {
            arg2 = (Array *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Array,2,0);
        }
    }
    {
        try {
            result = Matrix_mul((Matrix const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Array * resultptr;
        resultptr = new Array((Array &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Array, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Matrixm_____SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Matrix*"
    Matrix *arg1 = 0 ;
    Matrix *arg2 = 0 ;
    Matrix result;
    Matrix temp1 ;
    Matrix temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[0]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp1[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    1, argc, argv);
                }
            }
        } else {
            arg1 = (Matrix *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Matrix,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[1]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp2 = Matrix(rows,cols);
            arg2 = &temp2;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        2, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp2[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        2, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    2, argc, argv);
                }
            }
        } else {
            arg2 = (Matrix *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Matrix,2,0);
        }
    }
    {
        try {
            result = Matrix_mul((Matrix const &)*arg1,(Matrix const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_Matrixm___(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            /* native sequence? */
            if (SCHEME_VECTORP(argv[0])) {
                _v = 1;
                /* wrapped Matrix? */
            } else {
                Matrix* m;
                _v = (SWIG_ConvertPtr(argv[0],(void **) &m,SWIGTYPE_p_Matrix,0) != -1) ?
                1 : 0;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_Matrixm_____SWIG_0(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            /* native sequence? */
            if (SCHEME_VECTORP(argv[0])) {
                _v = 1;
                /* wrapped Matrix? */
            } else {
                Matrix* m;
                _v = (SWIG_ConvertPtr(argv[0],(void **) &m,SWIGTYPE_p_Matrix,0) != -1) ?
                1 : 0;
            }
        }
        if (_v) {
            {
                /* native sequence? */
                if (SCHEME_VECTORP(argv[1])) {
                    _v = 1;
                    /* wrapped Array? */
                } else {
                    Array* v;
                    _v = (SWIG_ConvertPtr(argv[1],(void **) &v,SWIGTYPE_p_Array,0) != -1) ?
                    1 : 0;
                }
            }
            if (_v) {
                return _wrap_Matrixm_____SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            /* native sequence? */
            if (SCHEME_VECTORP(argv[0])) {
                _v = 1;
                /* wrapped Matrix? */
            } else {
                Matrix* m;
                _v = (SWIG_ConvertPtr(argv[0],(void **) &m,SWIGTYPE_p_Matrix,0) != -1) ?
                1 : 0;
            }
        }
        if (_v) {
            {
                /* native sequence? */
                if (SCHEME_VECTORP(argv[1])) {
                    _v = 1;
                    /* wrapped Matrix? */
                } else {
                    Matrix* m;
                    _v = (SWIG_ConvertPtr(argv[1],(void **) &m,SWIGTYPE_p_Matrix,0) != -1) ?
                    1 : 0;
                }
            }
            if (_v) {
                return _wrap_Matrixm_____SWIG_2(argc,argv);
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'Matrix*'");
}


static Scheme_Object *_wrap_SalvagingAlgorithm_None(int argc, Scheme_Object** argv) {
#define FUNC_NAME "SalvagingAlgorithm-None"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_SalvagingAlgorithm_None);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_SalvagingAlgorithm_Spectral(int argc, Scheme_Object** argv) {
#define FUNC_NAME "SalvagingAlgorithm-Spectral"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_SalvagingAlgorithm_Spectral);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_SalvagingAlgorithm_Hypersphere(int argc, Scheme_Object** argv) {
#define FUNC_NAME "SalvagingAlgorithm-Hypersphere"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_SalvagingAlgorithm_Hypersphere);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_SalvagingAlgorithm (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-SalvagingAlgorithm"
    SalvagingAlgorithm *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (SalvagingAlgorithm *)new SalvagingAlgorithm();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_SalvagingAlgorithm, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_SalvagingAlgorithm (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-SalvagingAlgorithm"
    SalvagingAlgorithm *arg1 = (SalvagingAlgorithm *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SalvagingAlgorithm *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SalvagingAlgorithm, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__SalvagingAlgorithm(SalvagingAlgorithm *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__SalvagingAlgorithm_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__SalvagingAlgorithm, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Matrixstranspose___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Matrix-transpose"
    Matrix *arg1 = 0 ;
    Matrix result;
    Matrix temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[0]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp1[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    1, argc, argv);
                }
            }
        } else {
            arg1 = (Matrix *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Matrix,1,0);
        }
    }
    {
        try {
            result = transpose((Matrix const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Arraysoutersproduct___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Array-outer-product"
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix result;
    Array temp1 ;
    Array temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size size = SCHEME_VEC_SIZE(argv[1]);
            temp2 = Array(size);
            arg2 = &temp2;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp2[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                2, argc, argv);
            }
        } else {
            arg2 = (Array *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Array,2,0);
        }
    }
    {
        try {
            result = outerProduct((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Matrixspseudossqrt___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Matrix-pseudo-sqrt"
    Matrix *arg1 = 0 ;
    SalvagingAlgorithm::Type arg2 ;
    Matrix result;
    Matrix temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[0]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp1[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    1, argc, argv);
                }
            }
        } else {
            arg1 = (Matrix *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Matrix,1,0);
        }
    }
    {
        if (!SCHEME_INTP(argv[1])) 
        scheme_wrong_type(FUNC_NAME, "integer", 2 - 1, argc, argv);
        arg2 = (SalvagingAlgorithm::Type) SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            result = pseudoSqrt((Matrix const &)*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_SVD (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-SVD"
    Matrix *arg1 = 0 ;
    SVD *result;
    Matrix temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[0]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp1 = Matrix(rows,cols);
            arg1 = &temp1;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp1[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        1, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    1, argc, argv);
                }
            }
        } else {
            arg1 = (Matrix *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Matrix,1,0);
        }
    }
    {
        try {
            result = (SVD *)new SVD((Matrix const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_SVD, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_SVD_U (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "SVD-U"
    SVD *arg1 = (SVD *) 0 ;
    Matrix *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SVD *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SVD, 1, 0);
    }
    {
        try {
            {
                Matrix const &_result_ref = ((SVD const *)arg1)->U();
                result = (Matrix *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Matrix, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_SVD_V (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "SVD-V"
    SVD *arg1 = (SVD *) 0 ;
    Matrix *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SVD *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SVD, 1, 0);
    }
    {
        try {
            {
                Matrix const &_result_ref = ((SVD const *)arg1)->V();
                result = (Matrix *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Matrix, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_SVD_S (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "SVD-S"
    SVD *arg1 = (SVD *) 0 ;
    Matrix result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SVD *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SVD, 1, 0);
    }
    {
        try {
            result = ((SVD const *)arg1)->S();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Matrix * resultptr;
        resultptr = new Matrix((Matrix &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Matrix, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_SVD_singularValues (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "SVD-singularValues"
    SVD *arg1 = (SVD *) 0 ;
    Array *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SVD *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SVD, 1, 0);
    }
    {
        try {
            {
                Array const &_result_ref = ((SVD const *)arg1)->singularValues();
                result = (Array *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Array, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_SVD (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-SVD"
    SVD *arg1 = (SVD *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SVD *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SVD, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__SVD(SVD *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__SVD_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__SVD, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Quote___deref__ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Quote---deref--"
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    Quote *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTQuote_t, 1, 0);
    }
    {
        try {
            result = (Quote *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Quote, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Quote_nullq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Quote-null?"
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTQuote_t, 1, 0);
    }
    {
        try {
            result = (bool)boost_shared_ptr_Sl_Quote_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Quote_gObservable___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Quote->Observable"
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    boost::shared_ptr<Observable > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTQuote_t, 1, 0);
    }
    {
        try {
            result = (boost::shared_ptr<Observable > *)boost_shared_ptr_Sl_Quote_Sg__asObservable(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_boost__shared_ptrTObservable_t, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Quote_value (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Quote-value"
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTQuote_t, 1, 0);
    }
    {
        try {
            result = (Real)(*arg1)->value();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Quote (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Quote"
    boost::shared_ptr<Quote > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (boost::shared_ptr<Quote > *)new boost::shared_ptr<Quote >();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Quote (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Quote"
    boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTQuote_t, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__boost__shared_ptrTQuote_t(boost::shared_ptr<Quote > *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__boost__shared_ptrTQuote_t_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__boost__shared_ptrTQuote_t, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_QuoteHandle__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-QuoteHandle"
    boost::shared_ptr<Quote > *arg1 = 0 ;
    Handle<Quote > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTQuote_t, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (Handle<Quote > *)new Handle<Quote >((boost::shared_ptr<Quote > const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_HandleTQuote_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_QuoteHandle__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-QuoteHandle"
    Handle<Quote > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (Handle<Quote > *)new Handle<Quote >();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_HandleTQuote_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_QuoteHandle(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_QuoteHandle__SWIG_1(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_boost__shared_ptrTQuote_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            return _wrap_new_QuoteHandle__SWIG_0(argc,argv);
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_QuoteHandle'");
}


static Scheme_Object *_wrap_QuoteHandle___deref__ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteHandle---deref--"
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    boost::shared_ptr<Quote > result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Handle<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_HandleTQuote_t, 1, 0);
    }
    {
        try {
            result = (arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<Quote > * resultptr;
        resultptr = new boost::shared_ptr<Quote >((boost::shared_ptr<Quote > &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteHandle_linkstoN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteHandle-link-to!"
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Handle<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_HandleTQuote_t, 1, 0);
    }
    {
        arg2 = (boost::shared_ptr<Quote > *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_boost__shared_ptrTQuote_t, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            (arg1)->linkTo((boost::shared_ptr<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteHandle_emptyq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteHandle-empty?"
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Handle<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_HandleTQuote_t, 1, 0);
    }
    {
        try {
            result = (bool)(arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteHandle_gObservable___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteHandle->Observable"
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    boost::shared_ptr<Observable > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Handle<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_HandleTQuote_t, 1, 0);
    }
    {
        try {
            result = (boost::shared_ptr<Observable > *)Handle_Sl_Quote_Sg__asObservable(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_boost__shared_ptrTObservable_t, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteHandle_value (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteHandle-value"
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Handle<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_HandleTQuote_t, 1, 0);
    }
    {
        try {
            result = (Real)(*arg1)->value();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_QuoteHandle (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-QuoteHandle"
    Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Handle<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_HandleTQuote_t, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__HandleTQuote_t(Handle<Quote > *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__HandleTQuote_t_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__HandleTQuote_t, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_SimpleQuote (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-SimpleQuote"
    Real arg1 ;
    SimpleQuotePtr *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_REALP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"real", 1 - 1, argc, argv);
        arg1 = scheme_real_to_double(argv[0]);
    }
    {
        try {
            result = (SimpleQuotePtr *)new_SimpleQuotePtr(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_SimpleQuotePtr, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_SimpleQuote_valuessetN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "SimpleQuote-value-set!"
    SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
    Real arg2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SimpleQuotePtr *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SimpleQuotePtr, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            SimpleQuotePtr_setValue(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_SimpleQuote (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-SimpleQuote"
    SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SimpleQuotePtr *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SimpleQuotePtr, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__SimpleQuotePtr(SimpleQuotePtr *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__SimpleQuotePtr_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__SimpleQuotePtr, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_DerivedQuote (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-DerivedQuote"
    Handle<Quote > *arg1 = 0 ;
    Scheme_Object *arg2 = (Scheme_Object *) 0 ;
    DerivedQuotePtr *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Handle<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_HandleTQuote_t, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    arg2=argv[1];
    {
        try {
            result = (DerivedQuotePtr *)new_DerivedQuotePtr((Handle<Quote > const &)*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_DerivedQuotePtr, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_DerivedQuote (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-DerivedQuote"
    DerivedQuotePtr *arg1 = (DerivedQuotePtr *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (DerivedQuotePtr *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_DerivedQuotePtr, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__DerivedQuotePtr(DerivedQuotePtr *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__DerivedQuotePtr_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__DerivedQuotePtr, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_CompositeQuote (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-CompositeQuote"
    Handle<Quote > *arg1 = 0 ;
    Handle<Quote > *arg2 = 0 ;
    Scheme_Object *arg3 = (Scheme_Object *) 0 ;
    CompositeQuotePtr *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Handle<Quote > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_HandleTQuote_t, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Handle<Quote > *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_HandleTQuote_t, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    arg3=argv[2];
    {
        try {
            result = (CompositeQuotePtr *)new_CompositeQuotePtr((Handle<Quote > const &)*arg1,(Handle<Quote > const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_CompositeQuotePtr, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_CompositeQuote (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-CompositeQuote"
    CompositeQuotePtr *arg1 = (CompositeQuotePtr *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (CompositeQuotePtr *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_CompositeQuotePtr, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__CompositeQuotePtr(CompositeQuotePtr *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__CompositeQuotePtr_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__CompositeQuotePtr, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_QuoteVector__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-QuoteVector"
    unsigned int arg1 ;
    std::vector<boost::shared_ptr<Quote > > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_QuoteVector__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-QuoteVector"
    std::vector<boost::shared_ptr<Quote > > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_QuoteVector__SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-QuoteVector"
    unsigned int arg1 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    std::vector<boost::shared_ptr<Quote > > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        arg2 = (boost::shared_ptr<Quote > *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_boost__shared_ptrTQuote_t, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >(arg1,(boost::shared_ptr<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_QuoteVector__SWIG_3 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-QuoteVector"
    std::vector<boost::shared_ptr<Quote > > *arg1 = 0 ;
    std::vector<boost::shared_ptr<Quote > > *result;
    std::vector<boost::shared_ptr<Quote > > temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            unsigned int size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = std::vector<boost::shared_ptr<Quote > >(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (unsigned int i=0; i<size; i++) {
                temp1[i] = *((boost::shared_ptr<Quote >*) SWIG_MustGetPtr(items[i],
                SWIGTYPE_p_boost__shared_ptrTQuote_t,
                1, 0));
            }
        } else if (SCHEME_NULLP(argv[0])) {
            temp1 = std::vector<boost::shared_ptr<Quote > >();
            arg1 = &temp1;
        } else if (SCHEME_PAIRP(argv[0])) {
            temp1 = std::vector<boost::shared_ptr<Quote > >();
            arg1 = &temp1;
            Scheme_Object *head, *tail;
            tail = argv[0];
            while (!SCHEME_NULLP(tail)) {
                head = scheme_car(tail);
                tail = scheme_cdr(tail);
                temp1.push_back(*((boost::shared_ptr<Quote >*) SWIG_MustGetPtr(head,
                SWIGTYPE_p_boost__shared_ptrTQuote_t,
                1, 0)));
            }
        } else {
            arg1 = (std::vector<boost::shared_ptr<Quote > > *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t,1, 0);
        }
    }
    {
        try {
            result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >((std::vector<boost::shared_ptr<Quote > > const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_QuoteVector(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_QuoteVector__SWIG_1(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_QuoteVector__SWIG_0(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (SCHEME_VECTORP(argv[0])) {
                unsigned int size = SCHEME_VEC_SIZE(argv[0]);
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    boost::shared_ptr<Quote >* x;
                    Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
                    if (SWIG_ConvertPtr(items[0],(void**) &x,
                    SWIGTYPE_p_boost__shared_ptrTQuote_t, 0) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else if (SCHEME_NULLP(argv[0])) {
                /* again, an empty sequence can be of any type */
                _v = 1;
            } else if (SCHEME_PAIRP(argv[0])) {
                /* check the first element only */
                boost::shared_ptr<Quote >* x;
                Scheme_Object *head = scheme_car(argv[0]);
                if (SWIG_ConvertPtr(head,(void**) &x,
                SWIGTYPE_p_boost__shared_ptrTQuote_t, 0) != -1)
                _v = 1;
                else
                _v = 0;
            } else {
                /* wrapped vector? */
                std::vector<boost::shared_ptr<Quote > >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 0) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_QuoteVector__SWIG_3(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_boost__shared_ptrTQuote_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_new_QuoteVector__SWIG_2(argc,argv);
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_QuoteVector'");
}


static Scheme_Object *_wrap_QuoteVector_length (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteVector-length"
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    unsigned int result;
    std::vector<boost::shared_ptr<Quote > > temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            unsigned int size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = std::vector<boost::shared_ptr<Quote > >(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (unsigned int i=0; i<size; i++) {
                temp1[i] = *((boost::shared_ptr<Quote >*) SWIG_MustGetPtr(items[i],
                SWIGTYPE_p_boost__shared_ptrTQuote_t,
                1, 0));
            }
        } else if (SCHEME_NULLP(argv[0])) {
            temp1 = std::vector<boost::shared_ptr<Quote > >();
            arg1 = &temp1;
        } else if (SCHEME_PAIRP(argv[0])) {
            temp1 = std::vector<boost::shared_ptr<Quote > >();
            arg1 = &temp1;
            Scheme_Object *head, *tail;
            tail = argv[0];
            while (!SCHEME_NULLP(tail)) {
                head = scheme_car(tail);
                tail = scheme_cdr(tail);
                temp1.push_back(*((boost::shared_ptr<Quote >*) SWIG_MustGetPtr(head,
                SWIGTYPE_p_boost__shared_ptrTQuote_t,
                1, 0)));
            }
        } else {
            arg1 = (std::vector<boost::shared_ptr<Quote > > *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t,1, 0);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<boost::shared_ptr<Quote > > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value_from_unsigned(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteVector_emptyq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteVector-empty?"
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    bool result;
    std::vector<boost::shared_ptr<Quote > > temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            unsigned int size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = std::vector<boost::shared_ptr<Quote > >(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (unsigned int i=0; i<size; i++) {
                temp1[i] = *((boost::shared_ptr<Quote >*) SWIG_MustGetPtr(items[i],
                SWIGTYPE_p_boost__shared_ptrTQuote_t,
                1, 0));
            }
        } else if (SCHEME_NULLP(argv[0])) {
            temp1 = std::vector<boost::shared_ptr<Quote > >();
            arg1 = &temp1;
        } else if (SCHEME_PAIRP(argv[0])) {
            temp1 = std::vector<boost::shared_ptr<Quote > >();
            arg1 = &temp1;
            Scheme_Object *head, *tail;
            tail = argv[0];
            while (!SCHEME_NULLP(tail)) {
                head = scheme_car(tail);
                tail = scheme_cdr(tail);
                temp1.push_back(*((boost::shared_ptr<Quote >*) SWIG_MustGetPtr(head,
                SWIGTYPE_p_boost__shared_ptrTQuote_t,
                1, 0)));
            }
        } else {
            arg1 = (std::vector<boost::shared_ptr<Quote > > *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t,1, 0);
        }
    }
    {
        try {
            result = (bool)((std::vector<boost::shared_ptr<Quote > > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteVector_clearN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteVector-clear!"
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<boost::shared_ptr<Quote > > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1, 0);
    }
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteVector_pushN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteVector-push!"
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    boost::shared_ptr<Quote > *arg2 = 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<boost::shared_ptr<Quote > > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1, 0);
    }
    {
        arg2 = (boost::shared_ptr<Quote > *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_boost__shared_ptrTQuote_t, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            (arg1)->push_back((boost::shared_ptr<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteVector_popN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteVector-pop!"
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    boost::shared_ptr<Quote > result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<boost::shared_ptr<Quote > > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1, 0);
    }
    {
        try {
            try {
                result = std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__pop(arg1);
            }
            catch(std::out_of_range &_e) {
                SWIG_exception(SWIG_IndexError, (&_e)->what()); 
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        boost::shared_ptr<Quote > * resultptr;
        resultptr = new boost::shared_ptr<Quote >((boost::shared_ptr<Quote > &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_boost__shared_ptrTQuote_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteVector_ref (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteVector-ref"
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    boost::shared_ptr<Quote > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<boost::shared_ptr<Quote > > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            try {
                {
                    boost::shared_ptr<Quote > &_result_ref = std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__ref(arg1,arg2);
                    result = (boost::shared_ptr<Quote > *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_exception(SWIG_IndexError, (&_e)->what()); 
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_boost__shared_ptrTQuote_t, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteVector_setN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteVector-set!"
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int arg2 ;
    boost::shared_ptr<Quote > *arg3 = 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<boost::shared_ptr<Quote > > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        arg3 = (boost::shared_ptr<Quote > *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_boost__shared_ptrTQuote_t, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            try {
                std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__set(arg1,arg2,(boost::shared_ptr<Quote > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_exception(SWIG_IndexError, (&_e)->what()); 
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_QuoteVector (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-QuoteVector"
    std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<boost::shared_ptr<Quote > > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__std__vectorTboost__shared_ptrTQuote_t_t(std::vector<boost::shared_ptr<Quote > > *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__std__vectorTboost__shared_ptrTQuote_t_t_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__std__vectorTboost__shared_ptrTQuote_t_t, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_QuoteHandleVector__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-QuoteHandleVector"
    unsigned int arg1 ;
    std::vector<Handle<Quote > > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_QuoteHandleVector__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-QuoteHandleVector"
    std::vector<Handle<Quote > > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_QuoteHandleVector__SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-QuoteHandleVector"
    unsigned int arg1 ;
    Handle<Quote > *arg2 = 0 ;
    std::vector<Handle<Quote > > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        arg2 = (Handle<Quote > *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_HandleTQuote_t, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >(arg1,(Handle<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_QuoteHandleVector__SWIG_3 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-QuoteHandleVector"
    std::vector<Handle<Quote > > *arg1 = 0 ;
    std::vector<Handle<Quote > > *result;
    std::vector<Handle<Quote > > temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            unsigned int size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = std::vector<Handle<Quote > >(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (unsigned int i=0; i<size; i++) {
                temp1[i] = *((Handle<Quote >*) SWIG_MustGetPtr(items[i],
                SWIGTYPE_p_HandleTQuote_t,
                1, 0));
            }
        } else if (SCHEME_NULLP(argv[0])) {
            temp1 = std::vector<Handle<Quote > >();
            arg1 = &temp1;
        } else if (SCHEME_PAIRP(argv[0])) {
            temp1 = std::vector<Handle<Quote > >();
            arg1 = &temp1;
            Scheme_Object *head, *tail;
            tail = argv[0];
            while (!SCHEME_NULLP(tail)) {
                head = scheme_car(tail);
                tail = scheme_cdr(tail);
                temp1.push_back(*((Handle<Quote >*) SWIG_MustGetPtr(head,
                SWIGTYPE_p_HandleTQuote_t,
                1, 0)));
            }
        } else {
            arg1 = (std::vector<Handle<Quote > > *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_std__vectorTHandleTQuote_t_t,1, 0);
        }
    }
    {
        try {
            result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >((std::vector<Handle<Quote > > const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_QuoteHandleVector(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_QuoteHandleVector__SWIG_1(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_QuoteHandleVector__SWIG_0(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (SCHEME_VECTORP(argv[0])) {
                unsigned int size = SCHEME_VEC_SIZE(argv[0]);
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    Handle<Quote >* x;
                    Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
                    if (SWIG_ConvertPtr(items[0],(void**) &x,
                    SWIGTYPE_p_HandleTQuote_t, 0) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else if (SCHEME_NULLP(argv[0])) {
                /* again, an empty sequence can be of any type */
                _v = 1;
            } else if (SCHEME_PAIRP(argv[0])) {
                /* check the first element only */
                Handle<Quote >* x;
                Scheme_Object *head = scheme_car(argv[0]);
                if (SWIG_ConvertPtr(head,(void**) &x,
                SWIGTYPE_p_HandleTQuote_t, 0) != -1)
                _v = 1;
                else
                _v = 0;
            } else {
                /* wrapped vector? */
                std::vector<Handle<Quote > >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 0) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_QuoteHandleVector__SWIG_3(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_HandleTQuote_t, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_new_QuoteHandleVector__SWIG_2(argc,argv);
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_QuoteHandleVector'");
}


static Scheme_Object *_wrap_QuoteHandleVector_length (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteHandleVector-length"
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    unsigned int result;
    std::vector<Handle<Quote > > temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            unsigned int size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = std::vector<Handle<Quote > >(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (unsigned int i=0; i<size; i++) {
                temp1[i] = *((Handle<Quote >*) SWIG_MustGetPtr(items[i],
                SWIGTYPE_p_HandleTQuote_t,
                1, 0));
            }
        } else if (SCHEME_NULLP(argv[0])) {
            temp1 = std::vector<Handle<Quote > >();
            arg1 = &temp1;
        } else if (SCHEME_PAIRP(argv[0])) {
            temp1 = std::vector<Handle<Quote > >();
            arg1 = &temp1;
            Scheme_Object *head, *tail;
            tail = argv[0];
            while (!SCHEME_NULLP(tail)) {
                head = scheme_car(tail);
                tail = scheme_cdr(tail);
                temp1.push_back(*((Handle<Quote >*) SWIG_MustGetPtr(head,
                SWIGTYPE_p_HandleTQuote_t,
                1, 0)));
            }
        } else {
            arg1 = (std::vector<Handle<Quote > > *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_std__vectorTHandleTQuote_t_t,1, 0);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<Handle<Quote > > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value_from_unsigned(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteHandleVector_emptyq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteHandleVector-empty?"
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    bool result;
    std::vector<Handle<Quote > > temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            unsigned int size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = std::vector<Handle<Quote > >(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (unsigned int i=0; i<size; i++) {
                temp1[i] = *((Handle<Quote >*) SWIG_MustGetPtr(items[i],
                SWIGTYPE_p_HandleTQuote_t,
                1, 0));
            }
        } else if (SCHEME_NULLP(argv[0])) {
            temp1 = std::vector<Handle<Quote > >();
            arg1 = &temp1;
        } else if (SCHEME_PAIRP(argv[0])) {
            temp1 = std::vector<Handle<Quote > >();
            arg1 = &temp1;
            Scheme_Object *head, *tail;
            tail = argv[0];
            while (!SCHEME_NULLP(tail)) {
                head = scheme_car(tail);
                tail = scheme_cdr(tail);
                temp1.push_back(*((Handle<Quote >*) SWIG_MustGetPtr(head,
                SWIGTYPE_p_HandleTQuote_t,
                1, 0)));
            }
        } else {
            arg1 = (std::vector<Handle<Quote > > *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_std__vectorTHandleTQuote_t_t,1, 0);
        }
    }
    {
        try {
            result = (bool)((std::vector<Handle<Quote > > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteHandleVector_clearN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteHandleVector-clear!"
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Handle<Quote > > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1, 0);
    }
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteHandleVector_pushN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteHandleVector-push!"
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    Handle<Quote > *arg2 = 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Handle<Quote > > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1, 0);
    }
    {
        arg2 = (Handle<Quote > *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_HandleTQuote_t, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            (arg1)->push_back((Handle<Quote > const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteHandleVector_popN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteHandleVector-pop!"
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    Handle<Quote > result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Handle<Quote > > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1, 0);
    }
    {
        try {
            try {
                result = std_vector_Sl_Handle_Sl_Quote_Sg__Sg__pop(arg1);
            }
            catch(std::out_of_range &_e) {
                SWIG_exception(SWIG_IndexError, (&_e)->what()); 
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Handle<Quote > * resultptr;
        resultptr = new Handle<Quote >((Handle<Quote > &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_HandleTQuote_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteHandleVector_ref (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteHandleVector-ref"
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    Handle<Quote > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Handle<Quote > > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            try {
                {
                    Handle<Quote > &_result_ref = std_vector_Sl_Handle_Sl_Quote_Sg__Sg__ref(arg1,arg2);
                    result = (Handle<Quote > *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_exception(SWIG_IndexError, (&_e)->what()); 
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_HandleTQuote_t, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_QuoteHandleVector_setN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "QuoteHandleVector-set!"
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int arg2 ;
    Handle<Quote > *arg3 = 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Handle<Quote > > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        arg3 = (Handle<Quote > *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_HandleTQuote_t, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            try {
                std_vector_Sl_Handle_Sl_Quote_Sg__Sg__set(arg1,arg2,(Handle<Quote > const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_exception(SWIG_IndexError, (&_e)->what()); 
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_QuoteHandleVector (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-QuoteHandleVector"
    std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Handle<Quote > > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTHandleTQuote_t_t, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__std__vectorTHandleTQuote_t_t(std::vector<Handle<Quote > > *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__std__vectorTHandleTQuote_t_t_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__std__vectorTHandleTQuote_t_t, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Sunday(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Sunday"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Sunday);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Monday(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Monday"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Monday);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Tuesday(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Tuesday"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Tuesday);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Wednesday(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Wednesday"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Wednesday);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Thursday(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Thursday"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Thursday);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Friday(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Friday"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Friday);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Saturday(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Saturday"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Saturday);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_January(int argc, Scheme_Object** argv) {
#define FUNC_NAME "January"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_January);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_February(int argc, Scheme_Object** argv) {
#define FUNC_NAME "February"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_February);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_March(int argc, Scheme_Object** argv) {
#define FUNC_NAME "March"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_March);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_April(int argc, Scheme_Object** argv) {
#define FUNC_NAME "April"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_April);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_May(int argc, Scheme_Object** argv) {
#define FUNC_NAME "May"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_May);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_June(int argc, Scheme_Object** argv) {
#define FUNC_NAME "June"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_June);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_July(int argc, Scheme_Object** argv) {
#define FUNC_NAME "July"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_July);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_August(int argc, Scheme_Object** argv) {
#define FUNC_NAME "August"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_August);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_September(int argc, Scheme_Object** argv) {
#define FUNC_NAME "September"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_September);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_October(int argc, Scheme_Object** argv) {
#define FUNC_NAME "October"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_October);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_November(int argc, Scheme_Object** argv) {
#define FUNC_NAME "November"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_November);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_December(int argc, Scheme_Object** argv) {
#define FUNC_NAME "December"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_December);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Days(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Days"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Days);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Weeks(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Weeks"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Weeks);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Months(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Months"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Months);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Years(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Years"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Years);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_NoFrequency(int argc, Scheme_Object** argv) {
#define FUNC_NAME "NoFrequency"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_NoFrequency);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Once(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Once"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Once);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Annual(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Annual"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Annual);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Semiannual(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Semiannual"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Semiannual);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_EveryFourthMonth(int argc, Scheme_Object** argv) {
#define FUNC_NAME "EveryFourthMonth"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_EveryFourthMonth);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Quarterly(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Quarterly"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Quarterly);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Bimonthly(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Bimonthly"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Bimonthly);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Monthly(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Monthly"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Monthly);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Period__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Period"
    Integer arg1 ;
    TimeUnit arg2 ;
    Period *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        if (!SCHEME_INTP(argv[1])) 
        scheme_wrong_type(FUNC_NAME, "integer", 2 - 1, argc, argv);
        arg2 = (TimeUnit) SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            result = (Period *)new Period(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Period, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Period_length (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Period-length"
    Period *arg1 = (Period *) 0 ;
    Integer result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Period *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Period, 1, 0);
    }
    {
        try {
            result = (Integer)((Period const *)arg1)->length();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Period_units (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Period-units"
    Period *arg1 = (Period *) 0 ;
    TimeUnit result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Period *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Period, 1, 0);
    }
    {
        try {
            result = (TimeUnit)((Period const *)arg1)->units();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_make_integer_value(result);
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Period__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Period"
    std::string *arg1 = 0 ;
    Period *result;
    std::string temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_STRINGP(argv[0])) {
            temp1 = std::string(SCHEME_STR_VAL(argv[0]));
            arg1 = &temp1;
        } else {
            SWIG_exception(SWIG_TypeError, "string expected");
        }
    }
    {
        try {
            result = (Period *)new_Period__SWIG_1((std::string const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Period, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_Period(int argc, Scheme_Object **argv) {
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_STRINGP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_Period__SWIG_1(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (SCHEME_INTP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_Period__SWIG_0(argc,argv);
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_Period'");
}


static Scheme_Object *_wrap_Period_gstring___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Period->string"
    Period *arg1 = (Period *) 0 ;
    std::string result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Period *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Period, 1, 0);
    }
    {
        try {
            result = Period___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string((&result)->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Period___repr__ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Period---repr--"
    Period *arg1 = (Period *) 0 ;
    std::string result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Period *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Period, 1, 0);
    }
    {
        try {
            result = Period___repr__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string((&result)->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Period___cmp__ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Period---cmp--"
    Period *arg1 = (Period *) 0 ;
    Period *arg2 = 0 ;
    int result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Period *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Period, 1, 0);
    }
    {
        arg2 = (Period *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Period, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (int)Period___cmp__(arg1,(Period const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Period (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Period"
    Period *arg1 = (Period *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Period *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Period, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__Period(Period *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__Period_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__Period, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_PeriodVector__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-PeriodVector"
    unsigned int arg1 ;
    std::vector<Period > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (std::vector<Period > *)new std::vector<Period >(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_PeriodVector__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-PeriodVector"
    std::vector<Period > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (std::vector<Period > *)new std::vector<Period >();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_PeriodVector__SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-PeriodVector"
    unsigned int arg1 ;
    Period *arg2 = 0 ;
    std::vector<Period > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        arg2 = (Period *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Period, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (std::vector<Period > *)new std::vector<Period >(arg1,(Period const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_PeriodVector__SWIG_3 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-PeriodVector"
    std::vector<Period > *arg1 = 0 ;
    std::vector<Period > *result;
    std::vector<Period > temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            unsigned int size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = std::vector<Period >(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (unsigned int i=0; i<size; i++) {
                temp1[i] = *((Period*) SWIG_MustGetPtr(items[i],
                SWIGTYPE_p_Period,
                1, 0));
            }
        } else if (SCHEME_NULLP(argv[0])) {
            temp1 = std::vector<Period >();
            arg1 = &temp1;
        } else if (SCHEME_PAIRP(argv[0])) {
            temp1 = std::vector<Period >();
            arg1 = &temp1;
            Scheme_Object *head, *tail;
            tail = argv[0];
            while (!SCHEME_NULLP(tail)) {
                head = scheme_car(tail);
                tail = scheme_cdr(tail);
                temp1.push_back(*((Period*) SWIG_MustGetPtr(head,
                SWIGTYPE_p_Period,
                1, 0)));
            }
        } else {
            arg1 = (std::vector<Period > *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_std__vectorTPeriod_t,1, 0);
        }
    }
    {
        try {
            result = (std::vector<Period > *)new std::vector<Period >((std::vector<Period > const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTPeriod_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_PeriodVector(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_PeriodVector__SWIG_1(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_PeriodVector__SWIG_0(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (SCHEME_VECTORP(argv[0])) {
                unsigned int size = SCHEME_VEC_SIZE(argv[0]);
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    Period* x;
                    Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
                    if (SWIG_ConvertPtr(items[0],(void**) &x,
                    SWIGTYPE_p_Period, 0) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else if (SCHEME_NULLP(argv[0])) {
                /* again, an empty sequence can be of any type */
                _v = 1;
            } else if (SCHEME_PAIRP(argv[0])) {
                /* check the first element only */
                Period* x;
                Scheme_Object *head = scheme_car(argv[0]);
                if (SWIG_ConvertPtr(head,(void**) &x,
                SWIGTYPE_p_Period, 0) != -1)
                _v = 1;
                else
                _v = 0;
            } else {
                /* wrapped vector? */
                std::vector<Period >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTPeriod_t, 0) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_PeriodVector__SWIG_3(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Period, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_new_PeriodVector__SWIG_2(argc,argv);
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_PeriodVector'");
}


static Scheme_Object *_wrap_PeriodVector_length (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "PeriodVector-length"
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    unsigned int result;
    std::vector<Period > temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            unsigned int size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = std::vector<Period >(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (unsigned int i=0; i<size; i++) {
                temp1[i] = *((Period*) SWIG_MustGetPtr(items[i],
                SWIGTYPE_p_Period,
                1, 0));
            }
        } else if (SCHEME_NULLP(argv[0])) {
            temp1 = std::vector<Period >();
            arg1 = &temp1;
        } else if (SCHEME_PAIRP(argv[0])) {
            temp1 = std::vector<Period >();
            arg1 = &temp1;
            Scheme_Object *head, *tail;
            tail = argv[0];
            while (!SCHEME_NULLP(tail)) {
                head = scheme_car(tail);
                tail = scheme_cdr(tail);
                temp1.push_back(*((Period*) SWIG_MustGetPtr(head,
                SWIGTYPE_p_Period,
                1, 0)));
            }
        } else {
            arg1 = (std::vector<Period > *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_std__vectorTPeriod_t,1, 0);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<Period > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value_from_unsigned(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_PeriodVector_emptyq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "PeriodVector-empty?"
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    bool result;
    std::vector<Period > temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            unsigned int size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = std::vector<Period >(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (unsigned int i=0; i<size; i++) {
                temp1[i] = *((Period*) SWIG_MustGetPtr(items[i],
                SWIGTYPE_p_Period,
                1, 0));
            }
        } else if (SCHEME_NULLP(argv[0])) {
            temp1 = std::vector<Period >();
            arg1 = &temp1;
        } else if (SCHEME_PAIRP(argv[0])) {
            temp1 = std::vector<Period >();
            arg1 = &temp1;
            Scheme_Object *head, *tail;
            tail = argv[0];
            while (!SCHEME_NULLP(tail)) {
                head = scheme_car(tail);
                tail = scheme_cdr(tail);
                temp1.push_back(*((Period*) SWIG_MustGetPtr(head,
                SWIGTYPE_p_Period,
                1, 0)));
            }
        } else {
            arg1 = (std::vector<Period > *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_std__vectorTPeriod_t,1, 0);
        }
    }
    {
        try {
            result = (bool)((std::vector<Period > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_PeriodVector_clearN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "PeriodVector-clear!"
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Period > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTPeriod_t, 1, 0);
    }
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_PeriodVector_pushN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "PeriodVector-push!"
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    Period *arg2 = 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Period > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTPeriod_t, 1, 0);
    }
    {
        arg2 = (Period *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Period, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            (arg1)->push_back((Period const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_PeriodVector_popN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "PeriodVector-pop!"
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    SwigValueWrapper<Period > result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Period > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTPeriod_t, 1, 0);
    }
    {
        try {
            try {
                result = std_vector_Sl_Period_Sg__pop(arg1);
            }
            catch(std::out_of_range &_e) {
                SWIG_exception(SWIG_IndexError, (&_e)->what()); 
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Period * resultptr;
        resultptr = new Period((Period &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Period, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_PeriodVector_ref (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "PeriodVector-ref"
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    Period *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Period > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTPeriod_t, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            try {
                {
                    Period &_result_ref = std_vector_Sl_Period_Sg__ref(arg1,arg2);
                    result = (Period *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_exception(SWIG_IndexError, (&_e)->what()); 
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Period, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_PeriodVector_setN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "PeriodVector-set!"
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int arg2 ;
    Period *arg3 = 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Period > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTPeriod_t, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        arg3 = (Period *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Period, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            try {
                std_vector_Sl_Period_Sg__set(arg1,arg2,(Period const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_exception(SWIG_IndexError, (&_e)->what()); 
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_PeriodVector (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-PeriodVector"
    std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Period > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTPeriod_t, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__std__vectorTPeriod_t(std::vector<Period > *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__std__vectorTPeriod_t_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__std__vectorTPeriod_t, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Date__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Date"
    Date *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (Date *)new Date();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Date__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Date"
    Day arg1 ;
    Month arg2 ;
    Year arg3 ;
    Date *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        if (!SCHEME_INTP(argv[1])) 
        scheme_wrong_type(FUNC_NAME, "integer", 2 - 1, argc, argv);
        arg2 = (Month) SCHEME_INT_VAL(argv[1]);
    }
    {
        if (!SCHEME_INTP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"integer", 3 - 1, argc, argv);
        arg3 = SCHEME_INT_VAL(argv[2]);
    }
    {
        try {
            result = (Date *)new Date(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Date__SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Date"
    BigInteger arg1 ;
    Date *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (Date *)new Date(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_weekday (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-weekday"
    Date *arg1 = (Date *) 0 ;
    Weekday result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
    }
    {
        try {
            result = (Weekday)((Date const *)arg1)->weekday();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_make_integer_value(result);
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_daysofsmonth___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-day-of-month"
    Date *arg1 = (Date *) 0 ;
    Day result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
    }
    {
        try {
            result = (Day)((Date const *)arg1)->dayOfMonth();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_daysofsyear___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-day-of-year"
    Date *arg1 = (Date *) 0 ;
    Day result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
    }
    {
        try {
            result = (Day)((Date const *)arg1)->dayOfYear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_month (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-month"
    Date *arg1 = (Date *) 0 ;
    Month result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
    }
    {
        try {
            result = (Month)((Date const *)arg1)->month();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_make_integer_value(result);
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_year (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-year"
    Date *arg1 = (Date *) 0 ;
    Year result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
    }
    {
        try {
            result = (Year)((Date const *)arg1)->year();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_serialsnumber___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-serial-number"
    Date *arg1 = (Date *) 0 ;
    BigInteger result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
    }
    {
        try {
            result = (BigInteger)((Date const *)arg1)->serialNumber();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_issleapq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-is-leap?"
    Year arg1 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (bool)Date::isLeap(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_minsdate___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-min-date"
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = Date::minDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_maxsdate___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-max-date"
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = Date::maxDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_todayssdate___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-todays-date"
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = Date::todaysDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_endsofsmonth___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-end-of-month"
    Date *arg1 = 0 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = Date::endOfMonth((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_isseomq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-is-eom?"
    Date *arg1 = 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (bool)Date::isEOM((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_nextsweekday___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-next-weekday"
    Date *arg1 = 0 ;
    Weekday arg2 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[1])) 
        scheme_wrong_type(FUNC_NAME, "integer", 2 - 1, argc, argv);
        arg2 = (Weekday) SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            result = Date::nextWeekday((Date const &)*arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_nthsweekday___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-nth-weekday"
    Size arg1 ;
    Weekday arg2 ;
    Month arg3 ;
    Year arg4 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        if (!SCHEME_INTP(argv[1])) 
        scheme_wrong_type(FUNC_NAME, "integer", 2 - 1, argc, argv);
        arg2 = (Weekday) SCHEME_INT_VAL(argv[1]);
    }
    {
        if (!SCHEME_INTP(argv[2])) 
        scheme_wrong_type(FUNC_NAME, "integer", 3 - 1, argc, argv);
        arg3 = (Month) SCHEME_INT_VAL(argv[2]);
    }
    {
        if (!SCHEME_INTP(argv[3]))
        scheme_wrong_type(FUNC_NAME,"integer", 4 - 1, argc, argv);
        arg4 = SCHEME_INT_VAL(argv[3]);
    }
    {
        try {
            result = Date::nthWeekday(arg1,arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_issimmsdateq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-is-imm-date?"
    Date *arg1 = 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (bool)Date::isIMMdate((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_nextsimmsdate___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-next-imm-date"
    Date *arg1 = 0 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = Date::nextIMMdate((Date const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Date__SWIG_3 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Date"
    std::string *arg1 = 0 ;
    std::string *arg2 = 0 ;
    Date *result;
    std::string temp1 ;
    std::string temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_STRINGP(argv[0])) {
            temp1 = std::string(SCHEME_STR_VAL(argv[0]));
            arg1 = &temp1;
        } else {
            SWIG_exception(SWIG_TypeError, "string expected");
        }
    }
    {
        if (SCHEME_STRINGP(argv[1])) {
            temp2 = std::string(SCHEME_STR_VAL(argv[1]));
            arg2 = &temp2;
        } else {
            SWIG_exception(SWIG_TypeError, "string expected");
        }
    }
    {
        try {
            result = (Date *)new_Date__SWIG_3((std::string const &)*arg1,(std::string const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_Date(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_Date__SWIG_0(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_Date__SWIG_2(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (SCHEME_STRINGP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (SCHEME_STRINGP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_Date__SWIG_3(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (SCHEME_INTP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_INTP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_Date__SWIG_1(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_Date'");
}


static Scheme_Object *_wrap_Date_weekdaysnumber___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-weekday-number"
    Date *arg1 = (Date *) 0 ;
    Integer result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
    }
    {
        try {
            result = (Integer)Date_weekdayNumber(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_gstring___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date->string"
    Date *arg1 = (Date *) 0 ;
    std::string result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
    }
    {
        try {
            result = Date___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string((&result)->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date___repr__ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date---repr--"
    Date *arg1 = (Date *) 0 ;
    std::string result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
    }
    {
        try {
            result = Date___repr__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string((&result)->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_ISO (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-ISO"
    Date *arg1 = (Date *) 0 ;
    std::string result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
    }
    {
        try {
            result = Date_ISO(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string((&result)->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Date_advance (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-advance"
    Date *arg1 = (Date *) 0 ;
    Integer arg2 ;
    TimeUnit arg3 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        if (!SCHEME_INTP(argv[2])) 
        scheme_wrong_type(FUNC_NAME, "integer", 3 - 1, argc, argv);
        arg3 = (TimeUnit) SCHEME_INT_VAL(argv[2]);
    }
    {
        try {
            result = Date_advance(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Date (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Date"
    Date *arg1 = (Date *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__Date(Date *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__Date_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__Date, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_DateVector__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-DateVector"
    unsigned int arg1 ;
    std::vector<Date > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (std::vector<Date > *)new std::vector<Date >(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTDate_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_DateVector__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-DateVector"
    std::vector<Date > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (std::vector<Date > *)new std::vector<Date >();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTDate_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_DateVector__SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-DateVector"
    unsigned int arg1 ;
    Date *arg2 = 0 ;
    std::vector<Date > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (std::vector<Date > *)new std::vector<Date >(arg1,(Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTDate_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_DateVector__SWIG_3 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-DateVector"
    std::vector<Date > *arg1 = 0 ;
    std::vector<Date > *result;
    std::vector<Date > temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            unsigned int size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (unsigned int i=0; i<size; i++) {
                temp1[i] = *((Date*) SWIG_MustGetPtr(items[i],
                SWIGTYPE_p_Date,
                1, 0));
            }
        } else if (SCHEME_NULLP(argv[0])) {
            temp1 = std::vector<Date >();
            arg1 = &temp1;
        } else if (SCHEME_PAIRP(argv[0])) {
            temp1 = std::vector<Date >();
            arg1 = &temp1;
            Scheme_Object *head, *tail;
            tail = argv[0];
            while (!SCHEME_NULLP(tail)) {
                head = scheme_car(tail);
                tail = scheme_cdr(tail);
                temp1.push_back(*((Date*) SWIG_MustGetPtr(head,
                SWIGTYPE_p_Date,
                1, 0)));
            }
        } else {
            arg1 = (std::vector<Date > *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_std__vectorTDate_t,1, 0);
        }
    }
    {
        try {
            result = (std::vector<Date > *)new std::vector<Date >((std::vector<Date > const &)*arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_std__vectorTDate_t, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_DateVector(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_DateVector__SWIG_1(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_DateVector__SWIG_0(argc,argv);
        }
    }
    if (argc == 1) {
        int _v;
        {
            /* native sequence? */
            if (SCHEME_VECTORP(argv[0])) {
                unsigned int size = SCHEME_VEC_SIZE(argv[0]);
                if (size == 0) {
                    /* an empty sequence can be of any type */
                    _v = 1;
                } else {
                    /* check the first element only */
                    Date* x;
                    Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
                    if (SWIG_ConvertPtr(items[0],(void**) &x,
                    SWIGTYPE_p_Date, 0) != -1)
                    _v = 1;
                    else
                    _v = 0;
                }
            } else if (SCHEME_NULLP(argv[0])) {
                /* again, an empty sequence can be of any type */
                _v = 1;
            } else if (SCHEME_PAIRP(argv[0])) {
                /* check the first element only */
                Date* x;
                Scheme_Object *head = scheme_car(argv[0]);
                if (SWIG_ConvertPtr(head,(void**) &x,
                SWIGTYPE_p_Date, 0) != -1)
                _v = 1;
                else
                _v = 0;
            } else {
                /* wrapped vector? */
                std::vector<Date >* v;
                if (SWIG_ConvertPtr(argv[0],(void **) &v, 
                SWIGTYPE_p_std__vectorTDate_t, 0) != -1)
                _v = 1;
                else
                _v = 0;
            }
        }
        if (_v) {
            return _wrap_new_DateVector__SWIG_3(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_new_DateVector__SWIG_2(argc,argv);
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_DateVector'");
}


static Scheme_Object *_wrap_DateVector_length (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "DateVector-length"
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    unsigned int result;
    std::vector<Date > temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            unsigned int size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (unsigned int i=0; i<size; i++) {
                temp1[i] = *((Date*) SWIG_MustGetPtr(items[i],
                SWIGTYPE_p_Date,
                1, 0));
            }
        } else if (SCHEME_NULLP(argv[0])) {
            temp1 = std::vector<Date >();
            arg1 = &temp1;
        } else if (SCHEME_PAIRP(argv[0])) {
            temp1 = std::vector<Date >();
            arg1 = &temp1;
            Scheme_Object *head, *tail;
            tail = argv[0];
            while (!SCHEME_NULLP(tail)) {
                head = scheme_car(tail);
                tail = scheme_cdr(tail);
                temp1.push_back(*((Date*) SWIG_MustGetPtr(head,
                SWIGTYPE_p_Date,
                1, 0)));
            }
        } else {
            arg1 = (std::vector<Date > *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_std__vectorTDate_t,1, 0);
        }
    }
    {
        try {
            result = (unsigned int)((std::vector<Date > const *)arg1)->size();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value_from_unsigned(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_DateVector_emptyq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "DateVector-empty?"
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    bool result;
    std::vector<Date > temp1 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            unsigned int size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = std::vector<Date >(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (unsigned int i=0; i<size; i++) {
                temp1[i] = *((Date*) SWIG_MustGetPtr(items[i],
                SWIGTYPE_p_Date,
                1, 0));
            }
        } else if (SCHEME_NULLP(argv[0])) {
            temp1 = std::vector<Date >();
            arg1 = &temp1;
        } else if (SCHEME_PAIRP(argv[0])) {
            temp1 = std::vector<Date >();
            arg1 = &temp1;
            Scheme_Object *head, *tail;
            tail = argv[0];
            while (!SCHEME_NULLP(tail)) {
                head = scheme_car(tail);
                tail = scheme_cdr(tail);
                temp1.push_back(*((Date*) SWIG_MustGetPtr(head,
                SWIGTYPE_p_Date,
                1, 0)));
            }
        } else {
            arg1 = (std::vector<Date > *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_std__vectorTDate_t,1, 0);
        }
    }
    {
        try {
            result = (bool)((std::vector<Date > const *)arg1)->empty();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_DateVector_clearN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "DateVector-clear!"
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Date > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTDate_t, 1, 0);
    }
    {
        try {
            (arg1)->clear();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_DateVector_pushN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "DateVector-push!"
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    Date *arg2 = 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Date > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTDate_t, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            (arg1)->push_back((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_DateVector_popN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "DateVector-pop!"
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Date > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTDate_t, 1, 0);
    }
    {
        try {
            try {
                result = std_vector_Sl_Date_Sg__pop(arg1);
            }
            catch(std::out_of_range &_e) {
                SWIG_exception(SWIG_IndexError, (&_e)->what()); 
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_DateVector_ref (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "DateVector-ref"
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    Date *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Date > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTDate_t, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            try {
                {
                    Date &_result_ref = std_vector_Sl_Date_Sg__ref(arg1,arg2);
                    result = (Date *) &_result_ref;
                }
            }
            catch(std::out_of_range &_e) {
                SWIG_exception(SWIG_IndexError, (&_e)->what()); 
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Date, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_DateVector_setN___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "DateVector-set!"
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int arg2 ;
    Date *arg3 = 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Date > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTDate_t, 1, 0);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        arg3 = (Date *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Date, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            try {
                std_vector_Sl_Date_Sg__set(arg1,arg2,(Date const &)*arg3);
            }
            catch(std::out_of_range &_e) {
                SWIG_exception(SWIG_IndexError, (&_e)->what()); 
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_DateVector (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-DateVector"
    std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (std::vector<Date > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_std__vectorTDate_t, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__std__vectorTDate_t(std::vector<Date > *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__std__vectorTDate_t_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__std__vectorTDate_t, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Date_days_between (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date-days-between"
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    BigInteger result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (BigInteger)Date_days_between((Date const &)*arg1,(Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Dateeq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date=?"
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (bool)Date_equal((Date const &)*arg1,(Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Datelq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date<?"
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (bool)Date_less((Date const &)*arg1,(Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Dateleq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date<=?"
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (bool)Date_less_equal((Date const &)*arg1,(Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Dategq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date>?"
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (bool)Date_greater((Date const &)*arg1,(Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Dategeq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Date>=?"
    Date *arg1 = 0 ;
    Date *arg2 = 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Date *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Date, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (bool)Date_greater_equal((Date const &)*arg1,(Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_nullsint___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "null-int"
    int result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (int)nullInt();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_nullsdouble___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "null-double"
    double result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (double)nullDouble();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_DayCounter_dayscount___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "DayCounter-day-count"
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    BigInteger result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (DayCounter *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_DayCounter, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Date *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Date, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (BigInteger)(arg1)->dayCount((Date const &)*arg2,(Date const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_DayCounter_yearsfraction_____SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "DayCounter-year-fraction"
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Date *arg4 = 0 ;
    Date *arg5 = 0 ;
    Time result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (DayCounter *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_DayCounter, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Date *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Date, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg4 = (Date *) SWIG_MustGetPtr(argv[3], SWIGTYPE_p_Date, 4, 0);
        if (arg4 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg5 = (Date *) SWIG_MustGetPtr(argv[4], SWIGTYPE_p_Date, 5, 0);
        if (arg5 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4,(Date const &)*arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_DayCounter_yearsfraction_____SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "DayCounter-year-fraction"
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Date *arg4 = 0 ;
    Time result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (DayCounter *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_DayCounter, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Date *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Date, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg4 = (Date *) SWIG_MustGetPtr(argv[3], SWIGTYPE_p_Date, 4, 0);
        if (arg4 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_DayCounter_yearsfraction_____SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "DayCounter-year-fraction"
    DayCounter *arg1 = (DayCounter *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    Time result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (DayCounter *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_DayCounter, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Date *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Date, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_DayCounter_yearsfraction___(int argc, Scheme_Object **argv) {
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_DayCounter, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    return _wrap_DayCounter_yearsfraction_____SWIG_2(argc,argv);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_DayCounter, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        void *ptr;
                        if (SWIG_ConvertPtr(argv[3], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                            _v = 0;
                        } else {
                            _v = 1;
                        }
                    }
                    if (_v) {
                        return _wrap_DayCounter_yearsfraction_____SWIG_1(argc,argv);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_DayCounter, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        void *ptr;
                        if (SWIG_ConvertPtr(argv[3], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                            _v = 0;
                        } else {
                            _v = 1;
                        }
                    }
                    if (_v) {
                        {
                            void *ptr;
                            if (SWIG_ConvertPtr(argv[4], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                                _v = 0;
                            } else {
                                _v = 1;
                            }
                        }
                        if (_v) {
                            return _wrap_DayCounter_yearsfraction_____SWIG_0(argc,argv);
                        }
                    }
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'DayCounter_year-fraction'");
}


static Scheme_Object *_wrap_DayCounter_gstring___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "DayCounter->string"
    DayCounter *arg1 = (DayCounter *) 0 ;
    std::string result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (DayCounter *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_DayCounter, 1, 0);
    }
    {
        try {
            result = DayCounter___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string((&result)->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_DayCounter (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-DayCounter"
    DayCounter *arg1 = (DayCounter *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (DayCounter *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_DayCounter, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__DayCounter(DayCounter *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__DayCounter_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__DayCounter, i, fields);
    return obj;
}

static Scheme_Object *_wrap_DayCountereq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "DayCounter=?"
    DayCounter *arg1 = 0 ;
    DayCounter *arg2 = 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (DayCounter *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_DayCounter, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (DayCounter *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_DayCounter, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (bool)DayCounter_equal((DayCounter const &)*arg1,(DayCounter const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Actual360 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Actual360"
    QuantLib::Actual360 *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Actual360 *)new QuantLib::Actual360();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Actual360, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Actual360 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Actual360"
    QuantLib::Actual360 *arg1 = (QuantLib::Actual360 *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Actual360 *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Actual360, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Actual360(QuantLib::Actual360 *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Actual360_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Actual360, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Actual365Fixed (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Actual365Fixed"
    QuantLib::Actual365Fixed *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Actual365Fixed *)new QuantLib::Actual365Fixed();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Actual365Fixed, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Actual365Fixed (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Actual365Fixed"
    QuantLib::Actual365Fixed *arg1 = (QuantLib::Actual365Fixed *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Actual365Fixed *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Actual365Fixed, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Actual365Fixed(QuantLib::Actual365Fixed *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Actual365Fixed_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Actual365Fixed, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Thirty360_USA(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Thirty360-USA"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Thirty360_USA);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Thirty360_BondBasis(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Thirty360-BondBasis"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Thirty360_BondBasis);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Thirty360_European(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Thirty360-European"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Thirty360_European);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Thirty360_EurobondBasis(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Thirty360-EurobondBasis"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Thirty360_EurobondBasis);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Thirty360_Italian(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Thirty360-Italian"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Thirty360_Italian);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Thirty360__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Thirty360"
    QuantLib::Thirty360::Convention arg1 ;
    QuantLib::Thirty360 *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0])) 
        scheme_wrong_type(FUNC_NAME, "integer", 1 - 1, argc, argv);
        arg1 = (QuantLib::Thirty360::Convention) SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (QuantLib::Thirty360 *)new QuantLib::Thirty360(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Thirty360, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Thirty360__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Thirty360"
    QuantLib::Thirty360 *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Thirty360 *)new QuantLib::Thirty360();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Thirty360, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_Thirty360(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_Thirty360__SWIG_1(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_Thirty360__SWIG_0(argc,argv);
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_Thirty360'");
}


static Scheme_Object *_wrap_delete_Thirty360 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Thirty360"
    QuantLib::Thirty360 *arg1 = (QuantLib::Thirty360 *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Thirty360 *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Thirty360, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Thirty360(QuantLib::Thirty360 *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Thirty360_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Thirty360, i, fields);
    return obj;
}

static Scheme_Object *_wrap_ActualActual_ISMA(int argc, Scheme_Object** argv) {
#define FUNC_NAME "ActualActual-ISMA"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_ActualActual_ISMA);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_ActualActual_Bond(int argc, Scheme_Object** argv) {
#define FUNC_NAME "ActualActual-Bond"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_ActualActual_Bond);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_ActualActual_ISDA(int argc, Scheme_Object** argv) {
#define FUNC_NAME "ActualActual-ISDA"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_ActualActual_ISDA);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_ActualActual_Historical(int argc, Scheme_Object** argv) {
#define FUNC_NAME "ActualActual-Historical"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_ActualActual_Historical);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_ActualActual_AFB(int argc, Scheme_Object** argv) {
#define FUNC_NAME "ActualActual-AFB"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_ActualActual_AFB);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_ActualActual_Euro(int argc, Scheme_Object** argv) {
#define FUNC_NAME "ActualActual-Euro"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_ActualActual_Euro);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_ActualActual__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-ActualActual"
    QuantLib::ActualActual::Convention arg1 ;
    QuantLib::ActualActual *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0])) 
        scheme_wrong_type(FUNC_NAME, "integer", 1 - 1, argc, argv);
        arg1 = (QuantLib::ActualActual::Convention) SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (QuantLib::ActualActual *)new QuantLib::ActualActual(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__ActualActual, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_ActualActual__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-ActualActual"
    QuantLib::ActualActual *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::ActualActual *)new QuantLib::ActualActual();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__ActualActual, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_ActualActual(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_ActualActual__SWIG_1(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_ActualActual__SWIG_0(argc,argv);
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_ActualActual'");
}


static Scheme_Object *_wrap_delete_ActualActual (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-ActualActual"
    QuantLib::ActualActual *arg1 = (QuantLib::ActualActual *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::ActualActual *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__ActualActual, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__ActualActual(QuantLib::ActualActual *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__ActualActual_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__ActualActual, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_OneDayCounter (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-OneDayCounter"
    QuantLib::OneDayCounter *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::OneDayCounter *)new QuantLib::OneDayCounter();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__OneDayCounter, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_OneDayCounter (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-OneDayCounter"
    QuantLib::OneDayCounter *arg1 = (QuantLib::OneDayCounter *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::OneDayCounter *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__OneDayCounter, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__OneDayCounter(QuantLib::OneDayCounter *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__OneDayCounter_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__OneDayCounter, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_SimpleDayCounter (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-SimpleDayCounter"
    QuantLib::SimpleDayCounter *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::SimpleDayCounter *)new QuantLib::SimpleDayCounter();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__SimpleDayCounter, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_SimpleDayCounter (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-SimpleDayCounter"
    QuantLib::SimpleDayCounter *arg1 = (QuantLib::SimpleDayCounter *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::SimpleDayCounter *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__SimpleDayCounter, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__SimpleDayCounter(QuantLib::SimpleDayCounter *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__SimpleDayCounter_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__SimpleDayCounter, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Simple(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Simple"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Simple);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Compounded(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Compounded"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Compounded);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Continuous(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Continuous"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Continuous);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_SimpleThenCompounded(int argc, Scheme_Object** argv) {
#define FUNC_NAME "SimpleThenCompounded"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_SimpleThenCompounded);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_InterestRate__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-InterestRate"
    InterestRate *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (InterestRate *)new InterestRate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_InterestRate__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-InterestRate"
    Rate arg1 ;
    DayCounter *arg2 = 0 ;
    Compounding arg3 ;
    Frequency arg4 ;
    InterestRate *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_REALP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"real", 1 - 1, argc, argv);
        arg1 = scheme_real_to_double(argv[0]);
    }
    {
        arg2 = (DayCounter *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_DayCounter, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[2])) 
        scheme_wrong_type(FUNC_NAME, "integer", 3 - 1, argc, argv);
        arg3 = (Compounding) SCHEME_INT_VAL(argv[2]);
    }
    {
        if (!SCHEME_INTP(argv[3])) 
        scheme_wrong_type(FUNC_NAME, "integer", 4 - 1, argc, argv);
        arg4 = (Frequency) SCHEME_INT_VAL(argv[3]);
    }
    {
        try {
            result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_InterestRate__SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-InterestRate"
    Rate arg1 ;
    DayCounter *arg2 = 0 ;
    Compounding arg3 ;
    InterestRate *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_REALP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"real", 1 - 1, argc, argv);
        arg1 = scheme_real_to_double(argv[0]);
    }
    {
        arg2 = (DayCounter *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_DayCounter, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[2])) 
        scheme_wrong_type(FUNC_NAME, "integer", 3 - 1, argc, argv);
        arg3 = (Compounding) SCHEME_INT_VAL(argv[2]);
    }
    {
        try {
            result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_InterestRate(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_InterestRate__SWIG_0(argc,argv);
    }
    if (argc == 3) {
        int _v;
        {
            _v = (SCHEME_REALP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_DayCounter, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = (SCHEME_INTP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_InterestRate__SWIG_2(argc,argv);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            _v = (SCHEME_REALP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_DayCounter, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = (SCHEME_INTP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (SCHEME_INTP(argv[3])) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_new_InterestRate__SWIG_1(argc,argv);
                    }
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_InterestRate'");
}


static Scheme_Object *_wrap_InterestRate_rate (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-rate"
    InterestRate *arg1 = (InterestRate *) 0 ;
    Rate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        try {
            result = (Rate)((InterestRate const *)arg1)->rate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_InterestRate_dayscounter___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-day-counter"
    InterestRate *arg1 = (InterestRate *) 0 ;
    SwigValueWrapper<DayCounter > result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        try {
            result = ((InterestRate const *)arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_InterestRate_compounding (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-compounding"
    InterestRate *arg1 = (InterestRate *) 0 ;
    Compounding result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        try {
            result = (Compounding)((InterestRate const *)arg1)->compounding();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_make_integer_value(result);
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_InterestRate_frequency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-frequency"
    InterestRate *arg1 = (InterestRate *) 0 ;
    Frequency result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        try {
            result = (Frequency)((InterestRate const *)arg1)->frequency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_make_integer_value(result);
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_InterestRate_discountsfactor_____SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-discount-factor"
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    DiscountFactor result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_InterestRate_discountsfactor_____SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-discount-factor"
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date arg2 ;
    Date arg3 ;
    DiscountFactor result;
    Date *argp2 ;
    Date *argp3 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        argp2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        arg2 = *argp2;
    }
    {
        argp3 = (Date *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Date, 3, 0);
        arg3 = *argp3;
    }
    {
        try {
            result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_InterestRate_discountsfactor___(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_InterestRate, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_InterestRate_discountsfactor_____SWIG_0(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_InterestRate, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    return _wrap_InterestRate_discountsfactor_____SWIG_1(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'InterestRate_discount-factor'");
}


static Scheme_Object *_wrap_InterestRate_compoundsfactor_____SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-compound-factor"
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_InterestRate_compoundsfactor_____SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-compound-factor"
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date arg2 ;
    Date arg3 ;
    Real result;
    Date *argp2 ;
    Date *argp3 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        argp2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        arg2 = *argp2;
    }
    {
        argp3 = (Date *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Date, 3, 0);
        arg3 = *argp3;
    }
    {
        try {
            result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_InterestRate_compoundsfactor___(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_InterestRate, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_InterestRate_compoundsfactor_____SWIG_0(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_InterestRate, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    return _wrap_InterestRate_compoundsfactor_____SWIG_1(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'InterestRate_compound-factor'");
}


static Scheme_Object *_wrap_InterestRate_impliedsrate_____SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-implied-rate"
    Real arg1 ;
    Time arg2 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_REALP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"real", 1 - 1, argc, argv);
        arg1 = scheme_real_to_double(argv[0]);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        arg3 = (DayCounter *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_DayCounter, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[3])) 
        scheme_wrong_type(FUNC_NAME, "integer", 4 - 1, argc, argv);
        arg4 = (Compounding) SCHEME_INT_VAL(argv[3]);
    }
    {
        if (!SCHEME_INTP(argv[4])) 
        scheme_wrong_type(FUNC_NAME, "integer", 5 - 1, argc, argv);
        arg5 = (Frequency) SCHEME_INT_VAL(argv[4]);
    }
    {
        try {
            result = InterestRate::impliedRate(arg1,arg2,(DayCounter const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_InterestRate_impliedsrate_____SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-implied-rate"
    Real arg1 ;
    Time arg2 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_REALP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"real", 1 - 1, argc, argv);
        arg1 = scheme_real_to_double(argv[0]);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        arg3 = (DayCounter *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_DayCounter, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[3])) 
        scheme_wrong_type(FUNC_NAME, "integer", 4 - 1, argc, argv);
        arg4 = (Compounding) SCHEME_INT_VAL(argv[3]);
    }
    {
        try {
            result = InterestRate::impliedRate(arg1,arg2,(DayCounter const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_InterestRate_impliedsrate_____SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-implied-rate"
    Real arg1 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_REALP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"real", 1 - 1, argc, argv);
        arg1 = scheme_real_to_double(argv[0]);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Date *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Date, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg4 = (DayCounter *) SWIG_MustGetPtr(argv[3], SWIGTYPE_p_DayCounter, 4, 0);
        if (arg4 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[4])) 
        scheme_wrong_type(FUNC_NAME, "integer", 5 - 1, argc, argv);
        arg5 = (Compounding) SCHEME_INT_VAL(argv[4]);
    }
    {
        if (!SCHEME_INTP(argv[5])) 
        scheme_wrong_type(FUNC_NAME, "integer", 6 - 1, argc, argv);
        arg6 = (Frequency) SCHEME_INT_VAL(argv[5]);
    }
    {
        try {
            result = InterestRate::impliedRate(arg1,(Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_InterestRate_impliedsrate_____SWIG_3 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-implied-rate"
    Real arg1 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_REALP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"real", 1 - 1, argc, argv);
        arg1 = scheme_real_to_double(argv[0]);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Date *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Date, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg4 = (DayCounter *) SWIG_MustGetPtr(argv[3], SWIGTYPE_p_DayCounter, 4, 0);
        if (arg4 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[4])) 
        scheme_wrong_type(FUNC_NAME, "integer", 5 - 1, argc, argv);
        arg5 = (Compounding) SCHEME_INT_VAL(argv[4]);
    }
    {
        try {
            result = InterestRate::impliedRate(arg1,(Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_InterestRate_impliedsrate___(int argc, Scheme_Object **argv) {
    if (argc == 4) {
        int _v;
        {
            _v = (SCHEME_REALP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_DayCounter, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        _v = (SCHEME_INTP(argv[3])) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_InterestRate_impliedsrate_____SWIG_1(argc,argv);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            _v = (SCHEME_REALP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        void *ptr;
                        if (SWIG_ConvertPtr(argv[3], (void **) &ptr, SWIGTYPE_p_DayCounter, 0)) {
                            _v = 0;
                        } else {
                            _v = 1;
                        }
                    }
                    if (_v) {
                        {
                            _v = (SCHEME_INTP(argv[4])) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_InterestRate_impliedsrate_____SWIG_3(argc,argv);
                        }
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            _v = (SCHEME_REALP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_DayCounter, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        _v = (SCHEME_INTP(argv[3])) ? 1 : 0;
                    }
                    if (_v) {
                        {
                            _v = (SCHEME_INTP(argv[4])) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_InterestRate_impliedsrate_____SWIG_0(argc,argv);
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            _v = (SCHEME_REALP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        void *ptr;
                        if (SWIG_ConvertPtr(argv[3], (void **) &ptr, SWIGTYPE_p_DayCounter, 0)) {
                            _v = 0;
                        } else {
                            _v = 1;
                        }
                    }
                    if (_v) {
                        {
                            _v = (SCHEME_INTP(argv[4])) ? 1 : 0;
                        }
                        if (_v) {
                            {
                                _v = (SCHEME_INTP(argv[5])) ? 1 : 0;
                            }
                            if (_v) {
                                return _wrap_InterestRate_impliedsrate_____SWIG_2(argc,argv);
                            }
                        }
                    }
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'InterestRate_implied-rate'");
}


static Scheme_Object *_wrap_InterestRate_equivalentsrate_____SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-equivalent-rate"
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_INTP(argv[2])) 
        scheme_wrong_type(FUNC_NAME, "integer", 3 - 1, argc, argv);
        arg3 = (Compounding) SCHEME_INT_VAL(argv[2]);
    }
    {
        if (!SCHEME_INTP(argv[3])) 
        scheme_wrong_type(FUNC_NAME, "integer", 4 - 1, argc, argv);
        arg4 = (Frequency) SCHEME_INT_VAL(argv[3]);
    }
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_InterestRate_equivalentsrate_____SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-equivalent-rate"
    InterestRate *arg1 = (InterestRate *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_INTP(argv[2])) 
        scheme_wrong_type(FUNC_NAME, "integer", 3 - 1, argc, argv);
        arg3 = (Compounding) SCHEME_INT_VAL(argv[2]);
    }
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_InterestRate_equivalentsrate_____SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-equivalent-rate"
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    Frequency arg6 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Date *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Date, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg4 = (DayCounter *) SWIG_MustGetPtr(argv[3], SWIGTYPE_p_DayCounter, 4, 0);
        if (arg4 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[4])) 
        scheme_wrong_type(FUNC_NAME, "integer", 5 - 1, argc, argv);
        arg5 = (Compounding) SCHEME_INT_VAL(argv[4]);
    }
    {
        if (!SCHEME_INTP(argv[5])) 
        scheme_wrong_type(FUNC_NAME, "integer", 6 - 1, argc, argv);
        arg6 = (Frequency) SCHEME_INT_VAL(argv[5]);
    }
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_InterestRate_equivalentsrate_____SWIG_3 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate-equivalent-rate"
    InterestRate *arg1 = (InterestRate *) 0 ;
    Date *arg2 = 0 ;
    Date *arg3 = 0 ;
    DayCounter *arg4 = 0 ;
    Compounding arg5 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Date *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Date, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg4 = (DayCounter *) SWIG_MustGetPtr(argv[3], SWIGTYPE_p_DayCounter, 4, 0);
        if (arg4 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[4])) 
        scheme_wrong_type(FUNC_NAME, "integer", 5 - 1, argc, argv);
        arg5 = (Compounding) SCHEME_INT_VAL(argv[4]);
    }
    {
        try {
            result = ((InterestRate const *)arg1)->equivalentRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_InterestRate_equivalentsrate___(int argc, Scheme_Object **argv) {
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_InterestRate, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_INTP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_InterestRate_equivalentsrate_____SWIG_1(argc,argv);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_InterestRate, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_INTP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (SCHEME_INTP(argv[3])) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_InterestRate_equivalentsrate_____SWIG_0(argc,argv);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_InterestRate, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        void *ptr;
                        if (SWIG_ConvertPtr(argv[3], (void **) &ptr, SWIGTYPE_p_DayCounter, 0)) {
                            _v = 0;
                        } else {
                            _v = 1;
                        }
                    }
                    if (_v) {
                        {
                            _v = (SCHEME_INTP(argv[4])) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_InterestRate_equivalentsrate_____SWIG_3(argc,argv);
                        }
                    }
                }
            }
        }
    }
    if (argc == 6) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_InterestRate, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        void *ptr;
                        if (SWIG_ConvertPtr(argv[3], (void **) &ptr, SWIGTYPE_p_DayCounter, 0)) {
                            _v = 0;
                        } else {
                            _v = 1;
                        }
                    }
                    if (_v) {
                        {
                            _v = (SCHEME_INTP(argv[4])) ? 1 : 0;
                        }
                        if (_v) {
                            {
                                _v = (SCHEME_INTP(argv[5])) ? 1 : 0;
                            }
                            if (_v) {
                                return _wrap_InterestRate_equivalentsrate_____SWIG_2(argc,argv);
                            }
                        }
                    }
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'InterestRate_equivalent-rate'");
}


static Scheme_Object *_wrap_InterestRate_gstring___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "InterestRate->string"
    InterestRate *arg1 = (InterestRate *) 0 ;
    std::string result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        try {
            result = InterestRate___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string((&result)->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_InterestRate (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-InterestRate"
    InterestRate *arg1 = (InterestRate *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (InterestRate *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_InterestRate, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__InterestRate(InterestRate *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__InterestRate_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__InterestRate, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Unadjusted(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Unadjusted"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Unadjusted);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Preceding(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Preceding"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Preceding);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_ModifiedPreceding(int argc, Scheme_Object** argv) {
#define FUNC_NAME "ModifiedPreceding"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_ModifiedPreceding);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Following(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Following"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Following);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_ModifiedFollowing(int argc, Scheme_Object** argv) {
#define FUNC_NAME "ModifiedFollowing"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_ModifiedFollowing);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_MonthEndReference(int argc, Scheme_Object** argv) {
#define FUNC_NAME "MonthEndReference"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_MonthEndReference);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_JoinHolidays(int argc, Scheme_Object** argv) {
#define FUNC_NAME "JoinHolidays"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_JoinHolidays);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_JoinBusinessDays(int argc, Scheme_Object** argv) {
#define FUNC_NAME "JoinBusinessDays"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_JoinBusinessDays);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Calendar_issbusinesssdayq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar-is-business-day?"
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (bool)(arg1)->isBusinessDay((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Calendar_issholidayq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar-is-holiday?"
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (bool)(arg1)->isHoliday((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Calendar_issendsofsmonthq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar-is-end-of-month?"
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (bool)(arg1)->isEndOfMonth((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Calendar_addsholiday___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar-add-holiday"
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            (arg1)->addHoliday((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Calendar_removesholiday___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar-remove-holiday"
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            (arg1)->removeHoliday((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Calendar_adjust__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar-adjust"
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    BusinessDayConvention arg3 ;
    Date *arg4 = 0 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[2])) 
        scheme_wrong_type(FUNC_NAME, "integer", 3 - 1, argc, argv);
        arg3 = (BusinessDayConvention) SCHEME_INT_VAL(argv[2]);
    }
    {
        arg4 = (Date *) SWIG_MustGetPtr(argv[3], SWIGTYPE_p_Date, 4, 0);
        if (arg4 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (arg1)->adjust((Date const &)*arg2,arg3,(Date const &)*arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Calendar_adjust__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar-adjust"
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    BusinessDayConvention arg3 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[2])) 
        scheme_wrong_type(FUNC_NAME, "integer", 3 - 1, argc, argv);
        arg3 = (BusinessDayConvention) SCHEME_INT_VAL(argv[2]);
    }
    {
        try {
            result = (arg1)->adjust((Date const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Calendar_adjust__SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar-adjust"
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (arg1)->adjust((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_Calendar_adjust(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_Calendar_adjust__SWIG_2(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = (SCHEME_INTP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_Calendar_adjust__SWIG_1(argc,argv);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = (SCHEME_INTP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    {
                        void *ptr;
                        if (SWIG_ConvertPtr(argv[3], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                            _v = 0;
                        } else {
                            _v = 1;
                        }
                    }
                    if (_v) {
                        return _wrap_Calendar_adjust__SWIG_0(argc,argv);
                    }
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'Calendar_adjust'");
}


static Scheme_Object *_wrap_Calendar_advance__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar-advance"
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Integer arg3 ;
    TimeUnit arg4 ;
    BusinessDayConvention arg5 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"integer", 3 - 1, argc, argv);
        arg3 = SCHEME_INT_VAL(argv[2]);
    }
    {
        if (!SCHEME_INTP(argv[3])) 
        scheme_wrong_type(FUNC_NAME, "integer", 4 - 1, argc, argv);
        arg4 = (TimeUnit) SCHEME_INT_VAL(argv[3]);
    }
    {
        if (!SCHEME_INTP(argv[4])) 
        scheme_wrong_type(FUNC_NAME, "integer", 5 - 1, argc, argv);
        arg5 = (BusinessDayConvention) SCHEME_INT_VAL(argv[4]);
    }
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Calendar_advance__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar-advance"
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Integer arg3 ;
    TimeUnit arg4 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"integer", 3 - 1, argc, argv);
        arg3 = SCHEME_INT_VAL(argv[2]);
    }
    {
        if (!SCHEME_INTP(argv[3])) 
        scheme_wrong_type(FUNC_NAME, "integer", 4 - 1, argc, argv);
        arg4 = (TimeUnit) SCHEME_INT_VAL(argv[3]);
    }
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Calendar_advance__SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar-advance"
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Period *arg3 = 0 ;
    BusinessDayConvention arg4 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Period *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Period, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[3])) 
        scheme_wrong_type(FUNC_NAME, "integer", 4 - 1, argc, argv);
        arg4 = (BusinessDayConvention) SCHEME_INT_VAL(argv[3]);
    }
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Calendar_advance__SWIG_3 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar-advance"
    Calendar *arg1 = (Calendar *) 0 ;
    Date *arg2 = 0 ;
    Period *arg3 = 0 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Period *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Period, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_Calendar_advance(int argc, Scheme_Object **argv) {
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Period, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    return _wrap_Calendar_advance__SWIG_3(argc,argv);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Period, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        _v = (SCHEME_INTP(argv[3])) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_Calendar_advance__SWIG_2(argc,argv);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = (SCHEME_INTP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (SCHEME_INTP(argv[3])) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_Calendar_advance__SWIG_1(argc,argv);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = (SCHEME_INTP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (SCHEME_INTP(argv[3])) ? 1 : 0;
                    }
                    if (_v) {
                        {
                            _v = (SCHEME_INTP(argv[4])) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_Calendar_advance__SWIG_0(argc,argv);
                        }
                    }
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'Calendar_advance'");
}


static Scheme_Object *_wrap_Calendar_gstring___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar->string"
    Calendar *arg1 = (Calendar *) 0 ;
    std::string result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        try {
            result = Calendar___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string((&result)->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Calendar (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Calendar"
    Calendar *arg1 = (Calendar *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__Calendar(Calendar *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__Calendar_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__Calendar, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Calendareq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Calendar=?"
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Calendar *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Calendar, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (bool)Calendar_equal((Calendar const &)*arg1,(Calendar const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Beijing (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Beijing"
    QuantLib::Beijing *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Beijing *)new QuantLib::Beijing();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Beijing, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Beijing (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Beijing"
    QuantLib::Beijing *arg1 = (QuantLib::Beijing *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Beijing *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Beijing, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Beijing(QuantLib::Beijing *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Beijing_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Beijing, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Bombay (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Bombay"
    QuantLib::Bombay *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Bombay *)new QuantLib::Bombay();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Bombay, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Bombay (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Bombay"
    QuantLib::Bombay *arg1 = (QuantLib::Bombay *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Bombay *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Bombay, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Bombay(QuantLib::Bombay *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Bombay_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Bombay, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Bratislava (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Bratislava"
    QuantLib::Bratislava *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Bratislava *)new QuantLib::Bratislava();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Bratislava, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Bratislava (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Bratislava"
    QuantLib::Bratislava *arg1 = (QuantLib::Bratislava *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Bratislava *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Bratislava, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Bratislava(QuantLib::Bratislava *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Bratislava_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Bratislava, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Budapest (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Budapest"
    QuantLib::Budapest *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Budapest *)new QuantLib::Budapest();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Budapest, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Budapest (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Budapest"
    QuantLib::Budapest *arg1 = (QuantLib::Budapest *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Budapest *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Budapest, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Budapest(QuantLib::Budapest *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Budapest_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Budapest, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Copenhagen (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Copenhagen"
    QuantLib::Copenhagen *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Copenhagen *)new QuantLib::Copenhagen();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Copenhagen, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Copenhagen (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Copenhagen"
    QuantLib::Copenhagen *arg1 = (QuantLib::Copenhagen *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Copenhagen *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Copenhagen, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Copenhagen(QuantLib::Copenhagen *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Copenhagen_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Copenhagen, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Germany_Settlement(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Germany-Settlement"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Germany_Settlement);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Germany_FrankfurtStockExchange(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Germany-FrankfurtStockExchange"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Germany_FrankfurtStockExchange);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Germany_Xetra(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Germany-Xetra"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Germany_Xetra);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Germany_Eurex(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Germany-Eurex"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Germany_Eurex);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Germany__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Germany"
    QuantLib::Germany::Market arg1 ;
    QuantLib::Germany *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0])) 
        scheme_wrong_type(FUNC_NAME, "integer", 1 - 1, argc, argv);
        arg1 = (QuantLib::Germany::Market) SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (QuantLib::Germany *)new QuantLib::Germany(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Germany, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Germany__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Germany"
    QuantLib::Germany *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Germany *)new QuantLib::Germany();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Germany, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_Germany(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_Germany__SWIG_1(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_Germany__SWIG_0(argc,argv);
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_Germany'");
}


static Scheme_Object *_wrap_delete_Germany (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Germany"
    QuantLib::Germany *arg1 = (QuantLib::Germany *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Germany *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Germany, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Germany(QuantLib::Germany *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Germany_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Germany, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Helsinki (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Helsinki"
    QuantLib::Helsinki *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Helsinki *)new QuantLib::Helsinki();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Helsinki, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Helsinki (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Helsinki"
    QuantLib::Helsinki *arg1 = (QuantLib::Helsinki *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Helsinki *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Helsinki, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Helsinki(QuantLib::Helsinki *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Helsinki_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Helsinki, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_HongKong (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-HongKong"
    QuantLib::HongKong *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::HongKong *)new QuantLib::HongKong();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__HongKong, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_HongKong (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-HongKong"
    QuantLib::HongKong *arg1 = (QuantLib::HongKong *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::HongKong *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__HongKong, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__HongKong(QuantLib::HongKong *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__HongKong_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__HongKong, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Italy_Settlement(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Italy-Settlement"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Italy_Settlement);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Italy_Exchange(int argc, Scheme_Object** argv) {
#define FUNC_NAME "Italy-Exchange"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_Italy_Exchange);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Italy__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Italy"
    QuantLib::Italy::Market arg1 ;
    QuantLib::Italy *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0])) 
        scheme_wrong_type(FUNC_NAME, "integer", 1 - 1, argc, argv);
        arg1 = (QuantLib::Italy::Market) SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (QuantLib::Italy *)new QuantLib::Italy(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Italy, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Italy__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Italy"
    QuantLib::Italy *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Italy *)new QuantLib::Italy();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Italy, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_Italy(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_Italy__SWIG_1(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_Italy__SWIG_0(argc,argv);
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_Italy'");
}


static Scheme_Object *_wrap_delete_Italy (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Italy"
    QuantLib::Italy *arg1 = (QuantLib::Italy *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Italy *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Italy, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Italy(QuantLib::Italy *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Italy_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Italy, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Istanbul (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Istanbul"
    QuantLib::Istanbul *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Istanbul *)new QuantLib::Istanbul();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Istanbul, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Istanbul (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Istanbul"
    QuantLib::Istanbul *arg1 = (QuantLib::Istanbul *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Istanbul *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Istanbul, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Istanbul(QuantLib::Istanbul *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Istanbul_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Istanbul, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Johannesburg (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Johannesburg"
    QuantLib::Johannesburg *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Johannesburg *)new QuantLib::Johannesburg();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Johannesburg, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Johannesburg (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Johannesburg"
    QuantLib::Johannesburg *arg1 = (QuantLib::Johannesburg *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Johannesburg *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Johannesburg, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Johannesburg(QuantLib::Johannesburg *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Johannesburg_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Johannesburg, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_NullCalendar (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-NullCalendar"
    QuantLib::NullCalendar *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::NullCalendar *)new QuantLib::NullCalendar();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__NullCalendar, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_NullCalendar (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-NullCalendar"
    QuantLib::NullCalendar *arg1 = (QuantLib::NullCalendar *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::NullCalendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__NullCalendar, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__NullCalendar(QuantLib::NullCalendar *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__NullCalendar_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__NullCalendar, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Oslo (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Oslo"
    QuantLib::Oslo *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Oslo *)new QuantLib::Oslo();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Oslo, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Oslo (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Oslo"
    QuantLib::Oslo *arg1 = (QuantLib::Oslo *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Oslo *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Oslo, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Oslo(QuantLib::Oslo *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Oslo_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Oslo, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Prague (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Prague"
    QuantLib::Prague *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Prague *)new QuantLib::Prague();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Prague, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Prague (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Prague"
    QuantLib::Prague *arg1 = (QuantLib::Prague *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Prague *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Prague, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Prague(QuantLib::Prague *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Prague_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Prague, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Riyadh (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Riyadh"
    QuantLib::Riyadh *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Riyadh *)new QuantLib::Riyadh();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Riyadh, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Riyadh (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Riyadh"
    QuantLib::Riyadh *arg1 = (QuantLib::Riyadh *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Riyadh *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Riyadh, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Riyadh(QuantLib::Riyadh *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Riyadh_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Riyadh, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Seoul (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Seoul"
    QuantLib::Seoul *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Seoul *)new QuantLib::Seoul();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Seoul, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Seoul (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Seoul"
    QuantLib::Seoul *arg1 = (QuantLib::Seoul *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Seoul *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Seoul, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Seoul(QuantLib::Seoul *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Seoul_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Seoul, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Singapore (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Singapore"
    QuantLib::Singapore *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Singapore *)new QuantLib::Singapore();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Singapore, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Singapore (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Singapore"
    QuantLib::Singapore *arg1 = (QuantLib::Singapore *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Singapore *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Singapore, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Singapore(QuantLib::Singapore *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Singapore_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Singapore, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Stockholm (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Stockholm"
    QuantLib::Stockholm *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Stockholm *)new QuantLib::Stockholm();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Stockholm, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Stockholm (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Stockholm"
    QuantLib::Stockholm *arg1 = (QuantLib::Stockholm *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Stockholm *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Stockholm, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Stockholm(QuantLib::Stockholm *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Stockholm_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Stockholm, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Sydney (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Sydney"
    QuantLib::Sydney *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Sydney *)new QuantLib::Sydney();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Sydney, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Sydney (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Sydney"
    QuantLib::Sydney *arg1 = (QuantLib::Sydney *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Sydney *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Sydney, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Sydney(QuantLib::Sydney *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Sydney_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Sydney, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_TARGET (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-TARGET"
    QuantLib::TARGET *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::TARGET *)new QuantLib::TARGET();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__TARGET, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_TARGET (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-TARGET"
    QuantLib::TARGET *arg1 = (QuantLib::TARGET *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::TARGET *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__TARGET, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__TARGET(QuantLib::TARGET *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__TARGET_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__TARGET, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Taipei (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Taipei"
    QuantLib::Taipei *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Taipei *)new QuantLib::Taipei();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Taipei, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Taipei (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Taipei"
    QuantLib::Taipei *arg1 = (QuantLib::Taipei *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Taipei *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Taipei, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Taipei(QuantLib::Taipei *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Taipei_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Taipei, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Taiwan (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Taiwan"
    QuantLib::Taiwan *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Taiwan *)new QuantLib::Taiwan();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Taiwan, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Taiwan (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Taiwan"
    QuantLib::Taiwan *arg1 = (QuantLib::Taiwan *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Taiwan *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Taiwan, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Taiwan(QuantLib::Taiwan *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Taiwan_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Taiwan, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Tokyo (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Tokyo"
    QuantLib::Tokyo *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Tokyo *)new QuantLib::Tokyo();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Tokyo, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Tokyo (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Tokyo"
    QuantLib::Tokyo *arg1 = (QuantLib::Tokyo *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Tokyo *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Tokyo, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Tokyo(QuantLib::Tokyo *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Tokyo_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Tokyo, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Toronto (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Toronto"
    QuantLib::Toronto *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Toronto *)new QuantLib::Toronto();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Toronto, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Toronto (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Toronto"
    QuantLib::Toronto *arg1 = (QuantLib::Toronto *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Toronto *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Toronto, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Toronto(QuantLib::Toronto *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Toronto_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Toronto, i, fields);
    return obj;
}

static Scheme_Object *_wrap_UnitedKingdom_Settlement(int argc, Scheme_Object** argv) {
#define FUNC_NAME "UnitedKingdom-Settlement"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_UnitedKingdom_Settlement);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_UnitedKingdom_Exchange(int argc, Scheme_Object** argv) {
#define FUNC_NAME "UnitedKingdom-Exchange"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_UnitedKingdom_Exchange);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_UnitedKingdom_Metals(int argc, Scheme_Object** argv) {
#define FUNC_NAME "UnitedKingdom-Metals"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_UnitedKingdom_Metals);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_UnitedKingdom__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-UnitedKingdom"
    QuantLib::UnitedKingdom::Market arg1 ;
    QuantLib::UnitedKingdom *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0])) 
        scheme_wrong_type(FUNC_NAME, "integer", 1 - 1, argc, argv);
        arg1 = (QuantLib::UnitedKingdom::Market) SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__UnitedKingdom, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_UnitedKingdom__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-UnitedKingdom"
    QuantLib::UnitedKingdom *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__UnitedKingdom, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_UnitedKingdom(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_UnitedKingdom__SWIG_1(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_UnitedKingdom__SWIG_0(argc,argv);
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_UnitedKingdom'");
}


static Scheme_Object *_wrap_delete_UnitedKingdom (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-UnitedKingdom"
    QuantLib::UnitedKingdom *arg1 = (QuantLib::UnitedKingdom *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::UnitedKingdom *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__UnitedKingdom, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__UnitedKingdom(QuantLib::UnitedKingdom *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__UnitedKingdom_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__UnitedKingdom, i, fields);
    return obj;
}

static Scheme_Object *_wrap_UnitedStates_Settlement(int argc, Scheme_Object** argv) {
#define FUNC_NAME "UnitedStates-Settlement"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_UnitedStates_Settlement);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_UnitedStates_Exchange(int argc, Scheme_Object** argv) {
#define FUNC_NAME "UnitedStates-Exchange"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_UnitedStates_Exchange);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_UnitedStates_GovernmentBond(int argc, Scheme_Object** argv) {
#define FUNC_NAME "UnitedStates-GovernmentBond"
    Scheme_Object *swig_result;
    
    {
        swig_result = scheme_make_integer_value(_wrap_const_UnitedStates_GovernmentBond);
    }
    
    return swig_result;
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_UnitedStates__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-UnitedStates"
    QuantLib::UnitedStates::Market arg1 ;
    QuantLib::UnitedStates *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0])) 
        scheme_wrong_type(FUNC_NAME, "integer", 1 - 1, argc, argv);
        arg1 = (QuantLib::UnitedStates::Market) SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__UnitedStates, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_UnitedStates__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-UnitedStates"
    QuantLib::UnitedStates *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__UnitedStates, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_UnitedStates(int argc, Scheme_Object **argv) {
    if (argc == 0) {
        return _wrap_new_UnitedStates__SWIG_1(argc,argv);
    }
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_UnitedStates__SWIG_0(argc,argv);
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_UnitedStates'");
}


static Scheme_Object *_wrap_delete_UnitedStates (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-UnitedStates"
    QuantLib::UnitedStates *arg1 = (QuantLib::UnitedStates *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::UnitedStates *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__UnitedStates, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__UnitedStates(QuantLib::UnitedStates *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__UnitedStates_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__UnitedStates, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Warsaw (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Warsaw"
    QuantLib::Warsaw *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Warsaw *)new QuantLib::Warsaw();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Warsaw, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Warsaw (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Warsaw"
    QuantLib::Warsaw *arg1 = (QuantLib::Warsaw *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Warsaw *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Warsaw, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Warsaw(QuantLib::Warsaw *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Warsaw_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Warsaw, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Wellington (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Wellington"
    QuantLib::Wellington *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Wellington *)new QuantLib::Wellington();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Wellington, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Wellington (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Wellington"
    QuantLib::Wellington *arg1 = (QuantLib::Wellington *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Wellington *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Wellington, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Wellington(QuantLib::Wellington *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Wellington_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Wellington, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Zurich (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Zurich"
    QuantLib::Zurich *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::Zurich *)new QuantLib::Zurich();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__Zurich, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Zurich (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Zurich"
    QuantLib::Zurich *arg1 = (QuantLib::Zurich *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::Zurich *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__Zurich, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__Zurich(QuantLib::Zurich *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__Zurich_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__Zurich, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_JointCalendar__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-JointCalendar"
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    JointCalendarRule arg3 ;
    QuantLib::JointCalendar *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Calendar *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Calendar, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[2])) 
        scheme_wrong_type(FUNC_NAME, "integer", 3 - 1, argc, argv);
        arg3 = (JointCalendarRule) SCHEME_INT_VAL(argv[2]);
    }
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__JointCalendar, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_JointCalendar__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-JointCalendar"
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    QuantLib::JointCalendar *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Calendar *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Calendar, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__JointCalendar, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_JointCalendar__SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-JointCalendar"
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    JointCalendarRule arg4 ;
    QuantLib::JointCalendar *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Calendar *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Calendar, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Calendar *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Calendar, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[3])) 
        scheme_wrong_type(FUNC_NAME, "integer", 4 - 1, argc, argv);
        arg4 = (JointCalendarRule) SCHEME_INT_VAL(argv[3]);
    }
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__JointCalendar, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_JointCalendar__SWIG_3 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-JointCalendar"
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    QuantLib::JointCalendar *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Calendar *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Calendar, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Calendar *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Calendar, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__JointCalendar, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_JointCalendar__SWIG_4 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-JointCalendar"
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    Calendar *arg4 = 0 ;
    JointCalendarRule arg5 ;
    QuantLib::JointCalendar *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Calendar *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Calendar, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Calendar *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Calendar, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg4 = (Calendar *) SWIG_MustGetPtr(argv[3], SWIGTYPE_p_Calendar, 4, 0);
        if (arg4 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[4])) 
        scheme_wrong_type(FUNC_NAME, "integer", 5 - 1, argc, argv);
        arg5 = (JointCalendarRule) SCHEME_INT_VAL(argv[4]);
    }
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__JointCalendar, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_JointCalendar__SWIG_5 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-JointCalendar"
    Calendar *arg1 = 0 ;
    Calendar *arg2 = 0 ;
    Calendar *arg3 = 0 ;
    Calendar *arg4 = 0 ;
    QuantLib::JointCalendar *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Calendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Calendar, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Calendar *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Calendar, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (Calendar *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_Calendar, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg4 = (Calendar *) SWIG_MustGetPtr(argv[3], SWIGTYPE_p_Calendar, 4, 0);
        if (arg4 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__JointCalendar, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_JointCalendar(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_new_JointCalendar__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    return _wrap_new_JointCalendar__SWIG_3(argc,argv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = (SCHEME_INTP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_JointCalendar__SWIG_0(argc,argv);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        void *ptr;
                        if (SWIG_ConvertPtr(argv[3], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                            _v = 0;
                        } else {
                            _v = 1;
                        }
                    }
                    if (_v) {
                        return _wrap_new_JointCalendar__SWIG_5(argc,argv);
                    }
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        _v = (SCHEME_INTP(argv[3])) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_new_JointCalendar__SWIG_2(argc,argv);
                    }
                }
            }
        }
    }
    if (argc == 5) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    void *ptr;
                    if (SWIG_ConvertPtr(argv[2], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                        _v = 0;
                    } else {
                        _v = 1;
                    }
                }
                if (_v) {
                    {
                        void *ptr;
                        if (SWIG_ConvertPtr(argv[3], (void **) &ptr, SWIGTYPE_p_Calendar, 0)) {
                            _v = 0;
                        } else {
                            _v = 1;
                        }
                    }
                    if (_v) {
                        {
                            _v = (SCHEME_INTP(argv[4])) ? 1 : 0;
                        }
                        if (_v) {
                            return _wrap_new_JointCalendar__SWIG_4(argc,argv);
                        }
                    }
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_JointCalendar'");
}


static Scheme_Object *_wrap_delete_JointCalendar (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-JointCalendar"
    QuantLib::JointCalendar *arg1 = (QuantLib::JointCalendar *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::JointCalendar *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__JointCalendar, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__JointCalendar(QuantLib::JointCalendar *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__JointCalendar_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__JointCalendar, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_Rounding (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Rounding"
    Rounding *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (Rounding *)new Rounding();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Rounding, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Rounding_apply (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Rounding-apply"
    Rounding *arg1 = (Rounding *) 0 ;
    Decimal arg2 ;
    Decimal result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Rounding *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Rounding, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (Decimal)((Rounding const *)arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Rounding (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Rounding"
    Rounding *arg1 = (Rounding *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Rounding *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Rounding, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__Rounding(Rounding *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__Rounding_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__Rounding, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_UpRounding__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-UpRounding"
    Integer arg1 ;
    Integer arg2 ;
    UpRounding *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            result = (UpRounding *)new UpRounding(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_UpRounding, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_UpRounding__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-UpRounding"
    Integer arg1 ;
    UpRounding *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (UpRounding *)new UpRounding(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_UpRounding, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_UpRounding(int argc, Scheme_Object **argv) {
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_UpRounding__SWIG_1(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (SCHEME_INTP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_UpRounding__SWIG_0(argc,argv);
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_UpRounding'");
}


static Scheme_Object *_wrap_delete_UpRounding (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-UpRounding"
    UpRounding *arg1 = (UpRounding *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (UpRounding *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_UpRounding, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__UpRounding(UpRounding *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__UpRounding_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__UpRounding, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_DownRounding__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-DownRounding"
    Integer arg1 ;
    Integer arg2 ;
    DownRounding *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            result = (DownRounding *)new DownRounding(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_DownRounding, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_DownRounding__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-DownRounding"
    Integer arg1 ;
    DownRounding *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (DownRounding *)new DownRounding(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_DownRounding, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_DownRounding(int argc, Scheme_Object **argv) {
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_DownRounding__SWIG_1(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (SCHEME_INTP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_DownRounding__SWIG_0(argc,argv);
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_DownRounding'");
}


static Scheme_Object *_wrap_delete_DownRounding (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-DownRounding"
    DownRounding *arg1 = (DownRounding *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (DownRounding *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_DownRounding, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__DownRounding(DownRounding *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__DownRounding_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__DownRounding, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_ClosestRounding__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-ClosestRounding"
    Integer arg1 ;
    Integer arg2 ;
    ClosestRounding *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            result = (ClosestRounding *)new ClosestRounding(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_ClosestRounding, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_ClosestRounding__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-ClosestRounding"
    Integer arg1 ;
    ClosestRounding *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (ClosestRounding *)new ClosestRounding(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_ClosestRounding, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_ClosestRounding(int argc, Scheme_Object **argv) {
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_ClosestRounding__SWIG_1(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (SCHEME_INTP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_ClosestRounding__SWIG_0(argc,argv);
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_ClosestRounding'");
}


static Scheme_Object *_wrap_delete_ClosestRounding (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-ClosestRounding"
    ClosestRounding *arg1 = (ClosestRounding *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (ClosestRounding *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_ClosestRounding, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__ClosestRounding(ClosestRounding *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__ClosestRounding_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__ClosestRounding, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_CeilingTruncation__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-CeilingTruncation"
    Integer arg1 ;
    Integer arg2 ;
    CeilingTruncation *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            result = (CeilingTruncation *)new CeilingTruncation(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_CeilingTruncation, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_CeilingTruncation__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-CeilingTruncation"
    Integer arg1 ;
    CeilingTruncation *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (CeilingTruncation *)new CeilingTruncation(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_CeilingTruncation, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_CeilingTruncation(int argc, Scheme_Object **argv) {
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_CeilingTruncation__SWIG_1(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (SCHEME_INTP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_CeilingTruncation__SWIG_0(argc,argv);
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_CeilingTruncation'");
}


static Scheme_Object *_wrap_delete_CeilingTruncation (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-CeilingTruncation"
    CeilingTruncation *arg1 = (CeilingTruncation *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (CeilingTruncation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_CeilingTruncation, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__CeilingTruncation(CeilingTruncation *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__CeilingTruncation_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__CeilingTruncation, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_FloorTruncation__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-FloorTruncation"
    Integer arg1 ;
    Integer arg2 ;
    FloorTruncation *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        if (!SCHEME_INTP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"integer", 2 - 1, argc, argv);
        arg2 = SCHEME_INT_VAL(argv[1]);
    }
    {
        try {
            result = (FloorTruncation *)new FloorTruncation(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_FloorTruncation, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_FloorTruncation__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-FloorTruncation"
    Integer arg1 ;
    FloorTruncation *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (!SCHEME_INTP(argv[0]))
        scheme_wrong_type(FUNC_NAME,"integer", 1 - 1, argc, argv);
        arg1 = SCHEME_INT_VAL(argv[0]);
    }
    {
        try {
            result = (FloorTruncation *)new FloorTruncation(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_FloorTruncation, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_new_FloorTruncation(int argc, Scheme_Object **argv) {
    if (argc == 1) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            return _wrap_new_FloorTruncation__SWIG_1(argc,argv);
        }
    }
    if (argc == 2) {
        int _v;
        {
            _v = (SCHEME_INTP(argv[0])) ? 1 : 0;
        }
        if (_v) {
            {
                _v = (SCHEME_INTP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_new_FloorTruncation__SWIG_0(argc,argv);
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'new_FloorTruncation'");
}


static Scheme_Object *_wrap_delete_FloorTruncation (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-FloorTruncation"
    FloorTruncation *arg1 = (FloorTruncation *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (FloorTruncation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_FloorTruncation, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__FloorTruncation(FloorTruncation *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__FloorTruncation_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__FloorTruncation, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Currency_name (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Currency-name"
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Currency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Currency, 1, 0);
    }
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->name();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string(result->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Currency_code (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Currency-code"
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Currency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Currency, 1, 0);
    }
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->code();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string(result->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Currency_numericscode___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Currency-numeric-code"
    Currency *arg1 = (Currency *) 0 ;
    Integer result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Currency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Currency, 1, 0);
    }
    {
        try {
            result = (Integer)((Currency const *)arg1)->numericCode();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Currency_symbol (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Currency-symbol"
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Currency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Currency, 1, 0);
    }
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->symbol();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string(result->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Currency_fractionssymbol___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Currency-fraction-symbol"
    Currency *arg1 = (Currency *) 0 ;
    std::string *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Currency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Currency, 1, 0);
    }
    {
        try {
            {
                std::string const &_result_ref = ((Currency const *)arg1)->fractionSymbol();
                result = (std::string *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string(result->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Currency_fractionsspersunit___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Currency-fractions-per-unit"
    Currency *arg1 = (Currency *) 0 ;
    Integer result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Currency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Currency, 1, 0);
    }
    {
        try {
            result = (Integer)((Currency const *)arg1)->fractionsPerUnit();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_integer_value(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Currency_rounding (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Currency-rounding"
    Currency *arg1 = (Currency *) 0 ;
    Rounding *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Currency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Currency, 1, 0);
    }
    {
        try {
            {
                Rounding const &_result_ref = ((Currency const *)arg1)->rounding();
                result = (Rounding *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Rounding, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Currency_issvalidq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Currency-is-valid?"
    Currency *arg1 = (Currency *) 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Currency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Currency, 1, 0);
    }
    {
        try {
            result = (bool)((Currency const *)arg1)->isValid();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Currency_triangulationscurrency___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Currency-triangulation-currency"
    Currency *arg1 = (Currency *) 0 ;
    Currency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Currency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Currency, 1, 0);
    }
    {
        try {
            {
                Currency const &_result_ref = ((Currency const *)arg1)->triangulationCurrency();
                result = (Currency *) &_result_ref;
            }
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Currency, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_Currency_gstring___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Currency->string"
    Currency *arg1 = (Currency *) 0 ;
    std::string result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Currency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Currency, 1, 0);
    }
    {
        try {
            result = Currency___str__(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_string((&result)->c_str());
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_Currency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-Currency"
    Currency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (Currency *)new Currency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_Currency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_Currency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-Currency"
    Currency *arg1 = (Currency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Currency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Currency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__Currency(Currency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__Currency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__Currency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_Currencyeq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "Currency=?"
    Currency *arg1 = 0 ;
    Currency *arg2 = 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (Currency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_Currency, 1, 0);
        if (arg1 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg2 = (Currency *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Currency, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (bool)Currency_equal((Currency const &)*arg1,(Currency const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_new_ARSCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-ARSCurrency"
    QuantLib::ARSCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::ARSCurrency *)new QuantLib::ARSCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__ARSCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_ARSCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-ARSCurrency"
    QuantLib::ARSCurrency *arg1 = (QuantLib::ARSCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::ARSCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__ARSCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__ARSCurrency(QuantLib::ARSCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__ARSCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__ARSCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_ATSCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-ATSCurrency"
    QuantLib::ATSCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::ATSCurrency *)new QuantLib::ATSCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__ATSCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_ATSCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-ATSCurrency"
    QuantLib::ATSCurrency *arg1 = (QuantLib::ATSCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::ATSCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__ATSCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__ATSCurrency(QuantLib::ATSCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__ATSCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__ATSCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_AUDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-AUDCurrency"
    QuantLib::AUDCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::AUDCurrency *)new QuantLib::AUDCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__AUDCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_AUDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-AUDCurrency"
    QuantLib::AUDCurrency *arg1 = (QuantLib::AUDCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::AUDCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__AUDCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__AUDCurrency(QuantLib::AUDCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__AUDCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__AUDCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_BDTCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-BDTCurrency"
    QuantLib::BDTCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::BDTCurrency *)new QuantLib::BDTCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__BDTCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_BDTCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-BDTCurrency"
    QuantLib::BDTCurrency *arg1 = (QuantLib::BDTCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::BDTCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__BDTCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__BDTCurrency(QuantLib::BDTCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__BDTCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__BDTCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_BEFCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-BEFCurrency"
    QuantLib::BEFCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::BEFCurrency *)new QuantLib::BEFCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__BEFCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_BEFCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-BEFCurrency"
    QuantLib::BEFCurrency *arg1 = (QuantLib::BEFCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::BEFCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__BEFCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__BEFCurrency(QuantLib::BEFCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__BEFCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__BEFCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_BGLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-BGLCurrency"
    QuantLib::BGLCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::BGLCurrency *)new QuantLib::BGLCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__BGLCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_BGLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-BGLCurrency"
    QuantLib::BGLCurrency *arg1 = (QuantLib::BGLCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::BGLCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__BGLCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__BGLCurrency(QuantLib::BGLCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__BGLCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__BGLCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_BRLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-BRLCurrency"
    QuantLib::BRLCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::BRLCurrency *)new QuantLib::BRLCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__BRLCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_BRLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-BRLCurrency"
    QuantLib::BRLCurrency *arg1 = (QuantLib::BRLCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::BRLCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__BRLCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__BRLCurrency(QuantLib::BRLCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__BRLCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__BRLCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_BYRCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-BYRCurrency"
    QuantLib::BYRCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::BYRCurrency *)new QuantLib::BYRCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__BYRCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_BYRCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-BYRCurrency"
    QuantLib::BYRCurrency *arg1 = (QuantLib::BYRCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::BYRCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__BYRCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__BYRCurrency(QuantLib::BYRCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__BYRCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__BYRCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_CADCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-CADCurrency"
    QuantLib::CADCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::CADCurrency *)new QuantLib::CADCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__CADCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_CADCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-CADCurrency"
    QuantLib::CADCurrency *arg1 = (QuantLib::CADCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::CADCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__CADCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__CADCurrency(QuantLib::CADCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__CADCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__CADCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_CHFCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-CHFCurrency"
    QuantLib::CHFCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::CHFCurrency *)new QuantLib::CHFCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__CHFCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_CHFCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-CHFCurrency"
    QuantLib::CHFCurrency *arg1 = (QuantLib::CHFCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::CHFCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__CHFCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__CHFCurrency(QuantLib::CHFCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__CHFCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__CHFCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_CLPCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-CLPCurrency"
    QuantLib::CLPCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::CLPCurrency *)new QuantLib::CLPCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__CLPCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_CLPCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-CLPCurrency"
    QuantLib::CLPCurrency *arg1 = (QuantLib::CLPCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::CLPCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__CLPCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__CLPCurrency(QuantLib::CLPCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__CLPCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__CLPCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_CNYCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-CNYCurrency"
    QuantLib::CNYCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::CNYCurrency *)new QuantLib::CNYCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__CNYCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_CNYCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-CNYCurrency"
    QuantLib::CNYCurrency *arg1 = (QuantLib::CNYCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::CNYCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__CNYCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__CNYCurrency(QuantLib::CNYCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__CNYCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__CNYCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_COPCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-COPCurrency"
    QuantLib::COPCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::COPCurrency *)new QuantLib::COPCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__COPCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_COPCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-COPCurrency"
    QuantLib::COPCurrency *arg1 = (QuantLib::COPCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::COPCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__COPCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__COPCurrency(QuantLib::COPCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__COPCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__COPCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_CYPCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-CYPCurrency"
    QuantLib::CYPCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::CYPCurrency *)new QuantLib::CYPCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__CYPCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_CYPCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-CYPCurrency"
    QuantLib::CYPCurrency *arg1 = (QuantLib::CYPCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::CYPCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__CYPCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__CYPCurrency(QuantLib::CYPCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__CYPCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__CYPCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_CZKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-CZKCurrency"
    QuantLib::CZKCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::CZKCurrency *)new QuantLib::CZKCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__CZKCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_CZKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-CZKCurrency"
    QuantLib::CZKCurrency *arg1 = (QuantLib::CZKCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::CZKCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__CZKCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__CZKCurrency(QuantLib::CZKCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__CZKCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__CZKCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_DEMCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-DEMCurrency"
    QuantLib::DEMCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::DEMCurrency *)new QuantLib::DEMCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__DEMCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_DEMCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-DEMCurrency"
    QuantLib::DEMCurrency *arg1 = (QuantLib::DEMCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::DEMCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__DEMCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__DEMCurrency(QuantLib::DEMCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__DEMCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__DEMCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_DKKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-DKKCurrency"
    QuantLib::DKKCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::DKKCurrency *)new QuantLib::DKKCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__DKKCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_DKKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-DKKCurrency"
    QuantLib::DKKCurrency *arg1 = (QuantLib::DKKCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::DKKCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__DKKCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__DKKCurrency(QuantLib::DKKCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__DKKCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__DKKCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_EEKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-EEKCurrency"
    QuantLib::EEKCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::EEKCurrency *)new QuantLib::EEKCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__EEKCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_EEKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-EEKCurrency"
    QuantLib::EEKCurrency *arg1 = (QuantLib::EEKCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::EEKCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__EEKCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__EEKCurrency(QuantLib::EEKCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__EEKCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__EEKCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_ESPCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-ESPCurrency"
    QuantLib::ESPCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::ESPCurrency *)new QuantLib::ESPCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__ESPCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_ESPCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-ESPCurrency"
    QuantLib::ESPCurrency *arg1 = (QuantLib::ESPCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::ESPCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__ESPCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__ESPCurrency(QuantLib::ESPCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__ESPCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__ESPCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_EURCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-EURCurrency"
    QuantLib::EURCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::EURCurrency *)new QuantLib::EURCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__EURCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_EURCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-EURCurrency"
    QuantLib::EURCurrency *arg1 = (QuantLib::EURCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::EURCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__EURCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__EURCurrency(QuantLib::EURCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__EURCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__EURCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_FIMCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-FIMCurrency"
    QuantLib::FIMCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::FIMCurrency *)new QuantLib::FIMCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__FIMCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_FIMCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-FIMCurrency"
    QuantLib::FIMCurrency *arg1 = (QuantLib::FIMCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::FIMCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__FIMCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__FIMCurrency(QuantLib::FIMCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__FIMCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__FIMCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_FRFCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-FRFCurrency"
    QuantLib::FRFCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::FRFCurrency *)new QuantLib::FRFCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__FRFCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_FRFCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-FRFCurrency"
    QuantLib::FRFCurrency *arg1 = (QuantLib::FRFCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::FRFCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__FRFCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__FRFCurrency(QuantLib::FRFCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__FRFCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__FRFCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_GBPCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-GBPCurrency"
    QuantLib::GBPCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::GBPCurrency *)new QuantLib::GBPCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__GBPCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_GBPCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-GBPCurrency"
    QuantLib::GBPCurrency *arg1 = (QuantLib::GBPCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::GBPCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__GBPCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__GBPCurrency(QuantLib::GBPCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__GBPCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__GBPCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_GRDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-GRDCurrency"
    QuantLib::GRDCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::GRDCurrency *)new QuantLib::GRDCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__GRDCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_GRDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-GRDCurrency"
    QuantLib::GRDCurrency *arg1 = (QuantLib::GRDCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::GRDCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__GRDCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__GRDCurrency(QuantLib::GRDCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__GRDCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__GRDCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_HKDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-HKDCurrency"
    QuantLib::HKDCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::HKDCurrency *)new QuantLib::HKDCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__HKDCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_HKDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-HKDCurrency"
    QuantLib::HKDCurrency *arg1 = (QuantLib::HKDCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::HKDCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__HKDCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__HKDCurrency(QuantLib::HKDCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__HKDCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__HKDCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_HUFCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-HUFCurrency"
    QuantLib::HUFCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::HUFCurrency *)new QuantLib::HUFCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__HUFCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_HUFCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-HUFCurrency"
    QuantLib::HUFCurrency *arg1 = (QuantLib::HUFCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::HUFCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__HUFCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__HUFCurrency(QuantLib::HUFCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__HUFCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__HUFCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_IEPCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-IEPCurrency"
    QuantLib::IEPCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::IEPCurrency *)new QuantLib::IEPCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__IEPCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_IEPCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-IEPCurrency"
    QuantLib::IEPCurrency *arg1 = (QuantLib::IEPCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::IEPCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__IEPCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__IEPCurrency(QuantLib::IEPCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__IEPCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__IEPCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_ILSCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-ILSCurrency"
    QuantLib::ILSCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::ILSCurrency *)new QuantLib::ILSCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__ILSCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_ILSCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-ILSCurrency"
    QuantLib::ILSCurrency *arg1 = (QuantLib::ILSCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::ILSCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__ILSCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__ILSCurrency(QuantLib::ILSCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__ILSCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__ILSCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_INRCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-INRCurrency"
    QuantLib::INRCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::INRCurrency *)new QuantLib::INRCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__INRCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_INRCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-INRCurrency"
    QuantLib::INRCurrency *arg1 = (QuantLib::INRCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::INRCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__INRCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__INRCurrency(QuantLib::INRCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__INRCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__INRCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_IQDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-IQDCurrency"
    QuantLib::IQDCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::IQDCurrency *)new QuantLib::IQDCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__IQDCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_IQDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-IQDCurrency"
    QuantLib::IQDCurrency *arg1 = (QuantLib::IQDCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::IQDCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__IQDCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__IQDCurrency(QuantLib::IQDCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__IQDCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__IQDCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_IRRCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-IRRCurrency"
    QuantLib::IRRCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::IRRCurrency *)new QuantLib::IRRCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__IRRCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_IRRCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-IRRCurrency"
    QuantLib::IRRCurrency *arg1 = (QuantLib::IRRCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::IRRCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__IRRCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__IRRCurrency(QuantLib::IRRCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__IRRCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__IRRCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_ISKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-ISKCurrency"
    QuantLib::ISKCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::ISKCurrency *)new QuantLib::ISKCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__ISKCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_ISKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-ISKCurrency"
    QuantLib::ISKCurrency *arg1 = (QuantLib::ISKCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::ISKCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__ISKCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__ISKCurrency(QuantLib::ISKCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__ISKCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__ISKCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_ITLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-ITLCurrency"
    QuantLib::ITLCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::ITLCurrency *)new QuantLib::ITLCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__ITLCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_ITLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-ITLCurrency"
    QuantLib::ITLCurrency *arg1 = (QuantLib::ITLCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::ITLCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__ITLCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__ITLCurrency(QuantLib::ITLCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__ITLCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__ITLCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_JPYCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-JPYCurrency"
    QuantLib::JPYCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::JPYCurrency *)new QuantLib::JPYCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__JPYCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_JPYCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-JPYCurrency"
    QuantLib::JPYCurrency *arg1 = (QuantLib::JPYCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::JPYCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__JPYCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__JPYCurrency(QuantLib::JPYCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__JPYCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__JPYCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_KRWCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-KRWCurrency"
    QuantLib::KRWCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::KRWCurrency *)new QuantLib::KRWCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__KRWCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_KRWCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-KRWCurrency"
    QuantLib::KRWCurrency *arg1 = (QuantLib::KRWCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::KRWCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__KRWCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__KRWCurrency(QuantLib::KRWCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__KRWCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__KRWCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_KWDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-KWDCurrency"
    QuantLib::KWDCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::KWDCurrency *)new QuantLib::KWDCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__KWDCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_KWDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-KWDCurrency"
    QuantLib::KWDCurrency *arg1 = (QuantLib::KWDCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::KWDCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__KWDCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__KWDCurrency(QuantLib::KWDCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__KWDCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__KWDCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_LTLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-LTLCurrency"
    QuantLib::LTLCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::LTLCurrency *)new QuantLib::LTLCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__LTLCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_LTLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-LTLCurrency"
    QuantLib::LTLCurrency *arg1 = (QuantLib::LTLCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::LTLCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__LTLCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__LTLCurrency(QuantLib::LTLCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__LTLCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__LTLCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_LUFCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-LUFCurrency"
    QuantLib::LUFCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::LUFCurrency *)new QuantLib::LUFCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__LUFCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_LUFCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-LUFCurrency"
    QuantLib::LUFCurrency *arg1 = (QuantLib::LUFCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::LUFCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__LUFCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__LUFCurrency(QuantLib::LUFCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__LUFCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__LUFCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_LVLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-LVLCurrency"
    QuantLib::LVLCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::LVLCurrency *)new QuantLib::LVLCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__LVLCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_LVLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-LVLCurrency"
    QuantLib::LVLCurrency *arg1 = (QuantLib::LVLCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::LVLCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__LVLCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__LVLCurrency(QuantLib::LVLCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__LVLCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__LVLCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_MTLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-MTLCurrency"
    QuantLib::MTLCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::MTLCurrency *)new QuantLib::MTLCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__MTLCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_MTLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-MTLCurrency"
    QuantLib::MTLCurrency *arg1 = (QuantLib::MTLCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::MTLCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__MTLCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__MTLCurrency(QuantLib::MTLCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__MTLCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__MTLCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_MXNCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-MXNCurrency"
    QuantLib::MXNCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::MXNCurrency *)new QuantLib::MXNCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__MXNCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_MXNCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-MXNCurrency"
    QuantLib::MXNCurrency *arg1 = (QuantLib::MXNCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::MXNCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__MXNCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__MXNCurrency(QuantLib::MXNCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__MXNCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__MXNCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_NLGCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-NLGCurrency"
    QuantLib::NLGCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::NLGCurrency *)new QuantLib::NLGCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__NLGCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_NLGCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-NLGCurrency"
    QuantLib::NLGCurrency *arg1 = (QuantLib::NLGCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::NLGCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__NLGCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__NLGCurrency(QuantLib::NLGCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__NLGCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__NLGCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_NOKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-NOKCurrency"
    QuantLib::NOKCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::NOKCurrency *)new QuantLib::NOKCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__NOKCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_NOKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-NOKCurrency"
    QuantLib::NOKCurrency *arg1 = (QuantLib::NOKCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::NOKCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__NOKCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__NOKCurrency(QuantLib::NOKCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__NOKCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__NOKCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_NPRCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-NPRCurrency"
    QuantLib::NPRCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::NPRCurrency *)new QuantLib::NPRCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__NPRCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_NPRCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-NPRCurrency"
    QuantLib::NPRCurrency *arg1 = (QuantLib::NPRCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::NPRCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__NPRCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__NPRCurrency(QuantLib::NPRCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__NPRCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__NPRCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_NZDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-NZDCurrency"
    QuantLib::NZDCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::NZDCurrency *)new QuantLib::NZDCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__NZDCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_NZDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-NZDCurrency"
    QuantLib::NZDCurrency *arg1 = (QuantLib::NZDCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::NZDCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__NZDCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__NZDCurrency(QuantLib::NZDCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__NZDCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__NZDCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_PKRCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-PKRCurrency"
    QuantLib::PKRCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::PKRCurrency *)new QuantLib::PKRCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__PKRCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_PKRCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-PKRCurrency"
    QuantLib::PKRCurrency *arg1 = (QuantLib::PKRCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::PKRCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__PKRCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__PKRCurrency(QuantLib::PKRCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__PKRCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__PKRCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_PLNCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-PLNCurrency"
    QuantLib::PLNCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::PLNCurrency *)new QuantLib::PLNCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__PLNCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_PLNCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-PLNCurrency"
    QuantLib::PLNCurrency *arg1 = (QuantLib::PLNCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::PLNCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__PLNCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__PLNCurrency(QuantLib::PLNCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__PLNCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__PLNCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_PTECurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-PTECurrency"
    QuantLib::PTECurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::PTECurrency *)new QuantLib::PTECurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__PTECurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_PTECurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-PTECurrency"
    QuantLib::PTECurrency *arg1 = (QuantLib::PTECurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::PTECurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__PTECurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__PTECurrency(QuantLib::PTECurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__PTECurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__PTECurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_ROLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-ROLCurrency"
    QuantLib::ROLCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::ROLCurrency *)new QuantLib::ROLCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__ROLCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_ROLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-ROLCurrency"
    QuantLib::ROLCurrency *arg1 = (QuantLib::ROLCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::ROLCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__ROLCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__ROLCurrency(QuantLib::ROLCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__ROLCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__ROLCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_SARCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-SARCurrency"
    QuantLib::SARCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::SARCurrency *)new QuantLib::SARCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__SARCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_SARCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-SARCurrency"
    QuantLib::SARCurrency *arg1 = (QuantLib::SARCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::SARCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__SARCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__SARCurrency(QuantLib::SARCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__SARCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__SARCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_SEKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-SEKCurrency"
    QuantLib::SEKCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::SEKCurrency *)new QuantLib::SEKCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__SEKCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_SEKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-SEKCurrency"
    QuantLib::SEKCurrency *arg1 = (QuantLib::SEKCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::SEKCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__SEKCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__SEKCurrency(QuantLib::SEKCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__SEKCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__SEKCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_SGDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-SGDCurrency"
    QuantLib::SGDCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::SGDCurrency *)new QuantLib::SGDCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__SGDCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_SGDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-SGDCurrency"
    QuantLib::SGDCurrency *arg1 = (QuantLib::SGDCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::SGDCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__SGDCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__SGDCurrency(QuantLib::SGDCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__SGDCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__SGDCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_SITCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-SITCurrency"
    QuantLib::SITCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::SITCurrency *)new QuantLib::SITCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__SITCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_SITCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-SITCurrency"
    QuantLib::SITCurrency *arg1 = (QuantLib::SITCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::SITCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__SITCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__SITCurrency(QuantLib::SITCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__SITCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__SITCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_SKKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-SKKCurrency"
    QuantLib::SKKCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::SKKCurrency *)new QuantLib::SKKCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__SKKCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_SKKCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-SKKCurrency"
    QuantLib::SKKCurrency *arg1 = (QuantLib::SKKCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::SKKCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__SKKCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__SKKCurrency(QuantLib::SKKCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__SKKCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__SKKCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_THBCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-THBCurrency"
    QuantLib::THBCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::THBCurrency *)new QuantLib::THBCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__THBCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_THBCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-THBCurrency"
    QuantLib::THBCurrency *arg1 = (QuantLib::THBCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::THBCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__THBCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__THBCurrency(QuantLib::THBCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__THBCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__THBCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_TRLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-TRLCurrency"
    QuantLib::TRLCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::TRLCurrency *)new QuantLib::TRLCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__TRLCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_TRLCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-TRLCurrency"
    QuantLib::TRLCurrency *arg1 = (QuantLib::TRLCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::TRLCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__TRLCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__TRLCurrency(QuantLib::TRLCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__TRLCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__TRLCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_TRYCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-TRYCurrency"
    QuantLib::TRYCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::TRYCurrency *)new QuantLib::TRYCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__TRYCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_TRYCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-TRYCurrency"
    QuantLib::TRYCurrency *arg1 = (QuantLib::TRYCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::TRYCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__TRYCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__TRYCurrency(QuantLib::TRYCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__TRYCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__TRYCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_TTDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-TTDCurrency"
    QuantLib::TTDCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::TTDCurrency *)new QuantLib::TTDCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__TTDCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_TTDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-TTDCurrency"
    QuantLib::TTDCurrency *arg1 = (QuantLib::TTDCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::TTDCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__TTDCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__TTDCurrency(QuantLib::TTDCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__TTDCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__TTDCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_TWDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-TWDCurrency"
    QuantLib::TWDCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::TWDCurrency *)new QuantLib::TWDCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__TWDCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_TWDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-TWDCurrency"
    QuantLib::TWDCurrency *arg1 = (QuantLib::TWDCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::TWDCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__TWDCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__TWDCurrency(QuantLib::TWDCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__TWDCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__TWDCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_USDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-USDCurrency"
    QuantLib::USDCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::USDCurrency *)new QuantLib::USDCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__USDCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_USDCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-USDCurrency"
    QuantLib::USDCurrency *arg1 = (QuantLib::USDCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::USDCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__USDCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__USDCurrency(QuantLib::USDCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__USDCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__USDCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_VEBCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-VEBCurrency"
    QuantLib::VEBCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::VEBCurrency *)new QuantLib::VEBCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__VEBCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_VEBCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-VEBCurrency"
    QuantLib::VEBCurrency *arg1 = (QuantLib::VEBCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::VEBCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__VEBCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__VEBCurrency(QuantLib::VEBCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__VEBCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__VEBCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_ZARCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-ZARCurrency"
    QuantLib::ZARCurrency *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        try {
            result = (QuantLib::ZARCurrency *)new QuantLib::ZARCurrency();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_QuantLib__ZARCurrency, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_delete_ZARCurrency (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-ZARCurrency"
    QuantLib::ZARCurrency *arg1 = (QuantLib::ZARCurrency *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (QuantLib::ZARCurrency *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_QuantLib__ZARCurrency, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__QuantLib__ZARCurrency(QuantLib::ZARCurrency *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__QuantLib__ZARCurrency_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__QuantLib__ZARCurrency, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_LinearInterpolation (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-LinearInterpolation"
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeLinearInterpolation *result;
    Array temp1 ;
    Array temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size size = SCHEME_VEC_SIZE(argv[1]);
            temp2 = Array(size);
            arg2 = &temp2;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp2[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                2, argc, argv);
            }
        } else {
            arg2 = (Array *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Array,2,0);
        }
    }
    {
        try {
            result = (SafeLinearInterpolation *)new SafeLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_SafeLinearInterpolation, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_LinearInterpolation_call__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "LinearInterpolation-call"
    SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeLinearInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeLinearInterpolation, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_BOOLP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"boolean", 3 - 1, argc, argv);
        arg3 = SCHEME_TRUEP(argv[2]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_LinearInterpolation_call__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "LinearInterpolation-call"
    SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
    Real arg2 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeLinearInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeLinearInterpolation, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_LinearInterpolation_call(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeLinearInterpolation, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_LinearInterpolation_call__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeLinearInterpolation, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_BOOLP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_LinearInterpolation_call__SWIG_0(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'LinearInterpolation_call'");
}


static Scheme_Object *_wrap_delete_LinearInterpolation (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-LinearInterpolation"
    SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeLinearInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeLinearInterpolation, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__SafeLinearInterpolation(SafeLinearInterpolation *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__SafeLinearInterpolation_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__SafeLinearInterpolation, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_LogLinearInterpolation (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-LogLinearInterpolation"
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeLogLinearInterpolation *result;
    Array temp1 ;
    Array temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size size = SCHEME_VEC_SIZE(argv[1]);
            temp2 = Array(size);
            arg2 = &temp2;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp2[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                2, argc, argv);
            }
        } else {
            arg2 = (Array *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Array,2,0);
        }
    }
    {
        try {
            result = (SafeLogLinearInterpolation *)new SafeLogLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_SafeLogLinearInterpolation, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_LogLinearInterpolation_call__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "LogLinearInterpolation-call"
    SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeLogLinearInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeLogLinearInterpolation, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_BOOLP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"boolean", 3 - 1, argc, argv);
        arg3 = SCHEME_TRUEP(argv[2]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_LogLinearInterpolation_call__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "LogLinearInterpolation-call"
    SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
    Real arg2 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeLogLinearInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeLogLinearInterpolation, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_LogLinearInterpolation_call(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeLogLinearInterpolation, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_LogLinearInterpolation_call__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeLogLinearInterpolation, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_BOOLP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_LogLinearInterpolation_call__SWIG_0(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'LogLinearInterpolation_call'");
}


static Scheme_Object *_wrap_delete_LogLinearInterpolation (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-LogLinearInterpolation"
    SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeLogLinearInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeLogLinearInterpolation, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__SafeLogLinearInterpolation(SafeLogLinearInterpolation *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__SafeLogLinearInterpolation_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__SafeLogLinearInterpolation, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_BackwardFlatInterpolation (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-BackwardFlatInterpolation"
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeBackwardFlatInterpolation *result;
    Array temp1 ;
    Array temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size size = SCHEME_VEC_SIZE(argv[1]);
            temp2 = Array(size);
            arg2 = &temp2;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp2[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                2, argc, argv);
            }
        } else {
            arg2 = (Array *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Array,2,0);
        }
    }
    {
        try {
            result = (SafeBackwardFlatInterpolation *)new SafeBackwardFlatInterpolation((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_SafeBackwardFlatInterpolation, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_BackwardFlatInterpolation_call__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "BackwardFlatInterpolation-call"
    SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeBackwardFlatInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeBackwardFlatInterpolation, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_BOOLP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"boolean", 3 - 1, argc, argv);
        arg3 = SCHEME_TRUEP(argv[2]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_BackwardFlatInterpolation_call__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "BackwardFlatInterpolation-call"
    SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
    Real arg2 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeBackwardFlatInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeBackwardFlatInterpolation, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_BackwardFlatInterpolation_call(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeBackwardFlatInterpolation, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_BackwardFlatInterpolation_call__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeBackwardFlatInterpolation, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_BOOLP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_BackwardFlatInterpolation_call__SWIG_0(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'BackwardFlatInterpolation_call'");
}


static Scheme_Object *_wrap_delete_BackwardFlatInterpolation (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-BackwardFlatInterpolation"
    SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeBackwardFlatInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeBackwardFlatInterpolation, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__SafeBackwardFlatInterpolation(SafeBackwardFlatInterpolation *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__SafeBackwardFlatInterpolation_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__SafeBackwardFlatInterpolation, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_ForwardFlatInterpolation (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-ForwardFlatInterpolation"
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeForwardFlatInterpolation *result;
    Array temp1 ;
    Array temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size size = SCHEME_VEC_SIZE(argv[1]);
            temp2 = Array(size);
            arg2 = &temp2;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp2[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                2, argc, argv);
            }
        } else {
            arg2 = (Array *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Array,2,0);
        }
    }
    {
        try {
            result = (SafeForwardFlatInterpolation *)new SafeForwardFlatInterpolation((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_SafeForwardFlatInterpolation, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_ForwardFlatInterpolation_call__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "ForwardFlatInterpolation-call"
    SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeForwardFlatInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeForwardFlatInterpolation, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_BOOLP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"boolean", 3 - 1, argc, argv);
        arg3 = SCHEME_TRUEP(argv[2]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_ForwardFlatInterpolation_call__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "ForwardFlatInterpolation-call"
    SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
    Real arg2 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeForwardFlatInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeForwardFlatInterpolation, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_ForwardFlatInterpolation_call(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeForwardFlatInterpolation, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_ForwardFlatInterpolation_call__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeForwardFlatInterpolation, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_BOOLP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_ForwardFlatInterpolation_call__SWIG_0(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'ForwardFlatInterpolation_call'");
}


static Scheme_Object *_wrap_delete_ForwardFlatInterpolation (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-ForwardFlatInterpolation"
    SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeForwardFlatInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeForwardFlatInterpolation, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__SafeForwardFlatInterpolation(SafeForwardFlatInterpolation *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__SafeForwardFlatInterpolation_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__SafeForwardFlatInterpolation, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_CubicSpline (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-CubicSpline"
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeNaturalCubicSpline *result;
    Array temp1 ;
    Array temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size size = SCHEME_VEC_SIZE(argv[1]);
            temp2 = Array(size);
            arg2 = &temp2;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp2[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                2, argc, argv);
            }
        } else {
            arg2 = (Array *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Array,2,0);
        }
    }
    {
        try {
            result = (SafeNaturalCubicSpline *)new SafeNaturalCubicSpline((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_SafeNaturalCubicSpline, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_CubicSpline_call__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "CubicSpline-call"
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalCubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_BOOLP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"boolean", 3 - 1, argc, argv);
        arg3 = SCHEME_TRUEP(argv[2]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_CubicSpline_call__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "CubicSpline-call"
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalCubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_CubicSpline_call(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeNaturalCubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_CubicSpline_call__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeNaturalCubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_BOOLP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_CubicSpline_call__SWIG_0(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'CubicSpline_call'");
}


static Scheme_Object *_wrap_CubicSpline_derivative__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "CubicSpline-derivative"
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalCubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_BOOLP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"boolean", 3 - 1, argc, argv);
        arg3 = SCHEME_TRUEP(argv[2]);
    }
    {
        try {
            result = (Real)SafeNaturalCubicSpline_derivative__SWIG_0(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_CubicSpline_derivative__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "CubicSpline-derivative"
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalCubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (Real)SafeNaturalCubicSpline_derivative__SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_CubicSpline_derivative(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeNaturalCubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_CubicSpline_derivative__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeNaturalCubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_BOOLP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_CubicSpline_derivative__SWIG_0(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'CubicSpline_derivative'");
}


static Scheme_Object *_wrap_CubicSpline_secondDerivative__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "CubicSpline-secondDerivative"
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalCubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_BOOLP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"boolean", 3 - 1, argc, argv);
        arg3 = SCHEME_TRUEP(argv[2]);
    }
    {
        try {
            result = (Real)SafeNaturalCubicSpline_secondDerivative__SWIG_0(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_CubicSpline_secondDerivative__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "CubicSpline-secondDerivative"
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalCubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (Real)SafeNaturalCubicSpline_secondDerivative__SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_CubicSpline_secondDerivative(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeNaturalCubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_CubicSpline_secondDerivative__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeNaturalCubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_BOOLP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_CubicSpline_secondDerivative__SWIG_0(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'CubicSpline_secondDerivative'");
}


static Scheme_Object *_wrap_delete_CubicSpline (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-CubicSpline"
    SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalCubicSpline, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__SafeNaturalCubicSpline(SafeNaturalCubicSpline *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__SafeNaturalCubicSpline_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__SafeNaturalCubicSpline, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_MonotonicCubicSpline (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-MonotonicCubicSpline"
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    SafeNaturalMonotonicCubicSpline *result;
    Array temp1 ;
    Array temp2 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size size = SCHEME_VEC_SIZE(argv[1]);
            temp2 = Array(size);
            arg2 = &temp2;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp2[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                2, argc, argv);
            }
        } else {
            arg2 = (Array *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Array,2,0);
        }
    }
    {
        try {
            result = (SafeNaturalMonotonicCubicSpline *)new SafeNaturalMonotonicCubicSpline((Array const &)*arg1,(Array const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_MonotonicCubicSpline_call__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "MonotonicCubicSpline-call"
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalMonotonicCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_BOOLP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"boolean", 3 - 1, argc, argv);
        arg3 = SCHEME_TRUEP(argv[2]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_MonotonicCubicSpline_call__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "MonotonicCubicSpline-call"
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalMonotonicCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_MonotonicCubicSpline_call(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_MonotonicCubicSpline_call__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_BOOLP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_MonotonicCubicSpline_call__SWIG_0(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'MonotonicCubicSpline_call'");
}


static Scheme_Object *_wrap_MonotonicCubicSpline_derivative__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "MonotonicCubicSpline-derivative"
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalMonotonicCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_BOOLP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"boolean", 3 - 1, argc, argv);
        arg3 = SCHEME_TRUEP(argv[2]);
    }
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_MonotonicCubicSpline_derivative__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "MonotonicCubicSpline-derivative"
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalMonotonicCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_MonotonicCubicSpline_derivative(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_MonotonicCubicSpline_derivative__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_BOOLP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_MonotonicCubicSpline_derivative__SWIG_0(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'MonotonicCubicSpline_derivative'");
}


static Scheme_Object *_wrap_MonotonicCubicSpline_secondDerivative__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "MonotonicCubicSpline-secondDerivative"
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    bool arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalMonotonicCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_BOOLP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"boolean", 3 - 1, argc, argv);
        arg3 = SCHEME_TRUEP(argv[2]);
    }
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(arg1,arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_MonotonicCubicSpline_secondDerivative__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "MonotonicCubicSpline-secondDerivative"
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    Real arg2 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalMonotonicCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (Real)SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(arg1,arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_MonotonicCubicSpline_secondDerivative(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_MonotonicCubicSpline_secondDerivative__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_BOOLP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_MonotonicCubicSpline_secondDerivative__SWIG_0(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'MonotonicCubicSpline_secondDerivative'");
}


static Scheme_Object *_wrap_delete_MonotonicCubicSpline (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-MonotonicCubicSpline"
    SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeNaturalMonotonicCubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeNaturalMonotonicCubicSpline, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__SafeNaturalMonotonicCubicSpline(SafeNaturalMonotonicCubicSpline *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__SafeNaturalMonotonicCubicSpline_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__SafeNaturalMonotonicCubicSpline, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_BilinearInterpolation (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-BilinearInterpolation"
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix *arg3 = 0 ;
    SafeBilinearInterpolation *result;
    Array temp1 ;
    Array temp2 ;
    Matrix temp3 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size size = SCHEME_VEC_SIZE(argv[1]);
            temp2 = Array(size);
            arg2 = &temp2;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp2[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                2, argc, argv);
            }
        } else {
            arg2 = (Array *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Array,2,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[2])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[2]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[2]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp3 = Matrix(rows,cols);
            arg3 = &temp3;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        3, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp3[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        3, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    3, argc, argv);
                }
            }
        } else {
            arg3 = (Matrix *) SWIG_MustGetPtr(argv[2],SWIGTYPE_p_Matrix,3,0);
        }
    }
    {
        try {
            result = (SafeBilinearInterpolation *)new SafeBilinearInterpolation((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_SafeBilinearInterpolation, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_BilinearInterpolation_call__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "BilinearInterpolation-call"
    SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
    Real arg2 ;
    Real arg3 ;
    bool arg4 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeBilinearInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeBilinearInterpolation, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_REALP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"real", 3 - 1, argc, argv);
        arg3 = scheme_real_to_double(argv[2]);
    }
    {
        if (!SCHEME_BOOLP(argv[3]))
        scheme_wrong_type(FUNC_NAME,"boolean", 4 - 1, argc, argv);
        arg4 = SCHEME_TRUEP(argv[3]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_BilinearInterpolation_call__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "BilinearInterpolation-call"
    SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
    Real arg2 ;
    Real arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeBilinearInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeBilinearInterpolation, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_REALP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"real", 3 - 1, argc, argv);
        arg3 = scheme_real_to_double(argv[2]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_BilinearInterpolation_call(int argc, Scheme_Object **argv) {
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeBilinearInterpolation, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_REALP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_BilinearInterpolation_call__SWIG_1(argc,argv);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeBilinearInterpolation, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_REALP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (SCHEME_BOOLP(argv[3])) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BilinearInterpolation_call__SWIG_0(argc,argv);
                    }
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'BilinearInterpolation_call'");
}


static Scheme_Object *_wrap_delete_BilinearInterpolation (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-BilinearInterpolation"
    SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeBilinearInterpolation *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeBilinearInterpolation, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__SafeBilinearInterpolation(SafeBilinearInterpolation *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__SafeBilinearInterpolation_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__SafeBilinearInterpolation, i, fields);
    return obj;
}

static Scheme_Object *_wrap_new_BicubicSpline (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "new-BicubicSpline"
    Array *arg1 = 0 ;
    Array *arg2 = 0 ;
    Matrix *arg3 = 0 ;
    SafeBicubicSpline *result;
    Array temp1 ;
    Array temp2 ;
    Matrix temp3 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        if (SCHEME_VECTORP(argv[0])) {
            Size size = SCHEME_VEC_SIZE(argv[0]);
            temp1 = Array(size);
            arg1 = &temp1;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[0]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp1[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                1, argc, argv);
            }
        } else {
            arg1 = (Array *) SWIG_MustGetPtr(argv[0],SWIGTYPE_p_Array,1,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[1])) {
            Size size = SCHEME_VEC_SIZE(argv[1]);
            temp2 = Array(size);
            arg2 = &temp2;
            Scheme_Object** items = SCHEME_VEC_ELS(argv[1]);
            for (Size i=0; i<size; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_REALP(o))
                temp2[i] = scheme_real_to_double(o);
                else
                scheme_wrong_type(FUNC_NAME, "Array",
                2, argc, argv);
            }
        } else {
            arg2 = (Array *) SWIG_MustGetPtr(argv[1],SWIGTYPE_p_Array,2,0);
        }
    }
    {
        if (SCHEME_VECTORP(argv[2])) {
            Size rows, cols;
            rows = SCHEME_VEC_SIZE(argv[2]);
            Scheme_Object** items = SCHEME_VEC_ELS(argv[2]);
            if (rows > 0) {
                if (SCHEME_VECTORP(items[0])) {
                    cols = SCHEME_VEC_SIZE(items[0]);
                } else {
                    cols = 0;
                }
            }
            temp3 = Matrix(rows,cols);
            arg3 = &temp3;
            for (Size i=0; i<rows; i++) {
                Scheme_Object* o = items[i];
                if (SCHEME_VECTORP(o)) {
                    if (SCHEME_VEC_SIZE(o) != cols) {
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        3, argc, argv);
                    }
                    Scheme_Object** els = SCHEME_VEC_ELS(o);
                    for (Size j=0; j<cols; j++) {
                        Scheme_Object* x = els[j];
                        if (SCHEME_REALP(x))
                        temp3[i][j] = scheme_real_to_double(x);
                        else
                        scheme_wrong_type(FUNC_NAME, "Matrix",
                        3, argc, argv);
                    }
                } else {
                    scheme_wrong_type(FUNC_NAME, "Matrix",
                    3, argc, argv);
                }
            }
        } else {
            arg3 = (Matrix *) SWIG_MustGetPtr(argv[2],SWIGTYPE_p_Matrix,3,0);
        }
    }
    {
        try {
            result = (SafeBicubicSpline *)new SafeBicubicSpline((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_SafeBicubicSpline, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_BicubicSpline_call__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "BicubicSpline-call"
    SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
    Real arg2 ;
    Real arg3 ;
    bool arg4 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeBicubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeBicubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_REALP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"real", 3 - 1, argc, argv);
        arg3 = scheme_real_to_double(argv[2]);
    }
    {
        if (!SCHEME_BOOLP(argv[3]))
        scheme_wrong_type(FUNC_NAME,"boolean", 4 - 1, argc, argv);
        arg4 = SCHEME_TRUEP(argv[3]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_BicubicSpline_call__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "BicubicSpline-call"
    SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
    Real arg2 ;
    Real arg3 ;
    Real result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeBicubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeBicubicSpline, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_REALP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"real", 3 - 1, argc, argv);
        arg3 = scheme_real_to_double(argv[2]);
    }
    {
        try {
            result = (Real)(arg1)->operator ()(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_BicubicSpline_call(int argc, Scheme_Object **argv) {
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeBicubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_REALP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_BicubicSpline_call__SWIG_1(argc,argv);
                }
            }
        }
    }
    if (argc == 4) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_SafeBicubicSpline, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_REALP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = (SCHEME_BOOLP(argv[3])) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_BicubicSpline_call__SWIG_0(argc,argv);
                    }
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'BicubicSpline_call'");
}


static Scheme_Object *_wrap_delete_BicubicSpline (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "delete-BicubicSpline"
    SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (SafeBicubicSpline *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_SafeBicubicSpline, 1, 0);
    }
    {
        try {
            delete arg1;
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    values[0] = scheme_void;
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_swig_convert_struct__SafeBicubicSpline(SafeBicubicSpline *ptr)
 {
    Scheme_Object *obj;
    Scheme_Object *fields[_swig_struct__SafeBicubicSpline_field_names_cnt];
    int i = 0;

    obj = scheme_make_struct_instance(_swig_struct_type__SafeBicubicSpline, i, fields);
    return obj;
}

static Scheme_Object *_wrap_YieldTermStructure___deref__ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure---deref--"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    YieldTermStructure *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        try {
            result = (YieldTermStructure *)(arg1)->operator ->();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_YieldTermStructure, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_nullq___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-null?"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    bool result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        try {
            result = (bool)boost_shared_ptr_Sl_YieldTermStructure_Sg__isNull(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = swig_make_boolean(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_gObservable___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure->Observable"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    boost::shared_ptr<Observable > *result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        try {
            result = (boost::shared_ptr<Observable > *)boost_shared_ptr_Sl_YieldTermStructure_Sg__asObservable(arg1);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = SWIG_NewPointerObj (result, SWIGTYPE_p_boost__shared_ptrTObservable_t, 0);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_dayscounter___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-day-counter"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    SwigValueWrapper<DayCounter > result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        try {
            result = (*arg1)->dayCounter();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        DayCounter * resultptr;
        resultptr = new DayCounter((DayCounter &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_DayCounter, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_calendar (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-calendar"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    SwigValueWrapper<Calendar > result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        try {
            result = (*arg1)->calendar();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Calendar * resultptr;
        resultptr = new Calendar((Calendar &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Calendar, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_referencesdate___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-reference-date"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        try {
            result = (*arg1)->referenceDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_maxsdate___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-max-date"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        try {
            result = (*arg1)->maxDate();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        Date * resultptr;
        resultptr = new Date((Date &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_Date, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_maxstime___ (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-max-time"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        try {
            result = (Time)(*arg1)->maxTime();
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_discount__SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-discount"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    bool arg3 ;
    DiscountFactor result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_BOOLP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"boolean", 3 - 1, argc, argv);
        arg3 = SCHEME_TRUEP(argv[2]);
    }
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_discount__SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-discount"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DiscountFactor result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        try {
            result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_discount__SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-discount"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    bool arg3 ;
    DiscountFactor result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_BOOLP(argv[2]))
        scheme_wrong_type(FUNC_NAME,"boolean", 3 - 1, argc, argv);
        arg3 = SCHEME_TRUEP(argv[2]);
    }
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_discount__SWIG_3 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-discount"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    DiscountFactor result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        try {
            result = (DiscountFactor)(*arg1)->discount(arg2);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        values[0] = scheme_make_double(result);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_YieldTermStructure_discount(int argc, Scheme_Object **argv) {
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                return _wrap_YieldTermStructure_discount__SWIG_1(argc,argv);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                return _wrap_YieldTermStructure_discount__SWIG_3(argc,argv);
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *ptr;
                if (SWIG_ConvertPtr(argv[1], (void **) &ptr, SWIGTYPE_p_Date, 0)) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                {
                    _v = (SCHEME_BOOLP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_YieldTermStructure_discount__SWIG_0(argc,argv);
                }
            }
        }
    }
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = (SCHEME_BOOLP(argv[2])) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_YieldTermStructure_discount__SWIG_2(argc,argv);
                }
            }
        }
    }
    
    scheme_signal_error("No matching function for overloaded 'YieldTermStructure_discount'");
}


static Scheme_Object *_wrap_YieldTermStructure_zerosrate_____SWIG_0 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-zero-rate"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    bool arg6 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (DayCounter *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_DayCounter, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[3])) 
        scheme_wrong_type(FUNC_NAME, "integer", 4 - 1, argc, argv);
        arg4 = (Compounding) SCHEME_INT_VAL(argv[3]);
    }
    {
        if (!SCHEME_INTP(argv[4])) 
        scheme_wrong_type(FUNC_NAME, "integer", 5 - 1, argc, argv);
        arg5 = (Frequency) SCHEME_INT_VAL(argv[4]);
    }
    {
        if (!SCHEME_BOOLP(argv[5]))
        scheme_wrong_type(FUNC_NAME,"boolean", 6 - 1, argc, argv);
        arg6 = SCHEME_TRUEP(argv[5]);
    }
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5,arg6);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_zerosrate_____SWIG_1 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-zero-rate"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    Frequency arg5 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (DayCounter *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_DayCounter, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[3])) 
        scheme_wrong_type(FUNC_NAME, "integer", 4 - 1, argc, argv);
        arg4 = (Compounding) SCHEME_INT_VAL(argv[3]);
    }
    {
        if (!SCHEME_INTP(argv[4])) 
        scheme_wrong_type(FUNC_NAME, "integer", 5 - 1, argc, argv);
        arg5 = (Frequency) SCHEME_INT_VAL(argv[4]);
    }
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_zerosrate_____SWIG_2 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-zero-rate"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Date *arg2 = 0 ;
    DayCounter *arg3 = 0 ;
    Compounding arg4 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        arg2 = (Date *) SWIG_MustGetPtr(argv[1], SWIGTYPE_p_Date, 2, 0);
        if (arg2 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        arg3 = (DayCounter *) SWIG_MustGetPtr(argv[2], SWIGTYPE_p_DayCounter, 3, 0);
        if (arg3 == NULL) scheme_signal_error("swig-type-error (null reference)");
    }
    {
        if (!SCHEME_INTP(argv[3])) 
        scheme_wrong_type(FUNC_NAME, "integer", 4 - 1, argc, argv);
        arg4 = (Compounding) SCHEME_INT_VAL(argv[3]);
    }
    {
        try {
            result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_zerosrate_____SWIG_3 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-zero-rate"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 ;
    bool arg5 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_INTP(argv[2])) 
        scheme_wrong_type(FUNC_NAME, "integer", 3 - 1, argc, argv);
        arg3 = (Compounding) SCHEME_INT_VAL(argv[2]);
    }
    {
        if (!SCHEME_INTP(argv[3])) 
        scheme_wrong_type(FUNC_NAME, "integer", 4 - 1, argc, argv);
        arg4 = (Frequency) SCHEME_INT_VAL(argv[3]);
    }
    {
        if (!SCHEME_BOOLP(argv[4]))
        scheme_wrong_type(FUNC_NAME,"boolean", 5 - 1, argc, argv);
        arg5 = SCHEME_TRUEP(argv[4]);
    }
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3,arg4,arg5);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_zerosrate_____SWIG_4 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-zero-rate"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    Frequency arg4 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_INTP(argv[2])) 
        scheme_wrong_type(FUNC_NAME, "integer", 3 - 1, argc, argv);
        arg3 = (Compounding) SCHEME_INT_VAL(argv[2]);
    }
    {
        if (!SCHEME_INTP(argv[3])) 
        scheme_wrong_type(FUNC_NAME, "integer", 4 - 1, argc, argv);
        arg4 = (Frequency) SCHEME_INT_VAL(argv[3]);
    }
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3,arg4);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *_wrap_YieldTermStructure_zerosrate_____SWIG_5 (int argc, Scheme_Object **argv)
{
#define FUNC_NAME "YieldTermStructure-zero-rate"
    boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
    Time arg2 ;
    Compounding arg3 ;
    InterestRate result;
    int lenv = 1;
    Scheme_Object *values[MAXVALUES];
    
    {
        arg1 = (boost::shared_ptr<YieldTermStructure > *) SWIG_MustGetPtr(argv[0], SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 1, 0);
    }
    {
        if (!SCHEME_REALP(argv[1]))
        scheme_wrong_type(FUNC_NAME,"real", 2 - 1, argc, argv);
        arg2 = scheme_real_to_double(argv[1]);
    }
    {
        if (!SCHEME_INTP(argv[2])) 
        scheme_wrong_type(FUNC_NAME, "integer", 3 - 1, argc, argv);
        arg3 = (Compounding) SCHEME_INT_VAL(argv[2]);
    }
    {
        try {
            result = (*arg1)->zeroRate(arg2,arg3);
            
        } catch (std::out_of_range& e) {
            SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
        } catch (std::exception& e) {
            SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
        } catch (...) {
            SWIG_exception(SWIG_UnknownError,"unknown error");
        }
    }
    {
        InterestRate * resultptr;
        resultptr = new InterestRate((InterestRate &) result);
        values[0] =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_InterestRate, 1);
    }
    return SWIG_MzScheme_PackageValues(lenv, values);
#undef FUNC_NAME
}


static Scheme_Object *
_wrap_YieldTermStructure_zerosrate___(int argc, Scheme_Object **argv) {
    if (argc == 3) {
        int _v;
        {
            void *ptr;
            if (SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t, 0)) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                _v = (SCHEME_REALP(argv[1])) ? 1 :