/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.31
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace QuantLib {

using System;
using System.Runtime.InteropServices;

class NQuantLibcPINVOKE {

  protected class SWIGExceptionHelper {

    public delegate void ExceptionDelegate(string message);
    public delegate void ExceptionArgumentDelegate(string message, string paramName);

    static ExceptionDelegate applicationDelegate = new ExceptionDelegate(SetPendingApplicationException);
    static ExceptionDelegate arithmeticDelegate = new ExceptionDelegate(SetPendingArithmeticException);
    static ExceptionDelegate divideByZeroDelegate = new ExceptionDelegate(SetPendingDivideByZeroException);
    static ExceptionDelegate indexOutOfRangeDelegate = new ExceptionDelegate(SetPendingIndexOutOfRangeException);
    static ExceptionDelegate invalidCastDelegate = new ExceptionDelegate(SetPendingInvalidCastException);
    static ExceptionDelegate invalidOperationDelegate = new ExceptionDelegate(SetPendingInvalidOperationException);
    static ExceptionDelegate ioDelegate = new ExceptionDelegate(SetPendingIOException);
    static ExceptionDelegate nullReferenceDelegate = new ExceptionDelegate(SetPendingNullReferenceException);
    static ExceptionDelegate outOfMemoryDelegate = new ExceptionDelegate(SetPendingOutOfMemoryException);
    static ExceptionDelegate overflowDelegate = new ExceptionDelegate(SetPendingOverflowException);
    static ExceptionDelegate systemDelegate = new ExceptionDelegate(SetPendingSystemException);

    static ExceptionArgumentDelegate argumentDelegate = new ExceptionArgumentDelegate(SetPendingArgumentException);
    static ExceptionArgumentDelegate argumentNullDelegate = new ExceptionArgumentDelegate(SetPendingArgumentNullException);
    static ExceptionArgumentDelegate argumentOutOfRangeDelegate = new ExceptionArgumentDelegate(SetPendingArgumentOutOfRangeException);

    [DllImport("NQuantLibc", EntryPoint="SWIGRegisterExceptionCallbacks_NQuantLibc")]
    public static extern void SWIGRegisterExceptionCallbacks_NQuantLibc(
                                ExceptionDelegate applicationDelegate,
                                ExceptionDelegate arithmeticDelegate,
                                ExceptionDelegate divideByZeroDelegate, 
                                ExceptionDelegate indexOutOfRangeDelegate, 
                                ExceptionDelegate invalidCastDelegate,
                                ExceptionDelegate invalidOperationDelegate,
                                ExceptionDelegate ioDelegate,
                                ExceptionDelegate nullReferenceDelegate,
                                ExceptionDelegate outOfMemoryDelegate, 
                                ExceptionDelegate overflowDelegate, 
                                ExceptionDelegate systemExceptionDelegate);

    [DllImport("NQuantLibc", EntryPoint="SWIGRegisterExceptionArgumentCallbacks_NQuantLibc")]
    public static extern void SWIGRegisterExceptionCallbacksArgument_NQuantLibc(
                                ExceptionArgumentDelegate argumentDelegate,
                                ExceptionArgumentDelegate argumentNullDelegate,
                                ExceptionArgumentDelegate argumentOutOfRangeDelegate);

    static void SetPendingApplicationException(string message) {
      SWIGPendingException.Set(new System.ApplicationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArithmeticException(string message) {
      SWIGPendingException.Set(new System.ArithmeticException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingDivideByZeroException(string message) {
      SWIGPendingException.Set(new System.DivideByZeroException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIndexOutOfRangeException(string message) {
      SWIGPendingException.Set(new System.IndexOutOfRangeException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidCastException(string message) {
      SWIGPendingException.Set(new System.InvalidCastException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidOperationException(string message) {
      SWIGPendingException.Set(new System.InvalidOperationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIOException(string message) {
      SWIGPendingException.Set(new System.IO.IOException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingNullReferenceException(string message) {
      SWIGPendingException.Set(new System.NullReferenceException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOutOfMemoryException(string message) {
      SWIGPendingException.Set(new System.OutOfMemoryException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOverflowException(string message) {
      SWIGPendingException.Set(new System.OverflowException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingSystemException(string message) {
      SWIGPendingException.Set(new System.SystemException(message, SWIGPendingException.Retrieve()));
    }

    static void SetPendingArgumentException(string message, string paramName) {
      SWIGPendingException.Set(new System.ArgumentException(message, paramName, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArgumentNullException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentNullException(paramName, message));
    }
    static void SetPendingArgumentOutOfRangeException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentOutOfRangeException(paramName, message));
    }

    static SWIGExceptionHelper() {
      SWIGRegisterExceptionCallbacks_NQuantLibc(
                                applicationDelegate,
                                arithmeticDelegate,
                                divideByZeroDelegate,
                                indexOutOfRangeDelegate,
                                invalidCastDelegate,
                                invalidOperationDelegate,
                                ioDelegate,
                                nullReferenceDelegate,
                                outOfMemoryDelegate,
                                overflowDelegate,
                                systemDelegate);

      SWIGRegisterExceptionCallbacksArgument_NQuantLibc(
                                argumentDelegate,
                                argumentNullDelegate,
                                argumentOutOfRangeDelegate);
    }
  }

  protected static SWIGExceptionHelper swigExceptionHelper = new SWIGExceptionHelper();

  public class SWIGPendingException {
    [ThreadStatic]
    private static Exception pendingException = null;
    private static int numExceptionsPending = 0;

    public static bool Pending {
      get {
        bool pending = false;
        if (numExceptionsPending > 0)
          if (pendingException != null)
            pending = true;
        return pending;
      } 
    }

    public static void Set(Exception e) {
      if (pendingException != null)
        throw new ApplicationException("FATAL: An earlier pending exception from unmanaged code was missed and thus not thrown (" + pendingException.ToString() + ")", e);
      pendingException = e;
      lock(typeof(NQuantLibcPINVOKE)) {
        numExceptionsPending++;
      }
    }

    public static Exception Retrieve() {
      Exception e = null;
      if (numExceptionsPending > 0) {
        if (pendingException != null) {
          e = pendingException;
          pendingException = null;
          lock(typeof(NQuantLibcPINVOKE)) {
            numExceptionsPending--;
          }
        }
      }
      return e;
    }
  }


  protected class SWIGStringHelper {

    public delegate string SWIGStringDelegate(string message);
    static SWIGStringDelegate stringDelegate = new SWIGStringDelegate(CreateString);

    [DllImport("NQuantLibc", EntryPoint="SWIGRegisterStringCallback_NQuantLibc")]
    public static extern void SWIGRegisterStringCallback_NQuantLibc(SWIGStringDelegate stringDelegate);

    static string CreateString(string cString) {
      return cString;
    }

    static SWIGStringHelper() {
      SWIGRegisterStringCallback_NQuantLibc(stringDelegate);
    }
  }

  static protected SWIGStringHelper swigStringHelper = new SWIGStringHelper();


  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Period__SWIG_0")]
  public static extern IntPtr new_Period__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Period__SWIG_1")]
  public static extern IntPtr new_Period__SWIG_1(int jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Period__SWIG_2")]
  public static extern IntPtr new_Period__SWIG_2(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Period_length")]
  public static extern int Period_length(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Period_units")]
  public static extern int Period_units(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Period__SWIG_3")]
  public static extern IntPtr new_Period__SWIG_3(string jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Period___str__")]
  public static extern string Period___str__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Period___repr__")]
  public static extern string Period___repr__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Period")]
  public static extern void delete_Period(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_Clear")]
  public static extern void PeriodVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_Add")]
  public static extern void PeriodVector_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_size")]
  public static extern uint PeriodVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_capacity")]
  public static extern uint PeriodVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_reserve")]
  public static extern void PeriodVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PeriodVector__SWIG_0")]
  public static extern IntPtr new_PeriodVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PeriodVector__SWIG_1")]
  public static extern IntPtr new_PeriodVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_getitemcopy")]
  public static extern IntPtr PeriodVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_getitem")]
  public static extern IntPtr PeriodVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_setitem")]
  public static extern void PeriodVector_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_AddRange")]
  public static extern void PeriodVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_GetRange")]
  public static extern IntPtr PeriodVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_Insert")]
  public static extern void PeriodVector_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_InsertRange")]
  public static extern void PeriodVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_RemoveAt")]
  public static extern void PeriodVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_RemoveRange")]
  public static extern void PeriodVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_Repeat")]
  public static extern IntPtr PeriodVector_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_Reverse__SWIG_0")]
  public static extern void PeriodVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_Reverse__SWIG_1")]
  public static extern void PeriodVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodVector_SetRange")]
  public static extern void PeriodVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_PeriodVector")]
  public static extern void delete_PeriodVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Date__SWIG_0")]
  public static extern IntPtr new_Date__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Date__SWIG_1")]
  public static extern IntPtr new_Date__SWIG_1(int jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Date__SWIG_2")]
  public static extern IntPtr new_Date__SWIG_2(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_weekday")]
  public static extern int Date_weekday(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_dayOfMonth")]
  public static extern int Date_dayOfMonth(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_dayOfYear")]
  public static extern int Date_dayOfYear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_month")]
  public static extern int Date_month(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_year")]
  public static extern int Date_year(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_serialNumber")]
  public static extern int Date_serialNumber(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_isLeap")]
  public static extern bool Date_isLeap(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_minDate")]
  public static extern IntPtr Date_minDate();

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_maxDate")]
  public static extern IntPtr Date_maxDate();

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_todaysDate")]
  public static extern IntPtr Date_todaysDate();

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_endOfMonth")]
  public static extern IntPtr Date_endOfMonth(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_isEndOfMonth")]
  public static extern bool Date_isEndOfMonth(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_nextWeekday")]
  public static extern IntPtr Date_nextWeekday(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_nthWeekday")]
  public static extern IntPtr Date_nthWeekday(uint jarg1, int jarg2, int jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Date__SWIG_3")]
  public static extern IntPtr new_Date__SWIG_3(string jarg1, string jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_weekdayNumber")]
  public static extern int Date_weekdayNumber(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date___str__")]
  public static extern string Date___str__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date___repr__")]
  public static extern string Date___repr__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Date_ISO")]
  public static extern string Date_ISO(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Date")]
  public static extern void delete_Date(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateParser_parse")]
  public static extern IntPtr DateParser_parse(string jarg1, string jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateParser_parseISO")]
  public static extern IntPtr DateParser_parseISO(string jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DateParser")]
  public static extern IntPtr new_DateParser();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DateParser")]
  public static extern void delete_DateParser(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PeriodParser_parse")]
  public static extern IntPtr PeriodParser_parse(string jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PeriodParser")]
  public static extern IntPtr new_PeriodParser();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_PeriodParser")]
  public static extern void delete_PeriodParser(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_Clear")]
  public static extern void DateVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_Add")]
  public static extern void DateVector_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_size")]
  public static extern uint DateVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_capacity")]
  public static extern uint DateVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_reserve")]
  public static extern void DateVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DateVector__SWIG_0")]
  public static extern IntPtr new_DateVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DateVector__SWIG_1")]
  public static extern IntPtr new_DateVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_getitemcopy")]
  public static extern IntPtr DateVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_getitem")]
  public static extern IntPtr DateVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_setitem")]
  public static extern void DateVector_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_AddRange")]
  public static extern void DateVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_GetRange")]
  public static extern IntPtr DateVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_Insert")]
  public static extern void DateVector_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_InsertRange")]
  public static extern void DateVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_RemoveAt")]
  public static extern void DateVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_RemoveRange")]
  public static extern void DateVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_Repeat")]
  public static extern IntPtr DateVector_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_Reverse__SWIG_0")]
  public static extern void DateVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_Reverse__SWIG_1")]
  public static extern void DateVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DateVector_SetRange")]
  public static extern void DateVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DateVector")]
  public static extern void delete_DateVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_isIMMdate__SWIG_0")]
  public static extern bool IMM_isIMMdate__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_isIMMdate__SWIG_1")]
  public static extern bool IMM_isIMMdate__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_isIMMcode__SWIG_0")]
  public static extern bool IMM_isIMMcode__SWIG_0(string jarg1, bool jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_isIMMcode__SWIG_1")]
  public static extern bool IMM_isIMMcode__SWIG_1(string jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_code")]
  public static extern string IMM_code(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_date__SWIG_0")]
  public static extern IntPtr IMM_date__SWIG_0(string jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_date__SWIG_1")]
  public static extern IntPtr IMM_date__SWIG_1(string jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_nextDate__SWIG_0")]
  public static extern IntPtr IMM_nextDate__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_nextDate__SWIG_1")]
  public static extern IntPtr IMM_nextDate__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_nextDate__SWIG_2")]
  public static extern IntPtr IMM_nextDate__SWIG_2();

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_nextDate__SWIG_3")]
  public static extern IntPtr IMM_nextDate__SWIG_3(string jarg1, bool jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_nextDate__SWIG_4")]
  public static extern IntPtr IMM_nextDate__SWIG_4(string jarg1, bool jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_nextDate__SWIG_5")]
  public static extern IntPtr IMM_nextDate__SWIG_5(string jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_nextCode__SWIG_0")]
  public static extern string IMM_nextCode__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_nextCode__SWIG_1")]
  public static extern string IMM_nextCode__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_nextCode__SWIG_2")]
  public static extern string IMM_nextCode__SWIG_2();

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_nextCode__SWIG_3")]
  public static extern string IMM_nextCode__SWIG_3(string jarg1, bool jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_nextCode__SWIG_4")]
  public static extern string IMM_nextCode__SWIG_4(string jarg1, bool jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IMM_nextCode__SWIG_5")]
  public static extern string IMM_nextCode__SWIG_5(string jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IMM")]
  public static extern IntPtr new_IMM();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_IMM")]
  public static extern void delete_IMM(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp__Exercise_type")]
  public static extern int _Exercise_type(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp__Exercise_dates")]
  public static extern IntPtr _Exercise_dates(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete__Exercise")]
  public static extern void delete__Exercise(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Exercise___deref__")]
  public static extern IntPtr Exercise___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Exercise_isNull")]
  public static extern bool Exercise_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Exercise_American_get")]
  public static extern int Exercise_American_get();

  [DllImport("NQuantLibc", EntryPoint="CSharp_Exercise_Bermudan_get")]
  public static extern int Exercise_Bermudan_get();

  [DllImport("NQuantLibc", EntryPoint="CSharp_Exercise_European_get")]
  public static extern int Exercise_European_get();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Exercise")]
  public static extern IntPtr new_Exercise();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Exercise")]
  public static extern void delete_Exercise(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Exercise_type")]
  public static extern int Exercise_type(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Exercise_dates")]
  public static extern IntPtr Exercise_dates(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuropeanExercise")]
  public static extern IntPtr new_EuropeanExercise(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuropeanExercise")]
  public static extern void delete_EuropeanExercise(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_AmericanExercise__SWIG_0")]
  public static extern IntPtr new_AmericanExercise__SWIG_0(HandleRef jarg1, HandleRef jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_AmericanExercise__SWIG_1")]
  public static extern IntPtr new_AmericanExercise__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_AmericanExercise")]
  public static extern void delete_AmericanExercise(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BermudanExercise__SWIG_0")]
  public static extern IntPtr new_BermudanExercise__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BermudanExercise__SWIG_1")]
  public static extern IntPtr new_BermudanExercise__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BermudanExercise")]
  public static extern void delete_BermudanExercise(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Observable___deref__")]
  public static extern IntPtr Observable___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Observable_isNull")]
  public static extern bool Observable_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Observable")]
  public static extern IntPtr new_Observable();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Observable")]
  public static extern void delete_Observable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QlArray__SWIG_0")]
  public static extern IntPtr new_QlArray__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QlArray__SWIG_1")]
  public static extern IntPtr new_QlArray__SWIG_1(uint jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QlArray__SWIG_2")]
  public static extern IntPtr new_QlArray__SWIG_2(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QlArray__SWIG_3")]
  public static extern IntPtr new_QlArray__SWIG_3(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QlArray_size")]
  public static extern uint QlArray_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QlArray___str__")]
  public static extern string QlArray___str__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_QlArray")]
  public static extern void delete_QlArray(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LexicographicalView_xSize")]
  public static extern uint LexicographicalView_xSize(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LexicographicalView_ySize")]
  public static extern uint LexicographicalView_ySize(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LexicographicalView")]
  public static extern IntPtr new_LexicographicalView(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LexicographicalView___str__")]
  public static extern string LexicographicalView___str__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_LexicographicalView")]
  public static extern void delete_LexicographicalView(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Matrix__SWIG_0")]
  public static extern IntPtr new_Matrix__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Matrix__SWIG_1")]
  public static extern IntPtr new_Matrix__SWIG_1(uint jarg1, uint jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Matrix__SWIG_2")]
  public static extern IntPtr new_Matrix__SWIG_2(uint jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Matrix__SWIG_3")]
  public static extern IntPtr new_Matrix__SWIG_3(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Matrix_rows")]
  public static extern uint Matrix_rows(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Matrix_columns")]
  public static extern uint Matrix_columns(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Matrix___str__")]
  public static extern string Matrix___str__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Matrix")]
  public static extern void delete_Matrix(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SalvagingAlgorithm")]
  public static extern IntPtr new_SalvagingAlgorithm();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SalvagingAlgorithm")]
  public static extern void delete_SalvagingAlgorithm(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_transpose")]
  public static extern IntPtr transpose(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_outerProduct")]
  public static extern IntPtr outerProduct(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_pseudoSqrt")]
  public static extern IntPtr pseudoSqrt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SVD")]
  public static extern IntPtr new_SVD(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SVD_U")]
  public static extern IntPtr SVD_U(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SVD_V")]
  public static extern IntPtr SVD_V(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SVD_S")]
  public static extern IntPtr SVD_S(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SVD_singularValues")]
  public static extern IntPtr SVD_singularValues(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SVD")]
  public static extern void delete_SVD(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DisposableArray")]
  public static extern IntPtr new_DisposableArray(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DisposableArray")]
  public static extern void delete_DisposableArray(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Quote___deref__")]
  public static extern IntPtr Quote___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Quote_isNull")]
  public static extern bool Quote_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Quote_asObservable")]
  public static extern IntPtr Quote_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Quote")]
  public static extern IntPtr new_Quote();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Quote")]
  public static extern void delete_Quote(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Quote_value")]
  public static extern double Quote_value(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QuoteHandle__SWIG_0")]
  public static extern IntPtr new_QuoteHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QuoteHandle__SWIG_1")]
  public static extern IntPtr new_QuoteHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandle___deref__")]
  public static extern IntPtr QuoteHandle___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandle_empty")]
  public static extern bool QuoteHandle_empty(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandle_asObservable")]
  public static extern IntPtr QuoteHandle_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_QuoteHandle")]
  public static extern void delete_QuoteHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandle_value")]
  public static extern double QuoteHandle_value(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableQuoteHandle__SWIG_0")]
  public static extern IntPtr new_RelinkableQuoteHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableQuoteHandle__SWIG_1")]
  public static extern IntPtr new_RelinkableQuoteHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandle_linkTo")]
  public static extern void RelinkableQuoteHandle_linkTo(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_RelinkableQuoteHandle")]
  public static extern void delete_RelinkableQuoteHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SimpleQuote")]
  public static extern IntPtr new_SimpleQuote(double jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SimpleQuote_setValue")]
  public static extern void SimpleQuote_setValue(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SimpleQuote")]
  public static extern void delete_SimpleQuote(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_Clear")]
  public static extern void QuoteVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_Add")]
  public static extern void QuoteVector_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_size")]
  public static extern uint QuoteVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_capacity")]
  public static extern uint QuoteVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_reserve")]
  public static extern void QuoteVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QuoteVector__SWIG_0")]
  public static extern IntPtr new_QuoteVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QuoteVector__SWIG_1")]
  public static extern IntPtr new_QuoteVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_getitemcopy")]
  public static extern IntPtr QuoteVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_getitem")]
  public static extern IntPtr QuoteVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_setitem")]
  public static extern void QuoteVector_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_AddRange")]
  public static extern void QuoteVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_GetRange")]
  public static extern IntPtr QuoteVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_Insert")]
  public static extern void QuoteVector_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_InsertRange")]
  public static extern void QuoteVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_RemoveAt")]
  public static extern void QuoteVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_RemoveRange")]
  public static extern void QuoteVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_Repeat")]
  public static extern IntPtr QuoteVector_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_Reverse__SWIG_0")]
  public static extern void QuoteVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_Reverse__SWIG_1")]
  public static extern void QuoteVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_SetRange")]
  public static extern void QuoteVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_Contains")]
  public static extern bool QuoteVector_Contains(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_IndexOf")]
  public static extern int QuoteVector_IndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_LastIndexOf")]
  public static extern int QuoteVector_LastIndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteVector_Remove")]
  public static extern void QuoteVector_Remove(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_QuoteVector")]
  public static extern void delete_QuoteVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_Clear")]
  public static extern void QuoteHandleVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_Add")]
  public static extern void QuoteHandleVector_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_size")]
  public static extern uint QuoteHandleVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_capacity")]
  public static extern uint QuoteHandleVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_reserve")]
  public static extern void QuoteHandleVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QuoteHandleVector__SWIG_0")]
  public static extern IntPtr new_QuoteHandleVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QuoteHandleVector__SWIG_1")]
  public static extern IntPtr new_QuoteHandleVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_getitemcopy")]
  public static extern IntPtr QuoteHandleVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_getitem")]
  public static extern IntPtr QuoteHandleVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_setitem")]
  public static extern void QuoteHandleVector_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_AddRange")]
  public static extern void QuoteHandleVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_GetRange")]
  public static extern IntPtr QuoteHandleVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_Insert")]
  public static extern void QuoteHandleVector_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_InsertRange")]
  public static extern void QuoteHandleVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_RemoveAt")]
  public static extern void QuoteHandleVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_RemoveRange")]
  public static extern void QuoteHandleVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_Repeat")]
  public static extern IntPtr QuoteHandleVector_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_Reverse__SWIG_0")]
  public static extern void QuoteHandleVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_Reverse__SWIG_1")]
  public static extern void QuoteHandleVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_SetRange")]
  public static extern void QuoteHandleVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_Contains")]
  public static extern bool QuoteHandleVector_Contains(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_IndexOf")]
  public static extern int QuoteHandleVector_IndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_LastIndexOf")]
  public static extern int QuoteHandleVector_LastIndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuoteHandleVector_Remove")]
  public static extern void QuoteHandleVector_Remove(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_QuoteHandleVector")]
  public static extern void delete_QuoteHandleVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_Clear")]
  public static extern void RelinkableQuoteHandleVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_Add")]
  public static extern void RelinkableQuoteHandleVector_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_size")]
  public static extern uint RelinkableQuoteHandleVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_capacity")]
  public static extern uint RelinkableQuoteHandleVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_reserve")]
  public static extern void RelinkableQuoteHandleVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableQuoteHandleVector__SWIG_0")]
  public static extern IntPtr new_RelinkableQuoteHandleVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableQuoteHandleVector__SWIG_1")]
  public static extern IntPtr new_RelinkableQuoteHandleVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_getitemcopy")]
  public static extern IntPtr RelinkableQuoteHandleVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_getitem")]
  public static extern IntPtr RelinkableQuoteHandleVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_setitem")]
  public static extern void RelinkableQuoteHandleVector_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_AddRange")]
  public static extern void RelinkableQuoteHandleVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_GetRange")]
  public static extern IntPtr RelinkableQuoteHandleVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_Insert")]
  public static extern void RelinkableQuoteHandleVector_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_InsertRange")]
  public static extern void RelinkableQuoteHandleVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_RemoveAt")]
  public static extern void RelinkableQuoteHandleVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_RemoveRange")]
  public static extern void RelinkableQuoteHandleVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_Repeat")]
  public static extern IntPtr RelinkableQuoteHandleVector_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_Reverse__SWIG_0")]
  public static extern void RelinkableQuoteHandleVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_Reverse__SWIG_1")]
  public static extern void RelinkableQuoteHandleVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_SetRange")]
  public static extern void RelinkableQuoteHandleVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_Contains")]
  public static extern bool RelinkableQuoteHandleVector_Contains(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_IndexOf")]
  public static extern int RelinkableQuoteHandleVector_IndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_LastIndexOf")]
  public static extern int RelinkableQuoteHandleVector_LastIndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleVector_Remove")]
  public static extern void RelinkableQuoteHandleVector_Remove(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_RelinkableQuoteHandleVector")]
  public static extern void delete_RelinkableQuoteHandleVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_nullInt")]
  public static extern int nullInt();

  [DllImport("NQuantLibc", EntryPoint="CSharp_nullDouble")]
  public static extern double nullDouble();

  [DllImport("NQuantLibc", EntryPoint="CSharp_DayCounter_dayCount")]
  public static extern int DayCounter_dayCount(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DayCounter_yearFraction__SWIG_0")]
  public static extern double DayCounter_yearFraction__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DayCounter_yearFraction__SWIG_1")]
  public static extern double DayCounter_yearFraction__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DayCounter_yearFraction__SWIG_2")]
  public static extern double DayCounter_yearFraction__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DayCounter___str__")]
  public static extern string DayCounter___str__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DayCounter")]
  public static extern void delete_DayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Actual360")]
  public static extern IntPtr new_Actual360();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Actual360")]
  public static extern void delete_Actual360(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Actual365Fixed")]
  public static extern IntPtr new_Actual365Fixed();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Actual365Fixed")]
  public static extern void delete_Actual365Fixed(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Thirty360__SWIG_0")]
  public static extern IntPtr new_Thirty360__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Thirty360__SWIG_1")]
  public static extern IntPtr new_Thirty360__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Thirty360")]
  public static extern void delete_Thirty360(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ActualActual__SWIG_0")]
  public static extern IntPtr new_ActualActual__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ActualActual__SWIG_1")]
  public static extern IntPtr new_ActualActual__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ActualActual")]
  public static extern void delete_ActualActual(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_OneDayCounter")]
  public static extern IntPtr new_OneDayCounter();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_OneDayCounter")]
  public static extern void delete_OneDayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SimpleDayCounter")]
  public static extern IntPtr new_SimpleDayCounter();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SimpleDayCounter")]
  public static extern void delete_SimpleDayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_InterestRate__SWIG_0")]
  public static extern IntPtr new_InterestRate__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_InterestRate__SWIG_1")]
  public static extern IntPtr new_InterestRate__SWIG_1(double jarg1, HandleRef jarg2, int jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_InterestRate__SWIG_2")]
  public static extern IntPtr new_InterestRate__SWIG_2(double jarg1, HandleRef jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_rate")]
  public static extern double InterestRate_rate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_dayCounter")]
  public static extern IntPtr InterestRate_dayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_compounding")]
  public static extern int InterestRate_compounding(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_frequency")]
  public static extern int InterestRate_frequency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_discountFactor__SWIG_0")]
  public static extern double InterestRate_discountFactor__SWIG_0(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_discountFactor__SWIG_1")]
  public static extern double InterestRate_discountFactor__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_compoundFactor__SWIG_0")]
  public static extern double InterestRate_compoundFactor__SWIG_0(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_compoundFactor__SWIG_1")]
  public static extern double InterestRate_compoundFactor__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_impliedRate__SWIG_0")]
  public static extern IntPtr InterestRate_impliedRate__SWIG_0(double jarg1, double jarg2, HandleRef jarg3, int jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_impliedRate__SWIG_1")]
  public static extern IntPtr InterestRate_impliedRate__SWIG_1(double jarg1, double jarg2, HandleRef jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_impliedRate__SWIG_2")]
  public static extern IntPtr InterestRate_impliedRate__SWIG_2(double jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_impliedRate__SWIG_3")]
  public static extern IntPtr InterestRate_impliedRate__SWIG_3(double jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_equivalentRate__SWIG_0")]
  public static extern IntPtr InterestRate_equivalentRate__SWIG_0(HandleRef jarg1, double jarg2, int jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_equivalentRate__SWIG_1")]
  public static extern IntPtr InterestRate_equivalentRate__SWIG_1(HandleRef jarg1, double jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_equivalentRate__SWIG_2")]
  public static extern IntPtr InterestRate_equivalentRate__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate_equivalentRate__SWIG_3")]
  public static extern IntPtr InterestRate_equivalentRate__SWIG_3(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRate___str__")]
  public static extern string InterestRate___str__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_InterestRate")]
  public static extern void delete_InterestRate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_isBusinessDay")]
  public static extern bool Calendar_isBusinessDay(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_isHoliday")]
  public static extern bool Calendar_isHoliday(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_isEndOfMonth")]
  public static extern bool Calendar_isEndOfMonth(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_addHoliday")]
  public static extern void Calendar_addHoliday(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_removeHoliday")]
  public static extern void Calendar_removeHoliday(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_adjust__SWIG_0")]
  public static extern IntPtr Calendar_adjust__SWIG_0(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_adjust__SWIG_1")]
  public static extern IntPtr Calendar_adjust__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_advance__SWIG_0")]
  public static extern IntPtr Calendar_advance__SWIG_0(HandleRef jarg1, HandleRef jarg2, int jarg3, int jarg4, int jarg5, bool jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_advance__SWIG_1")]
  public static extern IntPtr Calendar_advance__SWIG_1(HandleRef jarg1, HandleRef jarg2, int jarg3, int jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_advance__SWIG_2")]
  public static extern IntPtr Calendar_advance__SWIG_2(HandleRef jarg1, HandleRef jarg2, int jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_advance__SWIG_3")]
  public static extern IntPtr Calendar_advance__SWIG_3(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_advance__SWIG_4")]
  public static extern IntPtr Calendar_advance__SWIG_4(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_advance__SWIG_5")]
  public static extern IntPtr Calendar_advance__SWIG_5(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_businessDaysBetween__SWIG_0")]
  public static extern int Calendar_businessDaysBetween__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, bool jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_businessDaysBetween__SWIG_1")]
  public static extern int Calendar_businessDaysBetween__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar_businessDaysBetween__SWIG_2")]
  public static extern int Calendar_businessDaysBetween__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Calendar___str__")]
  public static extern string Calendar___str__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Calendar")]
  public static extern void delete_Calendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Argentina__SWIG_0")]
  public static extern IntPtr new_Argentina__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Argentina__SWIG_1")]
  public static extern IntPtr new_Argentina__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Argentina")]
  public static extern void delete_Argentina(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Australia")]
  public static extern IntPtr new_Australia();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Australia")]
  public static extern void delete_Australia(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Brazil__SWIG_0")]
  public static extern IntPtr new_Brazil__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Brazil__SWIG_1")]
  public static extern IntPtr new_Brazil__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Brazil")]
  public static extern void delete_Brazil(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Canada")]
  public static extern IntPtr new_Canada();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Canada")]
  public static extern void delete_Canada(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_China")]
  public static extern IntPtr new_China();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_China")]
  public static extern void delete_China(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CzechRepublic__SWIG_0")]
  public static extern IntPtr new_CzechRepublic__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CzechRepublic__SWIG_1")]
  public static extern IntPtr new_CzechRepublic__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CzechRepublic")]
  public static extern void delete_CzechRepublic(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Denmark")]
  public static extern IntPtr new_Denmark();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Denmark")]
  public static extern void delete_Denmark(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Finland")]
  public static extern IntPtr new_Finland();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Finland")]
  public static extern void delete_Finland(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Germany__SWIG_0")]
  public static extern IntPtr new_Germany__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Germany__SWIG_1")]
  public static extern IntPtr new_Germany__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Germany")]
  public static extern void delete_Germany(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_HongKong__SWIG_0")]
  public static extern IntPtr new_HongKong__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_HongKong__SWIG_1")]
  public static extern IntPtr new_HongKong__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_HongKong")]
  public static extern void delete_HongKong(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Hungary")]
  public static extern IntPtr new_Hungary();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Hungary")]
  public static extern void delete_Hungary(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Iceland__SWIG_0")]
  public static extern IntPtr new_Iceland__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Iceland__SWIG_1")]
  public static extern IntPtr new_Iceland__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Iceland")]
  public static extern void delete_Iceland(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_India__SWIG_0")]
  public static extern IntPtr new_India__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_India__SWIG_1")]
  public static extern IntPtr new_India__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_India")]
  public static extern void delete_India(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Indonesia__SWIG_0")]
  public static extern IntPtr new_Indonesia__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Indonesia__SWIG_1")]
  public static extern IntPtr new_Indonesia__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Indonesia")]
  public static extern void delete_Indonesia(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Italy__SWIG_0")]
  public static extern IntPtr new_Italy__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Italy__SWIG_1")]
  public static extern IntPtr new_Italy__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Italy")]
  public static extern void delete_Italy(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Japan")]
  public static extern IntPtr new_Japan();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Japan")]
  public static extern void delete_Japan(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Mexico__SWIG_0")]
  public static extern IntPtr new_Mexico__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Mexico__SWIG_1")]
  public static extern IntPtr new_Mexico__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Mexico")]
  public static extern void delete_Mexico(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NewZealand")]
  public static extern IntPtr new_NewZealand();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_NewZealand")]
  public static extern void delete_NewZealand(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Norway")]
  public static extern IntPtr new_Norway();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Norway")]
  public static extern void delete_Norway(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Poland")]
  public static extern IntPtr new_Poland();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Poland")]
  public static extern void delete_Poland(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SaudiArabia__SWIG_0")]
  public static extern IntPtr new_SaudiArabia__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SaudiArabia__SWIG_1")]
  public static extern IntPtr new_SaudiArabia__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SaudiArabia")]
  public static extern void delete_SaudiArabia(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Singapore__SWIG_0")]
  public static extern IntPtr new_Singapore__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Singapore__SWIG_1")]
  public static extern IntPtr new_Singapore__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Singapore")]
  public static extern void delete_Singapore(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Slovakia__SWIG_0")]
  public static extern IntPtr new_Slovakia__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Slovakia__SWIG_1")]
  public static extern IntPtr new_Slovakia__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Slovakia")]
  public static extern void delete_Slovakia(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SouthAfrica")]
  public static extern IntPtr new_SouthAfrica();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SouthAfrica")]
  public static extern void delete_SouthAfrica(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SouthKorea__SWIG_0")]
  public static extern IntPtr new_SouthKorea__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SouthKorea__SWIG_1")]
  public static extern IntPtr new_SouthKorea__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SouthKorea")]
  public static extern void delete_SouthKorea(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Sweden")]
  public static extern IntPtr new_Sweden();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Sweden")]
  public static extern void delete_Sweden(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Switzerland")]
  public static extern IntPtr new_Switzerland();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Switzerland")]
  public static extern void delete_Switzerland(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Taiwan__SWIG_0")]
  public static extern IntPtr new_Taiwan__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Taiwan__SWIG_1")]
  public static extern IntPtr new_Taiwan__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Taiwan")]
  public static extern void delete_Taiwan(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TARGET")]
  public static extern IntPtr new_TARGET();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_TARGET")]
  public static extern void delete_TARGET(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Turkey")]
  public static extern IntPtr new_Turkey();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Turkey")]
  public static extern void delete_Turkey(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Ukraine__SWIG_0")]
  public static extern IntPtr new_Ukraine__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Ukraine__SWIG_1")]
  public static extern IntPtr new_Ukraine__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Ukraine")]
  public static extern void delete_Ukraine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_UnitedKingdom__SWIG_0")]
  public static extern IntPtr new_UnitedKingdom__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_UnitedKingdom__SWIG_1")]
  public static extern IntPtr new_UnitedKingdom__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_UnitedKingdom")]
  public static extern void delete_UnitedKingdom(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_UnitedStates__SWIG_0")]
  public static extern IntPtr new_UnitedStates__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_UnitedStates__SWIG_1")]
  public static extern IntPtr new_UnitedStates__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_UnitedStates")]
  public static extern void delete_UnitedStates(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NullCalendar")]
  public static extern IntPtr new_NullCalendar();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_NullCalendar")]
  public static extern void delete_NullCalendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_JointCalendar__SWIG_0")]
  public static extern IntPtr new_JointCalendar__SWIG_0(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_JointCalendar__SWIG_1")]
  public static extern IntPtr new_JointCalendar__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_JointCalendar__SWIG_2")]
  public static extern IntPtr new_JointCalendar__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_JointCalendar__SWIG_3")]
  public static extern IntPtr new_JointCalendar__SWIG_3(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_JointCalendar__SWIG_4")]
  public static extern IntPtr new_JointCalendar__SWIG_4(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_JointCalendar__SWIG_5")]
  public static extern IntPtr new_JointCalendar__SWIG_5(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_JointCalendar")]
  public static extern void delete_JointCalendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Rounding")]
  public static extern IntPtr new_Rounding();

  [DllImport("NQuantLibc", EntryPoint="CSharp_Rounding_apply")]
  public static extern double Rounding_apply(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Rounding")]
  public static extern void delete_Rounding(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_UpRounding__SWIG_0")]
  public static extern IntPtr new_UpRounding__SWIG_0(int jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_UpRounding__SWIG_1")]
  public static extern IntPtr new_UpRounding__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_UpRounding")]
  public static extern void delete_UpRounding(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DownRounding__SWIG_0")]
  public static extern IntPtr new_DownRounding__SWIG_0(int jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DownRounding__SWIG_1")]
  public static extern IntPtr new_DownRounding__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DownRounding")]
  public static extern void delete_DownRounding(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ClosestRounding__SWIG_0")]
  public static extern IntPtr new_ClosestRounding__SWIG_0(int jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ClosestRounding__SWIG_1")]
  public static extern IntPtr new_ClosestRounding__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ClosestRounding")]
  public static extern void delete_ClosestRounding(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CeilingTruncation__SWIG_0")]
  public static extern IntPtr new_CeilingTruncation__SWIG_0(int jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CeilingTruncation__SWIG_1")]
  public static extern IntPtr new_CeilingTruncation__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CeilingTruncation")]
  public static extern void delete_CeilingTruncation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FloorTruncation__SWIG_0")]
  public static extern IntPtr new_FloorTruncation__SWIG_0(int jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FloorTruncation__SWIG_1")]
  public static extern IntPtr new_FloorTruncation__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FloorTruncation")]
  public static extern void delete_FloorTruncation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Currency_name")]
  public static extern string Currency_name(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Currency_code")]
  public static extern string Currency_code(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Currency_numericCode")]
  public static extern int Currency_numericCode(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Currency_symbol")]
  public static extern string Currency_symbol(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Currency_fractionSymbol")]
  public static extern string Currency_fractionSymbol(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Currency_fractionsPerUnit")]
  public static extern int Currency_fractionsPerUnit(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Currency_rounding")]
  public static extern IntPtr Currency_rounding(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Currency_format")]
  public static extern string Currency_format(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Currency_empty")]
  public static extern bool Currency_empty(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Currency_triangulationCurrency")]
  public static extern IntPtr Currency_triangulationCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Currency___str__")]
  public static extern string Currency___str__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Currency")]
  public static extern IntPtr new_Currency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Currency")]
  public static extern void delete_Currency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ARSCurrency")]
  public static extern IntPtr new_ARSCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ARSCurrency")]
  public static extern void delete_ARSCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ATSCurrency")]
  public static extern IntPtr new_ATSCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ATSCurrency")]
  public static extern void delete_ATSCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_AUDCurrency")]
  public static extern IntPtr new_AUDCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_AUDCurrency")]
  public static extern void delete_AUDCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BDTCurrency")]
  public static extern IntPtr new_BDTCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BDTCurrency")]
  public static extern void delete_BDTCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BEFCurrency")]
  public static extern IntPtr new_BEFCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BEFCurrency")]
  public static extern void delete_BEFCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BGLCurrency")]
  public static extern IntPtr new_BGLCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BGLCurrency")]
  public static extern void delete_BGLCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BRLCurrency")]
  public static extern IntPtr new_BRLCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BRLCurrency")]
  public static extern void delete_BRLCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BYRCurrency")]
  public static extern IntPtr new_BYRCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BYRCurrency")]
  public static extern void delete_BYRCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CADCurrency")]
  public static extern IntPtr new_CADCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CADCurrency")]
  public static extern void delete_CADCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CHFCurrency")]
  public static extern IntPtr new_CHFCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CHFCurrency")]
  public static extern void delete_CHFCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CLPCurrency")]
  public static extern IntPtr new_CLPCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CLPCurrency")]
  public static extern void delete_CLPCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CNYCurrency")]
  public static extern IntPtr new_CNYCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CNYCurrency")]
  public static extern void delete_CNYCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_COPCurrency")]
  public static extern IntPtr new_COPCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_COPCurrency")]
  public static extern void delete_COPCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CYPCurrency")]
  public static extern IntPtr new_CYPCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CYPCurrency")]
  public static extern void delete_CYPCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CZKCurrency")]
  public static extern IntPtr new_CZKCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CZKCurrency")]
  public static extern void delete_CZKCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DEMCurrency")]
  public static extern IntPtr new_DEMCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DEMCurrency")]
  public static extern void delete_DEMCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DKKCurrency")]
  public static extern IntPtr new_DKKCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DKKCurrency")]
  public static extern void delete_DKKCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EEKCurrency")]
  public static extern IntPtr new_EEKCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EEKCurrency")]
  public static extern void delete_EEKCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ESPCurrency")]
  public static extern IntPtr new_ESPCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ESPCurrency")]
  public static extern void delete_ESPCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURCurrency")]
  public static extern IntPtr new_EURCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURCurrency")]
  public static extern void delete_EURCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FIMCurrency")]
  public static extern IntPtr new_FIMCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FIMCurrency")]
  public static extern void delete_FIMCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FRFCurrency")]
  public static extern IntPtr new_FRFCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FRFCurrency")]
  public static extern void delete_FRFCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GBPCurrency")]
  public static extern IntPtr new_GBPCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GBPCurrency")]
  public static extern void delete_GBPCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GRDCurrency")]
  public static extern IntPtr new_GRDCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GRDCurrency")]
  public static extern void delete_GRDCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_HKDCurrency")]
  public static extern IntPtr new_HKDCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_HKDCurrency")]
  public static extern void delete_HKDCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_HUFCurrency")]
  public static extern IntPtr new_HUFCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_HUFCurrency")]
  public static extern void delete_HUFCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IEPCurrency")]
  public static extern IntPtr new_IEPCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_IEPCurrency")]
  public static extern void delete_IEPCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ILSCurrency")]
  public static extern IntPtr new_ILSCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ILSCurrency")]
  public static extern void delete_ILSCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_INRCurrency")]
  public static extern IntPtr new_INRCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_INRCurrency")]
  public static extern void delete_INRCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IQDCurrency")]
  public static extern IntPtr new_IQDCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_IQDCurrency")]
  public static extern void delete_IQDCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IRRCurrency")]
  public static extern IntPtr new_IRRCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_IRRCurrency")]
  public static extern void delete_IRRCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ISKCurrency")]
  public static extern IntPtr new_ISKCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ISKCurrency")]
  public static extern void delete_ISKCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ITLCurrency")]
  public static extern IntPtr new_ITLCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ITLCurrency")]
  public static extern void delete_ITLCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_JPYCurrency")]
  public static extern IntPtr new_JPYCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_JPYCurrency")]
  public static extern void delete_JPYCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_KRWCurrency")]
  public static extern IntPtr new_KRWCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_KRWCurrency")]
  public static extern void delete_KRWCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_KWDCurrency")]
  public static extern IntPtr new_KWDCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_KWDCurrency")]
  public static extern void delete_KWDCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LTLCurrency")]
  public static extern IntPtr new_LTLCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_LTLCurrency")]
  public static extern void delete_LTLCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LUFCurrency")]
  public static extern IntPtr new_LUFCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_LUFCurrency")]
  public static extern void delete_LUFCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LVLCurrency")]
  public static extern IntPtr new_LVLCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_LVLCurrency")]
  public static extern void delete_LVLCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MTLCurrency")]
  public static extern IntPtr new_MTLCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MTLCurrency")]
  public static extern void delete_MTLCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MXNCurrency")]
  public static extern IntPtr new_MXNCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MXNCurrency")]
  public static extern void delete_MXNCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NLGCurrency")]
  public static extern IntPtr new_NLGCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_NLGCurrency")]
  public static extern void delete_NLGCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NOKCurrency")]
  public static extern IntPtr new_NOKCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_NOKCurrency")]
  public static extern void delete_NOKCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NPRCurrency")]
  public static extern IntPtr new_NPRCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_NPRCurrency")]
  public static extern void delete_NPRCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NZDCurrency")]
  public static extern IntPtr new_NZDCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_NZDCurrency")]
  public static extern void delete_NZDCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PKRCurrency")]
  public static extern IntPtr new_PKRCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_PKRCurrency")]
  public static extern void delete_PKRCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PLNCurrency")]
  public static extern IntPtr new_PLNCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_PLNCurrency")]
  public static extern void delete_PLNCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PTECurrency")]
  public static extern IntPtr new_PTECurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_PTECurrency")]
  public static extern void delete_PTECurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ROLCurrency")]
  public static extern IntPtr new_ROLCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ROLCurrency")]
  public static extern void delete_ROLCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RONCurrency")]
  public static extern IntPtr new_RONCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_RONCurrency")]
  public static extern void delete_RONCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SARCurrency")]
  public static extern IntPtr new_SARCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SARCurrency")]
  public static extern void delete_SARCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SEKCurrency")]
  public static extern IntPtr new_SEKCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SEKCurrency")]
  public static extern void delete_SEKCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SGDCurrency")]
  public static extern IntPtr new_SGDCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SGDCurrency")]
  public static extern void delete_SGDCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SITCurrency")]
  public static extern IntPtr new_SITCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SITCurrency")]
  public static extern void delete_SITCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SKKCurrency")]
  public static extern IntPtr new_SKKCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SKKCurrency")]
  public static extern void delete_SKKCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_THBCurrency")]
  public static extern IntPtr new_THBCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_THBCurrency")]
  public static extern void delete_THBCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TRLCurrency")]
  public static extern IntPtr new_TRLCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_TRLCurrency")]
  public static extern void delete_TRLCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TRYCurrency")]
  public static extern IntPtr new_TRYCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_TRYCurrency")]
  public static extern void delete_TRYCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TTDCurrency")]
  public static extern IntPtr new_TTDCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_TTDCurrency")]
  public static extern void delete_TTDCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TWDCurrency")]
  public static extern IntPtr new_TWDCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_TWDCurrency")]
  public static extern void delete_TWDCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_USDCurrency")]
  public static extern IntPtr new_USDCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_USDCurrency")]
  public static extern void delete_USDCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_VEBCurrency")]
  public static extern IntPtr new_VEBCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_VEBCurrency")]
  public static extern void delete_VEBCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ZARCurrency")]
  public static extern IntPtr new_ZARCurrency();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ZARCurrency")]
  public static extern void delete_ZARCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LinearInterpolation")]
  public static extern IntPtr new_LinearInterpolation(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LinearInterpolation_call__SWIG_0")]
  public static extern double LinearInterpolation_call__SWIG_0(HandleRef jarg1, double jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LinearInterpolation_call__SWIG_1")]
  public static extern double LinearInterpolation_call__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_LinearInterpolation")]
  public static extern void delete_LinearInterpolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LogLinearInterpolation")]
  public static extern IntPtr new_LogLinearInterpolation(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LogLinearInterpolation_call__SWIG_0")]
  public static extern double LogLinearInterpolation_call__SWIG_0(HandleRef jarg1, double jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LogLinearInterpolation_call__SWIG_1")]
  public static extern double LogLinearInterpolation_call__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_LogLinearInterpolation")]
  public static extern void delete_LogLinearInterpolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BackwardFlatInterpolation")]
  public static extern IntPtr new_BackwardFlatInterpolation(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BackwardFlatInterpolation_call__SWIG_0")]
  public static extern double BackwardFlatInterpolation_call__SWIG_0(HandleRef jarg1, double jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BackwardFlatInterpolation_call__SWIG_1")]
  public static extern double BackwardFlatInterpolation_call__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BackwardFlatInterpolation")]
  public static extern void delete_BackwardFlatInterpolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ForwardFlatInterpolation")]
  public static extern IntPtr new_ForwardFlatInterpolation(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ForwardFlatInterpolation_call__SWIG_0")]
  public static extern double ForwardFlatInterpolation_call__SWIG_0(HandleRef jarg1, double jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ForwardFlatInterpolation_call__SWIG_1")]
  public static extern double ForwardFlatInterpolation_call__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ForwardFlatInterpolation")]
  public static extern void delete_ForwardFlatInterpolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CubicSpline")]
  public static extern IntPtr new_CubicSpline(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CubicSpline_call__SWIG_0")]
  public static extern double CubicSpline_call__SWIG_0(HandleRef jarg1, double jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CubicSpline_call__SWIG_1")]
  public static extern double CubicSpline_call__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CubicSpline_derivative__SWIG_0")]
  public static extern double CubicSpline_derivative__SWIG_0(HandleRef jarg1, double jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CubicSpline_derivative__SWIG_1")]
  public static extern double CubicSpline_derivative__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CubicSpline_secondDerivative__SWIG_0")]
  public static extern double CubicSpline_secondDerivative__SWIG_0(HandleRef jarg1, double jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CubicSpline_secondDerivative__SWIG_1")]
  public static extern double CubicSpline_secondDerivative__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CubicSpline")]
  public static extern void delete_CubicSpline(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MonotonicCubicSpline")]
  public static extern IntPtr new_MonotonicCubicSpline(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MonotonicCubicSpline_call__SWIG_0")]
  public static extern double MonotonicCubicSpline_call__SWIG_0(HandleRef jarg1, double jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MonotonicCubicSpline_call__SWIG_1")]
  public static extern double MonotonicCubicSpline_call__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MonotonicCubicSpline_derivative__SWIG_0")]
  public static extern double MonotonicCubicSpline_derivative__SWIG_0(HandleRef jarg1, double jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MonotonicCubicSpline_derivative__SWIG_1")]
  public static extern double MonotonicCubicSpline_derivative__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MonotonicCubicSpline_secondDerivative__SWIG_0")]
  public static extern double MonotonicCubicSpline_secondDerivative__SWIG_0(HandleRef jarg1, double jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MonotonicCubicSpline_secondDerivative__SWIG_1")]
  public static extern double MonotonicCubicSpline_secondDerivative__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MonotonicCubicSpline")]
  public static extern void delete_MonotonicCubicSpline(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BilinearInterpolation")]
  public static extern IntPtr new_BilinearInterpolation(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BilinearInterpolation_call__SWIG_0")]
  public static extern double BilinearInterpolation_call__SWIG_0(HandleRef jarg1, double jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BilinearInterpolation_call__SWIG_1")]
  public static extern double BilinearInterpolation_call__SWIG_1(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BilinearInterpolation")]
  public static extern void delete_BilinearInterpolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BicubicSpline")]
  public static extern IntPtr new_BicubicSpline(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BicubicSpline_call__SWIG_0")]
  public static extern double BicubicSpline_call__SWIG_0(HandleRef jarg1, double jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BicubicSpline_call__SWIG_1")]
  public static extern double BicubicSpline_call__SWIG_1(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BicubicSpline")]
  public static extern void delete_BicubicSpline(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BackwardFlat")]
  public static extern IntPtr new_BackwardFlat();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BackwardFlat")]
  public static extern void delete_BackwardFlat(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ForwardFlat")]
  public static extern IntPtr new_ForwardFlat();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ForwardFlat")]
  public static extern void delete_ForwardFlat(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Linear")]
  public static extern IntPtr new_Linear();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Linear")]
  public static extern void delete_Linear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LogLinear")]
  public static extern IntPtr new_LogLinear();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_LogLinear")]
  public static extern void delete_LogLinear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Cubic")]
  public static extern IntPtr new_Cubic();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Cubic")]
  public static extern void delete_Cubic(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure___deref__")]
  public static extern IntPtr YieldTermStructure___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_isNull")]
  public static extern bool YieldTermStructure_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_asObservable")]
  public static extern IntPtr YieldTermStructure_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_YieldTermStructure")]
  public static extern IntPtr new_YieldTermStructure();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_YieldTermStructure")]
  public static extern void delete_YieldTermStructure(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_dayCounter")]
  public static extern IntPtr YieldTermStructure_dayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_calendar")]
  public static extern IntPtr YieldTermStructure_calendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_referenceDate")]
  public static extern IntPtr YieldTermStructure_referenceDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_maxDate")]
  public static extern IntPtr YieldTermStructure_maxDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_maxTime")]
  public static extern double YieldTermStructure_maxTime(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_discount__SWIG_0")]
  public static extern double YieldTermStructure_discount__SWIG_0(HandleRef jarg1, HandleRef jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_discount__SWIG_1")]
  public static extern double YieldTermStructure_discount__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_discount__SWIG_2")]
  public static extern double YieldTermStructure_discount__SWIG_2(HandleRef jarg1, double jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_discount__SWIG_3")]
  public static extern double YieldTermStructure_discount__SWIG_3(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_zeroRate__SWIG_0")]
  public static extern IntPtr YieldTermStructure_zeroRate__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4, int jarg5, bool jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_zeroRate__SWIG_1")]
  public static extern IntPtr YieldTermStructure_zeroRate__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_zeroRate__SWIG_2")]
  public static extern IntPtr YieldTermStructure_zeroRate__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_zeroRate__SWIG_3")]
  public static extern IntPtr YieldTermStructure_zeroRate__SWIG_3(HandleRef jarg1, double jarg2, int jarg3, int jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_zeroRate__SWIG_4")]
  public static extern IntPtr YieldTermStructure_zeroRate__SWIG_4(HandleRef jarg1, double jarg2, int jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_zeroRate__SWIG_5")]
  public static extern IntPtr YieldTermStructure_zeroRate__SWIG_5(HandleRef jarg1, double jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_forwardRate__SWIG_0")]
  public static extern IntPtr YieldTermStructure_forwardRate__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6, bool jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_forwardRate__SWIG_1")]
  public static extern IntPtr YieldTermStructure_forwardRate__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_forwardRate__SWIG_2")]
  public static extern IntPtr YieldTermStructure_forwardRate__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_forwardRate__SWIG_3")]
  public static extern IntPtr YieldTermStructure_forwardRate__SWIG_3(HandleRef jarg1, double jarg2, double jarg3, int jarg4, int jarg5, bool jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_forwardRate__SWIG_4")]
  public static extern IntPtr YieldTermStructure_forwardRate__SWIG_4(HandleRef jarg1, double jarg2, double jarg3, int jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_forwardRate__SWIG_5")]
  public static extern IntPtr YieldTermStructure_forwardRate__SWIG_5(HandleRef jarg1, double jarg2, double jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_enableExtrapolation")]
  public static extern void YieldTermStructure_enableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_disableExtrapolation")]
  public static extern void YieldTermStructure_disableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructure_allowsExtrapolation")]
  public static extern bool YieldTermStructure_allowsExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_YieldTermStructureHandle__SWIG_0")]
  public static extern IntPtr new_YieldTermStructureHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_YieldTermStructureHandle__SWIG_1")]
  public static extern IntPtr new_YieldTermStructureHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle___deref__")]
  public static extern IntPtr YieldTermStructureHandle___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_empty")]
  public static extern bool YieldTermStructureHandle_empty(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_asObservable")]
  public static extern IntPtr YieldTermStructureHandle_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_YieldTermStructureHandle")]
  public static extern void delete_YieldTermStructureHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_dayCounter")]
  public static extern IntPtr YieldTermStructureHandle_dayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_calendar")]
  public static extern IntPtr YieldTermStructureHandle_calendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_referenceDate")]
  public static extern IntPtr YieldTermStructureHandle_referenceDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_maxDate")]
  public static extern IntPtr YieldTermStructureHandle_maxDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_maxTime")]
  public static extern double YieldTermStructureHandle_maxTime(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_discount__SWIG_0")]
  public static extern double YieldTermStructureHandle_discount__SWIG_0(HandleRef jarg1, HandleRef jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_discount__SWIG_1")]
  public static extern double YieldTermStructureHandle_discount__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_discount__SWIG_2")]
  public static extern double YieldTermStructureHandle_discount__SWIG_2(HandleRef jarg1, double jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_discount__SWIG_3")]
  public static extern double YieldTermStructureHandle_discount__SWIG_3(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_zeroRate__SWIG_0")]
  public static extern IntPtr YieldTermStructureHandle_zeroRate__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4, int jarg5, bool jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_zeroRate__SWIG_1")]
  public static extern IntPtr YieldTermStructureHandle_zeroRate__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_zeroRate__SWIG_2")]
  public static extern IntPtr YieldTermStructureHandle_zeroRate__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_zeroRate__SWIG_3")]
  public static extern IntPtr YieldTermStructureHandle_zeroRate__SWIG_3(HandleRef jarg1, double jarg2, int jarg3, int jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_zeroRate__SWIG_4")]
  public static extern IntPtr YieldTermStructureHandle_zeroRate__SWIG_4(HandleRef jarg1, double jarg2, int jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_zeroRate__SWIG_5")]
  public static extern IntPtr YieldTermStructureHandle_zeroRate__SWIG_5(HandleRef jarg1, double jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_forwardRate__SWIG_0")]
  public static extern IntPtr YieldTermStructureHandle_forwardRate__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6, bool jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_forwardRate__SWIG_1")]
  public static extern IntPtr YieldTermStructureHandle_forwardRate__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_forwardRate__SWIG_2")]
  public static extern IntPtr YieldTermStructureHandle_forwardRate__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_forwardRate__SWIG_3")]
  public static extern IntPtr YieldTermStructureHandle_forwardRate__SWIG_3(HandleRef jarg1, double jarg2, double jarg3, int jarg4, int jarg5, bool jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_forwardRate__SWIG_4")]
  public static extern IntPtr YieldTermStructureHandle_forwardRate__SWIG_4(HandleRef jarg1, double jarg2, double jarg3, int jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_forwardRate__SWIG_5")]
  public static extern IntPtr YieldTermStructureHandle_forwardRate__SWIG_5(HandleRef jarg1, double jarg2, double jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_enableExtrapolation")]
  public static extern void YieldTermStructureHandle_enableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_disableExtrapolation")]
  public static extern void YieldTermStructureHandle_disableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureHandle_allowsExtrapolation")]
  public static extern bool YieldTermStructureHandle_allowsExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableYieldTermStructureHandle__SWIG_0")]
  public static extern IntPtr new_RelinkableYieldTermStructureHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableYieldTermStructureHandle__SWIG_1")]
  public static extern IntPtr new_RelinkableYieldTermStructureHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableYieldTermStructureHandle_linkTo")]
  public static extern void RelinkableYieldTermStructureHandle_linkTo(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_RelinkableYieldTermStructureHandle")]
  public static extern void delete_RelinkableYieldTermStructureHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ImpliedTermStructure")]
  public static extern IntPtr new_ImpliedTermStructure(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ImpliedTermStructure")]
  public static extern void delete_ImpliedTermStructure(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ZeroSpreadedTermStructure")]
  public static extern IntPtr new_ZeroSpreadedTermStructure(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ZeroSpreadedTermStructure")]
  public static extern void delete_ZeroSpreadedTermStructure(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ForwardSpreadedTermStructure")]
  public static extern IntPtr new_ForwardSpreadedTermStructure(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ForwardSpreadedTermStructure")]
  public static extern void delete_ForwardSpreadedTermStructure(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FlatForward__SWIG_0")]
  public static extern IntPtr new_FlatForward__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FlatForward__SWIG_1")]
  public static extern IntPtr new_FlatForward__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FlatForward__SWIG_2")]
  public static extern IntPtr new_FlatForward__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FlatForward__SWIG_3")]
  public static extern IntPtr new_FlatForward__SWIG_3(HandleRef jarg1, double jarg2, HandleRef jarg3, int jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FlatForward__SWIG_4")]
  public static extern IntPtr new_FlatForward__SWIG_4(HandleRef jarg1, double jarg2, HandleRef jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FlatForward__SWIG_5")]
  public static extern IntPtr new_FlatForward__SWIG_5(HandleRef jarg1, double jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FlatForward__SWIG_6")]
  public static extern IntPtr new_FlatForward__SWIG_6(int jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FlatForward__SWIG_7")]
  public static extern IntPtr new_FlatForward__SWIG_7(int jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FlatForward__SWIG_8")]
  public static extern IntPtr new_FlatForward__SWIG_8(int jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FlatForward__SWIG_9")]
  public static extern IntPtr new_FlatForward__SWIG_9(int jarg1, HandleRef jarg2, double jarg3, HandleRef jarg4, int jarg5, int jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FlatForward__SWIG_10")]
  public static extern IntPtr new_FlatForward__SWIG_10(int jarg1, HandleRef jarg2, double jarg3, HandleRef jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FlatForward__SWIG_11")]
  public static extern IntPtr new_FlatForward__SWIG_11(int jarg1, HandleRef jarg2, double jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FlatForward")]
  public static extern void delete_FlatForward(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure___deref__")]
  public static extern IntPtr BlackVolTermStructure___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_isNull")]
  public static extern bool BlackVolTermStructure_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_asObservable")]
  public static extern IntPtr BlackVolTermStructure_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackVolTermStructure")]
  public static extern IntPtr new_BlackVolTermStructure();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BlackVolTermStructure")]
  public static extern void delete_BlackVolTermStructure(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_referenceDate")]
  public static extern IntPtr BlackVolTermStructure_referenceDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_dayCounter")]
  public static extern IntPtr BlackVolTermStructure_dayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_calendar")]
  public static extern IntPtr BlackVolTermStructure_calendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_maxDate")]
  public static extern IntPtr BlackVolTermStructure_maxDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_maxTime")]
  public static extern double BlackVolTermStructure_maxTime(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_minStrike")]
  public static extern double BlackVolTermStructure_minStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_maxStrike")]
  public static extern double BlackVolTermStructure_maxStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackVol__SWIG_0")]
  public static extern double BlackVolTermStructure_blackVol__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackVol__SWIG_1")]
  public static extern double BlackVolTermStructure_blackVol__SWIG_1(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackVol__SWIG_2")]
  public static extern double BlackVolTermStructure_blackVol__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackVol__SWIG_3")]
  public static extern double BlackVolTermStructure_blackVol__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackVariance__SWIG_0")]
  public static extern double BlackVolTermStructure_blackVariance__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackVariance__SWIG_1")]
  public static extern double BlackVolTermStructure_blackVariance__SWIG_1(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackVariance__SWIG_2")]
  public static extern double BlackVolTermStructure_blackVariance__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackVariance__SWIG_3")]
  public static extern double BlackVolTermStructure_blackVariance__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackForwardVol__SWIG_0")]
  public static extern double BlackVolTermStructure_blackForwardVol__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackForwardVol__SWIG_1")]
  public static extern double BlackVolTermStructure_blackForwardVol__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackForwardVol__SWIG_2")]
  public static extern double BlackVolTermStructure_blackForwardVol__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackForwardVol__SWIG_3")]
  public static extern double BlackVolTermStructure_blackForwardVol__SWIG_3(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackForwardVariance__SWIG_0")]
  public static extern double BlackVolTermStructure_blackForwardVariance__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackForwardVariance__SWIG_1")]
  public static extern double BlackVolTermStructure_blackForwardVariance__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackForwardVariance__SWIG_2")]
  public static extern double BlackVolTermStructure_blackForwardVariance__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_blackForwardVariance__SWIG_3")]
  public static extern double BlackVolTermStructure_blackForwardVariance__SWIG_3(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_enableExtrapolation")]
  public static extern void BlackVolTermStructure_enableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_disableExtrapolation")]
  public static extern void BlackVolTermStructure_disableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructure_allowsExtrapolation")]
  public static extern bool BlackVolTermStructure_allowsExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackVolTermStructureHandle__SWIG_0")]
  public static extern IntPtr new_BlackVolTermStructureHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackVolTermStructureHandle__SWIG_1")]
  public static extern IntPtr new_BlackVolTermStructureHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle___deref__")]
  public static extern IntPtr BlackVolTermStructureHandle___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_empty")]
  public static extern bool BlackVolTermStructureHandle_empty(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_asObservable")]
  public static extern IntPtr BlackVolTermStructureHandle_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BlackVolTermStructureHandle")]
  public static extern void delete_BlackVolTermStructureHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_referenceDate")]
  public static extern IntPtr BlackVolTermStructureHandle_referenceDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_dayCounter")]
  public static extern IntPtr BlackVolTermStructureHandle_dayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_calendar")]
  public static extern IntPtr BlackVolTermStructureHandle_calendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_maxDate")]
  public static extern IntPtr BlackVolTermStructureHandle_maxDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_maxTime")]
  public static extern double BlackVolTermStructureHandle_maxTime(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_minStrike")]
  public static extern double BlackVolTermStructureHandle_minStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_maxStrike")]
  public static extern double BlackVolTermStructureHandle_maxStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackVol__SWIG_0")]
  public static extern double BlackVolTermStructureHandle_blackVol__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackVol__SWIG_1")]
  public static extern double BlackVolTermStructureHandle_blackVol__SWIG_1(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackVol__SWIG_2")]
  public static extern double BlackVolTermStructureHandle_blackVol__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackVol__SWIG_3")]
  public static extern double BlackVolTermStructureHandle_blackVol__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackVariance__SWIG_0")]
  public static extern double BlackVolTermStructureHandle_blackVariance__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackVariance__SWIG_1")]
  public static extern double BlackVolTermStructureHandle_blackVariance__SWIG_1(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackVariance__SWIG_2")]
  public static extern double BlackVolTermStructureHandle_blackVariance__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackVariance__SWIG_3")]
  public static extern double BlackVolTermStructureHandle_blackVariance__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackForwardVol__SWIG_0")]
  public static extern double BlackVolTermStructureHandle_blackForwardVol__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackForwardVol__SWIG_1")]
  public static extern double BlackVolTermStructureHandle_blackForwardVol__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackForwardVol__SWIG_2")]
  public static extern double BlackVolTermStructureHandle_blackForwardVol__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackForwardVol__SWIG_3")]
  public static extern double BlackVolTermStructureHandle_blackForwardVol__SWIG_3(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackForwardVariance__SWIG_0")]
  public static extern double BlackVolTermStructureHandle_blackForwardVariance__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackForwardVariance__SWIG_1")]
  public static extern double BlackVolTermStructureHandle_blackForwardVariance__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackForwardVariance__SWIG_2")]
  public static extern double BlackVolTermStructureHandle_blackForwardVariance__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_blackForwardVariance__SWIG_3")]
  public static extern double BlackVolTermStructureHandle_blackForwardVariance__SWIG_3(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_enableExtrapolation")]
  public static extern void BlackVolTermStructureHandle_enableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_disableExtrapolation")]
  public static extern void BlackVolTermStructureHandle_disableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureHandle_allowsExtrapolation")]
  public static extern bool BlackVolTermStructureHandle_allowsExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableBlackVolTermStructureHandle__SWIG_0")]
  public static extern IntPtr new_RelinkableBlackVolTermStructureHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableBlackVolTermStructureHandle__SWIG_1")]
  public static extern IntPtr new_RelinkableBlackVolTermStructureHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableBlackVolTermStructureHandle_linkTo")]
  public static extern void RelinkableBlackVolTermStructureHandle_linkTo(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_RelinkableBlackVolTermStructureHandle")]
  public static extern void delete_RelinkableBlackVolTermStructureHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure___deref__")]
  public static extern IntPtr LocalVolTermStructure___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_isNull")]
  public static extern bool LocalVolTermStructure_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_asObservable")]
  public static extern IntPtr LocalVolTermStructure_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LocalVolTermStructure")]
  public static extern IntPtr new_LocalVolTermStructure();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_LocalVolTermStructure")]
  public static extern void delete_LocalVolTermStructure(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_referenceDate")]
  public static extern IntPtr LocalVolTermStructure_referenceDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_dayCounter")]
  public static extern IntPtr LocalVolTermStructure_dayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_calendar")]
  public static extern IntPtr LocalVolTermStructure_calendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_maxDate")]
  public static extern IntPtr LocalVolTermStructure_maxDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_maxTime")]
  public static extern double LocalVolTermStructure_maxTime(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_minStrike")]
  public static extern double LocalVolTermStructure_minStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_maxStrike")]
  public static extern double LocalVolTermStructure_maxStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_localVol__SWIG_0")]
  public static extern double LocalVolTermStructure_localVol__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_localVol__SWIG_1")]
  public static extern double LocalVolTermStructure_localVol__SWIG_1(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_localVol__SWIG_2")]
  public static extern double LocalVolTermStructure_localVol__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_localVol__SWIG_3")]
  public static extern double LocalVolTermStructure_localVol__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_enableExtrapolation")]
  public static extern void LocalVolTermStructure_enableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_disableExtrapolation")]
  public static extern void LocalVolTermStructure_disableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructure_allowsExtrapolation")]
  public static extern bool LocalVolTermStructure_allowsExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LocalVolTermStructureHandle__SWIG_0")]
  public static extern IntPtr new_LocalVolTermStructureHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LocalVolTermStructureHandle__SWIG_1")]
  public static extern IntPtr new_LocalVolTermStructureHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle___deref__")]
  public static extern IntPtr LocalVolTermStructureHandle___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_empty")]
  public static extern bool LocalVolTermStructureHandle_empty(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_asObservable")]
  public static extern IntPtr LocalVolTermStructureHandle_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_LocalVolTermStructureHandle")]
  public static extern void delete_LocalVolTermStructureHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_referenceDate")]
  public static extern IntPtr LocalVolTermStructureHandle_referenceDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_dayCounter")]
  public static extern IntPtr LocalVolTermStructureHandle_dayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_calendar")]
  public static extern IntPtr LocalVolTermStructureHandle_calendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_maxDate")]
  public static extern IntPtr LocalVolTermStructureHandle_maxDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_maxTime")]
  public static extern double LocalVolTermStructureHandle_maxTime(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_minStrike")]
  public static extern double LocalVolTermStructureHandle_minStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_maxStrike")]
  public static extern double LocalVolTermStructureHandle_maxStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_localVol__SWIG_0")]
  public static extern double LocalVolTermStructureHandle_localVol__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_localVol__SWIG_1")]
  public static extern double LocalVolTermStructureHandle_localVol__SWIG_1(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_localVol__SWIG_2")]
  public static extern double LocalVolTermStructureHandle_localVol__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_localVol__SWIG_3")]
  public static extern double LocalVolTermStructureHandle_localVol__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_enableExtrapolation")]
  public static extern void LocalVolTermStructureHandle_enableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_disableExtrapolation")]
  public static extern void LocalVolTermStructureHandle_disableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalVolTermStructureHandle_allowsExtrapolation")]
  public static extern bool LocalVolTermStructureHandle_allowsExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableLocalVolTermStructureHandle__SWIG_0")]
  public static extern IntPtr new_RelinkableLocalVolTermStructureHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableLocalVolTermStructureHandle__SWIG_1")]
  public static extern IntPtr new_RelinkableLocalVolTermStructureHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableLocalVolTermStructureHandle_linkTo")]
  public static extern void RelinkableLocalVolTermStructureHandle_linkTo(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_RelinkableLocalVolTermStructureHandle")]
  public static extern void delete_RelinkableLocalVolTermStructureHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure___deref__")]
  public static extern IntPtr CapletVolatilityStructure___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_isNull")]
  public static extern bool CapletVolatilityStructure_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_asObservable")]
  public static extern IntPtr CapletVolatilityStructure_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapletVolatilityStructure")]
  public static extern IntPtr new_CapletVolatilityStructure();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CapletVolatilityStructure")]
  public static extern void delete_CapletVolatilityStructure(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_referenceDate")]
  public static extern IntPtr CapletVolatilityStructure_referenceDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_dayCounter")]
  public static extern IntPtr CapletVolatilityStructure_dayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_calendar")]
  public static extern IntPtr CapletVolatilityStructure_calendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_maxDate")]
  public static extern IntPtr CapletVolatilityStructure_maxDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_maxTime")]
  public static extern double CapletVolatilityStructure_maxTime(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_minStrike")]
  public static extern double CapletVolatilityStructure_minStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_maxStrike")]
  public static extern double CapletVolatilityStructure_maxStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_volatility__SWIG_0")]
  public static extern double CapletVolatilityStructure_volatility__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_volatility__SWIG_1")]
  public static extern double CapletVolatilityStructure_volatility__SWIG_1(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_volatility__SWIG_2")]
  public static extern double CapletVolatilityStructure_volatility__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_volatility__SWIG_3")]
  public static extern double CapletVolatilityStructure_volatility__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_blackVariance__SWIG_0")]
  public static extern double CapletVolatilityStructure_blackVariance__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_blackVariance__SWIG_1")]
  public static extern double CapletVolatilityStructure_blackVariance__SWIG_1(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_blackVariance__SWIG_2")]
  public static extern double CapletVolatilityStructure_blackVariance__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_blackVariance__SWIG_3")]
  public static extern double CapletVolatilityStructure_blackVariance__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_enableExtrapolation")]
  public static extern void CapletVolatilityStructure_enableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_disableExtrapolation")]
  public static extern void CapletVolatilityStructure_disableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructure_allowsExtrapolation")]
  public static extern bool CapletVolatilityStructure_allowsExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapletVolatilityStructureHandle__SWIG_0")]
  public static extern IntPtr new_CapletVolatilityStructureHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapletVolatilityStructureHandle__SWIG_1")]
  public static extern IntPtr new_CapletVolatilityStructureHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle___deref__")]
  public static extern IntPtr CapletVolatilityStructureHandle___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_empty")]
  public static extern bool CapletVolatilityStructureHandle_empty(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_asObservable")]
  public static extern IntPtr CapletVolatilityStructureHandle_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CapletVolatilityStructureHandle")]
  public static extern void delete_CapletVolatilityStructureHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_referenceDate")]
  public static extern IntPtr CapletVolatilityStructureHandle_referenceDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_dayCounter")]
  public static extern IntPtr CapletVolatilityStructureHandle_dayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_calendar")]
  public static extern IntPtr CapletVolatilityStructureHandle_calendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_maxDate")]
  public static extern IntPtr CapletVolatilityStructureHandle_maxDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_maxTime")]
  public static extern double CapletVolatilityStructureHandle_maxTime(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_minStrike")]
  public static extern double CapletVolatilityStructureHandle_minStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_maxStrike")]
  public static extern double CapletVolatilityStructureHandle_maxStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_volatility__SWIG_0")]
  public static extern double CapletVolatilityStructureHandle_volatility__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_volatility__SWIG_1")]
  public static extern double CapletVolatilityStructureHandle_volatility__SWIG_1(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_volatility__SWIG_2")]
  public static extern double CapletVolatilityStructureHandle_volatility__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_volatility__SWIG_3")]
  public static extern double CapletVolatilityStructureHandle_volatility__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_blackVariance__SWIG_0")]
  public static extern double CapletVolatilityStructureHandle_blackVariance__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_blackVariance__SWIG_1")]
  public static extern double CapletVolatilityStructureHandle_blackVariance__SWIG_1(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_blackVariance__SWIG_2")]
  public static extern double CapletVolatilityStructureHandle_blackVariance__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_blackVariance__SWIG_3")]
  public static extern double CapletVolatilityStructureHandle_blackVariance__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_enableExtrapolation")]
  public static extern void CapletVolatilityStructureHandle_enableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_disableExtrapolation")]
  public static extern void CapletVolatilityStructureHandle_disableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletVolatilityStructureHandle_allowsExtrapolation")]
  public static extern bool CapletVolatilityStructureHandle_allowsExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableCapletVolatilityStructureHandle__SWIG_0")]
  public static extern IntPtr new_RelinkableCapletVolatilityStructureHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableCapletVolatilityStructureHandle__SWIG_1")]
  public static extern IntPtr new_RelinkableCapletVolatilityStructureHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableCapletVolatilityStructureHandle_linkTo")]
  public static extern void RelinkableCapletVolatilityStructureHandle_linkTo(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_RelinkableCapletVolatilityStructureHandle")]
  public static extern void delete_RelinkableCapletVolatilityStructureHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure___deref__")]
  public static extern IntPtr SwaptionVolatilityStructure___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_isNull")]
  public static extern bool SwaptionVolatilityStructure_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_asObservable")]
  public static extern IntPtr SwaptionVolatilityStructure_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SwaptionVolatilityStructure")]
  public static extern IntPtr new_SwaptionVolatilityStructure();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SwaptionVolatilityStructure")]
  public static extern void delete_SwaptionVolatilityStructure(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_referenceDate")]
  public static extern IntPtr SwaptionVolatilityStructure_referenceDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_dayCounter")]
  public static extern IntPtr SwaptionVolatilityStructure_dayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_calendar")]
  public static extern IntPtr SwaptionVolatilityStructure_calendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_maxSwapTenor")]
  public static extern IntPtr SwaptionVolatilityStructure_maxSwapTenor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_maxSwapLength")]
  public static extern double SwaptionVolatilityStructure_maxSwapLength(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_minStrike")]
  public static extern double SwaptionVolatilityStructure_minStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_maxStrike")]
  public static extern double SwaptionVolatilityStructure_maxStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_volatility__SWIG_0")]
  public static extern double SwaptionVolatilityStructure_volatility__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_volatility__SWIG_1")]
  public static extern double SwaptionVolatilityStructure_volatility__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_volatility__SWIG_2")]
  public static extern double SwaptionVolatilityStructure_volatility__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_volatility__SWIG_3")]
  public static extern double SwaptionVolatilityStructure_volatility__SWIG_3(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_blackVariance__SWIG_0")]
  public static extern double SwaptionVolatilityStructure_blackVariance__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_blackVariance__SWIG_1")]
  public static extern double SwaptionVolatilityStructure_blackVariance__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_blackVariance__SWIG_2")]
  public static extern double SwaptionVolatilityStructure_blackVariance__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_blackVariance__SWIG_3")]
  public static extern double SwaptionVolatilityStructure_blackVariance__SWIG_3(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_enableExtrapolation")]
  public static extern void SwaptionVolatilityStructure_enableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_disableExtrapolation")]
  public static extern void SwaptionVolatilityStructure_disableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructure_allowsExtrapolation")]
  public static extern bool SwaptionVolatilityStructure_allowsExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SwaptionVolatilityStructureHandle__SWIG_0")]
  public static extern IntPtr new_SwaptionVolatilityStructureHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SwaptionVolatilityStructureHandle__SWIG_1")]
  public static extern IntPtr new_SwaptionVolatilityStructureHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle___deref__")]
  public static extern IntPtr SwaptionVolatilityStructureHandle___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_empty")]
  public static extern bool SwaptionVolatilityStructureHandle_empty(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_asObservable")]
  public static extern IntPtr SwaptionVolatilityStructureHandle_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SwaptionVolatilityStructureHandle")]
  public static extern void delete_SwaptionVolatilityStructureHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_referenceDate")]
  public static extern IntPtr SwaptionVolatilityStructureHandle_referenceDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_dayCounter")]
  public static extern IntPtr SwaptionVolatilityStructureHandle_dayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_calendar")]
  public static extern IntPtr SwaptionVolatilityStructureHandle_calendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_maxSwapTenor")]
  public static extern IntPtr SwaptionVolatilityStructureHandle_maxSwapTenor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_maxSwapLength")]
  public static extern double SwaptionVolatilityStructureHandle_maxSwapLength(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_minStrike")]
  public static extern double SwaptionVolatilityStructureHandle_minStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_maxStrike")]
  public static extern double SwaptionVolatilityStructureHandle_maxStrike(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_volatility__SWIG_0")]
  public static extern double SwaptionVolatilityStructureHandle_volatility__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_volatility__SWIG_1")]
  public static extern double SwaptionVolatilityStructureHandle_volatility__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_volatility__SWIG_2")]
  public static extern double SwaptionVolatilityStructureHandle_volatility__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_volatility__SWIG_3")]
  public static extern double SwaptionVolatilityStructureHandle_volatility__SWIG_3(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_blackVariance__SWIG_0")]
  public static extern double SwaptionVolatilityStructureHandle_blackVariance__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_blackVariance__SWIG_1")]
  public static extern double SwaptionVolatilityStructureHandle_blackVariance__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_blackVariance__SWIG_2")]
  public static extern double SwaptionVolatilityStructureHandle_blackVariance__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, double jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_blackVariance__SWIG_3")]
  public static extern double SwaptionVolatilityStructureHandle_blackVariance__SWIG_3(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_enableExtrapolation")]
  public static extern void SwaptionVolatilityStructureHandle_enableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_disableExtrapolation")]
  public static extern void SwaptionVolatilityStructureHandle_disableExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityStructureHandle_allowsExtrapolation")]
  public static extern bool SwaptionVolatilityStructureHandle_allowsExtrapolation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableSwaptionVolatilityStructureHandle__SWIG_0")]
  public static extern IntPtr new_RelinkableSwaptionVolatilityStructureHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableSwaptionVolatilityStructureHandle__SWIG_1")]
  public static extern IntPtr new_RelinkableSwaptionVolatilityStructureHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableSwaptionVolatilityStructureHandle_linkTo")]
  public static extern void RelinkableSwaptionVolatilityStructureHandle_linkTo(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_RelinkableSwaptionVolatilityStructureHandle")]
  public static extern void delete_RelinkableSwaptionVolatilityStructureHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackConstantVol__SWIG_0")]
  public static extern IntPtr new_BlackConstantVol__SWIG_0(HandleRef jarg1, double jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackConstantVol__SWIG_1")]
  public static extern IntPtr new_BlackConstantVol__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackConstantVol__SWIG_2")]
  public static extern IntPtr new_BlackConstantVol__SWIG_2(int jarg1, HandleRef jarg2, double jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackConstantVol__SWIG_3")]
  public static extern IntPtr new_BlackConstantVol__SWIG_3(int jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BlackConstantVol")]
  public static extern void delete_BlackConstantVol(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete__BlackVarianceSurface")]
  public static extern void delete__BlackVarianceSurface(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackVarianceSurface__SWIG_0")]
  public static extern IntPtr new_BlackVarianceSurface__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6, int jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackVarianceSurface__SWIG_1")]
  public static extern IntPtr new_BlackVarianceSurface__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackVarianceSurface__SWIG_2")]
  public static extern IntPtr new_BlackVarianceSurface__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVarianceSurface_ConstantExtrapolation_get")]
  public static extern int BlackVarianceSurface_ConstantExtrapolation_get();

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVarianceSurface_InterpolatorDefaultExtrapolation_get")]
  public static extern int BlackVarianceSurface_InterpolatorDefaultExtrapolation_get();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BlackVarianceSurface")]
  public static extern void delete_BlackVarianceSurface(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LocalConstantVol__SWIG_0")]
  public static extern IntPtr new_LocalConstantVol__SWIG_0(HandleRef jarg1, double jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LocalConstantVol__SWIG_1")]
  public static extern IntPtr new_LocalConstantVol__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LocalConstantVol__SWIG_2")]
  public static extern IntPtr new_LocalConstantVol__SWIG_2(int jarg1, HandleRef jarg2, double jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LocalConstantVol__SWIG_3")]
  public static extern IntPtr new_LocalConstantVol__SWIG_3(int jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_LocalConstantVol")]
  public static extern void delete_LocalConstantVol(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapletConstantVolatility__SWIG_0")]
  public static extern IntPtr new_CapletConstantVolatility__SWIG_0(HandleRef jarg1, double jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapletConstantVolatility__SWIG_1")]
  public static extern IntPtr new_CapletConstantVolatility__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapletConstantVolatility__SWIG_2")]
  public static extern IntPtr new_CapletConstantVolatility__SWIG_2(double jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapletConstantVolatility__SWIG_3")]
  public static extern IntPtr new_CapletConstantVolatility__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CapletConstantVolatility")]
  public static extern void delete_CapletConstantVolatility(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SwaptionVolatilityMatrix")]
  public static extern IntPtr new_SwaptionVolatilityMatrix(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SwaptionVolatilityMatrix")]
  public static extern void delete_SwaptionVolatilityMatrix(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcess___deref__")]
  public static extern IntPtr StochasticProcess___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcess_isNull")]
  public static extern bool StochasticProcess_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcess_asObservable")]
  public static extern IntPtr StochasticProcess_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_StochasticProcess")]
  public static extern IntPtr new_StochasticProcess();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_StochasticProcess")]
  public static extern void delete_StochasticProcess(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_StochasticProcess1D")]
  public static extern void delete_StochasticProcess1D(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GeneralizedBlackScholesPress")]
  public static extern IntPtr new_GeneralizedBlackScholesPress(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GeneralizedBlackScholesPress")]
  public static extern void delete_GeneralizedBlackScholesPress(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackScholesProcess")]
  public static extern IntPtr new_BlackScholesProcess(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BlackScholesProcess")]
  public static extern void delete_BlackScholesProcess(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackScholesMertonProcess")]
  public static extern IntPtr new_BlackScholesMertonProcess(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BlackScholesMertonProcess")]
  public static extern void delete_BlackScholesMertonProcess(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackProcess")]
  public static extern IntPtr new_BlackProcess(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BlackProcess")]
  public static extern void delete_BlackProcess(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GarmanKohlagenProcess")]
  public static extern IntPtr new_GarmanKohlagenProcess(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GarmanKohlagenProcess")]
  public static extern void delete_GarmanKohlagenProcess(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Merton76Process")]
  public static extern IntPtr new_Merton76Process(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Merton76Process")]
  public static extern void delete_Merton76Process(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_StochasticProcessArray")]
  public static extern IntPtr new_StochasticProcessArray(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_StochasticProcessArray")]
  public static extern void delete_StochasticProcessArray(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_Clear")]
  public static extern void StochasticProcessVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_Add")]
  public static extern void StochasticProcessVector_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_size")]
  public static extern uint StochasticProcessVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_capacity")]
  public static extern uint StochasticProcessVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_reserve")]
  public static extern void StochasticProcessVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_StochasticProcessVector__SWIG_0")]
  public static extern IntPtr new_StochasticProcessVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_StochasticProcessVector__SWIG_1")]
  public static extern IntPtr new_StochasticProcessVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_getitemcopy")]
  public static extern IntPtr StochasticProcessVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_getitem")]
  public static extern IntPtr StochasticProcessVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_setitem")]
  public static extern void StochasticProcessVector_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_AddRange")]
  public static extern void StochasticProcessVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_GetRange")]
  public static extern IntPtr StochasticProcessVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_Insert")]
  public static extern void StochasticProcessVector_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_InsertRange")]
  public static extern void StochasticProcessVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_RemoveAt")]
  public static extern void StochasticProcessVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_RemoveRange")]
  public static extern void StochasticProcessVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_Repeat")]
  public static extern IntPtr StochasticProcessVector_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_Reverse__SWIG_0")]
  public static extern void StochasticProcessVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_Reverse__SWIG_1")]
  public static extern void StochasticProcessVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_SetRange")]
  public static extern void StochasticProcessVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_Contains")]
  public static extern bool StochasticProcessVector_Contains(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_IndexOf")]
  public static extern int StochasticProcessVector_IndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_LastIndexOf")]
  public static extern int StochasticProcessVector_LastIndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessVector_Remove")]
  public static extern void StochasticProcessVector_Remove(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_StochasticProcessVector")]
  public static extern void delete_StochasticProcessVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PricingEngine___deref__")]
  public static extern IntPtr PricingEngine___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PricingEngine_isNull")]
  public static extern bool PricingEngine_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PricingEngine")]
  public static extern IntPtr new_PricingEngine();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_PricingEngine")]
  public static extern void delete_PricingEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Instrument___deref__")]
  public static extern IntPtr Instrument___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Instrument_isNull")]
  public static extern bool Instrument_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Instrument_asObservable")]
  public static extern IntPtr Instrument_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Instrument")]
  public static extern IntPtr new_Instrument();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Instrument")]
  public static extern void delete_Instrument(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Instrument_NPV")]
  public static extern double Instrument_NPV(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Instrument_errorEstimate")]
  public static extern double Instrument_errorEstimate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Instrument_isExpired")]
  public static extern bool Instrument_isExpired(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Instrument_setPricingEngine")]
  public static extern void Instrument_setPricingEngine(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Instrument_recalculate")]
  public static extern void Instrument_recalculate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Instrument_freeze")]
  public static extern void Instrument_freeze(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Instrument_unfreeze")]
  public static extern void Instrument_unfreeze(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Stock")]
  public static extern IntPtr new_Stock(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Stock")]
  public static extern void delete_Stock(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CompositeInstrument")]
  public static extern IntPtr new_CompositeInstrument();

  [DllImport("NQuantLibc", EntryPoint="CSharp_CompositeInstrument_add__SWIG_0")]
  public static extern void CompositeInstrument_add__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CompositeInstrument_add__SWIG_1")]
  public static extern void CompositeInstrument_add__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CompositeInstrument_subtract__SWIG_0")]
  public static extern void CompositeInstrument_subtract__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CompositeInstrument_subtract__SWIG_1")]
  public static extern void CompositeInstrument_subtract__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CompositeInstrument")]
  public static extern void delete_CompositeInstrument(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Option")]
  public static extern void delete_Option(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Barrier")]
  public static extern IntPtr new_Barrier();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Barrier")]
  public static extern void delete_Barrier(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Payoff___deref__")]
  public static extern IntPtr Payoff___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Payoff_isNull")]
  public static extern bool Payoff_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Payoff")]
  public static extern IntPtr new_Payoff();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Payoff")]
  public static extern void delete_Payoff(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Payoff_call")]
  public static extern double Payoff_call(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_VanillaOption__SWIG_0")]
  public static extern IntPtr new_VanillaOption__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_VanillaOption__SWIG_1")]
  public static extern IntPtr new_VanillaOption__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_delta")]
  public static extern double VanillaOption_delta(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_gamma")]
  public static extern double VanillaOption_gamma(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_theta")]
  public static extern double VanillaOption_theta(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_thetaPerDay")]
  public static extern double VanillaOption_thetaPerDay(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_vega")]
  public static extern double VanillaOption_vega(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_rho")]
  public static extern double VanillaOption_rho(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_dividendRho")]
  public static extern double VanillaOption_dividendRho(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_strikeSensitivity")]
  public static extern double VanillaOption_strikeSensitivity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_priceCurve")]
  public static extern IntPtr VanillaOption_priceCurve(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_impliedVolatility__SWIG_0")]
  public static extern double VanillaOption_impliedVolatility__SWIG_0(HandleRef jarg1, double jarg2, double jarg3, uint jarg4, double jarg5, double jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_impliedVolatility__SWIG_1")]
  public static extern double VanillaOption_impliedVolatility__SWIG_1(HandleRef jarg1, double jarg2, double jarg3, uint jarg4, double jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_impliedVolatility__SWIG_2")]
  public static extern double VanillaOption_impliedVolatility__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, uint jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_impliedVolatility__SWIG_3")]
  public static extern double VanillaOption_impliedVolatility__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOption_impliedVolatility__SWIG_4")]
  public static extern double VanillaOption_impliedVolatility__SWIG_4(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_VanillaOption")]
  public static extern void delete_VanillaOption(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuropeanOption__SWIG_0")]
  public static extern IntPtr new_EuropeanOption__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuropeanOption__SWIG_1")]
  public static extern IntPtr new_EuropeanOption__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuropeanOption")]
  public static extern void delete_EuropeanOption(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ForwardVanillaOption__SWIG_0")]
  public static extern IntPtr new_ForwardVanillaOption__SWIG_0(double jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ForwardVanillaOption__SWIG_1")]
  public static extern IntPtr new_ForwardVanillaOption__SWIG_1(double jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ForwardVanillaOption")]
  public static extern void delete_ForwardVanillaOption(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QuantoVanillaOption__SWIG_0")]
  public static extern IntPtr new_QuantoVanillaOption__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QuantoVanillaOption__SWIG_1")]
  public static extern IntPtr new_QuantoVanillaOption__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuantoVanillaOption_qvega")]
  public static extern double QuantoVanillaOption_qvega(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuantoVanillaOption_qrho")]
  public static extern double QuantoVanillaOption_qrho(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuantoVanillaOption_qlambda")]
  public static extern double QuantoVanillaOption_qlambda(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_QuantoVanillaOption")]
  public static extern void delete_QuantoVanillaOption(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QuantoForwardVanillaOption__SWIG_0")]
  public static extern IntPtr new_QuantoForwardVanillaOption__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8, HandleRef jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QuantoForwardVanillaOption__SWIG_1")]
  public static extern IntPtr new_QuantoForwardVanillaOption__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_QuantoForwardVanillaOption")]
  public static extern void delete_QuantoForwardVanillaOption(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultiAssetOption_delta")]
  public static extern double MultiAssetOption_delta(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultiAssetOption_gamma")]
  public static extern double MultiAssetOption_gamma(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultiAssetOption_theta")]
  public static extern double MultiAssetOption_theta(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultiAssetOption_vega")]
  public static extern double MultiAssetOption_vega(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultiAssetOption_rho")]
  public static extern double MultiAssetOption_rho(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultiAssetOption_dividendRho")]
  public static extern double MultiAssetOption_dividendRho(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MultiAssetOption")]
  public static extern IntPtr new_MultiAssetOption();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MultiAssetOption")]
  public static extern void delete_MultiAssetOption(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_AnalyticEuropeanEngine")]
  public static extern IntPtr new_AnalyticEuropeanEngine();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_AnalyticEuropeanEngine")]
  public static extern void delete_AnalyticEuropeanEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IntegralEngine")]
  public static extern IntPtr new_IntegralEngine();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_IntegralEngine")]
  public static extern void delete_IntegralEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDEuropeanEngine__SWIG_0")]
  public static extern IntPtr new_FDEuropeanEngine__SWIG_0(uint jarg1, uint jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDEuropeanEngine__SWIG_1")]
  public static extern IntPtr new_FDEuropeanEngine__SWIG_1(uint jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDEuropeanEngine__SWIG_2")]
  public static extern IntPtr new_FDEuropeanEngine__SWIG_2(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDEuropeanEngine__SWIG_3")]
  public static extern IntPtr new_FDEuropeanEngine__SWIG_3();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FDEuropeanEngine")]
  public static extern void delete_FDEuropeanEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BinomialVanillaEngine")]
  public static extern IntPtr new_BinomialVanillaEngine(string jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BinomialVanillaEngine")]
  public static extern void delete_BinomialVanillaEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MCEuropeanEngine")]
  public static extern IntPtr new_MCEuropeanEngine(string jarg1, int jarg2, int jarg3, bool jarg4, bool jarg5, bool jarg6, int jarg7, double jarg8, int jarg9, int jarg10);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MCEuropeanEngine")]
  public static extern void delete_MCEuropeanEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDAmericanEngine__SWIG_0")]
  public static extern IntPtr new_FDAmericanEngine__SWIG_0(uint jarg1, uint jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDAmericanEngine__SWIG_1")]
  public static extern IntPtr new_FDAmericanEngine__SWIG_1(uint jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDAmericanEngine__SWIG_2")]
  public static extern IntPtr new_FDAmericanEngine__SWIG_2(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDAmericanEngine__SWIG_3")]
  public static extern IntPtr new_FDAmericanEngine__SWIG_3();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FDAmericanEngine")]
  public static extern void delete_FDAmericanEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDShoutEngine__SWIG_0")]
  public static extern IntPtr new_FDShoutEngine__SWIG_0(uint jarg1, uint jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDShoutEngine__SWIG_1")]
  public static extern IntPtr new_FDShoutEngine__SWIG_1(uint jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDShoutEngine__SWIG_2")]
  public static extern IntPtr new_FDShoutEngine__SWIG_2(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDShoutEngine__SWIG_3")]
  public static extern IntPtr new_FDShoutEngine__SWIG_3();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FDShoutEngine")]
  public static extern void delete_FDShoutEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BaroneAdesiWhaleyEngine")]
  public static extern IntPtr new_BaroneAdesiWhaleyEngine();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BaroneAdesiWhaleyEngine")]
  public static extern void delete_BaroneAdesiWhaleyEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BjerksundStenslandEngine")]
  public static extern IntPtr new_BjerksundStenslandEngine();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BjerksundStenslandEngine")]
  public static extern void delete_BjerksundStenslandEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_AnalyticDigitalAmericanEngine")]
  public static extern IntPtr new_AnalyticDigitalAmericanEngine();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_AnalyticDigitalAmericanEngine")]
  public static extern void delete_AnalyticDigitalAmericanEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DividendVanillaOption__SWIG_0")]
  public static extern IntPtr new_DividendVanillaOption__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DividendVanillaOption__SWIG_1")]
  public static extern IntPtr new_DividendVanillaOption__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOption_delta")]
  public static extern double DividendVanillaOption_delta(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOption_gamma")]
  public static extern double DividendVanillaOption_gamma(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOption_theta")]
  public static extern double DividendVanillaOption_theta(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOption_vega")]
  public static extern double DividendVanillaOption_vega(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOption_rho")]
  public static extern double DividendVanillaOption_rho(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOption_dividendRho")]
  public static extern double DividendVanillaOption_dividendRho(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOption_strikeSensitivity")]
  public static extern double DividendVanillaOption_strikeSensitivity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOption_priceCurve")]
  public static extern IntPtr DividendVanillaOption_priceCurve(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOption_impliedVolatility__SWIG_0")]
  public static extern double DividendVanillaOption_impliedVolatility__SWIG_0(HandleRef jarg1, double jarg2, double jarg3, uint jarg4, double jarg5, double jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOption_impliedVolatility__SWIG_1")]
  public static extern double DividendVanillaOption_impliedVolatility__SWIG_1(HandleRef jarg1, double jarg2, double jarg3, uint jarg4, double jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOption_impliedVolatility__SWIG_2")]
  public static extern double DividendVanillaOption_impliedVolatility__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, uint jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOption_impliedVolatility__SWIG_3")]
  public static extern double DividendVanillaOption_impliedVolatility__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOption_impliedVolatility__SWIG_4")]
  public static extern double DividendVanillaOption_impliedVolatility__SWIG_4(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DividendVanillaOption")]
  public static extern void delete_DividendVanillaOption(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_AnalyticDividendEuropeanEngine")]
  public static extern IntPtr new_AnalyticDividendEuropeanEngine();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_AnalyticDividendEuropeanEngine")]
  public static extern void delete_AnalyticDividendEuropeanEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDDividendEuropeanEngine__SWIG_0")]
  public static extern IntPtr new_FDDividendEuropeanEngine__SWIG_0(uint jarg1, uint jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDDividendEuropeanEngine__SWIG_1")]
  public static extern IntPtr new_FDDividendEuropeanEngine__SWIG_1(uint jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDDividendEuropeanEngine__SWIG_2")]
  public static extern IntPtr new_FDDividendEuropeanEngine__SWIG_2(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDDividendEuropeanEngine__SWIG_3")]
  public static extern IntPtr new_FDDividendEuropeanEngine__SWIG_3();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FDDividendEuropeanEngine")]
  public static extern void delete_FDDividendEuropeanEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDDividendAmericanEngine__SWIG_0")]
  public static extern IntPtr new_FDDividendAmericanEngine__SWIG_0(uint jarg1, uint jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDDividendAmericanEngine__SWIG_1")]
  public static extern IntPtr new_FDDividendAmericanEngine__SWIG_1(uint jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDDividendAmericanEngine__SWIG_2")]
  public static extern IntPtr new_FDDividendAmericanEngine__SWIG_2(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FDDividendAmericanEngine__SWIG_3")]
  public static extern IntPtr new_FDDividendAmericanEngine__SWIG_3();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FDDividendAmericanEngine")]
  public static extern void delete_FDDividendAmericanEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BarrierOption__SWIG_0")]
  public static extern IntPtr new_BarrierOption__SWIG_0(int jarg1, double jarg2, double jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BarrierOption__SWIG_1")]
  public static extern IntPtr new_BarrierOption__SWIG_1(int jarg1, double jarg2, double jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOption_delta")]
  public static extern double BarrierOption_delta(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOption_gamma")]
  public static extern double BarrierOption_gamma(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOption_theta")]
  public static extern double BarrierOption_theta(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOption_vega")]
  public static extern double BarrierOption_vega(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOption_rho")]
  public static extern double BarrierOption_rho(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOption_dividendRho")]
  public static extern double BarrierOption_dividendRho(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOption_strikeSensitivity")]
  public static extern double BarrierOption_strikeSensitivity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOption_priceCurve")]
  public static extern IntPtr BarrierOption_priceCurve(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOption_impliedVolatility__SWIG_0")]
  public static extern double BarrierOption_impliedVolatility__SWIG_0(HandleRef jarg1, double jarg2, double jarg3, uint jarg4, double jarg5, double jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOption_impliedVolatility__SWIG_1")]
  public static extern double BarrierOption_impliedVolatility__SWIG_1(HandleRef jarg1, double jarg2, double jarg3, uint jarg4, double jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOption_impliedVolatility__SWIG_2")]
  public static extern double BarrierOption_impliedVolatility__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, uint jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOption_impliedVolatility__SWIG_3")]
  public static extern double BarrierOption_impliedVolatility__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOption_impliedVolatility__SWIG_4")]
  public static extern double BarrierOption_impliedVolatility__SWIG_4(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BarrierOption")]
  public static extern void delete_BarrierOption(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_AnalyticBarrierEngine")]
  public static extern IntPtr new_AnalyticBarrierEngine();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_AnalyticBarrierEngine")]
  public static extern void delete_AnalyticBarrierEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MCBarrierEngine")]
  public static extern IntPtr new_MCBarrierEngine(string jarg1, uint jarg2, bool jarg3, bool jarg4, bool jarg5, int jarg6, double jarg7, int jarg8, bool jarg9, int jarg10);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MCBarrierEngine")]
  public static extern void delete_MCBarrierEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ForwardVanillaEngine")]
  public static extern IntPtr new_ForwardVanillaEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ForwardVanillaEngine")]
  public static extern void delete_ForwardVanillaEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QuantoVanillaEngine")]
  public static extern IntPtr new_QuantoVanillaEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_QuantoVanillaEngine")]
  public static extern void delete_QuantoVanillaEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_QuantoForwardVanillaEngine")]
  public static extern IntPtr new_QuantoForwardVanillaEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_QuantoForwardVanillaEngine")]
  public static extern void delete_QuantoForwardVanillaEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PlainVanillaPayoff")]
  public static extern IntPtr new_PlainVanillaPayoff(int jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_PlainVanillaPayoff")]
  public static extern void delete_PlainVanillaPayoff(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PercentageStrikePayoff")]
  public static extern IntPtr new_PercentageStrikePayoff(int jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_PercentageStrikePayoff")]
  public static extern void delete_PercentageStrikePayoff(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CashOrNothingPayoff")]
  public static extern IntPtr new_CashOrNothingPayoff(int jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CashOrNothingPayoff")]
  public static extern void delete_CashOrNothingPayoff(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_AssetOrNothingPayoff")]
  public static extern IntPtr new_AssetOrNothingPayoff(int jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_AssetOrNothingPayoff")]
  public static extern void delete_AssetOrNothingPayoff(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SuperSharePayoff")]
  public static extern IntPtr new_SuperSharePayoff(int jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SuperSharePayoff")]
  public static extern void delete_SuperSharePayoff(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GapPayoff")]
  public static extern IntPtr new_GapPayoff(int jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GapPayoff")]
  public static extern void delete_GapPayoff(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BasketPayoff")]
  public static extern IntPtr new_BasketPayoff();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BasketPayoff")]
  public static extern void delete_BasketPayoff(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MinBasketPayoff")]
  public static extern IntPtr new_MinBasketPayoff(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MinBasketPayoff")]
  public static extern void delete_MinBasketPayoff(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MaxBasketPayoff")]
  public static extern IntPtr new_MaxBasketPayoff(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MaxBasketPayoff")]
  public static extern void delete_MaxBasketPayoff(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_AverageBasketPayoff__SWIG_0")]
  public static extern IntPtr new_AverageBasketPayoff__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_AverageBasketPayoff__SWIG_1")]
  public static extern IntPtr new_AverageBasketPayoff__SWIG_1(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_AverageBasketPayoff")]
  public static extern void delete_AverageBasketPayoff(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BasketOption__SWIG_0")]
  public static extern IntPtr new_BasketOption__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BasketOption__SWIG_1")]
  public static extern IntPtr new_BasketOption__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BasketOption")]
  public static extern void delete_BasketOption(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MCBasketEngine")]
  public static extern IntPtr new_MCBasketEngine(string jarg1, uint jarg2, bool jarg3, bool jarg4, bool jarg5, int jarg6, double jarg7, int jarg8, int jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MCBasketEngine")]
  public static extern void delete_MCBasketEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MCAmericanBasketEngine")]
  public static extern IntPtr new_MCAmericanBasketEngine(string jarg1, uint jarg2, uint jarg3, bool jarg4, bool jarg5, bool jarg6, int jarg7, double jarg8, int jarg9, int jarg10);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MCAmericanBasketEngine")]
  public static extern void delete_MCAmericanBasketEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_StulzEngine")]
  public static extern IntPtr new_StulzEngine();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_StulzEngine")]
  public static extern void delete_StulzEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RealTimeSeries__SWIG_0")]
  public static extern IntPtr new_RealTimeSeries__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RealTimeSeries__SWIG_1")]
  public static extern IntPtr new_RealTimeSeries__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RealTimeSeries_dates")]
  public static extern IntPtr RealTimeSeries_dates(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RealTimeSeries_values")]
  public static extern IntPtr RealTimeSeries_values(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RealTimeSeries_size")]
  public static extern uint RealTimeSeries_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_RealTimeSeries")]
  public static extern void delete_RealTimeSeries(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IntervalPriceTimeSeries__SWIG_0")]
  public static extern IntPtr new_IntervalPriceTimeSeries__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IntervalPriceTimeSeries__SWIG_1")]
  public static extern IntPtr new_IntervalPriceTimeSeries__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceTimeSeries_dates")]
  public static extern IntPtr IntervalPriceTimeSeries_dates(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceTimeSeries_values")]
  public static extern IntPtr IntervalPriceTimeSeries_values(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceTimeSeries_size")]
  public static extern uint IntervalPriceTimeSeries_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_IntervalPriceTimeSeries")]
  public static extern void delete_IntervalPriceTimeSeries(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_Clear")]
  public static extern void IntervalPriceVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_Add")]
  public static extern void IntervalPriceVector_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_size")]
  public static extern uint IntervalPriceVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_capacity")]
  public static extern uint IntervalPriceVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_reserve")]
  public static extern void IntervalPriceVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IntervalPriceVector__SWIG_0")]
  public static extern IntPtr new_IntervalPriceVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IntervalPriceVector__SWIG_1")]
  public static extern IntPtr new_IntervalPriceVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_getitemcopy")]
  public static extern IntPtr IntervalPriceVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_getitem")]
  public static extern IntPtr IntervalPriceVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_setitem")]
  public static extern void IntervalPriceVector_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_AddRange")]
  public static extern void IntervalPriceVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_GetRange")]
  public static extern IntPtr IntervalPriceVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_Insert")]
  public static extern void IntervalPriceVector_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_InsertRange")]
  public static extern void IntervalPriceVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_RemoveAt")]
  public static extern void IntervalPriceVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_RemoveRange")]
  public static extern void IntervalPriceVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_Repeat")]
  public static extern IntPtr IntervalPriceVector_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_Reverse__SWIG_0")]
  public static extern void IntervalPriceVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_Reverse__SWIG_1")]
  public static extern void IntervalPriceVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPriceVector_SetRange")]
  public static extern void IntervalPriceVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_IntervalPriceVector")]
  public static extern void delete_IntervalPriceVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IntervalPrice")]
  public static extern IntPtr new_IntervalPrice(double jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPrice_setValue")]
  public static extern void IntervalPrice_setValue(HandleRef jarg1, double jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPrice_setValues")]
  public static extern void IntervalPrice_setValues(HandleRef jarg1, double jarg2, double jarg3, double jarg4, double jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPrice_value")]
  public static extern double IntervalPrice_value(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPrice_open")]
  public static extern double IntervalPrice_open(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPrice_close")]
  public static extern double IntervalPrice_close(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPrice_high")]
  public static extern double IntervalPrice_high(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPrice_low")]
  public static extern double IntervalPrice_low(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPrice_makeSeries")]
  public static extern IntPtr IntervalPrice_makeSeries(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPrice_extractValues")]
  public static extern IntPtr IntervalPrice_extractValues(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntervalPrice_extractComponent")]
  public static extern IntPtr IntervalPrice_extractComponent(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_IntervalPrice")]
  public static extern void delete_IntervalPrice(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_Clear")]
  public static extern void IntVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_Add")]
  public static extern void IntVector_Add(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_size")]
  public static extern uint IntVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_capacity")]
  public static extern uint IntVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_reserve")]
  public static extern void IntVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IntVector__SWIG_0")]
  public static extern IntPtr new_IntVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IntVector__SWIG_1")]
  public static extern IntPtr new_IntVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_getitemcopy")]
  public static extern int IntVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_getitem")]
  public static extern int IntVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_setitem")]
  public static extern void IntVector_setitem(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_AddRange")]
  public static extern void IntVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_GetRange")]
  public static extern IntPtr IntVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_Insert")]
  public static extern void IntVector_Insert(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_InsertRange")]
  public static extern void IntVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_RemoveAt")]
  public static extern void IntVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_RemoveRange")]
  public static extern void IntVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_Repeat")]
  public static extern IntPtr IntVector_Repeat(int jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_Reverse__SWIG_0")]
  public static extern void IntVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_Reverse__SWIG_1")]
  public static extern void IntVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_SetRange")]
  public static extern void IntVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_Contains")]
  public static extern bool IntVector_Contains(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_IndexOf")]
  public static extern int IntVector_IndexOf(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_LastIndexOf")]
  public static extern int IntVector_LastIndexOf(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntVector_Remove")]
  public static extern void IntVector_Remove(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_IntVector")]
  public static extern void delete_IntVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_Clear")]
  public static extern void DoubleVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_Add")]
  public static extern void DoubleVector_Add(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_size")]
  public static extern uint DoubleVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_capacity")]
  public static extern uint DoubleVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_reserve")]
  public static extern void DoubleVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DoubleVector__SWIG_0")]
  public static extern IntPtr new_DoubleVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DoubleVector__SWIG_1")]
  public static extern IntPtr new_DoubleVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_getitemcopy")]
  public static extern double DoubleVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_getitem")]
  public static extern double DoubleVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_setitem")]
  public static extern void DoubleVector_setitem(HandleRef jarg1, int jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_AddRange")]
  public static extern void DoubleVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_GetRange")]
  public static extern IntPtr DoubleVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_Insert")]
  public static extern void DoubleVector_Insert(HandleRef jarg1, int jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_InsertRange")]
  public static extern void DoubleVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_RemoveAt")]
  public static extern void DoubleVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_RemoveRange")]
  public static extern void DoubleVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_Repeat")]
  public static extern IntPtr DoubleVector_Repeat(double jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_Reverse__SWIG_0")]
  public static extern void DoubleVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_Reverse__SWIG_1")]
  public static extern void DoubleVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_SetRange")]
  public static extern void DoubleVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_Contains")]
  public static extern bool DoubleVector_Contains(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_IndexOf")]
  public static extern int DoubleVector_IndexOf(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_LastIndexOf")]
  public static extern int DoubleVector_LastIndexOf(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DoubleVector_Remove")]
  public static extern void DoubleVector_Remove(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DoubleVector")]
  public static extern void delete_DoubleVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_Clear")]
  public static extern void StrVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_Add")]
  public static extern void StrVector_Add(HandleRef jarg1, string jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_size")]
  public static extern uint StrVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_capacity")]
  public static extern uint StrVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_reserve")]
  public static extern void StrVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_StrVector__SWIG_0")]
  public static extern IntPtr new_StrVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_StrVector__SWIG_1")]
  public static extern IntPtr new_StrVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_getitemcopy")]
  public static extern string StrVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_getitem")]
  public static extern string StrVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_setitem")]
  public static extern void StrVector_setitem(HandleRef jarg1, int jarg2, string jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_AddRange")]
  public static extern void StrVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_GetRange")]
  public static extern IntPtr StrVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_Insert")]
  public static extern void StrVector_Insert(HandleRef jarg1, int jarg2, string jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_InsertRange")]
  public static extern void StrVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_RemoveAt")]
  public static extern void StrVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_RemoveRange")]
  public static extern void StrVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_Repeat")]
  public static extern IntPtr StrVector_Repeat(string jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_Reverse__SWIG_0")]
  public static extern void StrVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_Reverse__SWIG_1")]
  public static extern void StrVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_SetRange")]
  public static extern void StrVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_Contains")]
  public static extern bool StrVector_Contains(HandleRef jarg1, string jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_IndexOf")]
  public static extern int StrVector_IndexOf(HandleRef jarg1, string jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_LastIndexOf")]
  public static extern int StrVector_LastIndexOf(HandleRef jarg1, string jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StrVector_Remove")]
  public static extern void StrVector_Remove(HandleRef jarg1, string jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_StrVector")]
  public static extern void delete_StrVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NodePair__SWIG_0")]
  public static extern IntPtr new_NodePair__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NodePair__SWIG_1")]
  public static extern IntPtr new_NodePair__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NodePair__SWIG_2")]
  public static extern IntPtr new_NodePair__SWIG_2(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodePair_first_set")]
  public static extern void NodePair_first_set(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodePair_first_get")]
  public static extern IntPtr NodePair_first_get(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodePair_second_set")]
  public static extern void NodePair_second_set(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodePair_second_get")]
  public static extern double NodePair_second_get(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_NodePair")]
  public static extern void delete_NodePair(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_Clear")]
  public static extern void NodeVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_Add")]
  public static extern void NodeVector_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_size")]
  public static extern uint NodeVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_capacity")]
  public static extern uint NodeVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_reserve")]
  public static extern void NodeVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NodeVector__SWIG_0")]
  public static extern IntPtr new_NodeVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NodeVector__SWIG_1")]
  public static extern IntPtr new_NodeVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_getitemcopy")]
  public static extern IntPtr NodeVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_getitem")]
  public static extern IntPtr NodeVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_setitem")]
  public static extern void NodeVector_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_AddRange")]
  public static extern void NodeVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_GetRange")]
  public static extern IntPtr NodeVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_Insert")]
  public static extern void NodeVector_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_InsertRange")]
  public static extern void NodeVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_RemoveAt")]
  public static extern void NodeVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_RemoveRange")]
  public static extern void NodeVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_Repeat")]
  public static extern IntPtr NodeVector_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_Reverse__SWIG_0")]
  public static extern void NodeVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_Reverse__SWIG_1")]
  public static extern void NodeVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_SetRange")]
  public static extern void NodeVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_Contains")]
  public static extern bool NodeVector_Contains(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_IndexOf")]
  public static extern int NodeVector_IndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_LastIndexOf")]
  public static extern int NodeVector_LastIndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NodeVector_Remove")]
  public static extern void NodeVector_Remove(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_NodeVector")]
  public static extern void delete_NodeVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IndexManager_instance")]
  public static extern IntPtr IndexManager_instance();

  [DllImport("NQuantLibc", EntryPoint="CSharp_IndexManager_setHistory")]
  public static extern void IndexManager_setHistory(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IndexManager_getHistory")]
  public static extern IntPtr IndexManager_getHistory(HandleRef jarg1, string jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IndexManager_hasHistory")]
  public static extern bool IndexManager_hasHistory(HandleRef jarg1, string jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IndexManager_histories")]
  public static extern IntPtr IndexManager_histories(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_IndexManager")]
  public static extern void delete_IndexManager(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Index___deref__")]
  public static extern IntPtr Index___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Index_isNull")]
  public static extern bool Index_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Index_addFixings")]
  public static extern void Index_addFixings(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Index___str__")]
  public static extern string Index___str__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Index_asObservable")]
  public static extern IntPtr Index_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Index")]
  public static extern IntPtr new_Index();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Index")]
  public static extern void delete_Index(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Index_name")]
  public static extern string Index_name(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Index_fixingCalendar")]
  public static extern IntPtr Index_fixingCalendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Index_isValidFixingDate")]
  public static extern bool Index_isValidFixingDate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Index_fixing__SWIG_0")]
  public static extern double Index_fixing__SWIG_0(HandleRef jarg1, HandleRef jarg2, bool jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Index_fixing__SWIG_1")]
  public static extern double Index_fixing__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Index_addFixing")]
  public static extern void Index_addFixing(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRateIndex_familyName")]
  public static extern string InterestRateIndex_familyName(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRateIndex_tenor")]
  public static extern IntPtr InterestRateIndex_tenor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRateIndex_fixingDays")]
  public static extern uint InterestRateIndex_fixingDays(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRateIndex_fixingDate")]
  public static extern IntPtr InterestRateIndex_fixingDate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRateIndex_currency")]
  public static extern IntPtr InterestRateIndex_currency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRateIndex_dayCounter")]
  public static extern IntPtr InterestRateIndex_dayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRateIndex_forecastFixing")]
  public static extern double InterestRateIndex_forecastFixing(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRateIndex_termStructure")]
  public static extern IntPtr InterestRateIndex_termStructure(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRateIndex_maturityDate")]
  public static extern IntPtr InterestRateIndex_maturityDate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRateIndex_valueDate")]
  public static extern IntPtr InterestRateIndex_valueDate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_InterestRateIndex")]
  public static extern void delete_InterestRateIndex(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IborIndex__SWIG_0")]
  public static extern IntPtr new_IborIndex__SWIG_0(string jarg1, HandleRef jarg2, int jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6, bool jarg7, HandleRef jarg8, HandleRef jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IborIndex__SWIG_1")]
  public static extern IntPtr new_IborIndex__SWIG_1(string jarg1, HandleRef jarg2, int jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6, bool jarg7, HandleRef jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IborIndex_businessDayConvention")]
  public static extern int IborIndex_businessDayConvention(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IborIndex_endOfMonth")]
  public static extern bool IborIndex_endOfMonth(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_IborIndex")]
  public static extern void delete_IborIndex(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SwapIndex")]
  public static extern IntPtr new_SwapIndex(string jarg1, HandleRef jarg2, int jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, int jarg7, HandleRef jarg8, HandleRef jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwapIndex_fixedLegTenor")]
  public static extern IntPtr SwapIndex_fixedLegTenor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwapIndex_fixedLegConvention")]
  public static extern int SwapIndex_fixedLegConvention(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwapIndex_iborIndex")]
  public static extern IntPtr SwapIndex_iborIndex(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SwapIndex")]
  public static extern void delete_SwapIndex(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_AUDLibor__SWIG_0")]
  public static extern IntPtr new_AUDLibor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_AUDLibor__SWIG_1")]
  public static extern IntPtr new_AUDLibor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_AUDLibor")]
  public static extern void delete_AUDLibor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CADLibor__SWIG_0")]
  public static extern IntPtr new_CADLibor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CADLibor__SWIG_1")]
  public static extern IntPtr new_CADLibor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CADLibor")]
  public static extern void delete_CADLibor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Cdor__SWIG_0")]
  public static extern IntPtr new_Cdor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Cdor__SWIG_1")]
  public static extern IntPtr new_Cdor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Cdor")]
  public static extern void delete_Cdor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CHFLibor__SWIG_0")]
  public static extern IntPtr new_CHFLibor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CHFLibor__SWIG_1")]
  public static extern IntPtr new_CHFLibor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CHFLibor")]
  public static extern void delete_CHFLibor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DKKLibor__SWIG_0")]
  public static extern IntPtr new_DKKLibor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DKKLibor__SWIG_1")]
  public static extern IntPtr new_DKKLibor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DKKLibor")]
  public static extern void delete_DKKLibor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor__SWIG_0")]
  public static extern IntPtr new_Euribor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor__SWIG_1")]
  public static extern IntPtr new_Euribor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor")]
  public static extern void delete_Euribor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSW__SWIG_0")]
  public static extern IntPtr new_EuriborSW__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSW__SWIG_1")]
  public static extern IntPtr new_EuriborSW__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSW")]
  public static extern void delete_EuriborSW(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor2W__SWIG_0")]
  public static extern IntPtr new_Euribor2W__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor2W__SWIG_1")]
  public static extern IntPtr new_Euribor2W__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor2W")]
  public static extern void delete_Euribor2W(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor3W__SWIG_0")]
  public static extern IntPtr new_Euribor3W__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor3W__SWIG_1")]
  public static extern IntPtr new_Euribor3W__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor3W")]
  public static extern void delete_Euribor3W(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor1M__SWIG_0")]
  public static extern IntPtr new_Euribor1M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor1M__SWIG_1")]
  public static extern IntPtr new_Euribor1M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor1M")]
  public static extern void delete_Euribor1M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor2M__SWIG_0")]
  public static extern IntPtr new_Euribor2M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor2M__SWIG_1")]
  public static extern IntPtr new_Euribor2M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor2M")]
  public static extern void delete_Euribor2M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor3M__SWIG_0")]
  public static extern IntPtr new_Euribor3M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor3M__SWIG_1")]
  public static extern IntPtr new_Euribor3M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor3M")]
  public static extern void delete_Euribor3M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor4M__SWIG_0")]
  public static extern IntPtr new_Euribor4M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor4M__SWIG_1")]
  public static extern IntPtr new_Euribor4M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor4M")]
  public static extern void delete_Euribor4M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor5M__SWIG_0")]
  public static extern IntPtr new_Euribor5M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor5M__SWIG_1")]
  public static extern IntPtr new_Euribor5M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor5M")]
  public static extern void delete_Euribor5M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor6M__SWIG_0")]
  public static extern IntPtr new_Euribor6M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor6M__SWIG_1")]
  public static extern IntPtr new_Euribor6M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor6M")]
  public static extern void delete_Euribor6M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor7M__SWIG_0")]
  public static extern IntPtr new_Euribor7M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor7M__SWIG_1")]
  public static extern IntPtr new_Euribor7M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor7M")]
  public static extern void delete_Euribor7M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor8M__SWIG_0")]
  public static extern IntPtr new_Euribor8M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor8M__SWIG_1")]
  public static extern IntPtr new_Euribor8M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor8M")]
  public static extern void delete_Euribor8M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor9M__SWIG_0")]
  public static extern IntPtr new_Euribor9M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor9M__SWIG_1")]
  public static extern IntPtr new_Euribor9M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor9M")]
  public static extern void delete_Euribor9M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor10M__SWIG_0")]
  public static extern IntPtr new_Euribor10M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor10M__SWIG_1")]
  public static extern IntPtr new_Euribor10M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor10M")]
  public static extern void delete_Euribor10M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor11M__SWIG_0")]
  public static extern IntPtr new_Euribor11M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor11M__SWIG_1")]
  public static extern IntPtr new_Euribor11M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor11M")]
  public static extern void delete_Euribor11M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor1Y__SWIG_0")]
  public static extern IntPtr new_Euribor1Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor1Y__SWIG_1")]
  public static extern IntPtr new_Euribor1Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor1Y")]
  public static extern void delete_Euribor1Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365__SWIG_0")]
  public static extern IntPtr new_Euribor365__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365__SWIG_1")]
  public static extern IntPtr new_Euribor365__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365")]
  public static extern void delete_Euribor365(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_SW__SWIG_0")]
  public static extern IntPtr new_Euribor365_SW__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_SW__SWIG_1")]
  public static extern IntPtr new_Euribor365_SW__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_SW")]
  public static extern void delete_Euribor365_SW(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_2W__SWIG_0")]
  public static extern IntPtr new_Euribor365_2W__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_2W__SWIG_1")]
  public static extern IntPtr new_Euribor365_2W__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_2W")]
  public static extern void delete_Euribor365_2W(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_3W__SWIG_0")]
  public static extern IntPtr new_Euribor365_3W__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_3W__SWIG_1")]
  public static extern IntPtr new_Euribor365_3W__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_3W")]
  public static extern void delete_Euribor365_3W(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_1M__SWIG_0")]
  public static extern IntPtr new_Euribor365_1M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_1M__SWIG_1")]
  public static extern IntPtr new_Euribor365_1M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_1M")]
  public static extern void delete_Euribor365_1M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_2M__SWIG_0")]
  public static extern IntPtr new_Euribor365_2M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_2M__SWIG_1")]
  public static extern IntPtr new_Euribor365_2M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_2M")]
  public static extern void delete_Euribor365_2M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_3M__SWIG_0")]
  public static extern IntPtr new_Euribor365_3M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_3M__SWIG_1")]
  public static extern IntPtr new_Euribor365_3M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_3M")]
  public static extern void delete_Euribor365_3M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_4M__SWIG_0")]
  public static extern IntPtr new_Euribor365_4M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_4M__SWIG_1")]
  public static extern IntPtr new_Euribor365_4M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_4M")]
  public static extern void delete_Euribor365_4M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_5M__SWIG_0")]
  public static extern IntPtr new_Euribor365_5M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_5M__SWIG_1")]
  public static extern IntPtr new_Euribor365_5M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_5M")]
  public static extern void delete_Euribor365_5M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_6M__SWIG_0")]
  public static extern IntPtr new_Euribor365_6M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_6M__SWIG_1")]
  public static extern IntPtr new_Euribor365_6M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_6M")]
  public static extern void delete_Euribor365_6M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_7M__SWIG_0")]
  public static extern IntPtr new_Euribor365_7M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_7M__SWIG_1")]
  public static extern IntPtr new_Euribor365_7M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_7M")]
  public static extern void delete_Euribor365_7M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_8M__SWIG_0")]
  public static extern IntPtr new_Euribor365_8M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_8M__SWIG_1")]
  public static extern IntPtr new_Euribor365_8M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_8M")]
  public static extern void delete_Euribor365_8M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_9M__SWIG_0")]
  public static extern IntPtr new_Euribor365_9M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_9M__SWIG_1")]
  public static extern IntPtr new_Euribor365_9M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_9M")]
  public static extern void delete_Euribor365_9M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_10M__SWIG_0")]
  public static extern IntPtr new_Euribor365_10M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_10M__SWIG_1")]
  public static extern IntPtr new_Euribor365_10M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_10M")]
  public static extern void delete_Euribor365_10M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_11M__SWIG_0")]
  public static extern IntPtr new_Euribor365_11M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_11M__SWIG_1")]
  public static extern IntPtr new_Euribor365_11M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_11M")]
  public static extern void delete_Euribor365_11M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_1Y__SWIG_0")]
  public static extern IntPtr new_Euribor365_1Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Euribor365_1Y__SWIG_1")]
  public static extern IntPtr new_Euribor365_1Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Euribor365_1Y")]
  public static extern void delete_Euribor365_1Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor__SWIG_0")]
  public static extern IntPtr new_EURLibor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor__SWIG_1")]
  public static extern IntPtr new_EURLibor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor")]
  public static extern void delete_EURLibor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLiborSW__SWIG_0")]
  public static extern IntPtr new_EURLiborSW__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLiborSW__SWIG_1")]
  public static extern IntPtr new_EURLiborSW__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLiborSW")]
  public static extern void delete_EURLiborSW(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor2W__SWIG_0")]
  public static extern IntPtr new_EURLibor2W__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor2W__SWIG_1")]
  public static extern IntPtr new_EURLibor2W__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor2W")]
  public static extern void delete_EURLibor2W(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor1M__SWIG_0")]
  public static extern IntPtr new_EURLibor1M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor1M__SWIG_1")]
  public static extern IntPtr new_EURLibor1M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor1M")]
  public static extern void delete_EURLibor1M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor2M__SWIG_0")]
  public static extern IntPtr new_EURLibor2M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor2M__SWIG_1")]
  public static extern IntPtr new_EURLibor2M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor2M")]
  public static extern void delete_EURLibor2M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor3M__SWIG_0")]
  public static extern IntPtr new_EURLibor3M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor3M__SWIG_1")]
  public static extern IntPtr new_EURLibor3M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor3M")]
  public static extern void delete_EURLibor3M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor4M__SWIG_0")]
  public static extern IntPtr new_EURLibor4M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor4M__SWIG_1")]
  public static extern IntPtr new_EURLibor4M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor4M")]
  public static extern void delete_EURLibor4M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor5M__SWIG_0")]
  public static extern IntPtr new_EURLibor5M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor5M__SWIG_1")]
  public static extern IntPtr new_EURLibor5M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor5M")]
  public static extern void delete_EURLibor5M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor6M__SWIG_0")]
  public static extern IntPtr new_EURLibor6M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor6M__SWIG_1")]
  public static extern IntPtr new_EURLibor6M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor6M")]
  public static extern void delete_EURLibor6M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor7M__SWIG_0")]
  public static extern IntPtr new_EURLibor7M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor7M__SWIG_1")]
  public static extern IntPtr new_EURLibor7M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor7M")]
  public static extern void delete_EURLibor7M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor8M__SWIG_0")]
  public static extern IntPtr new_EURLibor8M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor8M__SWIG_1")]
  public static extern IntPtr new_EURLibor8M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor8M")]
  public static extern void delete_EURLibor8M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor9M__SWIG_0")]
  public static extern IntPtr new_EURLibor9M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor9M__SWIG_1")]
  public static extern IntPtr new_EURLibor9M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor9M")]
  public static extern void delete_EURLibor9M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor10M__SWIG_0")]
  public static extern IntPtr new_EURLibor10M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor10M__SWIG_1")]
  public static extern IntPtr new_EURLibor10M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor10M")]
  public static extern void delete_EURLibor10M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor11M__SWIG_0")]
  public static extern IntPtr new_EURLibor11M__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor11M__SWIG_1")]
  public static extern IntPtr new_EURLibor11M__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor11M")]
  public static extern void delete_EURLibor11M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor1Y__SWIG_0")]
  public static extern IntPtr new_EURLibor1Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EURLibor1Y__SWIG_1")]
  public static extern IntPtr new_EURLibor1Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EURLibor1Y")]
  public static extern void delete_EURLibor1Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GBPLibor__SWIG_0")]
  public static extern IntPtr new_GBPLibor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GBPLibor__SWIG_1")]
  public static extern IntPtr new_GBPLibor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GBPLibor")]
  public static extern void delete_GBPLibor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Jibar__SWIG_0")]
  public static extern IntPtr new_Jibar__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Jibar__SWIG_1")]
  public static extern IntPtr new_Jibar__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Jibar")]
  public static extern void delete_Jibar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_JPYLibor__SWIG_0")]
  public static extern IntPtr new_JPYLibor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_JPYLibor__SWIG_1")]
  public static extern IntPtr new_JPYLibor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_JPYLibor")]
  public static extern void delete_JPYLibor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NZDLibor__SWIG_0")]
  public static extern IntPtr new_NZDLibor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NZDLibor__SWIG_1")]
  public static extern IntPtr new_NZDLibor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_NZDLibor")]
  public static extern void delete_NZDLibor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Tibor__SWIG_0")]
  public static extern IntPtr new_Tibor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Tibor__SWIG_1")]
  public static extern IntPtr new_Tibor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Tibor")]
  public static extern void delete_Tibor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TRLibor__SWIG_0")]
  public static extern IntPtr new_TRLibor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TRLibor__SWIG_1")]
  public static extern IntPtr new_TRLibor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_TRLibor")]
  public static extern void delete_TRLibor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_USDLibor__SWIG_0")]
  public static extern IntPtr new_USDLibor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_USDLibor__SWIG_1")]
  public static extern IntPtr new_USDLibor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_USDLibor")]
  public static extern void delete_USDLibor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Zibor__SWIG_0")]
  public static extern IntPtr new_Zibor__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Zibor__SWIG_1")]
  public static extern IntPtr new_Zibor__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Zibor")]
  public static extern void delete_Zibor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixAvs3M__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixAvs3M__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixAvs3M__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixAvs3M__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixAvs3M")]
  public static extern void delete_EuriborSwapFixAvs3M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixAvs6M__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixAvs6M__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixAvs6M__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixAvs6M__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixAvs6M")]
  public static extern void delete_EuriborSwapFixAvs6M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA1Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA1Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA1Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA1Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA1Y")]
  public static extern void delete_EuriborSwapFixA1Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA2Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA2Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA2Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA2Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA2Y")]
  public static extern void delete_EuriborSwapFixA2Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA3Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA3Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA3Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA3Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA3Y")]
  public static extern void delete_EuriborSwapFixA3Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA4Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA4Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA4Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA4Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA4Y")]
  public static extern void delete_EuriborSwapFixA4Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA5Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA5Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA5Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA5Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA5Y")]
  public static extern void delete_EuriborSwapFixA5Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA6Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA6Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA6Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA6Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA6Y")]
  public static extern void delete_EuriborSwapFixA6Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA7Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA7Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA7Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA7Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA7Y")]
  public static extern void delete_EuriborSwapFixA7Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA8Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA8Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA8Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA8Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA8Y")]
  public static extern void delete_EuriborSwapFixA8Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA9Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA9Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA9Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA9Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA9Y")]
  public static extern void delete_EuriborSwapFixA9Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA10Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA10Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA10Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA10Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA10Y")]
  public static extern void delete_EuriborSwapFixA10Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA12Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA12Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA12Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA12Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA12Y")]
  public static extern void delete_EuriborSwapFixA12Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA15Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA15Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA15Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA15Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA15Y")]
  public static extern void delete_EuriborSwapFixA15Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA20Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA20Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA20Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA20Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA20Y")]
  public static extern void delete_EuriborSwapFixA20Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA25Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA25Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA25Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA25Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA25Y")]
  public static extern void delete_EuriborSwapFixA25Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA30Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixA30Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixA30Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixA30Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixA30Y")]
  public static extern void delete_EuriborSwapFixA30Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFRvs3M__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFRvs3M__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFRvs3M__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFRvs3M__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFRvs3M")]
  public static extern void delete_EuriborSwapFixIFRvs3M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFRvs6M__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFRvs6M__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFRvs6M__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFRvs6M__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFRvs6M")]
  public static extern void delete_EuriborSwapFixIFRvs6M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR1Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR1Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR1Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR1Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR1Y")]
  public static extern void delete_EuriborSwapFixIFR1Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR2Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR2Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR2Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR2Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR2Y")]
  public static extern void delete_EuriborSwapFixIFR2Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR3Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR3Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR3Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR3Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR3Y")]
  public static extern void delete_EuriborSwapFixIFR3Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR4Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR4Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR4Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR4Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR4Y")]
  public static extern void delete_EuriborSwapFixIFR4Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR5Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR5Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR5Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR5Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR5Y")]
  public static extern void delete_EuriborSwapFixIFR5Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR6Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR6Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR6Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR6Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR6Y")]
  public static extern void delete_EuriborSwapFixIFR6Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR7Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR7Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR7Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR7Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR7Y")]
  public static extern void delete_EuriborSwapFixIFR7Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR8Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR8Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR8Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR8Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR8Y")]
  public static extern void delete_EuriborSwapFixIFR8Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR9Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR9Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR9Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR9Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR9Y")]
  public static extern void delete_EuriborSwapFixIFR9Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR10Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR10Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR10Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR10Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR10Y")]
  public static extern void delete_EuriborSwapFixIFR10Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR12Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR12Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR12Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR12Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR12Y")]
  public static extern void delete_EuriborSwapFixIFR12Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR15Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR15Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR15Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR15Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR15Y")]
  public static extern void delete_EuriborSwapFixIFR15Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR20Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR20Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR20Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR20Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR20Y")]
  public static extern void delete_EuriborSwapFixIFR20Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR25Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR25Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR25Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR25Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR25Y")]
  public static extern void delete_EuriborSwapFixIFR25Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR30Y__SWIG_0")]
  public static extern IntPtr new_EuriborSwapFixIFR30Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EuriborSwapFixIFR30Y__SWIG_1")]
  public static extern IntPtr new_EuriborSwapFixIFR30Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EuriborSwapFixIFR30Y")]
  public static extern void delete_EuriborSwapFixIFR30Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixAvs3M__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixAvs3M__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixAvs3M__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixAvs3M__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixAvs3M")]
  public static extern void delete_EurliborSwapFixAvs3M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixAvs6M__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixAvs6M__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixAvs6M__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixAvs6M__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixAvs6M")]
  public static extern void delete_EurliborSwapFixAvs6M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA1Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA1Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA1Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA1Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA1Y")]
  public static extern void delete_EurliborSwapFixA1Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA2Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA2Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA2Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA2Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA2Y")]
  public static extern void delete_EurliborSwapFixA2Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA3Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA3Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA3Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA3Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA3Y")]
  public static extern void delete_EurliborSwapFixA3Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA4Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA4Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA4Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA4Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA4Y")]
  public static extern void delete_EurliborSwapFixA4Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA5Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA5Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA5Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA5Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA5Y")]
  public static extern void delete_EurliborSwapFixA5Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA6Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA6Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA6Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA6Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA6Y")]
  public static extern void delete_EurliborSwapFixA6Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA7Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA7Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA7Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA7Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA7Y")]
  public static extern void delete_EurliborSwapFixA7Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA8Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA8Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA8Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA8Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA8Y")]
  public static extern void delete_EurliborSwapFixA8Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA9Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA9Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA9Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA9Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA9Y")]
  public static extern void delete_EurliborSwapFixA9Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA10Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA10Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA10Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA10Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA10Y")]
  public static extern void delete_EurliborSwapFixA10Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA12Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA12Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA12Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA12Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA12Y")]
  public static extern void delete_EurliborSwapFixA12Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA15Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA15Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA15Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA15Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA15Y")]
  public static extern void delete_EurliborSwapFixA15Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA20Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA20Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA20Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA20Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA20Y")]
  public static extern void delete_EurliborSwapFixA20Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA25Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA25Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA25Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA25Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA25Y")]
  public static extern void delete_EurliborSwapFixA25Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA30Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixA30Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixA30Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixA30Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixA30Y")]
  public static extern void delete_EurliborSwapFixA30Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixBvs3M__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixBvs3M__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixBvs3M__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixBvs3M__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixBvs3M")]
  public static extern void delete_EurliborSwapFixBvs3M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixBvs6M__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixBvs6M__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixBvs6M__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixBvs6M__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixBvs6M")]
  public static extern void delete_EurliborSwapFixBvs6M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB1Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB1Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB1Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB1Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB1Y")]
  public static extern void delete_EurliborSwapFixB1Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB2Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB2Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB2Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB2Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB2Y")]
  public static extern void delete_EurliborSwapFixB2Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB3Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB3Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB3Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB3Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB3Y")]
  public static extern void delete_EurliborSwapFixB3Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB4Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB4Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB4Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB4Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB4Y")]
  public static extern void delete_EurliborSwapFixB4Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB5Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB5Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB5Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB5Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB5Y")]
  public static extern void delete_EurliborSwapFixB5Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB6Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB6Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB6Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB6Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB6Y")]
  public static extern void delete_EurliborSwapFixB6Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB7Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB7Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB7Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB7Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB7Y")]
  public static extern void delete_EurliborSwapFixB7Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB8Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB8Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB8Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB8Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB8Y")]
  public static extern void delete_EurliborSwapFixB8Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB9Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB9Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB9Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB9Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB9Y")]
  public static extern void delete_EurliborSwapFixB9Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB10Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB10Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB10Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB10Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB10Y")]
  public static extern void delete_EurliborSwapFixB10Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB12Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB12Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB12Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB12Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB12Y")]
  public static extern void delete_EurliborSwapFixB12Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB15Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB15Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB15Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB15Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB15Y")]
  public static extern void delete_EurliborSwapFixB15Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB20Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB20Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB20Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB20Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB20Y")]
  public static extern void delete_EurliborSwapFixB20Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB25Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB25Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB25Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB25Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB25Y")]
  public static extern void delete_EurliborSwapFixB25Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB30Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixB30Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixB30Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixB30Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixB30Y")]
  public static extern void delete_EurliborSwapFixB30Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFRvs3M__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFRvs3M__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFRvs3M__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFRvs3M__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFRvs3M")]
  public static extern void delete_EurliborSwapFixIFRvs3M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFRvs6M__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFRvs6M__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFRvs6M__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFRvs6M__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFRvs6M")]
  public static extern void delete_EurliborSwapFixIFRvs6M(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR1Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR1Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR1Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR1Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR1Y")]
  public static extern void delete_EurliborSwapFixIFR1Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR2Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR2Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR2Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR2Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR2Y")]
  public static extern void delete_EurliborSwapFixIFR2Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR3Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR3Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR3Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR3Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR3Y")]
  public static extern void delete_EurliborSwapFixIFR3Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR4Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR4Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR4Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR4Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR4Y")]
  public static extern void delete_EurliborSwapFixIFR4Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR5Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR5Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR5Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR5Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR5Y")]
  public static extern void delete_EurliborSwapFixIFR5Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR6Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR6Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR6Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR6Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR6Y")]
  public static extern void delete_EurliborSwapFixIFR6Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR7Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR7Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR7Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR7Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR7Y")]
  public static extern void delete_EurliborSwapFixIFR7Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR8Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR8Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR8Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR8Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR8Y")]
  public static extern void delete_EurliborSwapFixIFR8Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR9Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR9Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR9Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR9Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR9Y")]
  public static extern void delete_EurliborSwapFixIFR9Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR10Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR10Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR10Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR10Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR10Y")]
  public static extern void delete_EurliborSwapFixIFR10Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR12Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR12Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR12Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR12Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR12Y")]
  public static extern void delete_EurliborSwapFixIFR12Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR15Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR15Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR15Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR15Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR15Y")]
  public static extern void delete_EurliborSwapFixIFR15Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR20Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR20Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR20Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR20Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR20Y")]
  public static extern void delete_EurliborSwapFixIFR20Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR25Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR25Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR25Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR25Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR25Y")]
  public static extern void delete_EurliborSwapFixIFR25Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR30Y__SWIG_0")]
  public static extern IntPtr new_EurliborSwapFixIFR30Y__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EurliborSwapFixIFR30Y__SWIG_1")]
  public static extern IntPtr new_EurliborSwapFixIFR30Y__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EurliborSwapFixIFR30Y")]
  public static extern void delete_EurliborSwapFixIFR30Y(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Schedule__SWIG_0")]
  public static extern IntPtr new_Schedule__SWIG_0(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Schedule__SWIG_1")]
  public static extern IntPtr new_Schedule__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6, bool jarg7, bool jarg8, HandleRef jarg9, HandleRef jarg10);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Schedule__SWIG_2")]
  public static extern IntPtr new_Schedule__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6, bool jarg7, bool jarg8, HandleRef jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Schedule__SWIG_3")]
  public static extern IntPtr new_Schedule__SWIG_3(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6, bool jarg7, bool jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Schedule_size")]
  public static extern uint Schedule_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Schedule_date")]
  public static extern IntPtr Schedule_date(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Schedule_isRegular")]
  public static extern bool Schedule_isRegular(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Schedule")]
  public static extern void delete_Schedule(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlow___deref__")]
  public static extern IntPtr CashFlow___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlow_isNull")]
  public static extern bool CashFlow_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlow_asObservable")]
  public static extern IntPtr CashFlow_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CashFlow")]
  public static extern IntPtr new_CashFlow();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CashFlow")]
  public static extern void delete_CashFlow(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlow_amount")]
  public static extern double CashFlow_amount(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlow_date")]
  public static extern IntPtr CashFlow_date(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SimpleCashFlow")]
  public static extern IntPtr new_SimpleCashFlow(double jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SimpleCashFlow")]
  public static extern void delete_SimpleCashFlow(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FixedRateCoupon__SWIG_0")]
  public static extern IntPtr new_FixedRateCoupon__SWIG_0(double jarg1, HandleRef jarg2, double jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FixedRateCoupon__SWIG_1")]
  public static extern IntPtr new_FixedRateCoupon__SWIG_1(double jarg1, HandleRef jarg2, double jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FixedRateCoupon__SWIG_2")]
  public static extern IntPtr new_FixedRateCoupon__SWIG_2(double jarg1, HandleRef jarg2, double jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FixedRateCoupon")]
  public static extern void delete_FixedRateCoupon(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IborCoupon__SWIG_0")]
  public static extern IntPtr new_IborCoupon__SWIG_0(HandleRef jarg1, double jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, HandleRef jarg6, double jarg7, double jarg8, HandleRef jarg9, HandleRef jarg10, HandleRef jarg11);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IborCoupon__SWIG_1")]
  public static extern IntPtr new_IborCoupon__SWIG_1(HandleRef jarg1, double jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, HandleRef jarg6, double jarg7, double jarg8, HandleRef jarg9, HandleRef jarg10);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IborCoupon__SWIG_2")]
  public static extern IntPtr new_IborCoupon__SWIG_2(HandleRef jarg1, double jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, HandleRef jarg6, double jarg7, double jarg8, HandleRef jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IborCoupon__SWIG_3")]
  public static extern IntPtr new_IborCoupon__SWIG_3(HandleRef jarg1, double jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, HandleRef jarg6, double jarg7, double jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IborCoupon__SWIG_4")]
  public static extern IntPtr new_IborCoupon__SWIG_4(HandleRef jarg1, double jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, HandleRef jarg6, double jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_IborCoupon__SWIG_5")]
  public static extern IntPtr new_IborCoupon__SWIG_5(HandleRef jarg1, double jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, HandleRef jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IborCoupon_rate")]
  public static extern double IborCoupon_rate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IborCoupon_indexFixing")]
  public static extern double IborCoupon_indexFixing(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IborCoupon_nominal")]
  public static extern double IborCoupon_nominal(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_IborCoupon")]
  public static extern void delete_IborCoupon(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FloatingRateCoupon_rate")]
  public static extern double FloatingRateCoupon_rate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FloatingRateCoupon_fixingDays")]
  public static extern int FloatingRateCoupon_fixingDays(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FloatingRateCoupon_spread")]
  public static extern double FloatingRateCoupon_spread(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FloatingRateCoupon_indexFixing")]
  public static extern double FloatingRateCoupon_indexFixing(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FloatingRateCoupon_fixingDate")]
  public static extern IntPtr FloatingRateCoupon_fixingDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FloatingRateCoupon")]
  public static extern IntPtr new_FloatingRateCoupon();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FloatingRateCoupon")]
  public static extern void delete_FloatingRateCoupon(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_Clear")]
  public static extern void Leg_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_Add")]
  public static extern void Leg_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_size")]
  public static extern uint Leg_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_capacity")]
  public static extern uint Leg_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_reserve")]
  public static extern void Leg_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Leg__SWIG_0")]
  public static extern IntPtr new_Leg__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Leg__SWIG_1")]
  public static extern IntPtr new_Leg__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_getitemcopy")]
  public static extern IntPtr Leg_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_getitem")]
  public static extern IntPtr Leg_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_setitem")]
  public static extern void Leg_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_AddRange")]
  public static extern void Leg_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_GetRange")]
  public static extern IntPtr Leg_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_Insert")]
  public static extern void Leg_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_InsertRange")]
  public static extern void Leg_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_RemoveAt")]
  public static extern void Leg_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_RemoveRange")]
  public static extern void Leg_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_Repeat")]
  public static extern IntPtr Leg_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_Reverse__SWIG_0")]
  public static extern void Leg_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_Reverse__SWIG_1")]
  public static extern void Leg_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_SetRange")]
  public static extern void Leg_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_Contains")]
  public static extern bool Leg_Contains(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_IndexOf")]
  public static extern int Leg_IndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_LastIndexOf")]
  public static extern int Leg_LastIndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Leg_Remove")]
  public static extern void Leg_Remove(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Leg")]
  public static extern void delete_Leg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FixedRateLeg__SWIG_0")]
  public static extern IntPtr FixedRateLeg__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, HandleRef jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FixedRateLeg__SWIG_1")]
  public static extern IntPtr FixedRateLeg__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FixedRateLeg__SWIG_2")]
  public static extern IntPtr FixedRateLeg__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IborLeg")]
  public static extern IntPtr IborLeg(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6, HandleRef jarg7, HandleRef jarg8, HandleRef jarg9, HandleRef jarg10, bool jarg11);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CmsLeg")]
  public static extern IntPtr CmsLeg(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6, HandleRef jarg7, HandleRef jarg8, HandleRef jarg9, HandleRef jarg10, bool jarg11);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CmsZeroLeg")]
  public static extern IntPtr CmsZeroLeg(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6, HandleRef jarg7, HandleRef jarg8, HandleRef jarg9, HandleRef jarg10);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Duration")]
  public static extern IntPtr new_Duration();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Duration")]
  public static extern void delete_Duration(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_startDate")]
  public static extern IntPtr CashFlows_startDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_maturityDate")]
  public static extern IntPtr CashFlows_maturityDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_npv__SWIG_0")]
  public static extern double CashFlows_npv__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_npv__SWIG_1")]
  public static extern double CashFlows_npv__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_npv__SWIG_2")]
  public static extern double CashFlows_npv__SWIG_2(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_bps__SWIG_0")]
  public static extern double CashFlows_bps__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_bps__SWIG_1")]
  public static extern double CashFlows_bps__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_bps__SWIG_2")]
  public static extern double CashFlows_bps__SWIG_2(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_atmRate__SWIG_0")]
  public static extern double CashFlows_atmRate__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, double jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_atmRate__SWIG_1")]
  public static extern double CashFlows_atmRate__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_atmRate__SWIG_2")]
  public static extern double CashFlows_atmRate__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_atmRate__SWIG_3")]
  public static extern double CashFlows_atmRate__SWIG_3(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_atmRate__SWIG_4")]
  public static extern double CashFlows_atmRate__SWIG_4(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_irr__SWIG_0")]
  public static extern double CashFlows_irr__SWIG_0(HandleRef jarg1, double jarg2, HandleRef jarg3, int jarg4, int jarg5, HandleRef jarg6, double jarg7, uint jarg8, double jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_irr__SWIG_1")]
  public static extern double CashFlows_irr__SWIG_1(HandleRef jarg1, double jarg2, HandleRef jarg3, int jarg4, int jarg5, HandleRef jarg6, double jarg7, uint jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_irr__SWIG_2")]
  public static extern double CashFlows_irr__SWIG_2(HandleRef jarg1, double jarg2, HandleRef jarg3, int jarg4, int jarg5, HandleRef jarg6, double jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_irr__SWIG_3")]
  public static extern double CashFlows_irr__SWIG_3(HandleRef jarg1, double jarg2, HandleRef jarg3, int jarg4, int jarg5, HandleRef jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_irr__SWIG_4")]
  public static extern double CashFlows_irr__SWIG_4(HandleRef jarg1, double jarg2, HandleRef jarg3, int jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_irr__SWIG_5")]
  public static extern double CashFlows_irr__SWIG_5(HandleRef jarg1, double jarg2, HandleRef jarg3, int jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_duration__SWIG_0")]
  public static extern double CashFlows_duration__SWIG_0(HandleRef jarg1, HandleRef jarg2, int jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_duration__SWIG_1")]
  public static extern double CashFlows_duration__SWIG_1(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_duration__SWIG_2")]
  public static extern double CashFlows_duration__SWIG_2(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_convexity__SWIG_0")]
  public static extern double CashFlows_convexity__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashFlows_convexity__SWIG_1")]
  public static extern double CashFlows_convexity__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CashFlows")]
  public static extern void delete_CashFlows(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_settlementDate")]
  public static extern IntPtr Bond_settlementDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_cashflows")]
  public static extern IntPtr Bond_cashflows(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_redemption")]
  public static extern IntPtr Bond_redemption(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_calendar")]
  public static extern IntPtr Bond_calendar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_paymentConvention")]
  public static extern int Bond_paymentConvention(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_dayCounter")]
  public static extern IntPtr Bond_dayCounter(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_frequency")]
  public static extern int Bond_frequency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_cleanPrice__SWIG_0")]
  public static extern double Bond_cleanPrice__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_cleanPrice__SWIG_1")]
  public static extern double Bond_cleanPrice__SWIG_1(HandleRef jarg1, double jarg2, int jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_cleanPrice__SWIG_2")]
  public static extern double Bond_cleanPrice__SWIG_2(HandleRef jarg1, double jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_dirtyPrice__SWIG_0")]
  public static extern double Bond_dirtyPrice__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_dirtyPrice__SWIG_1")]
  public static extern double Bond_dirtyPrice__SWIG_1(HandleRef jarg1, double jarg2, int jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_dirtyPrice__SWIG_2")]
  public static extern double Bond_dirtyPrice__SWIG_2(HandleRef jarg1, double jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_yield__SWIG_0")]
  public static extern double Bond_yield__SWIG_0(HandleRef jarg1, int jarg2, double jarg3, uint jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_yield__SWIG_1")]
  public static extern double Bond_yield__SWIG_1(HandleRef jarg1, int jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_yield__SWIG_2")]
  public static extern double Bond_yield__SWIG_2(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_yield__SWIG_3")]
  public static extern double Bond_yield__SWIG_3(HandleRef jarg1, double jarg2, int jarg3, HandleRef jarg4, double jarg5, uint jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_yield__SWIG_4")]
  public static extern double Bond_yield__SWIG_4(HandleRef jarg1, double jarg2, int jarg3, HandleRef jarg4, double jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_yield__SWIG_5")]
  public static extern double Bond_yield__SWIG_5(HandleRef jarg1, double jarg2, int jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_yield__SWIG_6")]
  public static extern double Bond_yield__SWIG_6(HandleRef jarg1, double jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_accruedAmount__SWIG_0")]
  public static extern double Bond_accruedAmount__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bond_accruedAmount__SWIG_1")]
  public static extern double Bond_accruedAmount__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Bond")]
  public static extern void delete_Bond(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ZeroCouponBond")]
  public static extern IntPtr new_ZeroCouponBond(int jarg1, double jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6, double jarg7, HandleRef jarg8, HandleRef jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ZeroCouponBond")]
  public static extern void delete_ZeroCouponBond(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FixedRateBond")]
  public static extern IntPtr new_FixedRateBond(int jarg1, double jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6, double jarg7, HandleRef jarg8, HandleRef jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FixedRateBond")]
  public static extern void delete_FixedRateBond(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FloatingRateBond")]
  public static extern IntPtr new_FloatingRateBond(uint jarg1, double jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6, uint jarg7, HandleRef jarg8, HandleRef jarg9, HandleRef jarg10, HandleRef jarg11, bool jarg12, double jarg13, HandleRef jarg14, HandleRef jarg15);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FloatingRateBond")]
  public static extern void delete_FloatingRateBond(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CallabilityPrice")]
  public static extern IntPtr new_CallabilityPrice(double jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityPrice_amount")]
  public static extern double CallabilityPrice_amount(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityPrice_type")]
  public static extern int CallabilityPrice_type(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CallabilityPrice")]
  public static extern void delete_CallabilityPrice(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp__Callability_price")]
  public static extern IntPtr _Callability_price(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp__Callability_type")]
  public static extern int _Callability_type(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp__Callability_date")]
  public static extern IntPtr _Callability_date(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete__Callability")]
  public static extern void delete__Callability(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Callability___deref__")]
  public static extern IntPtr Callability___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Callability_isNull")]
  public static extern bool Callability_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Callability_Call_get")]
  public static extern int Callability_Call_get();

  [DllImport("NQuantLibc", EntryPoint="CSharp_Callability_Put_get")]
  public static extern int Callability_Put_get();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Callability")]
  public static extern IntPtr new_Callability();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Callability")]
  public static extern void delete_Callability(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Callability_price")]
  public static extern IntPtr Callability_price(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Callability_type")]
  public static extern int Callability_type(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Callability_date")]
  public static extern IntPtr Callability_date(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SoftCallability")]
  public static extern IntPtr new_SoftCallability(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SoftCallability")]
  public static extern void delete_SoftCallability(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_Clear")]
  public static extern void CallabilityVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_Add")]
  public static extern void CallabilityVector_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_size")]
  public static extern uint CallabilityVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_capacity")]
  public static extern uint CallabilityVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_reserve")]
  public static extern void CallabilityVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CallabilityVector__SWIG_0")]
  public static extern IntPtr new_CallabilityVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CallabilityVector__SWIG_1")]
  public static extern IntPtr new_CallabilityVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_getitemcopy")]
  public static extern IntPtr CallabilityVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_getitem")]
  public static extern IntPtr CallabilityVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_setitem")]
  public static extern void CallabilityVector_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_AddRange")]
  public static extern void CallabilityVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_GetRange")]
  public static extern IntPtr CallabilityVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_Insert")]
  public static extern void CallabilityVector_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_InsertRange")]
  public static extern void CallabilityVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_RemoveAt")]
  public static extern void CallabilityVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_RemoveRange")]
  public static extern void CallabilityVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_Repeat")]
  public static extern IntPtr CallabilityVector_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_Reverse__SWIG_0")]
  public static extern void CallabilityVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_Reverse__SWIG_1")]
  public static extern void CallabilityVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_SetRange")]
  public static extern void CallabilityVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_Contains")]
  public static extern bool CallabilityVector_Contains(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_IndexOf")]
  public static extern int CallabilityVector_IndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_LastIndexOf")]
  public static extern int CallabilityVector_LastIndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CallabilityVector_Remove")]
  public static extern void CallabilityVector_Remove(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CallabilityVector")]
  public static extern void delete_CallabilityVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapFloor_impliedVolatility__SWIG_0")]
  public static extern double CapFloor_impliedVolatility__SWIG_0(HandleRef jarg1, double jarg2, double jarg3, uint jarg4, double jarg5, double jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapFloor_impliedVolatility__SWIG_1")]
  public static extern double CapFloor_impliedVolatility__SWIG_1(HandleRef jarg1, double jarg2, double jarg3, uint jarg4, double jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapFloor_impliedVolatility__SWIG_2")]
  public static extern double CapFloor_impliedVolatility__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, uint jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapFloor_impliedVolatility__SWIG_3")]
  public static extern double CapFloor_impliedVolatility__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapFloor_impliedVolatility__SWIG_4")]
  public static extern double CapFloor_impliedVolatility__SWIG_4(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapFloor")]
  public static extern IntPtr new_CapFloor();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CapFloor")]
  public static extern void delete_CapFloor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Cap")]
  public static extern IntPtr new_Cap(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Cap")]
  public static extern void delete_Cap(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Floor")]
  public static extern IntPtr new_Floor(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Floor")]
  public static extern void delete_Floor(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Collar")]
  public static extern IntPtr new_Collar(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Collar")]
  public static extern void delete_Collar(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackCapFloorEngine__SWIG_0")]
  public static extern IntPtr new_BlackCapFloorEngine__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackCapFloorEngine__SWIG_1")]
  public static extern IntPtr new_BlackCapFloorEngine__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BlackCapFloorEngine")]
  public static extern void delete_BlackCapFloorEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CompoundForward")]
  public static extern IntPtr new_CompoundForward(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5, int jarg6, HandleRef jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CompoundForward_dates")]
  public static extern IntPtr CompoundForward_dates(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CompoundForward_compoundForward__SWIG_0")]
  public static extern double CompoundForward_compoundForward__SWIG_0(HandleRef jarg1, HandleRef jarg2, int jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CompoundForward_compoundForward__SWIG_1")]
  public static extern double CompoundForward_compoundForward__SWIG_1(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CompoundForward_compoundForward__SWIG_2")]
  public static extern double CompoundForward_compoundForward__SWIG_2(HandleRef jarg1, double jarg2, int jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CompoundForward_compoundForward__SWIG_3")]
  public static extern double CompoundForward_compoundForward__SWIG_3(HandleRef jarg1, double jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CompoundForward")]
  public static extern void delete_CompoundForward(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Dividend___deref__")]
  public static extern IntPtr Dividend___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Dividend_isNull")]
  public static extern bool Dividend_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Dividend")]
  public static extern IntPtr new_Dividend();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Dividend")]
  public static extern void delete_Dividend(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Dividend_amount")]
  public static extern double Dividend_amount(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Dividend_date")]
  public static extern IntPtr Dividend_date(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FixedDividend")]
  public static extern IntPtr new_FixedDividend(double jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FixedDividend")]
  public static extern void delete_FixedDividend(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FractionalDividend")]
  public static extern IntPtr new_FractionalDividend(double jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FractionalDividend")]
  public static extern void delete_FractionalDividend(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ConvertibleZeroCouponBond__SWIG_0")]
  public static extern IntPtr new_ConvertibleZeroCouponBond__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8, int jarg9, HandleRef jarg10, HandleRef jarg11, double jarg12);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ConvertibleZeroCouponBond__SWIG_1")]
  public static extern IntPtr new_ConvertibleZeroCouponBond__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8, int jarg9, HandleRef jarg10, HandleRef jarg11);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ConvertibleZeroCouponBond")]
  public static extern void delete_ConvertibleZeroCouponBond(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ConvertibleFixedCouponBond__SWIG_0")]
  public static extern IntPtr new_ConvertibleFixedCouponBond__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8, int jarg9, HandleRef jarg10, HandleRef jarg11, HandleRef jarg12, double jarg13);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ConvertibleFixedCouponBond__SWIG_1")]
  public static extern IntPtr new_ConvertibleFixedCouponBond__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8, int jarg9, HandleRef jarg10, HandleRef jarg11, HandleRef jarg12);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ConvertibleFixedCouponBond")]
  public static extern void delete_ConvertibleFixedCouponBond(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ConvertibleFloatingRateBond__SWIG_0")]
  public static extern IntPtr new_ConvertibleFloatingRateBond__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8, int jarg9, HandleRef jarg10, int jarg11, HandleRef jarg12, HandleRef jarg13, HandleRef jarg14, double jarg15);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ConvertibleFloatingRateBond__SWIG_1")]
  public static extern IntPtr new_ConvertibleFloatingRateBond__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8, int jarg9, HandleRef jarg10, int jarg11, HandleRef jarg12, HandleRef jarg13, HandleRef jarg14);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ConvertibleFloatingRateBond")]
  public static extern void delete_ConvertibleFloatingRateBond(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BinomialConvertibleEngine")]
  public static extern IntPtr new_BinomialConvertibleEngine(string jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BinomialConvertibleEngine")]
  public static extern void delete_BinomialConvertibleEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DiscountCurve__SWIG_0")]
  public static extern IntPtr new_DiscountCurve__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DiscountCurve__SWIG_1")]
  public static extern IntPtr new_DiscountCurve__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DiscountCurve__SWIG_2")]
  public static extern IntPtr new_DiscountCurve__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DiscountCurve_dates")]
  public static extern IntPtr DiscountCurve_dates(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DiscountCurve_discounts")]
  public static extern IntPtr DiscountCurve_discounts(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DiscountCurve_nodes")]
  public static extern IntPtr DiscountCurve_nodes(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DiscountCurve")]
  public static extern void delete_DiscountCurve(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NormalDistribution__SWIG_0")]
  public static extern IntPtr new_NormalDistribution__SWIG_0(double jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NormalDistribution__SWIG_1")]
  public static extern IntPtr new_NormalDistribution__SWIG_1(double jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NormalDistribution__SWIG_2")]
  public static extern IntPtr new_NormalDistribution__SWIG_2();

  [DllImport("NQuantLibc", EntryPoint="CSharp_NormalDistribution_call")]
  public static extern double NormalDistribution_call(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NormalDistribution_derivative")]
  public static extern double NormalDistribution_derivative(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_NormalDistribution")]
  public static extern void delete_NormalDistribution(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CumulativeNormalDistribution__SWIG_0")]
  public static extern IntPtr new_CumulativeNormalDistribution__SWIG_0(double jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CumulativeNormalDistribution__SWIG_1")]
  public static extern IntPtr new_CumulativeNormalDistribution__SWIG_1(double jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CumulativeNormalDistribution__SWIG_2")]
  public static extern IntPtr new_CumulativeNormalDistribution__SWIG_2();

  [DllImport("NQuantLibc", EntryPoint="CSharp_CumulativeNormalDistribution_call")]
  public static extern double CumulativeNormalDistribution_call(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CumulativeNormalDistribution_derivative")]
  public static extern double CumulativeNormalDistribution_derivative(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CumulativeNormalDistribution")]
  public static extern void delete_CumulativeNormalDistribution(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_InverseCumulativeNormal__SWIG_0")]
  public static extern IntPtr new_InverseCumulativeNormal__SWIG_0(double jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_InverseCumulativeNormal__SWIG_1")]
  public static extern IntPtr new_InverseCumulativeNormal__SWIG_1(double jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_InverseCumulativeNormal__SWIG_2")]
  public static extern IntPtr new_InverseCumulativeNormal__SWIG_2();

  [DllImport("NQuantLibc", EntryPoint="CSharp_InverseCumulativeNormal_call")]
  public static extern double InverseCumulativeNormal_call(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_InverseCumulativeNormal")]
  public static extern void delete_InverseCumulativeNormal(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MoroInverseCumulativeNormal__SWIG_0")]
  public static extern IntPtr new_MoroInverseCumulativeNormal__SWIG_0(double jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MoroInverseCumulativeNormal__SWIG_1")]
  public static extern IntPtr new_MoroInverseCumulativeNormal__SWIG_1(double jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MoroInverseCumulativeNormal__SWIG_2")]
  public static extern IntPtr new_MoroInverseCumulativeNormal__SWIG_2();

  [DllImport("NQuantLibc", EntryPoint="CSharp_MoroInverseCumulativeNormal_call")]
  public static extern double MoroInverseCumulativeNormal_call(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MoroInverseCumulativeNormal")]
  public static extern void delete_MoroInverseCumulativeNormal(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Money__SWIG_0")]
  public static extern IntPtr new_Money__SWIG_0(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Money__SWIG_1")]
  public static extern IntPtr new_Money__SWIG_1(double jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Money_currency")]
  public static extern IntPtr Money_currency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Money_value")]
  public static extern double Money_value(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Money_rounded")]
  public static extern IntPtr Money_rounded(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Money_setConversionType")]
  public static extern void Money_setConversionType(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Money_setBaseCurrency")]
  public static extern void Money_setBaseCurrency(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Money")]
  public static extern void delete_Money(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ExchangeRate")]
  public static extern IntPtr new_ExchangeRate(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ExchangeRate_source")]
  public static extern IntPtr ExchangeRate_source(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ExchangeRate_target")]
  public static extern IntPtr ExchangeRate_target(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ExchangeRate_type")]
  public static extern int ExchangeRate_type(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ExchangeRate_rate")]
  public static extern double ExchangeRate_rate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ExchangeRate_exchange")]
  public static extern IntPtr ExchangeRate_exchange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ExchangeRate_chain")]
  public static extern IntPtr ExchangeRate_chain(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ExchangeRate")]
  public static extern void delete_ExchangeRate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ExchangeRateManager_instance")]
  public static extern IntPtr ExchangeRateManager_instance();

  [DllImport("NQuantLibc", EntryPoint="CSharp_ExchangeRateManager_add__SWIG_0")]
  public static extern void ExchangeRateManager_add__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ExchangeRateManager_add__SWIG_1")]
  public static extern void ExchangeRateManager_add__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ExchangeRateManager_add__SWIG_2")]
  public static extern void ExchangeRateManager_add__SWIG_2(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ExchangeRateManager_lookup__SWIG_0")]
  public static extern IntPtr ExchangeRateManager_lookup__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, int jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ExchangeRateManager_lookup__SWIG_1")]
  public static extern IntPtr ExchangeRateManager_lookup__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ExchangeRateManager_clear")]
  public static extern void ExchangeRateManager_clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ExchangeRateManager")]
  public static extern void delete_ExchangeRateManager(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ForwardCurve__SWIG_0")]
  public static extern IntPtr new_ForwardCurve__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ForwardCurve__SWIG_1")]
  public static extern IntPtr new_ForwardCurve__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ForwardCurve_dates")]
  public static extern IntPtr ForwardCurve_dates(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ForwardCurve_forwards")]
  public static extern IntPtr ForwardCurve_forwards(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ForwardCurve_nodes")]
  public static extern IntPtr ForwardCurve_nodes(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ForwardCurve")]
  public static extern void delete_ForwardCurve(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TimeGrid__SWIG_0")]
  public static extern IntPtr new_TimeGrid__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TimeGrid__SWIG_1")]
  public static extern IntPtr new_TimeGrid__SWIG_1(double jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TimeGrid__SWIG_2")]
  public static extern IntPtr new_TimeGrid__SWIG_2(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TimeGrid__SWIG_3")]
  public static extern IntPtr new_TimeGrid__SWIG_3(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TimeGrid_size")]
  public static extern uint TimeGrid_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_TimeGrid")]
  public static extern void delete_TimeGrid(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SegmentIntegral")]
  public static extern IntPtr new_SegmentIntegral(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SegmentIntegral")]
  public static extern void delete_SegmentIntegral(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TrapezoidIntegral")]
  public static extern IntPtr new_TrapezoidIntegral(double jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_TrapezoidIntegral")]
  public static extern void delete_TrapezoidIntegral(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SimpsonIntegral")]
  public static extern IntPtr new_SimpsonIntegral(double jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SimpsonIntegral")]
  public static extern void delete_SimpsonIntegral(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GaussKronrodAdaptive__SWIG_0")]
  public static extern IntPtr new_GaussKronrodAdaptive__SWIG_0(double jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GaussKronrodAdaptive__SWIG_1")]
  public static extern IntPtr new_GaussKronrodAdaptive__SWIG_1(double jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GaussKronrodAdaptive")]
  public static extern void delete_GaussKronrodAdaptive(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GaussKronrodNonAdaptive")]
  public static extern IntPtr new_GaussKronrodNonAdaptive(double jarg1, uint jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GaussKronrodNonAdaptive")]
  public static extern void delete_GaussKronrodNonAdaptive(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampleNumber_value")]
  public static extern double SampleNumber_value(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampleNumber_weight")]
  public static extern double SampleNumber_weight(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SampleNumber")]
  public static extern void delete_SampleNumber(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampleArray_value")]
  public static extern IntPtr SampleArray_value(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampleArray_weight")]
  public static extern double SampleArray_weight(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SampleArray")]
  public static extern void delete_SampleArray(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampleRealVector_value")]
  public static extern IntPtr SampleRealVector_value(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampleRealVector_weight")]
  public static extern double SampleRealVector_weight(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SampleRealVector")]
  public static extern void delete_SampleRealVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LecuyerUniformRng__SWIG_0")]
  public static extern IntPtr new_LecuyerUniformRng__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LecuyerUniformRng__SWIG_1")]
  public static extern IntPtr new_LecuyerUniformRng__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_LecuyerUniformRng_next")]
  public static extern IntPtr LecuyerUniformRng_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_LecuyerUniformRng")]
  public static extern void delete_LecuyerUniformRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_KnuthUniformRng")]
  public static extern void delete_KnuthUniformRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MersenneTwisterUniformRng")]
  public static extern void delete_MersenneTwisterUniformRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_UniformRandomGenerator__SWIG_0")]
  public static extern IntPtr new_UniformRandomGenerator__SWIG_0(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_UniformRandomGenerator__SWIG_1")]
  public static extern IntPtr new_UniformRandomGenerator__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_UniformRandomGenerator_next")]
  public static extern IntPtr UniformRandomGenerator_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_UniformRandomGenerator")]
  public static extern void delete_UniformRandomGenerator(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CentralLimitLecuyerGaussianRng")]
  public static extern IntPtr new_CentralLimitLecuyerGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CentralLimitLecuyerGaussianRng_next")]
  public static extern IntPtr CentralLimitLecuyerGaussianRng_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CentralLimitLecuyerGaussianRng")]
  public static extern void delete_CentralLimitLecuyerGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CentralLimitKnuthGaussianRng")]
  public static extern IntPtr new_CentralLimitKnuthGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CentralLimitKnuthGaussianRng_next")]
  public static extern IntPtr CentralLimitKnuthGaussianRng_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CentralLimitKnuthGaussianRng")]
  public static extern void delete_CentralLimitKnuthGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CentralLimitMersenneTwisterGaussianRng")]
  public static extern IntPtr new_CentralLimitMersenneTwisterGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CentralLimitMersenneTwisterGaussianRng_next")]
  public static extern IntPtr CentralLimitMersenneTwisterGaussianRng_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CentralLimitMersenneTwisterGaussianRng")]
  public static extern void delete_CentralLimitMersenneTwisterGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BoxMullerLecuyerGaussianRng")]
  public static extern IntPtr new_BoxMullerLecuyerGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BoxMullerLecuyerGaussianRng_next")]
  public static extern IntPtr BoxMullerLecuyerGaussianRng_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BoxMullerLecuyerGaussianRng")]
  public static extern void delete_BoxMullerLecuyerGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BoxMullerKnuthGaussianRng")]
  public static extern IntPtr new_BoxMullerKnuthGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BoxMullerKnuthGaussianRng_next")]
  public static extern IntPtr BoxMullerKnuthGaussianRng_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BoxMullerKnuthGaussianRng")]
  public static extern void delete_BoxMullerKnuthGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BoxMullerMersenneTwisterGaussianRng")]
  public static extern IntPtr new_BoxMullerMersenneTwisterGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BoxMullerMersenneTwisterGaussianRng_next")]
  public static extern IntPtr BoxMullerMersenneTwisterGaussianRng_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BoxMullerMersenneTwisterGaussianRng")]
  public static extern void delete_BoxMullerMersenneTwisterGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MoroInvCumulativeLecuyerGaussianRng")]
  public static extern IntPtr new_MoroInvCumulativeLecuyerGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MoroInvCumulativeLecuyerGaussianRng_next")]
  public static extern IntPtr MoroInvCumulativeLecuyerGaussianRng_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MoroInvCumulativeLecuyerGaussianRng")]
  public static extern void delete_MoroInvCumulativeLecuyerGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MoroInvCumulativeKnuthGaussianRng")]
  public static extern IntPtr new_MoroInvCumulativeKnuthGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MoroInvCumulativeKnuthGaussianRng_next")]
  public static extern IntPtr MoroInvCumulativeKnuthGaussianRng_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MoroInvCumulativeKnuthGaussianRng")]
  public static extern void delete_MoroInvCumulativeKnuthGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MoroInvCumulativeMersenneTwisterGaussianRng")]
  public static extern IntPtr new_MoroInvCumulativeMersenneTwisterGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MoroInvCumulativeMersenneTwisterGaussianRng_next")]
  public static extern IntPtr MoroInvCumulativeMersenneTwisterGaussianRng_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MoroInvCumulativeMersenneTwisterGaussianRng")]
  public static extern void delete_MoroInvCumulativeMersenneTwisterGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_InvCumulativeLecuyerGaussianRng")]
  public static extern IntPtr new_InvCumulativeLecuyerGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InvCumulativeLecuyerGaussianRng_next")]
  public static extern IntPtr InvCumulativeLecuyerGaussianRng_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_InvCumulativeLecuyerGaussianRng")]
  public static extern void delete_InvCumulativeLecuyerGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_InvCumulativeKnuthGaussianRng")]
  public static extern IntPtr new_InvCumulativeKnuthGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InvCumulativeKnuthGaussianRng_next")]
  public static extern IntPtr InvCumulativeKnuthGaussianRng_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_InvCumulativeKnuthGaussianRng")]
  public static extern void delete_InvCumulativeKnuthGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_InvCumulativeMersenneTwisterGaussianRng")]
  public static extern IntPtr new_InvCumulativeMersenneTwisterGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InvCumulativeMersenneTwisterGaussianRng_next")]
  public static extern IntPtr InvCumulativeMersenneTwisterGaussianRng_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_InvCumulativeMersenneTwisterGaussianRng")]
  public static extern void delete_InvCumulativeMersenneTwisterGaussianRng(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GaussianRandomGenerator")]
  public static extern IntPtr new_GaussianRandomGenerator(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GaussianRandomGenerator_next")]
  public static extern IntPtr GaussianRandomGenerator_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GaussianRandomGenerator")]
  public static extern void delete_GaussianRandomGenerator(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_HaltonRsg")]
  public static extern IntPtr new_HaltonRsg(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_HaltonRsg_nextSequence")]
  public static extern IntPtr HaltonRsg_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_HaltonRsg_dimension")]
  public static extern uint HaltonRsg_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_HaltonRsg")]
  public static extern void delete_HaltonRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SobolRsg__SWIG_0")]
  public static extern IntPtr new_SobolRsg__SWIG_0(uint jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SobolRsg__SWIG_1")]
  public static extern IntPtr new_SobolRsg__SWIG_1(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SobolRsg_nextSequence")]
  public static extern IntPtr SobolRsg_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SobolRsg_dimension")]
  public static extern uint SobolRsg_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SobolRsg")]
  public static extern void delete_SobolRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_LecuyerUniformRsg")]
  public static extern IntPtr new_LecuyerUniformRsg(uint jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LecuyerUniformRsg_nextSequence")]
  public static extern IntPtr LecuyerUniformRsg_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LecuyerUniformRsg_dimension")]
  public static extern uint LecuyerUniformRsg_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_LecuyerUniformRsg")]
  public static extern void delete_LecuyerUniformRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_KnuthUniformRsg")]
  public static extern IntPtr new_KnuthUniformRsg(uint jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_KnuthUniformRsg_nextSequence")]
  public static extern IntPtr KnuthUniformRsg_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_KnuthUniformRsg_dimension")]
  public static extern uint KnuthUniformRsg_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_KnuthUniformRsg")]
  public static extern void delete_KnuthUniformRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MersenneTwisterUniformRsg")]
  public static extern IntPtr new_MersenneTwisterUniformRsg(uint jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MersenneTwisterUniformRsg_nextSequence")]
  public static extern IntPtr MersenneTwisterUniformRsg_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MersenneTwisterUniformRsg_dimension")]
  public static extern uint MersenneTwisterUniformRsg_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MersenneTwisterUniformRsg")]
  public static extern void delete_MersenneTwisterUniformRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_UniformRandomSequenceGenerator")]
  public static extern IntPtr new_UniformRandomSequenceGenerator(uint jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_UniformRandomSequenceGenerator_nextSequence")]
  public static extern IntPtr UniformRandomSequenceGenerator_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_UniformRandomSequenceGenerator_dimension")]
  public static extern uint UniformRandomSequenceGenerator_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_UniformRandomSequenceGenerator")]
  public static extern void delete_UniformRandomSequenceGenerator(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_UniformLowDiscrepancySequenceGenerator")]
  public static extern IntPtr new_UniformLowDiscrepancySequenceGenerator(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_UniformLowDiscrepancySequenceGenerator_nextSequence")]
  public static extern IntPtr UniformLowDiscrepancySequenceGenerator_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_UniformLowDiscrepancySequenceGenerator_dimension")]
  public static extern uint UniformLowDiscrepancySequenceGenerator_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_UniformLowDiscrepancySequenceGenerator")]
  public static extern void delete_UniformLowDiscrepancySequenceGenerator(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MoroInvCumulativeLecuyerGaussianRsg")]
  public static extern IntPtr new_MoroInvCumulativeLecuyerGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MoroInvCumulativeLecuyerGaussianRsg_nextSequence")]
  public static extern IntPtr MoroInvCumulativeLecuyerGaussianRsg_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MoroInvCumulativeLecuyerGaussianRsg_dimension")]
  public static extern uint MoroInvCumulativeLecuyerGaussianRsg_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MoroInvCumulativeLecuyerGaussianRsg")]
  public static extern void delete_MoroInvCumulativeLecuyerGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MoroInvCumulativeKnuthGaussianRsg")]
  public static extern IntPtr new_MoroInvCumulativeKnuthGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MoroInvCumulativeKnuthGaussianRsg_nextSequence")]
  public static extern IntPtr MoroInvCumulativeKnuthGaussianRsg_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MoroInvCumulativeKnuthGaussianRsg_dimension")]
  public static extern uint MoroInvCumulativeKnuthGaussianRsg_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MoroInvCumulativeKnuthGaussianRsg")]
  public static extern void delete_MoroInvCumulativeKnuthGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MoroInvCumulativeMersenneTwisterGaussianRsg")]
  public static extern IntPtr new_MoroInvCumulativeMersenneTwisterGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MoroInvCumulativeMersenneTwisterGaussianRsg_nextSequence")]
  public static extern IntPtr MoroInvCumulativeMersenneTwisterGaussianRsg_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MoroInvCumulativeMersenneTwisterGaussianRsg_dimension")]
  public static extern uint MoroInvCumulativeMersenneTwisterGaussianRsg_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MoroInvCumulativeMersenneTwisterGaussianRsg")]
  public static extern void delete_MoroInvCumulativeMersenneTwisterGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MoroInvCumulativeHaltonGaussianRsg")]
  public static extern IntPtr new_MoroInvCumulativeHaltonGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MoroInvCumulativeHaltonGaussianRsg_nextSequence")]
  public static extern IntPtr MoroInvCumulativeHaltonGaussianRsg_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MoroInvCumulativeHaltonGaussianRsg_dimension")]
  public static extern uint MoroInvCumulativeHaltonGaussianRsg_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MoroInvCumulativeHaltonGaussianRsg")]
  public static extern void delete_MoroInvCumulativeHaltonGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_InvCumulativeLecuyerGaussianRsg")]
  public static extern IntPtr new_InvCumulativeLecuyerGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InvCumulativeLecuyerGaussianRsg_nextSequence")]
  public static extern IntPtr InvCumulativeLecuyerGaussianRsg_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InvCumulativeLecuyerGaussianRsg_dimension")]
  public static extern uint InvCumulativeLecuyerGaussianRsg_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_InvCumulativeLecuyerGaussianRsg")]
  public static extern void delete_InvCumulativeLecuyerGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_InvCumulativeKnuthGaussianRsg")]
  public static extern IntPtr new_InvCumulativeKnuthGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InvCumulativeKnuthGaussianRsg_nextSequence")]
  public static extern IntPtr InvCumulativeKnuthGaussianRsg_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InvCumulativeKnuthGaussianRsg_dimension")]
  public static extern uint InvCumulativeKnuthGaussianRsg_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_InvCumulativeKnuthGaussianRsg")]
  public static extern void delete_InvCumulativeKnuthGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_InvCumulativeMersenneTwisterGaussianRsg")]
  public static extern IntPtr new_InvCumulativeMersenneTwisterGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InvCumulativeMersenneTwisterGaussianRsg_nextSequence")]
  public static extern IntPtr InvCumulativeMersenneTwisterGaussianRsg_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InvCumulativeMersenneTwisterGaussianRsg_dimension")]
  public static extern uint InvCumulativeMersenneTwisterGaussianRsg_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_InvCumulativeMersenneTwisterGaussianRsg")]
  public static extern void delete_InvCumulativeMersenneTwisterGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_InvCumulativeHaltonGaussianRsg")]
  public static extern IntPtr new_InvCumulativeHaltonGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InvCumulativeHaltonGaussianRsg_nextSequence")]
  public static extern IntPtr InvCumulativeHaltonGaussianRsg_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InvCumulativeHaltonGaussianRsg_dimension")]
  public static extern uint InvCumulativeHaltonGaussianRsg_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_InvCumulativeHaltonGaussianRsg")]
  public static extern void delete_InvCumulativeHaltonGaussianRsg(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GaussianRandomSequenceGenerator")]
  public static extern IntPtr new_GaussianRandomSequenceGenerator(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GaussianRandomSequenceGenerator_nextSequence")]
  public static extern IntPtr GaussianRandomSequenceGenerator_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GaussianRandomSequenceGenerator_dimension")]
  public static extern uint GaussianRandomSequenceGenerator_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GaussianRandomSequenceGenerator")]
  public static extern void delete_GaussianRandomSequenceGenerator(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GaussianLowDiscrepancySequenceGenerator")]
  public static extern IntPtr new_GaussianLowDiscrepancySequenceGenerator(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GaussianLowDiscrepancySequenceGenerator_nextSequence")]
  public static extern IntPtr GaussianLowDiscrepancySequenceGenerator_nextSequence(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GaussianLowDiscrepancySequenceGenerator_dimension")]
  public static extern uint GaussianLowDiscrepancySequenceGenerator_dimension(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GaussianLowDiscrepancySequenceGenerator")]
  public static extern void delete_GaussianLowDiscrepancySequenceGenerator(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_getCovariance")]
  public static extern IntPtr getCovariance(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Path_length")]
  public static extern uint Path_length(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Path_value")]
  public static extern double Path_value(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Path_time")]
  public static extern double Path_time(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Path")]
  public static extern void delete_Path(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SamplePath_value")]
  public static extern IntPtr SamplePath_value(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SamplePath_weight")]
  public static extern double SamplePath_weight(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SamplePath")]
  public static extern void delete_SamplePath(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GaussianPathGenerator")]
  public static extern IntPtr new_GaussianPathGenerator(HandleRef jarg1, double jarg2, uint jarg3, HandleRef jarg4, bool jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GaussianPathGenerator_next")]
  public static extern IntPtr GaussianPathGenerator_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GaussianPathGenerator")]
  public static extern void delete_GaussianPathGenerator(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultiPath_pathSize")]
  public static extern uint MultiPath_pathSize(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultiPath_assetNumber")]
  public static extern uint MultiPath_assetNumber(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MultiPath")]
  public static extern void delete_MultiPath(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampleMultiPath_value")]
  public static extern IntPtr SampleMultiPath_value(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampleMultiPath_weight")]
  public static extern double SampleMultiPath_weight(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SampleMultiPath")]
  public static extern void delete_SampleMultiPath(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GaussianMultiPathGenerator__SWIG_0")]
  public static extern IntPtr new_GaussianMultiPathGenerator__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, bool jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GaussianMultiPathGenerator__SWIG_1")]
  public static extern IntPtr new_GaussianMultiPathGenerator__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GaussianMultiPathGenerator_next")]
  public static extern IntPtr GaussianMultiPathGenerator_next(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GaussianMultiPathGenerator")]
  public static extern void delete_GaussianMultiPathGenerator(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete__BoundaryCondition")]
  public static extern void delete__BoundaryCondition(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BoundaryCondition___deref__")]
  public static extern IntPtr BoundaryCondition___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BoundaryCondition_isNull")]
  public static extern bool BoundaryCondition_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BoundaryCondition_NoSide_get")]
  public static extern int BoundaryCondition_NoSide_get();

  [DllImport("NQuantLibc", EntryPoint="CSharp_BoundaryCondition_Upper_get")]
  public static extern int BoundaryCondition_Upper_get();

  [DllImport("NQuantLibc", EntryPoint="CSharp_BoundaryCondition_Lower_get")]
  public static extern int BoundaryCondition_Lower_get();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BoundaryCondition")]
  public static extern IntPtr new_BoundaryCondition();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BoundaryCondition")]
  public static extern void delete_BoundaryCondition(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NeumannBC")]
  public static extern IntPtr new_NeumannBC(double jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_NeumannBC")]
  public static extern void delete_NeumannBC(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DirichletBC")]
  public static extern IntPtr new_DirichletBC(double jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DirichletBC")]
  public static extern void delete_DirichletBC(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TridiagonalOperator")]
  public static extern IntPtr new_TridiagonalOperator(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TridiagonalOperator_solveFor")]
  public static extern IntPtr TridiagonalOperator_solveFor(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TridiagonalOperator_applyTo")]
  public static extern IntPtr TridiagonalOperator_applyTo(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TridiagonalOperator_size")]
  public static extern uint TridiagonalOperator_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TridiagonalOperator_setFirstRow")]
  public static extern void TridiagonalOperator_setFirstRow(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TridiagonalOperator_setMidRow")]
  public static extern void TridiagonalOperator_setMidRow(HandleRef jarg1, uint jarg2, double jarg3, double jarg4, double jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TridiagonalOperator_setMidRows")]
  public static extern void TridiagonalOperator_setMidRows(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TridiagonalOperator_setLastRow")]
  public static extern void TridiagonalOperator_setLastRow(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TridiagonalOperator_identity")]
  public static extern IntPtr TridiagonalOperator_identity(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_TridiagonalOperator")]
  public static extern void delete_TridiagonalOperator(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DPlus")]
  public static extern IntPtr new_DPlus(uint jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DPlus")]
  public static extern void delete_DPlus(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DMinus")]
  public static extern IntPtr new_DMinus(uint jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DMinus")]
  public static extern void delete_DMinus(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DZero")]
  public static extern IntPtr new_DZero(uint jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DZero")]
  public static extern void delete_DZero(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DPlusDMinus")]
  public static extern IntPtr new_DPlusDMinus(uint jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DPlusDMinus")]
  public static extern void delete_DPlusDMinus(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Brent_setMaxEvaluations")]
  public static extern void Brent_setMaxEvaluations(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Brent_setLowerBound")]
  public static extern void Brent_setLowerBound(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Brent_setUpperBound")]
  public static extern void Brent_setUpperBound(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Brent")]
  public static extern IntPtr new_Brent();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Brent")]
  public static extern void delete_Brent(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bisection_setMaxEvaluations")]
  public static extern void Bisection_setMaxEvaluations(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bisection_setLowerBound")]
  public static extern void Bisection_setLowerBound(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Bisection_setUpperBound")]
  public static extern void Bisection_setUpperBound(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Bisection")]
  public static extern IntPtr new_Bisection();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Bisection")]
  public static extern void delete_Bisection(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FalsePosition_setMaxEvaluations")]
  public static extern void FalsePosition_setMaxEvaluations(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FalsePosition_setLowerBound")]
  public static extern void FalsePosition_setLowerBound(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FalsePosition_setUpperBound")]
  public static extern void FalsePosition_setUpperBound(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FalsePosition")]
  public static extern IntPtr new_FalsePosition();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FalsePosition")]
  public static extern void delete_FalsePosition(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Ridder_setMaxEvaluations")]
  public static extern void Ridder_setMaxEvaluations(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Ridder_setLowerBound")]
  public static extern void Ridder_setLowerBound(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Ridder_setUpperBound")]
  public static extern void Ridder_setUpperBound(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Ridder")]
  public static extern IntPtr new_Ridder();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Ridder")]
  public static extern void delete_Ridder(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Secant_setMaxEvaluations")]
  public static extern void Secant_setMaxEvaluations(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Secant_setLowerBound")]
  public static extern void Secant_setLowerBound(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Secant_setUpperBound")]
  public static extern void Secant_setUpperBound(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Secant")]
  public static extern IntPtr new_Secant();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Secant")]
  public static extern void delete_Secant(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Constraint")]
  public static extern void delete_Constraint(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BoundaryConstraint")]
  public static extern IntPtr new_BoundaryConstraint(double jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BoundaryConstraint")]
  public static extern void delete_BoundaryConstraint(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_NoConstraint")]
  public static extern IntPtr new_NoConstraint();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_NoConstraint")]
  public static extern void delete_NoConstraint(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PositiveConstraint")]
  public static extern IntPtr new_PositiveConstraint();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_PositiveConstraint")]
  public static extern void delete_PositiveConstraint(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_EndCriteria")]
  public static extern IntPtr new_EndCriteria(uint jarg1, uint jarg2, double jarg3, double jarg4, double jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EndCriteria_call")]
  public static extern bool EndCriteria_call(HandleRef jarg1, uint jarg2, HandleRef jarg3, bool jarg4, double jarg5, double jarg6, double jarg7, double jarg8, HandleRef jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_EndCriteria")]
  public static extern void delete_EndCriteria(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_OptimizationMethod")]
  public static extern void delete_OptimizationMethod(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ConjugateGradient")]
  public static extern IntPtr new_ConjugateGradient();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ConjugateGradient")]
  public static extern void delete_ConjugateGradient(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Simplex")]
  public static extern IntPtr new_Simplex(double jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Simplex")]
  public static extern void delete_Simplex(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SteepestDescent")]
  public static extern IntPtr new_SteepestDescent();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SteepestDescent")]
  public static extern void delete_SteepestDescent(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Optimizer")]
  public static extern IntPtr new_Optimizer();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Optimizer")]
  public static extern void delete_Optimizer(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelper___deref__")]
  public static extern IntPtr RateHelper___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelper_isNull")]
  public static extern bool RateHelper_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RateHelper")]
  public static extern IntPtr new_RateHelper();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_RateHelper")]
  public static extern void delete_RateHelper(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DepositRateHelper__SWIG_0")]
  public static extern IntPtr new_DepositRateHelper__SWIG_0(HandleRef jarg1, HandleRef jarg2, uint jarg3, HandleRef jarg4, int jarg5, bool jarg6, uint jarg7, HandleRef jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DepositRateHelper__SWIG_1")]
  public static extern IntPtr new_DepositRateHelper__SWIG_1(double jarg1, HandleRef jarg2, uint jarg3, HandleRef jarg4, int jarg5, bool jarg6, uint jarg7, HandleRef jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DepositRateHelper")]
  public static extern void delete_DepositRateHelper(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FraRateHelper__SWIG_0")]
  public static extern IntPtr new_FraRateHelper__SWIG_0(HandleRef jarg1, uint jarg2, uint jarg3, uint jarg4, HandleRef jarg5, int jarg6, bool jarg7, uint jarg8, HandleRef jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FraRateHelper__SWIG_1")]
  public static extern IntPtr new_FraRateHelper__SWIG_1(double jarg1, uint jarg2, uint jarg3, uint jarg4, HandleRef jarg5, int jarg6, bool jarg7, uint jarg8, HandleRef jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FraRateHelper")]
  public static extern void delete_FraRateHelper(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FuturesRateHelper__SWIG_0")]
  public static extern IntPtr new_FuturesRateHelper__SWIG_0(HandleRef jarg1, HandleRef jarg2, uint jarg3, HandleRef jarg4, int jarg5, HandleRef jarg6, HandleRef jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FuturesRateHelper__SWIG_1")]
  public static extern IntPtr new_FuturesRateHelper__SWIG_1(HandleRef jarg1, HandleRef jarg2, uint jarg3, HandleRef jarg4, int jarg5, HandleRef jarg6, double jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FuturesRateHelper__SWIG_2")]
  public static extern IntPtr new_FuturesRateHelper__SWIG_2(HandleRef jarg1, HandleRef jarg2, uint jarg3, HandleRef jarg4, int jarg5, HandleRef jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FuturesRateHelper__SWIG_3")]
  public static extern IntPtr new_FuturesRateHelper__SWIG_3(double jarg1, HandleRef jarg2, uint jarg3, HandleRef jarg4, int jarg5, HandleRef jarg6, double jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FuturesRateHelper__SWIG_4")]
  public static extern IntPtr new_FuturesRateHelper__SWIG_4(double jarg1, HandleRef jarg2, uint jarg3, HandleRef jarg4, int jarg5, HandleRef jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FuturesRateHelper")]
  public static extern void delete_FuturesRateHelper(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SwapRateHelper__SWIG_0")]
  public static extern IntPtr new_SwapRateHelper__SWIG_0(HandleRef jarg1, HandleRef jarg2, uint jarg3, HandleRef jarg4, int jarg5, int jarg6, HandleRef jarg7, HandleRef jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SwapRateHelper__SWIG_1")]
  public static extern IntPtr new_SwapRateHelper__SWIG_1(double jarg1, HandleRef jarg2, uint jarg3, HandleRef jarg4, int jarg5, int jarg6, HandleRef jarg7, HandleRef jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SwapRateHelper")]
  public static extern void delete_SwapRateHelper(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FixedCouponBondHelper__SWIG_0")]
  public static extern IntPtr new_FixedCouponBondHelper__SWIG_0(HandleRef jarg1, uint jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6, double jarg7, HandleRef jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FixedCouponBondHelper__SWIG_1")]
  public static extern IntPtr new_FixedCouponBondHelper__SWIG_1(HandleRef jarg1, uint jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6, double jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FixedCouponBondHelper__SWIG_2")]
  public static extern IntPtr new_FixedCouponBondHelper__SWIG_2(HandleRef jarg1, uint jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_FixedCouponBondHelper__SWIG_3")]
  public static extern IntPtr new_FixedCouponBondHelper__SWIG_3(HandleRef jarg1, uint jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_FixedCouponBondHelper")]
  public static extern void delete_FixedCouponBondHelper(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_Clear")]
  public static extern void RateHelperVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_Add")]
  public static extern void RateHelperVector_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_size")]
  public static extern uint RateHelperVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_capacity")]
  public static extern uint RateHelperVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_reserve")]
  public static extern void RateHelperVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RateHelperVector__SWIG_0")]
  public static extern IntPtr new_RateHelperVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RateHelperVector__SWIG_1")]
  public static extern IntPtr new_RateHelperVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_getitemcopy")]
  public static extern IntPtr RateHelperVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_getitem")]
  public static extern IntPtr RateHelperVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_setitem")]
  public static extern void RateHelperVector_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_AddRange")]
  public static extern void RateHelperVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_GetRange")]
  public static extern IntPtr RateHelperVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_Insert")]
  public static extern void RateHelperVector_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_InsertRange")]
  public static extern void RateHelperVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_RemoveAt")]
  public static extern void RateHelperVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_RemoveRange")]
  public static extern void RateHelperVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_Repeat")]
  public static extern IntPtr RateHelperVector_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_Reverse__SWIG_0")]
  public static extern void RateHelperVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_Reverse__SWIG_1")]
  public static extern void RateHelperVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_SetRange")]
  public static extern void RateHelperVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_Contains")]
  public static extern bool RateHelperVector_Contains(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_IndexOf")]
  public static extern int RateHelperVector_IndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_LastIndexOf")]
  public static extern int RateHelperVector_LastIndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RateHelperVector_Remove")]
  public static extern void RateHelperVector_Remove(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_RateHelperVector")]
  public static extern void delete_RateHelperVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Discount")]
  public static extern IntPtr new_Discount();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Discount")]
  public static extern void delete_Discount(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ZeroYield")]
  public static extern IntPtr new_ZeroYield();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ZeroYield")]
  public static extern void delete_ZeroYield(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ForwardRate")]
  public static extern IntPtr new_ForwardRate();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ForwardRate")]
  public static extern void delete_ForwardRate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PiecewiseFlatForward__SWIG_0")]
  public static extern IntPtr new_PiecewiseFlatForward__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4, HandleRef jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PiecewiseFlatForward__SWIG_1")]
  public static extern IntPtr new_PiecewiseFlatForward__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PiecewiseFlatForward__SWIG_2")]
  public static extern IntPtr new_PiecewiseFlatForward__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PiecewiseFlatForward__SWIG_3")]
  public static extern IntPtr new_PiecewiseFlatForward__SWIG_3(int jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, double jarg5, HandleRef jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PiecewiseFlatForward__SWIG_4")]
  public static extern IntPtr new_PiecewiseFlatForward__SWIG_4(int jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, double jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_PiecewiseFlatForward__SWIG_5")]
  public static extern IntPtr new_PiecewiseFlatForward__SWIG_5(int jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PiecewiseFlatForward_dates")]
  public static extern IntPtr PiecewiseFlatForward_dates(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PiecewiseFlatForward_times")]
  public static extern IntPtr PiecewiseFlatForward_times(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PiecewiseFlatForward_nodes")]
  public static extern IntPtr PiecewiseFlatForward_nodes(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_PiecewiseFlatForward")]
  public static extern void delete_PiecewiseFlatForward(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SampledCurve__SWIG_0")]
  public static extern IntPtr new_SampledCurve__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SampledCurve__SWIG_1")]
  public static extern IntPtr new_SampledCurve__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_grid")]
  public static extern IntPtr SampledCurve_grid(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_values")]
  public static extern IntPtr SampledCurve_values(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_gridValue")]
  public static extern double SampledCurve_gridValue(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_value")]
  public static extern double SampledCurve_value(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_size")]
  public static extern uint SampledCurve_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_empty")]
  public static extern bool SampledCurve_empty(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_setGrid")]
  public static extern void SampledCurve_setGrid(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_setValues")]
  public static extern void SampledCurve_setValues(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_swap")]
  public static extern void SampledCurve_swap(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_setLogGrid")]
  public static extern void SampledCurve_setLogGrid(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_regridLogGrid")]
  public static extern void SampledCurve_regridLogGrid(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_shiftGrid")]
  public static extern void SampledCurve_shiftGrid(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_scaleGrid")]
  public static extern void SampledCurve_scaleGrid(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SampledCurve_regrid")]
  public static extern void SampledCurve_regrid(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SampledCurve")]
  public static extern void delete_SampledCurve(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Settings_instance")]
  public static extern IntPtr Settings_instance();

  [DllImport("NQuantLibc", EntryPoint="CSharp_Settings_getEvaluationDate")]
  public static extern IntPtr Settings_getEvaluationDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Settings_setEvaluationDate")]
  public static extern void Settings_setEvaluationDate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Settings")]
  public static extern void delete_Settings(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelper___deref__")]
  public static extern IntPtr CalibrationHelper___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelper_isNull")]
  public static extern bool CalibrationHelper_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CalibrationHelper")]
  public static extern IntPtr new_CalibrationHelper();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CalibrationHelper")]
  public static extern void delete_CalibrationHelper(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelper_setPricingEngine")]
  public static extern void CalibrationHelper_setPricingEngine(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelper_marketValue")]
  public static extern double CalibrationHelper_marketValue(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelper_modelValue")]
  public static extern double CalibrationHelper_modelValue(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelper_impliedVolatility")]
  public static extern double CalibrationHelper_impliedVolatility(HandleRef jarg1, double jarg2, double jarg3, uint jarg4, double jarg5, double jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelper_blackPrice")]
  public static extern double CalibrationHelper_blackPrice(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SwaptionHelper__SWIG_0")]
  public static extern IntPtr new_SwaptionHelper__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8, bool jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SwaptionHelper__SWIG_1")]
  public static extern IntPtr new_SwaptionHelper__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionHelper_times")]
  public static extern IntPtr SwaptionHelper_times(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SwaptionHelper")]
  public static extern void delete_SwaptionHelper(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapHelper")]
  public static extern IntPtr new_CapHelper(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4, HandleRef jarg5, bool jarg6, HandleRef jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapHelper_times")]
  public static extern IntPtr CapHelper_times(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CapHelper")]
  public static extern void delete_CapHelper(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_Clear")]
  public static extern void CalibrationHelperVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_Add")]
  public static extern void CalibrationHelperVector_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_size")]
  public static extern uint CalibrationHelperVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_capacity")]
  public static extern uint CalibrationHelperVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_reserve")]
  public static extern void CalibrationHelperVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CalibrationHelperVector__SWIG_0")]
  public static extern IntPtr new_CalibrationHelperVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CalibrationHelperVector__SWIG_1")]
  public static extern IntPtr new_CalibrationHelperVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_getitemcopy")]
  public static extern IntPtr CalibrationHelperVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_getitem")]
  public static extern IntPtr CalibrationHelperVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_setitem")]
  public static extern void CalibrationHelperVector_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_AddRange")]
  public static extern void CalibrationHelperVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_GetRange")]
  public static extern IntPtr CalibrationHelperVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_Insert")]
  public static extern void CalibrationHelperVector_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_InsertRange")]
  public static extern void CalibrationHelperVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_RemoveAt")]
  public static extern void CalibrationHelperVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_RemoveRange")]
  public static extern void CalibrationHelperVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_Repeat")]
  public static extern IntPtr CalibrationHelperVector_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_Reverse__SWIG_0")]
  public static extern void CalibrationHelperVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_Reverse__SWIG_1")]
  public static extern void CalibrationHelperVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_SetRange")]
  public static extern void CalibrationHelperVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_Contains")]
  public static extern bool CalibrationHelperVector_Contains(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_IndexOf")]
  public static extern int CalibrationHelperVector_IndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_LastIndexOf")]
  public static extern int CalibrationHelperVector_LastIndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CalibrationHelperVector_Remove")]
  public static extern void CalibrationHelperVector_Remove(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CalibrationHelperVector")]
  public static extern void delete_CalibrationHelperVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ShortRateModel___deref__")]
  public static extern IntPtr ShortRateModel___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ShortRateModel_isNull")]
  public static extern bool ShortRateModel_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ShortRateModel_asObservable")]
  public static extern IntPtr ShortRateModel_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ShortRateModel")]
  public static extern IntPtr new_ShortRateModel();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ShortRateModel")]
  public static extern void delete_ShortRateModel(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ShortRateModel_parameters")]
  public static extern IntPtr ShortRateModel_parameters(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ShortRateModel_calibrate__SWIG_0")]
  public static extern void ShortRateModel_calibrate__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ShortRateModel_calibrate__SWIG_1")]
  public static extern void ShortRateModel_calibrate__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ShortRateModel_calibrate__SWIG_2")]
  public static extern void ShortRateModel_calibrate__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_HullWhite__SWIG_0")]
  public static extern IntPtr new_HullWhite__SWIG_0(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_HullWhite__SWIG_1")]
  public static extern IntPtr new_HullWhite__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_HullWhite__SWIG_2")]
  public static extern IntPtr new_HullWhite__SWIG_2(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_HullWhite")]
  public static extern void delete_HullWhite(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackKarasinski__SWIG_0")]
  public static extern IntPtr new_BlackKarasinski__SWIG_0(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackKarasinski__SWIG_1")]
  public static extern IntPtr new_BlackKarasinski__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackKarasinski__SWIG_2")]
  public static extern IntPtr new_BlackKarasinski__SWIG_2(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BlackKarasinski")]
  public static extern void delete_BlackKarasinski(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_G2__SWIG_0")]
  public static extern IntPtr new_G2__SWIG_0(HandleRef jarg1, double jarg2, double jarg3, double jarg4, double jarg5, double jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_G2__SWIG_1")]
  public static extern IntPtr new_G2__SWIG_1(HandleRef jarg1, double jarg2, double jarg3, double jarg4, double jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_G2__SWIG_2")]
  public static extern IntPtr new_G2__SWIG_2(HandleRef jarg1, double jarg2, double jarg3, double jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_G2__SWIG_3")]
  public static extern IntPtr new_G2__SWIG_3(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_G2__SWIG_4")]
  public static extern IntPtr new_G2__SWIG_4(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_G2__SWIG_5")]
  public static extern IntPtr new_G2__SWIG_5(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_G2")]
  public static extern void delete_G2(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_JamshidianSwaptionEngine")]
  public static extern IntPtr new_JamshidianSwaptionEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_JamshidianSwaptionEngine")]
  public static extern void delete_JamshidianSwaptionEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TreeSwaptionEngine__SWIG_0")]
  public static extern IntPtr new_TreeSwaptionEngine__SWIG_0(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TreeSwaptionEngine__SWIG_1")]
  public static extern IntPtr new_TreeSwaptionEngine__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_TreeSwaptionEngine")]
  public static extern void delete_TreeSwaptionEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_AnalyticCapFloorEngine")]
  public static extern IntPtr new_AnalyticCapFloorEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_AnalyticCapFloorEngine")]
  public static extern void delete_AnalyticCapFloorEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TreeCapFloorEngine__SWIG_0")]
  public static extern IntPtr new_TreeCapFloorEngine__SWIG_0(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TreeCapFloorEngine__SWIG_1")]
  public static extern IntPtr new_TreeCapFloorEngine__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_TreeCapFloorEngine")]
  public static extern void delete_TreeCapFloorEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_G2SwaptionEngine")]
  public static extern IntPtr new_G2SwaptionEngine(HandleRef jarg1, double jarg2, uint jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_G2SwaptionEngine")]
  public static extern void delete_G2SwaptionEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_samples")]
  public static extern uint Statistics_samples(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_weightSum")]
  public static extern double Statistics_weightSum(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_mean")]
  public static extern double Statistics_mean(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_variance")]
  public static extern double Statistics_variance(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_standardDeviation")]
  public static extern double Statistics_standardDeviation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_errorEstimate")]
  public static extern double Statistics_errorEstimate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_skewness")]
  public static extern double Statistics_skewness(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_kurtosis")]
  public static extern double Statistics_kurtosis(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_min")]
  public static extern double Statistics_min(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_max")]
  public static extern double Statistics_max(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_reset")]
  public static extern void Statistics_reset(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_add__SWIG_0")]
  public static extern void Statistics_add__SWIG_0(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_add__SWIG_1")]
  public static extern void Statistics_add__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_add__SWIG_2")]
  public static extern void Statistics_add__SWIG_2(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Statistics_add__SWIG_3")]
  public static extern void Statistics_add__SWIG_3(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Statistics")]
  public static extern IntPtr new_Statistics();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Statistics")]
  public static extern void delete_Statistics(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RiskStatistics_semiVariance")]
  public static extern double RiskStatistics_semiVariance(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RiskStatistics_semiDeviation")]
  public static extern double RiskStatistics_semiDeviation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RiskStatistics_downsideVariance")]
  public static extern double RiskStatistics_downsideVariance(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RiskStatistics_downsideDeviation")]
  public static extern double RiskStatistics_downsideDeviation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RiskStatistics_regret")]
  public static extern double RiskStatistics_regret(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RiskStatistics_potentialUpside")]
  public static extern double RiskStatistics_potentialUpside(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RiskStatistics_valueAtRisk")]
  public static extern double RiskStatistics_valueAtRisk(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RiskStatistics_expectedShortfall")]
  public static extern double RiskStatistics_expectedShortfall(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RiskStatistics_shortfall")]
  public static extern double RiskStatistics_shortfall(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RiskStatistics_averageShortfall")]
  public static extern double RiskStatistics_averageShortfall(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RiskStatistics")]
  public static extern IntPtr new_RiskStatistics();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_RiskStatistics")]
  public static extern void delete_RiskStatistics(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_MultipleStatistics")]
  public static extern IntPtr new_MultipleStatistics(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_size")]
  public static extern uint MultipleStatistics_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_samples")]
  public static extern uint MultipleStatistics_samples(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_weightSum")]
  public static extern double MultipleStatistics_weightSum(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_mean")]
  public static extern IntPtr MultipleStatistics_mean(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_variance")]
  public static extern IntPtr MultipleStatistics_variance(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_standardDeviation")]
  public static extern IntPtr MultipleStatistics_standardDeviation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_errorEstimate")]
  public static extern IntPtr MultipleStatistics_errorEstimate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_skewness")]
  public static extern IntPtr MultipleStatistics_skewness(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_kurtosis")]
  public static extern IntPtr MultipleStatistics_kurtosis(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_min")]
  public static extern IntPtr MultipleStatistics_min(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_max")]
  public static extern IntPtr MultipleStatistics_max(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_covariance")]
  public static extern IntPtr MultipleStatistics_covariance(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_correlation")]
  public static extern IntPtr MultipleStatistics_correlation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_reset")]
  public static extern void MultipleStatistics_reset(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_add__SWIG_0")]
  public static extern void MultipleStatistics_add__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_add__SWIG_1")]
  public static extern void MultipleStatistics_add__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_add__SWIG_2")]
  public static extern void MultipleStatistics_add__SWIG_2(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultipleStatistics_add__SWIG_3")]
  public static extern void MultipleStatistics_add__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_MultipleStatistics")]
  public static extern void delete_MultipleStatistics(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_SequenceStatistics")]
  public static extern IntPtr new_SequenceStatistics(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_size")]
  public static extern uint SequenceStatistics_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_samples")]
  public static extern uint SequenceStatistics_samples(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_weightSum")]
  public static extern double SequenceStatistics_weightSum(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_mean")]
  public static extern IntPtr SequenceStatistics_mean(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_variance")]
  public static extern IntPtr SequenceStatistics_variance(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_standardDeviation")]
  public static extern IntPtr SequenceStatistics_standardDeviation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_errorEstimate")]
  public static extern IntPtr SequenceStatistics_errorEstimate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_skewness")]
  public static extern IntPtr SequenceStatistics_skewness(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_kurtosis")]
  public static extern IntPtr SequenceStatistics_kurtosis(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_min")]
  public static extern IntPtr SequenceStatistics_min(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_max")]
  public static extern IntPtr SequenceStatistics_max(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_covariance")]
  public static extern IntPtr SequenceStatistics_covariance(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_correlation")]
  public static extern IntPtr SequenceStatistics_correlation(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_reset")]
  public static extern void SequenceStatistics_reset(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_add__SWIG_0")]
  public static extern void SequenceStatistics_add__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_add__SWIG_1")]
  public static extern void SequenceStatistics_add__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_add__SWIG_2")]
  public static extern void SequenceStatistics_add__SWIG_2(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SequenceStatistics_add__SWIG_3")]
  public static extern void SequenceStatistics_add__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_SequenceStatistics")]
  public static extern void delete_SequenceStatistics(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TimeBasket__SWIG_0")]
  public static extern IntPtr new_TimeBasket__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TimeBasket__SWIG_1")]
  public static extern IntPtr new_TimeBasket__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TimeBasket_size")]
  public static extern uint TimeBasket_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TimeBasket_rebin")]
  public static extern IntPtr TimeBasket_rebin(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_TimeBasket")]
  public static extern void delete_TimeBasket(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Swap")]
  public static extern IntPtr new_Swap(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Swap_startDate")]
  public static extern IntPtr Swap_startDate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Swap")]
  public static extern void delete_Swap(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete__VanillaSwap")]
  public static extern void delete__VanillaSwap(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaSwap_Receiver_get")]
  public static extern int VanillaSwap_Receiver_get();

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaSwap_Payer_get")]
  public static extern int VanillaSwap_Payer_get();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_VanillaSwap")]
  public static extern IntPtr new_VanillaSwap(int jarg1, double jarg2, HandleRef jarg3, double jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, double jarg8, HandleRef jarg9, HandleRef jarg10);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaSwap_fairRate")]
  public static extern double VanillaSwap_fairRate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaSwap_fairSpread")]
  public static extern double VanillaSwap_fairSpread(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaSwap_fixedLegBPS")]
  public static extern double VanillaSwap_fixedLegBPS(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaSwap_floatingLegBPS")]
  public static extern double VanillaSwap_floatingLegBPS(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_VanillaSwap")]
  public static extern void delete_VanillaSwap(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Swaption")]
  public static extern IntPtr new_Swaption(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Swaption")]
  public static extern void delete_Swaption(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackSwaptionEngine__SWIG_0")]
  public static extern IntPtr new_BlackSwaptionEngine__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackSwaptionEngine__SWIG_1")]
  public static extern IntPtr new_BlackSwaptionEngine__SWIG_1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BlackSwaptionEngine")]
  public static extern void delete_BlackSwaptionEngine(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Surface___deref__")]
  public static extern IntPtr Surface___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Surface_isNull")]
  public static extern bool Surface_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_Surface")]
  public static extern IntPtr new_Surface();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_Surface")]
  public static extern void delete_Surface(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Surface_apply")]
  public static extern double Surface_apply(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Surface_domain")]
  public static extern IntPtr Surface_domain(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_TestSurface")]
  public static extern IntPtr new_TestSurface();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_TestSurface")]
  public static extern void delete_TestSurface(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ConstantEstimator")]
  public static extern IntPtr new_ConstantEstimator(uint jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ConstantEstimator_calculate")]
  public static extern IntPtr ConstantEstimator_calculate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ConstantEstimator")]
  public static extern void delete_ConstantEstimator(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ParkinsonSigma")]
  public static extern IntPtr new_ParkinsonSigma(double jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ParkinsonSigma_calculate")]
  public static extern IntPtr ParkinsonSigma_calculate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ParkinsonSigma")]
  public static extern void delete_ParkinsonSigma(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GarmanKlassSigma1")]
  public static extern IntPtr new_GarmanKlassSigma1(double jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GarmanKlassSigma1_calculate")]
  public static extern IntPtr GarmanKlassSigma1_calculate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GarmanKlassSigma1")]
  public static extern void delete_GarmanKlassSigma1(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GarmanKlassSigma3")]
  public static extern IntPtr new_GarmanKlassSigma3(double jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GarmanKlassSigma3_calculate")]
  public static extern IntPtr GarmanKlassSigma3_calculate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GarmanKlassSigma3")]
  public static extern void delete_GarmanKlassSigma3(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GarmanKlassSigma4")]
  public static extern IntPtr new_GarmanKlassSigma4(double jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GarmanKlassSigma4_calculate")]
  public static extern IntPtr GarmanKlassSigma4_calculate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GarmanKlassSigma4")]
  public static extern void delete_GarmanKlassSigma4(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GarmanKlassSigma5")]
  public static extern IntPtr new_GarmanKlassSigma5(double jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GarmanKlassSigma5_calculate")]
  public static extern IntPtr GarmanKlassSigma5_calculate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GarmanKlassSigma5")]
  public static extern void delete_GarmanKlassSigma5(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_GarmanKlassSigma6")]
  public static extern IntPtr new_GarmanKlassSigma6(double jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GarmanKlassSigma6_calculate")]
  public static extern IntPtr GarmanKlassSigma6_calculate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_GarmanKlassSigma6")]
  public static extern void delete_GarmanKlassSigma6(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ZeroCurve__SWIG_0")]
  public static extern IntPtr new_ZeroCurve__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_ZeroCurve__SWIG_1")]
  public static extern IntPtr new_ZeroCurve__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ZeroCurve_dates")]
  public static extern IntPtr ZeroCurve_dates(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ZeroCurve_zeroRates")]
  public static extern IntPtr ZeroCurve_zeroRates(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ZeroCurve_nodes")]
  public static extern IntPtr ZeroCurve_nodes(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_ZeroCurve")]
  public static extern void delete_ZeroCurve(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_DiscreteGeometricASO")]
  public static extern IntPtr new_DiscreteGeometricASO(int jarg1, double jarg2, double jarg3, double jarg4, HandleRef jarg5, double jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DiscreteGeometricASO_value")]
  public static extern double DiscreteGeometricASO_value(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_DiscreteGeometricASO")]
  public static extern void delete_DiscreteGeometricASO(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_Clear")]
  public static extern void YieldTermStructureVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_Add")]
  public static extern void YieldTermStructureVector_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_size")]
  public static extern uint YieldTermStructureVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_capacity")]
  public static extern uint YieldTermStructureVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_reserve")]
  public static extern void YieldTermStructureVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_YieldTermStructureVector__SWIG_0")]
  public static extern IntPtr new_YieldTermStructureVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_YieldTermStructureVector__SWIG_1")]
  public static extern IntPtr new_YieldTermStructureVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_getitemcopy")]
  public static extern IntPtr YieldTermStructureVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_getitem")]
  public static extern IntPtr YieldTermStructureVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_setitem")]
  public static extern void YieldTermStructureVector_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_AddRange")]
  public static extern void YieldTermStructureVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_GetRange")]
  public static extern IntPtr YieldTermStructureVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_Insert")]
  public static extern void YieldTermStructureVector_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_InsertRange")]
  public static extern void YieldTermStructureVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_RemoveAt")]
  public static extern void YieldTermStructureVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_RemoveRange")]
  public static extern void YieldTermStructureVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_Repeat")]
  public static extern IntPtr YieldTermStructureVector_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_Reverse__SWIG_0")]
  public static extern void YieldTermStructureVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_Reverse__SWIG_1")]
  public static extern void YieldTermStructureVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_SetRange")]
  public static extern void YieldTermStructureVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_Contains")]
  public static extern bool YieldTermStructureVector_Contains(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_IndexOf")]
  public static extern int YieldTermStructureVector_IndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_LastIndexOf")]
  public static extern int YieldTermStructureVector_LastIndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_YieldTermStructureVector_Remove")]
  public static extern void YieldTermStructureVector_Remove(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_YieldTermStructureVector")]
  public static extern void delete_YieldTermStructureVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_Clear")]
  public static extern void BlackVolTermStructureVector_Clear(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_Add")]
  public static extern void BlackVolTermStructureVector_Add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_size")]
  public static extern uint BlackVolTermStructureVector_size(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_capacity")]
  public static extern uint BlackVolTermStructureVector_capacity(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_reserve")]
  public static extern void BlackVolTermStructureVector_reserve(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackVolTermStructureVector__SWIG_0")]
  public static extern IntPtr new_BlackVolTermStructureVector__SWIG_0();

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_BlackVolTermStructureVector__SWIG_1")]
  public static extern IntPtr new_BlackVolTermStructureVector__SWIG_1(int jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_getitemcopy")]
  public static extern IntPtr BlackVolTermStructureVector_getitemcopy(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_getitem")]
  public static extern IntPtr BlackVolTermStructureVector_getitem(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_setitem")]
  public static extern void BlackVolTermStructureVector_setitem(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_AddRange")]
  public static extern void BlackVolTermStructureVector_AddRange(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_GetRange")]
  public static extern IntPtr BlackVolTermStructureVector_GetRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_Insert")]
  public static extern void BlackVolTermStructureVector_Insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_InsertRange")]
  public static extern void BlackVolTermStructureVector_InsertRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_RemoveAt")]
  public static extern void BlackVolTermStructureVector_RemoveAt(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_RemoveRange")]
  public static extern void BlackVolTermStructureVector_RemoveRange(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_Repeat")]
  public static extern IntPtr BlackVolTermStructureVector_Repeat(HandleRef jarg1, int jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_Reverse__SWIG_0")]
  public static extern void BlackVolTermStructureVector_Reverse__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_Reverse__SWIG_1")]
  public static extern void BlackVolTermStructureVector_Reverse__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_SetRange")]
  public static extern void BlackVolTermStructureVector_SetRange(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_Contains")]
  public static extern bool BlackVolTermStructureVector_Contains(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_IndexOf")]
  public static extern int BlackVolTermStructureVector_IndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_LastIndexOf")]
  public static extern int BlackVolTermStructureVector_LastIndexOf(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVolTermStructureVector_Remove")]
  public static extern void BlackVolTermStructureVector_Remove(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_BlackVolTermStructureVector")]
  public static extern void delete_BlackVolTermStructureVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_McDiscreteArithmeticASO__SWIG_0")]
  public static extern IntPtr new_McDiscreteArithmeticASO__SWIG_0(int jarg1, double jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, bool jarg7, int jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_McDiscreteArithmeticASO__SWIG_1")]
  public static extern IntPtr new_McDiscreteArithmeticASO__SWIG_1(int jarg1, double jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, bool jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McDiscreteArithmeticASO_value__SWIG_0")]
  public static extern double McDiscreteArithmeticASO_value__SWIG_0(HandleRef jarg1, double jarg2, uint jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McDiscreteArithmeticASO_value__SWIG_1")]
  public static extern double McDiscreteArithmeticASO_value__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McDiscreteArithmeticASO_valueWithSamples")]
  public static extern double McDiscreteArithmeticASO_valueWithSamples(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McDiscreteArithmeticASO_errorEstimate")]
  public static extern double McDiscreteArithmeticASO_errorEstimate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_McDiscreteArithmeticASO")]
  public static extern void delete_McDiscreteArithmeticASO(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_McMaxBasket__SWIG_0")]
  public static extern IntPtr new_McMaxBasket__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, double jarg6, int jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_McMaxBasket__SWIG_1")]
  public static extern IntPtr new_McMaxBasket__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, double jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McMaxBasket_value__SWIG_0")]
  public static extern double McMaxBasket_value__SWIG_0(HandleRef jarg1, double jarg2, uint jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McMaxBasket_value__SWIG_1")]
  public static extern double McMaxBasket_value__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McMaxBasket_valueWithSamples")]
  public static extern double McMaxBasket_valueWithSamples(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McMaxBasket_errorEstimate")]
  public static extern double McMaxBasket_errorEstimate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_McMaxBasket")]
  public static extern void delete_McMaxBasket(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_McHimalaya__SWIG_0")]
  public static extern IntPtr new_McHimalaya__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, double jarg6, HandleRef jarg7, int jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_McHimalaya__SWIG_1")]
  public static extern IntPtr new_McHimalaya__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, double jarg6, HandleRef jarg7);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McHimalaya_value__SWIG_0")]
  public static extern double McHimalaya_value__SWIG_0(HandleRef jarg1, double jarg2, uint jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McHimalaya_value__SWIG_1")]
  public static extern double McHimalaya_value__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McHimalaya_valueWithSamples")]
  public static extern double McHimalaya_valueWithSamples(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McHimalaya_errorEstimate")]
  public static extern double McHimalaya_errorEstimate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_McHimalaya")]
  public static extern void delete_McHimalaya(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_McEverest__SWIG_0")]
  public static extern IntPtr new_McEverest__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, double jarg5, int jarg6);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_McEverest__SWIG_1")]
  public static extern IntPtr new_McEverest__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, double jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McEverest_value__SWIG_0")]
  public static extern double McEverest_value__SWIG_0(HandleRef jarg1, double jarg2, uint jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McEverest_value__SWIG_1")]
  public static extern double McEverest_value__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McEverest_valueWithSamples")]
  public static extern double McEverest_valueWithSamples(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McEverest_errorEstimate")]
  public static extern double McEverest_errorEstimate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_McEverest")]
  public static extern void delete_McEverest(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_McPagoda__SWIG_0")]
  public static extern IntPtr new_McPagoda__SWIG_0(HandleRef jarg1, double jarg2, double jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8, int jarg9);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_McPagoda__SWIG_1")]
  public static extern IntPtr new_McPagoda__SWIG_1(HandleRef jarg1, double jarg2, double jarg3, HandleRef jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7, HandleRef jarg8);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McPagoda_value__SWIG_0")]
  public static extern double McPagoda_value__SWIG_0(HandleRef jarg1, double jarg2, uint jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McPagoda_value__SWIG_1")]
  public static extern double McPagoda_value__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McPagoda_valueWithSamples")]
  public static extern double McPagoda_valueWithSamples(HandleRef jarg1, uint jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_McPagoda_errorEstimate")]
  public static extern double McPagoda_errorEstimate(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_McPagoda")]
  public static extern void delete_McPagoda(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapVolatilityStructure___deref__")]
  public static extern IntPtr CapVolatilityStructure___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapVolatilityStructure_isNull")]
  public static extern bool CapVolatilityStructure_isNull(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapVolatilityStructure_asObservable")]
  public static extern IntPtr CapVolatilityStructure_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapVolatilityStructure")]
  public static extern IntPtr new_CapVolatilityStructure();

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CapVolatilityStructure")]
  public static extern void delete_CapVolatilityStructure(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapVolatilityStructure_volatility__SWIG_0")]
  public static extern double CapVolatilityStructure_volatility__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapVolatilityStructure_volatility__SWIG_1")]
  public static extern double CapVolatilityStructure_volatility__SWIG_1(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapVolatilityStructureHandle__SWIG_0")]
  public static extern IntPtr new_CapVolatilityStructureHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapVolatilityStructureHandle__SWIG_1")]
  public static extern IntPtr new_CapVolatilityStructureHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapVolatilityStructureHandle___deref__")]
  public static extern IntPtr CapVolatilityStructureHandle___deref__(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapVolatilityStructureHandle_empty")]
  public static extern bool CapVolatilityStructureHandle_empty(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapVolatilityStructureHandle_asObservable")]
  public static extern IntPtr CapVolatilityStructureHandle_asObservable(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CapVolatilityStructureHandle")]
  public static extern void delete_CapVolatilityStructureHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapVolatilityStructureHandle_volatility__SWIG_0")]
  public static extern double CapVolatilityStructureHandle_volatility__SWIG_0(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapVolatilityStructureHandle_volatility__SWIG_1")]
  public static extern double CapVolatilityStructureHandle_volatility__SWIG_1(HandleRef jarg1, double jarg2, double jarg3);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableCapVolatilityStructureHandle__SWIG_0")]
  public static extern IntPtr new_RelinkableCapVolatilityStructureHandle__SWIG_0(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_RelinkableCapVolatilityStructureHandle__SWIG_1")]
  public static extern IntPtr new_RelinkableCapVolatilityStructureHandle__SWIG_1();

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableCapVolatilityStructureHandle_linkTo")]
  public static extern void RelinkableCapVolatilityStructureHandle_linkTo(HandleRef jarg1, HandleRef jarg2);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_RelinkableCapVolatilityStructureHandle")]
  public static extern void delete_RelinkableCapVolatilityStructureHandle(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapVolatilityVector__SWIG_0")]
  public static extern IntPtr new_CapVolatilityVector__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("NQuantLibc", EntryPoint="CSharp_new_CapVolatilityVector__SWIG_1")]
  public static extern IntPtr new_CapVolatilityVector__SWIG_1(int jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("NQuantLibc", EntryPoint="CSharp_delete_CapVolatilityVector")]
  public static extern void delete_CapVolatilityVector(HandleRef jarg1);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuropeanExerciseUpcast")]
  public static extern IntPtr EuropeanExerciseUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_AmericanExerciseUpcast")]
  public static extern IntPtr AmericanExerciseUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BermudanExerciseUpcast")]
  public static extern IntPtr BermudanExerciseUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DisposableArrayUpcast")]
  public static extern IntPtr DisposableArrayUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableQuoteHandleUpcast")]
  public static extern IntPtr RelinkableQuoteHandleUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SimpleQuoteUpcast")]
  public static extern IntPtr SimpleQuoteUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Actual360Upcast")]
  public static extern IntPtr Actual360Upcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Actual365FixedUpcast")]
  public static extern IntPtr Actual365FixedUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Thirty360Upcast")]
  public static extern IntPtr Thirty360Upcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ActualActualUpcast")]
  public static extern IntPtr ActualActualUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_OneDayCounterUpcast")]
  public static extern IntPtr OneDayCounterUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SimpleDayCounterUpcast")]
  public static extern IntPtr SimpleDayCounterUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ArgentinaUpcast")]
  public static extern IntPtr ArgentinaUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_AustraliaUpcast")]
  public static extern IntPtr AustraliaUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BrazilUpcast")]
  public static extern IntPtr BrazilUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CanadaUpcast")]
  public static extern IntPtr CanadaUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ChinaUpcast")]
  public static extern IntPtr ChinaUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CzechRepublicUpcast")]
  public static extern IntPtr CzechRepublicUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DenmarkUpcast")]
  public static extern IntPtr DenmarkUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FinlandUpcast")]
  public static extern IntPtr FinlandUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GermanyUpcast")]
  public static extern IntPtr GermanyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_HongKongUpcast")]
  public static extern IntPtr HongKongUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_HungaryUpcast")]
  public static extern IntPtr HungaryUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IcelandUpcast")]
  public static extern IntPtr IcelandUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IndiaUpcast")]
  public static extern IntPtr IndiaUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IndonesiaUpcast")]
  public static extern IntPtr IndonesiaUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ItalyUpcast")]
  public static extern IntPtr ItalyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_JapanUpcast")]
  public static extern IntPtr JapanUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MexicoUpcast")]
  public static extern IntPtr MexicoUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NewZealandUpcast")]
  public static extern IntPtr NewZealandUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NorwayUpcast")]
  public static extern IntPtr NorwayUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PolandUpcast")]
  public static extern IntPtr PolandUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SaudiArabiaUpcast")]
  public static extern IntPtr SaudiArabiaUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SingaporeUpcast")]
  public static extern IntPtr SingaporeUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SlovakiaUpcast")]
  public static extern IntPtr SlovakiaUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SouthAfricaUpcast")]
  public static extern IntPtr SouthAfricaUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SouthKoreaUpcast")]
  public static extern IntPtr SouthKoreaUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwedenUpcast")]
  public static extern IntPtr SwedenUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwitzerlandUpcast")]
  public static extern IntPtr SwitzerlandUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TaiwanUpcast")]
  public static extern IntPtr TaiwanUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TARGETUpcast")]
  public static extern IntPtr TARGETUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TurkeyUpcast")]
  public static extern IntPtr TurkeyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_UkraineUpcast")]
  public static extern IntPtr UkraineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_UnitedKingdomUpcast")]
  public static extern IntPtr UnitedKingdomUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_UnitedStatesUpcast")]
  public static extern IntPtr UnitedStatesUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NullCalendarUpcast")]
  public static extern IntPtr NullCalendarUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_JointCalendarUpcast")]
  public static extern IntPtr JointCalendarUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_UpRoundingUpcast")]
  public static extern IntPtr UpRoundingUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DownRoundingUpcast")]
  public static extern IntPtr DownRoundingUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ClosestRoundingUpcast")]
  public static extern IntPtr ClosestRoundingUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CeilingTruncationUpcast")]
  public static extern IntPtr CeilingTruncationUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FloorTruncationUpcast")]
  public static extern IntPtr FloorTruncationUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ARSCurrencyUpcast")]
  public static extern IntPtr ARSCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ATSCurrencyUpcast")]
  public static extern IntPtr ATSCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_AUDCurrencyUpcast")]
  public static extern IntPtr AUDCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BDTCurrencyUpcast")]
  public static extern IntPtr BDTCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BEFCurrencyUpcast")]
  public static extern IntPtr BEFCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BGLCurrencyUpcast")]
  public static extern IntPtr BGLCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BRLCurrencyUpcast")]
  public static extern IntPtr BRLCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BYRCurrencyUpcast")]
  public static extern IntPtr BYRCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CADCurrencyUpcast")]
  public static extern IntPtr CADCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CHFCurrencyUpcast")]
  public static extern IntPtr CHFCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CLPCurrencyUpcast")]
  public static extern IntPtr CLPCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CNYCurrencyUpcast")]
  public static extern IntPtr CNYCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_COPCurrencyUpcast")]
  public static extern IntPtr COPCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CYPCurrencyUpcast")]
  public static extern IntPtr CYPCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CZKCurrencyUpcast")]
  public static extern IntPtr CZKCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DEMCurrencyUpcast")]
  public static extern IntPtr DEMCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DKKCurrencyUpcast")]
  public static extern IntPtr DKKCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EEKCurrencyUpcast")]
  public static extern IntPtr EEKCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ESPCurrencyUpcast")]
  public static extern IntPtr ESPCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURCurrencyUpcast")]
  public static extern IntPtr EURCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FIMCurrencyUpcast")]
  public static extern IntPtr FIMCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FRFCurrencyUpcast")]
  public static extern IntPtr FRFCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GBPCurrencyUpcast")]
  public static extern IntPtr GBPCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GRDCurrencyUpcast")]
  public static extern IntPtr GRDCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_HKDCurrencyUpcast")]
  public static extern IntPtr HKDCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_HUFCurrencyUpcast")]
  public static extern IntPtr HUFCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IEPCurrencyUpcast")]
  public static extern IntPtr IEPCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ILSCurrencyUpcast")]
  public static extern IntPtr ILSCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_INRCurrencyUpcast")]
  public static extern IntPtr INRCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IQDCurrencyUpcast")]
  public static extern IntPtr IQDCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IRRCurrencyUpcast")]
  public static extern IntPtr IRRCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ISKCurrencyUpcast")]
  public static extern IntPtr ISKCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ITLCurrencyUpcast")]
  public static extern IntPtr ITLCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_JPYCurrencyUpcast")]
  public static extern IntPtr JPYCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_KRWCurrencyUpcast")]
  public static extern IntPtr KRWCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_KWDCurrencyUpcast")]
  public static extern IntPtr KWDCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LTLCurrencyUpcast")]
  public static extern IntPtr LTLCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LUFCurrencyUpcast")]
  public static extern IntPtr LUFCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LVLCurrencyUpcast")]
  public static extern IntPtr LVLCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MTLCurrencyUpcast")]
  public static extern IntPtr MTLCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MXNCurrencyUpcast")]
  public static extern IntPtr MXNCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NLGCurrencyUpcast")]
  public static extern IntPtr NLGCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NOKCurrencyUpcast")]
  public static extern IntPtr NOKCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NPRCurrencyUpcast")]
  public static extern IntPtr NPRCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NZDCurrencyUpcast")]
  public static extern IntPtr NZDCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PKRCurrencyUpcast")]
  public static extern IntPtr PKRCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PLNCurrencyUpcast")]
  public static extern IntPtr PLNCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PTECurrencyUpcast")]
  public static extern IntPtr PTECurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ROLCurrencyUpcast")]
  public static extern IntPtr ROLCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RONCurrencyUpcast")]
  public static extern IntPtr RONCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SARCurrencyUpcast")]
  public static extern IntPtr SARCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SEKCurrencyUpcast")]
  public static extern IntPtr SEKCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SGDCurrencyUpcast")]
  public static extern IntPtr SGDCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SITCurrencyUpcast")]
  public static extern IntPtr SITCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SKKCurrencyUpcast")]
  public static extern IntPtr SKKCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_THBCurrencyUpcast")]
  public static extern IntPtr THBCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TRLCurrencyUpcast")]
  public static extern IntPtr TRLCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TRYCurrencyUpcast")]
  public static extern IntPtr TRYCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TTDCurrencyUpcast")]
  public static extern IntPtr TTDCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TWDCurrencyUpcast")]
  public static extern IntPtr TWDCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_USDCurrencyUpcast")]
  public static extern IntPtr USDCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VEBCurrencyUpcast")]
  public static extern IntPtr VEBCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ZARCurrencyUpcast")]
  public static extern IntPtr ZARCurrencyUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableYieldTermStructureHandleUpcast")]
  public static extern IntPtr RelinkableYieldTermStructureHandleUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ImpliedTermStructureUpcast")]
  public static extern IntPtr ImpliedTermStructureUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ZeroSpreadedTermStructureUpcast")]
  public static extern IntPtr ZeroSpreadedTermStructureUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ForwardSpreadedTermStructureUpcast")]
  public static extern IntPtr ForwardSpreadedTermStructureUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FlatForwardUpcast")]
  public static extern IntPtr FlatForwardUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableBlackVolTermStructureHandleUpcast")]
  public static extern IntPtr RelinkableBlackVolTermStructureHandleUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableLocalVolTermStructureHandleUpcast")]
  public static extern IntPtr RelinkableLocalVolTermStructureHandleUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableCapletVolatilityStructureHandleUpcast")]
  public static extern IntPtr RelinkableCapletVolatilityStructureHandleUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableSwaptionVolatilityStructureHandleUpcast")]
  public static extern IntPtr RelinkableSwaptionVolatilityStructureHandleUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackConstantVolUpcast")]
  public static extern IntPtr BlackConstantVolUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackVarianceSurfaceUpcast")]
  public static extern IntPtr BlackVarianceSurfaceUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_LocalConstantVolUpcast")]
  public static extern IntPtr LocalConstantVolUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapletConstantVolatilityUpcast")]
  public static extern IntPtr CapletConstantVolatilityUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionVolatilityMatrixUpcast")]
  public static extern IntPtr SwaptionVolatilityMatrixUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcess1DUpcast")]
  public static extern IntPtr StochasticProcess1DUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GeneralizedBlackScholesPressUpcast")]
  public static extern IntPtr GeneralizedBlackScholesPressUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackScholesProcessUpcast")]
  public static extern IntPtr BlackScholesProcessUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackScholesMertonProcessUpcast")]
  public static extern IntPtr BlackScholesMertonProcessUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackProcessUpcast")]
  public static extern IntPtr BlackProcessUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GarmanKohlagenProcessUpcast")]
  public static extern IntPtr GarmanKohlagenProcessUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Merton76ProcessUpcast")]
  public static extern IntPtr Merton76ProcessUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StochasticProcessArrayUpcast")]
  public static extern IntPtr StochasticProcessArrayUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StockUpcast")]
  public static extern IntPtr StockUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CompositeInstrumentUpcast")]
  public static extern IntPtr CompositeInstrumentUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaOptionUpcast")]
  public static extern IntPtr VanillaOptionUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuropeanOptionUpcast")]
  public static extern IntPtr EuropeanOptionUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ForwardVanillaOptionUpcast")]
  public static extern IntPtr ForwardVanillaOptionUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuantoVanillaOptionUpcast")]
  public static extern IntPtr QuantoVanillaOptionUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuantoForwardVanillaOptionUpcast")]
  public static extern IntPtr QuantoForwardVanillaOptionUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MultiAssetOptionUpcast")]
  public static extern IntPtr MultiAssetOptionUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_AnalyticEuropeanEngineUpcast")]
  public static extern IntPtr AnalyticEuropeanEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IntegralEngineUpcast")]
  public static extern IntPtr IntegralEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FDEuropeanEngineUpcast")]
  public static extern IntPtr FDEuropeanEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BinomialVanillaEngineUpcast")]
  public static extern IntPtr BinomialVanillaEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MCEuropeanEngineUpcast")]
  public static extern IntPtr MCEuropeanEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FDAmericanEngineUpcast")]
  public static extern IntPtr FDAmericanEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FDShoutEngineUpcast")]
  public static extern IntPtr FDShoutEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BaroneAdesiWhaleyEngineUpcast")]
  public static extern IntPtr BaroneAdesiWhaleyEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BjerksundStenslandEngineUpcast")]
  public static extern IntPtr BjerksundStenslandEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_AnalyticDigitalAmericanEngineUpcast")]
  public static extern IntPtr AnalyticDigitalAmericanEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DividendVanillaOptionUpcast")]
  public static extern IntPtr DividendVanillaOptionUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_AnalyticDividendEuropeanEngineUpcast")]
  public static extern IntPtr AnalyticDividendEuropeanEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FDDividendEuropeanEngineUpcast")]
  public static extern IntPtr FDDividendEuropeanEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FDDividendAmericanEngineUpcast")]
  public static extern IntPtr FDDividendAmericanEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BarrierOptionUpcast")]
  public static extern IntPtr BarrierOptionUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_AnalyticBarrierEngineUpcast")]
  public static extern IntPtr AnalyticBarrierEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MCBarrierEngineUpcast")]
  public static extern IntPtr MCBarrierEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ForwardVanillaEngineUpcast")]
  public static extern IntPtr ForwardVanillaEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuantoVanillaEngineUpcast")]
  public static extern IntPtr QuantoVanillaEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_QuantoForwardVanillaEngineUpcast")]
  public static extern IntPtr QuantoForwardVanillaEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PlainVanillaPayoffUpcast")]
  public static extern IntPtr PlainVanillaPayoffUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PercentageStrikePayoffUpcast")]
  public static extern IntPtr PercentageStrikePayoffUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CashOrNothingPayoffUpcast")]
  public static extern IntPtr CashOrNothingPayoffUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_AssetOrNothingPayoffUpcast")]
  public static extern IntPtr AssetOrNothingPayoffUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SuperSharePayoffUpcast")]
  public static extern IntPtr SuperSharePayoffUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GapPayoffUpcast")]
  public static extern IntPtr GapPayoffUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BasketPayoffUpcast")]
  public static extern IntPtr BasketPayoffUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MinBasketPayoffUpcast")]
  public static extern IntPtr MinBasketPayoffUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MaxBasketPayoffUpcast")]
  public static extern IntPtr MaxBasketPayoffUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_AverageBasketPayoffUpcast")]
  public static extern IntPtr AverageBasketPayoffUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BasketOptionUpcast")]
  public static extern IntPtr BasketOptionUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MCBasketEngineUpcast")]
  public static extern IntPtr MCBasketEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_MCAmericanBasketEngineUpcast")]
  public static extern IntPtr MCAmericanBasketEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_StulzEngineUpcast")]
  public static extern IntPtr StulzEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_InterestRateIndexUpcast")]
  public static extern IntPtr InterestRateIndexUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IborIndexUpcast")]
  public static extern IntPtr IborIndexUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwapIndexUpcast")]
  public static extern IntPtr SwapIndexUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_AUDLiborUpcast")]
  public static extern IntPtr AUDLiborUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CADLiborUpcast")]
  public static extern IntPtr CADLiborUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CdorUpcast")]
  public static extern IntPtr CdorUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CHFLiborUpcast")]
  public static extern IntPtr CHFLiborUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DKKLiborUpcast")]
  public static extern IntPtr DKKLiborUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborUpcast")]
  public static extern IntPtr EuriborUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSWUpcast")]
  public static extern IntPtr EuriborSWUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor2WUpcast")]
  public static extern IntPtr Euribor2WUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor3WUpcast")]
  public static extern IntPtr Euribor3WUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor1MUpcast")]
  public static extern IntPtr Euribor1MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor2MUpcast")]
  public static extern IntPtr Euribor2MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor3MUpcast")]
  public static extern IntPtr Euribor3MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor4MUpcast")]
  public static extern IntPtr Euribor4MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor5MUpcast")]
  public static extern IntPtr Euribor5MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor6MUpcast")]
  public static extern IntPtr Euribor6MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor7MUpcast")]
  public static extern IntPtr Euribor7MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor8MUpcast")]
  public static extern IntPtr Euribor8MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor9MUpcast")]
  public static extern IntPtr Euribor9MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor10MUpcast")]
  public static extern IntPtr Euribor10MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor11MUpcast")]
  public static extern IntPtr Euribor11MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor1YUpcast")]
  public static extern IntPtr Euribor1YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365Upcast")]
  public static extern IntPtr Euribor365Upcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_SWUpcast")]
  public static extern IntPtr Euribor365_SWUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_2WUpcast")]
  public static extern IntPtr Euribor365_2WUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_3WUpcast")]
  public static extern IntPtr Euribor365_3WUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_1MUpcast")]
  public static extern IntPtr Euribor365_1MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_2MUpcast")]
  public static extern IntPtr Euribor365_2MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_3MUpcast")]
  public static extern IntPtr Euribor365_3MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_4MUpcast")]
  public static extern IntPtr Euribor365_4MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_5MUpcast")]
  public static extern IntPtr Euribor365_5MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_6MUpcast")]
  public static extern IntPtr Euribor365_6MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_7MUpcast")]
  public static extern IntPtr Euribor365_7MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_8MUpcast")]
  public static extern IntPtr Euribor365_8MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_9MUpcast")]
  public static extern IntPtr Euribor365_9MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_10MUpcast")]
  public static extern IntPtr Euribor365_10MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_11MUpcast")]
  public static extern IntPtr Euribor365_11MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_Euribor365_1YUpcast")]
  public static extern IntPtr Euribor365_1YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLiborUpcast")]
  public static extern IntPtr EURLiborUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLiborSWUpcast")]
  public static extern IntPtr EURLiborSWUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLibor2WUpcast")]
  public static extern IntPtr EURLibor2WUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLibor1MUpcast")]
  public static extern IntPtr EURLibor1MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLibor2MUpcast")]
  public static extern IntPtr EURLibor2MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLibor3MUpcast")]
  public static extern IntPtr EURLibor3MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLibor4MUpcast")]
  public static extern IntPtr EURLibor4MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLibor5MUpcast")]
  public static extern IntPtr EURLibor5MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLibor6MUpcast")]
  public static extern IntPtr EURLibor6MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLibor7MUpcast")]
  public static extern IntPtr EURLibor7MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLibor8MUpcast")]
  public static extern IntPtr EURLibor8MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLibor9MUpcast")]
  public static extern IntPtr EURLibor9MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLibor10MUpcast")]
  public static extern IntPtr EURLibor10MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLibor11MUpcast")]
  public static extern IntPtr EURLibor11MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EURLibor1YUpcast")]
  public static extern IntPtr EURLibor1YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_GBPLiborUpcast")]
  public static extern IntPtr GBPLiborUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_JibarUpcast")]
  public static extern IntPtr JibarUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_JPYLiborUpcast")]
  public static extern IntPtr JPYLiborUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NZDLiborUpcast")]
  public static extern IntPtr NZDLiborUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TiborUpcast")]
  public static extern IntPtr TiborUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TRLiborUpcast")]
  public static extern IntPtr TRLiborUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_USDLiborUpcast")]
  public static extern IntPtr USDLiborUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ZiborUpcast")]
  public static extern IntPtr ZiborUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixAvs3MUpcast")]
  public static extern IntPtr EuriborSwapFixAvs3MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixAvs6MUpcast")]
  public static extern IntPtr EuriborSwapFixAvs6MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA1YUpcast")]
  public static extern IntPtr EuriborSwapFixA1YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA2YUpcast")]
  public static extern IntPtr EuriborSwapFixA2YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA3YUpcast")]
  public static extern IntPtr EuriborSwapFixA3YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA4YUpcast")]
  public static extern IntPtr EuriborSwapFixA4YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA5YUpcast")]
  public static extern IntPtr EuriborSwapFixA5YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA6YUpcast")]
  public static extern IntPtr EuriborSwapFixA6YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA7YUpcast")]
  public static extern IntPtr EuriborSwapFixA7YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA8YUpcast")]
  public static extern IntPtr EuriborSwapFixA8YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA9YUpcast")]
  public static extern IntPtr EuriborSwapFixA9YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA10YUpcast")]
  public static extern IntPtr EuriborSwapFixA10YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA12YUpcast")]
  public static extern IntPtr EuriborSwapFixA12YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA15YUpcast")]
  public static extern IntPtr EuriborSwapFixA15YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA20YUpcast")]
  public static extern IntPtr EuriborSwapFixA20YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA25YUpcast")]
  public static extern IntPtr EuriborSwapFixA25YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixA30YUpcast")]
  public static extern IntPtr EuriborSwapFixA30YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFRvs3MUpcast")]
  public static extern IntPtr EuriborSwapFixIFRvs3MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFRvs6MUpcast")]
  public static extern IntPtr EuriborSwapFixIFRvs6MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR1YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR1YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR2YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR2YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR3YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR3YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR4YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR4YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR5YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR5YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR6YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR6YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR7YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR7YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR8YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR8YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR9YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR9YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR10YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR10YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR12YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR12YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR15YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR15YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR20YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR20YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR25YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR25YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EuriborSwapFixIFR30YUpcast")]
  public static extern IntPtr EuriborSwapFixIFR30YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixAvs3MUpcast")]
  public static extern IntPtr EurliborSwapFixAvs3MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixAvs6MUpcast")]
  public static extern IntPtr EurliborSwapFixAvs6MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA1YUpcast")]
  public static extern IntPtr EurliborSwapFixA1YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA2YUpcast")]
  public static extern IntPtr EurliborSwapFixA2YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA3YUpcast")]
  public static extern IntPtr EurliborSwapFixA3YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA4YUpcast")]
  public static extern IntPtr EurliborSwapFixA4YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA5YUpcast")]
  public static extern IntPtr EurliborSwapFixA5YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA6YUpcast")]
  public static extern IntPtr EurliborSwapFixA6YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA7YUpcast")]
  public static extern IntPtr EurliborSwapFixA7YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA8YUpcast")]
  public static extern IntPtr EurliborSwapFixA8YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA9YUpcast")]
  public static extern IntPtr EurliborSwapFixA9YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA10YUpcast")]
  public static extern IntPtr EurliborSwapFixA10YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA12YUpcast")]
  public static extern IntPtr EurliborSwapFixA12YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA15YUpcast")]
  public static extern IntPtr EurliborSwapFixA15YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA20YUpcast")]
  public static extern IntPtr EurliborSwapFixA20YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA25YUpcast")]
  public static extern IntPtr EurliborSwapFixA25YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixA30YUpcast")]
  public static extern IntPtr EurliborSwapFixA30YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixBvs3MUpcast")]
  public static extern IntPtr EurliborSwapFixBvs3MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixBvs6MUpcast")]
  public static extern IntPtr EurliborSwapFixBvs6MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB1YUpcast")]
  public static extern IntPtr EurliborSwapFixB1YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB2YUpcast")]
  public static extern IntPtr EurliborSwapFixB2YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB3YUpcast")]
  public static extern IntPtr EurliborSwapFixB3YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB4YUpcast")]
  public static extern IntPtr EurliborSwapFixB4YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB5YUpcast")]
  public static extern IntPtr EurliborSwapFixB5YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB6YUpcast")]
  public static extern IntPtr EurliborSwapFixB6YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB7YUpcast")]
  public static extern IntPtr EurliborSwapFixB7YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB8YUpcast")]
  public static extern IntPtr EurliborSwapFixB8YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB9YUpcast")]
  public static extern IntPtr EurliborSwapFixB9YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB10YUpcast")]
  public static extern IntPtr EurliborSwapFixB10YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB12YUpcast")]
  public static extern IntPtr EurliborSwapFixB12YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB15YUpcast")]
  public static extern IntPtr EurliborSwapFixB15YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB20YUpcast")]
  public static extern IntPtr EurliborSwapFixB20YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB25YUpcast")]
  public static extern IntPtr EurliborSwapFixB25YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixB30YUpcast")]
  public static extern IntPtr EurliborSwapFixB30YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFRvs3MUpcast")]
  public static extern IntPtr EurliborSwapFixIFRvs3MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFRvs6MUpcast")]
  public static extern IntPtr EurliborSwapFixIFRvs6MUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR1YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR1YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR2YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR2YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR3YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR3YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR4YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR4YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR5YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR5YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR6YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR6YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR7YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR7YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR8YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR8YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR9YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR9YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR10YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR10YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR12YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR12YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR15YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR15YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR20YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR20YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR25YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR25YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_EurliborSwapFixIFR30YUpcast")]
  public static extern IntPtr EurliborSwapFixIFR30YUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SimpleCashFlowUpcast")]
  public static extern IntPtr SimpleCashFlowUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FixedRateCouponUpcast")]
  public static extern IntPtr FixedRateCouponUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_IborCouponUpcast")]
  public static extern IntPtr IborCouponUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FloatingRateCouponUpcast")]
  public static extern IntPtr FloatingRateCouponUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BondUpcast")]
  public static extern IntPtr BondUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ZeroCouponBondUpcast")]
  public static extern IntPtr ZeroCouponBondUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FixedRateBondUpcast")]
  public static extern IntPtr FixedRateBondUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FloatingRateBondUpcast")]
  public static extern IntPtr FloatingRateBondUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SoftCallabilityUpcast")]
  public static extern IntPtr SoftCallabilityUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapFloorUpcast")]
  public static extern IntPtr CapFloorUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapUpcast")]
  public static extern IntPtr CapUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FloorUpcast")]
  public static extern IntPtr FloorUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CollarUpcast")]
  public static extern IntPtr CollarUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackCapFloorEngineUpcast")]
  public static extern IntPtr BlackCapFloorEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CompoundForwardUpcast")]
  public static extern IntPtr CompoundForwardUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FixedDividendUpcast")]
  public static extern IntPtr FixedDividendUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FractionalDividendUpcast")]
  public static extern IntPtr FractionalDividendUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ConvertibleZeroCouponBondUpcast")]
  public static extern IntPtr ConvertibleZeroCouponBondUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ConvertibleFixedCouponBondUpcast")]
  public static extern IntPtr ConvertibleFixedCouponBondUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ConvertibleFloatingRateBondUpcast")]
  public static extern IntPtr ConvertibleFloatingRateBondUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BinomialConvertibleEngineUpcast")]
  public static extern IntPtr BinomialConvertibleEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DiscountCurveUpcast")]
  public static extern IntPtr DiscountCurveUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ForwardCurveUpcast")]
  public static extern IntPtr ForwardCurveUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NeumannBCUpcast")]
  public static extern IntPtr NeumannBCUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DirichletBCUpcast")]
  public static extern IntPtr DirichletBCUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DPlusUpcast")]
  public static extern IntPtr DPlusUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DMinusUpcast")]
  public static extern IntPtr DMinusUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DZeroUpcast")]
  public static extern IntPtr DZeroUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DPlusDMinusUpcast")]
  public static extern IntPtr DPlusDMinusUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BoundaryConstraintUpcast")]
  public static extern IntPtr BoundaryConstraintUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_NoConstraintUpcast")]
  public static extern IntPtr NoConstraintUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PositiveConstraintUpcast")]
  public static extern IntPtr PositiveConstraintUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ConjugateGradientUpcast")]
  public static extern IntPtr ConjugateGradientUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SimplexUpcast")]
  public static extern IntPtr SimplexUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SteepestDescentUpcast")]
  public static extern IntPtr SteepestDescentUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_DepositRateHelperUpcast")]
  public static extern IntPtr DepositRateHelperUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FraRateHelperUpcast")]
  public static extern IntPtr FraRateHelperUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FuturesRateHelperUpcast")]
  public static extern IntPtr FuturesRateHelperUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwapRateHelperUpcast")]
  public static extern IntPtr SwapRateHelperUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_FixedCouponBondHelperUpcast")]
  public static extern IntPtr FixedCouponBondHelperUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_PiecewiseFlatForwardUpcast")]
  public static extern IntPtr PiecewiseFlatForwardUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionHelperUpcast")]
  public static extern IntPtr SwaptionHelperUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapHelperUpcast")]
  public static extern IntPtr CapHelperUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_HullWhiteUpcast")]
  public static extern IntPtr HullWhiteUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackKarasinskiUpcast")]
  public static extern IntPtr BlackKarasinskiUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_G2Upcast")]
  public static extern IntPtr G2Upcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_JamshidianSwaptionEngineUpcast")]
  public static extern IntPtr JamshidianSwaptionEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TreeSwaptionEngineUpcast")]
  public static extern IntPtr TreeSwaptionEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_AnalyticCapFloorEngineUpcast")]
  public static extern IntPtr AnalyticCapFloorEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TreeCapFloorEngineUpcast")]
  public static extern IntPtr TreeCapFloorEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_G2SwaptionEngineUpcast")]
  public static extern IntPtr G2SwaptionEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RiskStatisticsUpcast")]
  public static extern IntPtr RiskStatisticsUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwapUpcast")]
  public static extern IntPtr SwapUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_VanillaSwapUpcast")]
  public static extern IntPtr VanillaSwapUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_SwaptionUpcast")]
  public static extern IntPtr SwaptionUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_BlackSwaptionEngineUpcast")]
  public static extern IntPtr BlackSwaptionEngineUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_TestSurfaceUpcast")]
  public static extern IntPtr TestSurfaceUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_ZeroCurveUpcast")]
  public static extern IntPtr ZeroCurveUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_RelinkableCapVolatilityStructureHandleUpcast")]
  public static extern IntPtr RelinkableCapVolatilityStructureHandleUpcast(IntPtr objectRef);

  [DllImport("NQuantLibc", EntryPoint="CSharp_CapVolatilityVectorUpcast")]
  public static extern IntPtr CapVolatilityVectorUpcast(IntPtr objectRef);
}

}
