/*
 * qucsdefs.h - netlist definitions for the Qucs netlists
 *
 * Copyright (C) 2004, 2005, 2006, 2007 Stefan Jahn <stefan@lkcc.org>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this package; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.  
 *
 * $Id: qucsdefs.h,v 1.71 2007/05/17 09:28:18 ela Exp $
 *
 */

#ifndef __QUCSDEFS_H__
#define __QUCSDEFS_H__

// List of available components.
struct define_t qucs_definition_available[] =
{
  /* resistor */
  { "R", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR, 
    { { "R", PROP_REAL, { 50, PROP_NO_STR }, PROP_NO_RANGE }, PROP_NO_PROP },
    { { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "Tc1", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      { "Tc2", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      { "Tnom", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP }
  },
  /* inductor */
  { "L", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "L", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_NO_RANGE }, PROP_NO_PROP },
    { { "I", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      PROP_NO_PROP }
  },
  /* capacitor */
  { "C", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "C", PROP_REAL, { 1e-12, PROP_NO_STR }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "V", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      PROP_NO_PROP }
  },
  /* two mutual inductors */
  { "MUT", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "L1", PROP_REAL, { 1e-3, PROP_NO_STR },	PROP_POS_RANGEX },
      { "L2", PROP_REAL, { 1e-3, PROP_NO_STR },	PROP_POS_RANGEX },
      { "k", PROP_REAL, { 0.9, PROP_NO_STR }, { '[', 0, 1, '[' } },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* three mutual inductors */
  { "MUT2", 6, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "L1", PROP_REAL, { 1e-3, PROP_NO_STR },	PROP_POS_RANGEX },
      { "L2", PROP_REAL, { 1e-3, PROP_NO_STR },	PROP_POS_RANGEX },
      { "L3", PROP_REAL, { 1e-3, PROP_NO_STR },	PROP_POS_RANGEX },
      { "k12", PROP_REAL, { 0.9, PROP_NO_STR }, { '[', 0, 1, '[' } },
      { "k13", PROP_REAL, { 0.9, PROP_NO_STR }, { '[', 0, 1, '[' } },
      { "k23", PROP_REAL, { 0.9, PROP_NO_STR }, { '[', 0, 1, '[' } },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* multiple mutual inductors */
  { "MUTX", PROP_NODES, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "L", PROP_LIST, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      { "k", PROP_LIST, { 0.9, PROP_NO_STR }, { '[', -1, +1, ']' } },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* voltage controlled current source */
  { "VCCS", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "G", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE }, PROP_NO_PROP },
    { { "T", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },
  /* current controlled current source */
  { "CCCS", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "G", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE }, PROP_NO_PROP },
    { { "T", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },
  /* voltage controlled voltage source */
  { "VCVS", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "G", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE }, PROP_NO_PROP },
    { { "T", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },
  /* current controlled voltage source */
  { "CCVS", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "G", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE }, PROP_NO_PROP },
    { { "T", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },
  /* power source */
  { "Pac", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "f", PROP_REAL, { 1e9, PROP_NO_STR }, PROP_POS_RANGE },
      { "Z", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGEX },
      { "Num", PROP_INT, { 1, PROP_NO_STR }, { '[', 1, MAX_PORTS, ']' } },
      PROP_NO_PROP },
    { { "P", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP }
  },
  /* circulator */
  { "Circulator", 3, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { PROP_NO_PROP },
    { { "Z1", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGE },
      { "Z2", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGE },
      { "Z3", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },
  /* isolator */
  { "Isolator", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { PROP_NO_PROP },
    { { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "Z1", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGE },
      { "Z2", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },
  /* attenuator */
  { "Attenuator", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "L", PROP_REAL, { 10, PROP_NO_STR }, PROP_MIN_VAL (1) },
      PROP_NO_PROP },
    { { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "Zref", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* bias tee */
  { "BiasT", 3, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { PROP_NO_PROP },
    { { "C", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_POS_RANGE },
      { "L", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* DC feed */
  { "DCFeed", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { PROP_NO_PROP },
    { { "L", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* DC block */
  { "DCBlock", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { PROP_NO_PROP },
    { { "C", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* transformer */
  { "Tr", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "T", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* symmetrical transformer */
  { "sTr", 6, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "T1", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "T2", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* DC voltage source */
  { "Vdc", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "U", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE }, PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* DC current source */
  { "Idc", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "I", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_NO_RANGE }, PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* AC voltage source */
  { "Vac", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "U", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE }, PROP_NO_PROP },
    { { "Phase", PROP_REAL, { 0, PROP_NO_STR }, { '[', -360, 360, ']' } },
      { "Theta", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "f", PROP_REAL, { 1e9, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* AC current source */
  { "Iac", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "I", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_NO_RANGE }, PROP_NO_PROP },
    { { "Phase", PROP_REAL, { 0, PROP_NO_STR }, { '[', -360, 360, ']' } },
      { "Theta", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "f", PROP_REAL, { 1e9, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* exponential current source */
  { "Iexp", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "I1", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      { "I2", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE },
      { "T1", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "T2", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { { "Tr", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      { "Tf", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* exponential voltage source */
  { "Vexp", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "U1", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      { "U2", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE },
      { "T1", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "T2", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { { "Tr", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      { "Tf", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* AM modulated AC voltage source */
  { "AM_Mod", 3, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "U", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "f", PROP_REAL, { 1e9, PROP_NO_STR }, PROP_POS_RANGE },
      { "m", PROP_REAL, { 1, PROP_NO_STR }, { '[', 0, 1, ']' } },
      PROP_NO_PROP },
    { { "Phase", PROP_REAL, { 0, PROP_NO_STR }, { '[', -360, 360, ']' } },
      PROP_NO_PROP }
  },
  /* PM modulated AC voltage source */
  { "PM_Mod", 3, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "U", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "f", PROP_REAL, { 1e9, PROP_NO_STR }, PROP_POS_RANGE },
      { "M", PROP_REAL, { 1, PROP_NO_STR }, { '[', 0, 1, ']' } },
      PROP_NO_PROP },
    { { "Phase", PROP_REAL, { 0, PROP_NO_STR }, { '[', -360, 360, ']' } },
      PROP_NO_PROP }
  },
  /* pulse voltage source */
  { "Vpulse", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "U1", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      { "U2", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE },
      { "T1", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "T2", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { { "Tr", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      { "Tf", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* pulse current source */
  { "Ipulse", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "I1", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      { "I2", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE },
      { "T1", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "T2", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { { "Tr", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      { "Tf", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* rectangular pulse voltage source */
  { "Vrect", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "U", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE },
      { "TH", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "TL", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { { "Tr", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      { "Tf", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      { "Td", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      PROP_NO_PROP }
  },
  /* rectangular pulse current source */
  { "Irect", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "I", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_NO_RANGE },
      { "TH", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "TL", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { { "Tr", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      { "Tf", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      { "Td", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      PROP_NO_PROP }
  },
  /* phase shifter */
  { "PShift", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "phi", PROP_REAL, { 1e-90, PROP_NO_STR }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Zref", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* gyrator */
  { "Gyrator", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "R", PROP_REAL, { 50, PROP_NO_STR }, PROP_NO_RANGE }, PROP_NO_PROP },
    { { "Zref", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* time controlled switch */
  { "Switch", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "init", PROP_STR, { PROP_NO_VAL, "off" }, PROP_NO_RANGE },
      { "time", PROP_LIST, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { { "Ron", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Roff", PROP_REAL, { 1e12, PROP_NO_STR }, PROP_POS_RANGE },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP }
  },
  /* relais */
  { "Relais", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "Vt", PROP_REAL, { 0.5, PROP_NO_STR }, PROP_NO_RANGE },
      { "Vh", PROP_REAL, { 0.1, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { { "Ron", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Roff", PROP_REAL, { 1e12, PROP_NO_STR }, PROP_POS_RANGE },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP }
  },
  /* ideal transmission line */
  { "TLIN", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "Z", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGE }, 
      { "L", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Alpha", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGEX },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP }
  },
  /* ideal 4-terminal transmission line */
  { "TLIN4P", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "Z", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGE }, 
      { "L", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Alpha", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGEX },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP }
  },
  /* coaxial cable */
  { "COAX", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "D", PROP_REAL, { 2.95e-3, PROP_NO_STR }, PROP_POS_RANGEX }, 
      { "d", PROP_REAL, { 0.9e-3, PROP_NO_STR }, PROP_POS_RANGEX },
      { "L", PROP_REAL, { 1500e-3, PROP_NO_STR }, PROP_NO_RANGE },
      { "er", PROP_REAL, { 2.29, PROP_NO_STR }, { '[', 1, 100, ']' } },
      { "mur", PROP_REAL, { 1, PROP_NO_STR }, { '[', 1, 100, ']' } },
      { "tand", PROP_REAL, { 4e-4, PROP_NO_STR }, PROP_POS_RANGE },
      { "rho", PROP_REAL, { 0.022e-6, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP }
  },
  /* twisted pair line */
  { "TWIST", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "d", PROP_REAL, { 0.5e-3, PROP_NO_STR }, PROP_POS_RANGEX }, 
      { "D", PROP_REAL, { 0.8e-3, PROP_NO_STR }, PROP_POS_RANGEX },
      { "L", PROP_REAL, { 1500e-3, PROP_NO_STR }, PROP_NO_RANGE },
      { "T", PROP_REAL, { 100, PROP_NO_STR }, PROP_POS_RANGE },
      { "er", PROP_REAL, { 4, PROP_NO_STR }, { '[', 1, 100, ']' } },
      { "mur", PROP_REAL, { 1, PROP_NO_STR }, { '[', 1, 100, ']' } },
      { "tand", PROP_REAL, { 4e-4, PROP_NO_STR }, PROP_POS_RANGE },
      { "rho", PROP_REAL, { 0.022e-6, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP }
  },
  /* ideal coupler */
  { "Coupler", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "k", PROP_REAL, { M_SQRT1_2, PROP_NO_STR }, PROP_NO_RANGE },
      { "phi", PROP_REAL, { 0, PROP_NO_STR }, { '[', -180, +180, ']' } },
      PROP_NO_PROP },
    { { "Z", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* current probe */
  { "IProbe", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* voltage probe */
  { "VProbe", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* S-parameter file */
  { "SPfile", PROP_NODES, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "File", PROP_STR, { PROP_NO_VAL, "spfile.snp" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Data", PROP_STR, { PROP_NO_VAL, "polar" }, PROP_NO_RANGE },
      { "Interpolator", PROP_STR, { PROP_NO_VAL, "linear" }, PROP_NO_RANGE },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "duringDC", PROP_STR, { PROP_NO_VAL, "open" }, PROP_NO_RANGE },
      PROP_NO_PROP }
  },
  /* amplifier */
  { "Amp", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "G", PROP_REAL, { 10, PROP_NO_STR }, PROP_MIN_VAL (1) },
      PROP_NO_PROP },
    { { "Z1", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGE },
      { "Z2", PROP_REAL, { 50, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* operational amplifier */
  { "OpAmp", 3, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "G", PROP_REAL, { 1e6, PROP_NO_STR }, PROP_MIN_VAL (1) },
      PROP_NO_PROP },
    { { "Umax", PROP_REAL, { 15, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* noise voltage source */
  { "Vnoise", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "u", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_POS_RANGE }, 
      PROP_NO_PROP },
    { { "a", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "c", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "e", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* noise current source */
  { "Inoise", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "i", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_POS_RANGE }, 
      PROP_NO_PROP },
    { { "a", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "c", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "e", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* correlated noise current sources */
  { "IInoise", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "i1", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_POS_RANGE }, 
      { "i2", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_POS_RANGE }, 
      { "C", PROP_REAL, { 0.5, PROP_NO_STR }, { '[', -1, 1, ']' } }, 
      PROP_NO_PROP },
    { { "a", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "c", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "e", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* correlated noise voltage sources */
  { "VVnoise", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "v1", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_POS_RANGE }, 
      { "v2", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_POS_RANGE }, 
      { "C", PROP_REAL, { 0.5, PROP_NO_STR }, { '[', -1, 1, ']' } }, 
      PROP_NO_PROP },
    { { "a", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "c", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "e", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* correlated noise sources */
  { "IVnoise", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "i1", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_POS_RANGE }, 
      { "v2", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_POS_RANGE }, 
      { "C", PROP_REAL, { 0.5, PROP_NO_STR }, { '[', -1, 1, ']' } }, 
      PROP_NO_PROP },
    { { "a", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "c", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "e", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },

  /* diode */
  { "Diode", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "Is", PROP_REAL, { 1e-15, PROP_NO_STR }, PROP_POS_RANGE },
      { "N", PROP_REAL, { 1, PROP_NO_STR }, { '[', 0.1, 100, ']' } },
      { "M", PROP_REAL, { 0.5, PROP_NO_STR }, { '[', 0, 2, ']' } },
      { "Cj0", PROP_REAL, { 10e-15, PROP_NO_STR }, PROP_POS_RANGE },
      { "Vj", PROP_REAL, { 0.7, PROP_NO_STR }, { ']', 0, 10, ']' } },
      PROP_NO_PROP },
    { { "Rs", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Isr", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Nr", PROP_REAL, { 2, PROP_NO_STR }, { '[', 0.1, 100, ']' } },
      { "Bv", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Ibv", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Ikf", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Tt", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Fc", PROP_REAL, { 0.5, PROP_NO_STR }, { '[', 0, 1, '[' } },
      { "Cp", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Kf", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Af", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "Ffe", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "Xti", PROP_REAL, { 3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Eg", PROP_REAL, { EgSi, PROP_NO_STR }, PROP_POS_RANGE },
      { "Tbv", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Trs", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      { "Ttt1", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      { "Ttt2", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      { "Tm1", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      { "Tm2", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      { "Tnom", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "Area", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGEX },
      PROP_NO_PROP }
  },
  /* jfet */
  { "JFET", 3, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "Is", PROP_REAL, { 1e-14, PROP_NO_STR }, PROP_POS_RANGE },
      { "N", PROP_REAL, { 1, PROP_NO_STR }, { '[', 1, 100, ']' } },
      { "Vt0", PROP_REAL, { -2, PROP_NO_STR }, PROP_NEG_RANGE },
      { "Lambda", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Beta", PROP_REAL, { 1e-4, PROP_NO_STR }, PROP_POS_RANGE },
      { "M", PROP_REAL, { 0.5, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "Pb", PROP_REAL, { 1.0, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "Fc", PROP_REAL, { 0.5, PROP_NO_STR }, { '[', 0, 1, '[' } },
      { "Cgs", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Cgd", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP },
    { { "Rd", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Rs", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Isr", PROP_REAL, { 1e-14, PROP_NO_STR }, PROP_POS_RANGE },
      { "Nr", PROP_REAL, { 2, PROP_NO_STR }, { '[', 1, 100, ']' } },
      { "Kf", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Af", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "Ffe", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "Type", PROP_STR, { PROP_NO_VAL, "nfet" }, PROP_NO_RANGE },
      { "Xti", PROP_REAL, { 3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Vt0tc", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Betatce", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Tnom", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "Area", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGEX },
      PROP_NO_PROP }
  },
  /* sgp bjt */
  { "BJT", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "Is", PROP_REAL, { 1e-16, PROP_NO_STR }, PROP_POS_RANGE },
      { "Nf", PROP_REAL, { 1, PROP_NO_STR }, { '[', 0.1, 100, ']' } },
      { "Nr", PROP_REAL, { 1, PROP_NO_STR }, { '[', 0.1, 100, ']' } },
      { "Ikf", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Ikr", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Vaf", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Var", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Ise", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Ne", PROP_REAL, { 1.5, PROP_NO_STR }, { '[', 0.1, 100, ']' } },
      { "Isc", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Nc", PROP_REAL, { 2, PROP_NO_STR }, { '[', 0.1, 100, ']' } },
      { "Bf", PROP_REAL, { 100, PROP_NO_STR }, PROP_POS_RANGEX },
      { "Br", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGEX },
      { "Rbm", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Irb", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Cje", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Vje", PROP_REAL, { 0.75, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "Mje", PROP_REAL, { 0.33, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "Cjc", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Vjc", PROP_REAL, { 0.75, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "Mjc", PROP_REAL, { 0.33, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "Xcjc", PROP_REAL, { 1, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "Cjs", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Vjs", PROP_REAL, { 0.75, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "Mjs", PROP_REAL, { 0, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "Fc", PROP_REAL, { 0.5, PROP_NO_STR }, { '[', 0, 1, '[' } },
      { "Vtf", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Tf", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Xtf", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Itf", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Tr", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { { "Rc", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Re", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Rb", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Kf", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Af", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "Ffe", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "Kb", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Ab", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "Fb", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "Type", PROP_STR, { PROP_NO_VAL, "npn" }, PROP_NO_RANGE },
      { "Ptf", PROP_REAL, { 0, PROP_NO_STR }, { '[', -180, +180, ']' } },
      { "Xtb", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Xti", PROP_REAL, { 3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Eg", PROP_REAL, { EgSi, PROP_NO_STR }, PROP_POS_RANGE },
      { "Tnom", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "Area", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGEX },
      PROP_NO_PROP }
  },
  /* fet: level 1 */
  { "MOSFET", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "Is", PROP_REAL, { 1e-14, PROP_NO_STR }, PROP_POS_RANGE },
      { "N", PROP_REAL, { 1, PROP_NO_STR }, { '[', 0.1, 100, ']' } },
      { "Vt0", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      { "Lambda", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Kp", PROP_REAL, { 2e-5, PROP_NO_STR }, PROP_POS_RANGE },
      { "Gamma", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Phi", PROP_REAL, { 0.6, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { { "Rd", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Rs", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Rg", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "L", PROP_REAL, { 100e-6, PROP_NO_STR }, PROP_RNG_X01I },
      { "Ld", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "W", PROP_REAL, { 100e-6, PROP_NO_STR }, PROP_RNG_X01I },
      { "Tox", PROP_REAL, { 1e-7, PROP_NO_STR }, PROP_RNG_X01I },
      { "Cgso", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Cgdo", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Cgbo", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Cbd", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Cbs", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Pb", PROP_REAL, { 0.8, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "Mj", PROP_REAL, { 0.5, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "Fc", PROP_REAL, { 0.5, PROP_NO_STR }, { '[', 0, 1, '[' } },
      { "Cjsw", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Mjsw", PROP_REAL, { 0.33, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "Tt", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Kf", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Af", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "Ffe", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "Nsub", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Nss", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Tpg", PROP_INT, { 1, PROP_NO_STR }, { '[', -1 , 1, ']' } },
      { "Uo", PROP_REAL, { 600, PROP_NO_STR }, PROP_POS_RANGE },
      { "Rsh", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Nrd", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "Nrs", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE },
      { "Cj", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Js", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Ad", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "As", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Pd", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Ps", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "Tnom", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "Type", PROP_STR, { PROP_NO_VAL, "nfet" }, PROP_NO_RANGE },
      { "capModel", PROP_INT, { 2, PROP_NO_STR }, { '[', 1 , 2, ']' } },
      PROP_NO_PROP }
  },
  /* equation defined device */
  { "EDD", PROP_NODES, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "I1", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "Q1", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      PROP_NO_PROP },
    { { "I2", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "Q2", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "I3", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "Q3", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "I4", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "Q4", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "I5", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "Q5", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "I6", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "Q6", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "I7", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "Q7", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "I8", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      { "Q8", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE }, 
      PROP_NO_PROP }
  },


  /* hicumL2p1 verilog device */
  { "hicumL2p1", 5, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    {
      { "c10", PROP_REAL, { 1.516E-31, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "qp0", PROP_REAL, { 5.939E-15, PROP_NO_STR }, { ']', 0, 1, ']' } },
      { "ich", PROP_REAL, { 1.0E11, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "hfe", PROP_REAL, { 1.0, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "hfc", PROP_REAL, { 0.03999, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "hjei", PROP_REAL, { 0.435, PROP_NO_STR }, { '[', 0, 100, ']' } },
      { "hjci", PROP_REAL, { 0.09477, PROP_NO_STR }, { '[', 0, 100, ']' } },
      { "ibeis", PROP_REAL, { 3.47E-20, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "mbei", PROP_REAL, { 1.025, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "ireis", PROP_REAL, { 390E-12, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "mrei", PROP_REAL, { 3, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "ibeps", PROP_REAL, { 4.18321E-21, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "mbep", PROP_REAL, { 1.045, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "ireps", PROP_REAL, { 1.02846E-14, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "mrep", PROP_REAL, { 3, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "mcf", PROP_REAL, { 1.0, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "ibcis", PROP_REAL, { 3.02613E-18, PROP_NO_STR }, { '[', 0, 1.0, ']' } },
      { "mbci", PROP_REAL, { 1.0, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "ibcxs", PROP_REAL, { 4.576E-29, PROP_NO_STR }, { '[', 0, 1.0, ']' } },
      { "mbcx", PROP_REAL, { 1.0, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "ibets", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "abet", PROP_REAL, { 36.74, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "favl", PROP_REAL, { 14.97, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "qavl", PROP_REAL, { 7.2407E-14, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "alfav", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
      { "alqav", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
      { "rbi0", PROP_REAL, { 7.9, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "rbx", PROP_REAL, { 13.15, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "fgeo", PROP_REAL, { 0.724, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "fdqr0", PROP_REAL, { 200, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "fcrbi", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "fqi", PROP_REAL, { 1.0, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "re", PROP_REAL, { 9.77, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "rcx", PROP_REAL, { 10, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "itss", PROP_REAL, { 2.81242E-19, PROP_NO_STR }, { '[', 0, 1.0, ']' } },
      { "msf", PROP_REAL, { 1.0, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "iscs", PROP_REAL, { 7.6376E-17, PROP_NO_STR }, { '[', 0, 1.0, ']' } },
      { "msc", PROP_REAL, { 1.0, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "tsf", PROP_REAL, { 1.733E-8, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "rsu", PROP_REAL, { 800, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "csu", PROP_REAL, { 1.778E-14, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "cjei0", PROP_REAL, { 5.24382E-14, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "vdei", PROP_REAL, { 0.9956, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "zei", PROP_REAL, { 0.4, PROP_NO_STR }, { ']', 0, 1, ']' } },
      { "aljei", PROP_REAL, { 2.5, PROP_NO_STR }, { '[', 1, 0, '.' } },
      { "cjep0", PROP_REAL, { 0, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "vdep", PROP_REAL, { 1, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "zep", PROP_REAL, { 0.01, PROP_NO_STR }, { ']', 0, 1, ']' } },
      { "aljep", PROP_REAL, { 2.5, PROP_NO_STR }, { '[', 1, 0, '.' } },
      { "cjci0", PROP_REAL, { 4.46887E-15, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "vdci", PROP_REAL, { 0.7, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "zci", PROP_REAL, { 0.38, PROP_NO_STR }, { ']', 0, 1, ']' } },
      { "vptci", PROP_REAL, { 100, PROP_NO_STR }, { ']', 0, 100, ']' } },
      { "cjcx0", PROP_REAL, { 1.55709E-14, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "vdcx", PROP_REAL, { 0.733, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "zcx", PROP_REAL, { 0.34, PROP_NO_STR }, { ']', 0, 1, ']' } },
      { "vptcx", PROP_REAL, { 100, PROP_NO_STR }, { ']', 0, 100, ']' } },
      { "fbc", PROP_REAL, { 0.3487, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "cjs0", PROP_REAL, { 17.68E-15, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "vds", PROP_REAL, { 0.621625, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "zs", PROP_REAL, { 0.122136, PROP_NO_STR }, { ']', 0, 1, ']' } },
      { "vpts", PROP_REAL, { 1000, PROP_NO_STR }, { ']', 0, 1000, ']' } },
      { "t0", PROP_REAL, { 1.28E-12, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "dt0h", PROP_REAL, { 260E-15, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "tbvl", PROP_REAL, { 2.0E-13, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "tef0", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "gtfe", PROP_REAL, { 1.0, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "thcs", PROP_REAL, { 46E-15, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "alhc", PROP_REAL, { 0.08913, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "fthc", PROP_REAL, { 0.8778, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "rci0", PROP_REAL, { 50.4277, PROP_NO_STR }, { ']', 0, 0, '.' } },
      { "vlim", PROP_REAL, { 0.9, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "vces", PROP_REAL, { 0.01, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "vpt", PROP_REAL, { 10, PROP_NO_STR }, { '[', 0, 100, ']' } },
      { "tr", PROP_REAL, { 1.0E-11, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "ceox", PROP_REAL, { 1.71992E-15, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "ccox", PROP_REAL, { 4.9E-15, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "alqf", PROP_REAL, { 0.1288, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "alit", PROP_REAL, { 1.0, PROP_NO_STR }, { '[', 0, 1, ']' } },
      { "kf", PROP_REAL, { 2.83667E-9, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "af", PROP_REAL, { 2.0, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "krbi", PROP_REAL, { 1.0, PROP_NO_STR }, { ']', 0, 0, '.' } },
      { "latb", PROP_REAL, { 10.479, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "latl", PROP_REAL, { 0.300012, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "vgb", PROP_REAL, { 1.112, PROP_NO_STR }, { ']', 0, 10, ']' } },
      { "alt0", PROP_REAL, { 0.0017580, PROP_NO_STR }, PROP_NO_RANGE },
      { "kt0", PROP_REAL, { 4.07E-6, PROP_NO_STR }, PROP_NO_RANGE },
      { "zetaci", PROP_REAL, { 0.7, PROP_NO_STR }, PROP_NO_RANGE },
      { "zetacx", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
      { "alvs", PROP_REAL, { 0.001, PROP_NO_STR }, PROP_NO_RANGE },
      { "alces", PROP_REAL, { 0.000125, PROP_NO_STR }, PROP_NO_RANGE },
      { "zetarbi", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
      { "zetarbx", PROP_REAL, { 0.2, PROP_NO_STR }, PROP_NO_RANGE },
      { "zetarcx", PROP_REAL, { 0.21, PROP_NO_STR }, PROP_NO_RANGE },
      { "zetare", PROP_REAL, { 0.7, PROP_NO_STR }, PROP_NO_RANGE },
      { "alb", PROP_REAL, { 0.007, PROP_NO_STR }, PROP_NO_RANGE },
      { "rth", PROP_REAL, { 1293.95, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "cth", PROP_REAL, { 7.22203E-11, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "tnom", PROP_REAL, { 27.0, PROP_NO_STR }, PROP_NO_RANGE },
      { "dt", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
      { "Type", PROP_STR, { PROP_NO_VAL, "npn" }, PROP_NO_RANGE },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* HBT_X verilog device */
  { "HBT_X", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    {
      { "Mode", PROP_INT, { 1, PROP_NO_STR }, { '[', 0, 4, ']' } },
      { "Noise", PROP_INT, { 1, PROP_NO_STR }, { '[', 0, 4, ']' } },
      { "Debug", PROP_INT, { 0, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "DebugPlus", PROP_INT, { 0, PROP_NO_STR }, { '[', 0, 0, '.' } },
      { "Temp", PROP_REAL, { 25.0, PROP_NO_STR }, { '[', (-273.15), 0, '.' } },
      { "Rth", PROP_REAL, { 0.1, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Cth", PROP_REAL, { (700*1.0e-9), PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "N", PROP_INT, { 1, PROP_NO_STR }, { ']', 0, 0, '.' } },
      { "L", PROP_REAL, { (30*1.0e-6), PROP_NO_STR }, { ']', 0.0, 0, '.' } },
      { "W", PROP_REAL, { (3*1.0e-6), PROP_NO_STR }, { ']', 0.0, 0, '.' } },
      { "Jsf", PROP_REAL, { 20e-24, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "nf", PROP_REAL, { 1.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Vg", PROP_REAL, { 1.3, PROP_NO_STR }, { '[', (-2.0), 0, '.' } },
      { "Jse", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "ne", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Rbxx", PROP_REAL, { 1e6, PROP_NO_STR }, { ']', 0.0, 0, '.' } },
      { "Vgb", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Jsee", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "nee", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Rbbxx", PROP_REAL, { 1e6, PROP_NO_STR }, { ']', 0.0, 0, '.' } },
      { "Vgbb", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Jsr", PROP_REAL, { 20e-18, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "nr", PROP_REAL, { 1.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Vgr", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "XCjc", PROP_REAL, { 0.5, PROP_NO_STR }, { '[', 0.0, 1.0, '[' } },
      { "Jsc", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "nc", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Rcxx", PROP_REAL, { 1e6, PROP_NO_STR }, { ']', 0.0, 0, '.' } },
      { "Vgc", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Bf", PROP_REAL, { 100.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "kBeta", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Br", PROP_REAL, { 1.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "VAF", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "VAR", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "IKF", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "IKR", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Mc", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "BVceo", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "kc", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "BVebo", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Tr", PROP_REAL, { (1*1.0e-15), PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Trx", PROP_REAL, { (1*1.0e-15), PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Tf", PROP_REAL, { (1*1.0e-12), PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Tft", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Thcs", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Ahc", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Cje", PROP_REAL, { (1*1.0e-15), PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "mje", PROP_REAL, { 0.5, PROP_NO_STR }, { '[', 0.0, 1, '[' } },
      { "Vje", PROP_REAL, { 1.3, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Cjc", PROP_REAL, { (1*1.0e-15), PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "mjc", PROP_REAL, { 0.5, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Vjc", PROP_REAL, { 1.3, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "kjc", PROP_REAL, { 1.0, PROP_NO_STR }, { '.', 0, 0, '.' } },
      { "Cmin", PROP_REAL, { (0.1*1.0e-15), PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "J0", PROP_REAL, { 1e-3, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "XJ0", PROP_REAL, { 1.0, PROP_NO_STR }, { '[', 0.0, 1.0, ']' } },
      { "Rci0", PROP_REAL, { 1e-3, PROP_NO_STR }, { ']', 0.0, 0, '.' } },
      { "Jk", PROP_REAL, { 4e-4, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "RJk", PROP_REAL, { 1e-3, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Vces", PROP_REAL, { 1e-3, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Rc", PROP_REAL, { 1.0, PROP_NO_STR }, { ']', 0.0, 0, '.' } },
      { "Re", PROP_REAL, { 1.0, PROP_NO_STR }, { ']', 0.0, 0, '.' } },
      { "Rb", PROP_REAL, { 1.0, PROP_NO_STR }, { ']', 0.0, 0, '.' } },
      { "Rb2", PROP_REAL, { 1.0, PROP_NO_STR }, { ']', 0.0, 0, '.' } },
      { "Lc", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Le", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Lb", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Cq", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Cpb", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Cpc", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Kfb", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Afb", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Ffeb", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Kb", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Ab", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Fb", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Kfe", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Afe", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Ffee", PROP_REAL, { 0.0, PROP_NO_STR }, { '[', 0.0, 0, '.' } },
      { "Tnom", PROP_REAL, { 20.0, PROP_NO_STR }, { '[', (-273.15), 0, '.' } },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },

  /* microstrip substrate */
  { "SUBST", 0, PROP_COMPONENT, PROP_SUBSTRATE, PROP_LINEAR,
    { { "er", PROP_REAL, { 9.8, PROP_NO_STR }, { '[', 1, 100, ']' } },
      { "h", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "t", PROP_REAL, { 35e-6, PROP_NO_STR }, PROP_POS_RANGE },
      { "tand", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "rho", PROP_REAL, { 0.022e-6, PROP_NO_STR }, PROP_POS_RANGE },
      { "D", PROP_REAL, { 0.15e-6, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* microstrip line */
  { "MLIN", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "L", PROP_REAL, { 10e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      { "DispModel", PROP_STR, { PROP_NO_VAL, "Kirschning" }, PROP_NO_RANGE },
      { "Model", PROP_STR, { PROP_NO_VAL, "Hammerstad" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP }
  },
  /* parallel coupled microstrip lines */
  { "MCOUPLED", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "L", PROP_REAL, { 10e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "S", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      { "Model", PROP_STR, { PROP_NO_VAL, "Kirschning" }, PROP_NO_RANGE },
      { "DispModel", PROP_STR, { PROP_NO_VAL, "Kirschning" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP }
  },
  /* microstrip corner */
  { "MCORN", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* microstrip mitered bend */
  { "MMBEND", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* microstrip impedance step */
  { "MSTEP", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W1", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "W2", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      { "MSDispModel", PROP_STR, { PROP_NO_VAL, "Kirschning" },
	PROP_NO_RANGE },
      { "MSModel", PROP_STR, { PROP_NO_VAL, "Hammerstad" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* microstrip open end */
  { "MOPEN", 1, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      { "MSDispModel", PROP_STR, { PROP_NO_VAL, "Kirschning" },
	PROP_NO_RANGE },
      { "MSModel", PROP_STR, { PROP_NO_VAL, "Hammerstad" }, PROP_NO_RANGE },
      { "Model", PROP_STR, { PROP_NO_VAL, "Kirschning" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* microstrip gap */
  { "MGAP", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W1", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "W2", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "S" , PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      { "MSDispModel", PROP_STR, { PROP_NO_VAL, "Kirschning" },
	PROP_NO_RANGE },
      { "MSModel", PROP_STR, { PROP_NO_VAL, "Hammerstad" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* microstrip t-junction */
  { "MTEE", 3, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W1", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "W2", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "W3", PROP_REAL, { 2e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      { "MSDispModel", PROP_STR, { PROP_NO_VAL, "Kirschning" },
	PROP_NO_RANGE },
      { "MSModel", PROP_STR, { PROP_NO_VAL, "Hammerstad" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP }
  },
  /* microstrip cross-junction */
  { "MCROSS", 4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W1", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "W2", PROP_REAL, { 2e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "W3", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "W4", PROP_REAL, { 2e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      { "MSDispModel", PROP_STR, { PROP_NO_VAL, "Kirschning" },
	PROP_NO_RANGE },
      { "MSModel", PROP_STR, { PROP_NO_VAL, "Hammerstad" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* microstrip via hole */
  { "MVIA", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "D", PROP_REAL, { 100e-6, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP }
  },
  /* bond wire */
  { "BOND", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "D", PROP_REAL, { 25e-6, PROP_NO_STR }, PROP_POS_RANGE },
      { "L", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "H", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "mur", PROP_REAL, { 1, PROP_NO_STR }, { '[', 1, 100, ']' } },
      { "rho", PROP_REAL, { 0.022e-6, PROP_NO_STR }, PROP_POS_RANGE },
      { "Model", PROP_STR, { PROP_NO_VAL, "FREESPACE" }, PROP_NO_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      PROP_NO_PROP }
  },
  /* coplanar line */
  { "CLIN", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "S", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "L", PROP_REAL, { 10e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "Backside", PROP_STR, { PROP_NO_VAL, "Metal" }, PROP_NO_RANGE },
      { "Approx", PROP_STR, { PROP_NO_VAL, "no" }, PROP_NO_RANGE },
      PROP_NO_PROP }
  },
  /* coplanar open */
  { "COPEN", 1, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "S", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "G", PROP_REAL, { 5e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Backside", PROP_STR, { PROP_NO_VAL, "Metal" }, PROP_NO_RANGE },
      PROP_NO_PROP }
  },
  /* coplanar short */
  { "CSHORT", 1, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "S", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Backside", PROP_STR, { PROP_NO_VAL, "Metal" }, PROP_NO_RANGE },
      PROP_NO_PROP }
  },
  /* coplanar gap */
  { "CGAP", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "G", PROP_REAL, { 5e-4, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "S", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* coplanar step */
  { "CSTEP", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "W1", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "W2", PROP_REAL, { 2e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "S", PROP_REAL, { 4e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Subst", PROP_STR, { PROP_NO_VAL, "Subst1" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Backside", PROP_STR, { PROP_NO_VAL, "Metal" }, PROP_NO_RANGE },
      PROP_NO_PROP }
  },

  /* logical inverter */
  { "Inv", 2, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "V", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP },
    { { "t", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },
  /* logical nor */
  { "NOR", PROP_NODES, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "V", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP },
    { { "t", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },
  /* logical or */
  { "OR", PROP_NODES, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "V", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP },
    { { "t", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },
  /* logical nand */
  { "NAND", PROP_NODES, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "V", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP },
    { { "t", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },
  /* logical and */
  { "AND", PROP_NODES, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "V", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP },
    { { "t", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },
  /* logical xnor */
  { "XNOR", PROP_NODES, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "V", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP },
    { { "t", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },
  /* logical xor */
  { "XOR", PROP_NODES, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR,
    { { "V", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP },
    { { "t", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },
  /* digital source */
  { "DigiSource", 1, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "init", PROP_STR, { PROP_NO_VAL, "low" }, PROP_NO_RANGE },
      { "times", PROP_LIST, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP },
    { { "V", PROP_REAL, { 1, PROP_NO_STR }, PROP_POS_RANGE }, PROP_NO_PROP }
  },

  /* s-parameter analysis */
  { "SP", 0, PROP_ACTION, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "Type", PROP_STR, { PROP_NO_VAL, "lin" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Noise", PROP_STR, { PROP_NO_VAL, "no" }, PROP_NO_RANGE },
      { "NoiseIP", PROP_INT, { 1, PROP_NO_STR }, { '[', 1, MAX_PORTS, ']' } }, 
      { "NoiseOP", PROP_INT, { 2, PROP_NO_STR }, { '[', 1, MAX_PORTS, ']' } },
      { "Start", PROP_REAL, { 1e9, PROP_NO_STR }, PROP_POS_RANGE },
      { "Stop", PROP_REAL, { 10e9, PROP_NO_STR }, PROP_POS_RANGE },
      { "Points", PROP_INT, { 10, PROP_NO_STR }, PROP_MIN_VAL (2) },
      { "Values", PROP_LIST, { 10, PROP_NO_STR }, PROP_POS_RANGE },
      { "saveCVs", PROP_STR, { PROP_NO_VAL, "no" }, PROP_NO_RANGE },
      { "saveAll", PROP_STR, { PROP_NO_VAL, "no" }, PROP_NO_RANGE },
      PROP_NO_PROP }
  },
  /* dc analysis */
  { "DC", 0, PROP_ACTION, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { PROP_NO_PROP },
    { { "MaxIter", PROP_INT, { 150, PROP_NO_STR }, { '[', 2, 10000, ']' } },
      { "abstol", PROP_REAL, { 1e-12, PROP_NO_STR }, PROP_RNG_X01I },
      { "vntol", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_RNG_X01I },
      { "reltol", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_RNG_X01I },
      { "saveOPs", PROP_STR, { PROP_NO_VAL, "no" }, PROP_NO_RANGE },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "saveAll", PROP_STR, { PROP_NO_VAL, "no" }, PROP_NO_RANGE },
      { "convHelper", PROP_STR, { PROP_NO_VAL, "none" }, PROP_NO_RANGE },
      { "Solver", PROP_STR, { PROP_NO_VAL, "CroutLU" }, PROP_NO_RANGE },
      PROP_NO_PROP }
  },
  /* parameter sweep */
  { "SW", 0, PROP_ACTION, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "Type", PROP_STR, { PROP_NO_VAL, "lin" }, PROP_NO_RANGE },
      { "Param", PROP_STR, { PROP_NO_VAL, "R1" }, PROP_NO_RANGE },
      { "Sim", PROP_STR, { PROP_NO_VAL, "DC1" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Points", PROP_INT, { 5, PROP_NO_STR }, PROP_MIN_VAL (2) },
      { "Stop", PROP_REAL, { 50, PROP_NO_STR }, PROP_NO_RANGE },
      { "Start", PROP_REAL, { 5, PROP_NO_STR }, PROP_NO_RANGE },
      { "Values", PROP_LIST, { 5, PROP_NO_STR }, PROP_NO_RANGE },
      PROP_NO_PROP }
  },
  /* ac analysis */
  { "AC", 0, PROP_ACTION, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "Type", PROP_STR, { PROP_NO_VAL, "lin" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { { "Noise", PROP_STR, { PROP_NO_VAL, "no" }, PROP_NO_RANGE },
      { "Start", PROP_REAL, { 1e9, PROP_NO_STR }, PROP_POS_RANGE },
      { "Stop", PROP_REAL, { 10e9, PROP_NO_STR }, PROP_POS_RANGE },
      { "Points", PROP_INT, { 10, PROP_NO_STR }, PROP_MIN_VAL (2) },
      { "Values", PROP_LIST, { 10, PROP_NO_STR }, PROP_POS_RANGE },
      PROP_NO_PROP }
  },
  /* transient analysis */
  { "TR", 0, PROP_ACTION, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "Type", PROP_STR, { PROP_NO_VAL, "lin" }, PROP_NO_RANGE },
      { "Start", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "Stop", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_POS_RANGE },
      { "Points", PROP_INT, { 10, PROP_NO_STR }, PROP_MIN_VAL (2) },
      PROP_NO_PROP },
    { { "IntegrationMethod", PROP_STR, { PROP_NO_VAL, "Trapezoidal" },
	PROP_NO_RANGE },
      { "Order", PROP_INT, { 2, PROP_NO_STR }, { '[', 1, 6, ']' } },
      { "InitialStep", PROP_REAL, { 1e-9, PROP_NO_STR }, PROP_POS_RANGE },
      { "MinStep", PROP_REAL, { 1e-16, PROP_NO_STR }, PROP_POS_RANGE },
      { "MaxStep", PROP_REAL, { 0, PROP_NO_STR }, PROP_POS_RANGE },
      { "MaxIter", PROP_INT, { 150, PROP_NO_STR }, { '[', 2, 10000, ']' } },
      { "abstol", PROP_REAL, { 1e-12, PROP_NO_STR }, PROP_RNG_X01I },
      { "vntol", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_RNG_X01I },
      { "reltol", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_RNG_X01I },
      { "LTEabstol", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_RNG_X01I },
      { "LTEreltol", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_RNG_X01I },
      { "LTEfactor", PROP_REAL, { 1, PROP_NO_STR }, { '[', 1, 16, ']' } },
      { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
      { "Solver", PROP_STR, { PROP_NO_VAL, "CroutLU" }, PROP_NO_RANGE },
      { "relaxTSR", PROP_STR, { PROP_NO_VAL, "no" }, PROP_NO_RANGE },
      { "initialDC", PROP_STR, { PROP_NO_VAL, "yes" }, PROP_NO_RANGE },
      PROP_NO_PROP }
  },
  /* harmonic balance analysis */
  { "HB", 0, PROP_ACTION, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "n", PROP_INT, { 1, PROP_NO_STR }, PROP_MIN_VAL (1) },
      PROP_NO_PROP },
    { { "f", PROP_REAL, { 1e9, PROP_NO_STR }, PROP_POS_RANGEX },
      { "iabstol", PROP_REAL, { 1e-12, PROP_NO_STR }, PROP_RNG_X01I },
      { "vabstol", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_RNG_X01I },
      { "reltol", PROP_REAL, { 1e-3, PROP_NO_STR }, PROP_RNG_X01I },
      { "MaxIter", PROP_INT, { 150, PROP_NO_STR }, { '[', 2, 10000, ']' } },
      PROP_NO_PROP }
  },
  /* subcircuit definition */
  { "Def", PROP_NODES, PROP_ACTION, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* subcircuit instance */
  { "Sub", PROP_NODES, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "Type", PROP_STR, { PROP_NO_VAL, "DEF1" }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },
  /* nodeset definition */
  { "NodeSet", 1, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_LINEAR,
    { { "U", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
      PROP_NO_PROP },
    { PROP_NO_PROP }
  },

  /* end of list */
  { NULL, 0, 0, 0, 0, { PROP_NO_PROP }, { PROP_NO_PROP } }
};

#endif /* __QUCSDEFS_H__ */
