#line 2 "scan_netlist.cpp"

#line 4 "scan_netlist.cpp"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 33
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE netlist_restart(netlist_in  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int netlist_leng;

extern FILE *netlist_in, *netlist_out;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE netlist_lex. 
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-netlist_lineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < netlist_leng; ++yyl )\
                    if ( netlist_text[yyl] == '\n' )\
                        --netlist_lineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up netlist_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up netlist_text again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via netlist_restart()), so that the user can continue scanning by
	 * just pointing netlist_in at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when netlist_text is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int netlist_leng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow netlist_wrap()'s to do buffer switches
 * instead of setting up a fresh netlist_in.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void netlist_restart (FILE *input_file  );
void netlist__switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE netlist__create_buffer (FILE *file,int size  );
void netlist__delete_buffer (YY_BUFFER_STATE b  );
void netlist__flush_buffer (YY_BUFFER_STATE b  );
void netlist_push_buffer_state (YY_BUFFER_STATE new_buffer  );
void netlist_pop_buffer_state (void );

static void netlist_ensure_buffer_stack (void );
static void netlist__load_buffer_state (void );
static void netlist__init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER netlist__flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE netlist__scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE netlist__scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE netlist__scan_bytes (yyconst char *bytes,int len  );

void *netlist_alloc (yy_size_t  );
void *netlist_realloc (void *,yy_size_t  );
void netlist_free (void *  );

#define yy_new_buffer netlist__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        netlist_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            netlist__create_buffer(netlist_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        netlist_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            netlist__create_buffer(netlist_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define netlist_wrap() 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *netlist_in = (FILE *) 0, *netlist_out = (FILE *) 0;

typedef int yy_state_type;

extern int netlist_lineno;

int netlist_lineno = 1;

extern char *netlist_text;
#define yytext_ptr netlist_text

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up netlist_text.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	netlist_leng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 45
#define YY_END_OF_BUFFER 46
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[198] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,   46,   21,
       18,   17,   21,   20,   19,   21,   14,    7,   15,   13,
       16,    1,    5,    5,    1,    1,    5,   11,   21,   12,
        5,    5,    1,   21,   22,   23,   22,   27,   26,   25,
       27,   24,   27,   27,    7,   13,    1,    5,    1,    1,
        5,   11,   12,    5,    5,    1,   27,   44,   18,   43,
       44,   37,   28,   44,   44,   44,   38,   35,   44,   36,
       40,   44,   39,   44,   17,    0,    7,    8,    0,    7,
        0,    0,    0,    9,    0,    0,    5,    0,    5,    1,
        1,    5,    1,    5,   18,    0,    1,    0,    5,    0,

       23,   25,    0,    5,    1,    1,    5,    1,    5,    1,
        0,    5,   43,   31,   33,    0,   42,   38,    0,   38,
        0,   30,   32,   29,    0,   40,    0,   39,   34,    0,
        8,    0,    0,    0,    7,    0,    9,    5,   10,    2,
        5,    1,    5,    5,    6,    5,    5,    1,    5,    5,
        0,   41,    0,    0,   38,   40,   39,   40,    8,    0,
        0,    7,    0,    9,    0,    5,    0,    5,    5,    5,
        0,   38,   40,    0,   39,    0,    8,    0,    3,    0,
        0,    9,    0,    5,    5,    0,   39,   39,    8,    0,
        0,    0,    9,   39,    0,    4,    0

    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    6,    7,    8,    1,    9,   10,   11,    9,
        9,    9,   12,    9,   12,   13,    9,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   15,   16,   17,
       18,   19,    9,    1,   20,   21,   22,   23,   24,   25,
       26,   27,   22,   22,   28,   22,   29,   22,   30,   22,
       22,   22,   31,   32,   22,   33,   34,   22,   22,   22,
       35,   36,   37,    9,   22,    1,   38,   22,   22,   39,

       40,   41,   22,   42,   43,   43,   44,   22,   45,   46,
       22,   47,   48,   22,   49,   22,   50,   22,   22,   22,
       22,   51,   52,   53,   54,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[55] =
    {   0,
        1,    2,    3,    3,    4,    1,    1,    1,    1,    1,
        1,    1,    5,    6,    1,    1,    1,    7,    1,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    1,    1,    1,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    1,    1,    8
    } ;

static yyconst flex_int16_t yy_base[209] =
    {   0,
        0,    0,   52,   54,   58,    0,  112,    0,  583,  593,
      593,  593,  569,  593,  593,  154,  167,  161,  593,  593,
      593,  174,  175,  181,  228,  193,  200,  593,  167,  593,
      207,  221,    0,    0,  593,  593,  562,  593,  593,  593,
      553,  593,  194,  541,  251,  593,  536,  525,  282,  165,
      190,  593,  593,  201,  236,    0,    0,  593,  593,  593,
      534,  518,  593,  525,  522,  518,  256,  513,  512,  511,
      266,  248,  285,  475,  593,  513,  305,  253,  222,  309,
      485,  481,  170,  268,  283,    0,  287,    0,  323,  333,
      337,  352,  354,  358,  593,  519,  476,  505,  372,  461,

      593,  593,    0,  500,  498,  187,  218,  496,  176,  459,
      466,  365,  593,  593,  593,  466,  593,  290,  461,  367,
      203,  593,  593,  593,    0,  382,  459,  396,  593,  457,
      402,  260,  427,  450,  294,  448,  404,  406,  593,  420,
      427,    0,  441,  436,  593,  421,  241,    0,  417,  439,
      416,  593,  264,  407,  392,  456,  465,  472,  359,  308,
      383,  350,  338,  399,  312,  423,  378,  474,  478,  480,
      368,  361,  483,  354,  486,  320,  347,  501,  342,  390,
      344,  297,  283,  442,  488,  279,  494,  269,  243,  515,
      201,  229,  226,  222,  180,  593,  593,  539,  546,  553,

      556,  562,  569,  204,  576,  190,  584,  185
    } ;

static yyconst flex_int16_t yy_def[209] =
    {   0,
      197,    1,  198,  198,  197,    5,  197,    7,  197,  197,
      197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
      197,  199,  199,  199,  199,  199,  199,  197,  197,  197,
      199,  199,   25,  200,  197,  197,  197,  197,  197,  197,
      197,  197,  197,  197,  197,  197,  201,  201,  201,  201,
      201,  197,  197,  201,  201,   49,  200,  197,  197,  197,
      197,  197,  197,  197,  202,  197,  197,  197,  197,  197,
      203,  197,  203,  197,  197,  197,  197,  197,  197,  197,
      197,  197,  197,  197,  197,  204,  199,  205,  199,  199,
      199,  199,  199,  199,  197,  197,   25,  204,  199,  200,

      197,  197,  206,  201,  201,  201,  201,  201,  201,   49,
      206,  201,  197,  197,  197,  207,  197,  197,  197,  197,
      197,  197,  197,  197,  208,  203,  208,  203,  197,  197,
      197,  197,  197,  197,  197,  197,  197,  204,  197,  199,
      199,   25,  204,   99,  197,  206,  201,   49,  206,  201,
      207,  197,  197,  197,  197,  208,  208,  128,  197,  197,
      197,  197,  197,  197,  197,  143,  197,   99,  206,  201,
      197,  197,  157,  197,  128,  197,  197,  197,  197,  197,
      197,  197,  197,  143,  206,  197,  157,  197,  197,  197,
      197,  197,  197,  197,  197,  197,    0,  197,  197,  197,

      197,  197,  197,  197,  197,  197,  197,  197
    } ;

static yyconst flex_int16_t yy_nxt[648] =
    {   0,
       10,   11,   12,   13,   11,   10,   14,   15,   10,   10,
       10,   16,   17,   18,   19,   20,   10,   21,   10,   22,
       23,   23,   23,   24,   22,   25,   26,   22,   25,   27,
       22,   25,   22,   22,   28,   29,   30,   25,   31,   23,
       25,   23,   32,   25,   33,   25,   25,   23,   22,   25,
       23,   34,   10,   10,   36,   37,   36,   37,   38,   39,
       40,   41,   39,   38,   42,   38,   38,   38,   38,   43,
       44,   45,   38,   46,   38,   38,   38,   47,   48,   48,
       48,   48,   47,   49,   50,   47,   49,   51,   47,   49,
       47,   47,   52,   38,   53,   49,   54,   48,   49,   48,

       55,   49,   56,   49,   49,   48,   47,   49,   48,   57,
       38,   38,   58,   59,   60,   61,   59,   62,   63,   58,
       63,   64,   65,   63,   66,   67,   63,   58,   68,   69,
       70,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   63,   72,   63,   71,
       71,   71,   71,   71,   73,   71,   71,   71,   71,   71,
       71,   71,   71,   58,   74,   58,   76,   77,   79,   95,
       96,   79,   82,   76,   77,   85,   85,  103,   85,   85,
       80,  134,   85,  135,   83,   85,   86,   86,  103,   81,
      156,   88,   88,   86,   85,  146,   78,   85,   88,  103,

       83,   85,  103,   84,   85,   86,   76,   77,   85,  138,
       88,   85,   86,  103,  154,  108,  155,   88,  196,   86,
      108,  110,   85,   79,   88,   85,   79,   97,   89,   85,
      103,  109,   85,   98,   99,  194,   78,  105,   88,  193,
       86,   94,  193,   93,   81,   88,  195,   90,  111,  112,
       95,   96,   90,  103,   91,   90,  189,   92,   90,  147,
       90,   90,   82,   76,   77,  130,  131,   85,  119,  120,
       85,  161,   90,  162,   83,  171,   90,  172,  125,  121,
      136,  137,  188,   88,   85,  105,   85,   85,   85,   85,
       83,   85,  194,   84,  103,  121,  189,  127,  128,   86,

       88,  105,   88,  118,   88,   82,  105,  135,  106,  105,
      182,  107,  105,  153,  105,  105,   82,   76,   77,  167,
       82,  177,   80,  181,   85,  182,  105,   85,   83,  153,
      105,  183,  132,  189,   85,   86,   84,   85,   85,  178,
       88,   85,  178,  190,   83,   86,  190,   84,  132,   86,
       88,   84,  179,   85,   88,   85,   85,  182,   85,   85,
      177,   82,   85,  162,   86,  191,   86,  188,  140,   88,
       86,   88,  159,   85,  172,   88,   85,  111,  112,  119,
      120,  172,  176,   85,   98,   99,   85,   90,  150,   88,
      121,  177,   84,  141,  125,  144,  162,   85,  176,   88,

       85,  192,   93,  193,  150,  155,  121,   85,  127,  128,
       85,  144,  164,   88,  130,  131,  136,  137,   86,  158,
      155,   85,  180,   88,   85,  160,  117,  165,   85,  103,
      149,   85,   86,  103,  183,  158,  184,   88,  180,   86,
      169,  160,   85,  165,   88,   85,  138,  167,   86,  168,
      167,  103,  170,   86,  143,  184,  169,   85,   88,   87,
       85,  164,  138,  135,  166,  138,   85,  163,  125,   85,
      159,   90,  157,   88,  118,   87,  152,  125,  157,  149,
      166,  138,   88,  174,  125,  175,   86,  168,  173,  183,
      103,  185,  103,  170,  186,  126,  187,   87,  125,  175,

      103,  185,  178,  148,  173,  178,  156,  187,  103,  126,
      103,  126,  103,   87,  145,  179,  190,  156,  143,  190,
      142,   95,  156,   84,  133,  126,   80,  129,  124,  123,
      122,  118,  117,  156,  115,  114,  113,  103,  191,   35,
       35,   35,   35,   35,   35,   35,   35,   87,  103,   87,
       87,   87,   87,  100,   80,  102,  100,  100,  100,  100,
      104,  104,  116,  116,  101,  116,  116,  116,  116,  116,
      126,   75,  126,  126,  126,  126,  139,  139,  139,  139,
      139,  139,  197,  139,  151,  151,  197,  151,  151,  151,
      151,  151,    9,  197,  197,  197,  197,  197,  197,  197,

      197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
      197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
      197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
      197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
      197,  197,  197,  197,  197,  197,  197
    } ;

static yyconst flex_int16_t yy_chk[648] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    3,    3,    4,    4,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,

        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,   16,   16,   17,   29,
       29,   17,   18,   18,   18,   22,   23,   50,   22,   23,
       17,   83,   24,   83,   18,   24,   22,   23,  109,   17,
      208,   22,   23,   24,   26,  206,   16,   26,   24,  106,

       18,   27,   51,   18,   27,   26,   43,   43,   31,  204,
       26,   31,   27,   54,  121,   50,  121,   27,  195,   31,
      109,   54,   32,   79,   31,   32,   79,   31,   24,   25,
      107,   51,   25,   32,   32,  194,   43,  106,   32,  193,
       25,   27,  192,   26,   79,   25,  191,   25,   55,   55,
       72,   72,   25,  147,   25,   25,  189,   25,   25,  107,
       25,   25,   45,   45,   45,   78,   78,   71,   67,   67,
       71,  132,   25,  132,   45,  153,   25,  153,   71,   67,
       84,   84,  188,   71,   85,  147,   73,   85,   87,   73,
       45,   87,  186,   45,   49,   67,  183,   73,   73,   87,

       85,   49,   73,  118,   87,  135,   49,  135,   49,   49,
      182,   49,   49,  118,   49,   49,   77,   77,   77,  160,
       80,  160,   80,  165,   89,  165,   49,   89,   77,  118,
       49,  176,   80,  176,   90,   89,  135,   90,   91,  163,
       89,   91,  163,  179,   77,   90,  179,   77,   80,   91,
       90,   80,  163,   92,   91,   93,   92,  181,   93,   94,
      177,  162,   94,  162,   92,  179,   93,  174,   89,   92,
       94,   93,  159,   99,  172,   94,   99,  112,  112,  120,
      120,  171,  159,  126,   99,   99,  126,   91,  112,   99,
      120,  167,  162,   92,  126,   99,  161,  128,  159,  126,

      128,  180,   94,  180,  112,  155,  120,  138,  128,  128,
      138,   99,  164,  128,  131,  131,  137,  137,  138,  128,
      154,  140,  164,  138,  140,  131,  151,  137,  141,  149,
      149,  141,  140,  146,  166,  128,  166,  140,  164,  141,
      149,  131,  143,  137,  141,  143,  166,  144,  144,  144,
      150,  150,  150,  143,  143,  184,  149,  156,  143,  144,
      156,  136,  166,  134,  143,  184,  157,  133,  156,  157,
      130,  141,  127,  156,  119,  144,  116,  157,  157,  111,
      143,  184,  157,  158,  158,  158,  168,  168,  157,  169,
      169,  169,  170,  170,  173,  158,  173,  168,  175,  175,

      185,  185,  178,  110,  157,  178,  173,  187,  108,  175,
      105,  158,  104,  168,  100,  178,  190,  187,   98,  190,
       97,   96,  173,   82,   81,  175,   76,   74,   70,   69,
       68,   66,   65,  187,   64,   62,   61,   48,  190,  198,
      198,  198,  198,  198,  198,  198,  198,  199,   47,  199,
      199,  199,  199,  200,   44,   41,  200,  200,  200,  200,
      201,  201,  202,  202,   37,  202,  202,  202,  202,  202,
      203,   13,  203,  203,  203,  203,  205,  205,  205,  205,
      205,  205,    9,  205,  207,  207,    0,  207,  207,  207,
      207,  207,  197,  197,  197,  197,  197,  197,  197,  197,

      197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
      197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
      197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
      197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
      197,  197,  197,  197,  197,  197,  197
    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[46] =
    {   0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 
    0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 1, 0, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int netlist__flex_debug;
int netlist__flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *netlist_text;
#line 1 "scan_netlist.l"
/* -*-c-*- */
#line 4 "scan_netlist.l"
/*
 * scan_netlist.l - scanner for the Qucs netlist
 *
 * Copyright (C) 2003, 2004, 2005, 2006, 2007 Stefan Jahn <stefan@lkcc.org>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this package; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.  
 *
 * $Id: scan_netlist.l,v 1.21 2007/04/27 16:01:27 ela Exp $
 *
 */

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef __MINGW32__
#include <io.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "logging.h"
#include "equation.h"
#include "check_netlist.h"
#include "tokens_netlist.h"

#if !HAVE_STRCHR
# define strchr  index
# define strrchr rindex
#endif


#line 741 "scan_netlist.cpp"

#define INITIAL 0
#define COMMENT 1
#define STR 2
#define EQN 3

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int netlist_wrap (void );
#else
extern int netlist_wrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( netlist_text, netlist_leng, 1, netlist_out )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( netlist_in )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( netlist_in ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, netlist_in))==0 && ferror(netlist_in)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(netlist_in); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int netlist_lex (void);

#define YY_DECL int netlist_lex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after netlist_text and netlist_leng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 94 "scan_netlist.l"


#line 890 "scan_netlist.cpp"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! netlist_in )
			netlist_in = stdin;

		if ( ! netlist_out )
			netlist_out = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			netlist_ensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				netlist__create_buffer(netlist_in,YY_BUF_SIZE );
		}

		netlist__load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of netlist_text. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 198 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 593 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < netlist_leng; ++yyl )
				if ( netlist_text[yyl] == '\n' )
					   
    netlist_lineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 96 "scan_netlist.l"
{ /* identify scale and/or unit */
    netlist_lval.str = strdup (netlist_text);
    return ScaleOrUnit;
  }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 100 "scan_netlist.l"
{ /* special equation case */
    BEGIN(EQN);
    return Eqn;
  }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 104 "scan_netlist.l"
{
    /* subcircuit definition begins */
    return DefSub;
  }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 108 "scan_netlist.l"
{
    /* subcircuit definition ends */
    return EndSub;
  }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 112 "scan_netlist.l"
{ /* identify identifier */
    netlist_lval.ident = strdup (netlist_text);
    return Identifier;
  }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 116 "scan_netlist.l"
{ /* identify file reference */
    char * p = strrchr (netlist_text, '}'); *p = '\0';
    netlist_lval.ident = strdup (&netlist_text[1]);
    return Identifier;
  }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 121 "scan_netlist.l"
{ /* identify (signed) real float */
    netlist_lval.d = strtod (netlist_text, NULL);
    return REAL;
  }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 125 "scan_netlist.l"
{ /* identify (signed) imaginary float */
    if (netlist_text[0] == 'i' || netlist_text[0] == 'j')
      netlist_text[0] = (netlist_text[1] == '\0') ? '1' : '0';
    else
      netlist_text[1] = '0';
    netlist_lval.d = strtod (netlist_text, NULL);
    return IMAG;
  }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 133 "scan_netlist.l"
{ /* identify complete (signed) complex number */
    int i = 0;
    while (netlist_text[i] != 'i' && netlist_text[i] != 'j') i++;
    netlist_text[i] = netlist_text[i - 1];
    netlist_text[i - 1] = '\0';
    netlist_lval.c.r = strtod (netlist_text, NULL);
    netlist_lval.c.i = strtod (&netlist_text[i], NULL);
    return COMPLEX;
  }
	YY_BREAK
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 142 "scan_netlist.l"
{  /* identify 'identifier =' assign */
    int len = netlist_leng - 3;
    while (isspace (netlist_text[len])) len--;
    netlist_lval.ident = (char *) calloc (len + 2, 1);
    memcpy (netlist_lval.ident, netlist_text, len + 1);
    yyless (netlist_leng - 1); /* push back last character */
    return Assign; 
  }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 151 "scan_netlist.l"
{ /* special token for the value list */ return '['; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 152 "scan_netlist.l"
{ /* special token for the value list */ return ']'; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 153 "scan_netlist.l"
{ /* special token for the value list */ return ';'; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 155 "scan_netlist.l"
{ /* pass the '.' to the parser */ return '.'; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 156 "scan_netlist.l"
{ /* pass the ':' to the parser */ return ':'; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 157 "scan_netlist.l"
{ /* pass the '=' to the parser */ return '='; }
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 158 "scan_netlist.l"
{ /* detect end of line */ return Eol; }
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 160 "scan_netlist.l"
/* skip spaces and the trailing '\' */
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 162 "scan_netlist.l"
{ /* leave these characters */
    BEGIN(COMMENT);
  }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 165 "scan_netlist.l"
{ /* string constant starts here */
    BEGIN(STR);  
    return '"';
  }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 169 "scan_netlist.l"
{ /* any other character in invalid */
    logprint (LOG_ERROR, 
	      "line %d: syntax error, unrecognized character: `%s'\n", 
	      netlist_lineno, netlist_text);
    return InvalidCharacter;
  }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 176 "scan_netlist.l"
{ /* skip any character in here */ }
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 177 "scan_netlist.l"
{ BEGIN(INITIAL); /* skipping ends here */ }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 179 "scan_netlist.l"
{ /* string constant ends here */
    BEGIN(INITIAL); 
    return '"';
  }
	YY_BREAK
case 25:
/* rule 25 can match eol */
YY_RULE_SETUP
#line 183 "scan_netlist.l"
{ /* string in a single line only */
    logprint (LOG_ERROR, 
	      "line %d: syntax error, unterminated string constant\n",
	      netlist_lineno);
    return Eol;
  }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 189 "scan_netlist.l"
/* skip spaces */
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 191 "scan_netlist.l"
{ /* any other character is invalid */
    logprint (LOG_ERROR, 
	      "line %d: syntax error, unrecognized character: `%s'\n", 
	      netlist_lineno, netlist_text);
    return InvalidCharacter;
  }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 198 "scan_netlist.l"
{ /* return operators unchanged */
    return netlist_text[0];
  }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 202 "scan_netlist.l"
{ return GreaterOrEqual; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 203 "scan_netlist.l"
{ return LessOrEqual; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 204 "scan_netlist.l"
{ return NotEqual; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 205 "scan_netlist.l"
{ return Equal; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 206 "scan_netlist.l"
{ return And; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 207 "scan_netlist.l"
{ return Or; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 208 "scan_netlist.l"
{ return Less; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 209 "scan_netlist.l"
{ return Greater; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 210 "scan_netlist.l"
{ return Not; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 212 "scan_netlist.l"
{ /* identify unsigned real float */
    netlist_lval.d = strtod (netlist_text, NULL);
    return REAL;
  }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 216 "scan_netlist.l"
{ /* identify unsigned imaginary float */
    if (netlist_text[0] == 'i' || netlist_text[0] == 'j')
      netlist_text[0] = (netlist_text[1] == '\0') ? '1' : '0';
    else
      netlist_text[1] = '0';
    netlist_lval.d = strtod (netlist_text, NULL);
    return IMAG;
  }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 224 "scan_netlist.l"
{ /* identify identifier */
    netlist_lval.ident = strdup (netlist_text);
    return Identifier;
  }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 228 "scan_netlist.l"
{
    netlist_lval.chr = netlist_text[1];
    return Character;
  }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 232 "scan_netlist.l"
{
    netlist_lval.str = strdup (&netlist_text[1]);
    netlist_lval.str[strlen (netlist_lval.str) - 1] = '\0';
    return STRING;
  }
	YY_BREAK
case 43:
/* rule 43 can match eol */
YY_RULE_SETUP
#line 237 "scan_netlist.l"
{ /* detect end of line */ BEGIN(INITIAL); return Eol; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 239 "scan_netlist.l"
{ /* any other character in invalid */
    logprint (LOG_ERROR, 
	      "line %d: syntax error, unrecognized character: `%s'\n", 
	      netlist_lineno, netlist_text);
    return InvalidCharacter;
  }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 246 "scan_netlist.l"
ECHO;
	YY_BREAK
#line 1308 "scan_netlist.cpp"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMENT):
case YY_STATE_EOF(STR):
case YY_STATE_EOF(EQN):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed netlist_in at a new source and called
			 * netlist_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = netlist_in;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( netlist_wrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * netlist_text, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of netlist_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					netlist_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			netlist_restart(netlist_in  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 198 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 198 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 197);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					netlist_restart(netlist_in );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( netlist_wrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve netlist_text */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		   
    netlist_lineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void netlist_restart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        netlist_ensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            netlist__create_buffer(netlist_in,YY_BUF_SIZE );
	}

	netlist__init_buffer(YY_CURRENT_BUFFER,input_file );
	netlist__load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void netlist__switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		netlist_pop_buffer_state();
	 *		netlist_push_buffer_state(new_buffer);
     */
	netlist_ensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	netlist__load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (netlist_wrap()) processing, but the only time this flag
	 * is looked at is after netlist_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void netlist__load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	netlist_in = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE netlist__create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) netlist_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in netlist__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) netlist_alloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in netlist__create_buffer()" );

	b->yy_is_our_buffer = 1;

	netlist__init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with netlist__create_buffer()
 * 
 */
    void netlist__delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		netlist_free((void *) b->yy_ch_buf  );

	netlist_free((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a netlist_restart() or at EOF.
 */
    static void netlist__init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	netlist__flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then netlist__init_buffer was _probably_
     * called from netlist_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void netlist__flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		netlist__load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void netlist_push_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	netlist_ensure_buffer_stack();

	/* This block is copied from netlist__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from netlist__switch_to_buffer. */
	netlist__load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void netlist_pop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	netlist__delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		netlist__load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void netlist_ensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)netlist_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)netlist_realloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE netlist__scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) netlist_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in netlist__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	netlist__switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to netlist_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       netlist__scan_bytes() instead.
 */
YY_BUFFER_STATE netlist__scan_string (yyconst char * yystr )
{
    
	return netlist__scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to netlist_lex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE netlist__scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) netlist_alloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in netlist__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = netlist__scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in netlist__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up netlist_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		netlist_text[netlist_leng] = (yy_hold_char); \
		(yy_c_buf_p) = netlist_text + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		netlist_leng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int netlist_get_lineno  (void)
{
        
    return netlist_lineno;
}

/** Get the input stream.
 * 
 */
FILE *netlist_get_in  (void)
{
        return netlist_in;
}

/** Get the output stream.
 * 
 */
FILE *netlist_get_out  (void)
{
        return netlist_out;
}

/** Get the length of the current token.
 * 
 */
int netlist_get_leng  (void)
{
        return netlist_leng;
}

/** Get the current token.
 * 
 */

char *netlist_get_text  (void)
{
        return netlist_text;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void netlist_set_lineno (int  line_number )
{
    
    netlist_lineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see netlist__switch_to_buffer
 */
void netlist_set_in (FILE *  in_str )
{
        netlist_in = in_str ;
}

void netlist_set_out (FILE *  out_str )
{
        netlist_out = out_str ;
}

int netlist_get_debug  (void)
{
        return netlist__flex_debug;
}

void netlist_set_debug (int  bdebug )
{
        netlist__flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from netlist_lex_destroy(), so don't allocate here.
     */

    /* We do not touch netlist_lineno unless the option is enabled. */
    netlist_lineno =  1;
    
    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    netlist_in = stdin;
    netlist_out = stdout;
#else
    netlist_in = (FILE *) 0;
    netlist_out = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * netlist_lex_init()
     */
    return 0;
}

/* netlist_lex_destroy is for both reentrant and non-reentrant scanners. */
int netlist_lex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		netlist__delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		netlist_pop_buffer_state();
	}

	/* Destroy the stack itself. */
	netlist_free((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * netlist_lex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *netlist_alloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *netlist_realloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void netlist_free (void * ptr )
{
	free( (char *) ptr );	/* see netlist_realloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 246 "scan_netlist.l"



