/*
    chatWindow

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#include "chatwindow.h"

chatWindow::chatWindow(QWidget *parent)
    : QWidget(parent)
{
	online = false;
	showNames = false;
	timestamp = 1;
	typingChanged = false;
	textChanged = false;
	contactAvatarPath.clear();
	ui.setupUi(this);
	connect(ui.messageEdit, SIGNAL(sendMessage()), ui.sendButton, SLOT(click()));
	connect(ui.messageEdit, SIGNAL(focusWindow()), this, SLOT(tst()));
	connect(ui.messageChat, SIGNAL(focusWindow()), this, SLOT(tst()));
	connect(ui.messageEdit, SIGNAL(closeWindow()), this, SLOT(close()));
	setFocus(Qt::ActiveWindowFocusReason);
//	ui.messageChat->setFocusProxy(this);
//	ui.messageEdit->setFocusProxy(this);
	ui.sendButton->setFocusProxy(this);
	setMinimumWidth(250);
//	resize(600,600);
//	installEventFilter(this);
	emoticMenu = new QMenu(ui.emoticonButton);
	emoticonAction = new QWidgetAction(emoticMenu);
	emoticonWidget = new emoticonMenu(emoticMenu);
	emoticonAction->setDefaultWidget(emoticonWidget);
	emoticMenu->addAction(emoticonAction);
	ui.emoticonButton->setMenu(emoticMenu);
	connect(emoticonWidget, SIGNAL(insertSmile(const QString &)), this,
			SLOT(insertSmile(const QString &)));
	
}

chatWindow::~chatWindow()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+uin, "account");
	settings.setValue("chatwindow/state", ui.splitter->saveState());
	delete emoticonWidget;
	delete emoticMenu;
}

void chatWindow::setMessage(const QString &from, const QString &message, const QDateTime &date, bool in)
{
	
	ui.messageChat->moveCursor(QTextCursor::End);

	QString fromText;
	fromText.append("<table width = '100%' border='0' cellspacing='0' cellpadding='0'><tbody><tr><td style='background-image : url(front.png);'><font color='grey' size='3'>");
	QString color;
	if ( in )
		color = "red";
	else
		color = "blue";
	if ( showNames )
		fromText.append(from);
	
	fromText.append("</font></td><td align='right' style='background-image : url(front.png);'><font color='grey'>");
	if ( date.isNull() )
	{
		fromText.append(generateTime());
	}
	else
	{
		QString dateString;
		switch(timestamp)
			{
			case 0:
				dateString =  QString(date.toString("hh:mm:ss dd/MM/yyyy"));
				break;
			case 1:
				dateString =  QString(date.toString("hh:mm:ss"));
				break;
			case 2:
				dateString =  QString(date.toString("hh:mm ddd/MMM/yyyy"));
				break;
				
			default:
				dateString =  QString( date.toString("hh:mm:ss") );
			}
		fromText.append(dateString);
	}
	
	fromText.append("</font></td></tr></tbody></table>");
	
	if (  in )
	{
	if ( !contactAvatarPath.isEmpty())
	{
		fromText.append("<img align='left' src='"+ contactAvatarPath +"' hspace='10'>");
	}
	else
		fromText.append("<br>");
	} else {
		
		if ( !ownerAvatarPath.isEmpty())
		{
			fromText.append("<img align='right' src='"+ ownerAvatarPath +"' hspace='10'>");
		}
		else
			fromText.append("<br>");
	}
	
//	fromText.append("<font color='#525252' >" + Qt::escape(message) + "</div></font>");
	
//	ui.messageChat->append(fromText);
	
//	ui.messageChat->insertPlainText("\n" + message);
//	ui.messageChat->append("<font color='black' size='3'>" + Qt::escape(message) + "</font>");
	
//	int vPos = ui.messageChat->verticalScrollBar()->value();
	ui.messageChat->append(fromText);
	
	if ( message.startsWith("<qimage>") && message.endsWith("</qimage>"))
	{
		ui.messageChat->insertImage(message);
	}
	else
		ui.messageChat->append("<font color='#525252' >" + checkForEmoticons(Qt::escape(message)) + "</font><br clear=all>");
	typingIcon(false);
	ui.messageChat->setLineWrapColumnOrWidth(ui.messageChat->lineWrapColumnOrWidth());
//	ui.messageChat->moveCursor(QTextCursor::End);
//	ui.messageChat->ensureCursorVisible();
	ui.messageChat->verticalScrollBar()->setValue( ui.messageChat->verticalScrollBar()->maximum() );
	
}

void chatWindow::on_messageEdit_textChanged()
{
	
	ui.countLabel->setText(QString::number(ui.messageEdit->toPlainText().size()));
	textChanged = true;
	if ( sendTyping )
	{
		if ( ! typingChanged )
		{
			typingChanged = true;
			
			emit sendTypingNotification(chatWith, 0x0002);
			QTimer::singleShot(5000, this, SLOT(typingNow()));
		}
		
		
		if ( ui.messageEdit->toPlainText().isEmpty() )
		{
			typingChanged = false;
			emit sendTypingNotification(chatWith, 0x0000);
		}
	}
	
	if ( online && !ui.messageEdit->toPlainText().isEmpty() )
		ui.sendButton->setEnabled(true);
	else 
		ui.sendButton->setEnabled(false);
	
}

void chatWindow::on_sendButton_clicked()
{
	ui.messageChat->moveCursor(QTextCursor::End);
	
	QString from;
	
	from.append("<table width = '100%' border='0' cellspacing='0' cellpadding='0'><tbody><tr><td style='background-image : url(front.png);'><font color='grey' size='3'>");
	if ( showNames )
//		from.append("<font color='blue'>" + accountNickName +": </font>" );
		from.append(accountNickName);
//	from.append("<font color='blue'>" + generateTime() +"</font>");
	from.append("</font></td><td align='right' style='background-image : url(front.png);'><font color='grey'>");
	from.append(generateTime());
	from.append("</font></td></tr></tbody></table>");
	
	if ( !ownerAvatarPath.isEmpty())
	{
		from.append("<img align='right' src='"+ ownerAvatarPath +"' hspace='10'>");
	}
	else
		from.append("<br>");
	
	
	
	
	ui.messageChat->append(from);
//	ui.messageChat->insertPlainText("\n" + ui.messageEdit->toPlainText());
	ui.messageChat->append("<font color='#525252' size='3'>" + checkForEmoticons(Qt::escape(ui.messageEdit->toPlainText())) + "</font>");
	messageFormat msg;
	msg.fromUin = chatWith;
	msg.message = ui.messageEdit->toPlainText();
	ui.messageChat->moveCursor(QTextCursor::End);
	ui.messageChat->ensureCursorVisible();
	ui.messageChat->setLineWrapColumnOrWidth(ui.messageChat->lineWrapColumnOrWidth());
	ui.messageChat->verticalScrollBar()->setValue( ui.messageChat->verticalScrollBar()->maximum() );
	emit sendMessage(msg);
	ui.messageEdit->clear();
	if ( closeOnSend )
		close();
	if ( sendTyping )
	{
		typingChanged = false;
		emit sendTypingNotification(chatWith, 0x0000);
	}
	
	ui.sendButton->setEnabled(false);
	
}

void chatWindow::setOnline(bool o)
{
	online = o;
	
	if (o)
		ui.imageButton->setEnabled(true);
	else
		ui.imageButton->setEnabled(false);
	
	if (online && !ui.messageEdit->toPlainText().isEmpty() )
		ui.sendButton->setEnabled(true);
	else
		ui.sendButton->setEnabled(false);
}

QString chatWindow::generateTime()
{
	QDateTime today = QDateTime::currentDateTime();
	switch(timestamp)
	{
	case 0:
		return QString(today.toString("hh:mm:ss dd/MM/yyyy"));
		break;
	case 1:
		return QString(today.toString("hh:mm:ss"));
		break;
	case 2:
		return QString(today.toString("hh:mm ddd/MMM/yyyy") );
		break;
		
	default:
		return QString(today.toString("hh:mm:ss"));
	}
}

void chatWindow::setOnEnter(bool f)
{
	sendOnEnter = f;
	if ( sendOnEnter )
	{
		ui.sendButton->setShortcut(QKeySequence(Qt::Key_Return));
		ui.messageEdit->onEnter = true;
	} else {
		ui.sendButton->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Return));
		ui.messageEdit->onEnter = false;
	}
}

void chatWindow::focusEditMessage()
{
	ui.messageEdit->setFocus();
}

void chatWindow::focusInEvent(QFocusEvent *e)
{
	
	emit windowFocused(chatWith);
	QWidget::focusInEvent(e);
}

void chatWindow::typingNow()
{
	if ( sendTyping )
	{
		if ( textChanged )
		{
			textChanged = false;
			emit sendTypingNotification(chatWith, 0x0001);
			QTimer::singleShot(5000, this, SLOT(typingNow()));
		} else {
			typingChanged = false;
			emit sendTypingNotification(chatWith, 0x0000);
		}
	}
}

void chatWindow::restoreState()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+uin, "account");
	ui.splitter->restoreState(settings.value("chatwindow/state").toByteArray());
}

void chatWindow::typingIcon(bool f)
{
	if ( f )
	{
		ui.typingLabel->setText("<img src=':/icons/crystal_project/typing.png'>");
	} else
		ui.typingLabel->clear();
}

void chatWindow::on_historyButton_clicked()
{
	emit showHistory(chatWith);
}

void chatWindow::setServiceMessage(const QString & from, const QString &msg, const QDateTime &date)
{
	ui.messageChat->moveCursor(QTextCursor::End);
	QString fromText;
//	fromText.append("<font color='grey' size = '2'>");
	fromText.append("<table width='100%'><tbody><tr><td style='background-image:url(front.png);' ><font color='grey' size='2'>");

		QString dateString;
		switch(timestamp)
			{
			case 0:
				dateString =  QString("(" + date.toString("hh:mm:ss dd/MM/yyyy") + ")" );
				break;
			case 1:
				dateString =  QString("(" + date.toString("hh:mm:ss") + ")" );
				break;
			case 2:
				dateString =  QString("(" + date.toString("hh:mm ddd/MMM/yyyy") + ")" );
				break;
				
			default:
				dateString =  QString("(" + date.toString("hh:mm:ss") + ")" );
			}
		if ( showNames )
			fromText.append(" " + from +": " );
		fromText.append(dateString);
	fromText.append(" " + msg + "</font></td></tr> </tbody></table>");
	ui.messageChat->append(fromText);
	ui.messageChat->moveCursor(QTextCursor::End);
	ui.messageChat->ensureCursorVisible();	
	ui.messageChat->setLineWrapColumnOrWidth(ui.messageChat->lineWrapColumnOrWidth());
}

void chatWindow::keyPressEvent(QKeyEvent *event)
{
	if ( event->key() == Qt::Key_Escape)
		close();
}

void chatWindow::on_infoButton_clicked()
{
	emit openInfoWindow(chatWith);
}

void chatWindow::setAvatars(const QString &userAvatar)
{
	if ( QFile::exists(userAvatar) )
		contactAvatarPath = userAvatar;
	else
		contactAvatarPath.clear();
}

void chatWindow::showEvent ( QShowEvent * event )
{
	ui.messageChat->setLineWrapColumnOrWidth(ui.messageChat->lineWrapColumnOrWidth());
	ui.messageChat->verticalScrollBar()->setValue( ui.messageChat->verticalScrollBar()->maximum() );
//	ui.messageChat->moveCursor(QTextCursor::End);
//	ui.messageChat->ensureCursorVisible();
	
	QWidget::showEvent(event);
}

QString chatWindow::findUrls(const QString &sourceHTML)
{
    QString html = sourceHTML;
     QRegExp linkRegExp("((https?|ftp://|www\\.)[^\\s]+)");
     int pos = 0;
     while((pos=linkRegExp.indexIn(html, pos)) != -1)
     {
             QString link = linkRegExp.cap(0);
             link = "<a href=\"" + link + "\" target=\"_blank\">" + link + "</a>";
             html.replace(linkRegExp.cap(0), link);
             pos += link.count();
     }
     return html;
}

void chatWindow::setOwnerAvatar(const QString &userAvatar)
{
	if ( QFile::exists(userAvatar) )
		ownerAvatarPath = userAvatar;
	else
		ownerAvatarPath.clear();
}

void chatWindow::setEmoticonPath(const QString &path)
{
	emoticonList.clear();
	ui.messageChat->clearMovieList();
	QFile file(path);
	
	QString dirPath = path.section('/', 0, -2);
	QDir dir ( dirPath );
	
	QStringList fileList = dir.entryList(QDir::Files);
	
	if (file.exists() && file.open(QIODevice::ReadOnly) )
	{
		QDomDocument doc;
		if ( doc.setContent(&file) )
		{
			QDomElement rootElement = doc.documentElement();
			int emoticonCount = rootElement.childNodes().count();
			
			QDomElement emoticon = rootElement.firstChild().toElement();
			
			for ( int i = 0; i < emoticonCount ; i++ )
			{
				
				if ( emoticon.tagName() == "emoticon")
				{
					
					QStringList fileName = fileList.filter(emoticon.attribute("file"));
					if ( !fileName.isEmpty())
					{
					
						emoticonList.insert(fileName.at(0),emoticon.firstChild().toElement().text());
						
						int stringCount = emoticon.childNodes().count();
						QDomElement emoticonString = emoticon.firstChild().toElement();
						QStringList regExp;
						for(int j = 0; j < stringCount; j++)
						{
							if ( emoticonString.tagName() == "string")
							{
//								regExp.append("[" + emoticonString.text() + "]");
//								regExp.append(emoticonString.text());
								regExp<<emoticonString.text();
//								if ( j < (stringCount - 1))
//									regExp.append("|");
//								else
//									regExp.append(")");
							}
							
							emoticonString = emoticonString.nextSibling().toElement();
						}
						if ( regExp.count() )
						{
							regExpList.insert(fileName.at(0) + "-emoticon", regExp);
							urls.insert(fileName.at(0) + "-emoticon", dirPath + "/" + fileName.at(0));
						}
					}
					
				}
				emoticon = emoticon.nextSibling().toElement();
					
			}
			
		}
		emoticonWidget->setEmoticons(emoticonList, dirPath);
	}
}
void chatWindow::insertSmile(const QString &smile)
{
	ui.messageEdit->insertPlainText(smile);
}

QString chatWindow::checkForEmoticons(const QString &_source)
{
    QString source = _source;
    foreach(QStringList reg, regExpList)
    {
//    	QRegExp linkRegExp(regExp);
    	 bool wasInText = false;
    	 QString messageUrl;
    	foreach(QString regExp,reg )
    	{

		    QString tmp = source;
		    
		    if ( tmp != source.replace(regExp,"<img src='" +  regExpList.key(reg) + "'>"))
		    {
		    	wasInText = true;
		    	messageUrl = regExpList.key(reg);
		    }

    	}
	    if ( wasInText )
	    {
	    	ui.messageChat->addSmile(messageUrl, urls.value(messageUrl));
	    }
    }
    return findUrls(source.replace("\n", "<br>"));
}

void chatWindow::on_imageButton_clicked()
{
	QString fileName =   QFileDialog::getOpenFileName(this, tr("Open File"),
			 "",
	                                                 tr("Images (*.gif *.bmp *.jpg *.jpeg *.png)"));
	
	if ( !fileName.isEmpty())
		{
			QFile iconFile(fileName);

				if ( iconFile.size() > (7 * 1024 + 600))
				{
					QMessageBox::warning(this, tr("Open error"),
					                   tr("Image size is too big"));
				}
				else
				{
					emit sendImage(chatWith,fileName);
					
					if ( QFile::exists(fileName))
					{
					
					ui.messageChat->moveCursor(QTextCursor::End);
					
					QString from;
					
					from.append("<table width = '100%' border='0' cellspacing='0' cellpadding='0'><tbody><tr><td style='background-image : url(front.png);'><font color='grey' size='3'>");
					if ( showNames )
						from.append(accountNickName);
					from.append("</font></td><td align='right' style='background-image : url(front.png);'><font color='grey'>");
					from.append(generateTime());
					from.append("</font></td></tr></tbody></table>");
					
					if ( !ownerAvatarPath.isEmpty())
					{
						from.append("<img align='right' src='"+ ownerAvatarPath +"' hspace='10'>");
					}
					else
						from.append("<br>");
					
					
					
					
					ui.messageChat->append(from);
					
					QFile file(fileName);
					if (file.open(QIODevice::ReadOnly))
					{
					
					ui.messageChat->insertImage("<qimage>" + file.readAll().toHex() + "</qimage>");
					file.close();
					}
					}
					
				}
		}
}
