/*
    connection

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#include "connection.h"

connection::connection(QTcpSocket *tcpSocket, icqBuffer *buff, const QString &account, QObject *parent)
    : QObject(parent), icqUin(account), socket(tcpSocket), buffer(buff)
{
	connectedToBos = false;
}

connection::~connection()
{
	
}

void connection::connectToServer(QTcpSocket *socket)
{
	socket->setProxy(getProxy());
//	QNetworkProxy::setApplicationProxy(getProxy());
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
	
	QString host = settings.value("connection/host", "login.icq.com").toString();
	quint16 port = settings.value("connecion/port", 5190).toInt();
	connectedToBos = false;
	socket->connectToHost(host,port);
	
}

void connection::readData(const quint16 &length)
{
	if ( length < 10 )
	{
		protocolVersion = buffer->read(4);
		if ( (length -4) > 0 )
			buffer->read(length -4);
	}
	if ( !connectedToBos )
		emit sendLogin();
}


void connection::sendIdent(const QString &password)
{
	clientIdentification clientLogin;
	clientLogin.setProcolVersion(protocolVersion);
	clientLogin.setScreenName(icqUin);
	clientLogin.setClientName("ICQBasic");
	clientLogin.setPassword(password);
	clientLogin.sendPacket(socket);
}

void connection::connectToBos(const QHostAddress &bosIp, const quint16 &port, const QByteArray cookie, const quint16 &flapSeq)
{
//	socket->disconnectFromHost();
//	if (socket->state() == QAbstractSocket::UnconnectedState)
//	{
//	socket->abort();
//		socket->setProxy(QNetworkProxy::NoProxy);
	socket->setProxy(getProxy());
	connectedToBos = true;
	emit connectingToBos();
	socket->connectToHost(bosIp, port);
	quint16 length = 4;
	tlv cookieTlv;
	cookieTlv.setType(0x0006);
	cookieTlv.setData(cookie);
	length += cookieTlv.getLength();
	QByteArray packet;
	packet[0] = 0x2A;
	packet[1] = 0x01;
	packet[2] = flapSeq / 0x100;
	packet[3] = flapSeq % 0x100;
	packet[4] = length / 0x100;
	packet[5] = length % 0x100;
	packet.append(protocolVersion);
	packet.append(cookieTlv.getData());
	socket->write(packet);
//	}
}

QNetworkProxy connection::getProxy()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim/ICQ."+icqUin, "account");
	if ( settings.value("connection/useproxy", false).toBool() )
		{
			quint16 proxyType = settings.value("proxy/proxyType", 0).toInt();
			if ( proxyType )
			{
				QNetworkProxy connectionProxy;
				switch( proxyType )
				{
				case 1:
					connectionProxy.setType(QNetworkProxy::HttpProxy);
					break;
				case 2:
					connectionProxy.setType(QNetworkProxy::Socks5Proxy);
					break;
				default:
					break;
				
				}
				
				connectionProxy.setHostName(settings.value("proxy/host").toString());
				connectionProxy.setPort(settings.value("proxy/port", 1).toInt());
				if ( settings.value("proxy/auth", false).toBool() )
				{
					connectionProxy.setUser(settings.value("proxy/user").toString());
					connectionProxy.setPassword(settings.value("proxy/pass").toString());
				}
				return connectionProxy;						
			} else {
				return QNetworkProxy::NoProxy;
			}
		}
	return QNetworkProxy::NoProxy;
}
