#include "encryptionmanager.h"

EncryptionManager::EncryptionManager()
{
}

EncryptionManager::~EncryptionManager()
{
}

// TODO: think of key hiding mechanism of some sort
// idea: algorithmical encryption?

QString EncryptionManager::getDefaultKey1()
{
	return "tfx7jngt";
}

QString EncryptionManager::getDefaultKey2()
{
	return "lbce63rx";
}

void EncryptionManager::testRun()
{
	cryper = new QutDES();
	std::basic_string<char> strPlainText;
    std::basic_string<char> strCryptogram;
	
	cryper->SetDES();
	cryper->SetKey1((unsigned char*)"11111111");
	strPlainText = "A cult that has been waiting for an end to civilisation as we know "
		"it has finally left the cave they had barricaded themselves into. For almost " 
		"five months a group of 28 cult members had attempted to seal themselves off "
		"from the world by going to live in a cave and blocking the cave entrance with "
		"debris and human excrement. The cult came from somewhere in Russia that no-one "
		"really cares about and managed to find a cave that was conveniently no more "
		"that ten minutes driving from the all of the cult members' houses. The cult "
		"leader, Pyotr Kuznetsov, despite the nearing apocalypse, found many "
		"opportunities to talk to the press and averaged about 3 interviews a day (in "
		"between visits to psychiatric hospitals after an order from the local court)";
	unsigned long cbCryptogram = cryper->CalcCryptogramSize(strPlainText.size());
	strCryptogram.resize(cbCryptogram);
	cryper->SetOutputBuffer((unsigned char*)strCryptogram.data(), strCryptogram.size());
	if (cryper->Encrypt(strPlainText.c_str()))
    {
		strCryptogram.resize(cryper->GetCryptogramSize());
    }
		qDebug() << "Cryptogram: " << strCryptogram.c_str() << "\n";

	// finished encoding, let's decode

	cryper = new QutDES();

	cryper->SetDES();

	cryper->SetKey1((unsigned char*)"11111111");
	cryper->Decrypt((unsigned char*)strCryptogram.data(), strCryptogram.size());
	qDebug() << "Decryption (" << cryper->GetPlainTextSize() << ") bytes: "
		<< (char *)cryper->GetPlainText() << "\n";   
}

QString EncryptionManager::encryptDES(const QString &_text, const QString &_key)
{
	std::basic_string<char> strPlainText;
    std::basic_string<char> strCryptogram;

	// construct the key
	unsigned char *key = NULL;
	QByteArray ba = _key.toUtf8();
	key = (unsigned char*)qstrdup(ba.constData());

	// constructing string for encription
	ba = _text.toUtf8();
	strPlainText = (char*)qstrdup(ba.constData()); 

	// configuring cryper
	cryper = new QutDES();
	cryper->SetDES();
	cryper->SetCBC(false);
	cryper->SetKey1(key);
	delete [] key;

    // get the cryptogram's size
	unsigned long cbCryptogram = cryper->CalcCryptogramSize(strPlainText.size());
	
	// resize buffer and cryptogram
	strCryptogram.resize(cbCryptogram);
	cryper->SetOutputBuffer((unsigned char*)strCryptogram.data(), strCryptogram.size());

	// encrypting. if true - encrypted seccsesfully
	if (cryper->Encrypt(strPlainText.c_str()))
    {
		strCryptogram.resize(cryper->GetCryptogramSize());
    }

	QString n45;
	for(int i = 0; i < strCryptogram.size(); ++i)
	{
		n45[i] = strCryptogram[i];
	}

	return n45;
}

QString EncryptionManager::decryptDES(const QString &_cryptogram, const QString &_key)
{
	std::basic_string<char> strPlainText;
    std::basic_string<char> strCryptogram;

	// settingn single DES mode
	cryper = new QutDES();
	cryper->SetDES();
	cryper->SetCBC(false);

	// construct the key
	unsigned char *key = NULL;
	QByteArray ba = _key.toUtf8();
	key = (unsigned char*)qstrdup(ba.constData()); 
	// setting key
	cryper->SetKey1(key);
	// deleting key, we won't need it anymore
	delete [] key;

	// preparing cryptogram
	strCryptogram.resize(_cryptogram.size());
	strCryptogram = _cryptogram.toStdString();

	// decrypting
	if(cryper->Decrypt((unsigned char*)strCryptogram.data(), strCryptogram.size()))
	{
		//strPlainText.resize(cryper->GetPlainTextSize());
		strPlainText = (char *)cryper->GetPlainText();
		return QString().fromUtf8(strPlainText.c_str());
	}
	else
	{
		return "";
	}
}

QString EncryptionManager::encrypt3DES(const QString &_text, const QString &_key1, const QString &_key2)
{
	std::basic_string<char> strPlainText;
    std::basic_string<char> strCryptogram;

	// construct the key 1
	unsigned char *key1 = NULL;
	QByteArray ba = _key1.toUtf8();
	key1 = (unsigned char*)qstrdup(ba.constData());

	// construct the key 2
	unsigned char *key2 = NULL;
	ba = _key2.toUtf8();
	key2 = (unsigned char*)qstrdup(ba.constData());

	// constructing string for encription
	ba = _text.toUtf8();
	strPlainText = (char*)qstrdup(ba.constData()); 

	// configuring cryper
	cryper = new QutDES();
	cryper->SetTripleDES();
	cryper->SetCBC(false);
	cryper->SetKey1(key1);
	cryper->SetKey2(key2);
	delete [] key1;
	delete [] key2;

    // get the cryptogram's size
	unsigned long cbCryptogram = cryper->CalcCryptogramSize(strPlainText.size());
	
	// resize buffer and cryptogram
	strCryptogram.resize(cbCryptogram);
	cryper->SetOutputBuffer((unsigned char*)strCryptogram.data(), strCryptogram.size());

	// encrypting. if true - encrypted seccsesfully
	if (cryper->Encrypt(strPlainText.c_str()))
    {
		strCryptogram.resize(cryper->GetCryptogramSize());
		//strCryptogram = (char *)cryper->GetCryptogram();
    }

	QString n45;
	for(int i = 0; i < strCryptogram.size(); ++i)
	{
		n45[i] = strCryptogram[i];
	}

	return n45;
}

QString EncryptionManager::decrypt3DES(const QString &_cryptogram, const QString &_key1, const QString &_key2)
{
	std::basic_string<char> strPlainText;
    std::basic_string<char> strCryptogram;

	// construct the key 1
	unsigned char *key1 = NULL;
	QByteArray ba = _key1.toUtf8();
	key1 = (unsigned char*)qstrdup(ba.constData());

	// construct the key 2
	unsigned char *key2 = NULL;
	ba = _key2.toUtf8();
	key2 = (unsigned char*)qstrdup(ba.constData());

	// configuring cryper
	cryper = new QutDES();
	cryper->SetTripleDES();
	cryper->SetCBC(false);
	cryper->SetKey1(key1);
	cryper->SetKey2(key2);
	delete [] key1;
	delete [] key2;

	// preparing cryptogram
	strCryptogram.resize(_cryptogram.size());
	strCryptogram = _cryptogram.toStdString();

	// decrypting
	if(cryper->Decrypt((unsigned char*)strCryptogram.data(), strCryptogram.size()))
	{
		//strPlainText.resize(cryper->GetPlainTextSize());
		strPlainText = (char *)cryper->GetPlainText();
		return QString().fromUtf8(strPlainText.c_str());
	}
	else
	{
		return "";
	}
}

bool EncryptionManager::callKeysManager(QString &_key1, QString &_key2)
{
	KeysMan = new KeysManager();
	if(KeysMan->exec() == QDialog::Accepted)
	{
		_key1 = KeysMan->ui.key1Edit->text();
		_key2 = KeysMan->ui.key2Edit->text();
		//QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim", "encoding");
		//_key1 = settings.value("CurrentKeys/key1").toString();
		//_key2 = settings.value("CurrentKeys/key2").toString();
		return true;
	}
	return false;	
}

QString EncryptionManager::encrypPassword(QString _password, const bool DES)
{
	if(_password.isEmpty())
		return QString("");
	
	if(DES)
	{
		return encryptDES(_password, getDefaultKey1());
	}
	else
	{
		return encrypt3DES(_password, getDefaultKey1(), getDefaultKey2());
	}
}

QString EncryptionManager::decryptPassword(QString _cryptogram, const bool DES)
{
	if(_cryptogram.isEmpty())
		return QString("");
	
	if(DES)
	{
		return decryptDES(_cryptogram, getDefaultKey1());
	}
	else
	{
		return decrypt3DES(_cryptogram, getDefaultKey1(), getDefaultKey2());
	}
}

QString EncryptionManager::giveMeEncryptedXML(QFile *_file)
{
	// checking if fail can be opened for reading
    if (!_file->open(QIODevice::ReadOnly))
         return "";
	
	// reading all file
	QByteArray ba = _file->readAll();
	if(ba.size() == 0)
		return "";

	return "p" + encrypt3DES(ba, getDefaultKey1(), getDefaultKey2());	
}

QString EncryptionManager::giveMeDecryptedXML(const QString &_string)
{
	if(_string.isEmpty())
		return QString("");
	QString cryptogram = _string;

	if(_string.at(0) == 'p')
		return decrypt3DES(cryptogram.remove(0, 1), getDefaultKey1(), getDefaultKey2());
	else
		return decrypt3DES(_string, getDefaultKey1(), getDefaultKey2());
}

bool EncryptionManager::checkIfEncrypted(const QString &_string)
{
	if(_string.at(0) == 'p')
		return true;
	else
		return false; 
}