#include "keysmanager.h"

KeysManager::KeysManager(QWidget *parent)
	: QDialog(parent)
{
	ui.setupUi(this);
	setFixedSize(size());
	Load();
}

KeysManager::~KeysManager()
{
}


void KeysManager::on_pushButton_2_clicked()
{
	Save();
}

void KeysManager::Save()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim", "encoding");
	settings.beginGroup("KeyManager");
	settings.setValue("hide",ui.hideCheckBox->isChecked());
	settings.endGroup();
}

void KeysManager::Load()
{
	QSettings settings(QSettings::IniFormat, QSettings::UserScope, "qutim", "encoding");
	ui.hideCheckBox->setChecked(settings.value("KeyManager/hide", true).toBool());
}

void KeysManager::on_hideCheckBox_stateChanged(int)
{
	if(ui.hideCheckBox->isChecked())
	{
		ui.key1Edit->setEchoMode(QLineEdit::Password);
		ui.key2Edit->setEchoMode(QLineEdit::Password);
	}
	else
	{
		ui.key1Edit->setEchoMode(QLineEdit::Normal);
		ui.key2Edit->setEchoMode(QLineEdit::Normal);
	}
}

bool KeysManager::ValidateInputData()
{
	if(ui.key1Edit->text().length() != 8)
		return false;
	if(ui.key2Edit->text().length() != 8)
		return false;
	return true;
}

void KeysManager::on_key1Edit_textChanged(const QString &)
{
	ui.pushButton_2->setEnabled(ValidateInputData());
}

void KeysManager::on_key2Edit_textChanged(const QString &)
{
	ui.pushButton_2->setEnabled(ValidateInputData());
}