/*
    oscarProtocol

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#ifndef OSCARPROTOCOL_H
#define OSCARPROTOCOL_H

#include <QtGui/QWidget>
#include <QTcpSocket>
#include <QAbstractSocket>
#include "flap.h"
#include "connection.h"
#include "passworddialog.h"
#include "closeconnection.h"
#include "snacchannel.h"
#include "contactlist.h"
#include "buffer.h"
#include "cryper/encryptionmanager.h"

//enum accountStatus { online, ffc, away, na, occupied, dnd, invisible, offline, connecting};





class oscarProtocol : public QObject
{
    Q_OBJECT

public:
    oscarProtocol(const QString &, QTreeWidget *, QObject *parent = 0);
    ~oscarProtocol();
    void setStatus( accountStatus );
    accountStatus getStatus() { return currentStatus; }
    void removeContactList();
    void readreadMessageStack();
    contactListTree *getContactListClass() { return contactListClass; }
    void sendKeepAlive(bool);
    void updateAutoAway();
    bool userDisconnected;
    bool rateLimit;
    bool reconnectOnDisc;
    void resendCapabilities();
    void sendOnlyCapabilities();

signals:
	void statusChanged(accountStatus currentStatus);
	void systemMessage(const QString &);
	void userMessage(const QString &, const QString &, const QString &, userMessageType, bool);
	void getNewMessage();
	void readAllMessages();
	void addToEventList(bool);
   
private slots:
	void disconnected();
	void connected();
	void displayError(QAbstractSocket::SocketError);
	void readDataFromSocket();
	void clearSocket();
	void sendIdentif();
	void sendSystemMessage(const QString &m ) { emit systemMessage(m); }
	void sendUserMessage(const QString &fu, const QString &f, const QString &m, userMessageType t, bool l) { emit userMessage(fu, f , m, t, l); }
	void getBosIp(const QHostAddress &addr) { bosIp = addr; }
	void getBosPort ( const quint16 &port) { bosPort = port; }
	void incFlapSeqNum();
	void incReqSeq();
	void getAuthKey(const QByteArray &);
	void reconnectToBos(const QByteArray);
	void connectingToBos();
	void rereadSocket();
	void gettingNewMessage() { emit getNewMessage(); }
	void sendAlivePacket();
	void updateChangedStatus();
	void setAutoAway();
	void restartAutoAway(bool, quint32);
	void blockRateLimit() { rateLimit = true; }
	
private:
	bool checkPassword();
	
	accountStatus currentStatus;
	accountStatus tempStatus;
	QTcpSocket *connectionSocket;
	connection *connectClass;
	closeConnection *closeConnectionClass;
	snacChannel *snacChannelClass;
	QString icqUin;
	QString password;
	bool connectingAccount;
	QHostAddress bosIp;
	quint16 bosPort;
	quint16 flapSeqNum;
	bool md5Connection;
	QTreeWidget *contactList;
	contactListTree *contactListClass;
	bool readyToReadFlap;
	quint8 channel;
	quint16 flapLength;
	icqBuffer *buffer;
	quint16 reqSeq;
	bool keepAlive;
	QTimer *timer;
	QTimer *autoAwayTimer;
	bool connectBos;
	QByteArray cookieForBos;
	bool autoAway;
	quint32 awayMin;

};

#endif // OSCARPROTOCOL_H
