/*
    mainSettings

    Copyright (c) 2008 by Rustam Chakin <qutim.develop@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/


#ifndef MAINSETTINGS_H
#define MAINSETTINGS_H

#include <QtGui/QWidget>
#include <QSettings>
#include<QDebug>
#include "ui_mainsettings.h"

class mainSettings : public QWidget
{
    Q_OBJECT

public:
    mainSettings(QWidget *parent = 0);
    ~mainSettings();
    void loadSettings();
    void saveSettings();

private slots:
	void sizePosBoxChanged(int) { sizePosBoxChange = true; emit settingsChanged(); }
	void hideBoxChanged(int) { hideBoxChange = true; emit settingsChanged(); }
	void widgetStateChanged() { emit settingsChanged(); }
	void on_clAccountsBox_toggled(bool);
	
signals:
	void settingsChanged();
	
private:
	void resetStates();
	
	bool sizePosBoxChange;
	bool hideBoxChange;
    Ui::mainSettingsClass ui;
};

#endif // MAINSETTINGS_H
